<?php

/**
 * My Account navigation
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/navigation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 2.6.0
 */

if (!defined('ABSPATH')) {
	exit;
}

do_action('woocommerce_before_account_navigation');
?>
<div class="">
	<nav class="woocommerce-MyAccount-navigation px-5">
		<ul class="flex gap-1 md:gap-3 overflow-x-scroll md:overflow-auto">
			<?php foreach (wc_get_account_menu_items() as $endpoint => $label) : ?>
				<li class="rounded-md flex justify-center my-5 w-max px-2 cursor-pointer bg-slate-50 hover:bg-blue-600 hover:text-white hover:font-bold grow border-2 border-slate-200 hover:border-none <?php echo wc_get_account_menu_item_classes($endpoint); ?>">
					<a class="h-20 w-max flex justify-center items-center" href="<?php echo esc_url(wc_get_account_endpoint_url($endpoint)); ?>"><?php echo esc_html($label); ?></a>
				</li>
			<?php endforeach; ?>
		</ul>
	</nav>

	<?php do_action('woocommerce_after_account_navigation'); ?>
</div>