<?php
/**
 * Lost password form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-lost-password.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_lost_password_form' );
?>

<form method="post" class="woocommerce-ResetPassword lost_reset_password text-base text-black flex flex-col justify-center items-center w-full md:w-full my-11 md:my-28">

	<p class="font-normal mb-3 w-[90%] md:w-[34rem]"><?php echo apply_filters( 'woocommerce_lost_password_message', esc_html__( 'Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.', 'woocommerce' ) ); ?></p><?php // @codingStandardsIgnoreLine ?>

	<p class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first w-[90%] md:w-[34rem]">
		<label class="mt-5 mb-3 block" for="user_login"><?php esc_html_e( 'Username or email', 'woocommerce' ); ?></label>
		<input class="caret-blue-500 w-full border-2 border-slate-200 rounded-md h-9 bg-slate-50 p-3 flex items-center gap-3 md w-full:md:w-[34rem] woocommerce-Input woocommerce-Input--text input-text" type="text" name="user_login" id="user_login" autocomplete="username" />
	</p>

	<div class="clear"></div>

	<?php do_action( 'woocommerce_lostpassword_form' ); ?>

	<p class="woocommerce-form-row form-row w-[90%] md:w-[34rem]">
		<input type="hidden" name="wc_reset_password" value="true" />
		<button type="submit" class="mt-4 cursor-pointer bg-blue-600 w-full font-bold focus:outline-none focus:ring-2 focus:ring-blue-600 focus:ring-offset-2 focus:shadow-lg hover:shadow-lg hover:transition-all hover:duration-150 shadow-blue-600 text-white focus:border-transparent text-base p-2 flex justify-center items-center rounded-md woocommerce-Button button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" value="<?php esc_attr_e( 'Reset password', 'woocommerce' ); ?>"><?php esc_html_e( 'Reset password', 'woocommerce' ); ?></button>
	</p>

	<?php wp_nonce_field( 'lost_password', 'woocommerce-lost-password-nonce' ); ?>

</form>
<?php
do_action( 'woocommerce_after_lost_password_form' );
