<?php

/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

global $data_var_option_theme;

// Ensure visibility.
if (empty($product) || !$product->is_visible()) {
	return;
}
?>


<li class="selector-infinite lg:basis-1/2 w-full relative list-none m-0 print:h-20 print:basis-[49%]" <?php wc_product_class('', $product); ?>>

	<div class="bg-white p-2 rounded-md border-2 border-slate-200 shadow-md height-size-archive-print print:shadow-none print:rounded-none print:h-20 print:py-0 print:pr-0 print:pl-2 print:overflow-hidden">

		<?php
		/**
		 * Hook: woocommerce_before_shop_loop_item.
		 *
		 * @hooked woocommerce_template_loop_product_link_open - 10
		 */
		// do_action('woocommerce_before_shop_loop_item');


		/**
		 * Hook: woocommerce_before_shop_loop_item_title.
		 *
		 * @hooked woocommerce_show_product_loop_sale_flash - 10
		 * @hooked woocommerce_template_loop_product_thumbnail - 10
		 */

		?>

		<div class="flex w-full h-[136px] p-0 m-0 justify-between items-center z-0 print:h-auto">


			<div class="basis-4/12 h-[136px] print:h-auto print:basis-1/4 print:w-max ">
				<div class="rounded-md border-2 border-slate-200 print:border-0 overflow-hidden print:md:w-[80px] print:md:h-[80px] w-[8.5rem] h-[8.5rem] md:w-[136px] md:h-[136px]">
					<a href="<?php the_permalink(); ?>" aria-label="این تگ مربوط به محصول با نام <?php the_title(); ?> است">
						<?php the_post_thumbnail('thumbnail_product_archive_60', ['class' => 'w-full h-full object-cover print:h-20 print:w-20']) ?>
					</a>
				</div>
			</div>

			<div class="basis-4/5 h-[136px] flex justify-start flex-col print:h-[60px] print:basis-4/5 pr-2 print:pr-3 pt-2">

				<div class="flex justify-between items-center">

					<div class="h-10 flex justify-start items-center">
						<a class="print:whitespace-normal overflow-hidden pr-1 pb-2 block font-bold print:w-36 print:font-normal print:text-sm" href="<?php the_permalink(); ?>">
							<?php the_title(); ?>
						</a>
					</div>

				</div>




				<div class="flex justify-end items-center w-full text-sm lg:text-base print:hidden">





					<div class="flex justify-between items-center w-full">

						<?php if ($data_var_option_theme['editor__title_404_number_in_cart_ase']) {
						?>

							<span class="flex justify-between items-center mt-2 pt-2 border-t-2 border-slate-200 w-full">
								<!-- <span class="w-max">در کارتن:</span> -->
								<span>
									<?php print_r($data_var_option_theme['editor__title_404_number_in_cart_ase']); ?>
								</span>
							</span>

						<?php } ?>


						<?php if ($data_var_option_theme['display-disable_store'] == 0) { ?>


							<?php

							$regular_price = $product->get_regular_price();
							$regular_get_price = $product->get_price();
							if ($regular_price > $regular_get_price) {
								$discount_percentage = (1 - ($regular_get_price / $regular_price)) * 100;
							}
							$formatted_discount = number_format($discount_percentage, 2); // حداکثر دو رقم اعشار
							$formatted_discount = intval($formatted_discount);
							if ($regular_price > $regular_get_price) { ?>
								<div class="flex bg-red-800 px-1 text-white rounded-md mr-1">
									<?php echo "%$formatted_discount"; ?>
									<span class="px-1">تخفیف</span>
								</div>
							<?php } ?>


						<?php } ?>



					</div>





				</div>

				<?php if ($data_var_option_theme['display-disable_store'] == 0) { ?>


					<?php

					// بررسی موجودی محصول
					$stock_status = get_post_meta(get_the_ID(), '_stock_status', true);

					// اگر محصول موجود است
					if ('instock' === $stock_status) {

						// قیمت محصول را نمایش می دهد
						woocommerce_template_loop_price();
					} else {
					?>

						<span class="text-red-500">موجود نیست</span>

					<?php
					}


					?>


					<div class="flex justify-between items-center">



						<div class="rounded-md pt-1 flex justify-end items-center w-full z-0 relative print:hidden">

							<?php

							// اگر محصول موجود است
							if ('instock' === $stock_status) {



								// do_action('woocommerce_after_shop_loop_item');
								// do_action('woocommerce_after_shop_loop_item');
								// افزودن به سبد خرید را نمایش می دهد
								woocommerce_template_single_add_to_cart();
							}
							// نمایش دکمه افزودن به سبد خرید
							// do_action('woocommerce_after_shop_loop_item');
							?>





						</div>

					</div>



				<?php } ?>


			</div>

		</div>

		<?php

		/**
		 * Hook: woocommerce_shop_loop_item_title.
		 *
		 * @hooked woocommerce_template_loop_product_title - 10
		 */
		// do_action('woocommerce_shop_loop_item_title');

		/**
		 * Hook: woocommerce_after_shop_loop_item_title.
		 *
		 * @hooked woocommerce_template_loop_rating - 5
		 * @hooked woocommerce_template_loop_price - 10
		 */
		// do_action('woocommerce_after_shop_loop_item_title');



		/**
		 * Hook: woocommerce_after_shop_loop_item.
		 *
		 * @hooked woocommerce_template_loop_product_link_close - 5
		 * @hooked woocommerce_template_loop_add_to_cart - 10
		 */

		// do_action('woocommerce_after_shop_loop_item');


		?>


	</div>

</li>