<?php
/**
 * Checkout coupon form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-coupon.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

if ( ! wc_coupons_enabled() ) { // @codingStandardsIgnoreLine.
	return;
}

?>
<div class="mx-5 md:mx-0 woocommerce-form-coupon-toggle h-auto p-3 bg-blue-100 text-base font-bold text-blue-600 md:w-full text-right rounded-md w-auto">
	<?php wc_print_notice( apply_filters( 'woocommerce_checkout_coupon_message', esc_html__( 'Have a coupon?', 'woocommerce' ) . ' <a href="#" class="font-normal showcoupon">' . esc_html__( 'Click here to enter your code', 'woocommerce' ) . '</a>' ), 'notice' ); ?>
</div>

<form class="mx-5 md:mx-0 checkout_coupon woocommerce-form-coupon h-auto p-5 bg-white border-2 border-blue-600 text-base text-gray-800 md:w-full text-right rounded-md mt-2 w-auto" method="post" style="display:none">

	<p class="mb-3"><?php esc_html_e( 'If you have a coupon code, please apply it below.', 'woocommerce' ); ?></p>

	<p class="form-row form-row-first flex h-11 justify-start items-center">

		<label for="coupon_code" class="hidden md:block screen-reader-text ml-2"><?php esc_html_e( 'Coupon:', 'woocommerce' ); ?></label>
		<input type="text" name="coupon_code" class="md:basis-4/12 input-text caret-blue-500 w-full border-2 border-slate-200 rounded-md h-9 bg-slate-50 p-3 flex items-center gap-3 md:w-1/2" placeholder="<?php esc_attr_e( 'Coupon code', 'woocommerce' ); ?>" id="coupon_code" value="" />
		<button type="submit" class="basis-full md:basis-3/12 mr-2 cursor-pointer bg-blue-600 w-full font-bold focus:outline-none focus:ring-2 focus:ring-blue-600 focus:ring-offset-2 focus:shadow-lg hover:shadow-lg hover:transition-all hover:duration-150 shadow-blue-600 text-white focus:border-transparent text-base p-2 flex justify-center items-center rounded-md button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'woocommerce' ); ?>"><?php esc_html_e( 'Apply coupon', 'woocommerce' ); ?></button>

	</p>

		<div class="clear"></div>
</form>
