<?php

/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.9.0
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_cart'); ?>

<div class="w-screen bg-white border-b-2 border-gray-200 md:block md:w-full md:px-3">
	<div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md mx-auto block">

		<div class="flex flex-col md:flex-row mb-14 md:mt-14 gap-3">

			<div class="md:basis-9/12 basis-full">

				<form class="woocommerce-cart-form" action="<?php echo esc_url(wc_get_cart_url()); ?>" method="post">
					<?php do_action('woocommerce_before_cart_table'); ?>

					<div class="hidden md:block rounded-md overflow-hidden border-2 border-slate-200">
						<table class="w-full text-sm text-left rtl:text-right text-gray-500 dark:text-gray-400">
							<thead class="text-xs border-b-2 border-slate-200 hidden md:table-header-group">
								<tr class="rounded-md overflow-hidden mb-2 ">
									<th class="px-6 text-center py-3 product-remove border-l-2 border-slate-200"><span class="screen-reader-text block w-max"><?php esc_html_e('Remove item', 'woocommerce'); ?></span></th>
									<th class="px-6 text-center py-3 product-thumbnail"><span class="screen-reader-text block w-max"><?php esc_html_e('Thumbnail image', 'woocommerce'); ?></span></th>
									<th class="px-6 text-center py-3 product-name border-x-2 border-slate-200"><?php esc_html_e('Product', 'woocommerce'); ?></th>
									<th class="px-6 text-center py-3 product-price"><?php esc_html_e('Price', 'woocommerce'); ?></th>
									<th class="px-6 text-center py-3 product-quantity border-x-2 border-slate-200"><?php esc_html_e('Quantity', 'woocommerce'); ?></th>
									<th class="px-6 text-center py-3 w-max block product-subtotal"><?php esc_html_e('Subtotal', 'woocommerce'); ?></th>
								</tr>
							</thead>
							<tbody>
								<?php do_action('woocommerce_before_cart_contents'); ?>

								<?php
								foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
									$_product   = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
									$product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);
									/**
									 * Filter the product name.
									 *
									 * @since 2.1.0
									 * @param string $product_name Name of the product in the cart.
									 * @param array $cart_item The product in the cart.
									 * @param string $cart_item_key Key for the product in the cart.
									 */
									$product_name = apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key);

									if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_cart_item_visible', true, $cart_item, $cart_item_key)) {
										$product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
								?>
										<tr class="border-slate-200 border-b-2 relative woocommerce-cart-form__cart-item <?php echo esc_attr(apply_filters('woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key)); ?>">


											<td class="product-remove absolute left-0 md:static">
												<?php
												echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
													'woocommerce_cart_item_remove_link',
													sprintf(
														'<a href="%s" class="remove text-red-500 flex justify-center" aria-label="%s" data-product_id="%s" data-product_sku="%s">
													<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6">
													<path stroke-linecap="round" stroke-linejoin="round" d="M9.75 9.75l4.5 4.5m0-4.5l-4.5 4.5M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
													</svg>
												</a>',
														esc_url(wc_get_cart_remove_url($cart_item_key)),
														/* translators: %s is the product name */
														esc_attr(sprintf(__('Remove %s from cart', 'woocommerce'), wp_strip_all_tags($product_name))),
														esc_attr($product_id),
														esc_attr($_product->get_sku())
													),
													$cart_item_key
												);
												?>
											</td>

											<td class="absolute right-0 h-24 w-24 overflow-hidden md:static product-thumbnail md:w-28 md:h-auto max-h-28 object-cover shadow-md border-x-2 border-slate-200">
												<?php
												$thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);

												if (!$product_permalink) {
													echo $thumbnail; // PHPCS: XSS ok.
												} else {
													printf('<a href="%s">%s</a>', esc_url($product_permalink), $thumbnail); // PHPCS: XSS ok.
												}
												?>
											</td>

											<td class="absolute right-24 top-0 h-24 w-24 md:static product-name px-2 text-base font-bold text-gray-900 border-l-2 border-slate-200 p-3 md:h-auto md:w-5/12" data-title="<?php esc_attr_e('Product', 'woocommerce'); ?>">
												<?php
												if (!$product_permalink) {
													echo wp_kses_post($product_name . '&nbsp;');
												} else {
													/**
													 * This filter is documented above.
													 *
													 * @since 2.1.0
													 */
													echo wp_kses_post(apply_filters('woocommerce_cart_item_name', sprintf('<a href="%s">%s</a>', esc_url($product_permalink), $_product->get_name()), $cart_item, $cart_item_key));
												}

												do_action('woocommerce_after_cart_item_name', $cart_item, $cart_item_key);

												// Meta data.
												echo wc_get_formatted_cart_item_data($cart_item); // PHPCS: XSS ok.

												// Backorder notification.
												if ($_product->backorders_require_notification() && $_product->is_on_backorder($cart_item['quantity'])) {
													echo wp_kses_post(apply_filters('woocommerce_cart_item_backorder_notification', '<p class="backorder_notification">' . esc_html__('Available on backorder', 'woocommerce') . '</p>', $product_id));
												}
												?>
											</td>

											<td class="product-price border-l-2 border-slate-200 text-center" data-title="<?php esc_attr_e('Price', 'woocommerce'); ?>">
												<?php
												echo apply_filters('woocommerce_cart_item_price', WC()->cart->get_product_price($_product), $cart_item, $cart_item_key); // PHPCS: XSS ok.
												?>
											</td>

											<td class="product-quantity border-l-2 border-slate-200 text-center" data-title="<?php esc_attr_e('Quantity', 'woocommerce'); ?>">
												<?php
												if ($_product->is_sold_individually()) {
													$min_quantity = 1;
													$max_quantity = 1;
												} else {
													$min_quantity = 0;
													$max_quantity = $_product->get_max_purchase_quantity();
												}

												$product_quantity = woocommerce_quantity_input(
													array(
														'input_name'   => "cart[{$cart_item_key}][qty]",
														'input_value'  => $cart_item['quantity'],
														'max_value'    => $max_quantity,
														'min_value'    => $min_quantity,
														'product_name' => $product_name,
													),
													$_product,
													false
												);

												echo apply_filters('woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item); // PHPCS: XSS ok.
												?>
											</td>

											<td class="product-subtotal text-center" data-title="<?php esc_attr_e('Subtotal', 'woocommerce'); ?>">
												<?php
												echo apply_filters('woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal($_product, $cart_item['quantity']), $cart_item, $cart_item_key); // PHPCS: XSS ok.
												?>
											</td>


										</tr>
								<?php
									}
								}
								?>

								<?php do_action('woocommerce_cart_contents'); ?>

								<tr class="">
									<td colspan="6" class="actions ">

										<?php if (wc_coupons_enabled()) { ?>
											<div class="coupon p-3 text-base font-bold bg-slate-200 rounded-md m-6">
												<div class="md:w-full flex h-11 items-center">
													<label for="coupon_code" class="screen-reader-text md:w-max md:ml-3">وارد کردن کد تخفیف</label>
													<input type="text" name="coupon_code" class="input-text md:w-[40%] h-11 caret-blue-500 border-2 border-slate-200 rounded-md bg-slate-50 p-3" id="coupon_code" value="" placeholder="<?php esc_attr_e('Coupon code', 'woocommerce'); ?>" />

													<button type="submit" class="hidden md:block md:w-32 mr-3 text-center h-11 rounded-md bg-blue-600 text-white my-3 button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="apply_coupon" value="<?php esc_attr_e('Apply coupon', 'woocommerce'); ?>"><?php esc_html_e('Apply coupon', 'woocommerce'); ?>
													</button>

													<button type="submit" class="hidden md:block bg-white border-2 border-blue-600 text-blue-600  rounded-md md:px-3 md:mx-3 text-base md:w-max h-11  button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="update_cart" value="<?php esc_attr_e('Update cart', 'woocommerce'); ?>"><?php esc_html_e('Update cart', 'woocommerce'); ?></button>


												</div>


												<button type="submit" class="block md:hidden md:w-32 mr-3 text-center h-11 rounded-md bg-blue-600 text-white my-3 button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="apply_coupon" value="<?php esc_attr_e('Apply coupon', 'woocommerce'); ?>"><?php esc_html_e('Apply coupon', 'woocommerce'); ?>
												</button>

												<button type="submit" class="block md:hidden bg-white border-2 border-blue-600 text-blue-600  rounded-md md:px-3 md:mx-3 text-base md:w-max h-11  button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="update_cart" value="<?php esc_attr_e('Update cart', 'woocommerce'); ?>"><?php esc_html_e('Update cart', 'woocommerce'); ?></button>


												<?php do_action('woocommerce_cart_coupon'); ?>
											</div>
										<?php } ?>


										<?php do_action('woocommerce_cart_actions'); ?>

										<?php wp_nonce_field('woocommerce-cart', 'woocommerce-cart-nonce'); ?>
									</td>
								</tr>

								<?php do_action('woocommerce_after_cart_contents'); ?>
							</tbody>
						</table>

					</div>


					<div class="block md:hidden rounded-md overflow-hidden">
						<div class="w-full text-sm text-left rtl:text-right text-gray-500 dark:text-gray-400 p-5">

							<div>
								<?php do_action('woocommerce_before_cart_contents'); ?>

								<?php
								foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
									$_product   = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
									$product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);
									/**
									 * Filter the product name.
									 *
									 * @since 2.1.0
									 * @param string $product_name Name of the product in the cart.
									 * @param array $cart_item The product in the cart.
									 * @param string $cart_item_key Key for the product in the cart.
									 */
									$product_name = apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key);

									if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_cart_item_visible', true, $cart_item, $cart_item_key)) {
										$product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
								?>
										<div class="relative my-3 border-slate-200 border-b-2 woocommerce-cart-form__cart-item <?php echo esc_attr(apply_filters('woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key)); ?>">


											<div class="flex justify-between gap-2">

												<div class="product-thumbnail basis-3/12">
													<?php
													$thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);

													if (!$product_permalink) {
														echo $thumbnail; // PHPCS: XSS ok.
													} else {
														printf('<a href="%s">%s</a>', esc_url($product_permalink), $thumbnail); // PHPCS: XSS ok.
													}
													?>
												</div>

												<div class="basis-9/12 flex flex-col text-gray-700">

													<div class="product-name pl-6 h-auto py-2 border-dashed border-b-2 border-slate-200" data-title="<?php esc_attr_e('Product', 'woocommerce'); ?>">
														<?php
														if (!$product_permalink) {
															echo wp_kses_post($product_name . '&nbsp;');
														} else {
															/**
															 * This filter is documented above.
															 *
															 * @since 2.1.0
															 */
															echo wp_kses_post(apply_filters('woocommerce_cart_item_name', sprintf('<a href="%s">%s</a>', esc_url($product_permalink), $_product->get_name()), $cart_item, $cart_item_key));
														}

														do_action('woocommerce_after_cart_item_name', $cart_item, $cart_item_key);

														// Meta data.
														echo wc_get_formatted_cart_item_data($cart_item); // PHPCS: XSS ok.

														// Backorder notification.
														if ($_product->backorders_require_notification() && $_product->is_on_backorder($cart_item['quantity'])) {
															echo wp_kses_post(apply_filters('woocommerce_cart_item_backorder_notification', '<p class="backorder_notification">' . esc_html__('Available on backorder', 'woocommerce') . '</p>', $product_id));
														}
														?>
													</div>

													<div class="product-price h-11 py-2 flex justify-between items-center border-dashed border-b-2 border-slate-200" data-title="<?php esc_attr_e('Price', 'woocommerce'); ?>">

														<span> قیمت </span>

														<span> <?php
																echo apply_filters('woocommerce_cart_item_price', WC()->cart->get_product_price($_product), $cart_item, $cart_item_key); // PHPCS: XSS ok.
																?>
														</span>


													</div>

													<div class="product-quantity flex justify-between items-center h-11 py-2 border-dashed border-b-2 border-slate-200" data-title="<?php esc_attr_e('Quantity', 'woocommerce'); ?>">

														<span> تعداد </span>

														<span>
															<?php
															if ($_product->is_sold_individually()) {
																$min_quantity = 1;
																$max_quantity = 1;
															} else {
																$min_quantity = 0;
																$max_quantity = $_product->get_max_purchase_quantity();
															}

															$product_quantity = woocommerce_quantity_input(
																array(
																	'input_name'   => "cart[{$cart_item_key}][qty]",
																	'input_value'  => $cart_item['quantity'],
																	'max_value'    => $max_quantity,
																	'min_value'    => $min_quantity,
																	'product_name' => $product_name,
																),
																$_product,
																false
															);

															echo apply_filters('woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item); // PHPCS: XSS ok.
															?>
														</span>


													</div>

													<div class="product-subtotal flex justify-between items-center h-11 py-2" data-title="<?php esc_attr_e('Subtotal', 'woocommerce'); ?>">


														<span> جمع این محصول </span>

														<span>
															<?php
															echo apply_filters('woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal($_product, $cart_item['quantity']), $cart_item, $cart_item_key); // PHPCS: XSS ok.
															?>
														</span>

													</div>

												</div>




											</div>


											<div class="product-remove absolute left-0 top-0">

												<?php
												echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
													'woocommerce_cart_item_remove_link',
													sprintf(
														'<a href="%s" class="remove text-red-500 flex justify-center" aria-label="%s" data-product_id="%s" data-product_sku="%s">
													<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6">
													<path stroke-linecap="round" stroke-linejoin="round" d="M9.75 9.75l4.5 4.5m0-4.5l-4.5 4.5M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
													</svg>
												</a>',
														esc_url(wc_get_cart_remove_url($cart_item_key)),
														/* translators: %s is the product name */
														esc_attr(sprintf(__('Remove %s from cart', 'woocommerce'), wp_strip_all_tags($product_name))),
														esc_attr($product_id),
														esc_attr($_product->get_sku())
													),
													$cart_item_key
												);
												?>
											</div>






										</div>
								<?php
									}
								}
								?>

								<button type="submit" class="bg-blue-600 border-2 border-blue-600 text-white font-bold rounded-md text-base h-11 w-full my-7 button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="update_cart" value="<?php esc_attr_e('Update cart', 'woocommerce'); ?>"><?php esc_html_e('Update cart', 'woocommerce'); ?></button>

								<?php do_action('woocommerce_cart_contents'); ?>

								<div class="">
									<div colspan="6" class="actions ">

										<?php if (wc_coupons_enabled()) { ?>
											<div class="coupon text-base font-bold rounded-md mt-6">
												<div class="h-auto">
													<label for="coupon_code" class="screen-reader-text">
													</label>
													<input type="text" name="coupon_code" class="input-text h-11 caret-blue-500 border-2 border-slate-200 rounded-md bg-slate-50 p-3 w-full block" id="coupon_code" value="" placeholder="<?php esc_attr_e('Coupon code', 'woocommerce'); ?>" />

													<button type="submit" class="w-full block text-center h-11 rounded-md bg-blue-600 text-white my-3 button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="apply_coupon" value="<?php esc_attr_e('Apply coupon', 'woocommerce'); ?>"><?php esc_html_e('Apply coupon', 'woocommerce'); ?>
													</button>

												</div>






												<?php do_action('woocommerce_cart_coupon'); ?>
											</div>
										<?php } ?>


										<?php do_action('woocommerce_cart_actions'); ?>

										<?php wp_nonce_field('woocommerce-cart', 'woocommerce-cart-nonce'); ?>
									</div>
								</div>

								<?php do_action('woocommerce_after_cart_contents'); ?>
							</div>
						</div>

					</div>



					<?php do_action('woocommerce_after_cart_table'); ?>


				</form>



			</div>

			<?php do_action('woocommerce_before_cart_collaterals'); ?>

			<div class="md:basis-3/12 basis-full cart-collaterals px-5 pb-5 flex flex-col justify-start items-center border-2 border-slate-200 h-max rounded-md">
				<?php
				/**
				 * Cart collaterals hook.
				 *
				 * @hooked woocommerce_cross_sell_display
				 * @hooked woocommerce_cart_totals - 10
				 */
				do_action('woocommerce_cart_collaterals');
				?>
			</div>
		</div>

	</div>

</div>


<?php do_action('woocommerce_after_cart'); ?>