<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */
defined('ABSPATH') || exit;
get_header('shop');
/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action('woocommerce_before_main_content');
?>
<header class="woocommerce-products-header">
	<?php
	/**
	 * Hook: woocommerce_archive_description.
	 *
	 * @hooked woocommerce_taxonomy_archive_description - 10
	 * @hooked woocommerce_product_archive_description - 10
	 */
	// do_action('woocommerce_archive_description');
	?>
</header>
<div class="w-screen md:pt-4 bg-cover">
	<div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto">
		<div class="h-44 md:h-44 overflow-hidden md:rounded-md flex justify-center items-center relative print:hidden">
			<div class="">
				<?php global $data_var_option_theme; ?>
				<?php
				if ($data_var_option_theme['bg__title_archive_shop']['url']) {
				?>
					<?php $img_position_banner_title = $data_var_option_theme['bg_arrow_radio_items_archive_shop'] ?>
					<img class="w-screen h-44 md:h-80 object-cover filter brightness-50" src="<?php echo $data_var_option_theme['bg__title_archive_shop']['url']; ?>" style="<?php echo $img_position_banner_title; ?>" alt="">
				<?php
				} else {
				?>
					<img class="w-screen h-44 md:h-80 object-cover filter brightness-50" src="<?php echo get_template_directory_uri(); ?>/inc/img/banner-def.jpg " alt="تصویر 404 -  <?php bloginfo('name'); ?>">
				<?php }; ?>
			</div>
			<div class="absolute">
				<?php if (apply_filters('woocommerce_show_page_title', true)) : ?>
					<h1 class="p-0 m-0 text-white"><?php woocommerce_page_title(); ?></h1>
				<?php endif; ?>
			</div>
		</div>
		<div class="hidden print:block w-full">
			<div class=" flex justify-between items-center">
				<div class="text-black font-bold text-right">
					<span>
						<?php echo get_bloginfo('name'); ?>
					</span>
				</div>
				<div class="w-28 h-16 flex items-center justify-center">
					<div class="">
						<?php
						if ($data_var_option_theme['header-logo']['url']) {
						?>
							<a href="<?php bloginfo('url'); ?>">
								<img class="w-36 h-auto" src=" <?php echo $data_var_option_theme['header-logo']['url']; ?>" alt=" <?php bloginfo('name'); ?>  لوگو">
							</a>
						<?php
						} else {
						?> <div class="h-12 w-28 bg-slate-100 rounded-md ring-2 ring-cyan-600">
								<span class="w-full h-full flex justify-center items-center text-center font-bold">
									محل درج لوگو هدر
								</span>
							</div>
						<?php
						};
						?>
					</div>
				</div>
			</div>
		</div>
		<div class="lg:flex mb-10" id="my-products">
			<div class="w-full lg:w-[20%] lg:pl-4 px-5 print:hidden md:pt-8">
				<span class="h-[45px] p-3 w-full font-bold flex justify-start items-center cursor-pointer">فیلتر براساس دسته بندی</span>
				<?php
				$current_cat = get_queried_object();
				$current_id = $current_cat->term_id ?? 0;
				$current_parent = $current_cat->parent ?? 0;
				$main_cats = get_terms([
					'taxonomy' => 'product_cat',
					'parent' => 0,
					'hide_empty' => false
				]);
				if (!empty($main_cats)) :
				?>
					<div class="bg-white dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-600 max-w-sm mb-3">
						<ul class="list-none divide-y-2 divide-slate-100">
							<?php foreach ($main_cats as $main_cat) :
								$is_current_main = ($current_id == $main_cat->term_id);
								$is_current_child = ($current_parent == $main_cat->term_id || $current_id == $main_cat->term_id);
								$main_checked = ($is_current_main || $is_current_child);
							?>
								<li class="py-2">
									<a href="<?= get_term_link($main_cat); ?>" class="flex items-center space-x-2 group group-hover:text-blue-600">
										<input type="checkbox" disabled <?= $main_checked ? 'checked' : '' ?>
											class="me-2 w-4 h-4 text-blue-600 bg-blue-600 border-gray-300 rounded-sm group-hover:cursor-pointer focus:ring-blue-500 dark:focus:ring-blue-600 focus:ring-2 dark:bg-gray-600 dark:border-gray-500">
										<span class="font-semibold text-gray-900 dark:text-white group-hover:text-blue-600">
											<?= esc_html($main_cat->name); ?>
										</span>
									</a>
									<?php
									if ($is_current_main || $is_current_child) :
										$child_cats = get_terms([
											'taxonomy' => 'product_cat',
											'parent' => $main_cat->term_id,
											'hide_empty' => false
										]);
										if (!empty($child_cats)) : ?>
											<ul class="list-none mt-1 ms-6">
												<?php foreach ($child_cats as $child_cat) :
													$is_child_checked = ($current_id == $child_cat->term_id);
												?>
													<li class="py-2">
														<a href="<?= get_term_link($child_cat); ?>" class="flex items-center space-x-2 group">
															<input type="checkbox" disabled <?= $is_child_checked ? 'checked' : '' ?>
																class="me-2 w-4 h-4 text-blue-600 bg-blue-600 border-gray-300 rounded-sm group-hover:cursor-pointer focus:ring-blue-500 dark:focus:ring-blue-600 focus:ring-2 dark:bg-gray-600 dark:border-gray-500">
															<span class="text-sm text-gray-700 dark:text-gray-300 group-hover:text-blue-600">
																<?= esc_html($child_cat->name); ?>
															</span>
														</a>
													</li>
												<?php endforeach; ?>
											</ul>
									<?php endif;
									endif; ?>
								</li>
							<?php endforeach; ?>
						</ul>
					</div>
				<?php endif; ?>
				<div class="footer__right">
					<?php if (is_active_sidebar('filter_product_archive')) { ?>
						<div id="sidebar">
							<?php dynamic_sidebar('filter_product_archive'); ?>
						</div>
					<?php } ?>
				</div>
				<div class="">
					<div :class="one_operation ? 'ring-offset-2 ring border-gray-200 rounded-md transition-all duration-500':' ' " x-data="{ one_operation: false }" class="">
						<!-- header -->
						<!-- <div x-on:click="one_operation = ! one_operation" class="px-2 bg-gray-200 w-full h-10 rounded-md flex justify-between items-center text-black cursor-pointer mb-3">
							<h2 class="text-sm font-light text-zinc-800 p-0 m-0 flex justify-center items-center">
								<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6 ml-1">
									<path stroke-linecap="round" d="M15.75 10.5l4.72-4.72a.75.75 0 011.28.53v11.38a.75.75 0 01-1.28.53l-4.72-4.72M4.5 18.75h9a2.25 2.25 0 002.25-2.25v-9a2.25 2.25 0 00-2.25-2.25h-9A2.25 2.25 0 002.25 7.5v9a2.25 2.25 0 002.25 2.25z"></path>
								</svg>
								راهنمای خرید فروشگاهی
							</h2>
							<div class="basis-2/12 flex justify-end">
								<svg :class="one_operation ? 'rotate-180':'' " xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-7 transition-all duration-700">
									<path stroke-linecap="round" stroke-linejoin="round" d="M4.5 15.75l7.5-7.5 7.5 7.5" />
								</svg>
							</div>
						</div> -->
						<!-- footer -->
						<div x-show="one_operation" class="bg-white w-full h-auto rounded-md transition-all duration-1000">
							<div class="mt-2">
								<video class="rounded-md object-cover w-full" src="<?php echo get_template_directory_uri(); ?>./inc/video/1.mp4" type="video/mp4" controls preload muted loop></video>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="w-full lg:w-[80%] relative">
				<header class="woocommerce-products-header px-5 md:py-5 md:px-0">
					<div class="flex w-full justify-end items-center h-12 print:hidden mb-2 gap-3">
						<!-- <a href="<?php echo esc_url(wc_get_cart_url()); ?>">
							<div class="flex text-sm font-light text-zinc-800 items-center justify-center lg:mr-1 border-2 border-gray-200 rounded-md p-1 h-8">
								<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="ml-1 w-6 h-6 md:h-6 md:ml-1">
									<path stroke-linecap="round" stroke-linejoin="round" d="M2.25 3h1.386c.51 0 .955.343 1.087.835l.383 1.437M7.5 14.25a3 3 0 00-3 3h15.75m-12.75-3h11.218c1.121-2.3 2.1-4.684 2.924-7.138a60.114 60.114 0 00-16.536-1.84M7.5 14.25L5.106 5.272M6 20.25a.75.75 0 11-1.5 0 .75.75 0 011.5 0zm12.75 0a.75.75 0 11-1.5 0 .75.75 0 011.5 0z" />
								</svg>
								<span class="pr-1"> تکمیل خرید </span>
							</div>
						</a> -->
						<div class="flex text-sm font-light text-zinc-800 items-center justify-center lg:mr-2 border-2 border-gray-200 rounded-md h-8 w-full md:w-72 p-5">
							<button onclick="window.print()" class="flex justify-between items-center ">
								<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="ml-1 w-6 h-6 md:h-6 md:ml-1">
									<path stroke-linecap="round" stroke-linejoin="round" d="M6.72 13.829c-.24.03-.48.062-.72.096m.72-.096a42.415 42.415 0 0 1 10.56 0m-10.56 0L6.34 18m10.94-4.171c.24.03.48.062.72.096m-.72-.096L17.66 18m0 0 .229 2.523a1.125 1.125 0 0 1-1.12 1.227H7.231c-.662 0-1.18-.568-1.12-1.227L6.34 18m11.318 0h1.091A2.25 2.25 0 0 0 21 15.75V9.456c0-1.081-.768-2.015-1.837-2.175a48.055 48.055 0 0 0-1.913-.247M6.34 18H5.25A2.25 2.25 0 0 1 3 15.75V9.456c0-1.081.768-2.015 1.837-2.175a48.041 48.041 0 0 1 1.913-.247m10.5 0a48.536 48.536 0 0 0-10.5 0m10.5 0V3.375c0-.621-.504-1.125-1.125-1.125h-8.25c-.621 0-1.125.504-1.125 1.125v3.659M18 10.5h.008v.008H18V10.5Zm-3 0h.008v.008H15V10.5Z" />
								</svg>
								دریافت لیست چاپی محصولات
							</button>
						</div>
					</div>
					<?php
					if (woocommerce_product_loop()) {
						/**
						 * Hook: woocommerce_before_shop_loop.
						 *
						 * @hooked woocommerce_output_all_notices - 10
						 * @hooked woocommerce_result_count - 20
						 * @hooked woocommerce_catalog_ordering - 30
						 */
						do_action('woocommerce_before_shop_loop');
						woocommerce_product_loop_start();
					?>
						<div class="flex flex-wrap gap-4  md:p-0 mt-6 md:mt-0">
							<?php
							// گرفتن دسته‌بندی فعلی
							$current_category = get_queried_object();
							if ($current_category && $current_category->taxonomy === 'product_cat') {
								// بررسی وجود زیرشاخه‌ها
								$child_categories = get_terms(array(
									'taxonomy'   => 'product_cat',
									'hide_empty' => false,
									'parent'     => $current_category->term_id,
								));
								if (!empty($child_categories) && !is_wp_error($child_categories)) {
									// اگر زیرشاخه دارد، نمایش زیرشاخه‌ها
							?>
									<!-- <span>دسته بندی محصولات</span> -->
									<ul class="category-grid grid grid-cols-2 md:grid-cols-4 gap-4 w-full print:md:grid-cols-4 print:gap-1">
										<?php foreach ($child_categories as $child_category) : ?>
											<?php
											$child_link = get_term_link($child_category);
											$child_image_id = get_term_meta($child_category->term_id, 'thumbnail_id', true);
											$child_image = wp_get_attachment_url($child_image_id) ?: 'path/to/default-image.jpg';
											?>
											<li class="text-center p-2 border rounded-lg list-none">
												<a href="<?php echo esc_url($child_link); ?>" class="block">
													<img src="<?php echo esc_url($child_image); ?>" alt="<?php echo esc_attr($child_category->name); ?>" class="w-full h-auto">
												</a>
												<a href="<?php echo esc_url($child_link); ?>" class="block text-base pb-2 font-bold mt-2"><?php echo esc_html($child_category->name); ?></a>
											</li>
										<?php endforeach; ?>
									</ul>
								<?php
								} else {
									// اگر زیرشاخه‌ای ندارد، نمایش محصولات دسته فعلی
								?>
									<ul class="ulselector-infinite grid grid-cols-1 md:grid-cols-2 gap-4 w-full print:md:grid-cols-2 print:gap-1">
										<?php
										if (wc_get_loop_prop('total')) {
											while (have_posts()) {
												the_post();
												/**
												 * Hook: woocommerce_shop_loop.
												 */
												do_action('woocommerce_shop_loop');
												wc_get_template_part('content', 'product');
											}
										}
										?>
									</ul>
							<?php
								}
							}
							?>
						</div>
						<div class="pt-5">
							<?php
							do_action('woocommerce_archive_description');
							?>
						</div>
					<?php
						woocommerce_product_loop_end();
						/**
						 * Hook: woocommerce_after_shop_loop.
						 *
						 * @hooked woocommerce_pagination - 10
						 */
						do_action('woocommerce_after_shop_loop');
					} else {
						/**
						 * Hook: woocommerce_no_products_found.
						 *
						 * @hooked wc_no_products_found - 10
						 */
						do_action('woocommerce_no_products_found');
					}
					/**
					 * Hook: woocommerce_after_main_content.
					 *
					 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
					 */
					do_action('woocommerce_after_main_content');
					?>
			</div>
		</div>
	</div>
</div>
<script>
	// کد جاوااسکریپت برای مدیریت انتخاب دسته‌بندی‌ها و ریدایرکت به دسته انتخاب‌شده
	(function() {
		const checkboxes = document.querySelectorAll('input[type="checkbox"]');
		checkboxes.forEach(checkbox => {
			checkbox.addEventListener('change', function() {
				if (this.checked) {
					const categoryLink = document.querySelector('label[for="' + this.id + '"] a').href;
					window.location.href = categoryLink;
				} else {
					const selectedCategories = Array.from(checkboxes)
						.filter(cb => cb.checked)
						.map(cb => cb.value);
					const urlParams = new URLSearchParams(window.location.search);
					urlParams.set('categories', selectedCategories.join(','));
					window.location.search = urlParams.toString();
				}
			});
		});
	})();
</script>
<?php
get_footer('shop');
