<?php

/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */

defined('ABSPATH') || exit;

get_header('shop');

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action('woocommerce_before_main_content'); ?>

<div class="w-screen md:pt-4 bg-cover">
    <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto">
        <div class="h-44 md:h-44 overflow-hidden md:rounded-md flex justify-center items-center relative print:hidden">
            <div class="">
                <?php global $data_var_option_theme; ?>

                <?php
                if ($data_var_option_theme['bg__title_archive_shop']['url']) {
                ?>
                    <?php $img_position_banner_title = $data_var_option_theme['bg_arrow_radio_items_archive_shop'] ?>
                    <img class="w-screen h-44 md:h-80 object-cover filter brightness-50" src="<?php echo $data_var_option_theme['bg__title_archive_shop']['url']; ?>" style="<?php echo $img_position_banner_title; ?>" alt="">
                <?php
                } else {
                ?>
                    <img class="w-screen h-44 md:h-80 object-cover filter brightness-50" src="<?php echo get_template_directory_uri(); ?>/inc/img/banner-def.jpg " alt="تصویر 404 -  <?php bloginfo('name'); ?>">
                <?php }; ?>
            </div>
            <div class="absolute">
                <?php if (apply_filters('woocommerce_show_page_title', true)) : ?>
                    <h1 class="p-0 m-0 text-white"><?php the_title(); ?></h1>
                <?php endif; ?>
            </div>
        </div>
        <div class="hidden print:block w-full">
            <div class=" flex justify-between items-center">
                <div class="text-black font-bold text-right">
                    <span>
                        فکراگیم، یادگیری و سرگرمی در کنار هم!
                    </span>
                </div>
                <div class="w-28 h-16 flex items-center justify-center">
                    <div class="">
                        <?php
                        if ($data_var_option_theme['header-logo']['url']) {
                        ?>
                            <a href="<?php bloginfo('url'); ?>">
                                <img class="w-36 h-auto" src=" <?php echo $data_var_option_theme['header-logo']['url']; ?>" alt=" <?php bloginfo('name'); ?>  لوگو">
                            </a>
                        <?php
                        } else {
                        ?> <div class="h-12 w-28 bg-slate-100 rounded-md ring-2 ring-cyan-600">
                                <span class="w-full h-full flex justify-center items-center text-center font-bold">
                                    محل درج لوگو هدر
                                </span>
                            </div>
                        <?php
                        };
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="lg:flex mb-10" id="my-products">
            <div class="w-full lg:w-[20%] lg:pl-4 p-2 print:hidden">
                <span class="text-base font-bold text-zinc-800 lg:mt-6 py-4 px-1 block">محل جستجو محصول</span>
                <div class="h-12 items-center justify-center flex-col mb-2 md:mb-0">
                    <!-- <span class="text-base font-bold text-zinc-800 mt-6 mb-6 block">محل جستجو محصول.</span> -->
                    <form class="w-full">
                        <div class="relative">
                            <div class="absolute inset-y-0 right-3 flex items-center pl-3 pointer-events-none">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-w-10 ml-2 md:w-6 md:h-6 md:ml-1">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z" />
                                </svg>
                            </div>
                            <input type="search" data-swplive="true" id="search" class="w-full block h-11 p-4 pr-14 lg:pr-10 text-sm text-gray-900 border border-gray-200 rounded-md bg-white focus:ring-blue-500 focus:border-blue-500 dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="جستجو کنید..." required>
                        </div>
                    </form>
                </div>





                <div class="footer__right">
                    <?php if (is_active_sidebar('filter_product_archive')) { ?>
                        <ul id="sidebar">
                            <?php dynamic_sidebar('filter_product_archive'); ?>
                        </ul>
                    <?php } ?>
                </div>



                <div class=" pt-14">
                    <div :class="one_operation ? 'ring-offset-2 ring border-gray-200 rounded-md transition-all duration-500':' ' " x-data="{ one_operation: false }" class="">
                        <!-- header -->
                        <div x-on:click="one_operation = ! one_operation" class="px-2 bg-gray-200 w-full h-10 rounded-md flex justify-between items-center text-black cursor-pointer">
                            <h2 class="text-sm font-light text-zinc-800 p-0 m-0 flex justify-center items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6 ml-1">
                                    <path stroke-linecap="round" d="M15.75 10.5l4.72-4.72a.75.75 0 011.28.53v11.38a.75.75 0 01-1.28.53l-4.72-4.72M4.5 18.75h9a2.25 2.25 0 002.25-2.25v-9a2.25 2.25 0 00-2.25-2.25h-9A2.25 2.25 0 002.25 7.5v9a2.25 2.25 0 002.25 2.25z"></path>
                                </svg>
                                راهنمای خرید فروشگاهی
                            </h2>
                            <div class="basis-2/12 flex justify-end">
                                <svg :class="one_operation ? 'rotate-180':'' " xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-7 transition-all duration-700">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M4.5 15.75l7.5-7.5 7.5 7.5" />
                                </svg>
                            </div>
                        </div>
                        <!-- footer -->
                        <div x-show="one_operation" class="bg-white w-full h-auto rounded-md transition-all duration-1000">
                            <div class="mt-2">
                                <video class="rounded-md object-cover w-full" src="<?php echo get_template_directory_uri(); ?>./inc/video/1.mp4" type="video/mp4" controls preload muted loop></video>
                            </div>
                        </div>
                    </div>
                </div>











            </div>
            <div class="w-full lg:w-[80%]">
                <header class="woocommerce-products-header p-2">
                    <div class="flex w-full justify-end items-center h-12 print:hidden mb-2">
                        <a href="<?php echo esc_url(wc_get_cart_url()); ?>">
                            <div class="flex text-sm font-light text-zinc-800 items-center justify-center  lg:mr-1 border-2 border-gray-200 rounded-md p-1 h-8">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="ml-1 w-6 h-6 md:h-6 md:ml-1">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 3h1.386c.51 0 .955.343 1.087.835l.383 1.437M7.5 14.25a3 3 0 00-3 3h15.75m-12.75-3h11.218c1.121-2.3 2.1-4.684 2.924-7.138a60.114 60.114 0 00-16.536-1.84M7.5 14.25L5.106 5.272M6 20.25a.75.75 0 11-1.5 0 .75.75 0 011.5 0zm12.75 0a.75.75 0 11-1.5 0 .75.75 0 011.5 0z" />
                                </svg>
                                <span class="pr-1"> تکمیل خرید </span>
                            </div>
                        </a>
                    </div>



                    <div class="flex flex-wrap gap-4 px-5 mt-8 md:p-0">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-x-4 gap-y-8 w-full">

                            <?php
                            $args = array(
                                'post_type'      => 'product',
                                'posts_per_page' => -1,
                                'tax_query'      => array(
                                    array(
                                        'taxonomy' => 'product_cat',
                                        'field'    => 'slug',
                                        'terms'    => 'educational-products	',
                                    ),
                                ),
                            );

                            $products = new WP_Query($args);

                            if ($products->have_posts()) {
                                while ($products->have_posts()) {
                                    $products->the_post();
                                    // اینجا می‌توانید کد مربوط به نمایش هر محصول را قرار دهید
                                    wc_get_template_part('content-education', 'product');
                                }
                                wp_reset_postdata();
                            } else {
                                echo __('No products found', 'text-domain');
                            }
                            ?>



                        </div>

                    </div>



            </div>
        </div>
    </div>
</div>
</div>
<?php
get_footer('shop');
