<?php

global $data_var_option_theme;

global $product;

?>


<div class="w-screen bg-cover px-5 mt-5">

    <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto flex justify-center items-center">


        <div class="w-full border-2 border-white rounded-3xl overflow-hidden diff-all-web">
            <div class="h-auto">

                <div class="swiper mySwiper-head-front-page w-full relative rounded-md">
                    <div class="swiper-wrapper">

                        <?php
                        // تعداد آرایه‌ها
                        $numArrays = count($data_var_option_theme['img_slider_desktop']);
                        // حلقه برای نمایش آرایه‌ها
                        for ($i = 0; $i < $numArrays; $i++) {
                        ?>
                            <div class="swiper-slide w-full h-[200px] relative">
                                <div class="flex items-center h-full w-full ">


                                    <?php
                                    if (!empty($data_var_option_theme['img_slider_desktop_editor__title'][$i])) {
                                    ?>
                                        <div class="absolute right-5 p-8 bg-gray-50 bg-opacity-90 rounded-md w-1/3">
                                            <p class="text-xl text-right font-extrabold leading-10">
                                                <?php echo htmlspecialchars($data_var_option_theme['img_slider_desktop_editor__title'][$i], ENT_QUOTES, 'UTF-8'); ?>
                                            </p>
                                        </div>
                                    <?php
                                    }
                                    ?>



                                    <a href="<?php if ($data_var_option_theme['img_slider_desktop_text_url_tag_a'][$i]) {
                                                    echo esc_url($data_var_option_theme['img_slider_desktop_text_url_tag_a'][$i]);
                                                } else {
                                                    echo "#";
                                                } ?>">

                                        <img class="z-0 w-full h-full" src="<?php echo $data_var_option_theme['img_slider_desktop'][$i]['url']; ?>" alt="<?php
                                                                                                                                                            if ($data_var_option_theme['img_slider_desktop_text']) {
                                                                                                                                                                echo $data_var_option_theme['img_slider_desktop_text'];
                                                                                                                                                            } else {
                                                                                                                                                                echo "'بنر' $i 'دسکتاپ'";
                                                                                                                                                            }
                                                                                                                                                            ?> " />

                                    </a>
                                </div>
                            </div>
                        <?php } ?>

                    </div>

                    <div class="swiper-pagination flex justify-center items-center"></div>
                    <div class="absolute left-0 bottom-0 bg-white w-52 h-52 z-10" style="clip-path: polygon(0 1%, 0% 100%, 100% 100%);"></div>
                    <div class="flex w-full justify-center items-start">
                        <div class="absolute top-[-90px] rotate-[315deg] bg-white w-36 h-36 z-10 rounded-3xl" style="clip-path: polygon(0 1%, 0% 100%, 100% 100%);"></div>
                    </div>
                    <div class="swiper-button-next z-20"></div>
                    <div class="swiper-button-prev z-20"></div>
                </div>

            </div>
        </div>


    </div>



</div>