<?php

/**
 * The template for displaying Search Results pages.
 *
 * @package Shape
 * @since Shape 1.0
 */

get_header(); ?>


<div class="box-search-in-page mb-30">
	<div class="search-all">
		<p>در کادر زیر می توانید متن خود را جستجو کنید.</p>
		<form role="search" method="get" class="search-form" action="<?php echo home_url('/'); ?>">
			<input type="hidden" name="post_type" value="post">
			<label>
				<span class="screen-reader-text"><?php echo _x('Search for:', 'label') ?></span>
				<input data-swplive="true" type="search" class="search-field" placeholder="<?php echo esc_attr_x('جستجو کنید', 'placeholder') ?>" value="<?php echo get_search_query() ?>" name="s" title="<?php echo esc_attr_x('Search for:', 'label') ?>" />
			</label>

			<button type="submit" class="fa-solid-search-submit" value="<?php echo esc_attr_x('', 'submit button') ?>" class="button">

				<i class=" fa-solid fa-magnifying-glass"></i>

			</button>

		</form>
	</div>
</div>


<?php get_footer(); ?>