<?php

/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package MohammadrezaBehdarvand
 */

?>

<?php global $data_var_option_theme; ?>


<?php
// شرط بر اساس نوع محتوا که محصول فیزیکی است یا آموزشی
if ($data_var_option_theme['switch-page-service-physical'] == 1) {
	// صفحه خدمات است
	include('service/page-services.php');
} else {
	// صفحه خدمات نیست
?>


	<div class="w-screen bg-white border-b-2 border-gray-200 md:block md:w-full md:px-3">
		<div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md mx-auto block">


			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

				<?php if (!is_checkout() && !is_cart() && !is_order_received_page() && !is_account_page()) { ?>
					<header class="entry-header">
						<?php the_title('<h1 class="entry-title flex justify-center items-center md:h-28 bg-slate-50 md:bg-white m-0 py-5">', '</h1>'); ?>
					</header><!-- .entry-header -->
				<?php }; ?>

				<?php mohammadrezabehdarvand_post_thumbnail(); ?>

				<div class="entry-content">
					<?php
					the_content();

					wp_link_pages(
						array(
							'before' => '<div class="page-links">' . esc_html__('Pages:', 'mohammadrezabehdarvand'),
							'after'  => '</div>',
						)
					);
					?>
				</div><!-- .entry-content -->

				<?php if (get_edit_post_link()) : ?>
					<footer class="entry-footer">
						<?php
						edit_post_link(
							sprintf(
								wp_kses(
									/* translators: %s: Name of current post. Only visible to screen readers */
									__('Edit <span class="screen-reader-text">%s</span>', 'mohammadrezabehdarvand'),
									array(
										'span' => array(
											'class' => array(),
										),
									)
								),
								wp_kses_post(get_the_title())
							),
							'<span class="edit-link">',
							'</span>'
						);
						?>
					</footer><!-- .entry-footer -->
				<?php endif; ?>
			</article><!-- #post-<?php the_ID(); ?> -->


		</div>
	</div>


<?php }  ?>