<?php get_header(); ?>


<?php

global $data_var_option_theme;

global $product;

?>


<?php

// تعداد کاراکتر‌ها در هر کلمه
$charactersPerWord = 5;

// میانگین سرعت خواندن کلمه در دقیقه
$averageReadingSpeed = 225;

?>


<div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto ">
    <div class="h-auto mt-5 md:mt-12 mb-6 md:my-10">

        <div class="md:grid md:grid-cols-4 md:grid-rows-2 flex flex-col px-5 md:px-0 gap-4">


            <?php
            $args_top_blog_grid = array(
                'offset' => 1,
                'posts_per_page' => 1,
            );

            $the_query_top_blog_grid = new WP_Query($args_top_blog_grid); ?>

            <?php if ($the_query_top_blog_grid->have_posts()) : ?>
                <?php while ($the_query_top_blog_grid->have_posts()) :  $the_query_top_blog_grid->the_post(); ?>


                    <?php

                    $content = get_the_content();

                    // تعداد کاراکتر‌های محتوا را محاسبه
                    $totalCharacters = mb_strlen($content);


                    // محاسبه تعداد کلمه‌ها
                    $totalWords = ceil($totalCharacters / $charactersPerWord);

                    // محاسبه زمان لازم بر اساس میانگین سرعت خواندن
                    $timeInMinutes = $totalWords / $averageReadingSpeed;

                    // تبدیل به ثانیه
                    $timeInSeconds = $timeInMinutes * 60;

                    // تبدیل ثانیه به دقیقه و ثانیه
                    $minutes = floor($timeInSeconds / 60);
                    $seconds = $timeInSeconds % 60;
                    ?>

                    <div class="cursor-pointer bg-slate-200 hover:shadow-lg min-h-[12rem] max-h-[207px] rounded-md shadow-md col-start-1 row-start-1 relative overflow-hidden">
                        <a class="cursor-pointer" href="<?php the_permalink(); ?>">

                            <div class="h-full w-full">
                                <?php

                                if (has_post_thumbnail()) { ?>
                                    <img class="w-full h-full object-cover" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                                <?php } else { ?>
                                    <img class="w-full h-full object-cover" src=" <?php echo get_template_directory_uri(); ?>/inc/img/replace-banner.webp " alt="<?php echo esc_attr($alt_text); ?>">
                                <?php } ?>

                                <span class="backdrop-blur-sm bg-gradient-to-b from-transparent to-black/50 min-h-[5rem] max-h-[10rem] w-full text-base text-white font-bold px-3 flex justify-start items-center bg-black bg-opacity-40 absolute bottom-0">

                                    <?php the_title(); ?>

                                </span>

                                <span class="flex items-center justify-center absolute top-3 left-3 text-xs text-gray-800 font-thin backdrop-blur-sm bg-white/50 h-6 w-max px-1 rounded-md">
                                    <?php if ($minutes > 0 && $seconds > 0) {
                                        echo "زمان خواندن: $minutes دقیقه و $seconds ثانیه";
                                    } elseif ($minutes > 0 && $seconds == 0) {
                                        echo "زمان خواندن: $minutes دقیقه";
                                    } elseif ($minutes == 0) {
                                        echo "زمان خواندن: $seconds ثانیه";
                                    }
                                    ?>
                                </span>

                            </div>
                        </a>
                    </div>


                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            <?php endif; ?>




            <?php
            $args_top_blog_grid = array(
                'offset' => 2,
                'posts_per_page' => 1,
            );

            $the_query_top_blog_grid = new WP_Query($args_top_blog_grid); ?>

            <?php if ($the_query_top_blog_grid->have_posts()) : ?>
                <?php while ($the_query_top_blog_grid->have_posts()) :  $the_query_top_blog_grid->the_post(); ?>


                    <?php

                    $content = get_the_content();

                    // تعداد کاراکتر‌های محتوا را محاسبه
                    $totalCharacters = mb_strlen($content);


                    // محاسبه تعداد کلمه‌ها
                    $totalWords = ceil($totalCharacters / $charactersPerWord);

                    // محاسبه زمان لازم بر اساس میانگین سرعت خواندن
                    $timeInMinutes = $totalWords / $averageReadingSpeed;

                    // تبدیل به ثانیه
                    $timeInSeconds = $timeInMinutes * 60;

                    // تبدیل ثانیه به دقیقه و ثانیه
                    $minutes = floor($timeInSeconds / 60);
                    $seconds = $timeInSeconds % 60;
                    ?>

                    <div class="cursor-pointer bg-slate-200 hover:shadow-lg min-h-[12rem] max-h-[207px] rounded-md shadow-md col-start-1 row-start-2 relative overflow-hidden">
                        <a class="cursor-pointer" href="<?php the_permalink(); ?>">

                            <div class="h-full w-full">

                                <?php

                                if (has_post_thumbnail()) { ?>
                                    <img class="w-full h-full object-cover" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                                <?php } else { ?>
                                    <img class="w-full h-full object-cover" src=" <?php echo get_template_directory_uri(); ?>/inc/img/replace-banner.webp " alt="<?php echo esc_attr($alt_text); ?>">
                                <?php } ?>


                                <span class="backdrop-blur-sm bg-gradient-to-b from-transparent to-black/50 min-h-[5rem] max-h-[10rem] w-full text-base text-white font-bold px-3 flex justify-start items-center bg-black bg-opacity-40 absolute bottom-0">

                                    <?php the_title(); ?>

                                </span>

                                <span class="flex items-center justify-center absolute top-3 left-3 text-xs text-gray-800 font-thin backdrop-blur-sm bg-white/50 h-6 w-max px-1 rounded-md">
                                    <?php if ($minutes > 0 && $seconds > 0) {
                                        echo "زمان خواندن: $minutes دقیقه و $seconds ثانیه";
                                    } elseif ($minutes > 0 && $seconds == 0) {
                                        echo "زمان خواندن: $minutes دقیقه";
                                    } elseif ($minutes == 0) {
                                        echo "زمان خواندن: $seconds ثانیه";
                                    }
                                    ?>
                                </span>

                            </div>
                        </a>
                    </div>


                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            <?php endif; ?>




            <?php
            $args_top_blog_grid = array(
                'offset' => 0,
                'posts_per_page' => 1,
            );

            $the_query_top_blog_grid = new WP_Query($args_top_blog_grid); ?>

            <?php if ($the_query_top_blog_grid->have_posts()) : ?>
                <?php while ($the_query_top_blog_grid->have_posts()) :  $the_query_top_blog_grid->the_post(); ?>


                    <?php

                    $content = get_the_content();

                    // تعداد کاراکتر‌های محتوا را محاسبه
                    $totalCharacters = mb_strlen($content);


                    // محاسبه تعداد کلمه‌ها
                    $totalWords = ceil($totalCharacters / $charactersPerWord);

                    // محاسبه زمان لازم بر اساس میانگین سرعت خواندن
                    $timeInMinutes = $totalWords / $averageReadingSpeed;

                    // تبدیل به ثانیه
                    $timeInSeconds = $timeInMinutes * 60;

                    // تبدیل ثانیه به دقیقه و ثانیه
                    $minutes = floor($timeInSeconds / 60);
                    $seconds = $timeInSeconds % 60;
                    ?>

                    <div class="cursor-pointer bg-slate-200 hover:shadow-lg min-h-[12rem] max-h-[207px] md:max-h-[430px] rounded-md shadow-md col-span-2 row-span-2 col-start-2 row-start-1 relative overflow-hidden">
                        <a class="cursor-pointer" href="<?php the_permalink(); ?>">

                            <div class="h-full w-full">

                                <?php

                                if (has_post_thumbnail()) { ?>
                                    <img class="w-full h-full object-cover max-h-[427px]" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                                <?php } else { ?>
                                    <img class="w-full h-full object-cover max-h-[427px]" src=" <?php echo get_template_directory_uri(); ?>/inc/img/replace-banner.webp " alt="<?php echo esc_attr($alt_text); ?>">
                                <?php } ?>




                                <span class="backdrop-blur-sm bg-gradient-to-b from-transparent to-black/50 min-h-[5rem] max-h-[10rem] w-full text-base text-white font-bold px-3 flex justify-start items-center bg-black bg-opacity-40 absolute bottom-0">

                                    <?php the_title(); ?>

                                </span>

                                <span class="flex items-center justify-center absolute top-3 left-3 text-xs text-gray-800 font-thin backdrop-blur-sm bg-white/50 h-6 w-max px-1 rounded-md">
                                    <?php if ($minutes > 0 && $seconds > 0) {
                                        echo "زمان خواندن: $minutes دقیقه و $seconds ثانیه";
                                    } elseif ($minutes > 0 && $seconds == 0) {
                                        echo "زمان خواندن: $minutes دقیقه";
                                    } elseif ($minutes == 0) {
                                        echo "زمان خواندن: $seconds ثانیه";
                                    }
                                    ?>
                                </span>

                            </div>
                        </a>
                    </div>


                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            <?php endif; ?>



            <?php
            $args_top_blog_grid = array(
                'offset' => 3,
                'posts_per_page' => 1,
            );

            $the_query_top_blog_grid = new WP_Query($args_top_blog_grid); ?>

            <?php if ($the_query_top_blog_grid->have_posts()) : ?>
                <?php while ($the_query_top_blog_grid->have_posts()) :  $the_query_top_blog_grid->the_post(); ?>


                    <?php

                    $content = get_the_content();

                    // تعداد کاراکتر‌های محتوا را محاسبه
                    $totalCharacters = mb_strlen($content);


                    // محاسبه تعداد کلمه‌ها
                    $totalWords = ceil($totalCharacters / $charactersPerWord);

                    // محاسبه زمان لازم بر اساس میانگین سرعت خواندن
                    $timeInMinutes = $totalWords / $averageReadingSpeed;

                    // تبدیل به ثانیه
                    $timeInSeconds = $timeInMinutes * 60;

                    // تبدیل ثانیه به دقیقه و ثانیه
                    $minutes = floor($timeInSeconds / 60);
                    $seconds = $timeInSeconds % 60;
                    ?>

                    <div class="cursor-pointer bg-slate-200 hover:shadow-lg min-h-[12rem] max-h-[207px] rounded-md shadow-md col-start-4 row-start-1 relative overflow-hidden">
                        <a class="cursor-pointer" href="<?php the_permalink(); ?>">

                            <div class="h-full w-full">

                                <?php

                                if (has_post_thumbnail()) { ?>
                                    <img class="w-full h-full object-cover" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                                <?php } else { ?>
                                    <img class="w-full h-full object-cover" src=" <?php echo get_template_directory_uri(); ?>/inc/img/replace-banner.webp " alt="<?php echo esc_attr($alt_text); ?>">
                                <?php } ?>



                                <span class="backdrop-blur-sm bg-gradient-to-b from-transparent to-black/50 min-h-[5rem] max-h-[10rem] w-full text-base text-white font-bold px-3 flex justify-start items-center bg-black bg-opacity-40 absolute bottom-0">

                                    <?php the_title(); ?>

                                </span>

                                <span class="flex items-center justify-center absolute top-3 left-3 text-xs text-gray-800 font-thin backdrop-blur-sm bg-white/50 h-6 w-max px-1 rounded-md">
                                    <?php if ($minutes > 0 && $seconds > 0) {
                                        echo "زمان خواندن: $minutes دقیقه و $seconds ثانیه";
                                    } elseif ($minutes > 0 && $seconds == 0) {
                                        echo "زمان خواندن: $minutes دقیقه";
                                    } elseif ($minutes == 0) {
                                        echo "زمان خواندن: $seconds ثانیه";
                                    }
                                    ?>
                                </span>

                            </div>
                        </a>
                    </div>


                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            <?php endif; ?>




            <?php
            $args_top_blog_grid = array(
                'offset' => 4,
                'posts_per_page' => 1,
            );

            $the_query_top_blog_grid = new WP_Query($args_top_blog_grid); ?>

            <?php if ($the_query_top_blog_grid->have_posts()) : ?>
                <?php while ($the_query_top_blog_grid->have_posts()) :  $the_query_top_blog_grid->the_post(); ?>


                    <?php

                    $content = get_the_content();

                    // تعداد کاراکتر‌های محتوا را محاسبه
                    $totalCharacters = mb_strlen($content);


                    // محاسبه تعداد کلمه‌ها
                    $totalWords = ceil($totalCharacters / $charactersPerWord);

                    // محاسبه زمان لازم بر اساس میانگین سرعت خواندن
                    $timeInMinutes = $totalWords / $averageReadingSpeed;

                    // تبدیل به ثانیه
                    $timeInSeconds = $timeInMinutes * 60;

                    // تبدیل ثانیه به دقیقه و ثانیه
                    $minutes = floor($timeInSeconds / 60);
                    $seconds = $timeInSeconds % 60;
                    ?>

                    <div class="cursor-pointer bg-slate-200 hover:shadow-lg min-h-[12rem] max-h-[207px] rounded-md shadow-md col-start-4 row-start-2 relative overflow-hidden">
                        <a class="cursor-pointer" href="<?php the_permalink(); ?>">

                            <div class="h-full w-full">


                                <?php
                                $alt_text = get_post_meta(get_the_ID(), '_wp_attachment_image_alt', true);

                                if (empty($alt_text)) {
                                    $alt_text = get_the_title();
                                }


                                if (has_post_thumbnail()) { ?>
                                    <img class="w-full h-full object-cover" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                                <?php } else { ?>
                                    <img class="w-full h-full object-cover" src=" <?php echo get_template_directory_uri(); ?>/inc/img/replace-banner.webp " alt="<?php echo esc_attr($alt_text); ?>">
                                <?php } ?>



                                <img class="w-full h-full object-cover" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="">
                                <span class="backdrop-blur-sm bg-gradient-to-b from-transparent to-black/50 min-h-[5rem] max-h-[10rem] w-full text-base text-white font-bold px-3 flex justify-start items-center bg-black bg-opacity-40 absolute bottom-0">

                                    <?php the_title(); ?>

                                </span>

                                <span class="flex items-center justify-center absolute top-3 left-3 text-xs text-gray-800 font-thin backdrop-blur-sm bg-white/50 h-6 w-max px-1 rounded-md">
                                    <?php if ($minutes > 0 && $seconds > 0) {
                                        echo "زمان خواندن: $minutes دقیقه و $seconds ثانیه";
                                    } elseif ($minutes > 0 && $seconds == 0) {
                                        echo "زمان خواندن: $minutes دقیقه";
                                    } elseif ($minutes == 0) {
                                        echo "زمان خواندن: $seconds ثانیه";
                                    }
                                    ?>
                                </span>

                            </div>
                        </a>
                    </div>


                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            <?php endif; ?>





        </div>


        <div class="h-10 w-full text-xl font-bold text-gray-900 border-slate-200 border-b-2 my-10 flex items-center justify-start px-5 md:px-0">
            <span>
                جدیدترین اخبار و مقاله‌ها
            </span>
        </div>


        <div class="flex flex-col justify-center items-center md:flex-row md:justify-between md:items-start gap-6">






            <div class="h-auto basis-9/12">


                <div class="flex flex-wrap gap-4 px-5 md:p-0">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">


                        <?php
                        $args_top_blog_grid = array(
                            'offset' => 5,
                            // 'posts_per_page' => 4, // تعداد مطالب در هر صفحه
                        );

                        $the_query_top_blog_grid = new WP_Query($args_top_blog_grid); ?>

                        <?php if ($the_query_top_blog_grid->have_posts()) : ?>
                            <?php while ($the_query_top_blog_grid->have_posts()) :  $the_query_top_blog_grid->the_post(); ?>
                                <!-- کد نمایش مطالب -->

                                <?php

                                $content = get_the_content();

                                // تعداد کاراکتر‌های محتوا را محاسبه
                                $totalCharacters = mb_strlen($content);


                                // محاسبه تعداد کلمه‌ها
                                $totalWords = ceil($totalCharacters / $charactersPerWord);

                                // محاسبه زمان لازم بر اساس میانگین سرعت خواندن
                                $timeInMinutes = $totalWords / $averageReadingSpeed;

                                // تبدیل به ثانیه
                                $timeInSeconds = $timeInMinutes * 60;

                                // تبدیل ثانیه به دقیقه و ثانیه
                                $minutes = floor($timeInSeconds / 60);
                                $seconds = $timeInSeconds % 60;
                                ?>


                                <a class="cursor-pointer block h-auto" href="<?php the_permalink(); ?>">
                                    <div class="relative aspect-w-16 aspect-h-9 border-2 rounded-md border-slate-200 inline-block hover:shadow-lg h-[368px]">
                                        <div class="relative">


                                            <?php

                                            if (has_post_thumbnail()) { ?>
                                                <img class="w-full object-cover rounded-md max-h-[220px]" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                                            <?php } else { ?>
                                                <img class="w-full object-cover rounded-md max-h-[220px]" src=" <?php echo get_template_directory_uri(); ?>/inc/img/replace.webp " alt="<?php echo esc_attr($alt_text); ?>">
                                            <?php } ?>


                                            <div class="flex items-center justify-center absolute top-3 left-3 text-xs text-gray-800 font-thin backdrop-blur-sm bg-white/50 h-6 w-max px-1 rounded-md">
                                                <span class="text-sm text-gray-900 bg-slate-100 p-1 rounded-md">
                                                    <?php if ($minutes > 0 && $seconds > 0) {
                                                        echo "زمان خواندن: $minutes دقیقه و $seconds ثانیه";
                                                    } elseif ($minutes > 0 && $seconds == 0) {
                                                        echo "زمان خواندن: $minutes دقیقه";
                                                    } elseif ($minutes == 0) {
                                                        echo "زمان خواندن: $seconds ثانیه";
                                                    }
                                                    ?>

                                                    <?php

                                                    ?>
                                                </span>
                                            </div>
                                        </div>
                                        <div class="text-gray-900 text-base bg-slate-50 p-2 inline-block">
                                            <span class="font-bold overflow-hidden text-ellipsis whitespace-normal line-clamp-1">
                                                <?php the_title(); ?>
                                            </span>
                                            <div class="w-full py-4">
                                                <p class="overflow-hidden text-ellipsis whitespace-normal line-clamp-3">
                                                    <?php echo get_the_excerpt(); ?>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </a>





                            <?php endwhile; ?>


                            <!-- Pagination Code -->
                            <!-- باید مشکل آن رفع گردد -->
                            <!-- Pagination Code End -->

                        <?php endif; ?>






















                    </div>
                </div>















            </div>









            <!-- تبلیغات -->
            <div class="h-auto md:basis-3/12 w-full px-5 md:px-0 flex flex-col gap-4">


                <?php
                // تعداد آرایه‌ها
                $numArrays = count($data_var_option_theme['img_slider_desktop_tax']);
                // حلقه برای نمایش آرایه‌ها
                for ($i = 0; $i < $numArrays; $i++) {
                ?>

                    <div class="w-full h-[280px] rounded-md shadow-md overflow-hidden">



                        <?php
                        // دریافت شناسه پست
                        $post_id = get_the_ID();

                        // دریافت متن جایگزین تصویر شاخص
                        $alt_text = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);

                        // اگر متن جایگزین خالی بود، از عنوان پست استفاده کن
                        if (empty($alt_text)) {
                            $alt_text = get_the_title();
                        }

                        // چاپ کد HTML تصویر
                        ?>




                        <?php

                        if ($data_var_option_theme['img_slider_desktop_tax'][$i]['url']) { ?>
                            <img class="w-full h-full object-cover" src="<?php echo $data_var_option_theme['img_slider_desktop_tax'][$i]['url']; ?>" alt="<?php echo esc_attr($alt_text); ?>">
                        <?php } else { ?>
                            <img class="w-full h-full object-cover" src=" <?php echo get_template_directory_uri(); ?>/inc/img/replace.webp " alt="<?php echo esc_attr($alt_text); ?>">
                        <?php } ?>


                    </div>


                <?php } ?>



            </div>





        </div>
    </div>

</div>

<?php get_footer(); ?>