<?php
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'تنظیمات اصلی قالب',
        'id'               => 'basic',
        'customizer_width' => '40px',
        'icon'             => 'el el-home',
    )
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'لوگو وبسایت',
        'id'               => 'basic_logo',
        'icon'             => 'el el-home',
        'subsection'       => true,
        'fields'           =>     array(
            array(
                'id'       => 'header-logo',
                'type'     => 'media',
                'url'      => true,
                'title'    => 'تغییر لوگو هدر',
                'desc'     => 'در اینجا می توانید لوگو برای درج در هدر را اضافه کنید - سایز استاندارد لوگو قالب 757*1580 پیکسل است',
            ),
            array(
                'id'       => 'footer-logo',
                'type'     => 'media',
                'url'      => true,
                'title'    => 'تغییر لوگو فوتر',
                'desc'     => 'در اینجا می توانید لوگو انگلیسی برای درج در فوتر را اضافه کنید - سایز استاندارد لوگو قالب 757*1580 پیکسل است',
            ),
        ),
    ),
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'فاوآیکون',
        'id'               => 'basic_logo_favicon',
        'icon'             => 'el el-home',
        'subsection'       => true,
        'fields'           =>     array(
            array(
                'id'       => 'header-logo_favicon',
                'type'     => 'media',
                'url'      => true,
                'title'    => 'تغییر فاوآیکون',
                'desc'     => 'در اینجا می توانید لوگو برای درج در فاوآیکون را اضافه کنید - سایز استاندارد لوگو قالب فاوآیکون پیکسل است',
            ),
        ),
    ),
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'شماره تماس پشتیبانی رفع مشکلات',
        'id'               => 'Support_contact_number_to_solve_problems',
        'icon'             => 'el el-home',
        'desc'     => 'در بعضی از بخش های وبسایت شما یک شماره قرار می گیرد که در صورت عیب در سایت یا مشکلات کاربر، با شما تماس گرفته می شود. پشتیبانی این شماره تماس در دست یک فرد متخصص باشد.',
        'subsection'       => true,
        'fields'           =>     array(
            array(
                'id'       => 'Support_contact_number_to_solve_problems_text',
                'type'     => 'text',
                'title'    => 'شماره تماس رفع مشکلات سایت',
            ),
            array(
                'id'       => 'Support_header_contact_number_to_solve_problems_text',
                'type'     => 'text',
                'title'    => 'شماره تماس پشتیبانی سریع',
            ),
        ),
    ),
);
// Redux::set_section(
//     $opt_name,
//     array(
//         'id'               => 'select_category_main_page_display_product',
//         'type'     => 'select',
//         'multi'    => true,
//         'title'            => 'انتخاب دسته بندی خانه',
//         'desc'     => 'نام دسته بندی هایی که در صفحه اصلی در زیر اسلایدر میخواهید نمایش داده شوند را وارد کنید.',
//         //Must provide key => value pairs for radio options
//         'options' => $options,
//         // 'default'  => array('2', '3')
//     )
// );
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'پست تک',
        'id'               => 'social_netw_singe_post',
        'icon'             => 'el el-home',
        'subsection'       => true,
        'fields'           => array(
            array(
                'id'               => 'switch-learn-phy_singe_post',
                'type'             => 'switch',
                'title'            => 'نمایش برچسب ها',
                'desc'     => 'ایا میخواهید در صفحه تک محصول، برچسب ها هم نمایش داده شوند؟',
                'default'          => false,
                'on' => 'فعال',
                'off' => 'غیرفعال'
            ),
            array(
                'id'               => 'switch-learn-phy_category_singe_post',
                'type'             => 'switch',
                'title'            => 'نمایش دسته بندی ها',
                'desc'     => 'ایا میخواهید در صفحه تک محصول، دسته بندی ها هم نمایش داده شوند؟',
                'default'          => false,
                'on' => 'فعال',
                'off' => 'غیرفعال'
            ),
            array(
                'id'               => 'switch-learn-phy_monthly_singe_post',
                'type'             => 'switch',
                'title'            => 'نمایش بر اساس ماه های انتشار',
                'desc'     => 'ایا میخواهید در صفحه تک محصول، ماه های انتشار هم نمایش داده شوند؟',
                'default'          => false,
                'on' => 'فعال',
                'off' => 'غیرفعال'
            ),
            array(
                'id'               => 'switch_learn_phy_Latest_articles_singe_post',
                'type'             => 'switch',
                'title'            => 'نمایش 5 مقاله آخر ارائه شده',
                'desc'     => 'ایا میخواهید در صفحه تک محصول، 5 مقاله آخر نمایش داده شوند؟',
                'default'          => false,
                'on' => 'فعال',
                'off' => 'غیرفعال'
            ),
        ),
    ),
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'آیکون شبکه های مجازی',
        'id'               => 'social_network',
        'icon'             => 'el el-home',
        'desc'     => 'لطفا تنها آدرس خود را وارد کنید مثلا: WordPress/ را وارد کنید و نیاز نیست که https://www.facebook.com/WordPress/ را وارد کنید.',
        'subsection'       => true,
        'fields'           =>     array(
            array(
                'id'       => 'social_network_youtube',
                'type'     => 'text',
                'url'      => true,
                'title'    => 'یوتیوب',
            ),
            array(
                'id'       => 'social_network_twitter',
                'type'     => 'text',
                'url'      => true,
                'title'    => 'ایکس',
            ),
            array(
                'id'       => 'social_network_instagram',
                'type'     => 'text',
                'url'      => true,
                'title'    => 'اینستاگرام',
            ),
            array(
                'id'       => 'social_network_linkedin',
                'type'     => 'text',
                'url'      => true,
                'title'    => 'لینکدین',
            ),
            array(
                'id'       => 'social_network_telegram',
                'type'     => 'text',
                'url'      => true,
                'title'    => 'تلگرام',
            ),
            array(
                'id'       => 'social_network_facebook',
                'type'     => 'text',
                'url'      => true,
                'title'    => 'فیسبوک',
            ),
            array(
                'id'       => 'social_network_aparat',
                'type'     => 'text',
                'url'      => true,
                'title'    => 'آپارات',
            ),
        ),
    ),
);
Redux::setSection($opt_name, array(
    'title'             => __('آیتم های فروش'),
    'id'                => 'add_item_for_sale',
    'desc'              => __('این موارد بصورت لیست در صفحه محصول نمایش داده می شوند'),
    'icon'              => 'dashicons dashicons-dashboard',
    'subsection'       => true,
    'fields'            => array(
        array(
            'id'         => 'repeater-field-add_item_for_sale',
            'type'       => 'repeater',
            'title'      => __('موارد دلخواه را وارد کنید', 'redux-framework-demo'),
            'subtitle'   => __('', 'redux-framework-demo'),
            'desc'       => __('', 'redux-framework-demo'),
            //'group_values' => true, // Group all fields below within the repeater ID
            'item_name' => 'آیتم های بازاریابی', // Add a repeater block name to the Add and Delete buttons
            'bind_title' => 'وارد کردن آیتم ها', // Bind the repeater block title to this field ID
            //'static'     => 2, // Set the number of repeater blocks to be output
            'limit' => 10000000, // Limit the number of repeater blocks a user can create
            //'sortable' => false, // Allow the users to sort the repeater blocks or not
            'fields'     => array(
                array(
                    'id'          => 'title_field_add_item_for_sale',
                    'title'            => 'متن مورد نظر خود را وارد کنید',
                    'type'        => 'text',
                ),
            )
        )
    )
));
Redux::setSection($opt_name, array(
    'title'             => __('نکات مهم دوره های آموزشی'),
    'id'                => 'add_item_for_sale_note',
    'desc'              => __('این موارد بصورت لیست در صفحه محصول آموزشی نمایش داده می شوند'),
    'icon'              => 'dashicons dashicons-dashboard',
    'subsection'       => true,
    'fields'            => array(
        array(
            'id'         => 'repeater-field-add_item_for_sale_note',
            'type'       => 'repeater',
            'title'      => __('موارد دلخواه را وارد کنید', 'redux-framework-demo'),
            'subtitle'   => __('', 'redux-framework-demo'),
            'desc'       => __('', 'redux-framework-demo'),
            //'group_values' => true, // Group all fields below within the repeater ID
            'item_name' => 'نکات مهم دوره های آموزشی', // Add a repeater block name to the Add and Delete buttons
            'bind_title' => 'وارد کردن آیتم ها', // Bind the repeater block title to this field ID
            //'static'     => 2, // Set the number of repeater blocks to be output
            'limit' => 10, // Limit the number of repeater blocks a user can create
            //'sortable' => false, // Allow the users to sort the repeater blocks or not
            'fields'     => array(
                array(
                    'id'          => 'title_field_add_item_for_sale_note',
                    'title'            => 'متن مورد نظر خود را وارد کنید',
                    'type'        => 'text',
                ),
            )
        )
    )
));
Redux::setSection($opt_name, array(
    'title'             => __('بنر در موبایل'),
    'id'                => 'img_slider_mobile_repeater_main',
    'desc'              => __('بنر های انتخابی بصورت اختصاصی در اسلایدر موبایل نمایش داده می شوند.'),
    'icon'              => 'dashicons dashicons-dashboard',
    'subsection'       => true,
    'fields'            => array(
        array(
            'id'         => 'img_slider_mobile_repeater',
            'type'       => 'repeater',
            'title'      => __('عکس دلخواه را انتخاب کنید', 'redux-framework-demo'),
            'subtitle'   => __('', 'redux-framework-demo'),
            'desc'       => __('', 'redux-framework-demo'),
            //'group_values' => true, // Group all fields below within the repeater ID
            'item_name' => 'آیتم های بازاریابی', // Add a repeater block name to the Add and Delete buttons
            'bind_title' => 'وارد کردن آیتم ها', // Bind the repeater block title to this field ID
            //'static'     => 2, // Set the number of repeater blocks to be output
            'limit' => 10, // Limit the number of repeater blocks a user can create
            //'sortable' => false, // Allow the users to sort the repeater blocks or not
            'fields'     => array(
                array(
                    'id'       => 'img_slider_mobile',
                    'type'     => 'media',
                    'title'    => 'اضافه کردن بنر دلخواه',
                    'desc'     => 'سایز استاندارد 640 عرض و 480 ارتفاع است.',
                ),
                array(
                    'id'       => 'img_slider_mobile_text_url_tag_a',
                    'type'     => 'text',
                    'title'    => 'آدرس اینترنتی برای انتقال به صفحه دلخواه',
                ),
                array(
                    'id'       => 'img_slider_mobile_text',
                    'type'     => 'text',
                    'title'    => 'نام عکس برای alt را وراد کنید',
                ),
            )
        )
    )
));
Redux::setSection($opt_name, array(
    'title'             => __('بنر در دسکتاپ'),
    'id'                => 'img_slider_desktop_repeater_main',
    'desc'              => __('بنر های انتخابی بصورت اختصاصی در اسلایدر دسکتاپ نمایش داده می شوند.'),
    'icon'              => 'dashicons dashicons-dashboard',
    'subsection'       => true,
    'fields'            => array(
        array(
            'id'         => 'img_slider_desktop_repeater',
            'type'       => 'repeater',
            'title'      => __('عکس دلخواه را انتخاب کنید', 'redux-framework-demo'),
            'subtitle'   => __('', 'redux-framework-demo'),
            'desc'       => __('', 'redux-framework-demo'),
            //'group_values' => true, // Group all fields below within the repeater ID
            'item_name' => 'آیتم های بازاریابی', // Add a repeater block name to the Add and Delete buttons
            'bind_title' => 'وارد کردن آیتم ها', // Bind the repeater block title to this field ID
            //'static'     => 2, // Set the number of repeater blocks to be output
            'limit' => 1000, // Limit the number of repeater blocks a user can create
            //'sortable' => false, // Allow the users to sort the repeater blocks or not
            'fields'     => array(
                array(
                    'id'       => 'img_slider_desktop',
                    'type'     => 'media',
                    'title'    => 'اضافه کردن بنر دلخواه',
                    'desc'     => 'سایز استاندارد 640 عرض و 480 ارتفاع است.',
                ),
                array(
                    'id'       => 'img_slider_desktop_editor__title',
                    'type'     => 'text',
                    'title'    => 'توضیحات بنر صفحه اصلی',
                    'desc'     => 'در اینجا متن دلخواه برای نمایش در بنر در صفحه اصلی را وارد کنید.',
                    'media_buttons'  => true,
                    'tabindex'  => true,
                ),
                array(
                    'id'       => 'img_slider_desktop_text_url_tag_a',
                    'type'     => 'text',
                    'title'    => 'آدرس اینترنتی برای انتقال به صفحه دلخواه',
                ),
                array(
                    'id'       => 'img_slider_desktop_text',
                    'type'     => 'text',
                    'title'    => 'نام عکس برای alt را وراد کنید',
                ),
            )
        )
    )
));
Redux::setSection($opt_name, array(
    'title'       => __('شبکه‌های مجازی چسبان در پایین', 'your-textdomain'),
    'id'          => 'sticky_social_networks_at_the_bottom',
    'desc'        => __('در ادامه می توانید لینک دقیق شبکه های مجازی خود را قراردهید', 'your-textdomain'),
    'icon'        => 'dashicons dashicons-dashboard',
    'subsection'  => true,
    'fields'      => array(
        array(
            'id'       => 'sticky_social_networks_at_the_bottom_telegram_name',
            'type'     => 'text',
            'title'    => __('نام دلخوام کانال تلگرام', 'your-textdomain'),
        ),
        array(
            'id'       => 'sticky_social_networks_at_the_bottom_telegram',
            'type'     => 'text',
            'title'    => __('آدرس دقیق کانال تلگرام', 'your-textdomain'),
        ),
        array(
            'id'       => 'sticky_social_networks_at_the_bottom_telegram_media',
            'type'     => 'media',
            'title'    => __('تصویر تلگرام', 'your-textdomain'),
        ),
        array(
            'id'       => 'sticky_social_networks_at_the_bottom_wp_name',
            'type'     => 'text',
            'title'    => __('نام دلخوام واتس اپ', 'your-textdomain'),
        ),
        array(
            'id'       => 'sticky_social_networks_at_the_bottom_wp',
            'type'     => 'text',
            'title'    => __('شماره دقیق واتس اپ', 'your-textdomain'),
        ),
        array(
            'id'       => 'sticky_social_networks_at_the_bottom_wp_media',
            'type'     => 'media',
            'title'    => __('تصویر واتس اپ', 'your-textdomain'),
        ),
        array(
            'id'       => 'sticky_social_networks_at_the_bottom_ita_name',
            'type'     => 'text',
            'title'    => __('نام دلخوام ایتا برای نمایش در سایت', 'your-textdomain'),
        ),
        array(
            'id'       => 'sticky_social_networks_at_the_bottom_ita',
            'type'     => 'text',
            'title'    => __('نام کاربری دقیق ایتا', 'your-textdomain'),
        ),
        array(
            'id'       => 'sticky_social_networks_at_the_bottom_ita_media',
            'type'     => 'media',
            'title'    => __('تصویر ایتا', 'your-textdomain'),
        ),
        array(
            'id'       => 'sticky_social_networks_at_the_bottom_call_name',
            'type'     => 'text',
            'title'    => __('نام دلخوام تماس', 'your-textdomain'),
        ),
        array(
            'id'       => 'sticky_social_networks_at_the_bottom_call',
            'type'     => 'text',
            'title'    => __('شماره تماس', 'your-textdomain'),
        ),
        array(
            'id'       => 'sticky_social_networks_at_the_bottom_call_media',
            'type'     => 'media',
            'title'    => __('تصویر تماس', 'your-textdomain'),
        ),
    ),
));
Redux::setSection($opt_name, array(
    'title'             => __('معرفی محصولات مهم در خانه'),
    'id'                => 'introducing_important_products_for_home_repeater',
    'desc'              => __('بنر های انتخابی بصورت اختصاصی در صغحه آرشیو مقالات نمایش داده می شوند.'),
    'icon'              => 'dashicons dashicons-dashboard',
    'subsection'       => true,
    'fields'            => array(
        array(
            'id'       => 'introducing_important_products_for_home_title',
            'type'     => 'text',
            'title'    => 'عنوان را وارد کنید',
        ),
        array(
            'id'       => 'introducing_important_products_for_home_title_des',
            'type'     => 'editor',
            'title'    => 'توضیحات را وارد کنید',
        ),
        array(
            'id'         => 'introducing_important_products_for_home_tax',
            'type'       => 'repeater',
            'title'      => __('عکس دلخواه را انتخاب کنید', 'redux-framework-demo'),
            'subtitle'   => __('', 'redux-framework-demo'),
            'desc'       => __('', 'redux-framework-demo'),
            //'group_values' => true, // Group all fields below within the repeater ID
            'item_name' => '  عکس های تبلیغاتی', // Add a repeater block name to the Add and Delete buttons
            'bind_title' => 'وارد کردن آیتم ها', // Bind the repeater block title to this field ID
            //'static'     => 2, // Set the number of repeater blocks to be output
            'limit' => 10, // Limit the number of repeater blocks a user can create
            //'sortable' => false, // Allow the users to sort the repeater blocks or not
            'fields'     => array(
                array(
                    'id'       => 'introducing_important_products_for_home_text',
                    'type'     => 'text',
                    'title'    => 'اضافه کردن متن دلخواه',
                ),
                array(
                    'id'       => 'introducing_important_products_for_home_description',
                    'type'     => 'editor',
                    'title'    => 'اضافه کردن متن دلخواه',
                ),
                array(
                    'id'       => 'introducing_important_products_for_home_img',
                    'type'     => 'media',
                    'title'    => 'اضافه کردن تصویر دلخواه',
                ),
            )
        )
    )
));
Redux::setSection($opt_name, array(
    'title'             => __('تبلیغات آرشیو مقالات'),
    'id'                => 'img_slider_desktop_repeater_main_tax',
    'desc'              => __('بنر های انتخابی بصورت اختصاصی در صغحه آرشیو مقالات نمایش داده می شوند.'),
    'icon'              => 'dashicons dashicons-dashboard',
    'subsection'       => true,
    'fields'            => array(
        array(
            'id'         => 'img_slider_desktop_repeater_tax',
            'type'       => 'repeater',
            'title'      => __('عکس دلخواه را انتخاب کنید', 'redux-framework-demo'),
            'subtitle'   => __('', 'redux-framework-demo'),
            'desc'       => __('', 'redux-framework-demo'),
            //'group_values' => true, // Group all fields below within the repeater ID
            'item_name' => '  عکس های تبلیغاتی', // Add a repeater block name to the Add and Delete buttons
            'bind_title' => 'وارد کردن آیتم ها', // Bind the repeater block title to this field ID
            //'static'     => 2, // Set the number of repeater blocks to be output
            'limit' => 10, // Limit the number of repeater blocks a user can create
            //'sortable' => false, // Allow the users to sort the repeater blocks or not
            'fields'     => array(
                array(
                    'id'       => 'img_slider_desktop_tax',
                    'type'     => 'media',
                    'title'    => 'اضافه کردن بنر دلخواه',
                ),
            )
        )
    )
));
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'غیر فعال کردن فروشگاه',
        'id'               => 'bg_title_disable_store',
        'icon'             => 'el el-home',
        'subsection'       => true,
        'fields'           =>     array(
            array(
                'id'               => 'display-disable_store',
                'title'            => 'فعال/غیر فعال بودن فروشگاه',
                'type'             => 'switch',
                'default'          => false,
                'on' => 'فعال',
                'off' => 'غیرفعال'
            ),
        ),
    ),
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'عکس و متن صفحات',
        'id'               => 'bg-img-text',
        'customizer_width' => '40px',
        'icon'             => 'el el-home',
    )
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => '404',
        'id'               => 'bg_title',
        'icon'             => 'el el-home',
        'subsection'       => true,
        'fields'           =>     array(
            array(
                'id'       => 'editor__title_404',
                'type'     => 'editor',
                'title'    => 'تغییر متن درون صفحه 404',
                'desc'     => 'در اینجا متن دلخواه خود برای صفحه 404 را بنویسید.',
                'media_buttons'  => true,
                'tabindex'  => true,
            ),
            array(
                'id'       => 'bg__title_404',
                'type'     => 'media',
                'title'    => 'تغییر تصویر صفحه 404',
                'desc'     => 'در اینجا می توانید تصویر صفحه 404 را تغییر دهید ',
            ),
        ),
    ),
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'دسته بندی خانه',
        'id'               => 'bg_title_category_woo',
        'icon'             => 'el el-home',
        'subsection'       => true,
        'fields'           =>     array(
            array(
                'id'               => 'display-post-category-in-front-page',
                'title'            => 'فعال/غیر فعال بودن دسته بندی مقالات در صفحه اصلی',
                'type'             => 'switch',
                'default'          => false,
                'on' => 'فعال',
                'off' => 'غیرفعال'
            ),
            array(
                'id'               => 'display-product-category-in-front-page',
                'title'            => 'فعال/غیر فعال بودن دسته بندی محصولات در صفحه اصلی',
                'type'             => 'switch',
                'default'          => false,
                'on' => 'فعال',
                'off' => 'غیرفعال'
            ),
            array(
                'id'       => 'bg__title_category_woo',
                'type'     => 'text',
                'title'    => 'عنوان دسته بندی محصول',
                'desc'     => 'در اینجا متن دلخواه برای عنوان دسته بندی محصولات در صفحه اصلی را وارد کنید.',
            ),
            array(
                'id'       => 'editor__title_category_woo',
                'type'     => 'editor',
                'title'    => 'توضیحات دسته بندی محصول صفحه اصلی',
                'desc'     => 'در اینجا متن دلخواه برای زیر دسته بندی محصولات در صفحه اصلی را وارد کنید.',
                'media_buttons'  => true,
                'tabindex'  => true,
            ),
            array(
                'id'       => 'bg__title_category_post',
                'type'     => 'text',
                'title'    => 'عنوان دسته بندی مقالات',
                'desc'     => 'در اینجا متن دلخواه برای عنوان دسته بندی مقالات در صفحه اصلی را وارد کنید.',
            ),
            array(
                'id'       => 'editor__title_category_post',
                'type'     => 'editor',
                'title'    => 'توضیحات دسته بندی مقالات صفحه اصلی',
                'desc'     => 'در اینجا متن دلخواه برای زیر دسته بندی مقالات در صفحه اصلی را وارد کنید.',
                'media_buttons'  => true,
                'tabindex'  => true,
            ),
        ),
    ),
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'تماس سریع',
        'id'               => 'bg_title_call_woo',
        'icon'             => 'el el-home',
        'subsection'       => true,
        'fields'           =>     array(
            array(
                'id'       => 'bg__title_call_woo',
                'type'     => 'text',
                'title'    => 'عنوان تماس سریع',
                'desc'     => 'در اینجا متن دلخواه برای عنوان تماس سریع در صفحه اصلی را وارد کنید.',
            ),
            array(
                'id'       => 'editor__title_call_woo',
                'type'     => 'editor',
                'title'    => 'توضیحات تماس سریع صفحه اصلی',
                'desc'     => 'در اینجا متن دلخواه برای توضیحات تماس سریع در صفحه اصلی را وارد کنید.',
                'media_buttons'  => true,
                'tabindex'  => true,
            ),
            array(
                'id'       => 'bg__title_call_number',
                'type'     => 'text',
                'title'    => 'شماره تماس (بدون صفر)',
                'desc'     => 'بصورت خودکار +98 ابتدای شماره قرار می گیرد. شما بدون 0 شماره خود را وارد کنید. مثلا: 9385330363 یا 2191011246.',
            ),
            array(
                'id'       => 'bg__title_call_number_text',
                'type'     => 'text',
                'title'    => 'عنوان دکمه تماس سریع',
                'desc'     => 'در اینجا متن دلخواه برای عنوان تماس سریع در صفحه اصلی را وارد کنید.',
            ),
        ),
    ),
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'عنوان مقاله خانه',
        'id'               => 'bg_title_home',
        'icon'             => 'el el-home',
        'subsection'       => true,
        'fields'           =>     array(
            array(
                'id'       => 'bg__title__home',
                'type'     => 'text',
                'title'    => 'عنوان آخرین مقالات',
            ),
            array(
                'id'       => 'editor__title__home_des',
                'type'     => 'editor',
                'title'    => 'توضیحات آخرین مقالات صفحه اصلی',
                'media_buttons'  => true,
                'tabindex'  => true,
            ),
        ),
    ),
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'بنر میانی خانه',
        'id'               => 'bg_mdu_home_page',
        'icon'             => 'el el-home',
        'subsection'       => true,
        'fields'           =>     array(
            array(
                'id'       => 'bg__title_mdu_home_page_desktop',
                'type'     => 'media',
                'title'    => 'بنر دسکتاپ را وارد کنید',
                'desc'     => 'بنر مربوط به نمایش در حالت دسکتاپ را می توانید در این حالت نمایش دهید',
            ),
            array(
                'id'       => 'bg__title_mdu_home_page_desktop_url_tag_a',
                'type'     => 'text',
                'title'    => 'آدرس اینترنتی برای انتقال به صفحه دلخواه',
            ),
            array(
                'id'       => 'bg__title_mdu_home_page_mobile',
                'type'     => 'media',
                'title'    => 'بنر موبایل را وارد کنید',
                'desc'     => 'بنر مربوط به نمایش در حالت موبایل را می توانید در این حالت نمایش دهید',
            ),
        ),
    ),
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'همکاری در خانه',
        'id'               => 'bg_title_home_work',
        'icon'             => 'el el-home',
        'subsection'       => true,
        'fields'           =>     array(
            array(
                'id'       => 'bg__title__home_work',
                'type'     => 'text',
                'title'    => 'عنوان بخش',
            ),
            array(
                'id'       => 'editor__title__home__work',
                'type'     => 'editor',
                'title'    => 'توضیحات بخش همکاران',
                'media_buttons'  => true,
                'tabindex'  => true,
            ),
            array(
                'id'         => 'img_slider_mobile_repeater__home__work',
                'type'       => 'repeater',
                'title'      => __('عکس دلخواه را انتخاب کنید', 'redux-framework-demo'),
                'subtitle'   => __('', 'redux-framework-demo'),
                'desc'       => __('', 'redux-framework-demo'),
                //'group_values' => true, // Group all fields below within the repeater ID
                'item_name' => 'وارد کردن لوگوها', // Add a repeater block name to the Add and Delete buttons
                'bind_title' => 'وارد کردن لوگوها', // Bind the repeater block title to this field ID
                //'static'     => 2, // Set the number of repeater blocks to be output
                'limit' => 100000000, // Limit the number of repeater blocks a user can create
                //'sortable' => false, // Allow the users to sort the repeater blocks or not
                'fields'     => array(
                    array(
                        'id'       => 'img_slider_mobile__home__work',
                        'type'     => 'media',
                        'title'    => 'اضافه کردن لوگو دلخواه',
                        'desc'     => 'سایز استاندارد 200 عرض و 200 ارتفاع است.',
                    ),
                    array(
                        'id'       => 'img_slider_mobile__home__work_text',
                        'type'     => 'text',
                        'title'    => 'عنوان لوگو',
                    ),
                )
            ),
        ),
    ),
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'نظرات خانه',
        'id'               => 'bg_title_home_comment-user',
        'icon'             => 'el el-home',
        'subsection'       => true,
        'fields'           =>     array(
            array(
                'id'       => 'bg__title__home_comment-user',
                'type'     => 'text',
                'title'    => 'عنوان بخش',
            ),
            array(
                'id'       => 'editor__title__home___comment-user',
                'type'     => 'editor',
                'title'    => 'توضیحات بخش نظرات',
                'media_buttons'  => true,
                'tabindex'  => true,
            ),
            array(
                'id'         => 'img_slider__repeater___comment-user',
                'type'       => 'repeater',
                'title'      => __('متن تمام نظرها را وارد کنید', 'redux-framework-demo'),
                'subtitle'   => __('', 'redux-framework-demo'),
                'desc'       => __('', 'redux-framework-demo'),
                //'group_values' => true, // Group all fields below within the repeater ID
                'item_name' => 'وارد کردن نظرات کاربران', // Add a repeater block name to the Add and Delete buttons
                'bind_title' => 'وارد کردن نظرها', // Bind the repeater block title to this field ID
                //'static'     => 2, // Set the number of repeater blocks to be output
                'limit' => 1000000000000, // Limit the number of repeater blocks a user can create
                //'sortable' => false, // Allow the users to sort the repeater blocks or not
                'fields'     => array(
                    array(
                        'id'       => 'img_slider__home___comment-user',
                        'type'     => 'editor',
                        'title'    => 'اضافه کردن نظر دلخواه',
                    ),
                    array(
                        'id'       => 'img_slider__home___comment-user-name',
                        'type'     => 'text',
                        'title'    => 'نام نظر دهنده',
                    ),
                )
            ),
        ),
    ),
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'آیتم های درباره ما',
        'id'               => 'about-us_on',
        'icon'             => 'el el-home',
        'subsection'       => true,
        'fields'           =>     array(
            array(
                'id'         => 'img_slider__repeater___about-us',
                'type'       => 'repeater',
                'title'      => __('متن و عکس صفحه آیتم های پایینی صفحه درباره ما را وارد کنید', 'redux-framework-demo'),
                'subtitle'   => __('', 'redux-framework-demo'),
                'desc'       => __('', 'redux-framework-demo'),
                //'group_values' => true, // Group all fields below within the repeater ID
                'item_name' => 'وارد کردن آیتم های صفحه درباره ما', // Add a repeater block name to the Add and Delete buttons
                'bind_title' => 'وارد کردن صفحه درباره ما', // Bind the repeater block title to this field ID
                //'static'     => 2, // Set the number of repeater blocks to be output
                'limit' => 10, // Limit the number of repeater blocks a user can create
                //'sortable' => false, // Allow the users to sort the repeater blocks or not
                'fields'     => array(
                    array(
                        'id'       => 'img_slider__home__media-about-us',
                        'type'     => 'media',
                        'title'    => 'تصویر هر بخش',
                    ),
                    array(
                        'id'       => 'img_slider__home___about-us-title',
                        'type'     => 'text',
                        'title'    => 'عنوان هر بخش',
                    ),
                    array(
                        'id'       => 'img_slider__home___about-us-sw',
                        'type'     => 'editor',
                        'title'    => 'متن هر بخش',
                        'media_buttons'  => true,
                        'tabindex'  => true,
                    ),
                )
            ),
        ),
    ),
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'بنر انتهایی خانه',
        'id'               => 'bg_mdu_end_home_page',
        'icon'             => 'el el-home',
        'subsection'       => true,
        'fields'           =>     array(
            // array(
            //     'id'       => 'bg__title_mdu_end_home_page',
            //     'type'     => 'media',
            //     'title'    => 'بنر اول را وارد کنید',
            //     'desc'     => 'بنر مربوط به نمایش در حالت دسکتاپ و موبایل را می توانید در این حالت نمایش دهید',
            // ),
            // array(
            //     'id'       => 'bg__title_mdu_end_home_page',
            //     'type'     => 'media',
            //     'title'    => 'بنر دوم را وارد کنید',
            //     'desc'     => 'بنر مربوط به نمایش در حالت دسکتاپ و موبایل را می توانید در این حالت نمایش دهید',
            // ),
            array(
                'id'         => 'img_slider_mobile_repeater__home__work_end_page',
                'type'       => 'repeater',
                'title'      => __('به تعداد دلخواه بنر های خود را وارد کنید', 'redux-framework-demo'),
                'subtitle'   => __('', 'redux-framework-demo'),
                'desc'       => __('', 'redux-framework-demo'),
                //'group_values' => true, // Group all fields below within the repeater ID
                'item_name' => 'وارد کردن بنرها', // Add a repeater block name to the Add and Delete buttons
                'bind_title' => 'وارد کردن بنرها', // Bind the repeater block title to this field ID
                //'static'     => 2, // Set the number of repeater blocks to be output
                'limit' => 10, // Limit the number of repeater blocks a user can create
                //'sortable' => false, // Allow the users to sort the repeater blocks or not
                'fields'     => array(
                    array(
                        'id'       => 'img_slider_mobile__home__work_end_page',
                        'type'     => 'media',
                        'title'    => 'اضافه کردن بنر دلخواه',
                        'desc'     => 'سایز استاندارد 460 عرض و 339 ارتفاع است.',
                    ),
                    array(
                        'id'       => 'img_slider_mobile__home__work_text_end_page_url',
                        'type'     => 'text',
                        'title'    => 'آدرس اینترنتی برای انتقال به صفحه دلخواه',
                    ),
                    array(
                        'id'       => 'img_slider_mobile__home__work_text_end_page',
                        'type'     => 'text',
                        'title'    => 'عنوان بنر',
                    ),
                )
            ),
        ),
    ),
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'درباره ما',
        'id'               => 'about_page',
        'icon'             => 'el el-home',
        'subsection'       => true,
        'fields'           =>     array(
            array(
                'id'       => 'bg__title_about',
                'type'     => 'media',
                'title'    => 'تغییر عکس ',
                'desc'     => 'از این بخش می توانید عکس پس زمینه عنوان در صفحه درباره ما را تغییر دهید',
            ),
            array(
                'id'      => 'bg_arrow_radio_items',
                'type'    => 'radio',
                'title'   => 'انتخاب آیتم دلخواه',
                'desc'     => 'نحوه قرار گیری عکس را از آیتم های زیر انتخاب کنید',
                'data'  => array(
                    'object-position: bottom;' => 'پایین',
                    'object-position: center;' => 'مرکز',
                    'object-position: left;' => 'چپ',
                    'object-position: left bottom;' => 'چپ - پایین',
                    'object-position: left top;' => 'چپ - بالا',
                    'object-position: right;' => 'راست',
                    'object-position: right bottom;' => 'راست - پایین',
                    'object-position: right top;' => 'راست - بالا',
                    'object-position: top;' => 'بالا',
                ),
                'default' => 'object-position: bottom;'
            )
        ),
    ),
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'سوالات متداول',
        'id'               => 'faq_page',
        'icon'             => 'el el-home',
        'subsection'       => true,
        'fields'           =>     array(
            array(
                'id'       => 'bg__title_faq',
                'type'     => 'media',
                'title'    => 'تغییر عکس ',
                'desc'     => 'از این بخش می توانید عکس پس زمینه عنوان در صفحه سوالات متداول را تغییر دهید',
            ),
            array(
                'id'      => 'bg_arrow_radio_items_faq',
                'type'    => 'radio',
                'title'   => 'انتخاب آیتم دلخواه',
                'desc'     => 'نحوه قرار گیری عکس را از آیتم های زیر انتخاب کنید',
                'data'  => array(
                    'object-position: bottom;' => 'پایین',
                    'object-position: center;' => 'مرکز',
                    'object-position: left;' => 'چپ',
                    'object-position: left bottom;' => 'چپ - پایین',
                    'object-position: left top;' => 'چپ - بالا',
                    'object-position: right;' => 'راست',
                    'object-position: right bottom;' => 'راست - پایین',
                    'object-position: right top;' => 'راست - بالا',
                    'object-position: top;' => 'بالا',
                ),
                'default' => 'object-position: bottom;'
            )
        ),
    ),
);
Redux::set_section(
    $opt_name,
    array(
        'title'            => 'صفحه آرشیو محصول',
        'id'               => 'archive_shop_page',
        'icon'             => 'el el-home',
        'subsection'       => true,
        'fields'           =>     array(
            array(
                'id'       => 'bg__title_archive_shop',
                'type'     => 'media',
                'title'    => 'تغییر عکس ',
                'desc'     => 'از این بخش می توانید عکس پس زمینه عنوان در صفحه سوالات متداول را تغییر دهید',
            ),
            array(
                'id'      => 'bg_arrow_radio_items_archive_shop',
                'type'    => 'radio',
                'title'   => 'انتخاب آیتم دلخواه',
                'desc'     => 'نحوه قرار گیری عکس را از آیتم های زیر انتخاب کنید',
                'data'  => array(
                    'object-position: bottom;' => 'پایین',
                    'object-position: center;' => 'مرکز',
                    'object-position: left;' => 'چپ',
                    'object-position: left bottom;' => 'چپ - پایین',
                    'object-position: left top;' => 'چپ - بالا',
                    'object-position: right;' => 'راست',
                    'object-position: right bottom;' => 'راست - پایین',
                    'object-position: right top;' => 'راست - بالا',
                    'object-position: top;' => 'بالا',
                ),
                'default' => 'object-position: bottom;'
            )
        ),
    ),
);
// Change this variable to the opt_name of YOUR project.
// Standard metabox.
Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'id'         => 'accordion_page_post_product',
        'title'      => 'تنظیمات سوالات متداول',
        'post_types' => array('page'),
        'position'   => 'normal', // normal, advanced, side.
        'priority'   => 'high',   // high, core, default, low.
        'sections'   => array(
            array(
                'title'  => 'سوالات متداول',
                'id'     => 'accordion_page_post_product-fields',
                'icon'   => 'el-icon-cogs',
                'subsection'       => true,
                'fields'            => array(
                    array(
                        'id'         => 'repeater-field-id-accordion',
                        'type'       => 'repeater',
                        'sortable' => true,
                        // 'title'      => __('Title', 'redux-framework-demo'),
                        // 'subtitle'   => __('', 'redux-framework-demo'),
                        // 'desc'       => __('', 'redux-framework-demo'),
                        //'group_values' => true, // Group all fields below within the repeater ID
                        // 'item_name' => 'مجوز من', // Add a repeater block name to the Add and Delete buttons
                        // 'bind_title' => 'وارد کردن مجوز های اخذ شده', // Bind the repeater block title to this field ID
                        //'static'     => 2, // Set the number of repeater blocks to be output
                        // 'limit' => 10, // Limit the number of repeater blocks a user can create
                        //'sortable' => false, // Allow the users to sort the repeater blocks or not
                        // 'group_values' => true,
                        'fields'     => array(
                            array(
                                'id'          => 'title_field_accordion',
                                'title'            => 'پرسش متداول را در اینجا وارد کنید.',
                                'type'        => 'text',
                            ),
                            array(
                                'id'               => 'editor-text-lic',
                                'type'             => 'editor',
                                'title'            => 'پاسخ به پرسش متداول را می توانید در اینجا وارد کنید.',
                                'default'          => '',
                                'args'   => array(
                                    'teeny'            => false,
                                    'media_buttons'     => true,
                                )
                            ),
                        )
                    )
                ),
            ),
        ),
    )
);
Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'id'         => 'accordion_detail_product',
        'title'      => 'جزئیات محصول',
        'post_types' => array('product'),
        'position'   => 'normal', // normal, advanced, side.
        'priority'   => 'high',   // high, core, default, low.
        'sections'   => array(
            array(
                'title'  => 'سوالات متداول',
                'id'     => 'accordion_detail_product-fields',
                'icon'   => 'el-icon-cogs',
                'subsection'       => true,
                'fields'            => array(
                    array(
                        'id'         => 'repeater-detail-field-id-accordion',
                        'type'       => 'repeater',
                        'sortable' => true,
                        'fields'     => array(
                            array(
                                'id'               => 'editor-detail-text-lic',
                                'type'             => 'textarea',
                                'title'            => 'پاسخ به پرسش متداول را می توانید در اینجا وارد کنید.',
                                'default'          => '',
                                'args'   => array(
                                    'teeny'            => false,
                                    'textarea_rows'    => 5,
                                    'media_buttons'     => true,
                                )
                            ),
                        )
                    )
                ),
            ),
        ),
    )
);
Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'id'         => 'product-learn-switch',
        'title'      => 'آیا محصول آموزشی است؟',
        'post_types' => array('product'),
        'position'   => 'side', // normal, advanced, side.
        'priority'   => 'high',   // high, core, default, low.
        'sections'   => array(
            array(
                'id'     => 'switch-learn-physical-side',
                'fields'            => array(
                    array(
                        'id'               => 'c',
                        'type'             => 'switch',
                        'default'          => false,
                        'on' => 'فعال',
                        'off' => 'غیرفعال'
                    ),
                ),
            ),
        ),
    )
);
Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'id'         => 'page-service-switch',
        'title'      => 'آیا خدمات است؟',
        'post_types' => array('page'),
        'position'   => 'side', // normal, advanced, side.
        'priority'   => 'high',   // high, core, default, low.
        'sections'   => array(
            array(
                'id'     => 'switch__page-service',
                'fields'            => array(
                    array(
                        'id'               => 'switch-page-service-physical',
                        'type'             => 'switch',
                        'default'          => false,
                        'on' => 'فعال',
                        'off' => 'غیرفعال'
                    ),
                ),
            ),
        ),
    )
);
Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'id'         => 'product-learn-switch-position',
        'title'      => 'مرحله ضبط به کجا رسیده؟',
        'post_types' => array('product'),
        'position'   => 'side', // normal, advanced, side.
        'priority'   => 'high',   // high, core, default, low.
        'sections'   => array(
            array(
                'id'     => 'switch-learn-physical-side-position',
                'fields'            => array(
                    array(
                        'id'       => 'level-learn-select-position',
                        'type'     => 'select',
                        'title'    => esc_html__('آیا ضبط کامل شده؟', 'your-textdomain-here'),
                        // Must provide key => value pairs for select options
                        'options'  => array(
                            'در حال برگزاری' => 'درحال برگزاری',
                            ' تکمیل ضبط' => 'تکمیل ضبط ',
                            'پیش فروش' => 'پیش فروش',
                        ),
                        'default'  => 'یک سطح انتخاب کنید',
                    ),
                ),
            ),
        ),
    )
);
// بازاریابی
Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'id'         => 'add_item_for_sale_learn_all_one',
        'title'      => 'آیتم های بازاریابی',
        'post_types' => array('product'),
        'position'   => 'normal', // normal, advanced, side.
        'priority'   => 'high',   // high, core, default, low.
        'sections'   => array(
            array(
                'id'     => 'add_item_for_sale_learn',
                'fields'            => array(
                    array(
                        'id'    => 'title_field_add_item_for_sale_learn_one',
                        'type'  => 'text',
                        'title' => esc_html__('روش دریافت:', 'your-textdomain-here'),
                    ),
                    array(
                        'id'    => 'title_field_add_item_for_sale_learn_send_one',
                        'type'  => 'text',
                        'title' => esc_html__('تاریخ انتشار', 'your-textdomain-here'),
                    ),
                    array(
                        'id'    => 'title_field_add_item_for_sale_learn_update_one',
                        'type'  => 'text',
                        'title' => esc_html__('اخرین بروزرسانی', 'your-textdomain-here'),
                    ),
                    array(
                        'id'    => 'title_field_add_item_for_sale_learn_support_one',
                        'type'  => 'text',
                        'title' => esc_html__('پشتیبانی', 'your-textdomain-here'),
                    ),
                ),
            ),
        ),
    )
);
Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'title' => esc_html__('Repeater Section', 'your-textdomain-here'),
        'post_types' => array('product'),
        'position'   => 'normal', // normal, advanced, side.
        'priority'   => 'high',   // high, core, default, low.
        'icon'  => 'el-icon-thumbs-up',
        'fields' => array(
            array(
                'id'         => 'slides_repeater',
                'type'       => 'repeater',
                'title'      => esc_html__('Slides Repeater', 'your-textdomain-here'),
                'subtitle'   => esc_html__('Add and manage slides', 'your-textdomain-here'),
                'desc'       => esc_html__('This repeater field will store all slides values into a multidimensional array to use in a foreach loop.', 'your-textdomain-here'),
                'fields'     => array(
                    array(
                        'id'    => 'opt-slides',
                        'type'  => 'slides',
                        'title' => esc_html__('Slides Options', 'your-textdomain-here'),
                        // Placeholder values from the original slides field
                        'placeholder' => array(
                            'title'       => esc_html__('This is a title', 'your-textdomain-here'),
                            'description' => esc_html__('Description Here', 'your-textdomain-here'),
                            'url'         => esc_html__('Give us a link!', 'your-textdomain-here'),
                            'title_2'     => esc_html__('Another title', 'your-textdomain-here'),
                            'title_3'     => esc_html__('Yet another title', 'your-textdomain-here'),
                        ),
                    ),
                ),
            ),
        ),
    )
);
Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'id'         => 'video-section',
        'title'      => 'بخش ویدئو',
        'post_types' => array('product'),
        'position'   => 'normal',
        'priority'   => 'high',
        'sections'   => array(
            array(
                'id'     => 'video-details',
                'fields' => array(
                    array(
                        'id'    => 'text_lesson_number',
                        'type'  => 'text',
                        'title' => esc_html__('تعداد جلسات', 'your-textdomain-here'),
                    ),
                    array(
                        'id'    => 'time_lesson_number',
                        'type'  => 'text',
                        'title' => esc_html__('زمان این دوره آموزشی', 'your-textdomain-here'),
                    ),
                    array(
                        'id'       => 'level-learn-select',
                        'type'     => 'select',
                        'title'    => esc_html__('سطح دوه آموزشی را انتخاب کنید', 'your-textdomain-here'),
                        // Must provide key => value pairs for select options
                        'options'  => array(
                            'مقدماتی' => 'مقدماتی',
                            'حرفه ای' => 'حرفه ای',
                            'از مقدماتی تا حرفه ای' => 'از مقدماتی تا حرفه ای',
                        ),
                        'default'  => 'یک سطح انتخاب کنید',
                    ),
                    array(
                        'id'    => 'location_lesson_record',
                        'type'  => 'text',
                        'title' => esc_html__('مکان ضبط دوره آموزشی', 'your-textdomain-here'),
                    ),
                    array(
                        'id'    => 'videos_repeater',
                        'type'  => 'repeater',
                        'limit' => 2000,
                        'title' => esc_html__('لیست ویدئوها', 'your-textdomain-here'),
                        'fields' => array(
                            array(
                                'id'    => 'section_name_part_start',
                                'type'  => 'text',
                                'title' => esc_html__('نام جلسه', 'your-textdomain-here'),
                            ),
                            array(
                                'id'    => 'lesson-spinner',
                                'type'  => 'text',
                                'title' => esc_html__('زمان جلسه ', 'your-textdomain-here'),
                            ),
                            array(
                                'id'    => 'custom_media_learn_product-free-sec',
                                'type'  => 'media',
                                'title' => esc_html__('ویدئو پیش نمایش', 'your-textdomain-here'),
                                'url' => true,
                                'mode' => false,
                                'readonly' => false,
                                'preview' => false,
                                'desc' => esc_html__('آپلود ویدئو پیش نمایش', 'your-textdomain-here'),
                            ),
                            array(
                                'id' => 'custom_media_learn-pooster-free',
                                'type' => 'media',
                                'title' => __('پوستر ویدئو پیش نمایش', 'redux-framework-demo'),
                                'url' => true,
                                'mode' => false,
                                'readonly' => false,
                                'preview' => false,
                                'desc' => __('آپلود پوستر ویدئو', 'redux-framework-demo'),
                                'subtitle' => __('لطفا عکس مورد نظر خود را در اینجا آپلود کنید.', 'redux-framework-demo'),
                            ),
                            array(
                                'id'       => 'free_checkbox',
                                'type'     => 'checkbox',
                                'title'    => esc_html__('ایا نیاز به وارد کردن متن دارید؟', 'your-textdomain-here'),
                                'default'  => '1'
                            ),
                            array(
                                'id'               => 'free-editor-text',
                                'type'             => 'editor',
                                'title'            => esc_html__('متن کوتاه در مورد این جلسه را تایپ کنید', 'your-textdomain-here'),
                                'args'   => array(
                                    'teeny'            => true,
                                    'textarea_rows'    => 10
                                ),
                                'required' => array('free_checkbox', '=', '1'),
                            ),
                        ),
                    ),
                ),
            ),
        ),
    )
);
// آپلود ویدئو پیش نمایش
Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'id'         => 'product-learn-media',
        'title'      => 'آپلود فیلم پیش نمایش',
        'post_types' => array('product'),
        'position'   => 'normal', // normal, advanced, side.
        'priority'   => 'high',   // high, core, default, low.
        'sections'   => array(
            array(
                'id'     => 'media-learn-side',
                'fields'            => array(
                    array(
                        'id' => 'custom_media_learn_product',
                        'type' => 'media',
                        'title' => __('ویدئو پیش نمایش', 'redux-framework-demo'),
                        'url' => true,
                        'mode' => false,
                        'readonly' => false,
                        'preview' => false,
                        'desc' => __('آپلود ویدئو پیش نمایش', 'redux-framework-demo'),
                        'subtitle' => __('لطفا فیلم پیشنمایش مورد نظر خود را در اینجا آپلود کنید.', 'redux-framework-demo'),
                    ),
                    array(
                        'id' => 'custom_media_learn-pooster',
                        'type' => 'media',
                        'title' => __('پوستر ویدئو پیش نمایش', 'redux-framework-demo'),
                        'url' => true,
                        'mode' => false,
                        'readonly' => false,
                        'preview' => false,
                        'desc' => __('آپلود پوستر ویدئو', 'redux-framework-demo'),
                        'subtitle' => __('لطفا عکس مورد نظر خود را در اینجا آپلود کنید.', 'redux-framework-demo'),
                    ),
                ),
            ),
        ),
    )
);
// آپلود عکس مدرس
Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'id'         => 'product-learn-media-te',
        'title'      => 'آپلود عکس مدرس',
        'post_types' => array('product'),
        'position'   => 'normal', // normal, advanced, side.
        'priority'   => 'high',   // high, core, default, low.
        'sections'   => array(
            array(
                'id'     => 'media-learn-side-te',
                'fields'            => array(
                    array(
                        'id' => 'custom_img-te',
                        'type' => 'media',
                        'title' => __('عکس مدرس', 'redux-framework-demo'),
                        'url' => true,
                        'mode' => false,
                        'readonly' => false,
                        'preview' => false,
                        'desc' => __('آپلود عکس مدرس', 'redux-framework-demo'),
                        'subtitle' => __('لطفا عکس مورد نظر خود را در اینجا آپلود کنید.', 'redux-framework-demo'),
                    ),
                ),
            ),
        ),
    )
);
// متن خلاصه برای بالای صفحات خدمت
Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'id'         => 'the_excerpt-contact-service',
        'title'      => 'متن خلاصه برای بالای صفحات خدمت',
        'post_types' => array('page'),
        'position'   => 'normal', // normal, advanced, side.
        'priority'   => 'high',   // high, core, default, low.
        'sections'   => array(
            array(
                'id'     => 'media_the_excerpt-contact-service',
                'fields'            => array(
                    array(
                        'id' => 'custom_text-the_excerpt-contact-service',
                        'type' => 'editor',
                        'title' => __('متن خلاصه', 'redux-framework-demo'),
                        'media_buttons'  => true,
                        'tabindex'  => true,
                        'args'   => array(
                            'teeny'            => false,
                            'dfw'              => true,
                            'tinymce'            => true,
                            'quicktags'              => true,
                        )
                    ),
                ),
            ),
        ),
    )
);
// متن خلاصه برای بالای صفحات خدمت
Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'id'         => 'the_excerpt-contact-service-media-and-text',
        'title'      => 'متن توضیح ارسال و ویدئو معرفی',
        'post_types' => array('page'),
        'position'   => 'normal', // normal, advanced, side.
        'priority'   => 'high',   // high, core, default, low.
        'sections'   => array(
            array(
                'id'     => 'media_text_the_excerpt-contact-service',
                'fields'            => array(
                    array(
                        'id' => 'media_text_the_excerpt-contact-service_send_pro',
                        'type' => 'editor',
                        'title' => __('متن توضیح نحوه ارسال', 'redux-framework-demo'),
                        'media_buttons'  => true,
                        'tabindex'  => true,
                        'args'   => array(
                            'teeny'            => false,
                            'dfw'              => true,
                            'tinymce'            => true,
                            'quicktags'              => true,
                        )
                    ),
                    array(
                        'id'    => 'media_text_the_excerpt-contact-service_video',
                        'type'  => 'media',
                        'title' => esc_html__('ویدئو معرفی خدمت', 'your-textdomain-here'),
                        'url' => true,
                        'mode' => false,
                        'readonly' => false,
                        'preview' => false,
                        'desc' => esc_html__('آپلود ویدئو معرفی خدمت', 'your-textdomain-here'),
                    ),
                    array(
                        'id' => 'media_text_the_excerpt-contact-service_poster',
                        'type' => 'media',
                        'title' => __('پوستر ویدئو پیش نمایش', 'redux-framework-demo'),
                        'url' => true,
                        'mode' => false,
                        'readonly' => false,
                        'preview' => false,
                        'desc' => __('آپلود پوستر ویدئو', 'redux-framework-demo'),
                        'subtitle' => __('لطفا عکس مورد نظر خود را در اینجا آپلود کنید.', 'redux-framework-demo'),
                    ),
                    array(
                        'id' => 'media_text_the_excerpt-contact-service_backgraound-one',
                        'type' => 'media',
                        'title' => __('پس زمینه فرم درخواست', 'redux-framework-demo'),
                        'url' => true,
                        'mode' => false,
                        'readonly' => false,
                        'preview' => false,
                    ),
                    array(
                        'id' => 'media_text_the_excerpt-contact_title-service_short-code',
                        'type' => 'text',
                        'title' => __('عنوان فرم ارسال', 'redux-framework-demo'),
                    ),
                    array(
                        'id' => 'media_text_the_excerpt-contact-service_short-code',
                        'type' => 'text',
                        'title' => __('لطفا شماره ID کانتکت فرم 7 را وارد کنید', 'redux-framework-demo'),
                        'default'  => '0',
                        'min'      => '1',
                        'step'     => '1',
                        'max'      => '1000',
                    ),
                ),
            ),
        ),
    )
);
// آپلود عکس مدرس
Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'id'         => 'product-learn-media-te-name',
        'title'      => 'نام مدرس',
        'post_types' => array('product'),
        'position'   => 'normal', // normal, advanced, side.
        'priority'   => 'high',   // high, core, default, low.
        'sections'   => array(
            array(
                'id'     => 'media-learn-side-te-name',
                'fields'            => array(
                    array(
                        'id' => 'custom-te-name',
                        'type' => 'text',
                        'title' => __('نام مدرس', 'redux-framework-demo'),
                        'url' => true,
                        'mode' => false,
                        'readonly' => false,
                        'preview' => false,
                        'desc' => __(' نام مدرس', 'redux-framework-demo'),
                        'subtitle' => __('لطفا نام مورد نظر خود را در اینجا وارد کنید.', 'redux-framework-demo'),
                    ),
                    array(
                        'id' => 'custom-te-name-bold',
                        'type' => 'text',
                        'title' => __('بخش برجسته اسم و رسم مدرس', 'redux-framework-demo'),
                        'url' => true,
                        'mode' => false,
                        'readonly' => false,
                        'preview' => false,
                        'desc' => __('بخش برجسته معرفی مدرس', 'redux-framework-demo'),
                        'subtitle' => __('لطفا عکس مورد نظر خود را در اینجا آپلود کنید.', 'redux-framework-demo'),
                    ),
                ),
            ),
        ),
    )
);
// Redux_Metaboxes::set_box(
//     $opt_name,
//     array(
//         'id'         => 'switch-learn-physical',
//         'title'    => __('آیا محصول آموزشی است؟'),
//         'post_types' => array('product'),
//         'position'   => 'side', // normal, advanced, side.
//         'priority'   => 'high',   // high, core, default, low.
//         'sections'   => array(
//             $fields = array(
//                 'id'       => 'switch-learn-physical-setup',
//                 'type'     => 'switch',
//                 'title'    => __('آموزشی | فیزیکی'),
//                 'default'  => false,
//             ),
//         ),
//     )
// );
Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'id'         => 'accordion_detail_product_number_in_cart_ase',
        'title'  => 'تعداد در کارتن',
        'post_types' => array('product'),
        'position'   => 'side', // normal, advanced, side.
        'sections'   => array(
            array(
                'title'  => 'تعداد در کارتن',
                'id'     => 'accordion_detail_product-fields_number_in_cart_ase',
                'icon'   => 'el-icon-cogs',
                'subsection'       => true,
                'fields'           =>     array(
                    array(
                        'id'       => 'editor__title_404_number_in_cart_ase',
                        'type'   => 'text',
                        'title'    => 'تعداد در کارتن را وازد کنید',
                        'media_buttons'  => true,
                        'tabindex'  => true,
                    ),
                ),
            ),
        ),
    )
);
