<?php get_header(); ?>


<?php

global $data_var_option_theme;

global $product;

?>


<?php

// تعداد کاراکتر‌ها در هر کلمه
$charactersPerWord = 5;

// میانگین سرعت خواندن کلمه در دقیقه
$averageReadingSpeed = 225;

?>




















<div class="w-screen z-0 my-10">

    <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto md:flex justify-start items-center gap-2 px-5 md:p-0">
        <div class="font-bold text-2xl text-gray-900">

            <h1 class="m-0 p-0">

                <?php
                echo get_the_archive_title();
                ?>

            </h1>
        </div>

    </div>

    <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto">

        <div class="md:flex justify-between">

            <div class="basis-8/12 md:flex md:justify-between md:items-start md:gap-2">


                <div class="h-auto w-full text-lg text-gray-900 my-10 items-center justify-start px-5 md:px-0">


                    <div class="flex flex-col justify-center items-center md:flex-row md:justify-between md:items-start gap-6">

                        <div class="h-auto">

                            <?php if (have_posts()) : ?>
                                <div class="flex flex-wrap gap-4 md:p-0">
                                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                        <?php while (have_posts()) : the_post(); ?>
                                            <a class="cursor-pointer block h-auto" href="<?php the_permalink(); ?>">
                                                <div class="relative aspect-w-16 aspect-h-9 border-2 rounded-md border-slate-200 inline-block hover:shadow-lg h-[368px]">
                                                    <div class="relative">
                                                        <?php
                                                        $alt_text = get_post_meta(get_the_ID(), '_wp_attachment_image_alt', true);
                                                        if (empty($alt_text)) {
                                                            $alt_text = get_the_title();
                                                        }
                                                        if (has_post_thumbnail()) : ?>
                                                            <img class="w-full object-cover rounded-md max-h-[220px]" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                                                        <?php else : ?>
                                                            <img class="w-full object-cover rounded-md max-h-[220px]" src="<?php echo get_template_directory_uri(); ?>/inc/img/replace.webp" alt="<?php echo esc_attr($alt_text); ?>">
                                                        <?php endif; ?>

                                                        <div class="flex items-center justify-center absolute top-3 left-3 text-xs text-gray-800 font-thin backdrop-blur-sm bg-white/50 h-6 w-max px-1 rounded-md">
                                                            <span class="text-sm text-gray-900 bg-slate-100 p-1 rounded-md">
                                                                <?php
                                                                // دستورات if برای $minutes و $seconds اینجا باید اصلاح شود
                                                                if ($minutes > 0 && $seconds > 0) {
                                                                    echo "زمان خواندن: $minutes دقیقه و $seconds ثانیه";
                                                                } elseif ($minutes > 0 && $seconds == 0) {
                                                                    echo "زمان خواندن: $minutes دقیقه";
                                                                } elseif ($minutes == 0) {
                                                                    echo "زمان خواندن: $seconds ثانیه";
                                                                }
                                                                ?>
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="text-gray-900 text-base bg-slate-50 p-2 inline-block">
                                                        <span class="font-bold overflow-hidden text-ellipsis whitespace-normal line-clamp-1">
                                                            <?php the_title(); ?>
                                                        </span>
                                                        <div class="w-full py-4">
                                                            <p class="overflow-hidden text-ellipsis whitespace-normal line-clamp-3">
                                                                <?php echo get_the_excerpt(); ?>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                        <?php endwhile; ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                        </div>
                    </div>

                    <?php
                    // شرط بر اساس نمایش دادن برچسب ها یا نمایش ندادن آنها
                    if ($data_var_option_theme['switch-learn-phy_singe_post'] == 1) { ?>


                        <div class="h-auto">

                            <div class="p-3 mt-4 border-2 border-slate-200 rounded-md">
                                <span class="block pb-2 font-bold border-b-2 border-slate-200 mb-3">
                                    برچسب ها
                                </span>

                                <ul id="" class="flex flex-wrap gap-2 list-none">
                                    <?php
                                    $post_tags = get_the_tags();
                                    if ($post_tags) {
                                        foreach ($post_tags as $tag) {
                                            $tag_link = get_tag_link($tag->term_id);
                                    ?>
                                            <li class="rounded-md bg-slate-200 h-max">
                                                <a href="<?php echo $tag_link; ?>" title="<?php echo $tag->name; ?>" class="p-2 w-max block <?php echo $tag->slug; ?>">
                                                    <?php echo $tag->name; ?>
                                                </a>
                                            </li>
                                    <?php
                                        }
                                    }
                                    ?>
                                </ul>



                            </div>

                        </div>


                    <?php  }   ?>



                </div>

            </div>


            <div class="basis-3/12 my-10 px-5 md:px-0">



                <?php

                // شرط بر اساس نمایش دادن دسته بندی ها یا نمایش ندادن آنها
                if ($data_var_option_theme['switch-learn-phy_category_singe_post'] == 1) { ?>



                    <div class="mt-3 rounded-md overflow-hidden h-auto justify-center items-center flex-wrap p-3 shadow-md">

                        <span class="block pb-2 font-bold border-b-2 border-slate-200 mb-3">
                            دسته بندی ها
                        </span>
                        <ul class="list-none">
                            <?php
                            $categories = get_categories();
                            foreach ($categories as $category) {
                                echo '<li><a href="' . get_category_link($category->term_id) . '">' . $category->name . '</a></li>';
                            }
                            ?>
                        </ul>

                    </div>







                <?php } ?>




                <?php

                // شرط بر اساس نمایش دادن ماه های انتشار یا نمایش ندادن آنها
                if ($data_var_option_theme['switch-learn-phy_monthly_singe_post'] == 1) { ?>



                    <div class="mt-3 rounded-md overflow-hidden h-auto justify-center items-center flex-wrap p-3 shadow-md">

                        <span class="block pb-2 font-bold border-b-2 border-slate-200 mb-3">
                            نمایش بر ماه انتشار
                        </span>

                        <ul class="list-none">
                            <?php
                            $args = array(
                                'type'            => 'monthly',
                                'show_post_count' => false,
                            );
                            wp_get_archives($args);
                            ?>
                        </ul>


                    </div>


                <?php } ?>




                <?php

                // شرط بر اساس نمایش دادن ماه های انتشار یا نمایش ندادن آنها
                if ($data_var_option_theme['switch_learn_phy_Latest_articles_singe_post'] == 1) { ?>

                    <div class="mt-3 rounded-md overflow-hidden h-auto justify-center items-center flex-wrap p-3 shadow-md">

                        <span class="block pb-2 font-bold border-b-2 border-slate-200 mb-3">
                            آخرین مقالات
                        </span>

                        <ul class="list-none">
                            <?php
                            $args = array(
                                'posts_per_page' => 5, // تعداد مقالات
                                'orderby'        => 'date',
                                'order'          => 'DESC',
                            );
                            $recent_posts = get_posts($args);
                            foreach ($recent_posts as $post) :
                                setup_postdata($post);
                            ?>
                                <li class="py-2"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
                            <?php
                            endforeach;
                            wp_reset_postdata();
                            ?>
                        </ul>

                    </div>

                <?php } ?>







            </div>

        </div>

    </div>

</div>






































<?php get_footer(); ?>