/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-12-26 11:21:39 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1602 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=15066 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=4776 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `woo_idx_comment_date_type` (`comment_date_gmt`,`comment_type`,`comment_approved`,`comment_post_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=43497 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6766 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=707 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_rank_math_analytics_gsc` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `query` varchar(1000) NOT NULL,
  `page` varchar(500) NOT NULL,
  `clicks` mediumint(6) NOT NULL,
  `impressions` mediumint(6) NOT NULL,
  `position` double NOT NULL,
  `ctr` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `analytics_query` (`query`(190)),
  KEY `analytics_page` (`page`(190)),
  KEY `clicks` (`clicks`),
  KEY `rank_position` (`position`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_rank_math_analytics_inspections` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `page` varchar(500) NOT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `index_verdict` varchar(64) NOT NULL,
  `indexing_state` varchar(64) NOT NULL,
  `coverage_state` text NOT NULL,
  `page_fetch_state` varchar(64) NOT NULL,
  `robots_txt_state` varchar(64) NOT NULL,
  `rich_results_verdict` varchar(64) NOT NULL,
  `rich_results_items` longtext NOT NULL,
  `last_crawl_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `crawled_as` varchar(64) NOT NULL,
  `google_canonical` text NOT NULL,
  `user_canonical` text NOT NULL,
  `sitemap` text NOT NULL,
  `referring_urls` longtext NOT NULL,
  `raw_api_response` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `analytics_object_page` (`page`(190)),
  KEY `created` (`created`),
  KEY `index_verdict` (`index_verdict`),
  KEY `page_fetch_state` (`page_fetch_state`),
  KEY `robots_txt_state` (`robots_txt_state`),
  KEY `rich_results_verdict` (`rich_results_verdict`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_rank_math_analytics_objects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `title` text NOT NULL,
  `page` varchar(500) NOT NULL,
  `object_type` varchar(100) NOT NULL,
  `object_subtype` varchar(100) NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `primary_key` varchar(255) NOT NULL,
  `seo_score` tinyint(4) NOT NULL DEFAULT 0,
  `page_score` tinyint(4) NOT NULL DEFAULT 0,
  `is_indexable` tinyint(1) NOT NULL DEFAULT 1,
  `schemas_in_use` varchar(500) DEFAULT NULL,
  `desktop_interactive` double DEFAULT 0,
  `desktop_pagescore` double DEFAULT 0,
  `mobile_interactive` double DEFAULT 0,
  `mobile_pagescore` double DEFAULT 0,
  `pagespeed_refreshed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `analytics_object_page` (`page`(190))
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_rank_math_internal_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `target_post_id` (`target_post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_rank_math_internal_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT 0,
  `external_link_count` int(10) unsigned DEFAULT 0,
  `incoming_link_count` int(10) unsigned DEFAULT 0,
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=219 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17314 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`),
  KEY `idx_date_paid_status_parent` (`date_paid`,`status`,`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`),
  KEY `session_expiry` (`session_expiry`)
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("17", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "failed", "2024-12-03 10:44:36", "2024-12-03 10:44:36", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-12-03 10:45:05", "2024-12-03 14:15:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("29", "action_scheduler/migration_hook", "failed", "2024-12-04 09:05:28", "2024-12-04 09:05:28", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1733303128;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1733303128;}", "1", "1", "2024-12-04 09:05:34", "2024-12-04 12:35:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("943", "rank_math/analytics/data_fetch", "failed", "2025-03-26 17:04:00", "2025-03-26 17:04:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743008640;s:18:\"\0*\0first_timestamp\";i:1743008640;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743008640;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "7", "1", "2025-03-26 17:18:50", "2025-03-26 20:48:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("951", "rank_math/analytics/data_fetch", "failed", "2025-04-02 17:18:50", "2025-04-02 17:18:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743614330;s:18:\"\0*\0first_timestamp\";i:1743008640;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743614330;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "7", "1", "2025-04-02 17:26:02", "2025-04-02 20:56:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("966", "rank_math/analytics/data_fetch", "failed", "2025-04-09 17:26:02", "2025-04-09 17:26:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744219562;s:18:\"\0*\0first_timestamp\";i:1743008640;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744219562;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "7", "1", "2025-04-09 17:32:52", "2025-04-09 21:02:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("979", "rank_math/analytics/data_fetch", "failed", "2025-04-16 17:32:52", "2025-04-16 17:32:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744824772;s:18:\"\0*\0first_timestamp\";i:1743008640;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744824772;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "7", "1", "2025-04-16 17:36:33", "2025-04-16 21:06:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("997", "rank_math/analytics/data_fetch", "failed", "2025-04-23 17:36:33", "2025-04-23 17:36:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745429793;s:18:\"\0*\0first_timestamp\";i:1743008640;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745429793;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "7", "1", "2025-04-23 17:42:36", "2025-04-23 21:12:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1442", "woocommerce_cleanup_draft_orders", "complete", "2025-11-26 08:38:49", "2025-11-26 08:38:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764146329;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764146329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-26 08:39:31", "2025-11-26 12:09:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1443", "woocommerce_cleanup_draft_orders", "complete", "2025-11-26 08:38:49", "2025-11-26 08:38:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764146329;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764146329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-26 08:39:31", "2025-11-26 12:09:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1444", "woocommerce_refresh_order_count_cache", "complete", "2025-11-25 20:38:49", "2025-11-25 20:38:49", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764103129;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764103129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-11-25 20:42:01", "2025-11-26 00:12:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1445", "woocommerce_refresh_order_count_cache", "complete", "2025-11-26 08:42:01", "2025-11-26 08:42:01", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764146521;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764146521;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-11-26 15:29:03", "2025-11-26 18:59:03", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1446", "woocommerce_cleanup_draft_orders", "complete", "2025-11-27 08:39:31", "2025-11-27 08:39:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764232771;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764232771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-28 10:44:42", "2025-11-28 14:14:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1447", "woocommerce_cleanup_draft_orders", "complete", "2025-11-27 08:39:31", "2025-11-27 08:39:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764232771;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764232771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-28 10:44:42", "2025-11-28 14:14:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1448", "woocommerce_refresh_order_count_cache", "complete", "2025-11-27 03:29:03", "2025-11-27 03:29:03", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764214143;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764214143;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-11-28 10:44:42", "2025-11-28 14:14:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1449", "woocommerce_refresh_order_count_cache", "complete", "2025-11-28 22:44:42", "2025-11-28 22:44:42", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764369882;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764369882;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-11-28 22:46:00", "2025-11-29 02:16:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1450", "woocommerce_cleanup_draft_orders", "complete", "2025-11-29 10:44:42", "2025-11-29 10:44:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764413082;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764413082;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-29 12:46:25", "2025-11-29 16:16:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1451", "woocommerce_cleanup_draft_orders", "complete", "2025-11-29 10:44:42", "2025-11-29 10:44:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764413082;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764413082;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-29 12:46:25", "2025-11-29 16:16:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1452", "woocommerce_refresh_order_count_cache", "complete", "2025-11-29 10:46:00", "2025-11-29 10:46:00", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764413160;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764413160;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-11-29 12:46:25", "2025-11-29 16:16:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1453", "woocommerce_cleanup_draft_orders", "complete", "2025-11-30 12:46:25", "2025-11-30 12:46:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764506785;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764506785;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-01 07:18:35", "2025-12-01 10:48:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1454", "woocommerce_cleanup_draft_orders", "complete", "2025-11-30 12:46:25", "2025-11-30 12:46:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764506785;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764506785;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-01 07:18:35", "2025-12-01 10:48:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1455", "woocommerce_refresh_order_count_cache", "complete", "2025-11-30 00:46:25", "2025-11-30 00:46:25", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764463585;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764463585;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-11-30 01:07:00", "2025-11-30 04:37:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1456", "woocommerce_refresh_order_count_cache", "complete", "2025-11-30 13:07:00", "2025-11-30 13:07:00", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764508020;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764508020;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-01 07:18:35", "2025-12-01 10:48:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1457", "woocommerce_cleanup_draft_orders", "complete", "2025-12-02 07:18:35", "2025-12-02 07:18:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764659915;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764659915;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-02 08:02:44", "2025-12-02 11:32:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1458", "woocommerce_cleanup_draft_orders", "complete", "2025-12-02 07:18:35", "2025-12-02 07:18:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764659915;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764659915;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-02 08:02:44", "2025-12-02 11:32:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1459", "woocommerce_refresh_order_count_cache", "complete", "2025-12-01 19:18:35", "2025-12-01 19:18:35", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764616715;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764616715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-01 21:34:48", "2025-12-02 01:04:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1460", "woocommerce_refresh_order_count_cache", "complete", "2025-12-02 09:34:48", "2025-12-02 09:34:48", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764668088;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764668088;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-02 12:37:08", "2025-12-02 16:07:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1461", "woocommerce_cleanup_draft_orders", "complete", "2025-12-03 08:02:44", "2025-12-03 08:02:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764748964;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764748964;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-03 08:02:50", "2025-12-03 11:32:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1462", "woocommerce_cleanup_draft_orders", "complete", "2025-12-03 08:02:44", "2025-12-03 08:02:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764748964;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764748964;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-03 08:02:50", "2025-12-03 11:32:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1463", "woocommerce_refresh_order_count_cache", "complete", "2025-12-03 00:37:08", "2025-12-03 00:37:08", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764722228;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764722228;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-03 04:05:57", "2025-12-03 07:35:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1464", "woocommerce_refresh_order_count_cache", "complete", "2025-12-03 16:05:57", "2025-12-03 16:05:57", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764777957;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764777957;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-03 19:30:33", "2025-12-03 23:00:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1465", "woocommerce_cleanup_draft_orders", "complete", "2025-12-04 08:02:50", "2025-12-04 08:02:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764835370;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764835370;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-04 16:23:29", "2025-12-04 19:53:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1466", "woocommerce_cleanup_draft_orders", "complete", "2025-12-04 08:02:50", "2025-12-04 08:02:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764835370;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764835370;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-04 16:23:29", "2025-12-04 19:53:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1467", "woocommerce_refresh_order_count_cache", "complete", "2025-12-04 07:30:33", "2025-12-04 07:30:33", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764833433;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764833433;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-04 16:23:29", "2025-12-04 19:53:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1468", "woocommerce_refresh_order_count_cache", "complete", "2025-12-05 04:23:29", "2025-12-05 04:23:29", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764908609;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764908609;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-05 21:15:01", "2025-12-06 00:45:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1469", "woocommerce_cleanup_draft_orders", "complete", "2025-12-05 16:23:29", "2025-12-05 16:23:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764951809;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764951809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-05 21:15:01", "2025-12-06 00:45:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1470", "woocommerce_cleanup_draft_orders", "complete", "2025-12-05 16:23:29", "2025-12-05 16:23:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764951809;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764951809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-05 21:15:01", "2025-12-06 00:45:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1471", "woocommerce_refresh_order_count_cache", "complete", "2025-12-06 09:15:01", "2025-12-06 09:15:01", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765012501;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765012501;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-06 11:20:11", "2025-12-06 14:50:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1472", "woocommerce_cleanup_draft_orders", "complete", "2025-12-06 21:15:01", "2025-12-06 21:15:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765055701;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765055701;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-06 21:38:31", "2025-12-07 01:08:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1473", "woocommerce_cleanup_draft_orders", "complete", "2025-12-06 21:15:01", "2025-12-06 21:15:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765055701;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765055701;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-06 21:38:31", "2025-12-07 01:08:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1474", "woocommerce_refresh_order_count_cache", "complete", "2025-12-06 23:20:11", "2025-12-06 23:20:11", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765063211;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765063211;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-06 23:24:37", "2025-12-07 02:54:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1475", "woocommerce_cleanup_draft_orders", "complete", "2025-12-07 21:38:31", "2025-12-07 21:38:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765143511;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765143511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-07 22:52:37", "2025-12-08 02:22:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1476", "woocommerce_cleanup_draft_orders", "complete", "2025-12-07 21:38:31", "2025-12-07 21:38:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765143511;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765143511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-07 22:52:37", "2025-12-08 02:22:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1477", "woocommerce_refresh_order_count_cache", "complete", "2025-12-07 11:24:37", "2025-12-07 11:24:37", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765106677;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765106677;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-07 12:32:09", "2025-12-07 16:02:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1478", "woocommerce_refresh_order_count_cache", "complete", "2025-12-08 00:32:09", "2025-12-08 00:32:09", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765153929;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765153929;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-08 03:55:27", "2025-12-08 07:25:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1479", "woocommerce_cleanup_draft_orders", "complete", "2025-12-08 22:52:37", "2025-12-08 22:52:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765234357;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765234357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-08 23:55:12", "2025-12-09 03:25:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1480", "woocommerce_cleanup_draft_orders", "complete", "2025-12-08 22:52:37", "2025-12-08 22:52:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765234357;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765234357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-08 23:55:12", "2025-12-09 03:25:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1481", "woocommerce_refresh_order_count_cache", "complete", "2025-12-08 15:55:27", "2025-12-08 15:55:27", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765209327;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765209327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-08 21:27:05", "2025-12-09 00:57:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1482", "wc_delete_related_product_transients_async", "complete", "2025-12-08 07:00:49", "2025-12-08 07:00:49", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765177249;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765177249;}", "9", "1", "2025-12-08 07:07:32", "2025-12-08 10:37:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1483", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-08 07:00:50", "2025-12-08 07:00:50", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765177250;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765177250;}", "4", "1", "2025-12-08 07:07:32", "2025-12-08 10:37:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1484", "wc_delete_related_product_transients_async", "complete", "2025-12-08 07:11:24", "2025-12-08 07:11:24", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765177884;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765177884;}", "9", "1", "2025-12-08 07:12:29", "2025-12-08 10:42:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1485", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-08 07:11:25", "2025-12-08 07:11:25", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765177885;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765177885;}", "4", "1", "2025-12-08 07:12:29", "2025-12-08 10:42:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1486", "wc_delete_related_product_transients_async", "complete", "2025-12-08 07:13:21", "2025-12-08 07:13:21", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765178001;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765178001;}", "9", "1", "2025-12-08 07:13:29", "2025-12-08 10:43:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1487", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-08 07:13:22", "2025-12-08 07:13:22", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765178002;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765178002;}", "4", "1", "2025-12-08 07:13:29", "2025-12-08 10:43:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1488", "wc_delete_related_product_transients_async", "complete", "2025-12-08 07:14:54", "2025-12-08 07:14:54", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765178094;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765178094;}", "9", "1", "2025-12-08 07:16:02", "2025-12-08 10:46:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1489", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-08 07:14:55", "2025-12-08 07:14:55", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765178095;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765178095;}", "4", "1", "2025-12-08 07:16:02", "2025-12-08 10:46:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1490", "wc_delete_related_product_transients_async", "complete", "2025-12-08 08:26:45", "2025-12-08 08:26:45", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765182405;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765182405;}", "9", "1", "2025-12-08 08:27:35", "2025-12-08 11:57:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1491", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-08 08:26:46", "2025-12-08 08:26:46", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765182406;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765182406;}", "4", "1", "2025-12-08 08:27:35", "2025-12-08 11:57:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1492", "wc_delete_related_product_transients_async", "complete", "2025-12-08 09:02:54", "2025-12-08 09:02:54", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765184574;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765184574;}", "9", "1", "2025-12-08 09:05:20", "2025-12-08 12:35:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1493", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-08 09:02:55", "2025-12-08 09:02:55", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765184575;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765184575;}", "4", "1", "2025-12-08 09:05:20", "2025-12-08 12:35:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1494", "wc_delete_related_product_transients_async", "complete", "2025-12-08 09:08:31", "2025-12-08 09:08:31", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765184911;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765184911;}", "9", "1", "2025-12-08 09:08:38", "2025-12-08 12:38:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1495", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-08 09:08:32", "2025-12-08 09:08:32", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765184912;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765184912;}", "4", "1", "2025-12-08 09:08:38", "2025-12-08 12:38:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1496", "wc_delete_related_product_transients_async", "complete", "2025-12-08 09:09:45", "2025-12-08 09:09:45", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765184985;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765184985;}", "9", "1", "2025-12-08 09:10:54", "2025-12-08 12:40:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1497", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-08 09:09:46", "2025-12-08 09:09:46", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765184986;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765184986;}", "4", "1", "2025-12-08 09:10:54", "2025-12-08 12:40:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1498", "wc_delete_related_product_transients_async", "complete", "2025-12-08 09:11:37", "2025-12-08 09:11:37", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765185097;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765185097;}", "9", "1", "2025-12-08 09:12:13", "2025-12-08 12:42:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1499", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-08 09:11:38", "2025-12-08 09:11:38", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765185098;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765185098;}", "4", "1", "2025-12-08 09:12:13", "2025-12-08 12:42:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1500", "wc_delete_related_product_transients_async", "complete", "2025-12-08 09:13:19", "2025-12-08 09:13:19", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765185199;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765185199;}", "9", "1", "2025-12-08 09:14:19", "2025-12-08 12:44:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1501", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-08 09:13:20", "2025-12-08 09:13:20", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765185200;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765185200;}", "4", "1", "2025-12-08 09:14:19", "2025-12-08 12:44:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1502", "wc_delete_related_product_transients_async", "complete", "2025-12-08 09:28:42", "2025-12-08 09:28:42", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765186122;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765186122;}", "9", "1", "2025-12-08 09:29:07", "2025-12-08 12:59:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1503", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-08 09:28:43", "2025-12-08 09:28:43", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765186123;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765186123;}", "4", "1", "2025-12-08 09:29:07", "2025-12-08 12:59:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1504", "woocommerce_refresh_order_count_cache", "complete", "2025-12-09 09:27:05", "2025-12-09 09:27:05", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765272425;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765272425;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-09 11:56:09", "2025-12-09 15:26:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1505", "woocommerce_cleanup_draft_orders", "complete", "2025-12-09 23:55:12", "2025-12-09 23:55:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765324512;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765324512;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-10 05:58:28", "2025-12-10 09:28:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1506", "woocommerce_cleanup_draft_orders", "complete", "2025-12-09 23:55:12", "2025-12-09 23:55:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765324512;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765324512;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-10 05:58:28", "2025-12-10 09:28:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1507", "wc_delete_related_product_transients_async", "complete", "2025-12-09 05:38:58", "2025-12-09 05:38:58", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765258738;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765258738;}", "9", "1", "2025-12-09 05:40:00", "2025-12-09 09:10:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1508", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-09 05:38:59", "2025-12-09 05:38:59", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765258739;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765258739;}", "4", "1", "2025-12-09 05:40:00", "2025-12-09 09:10:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1509", "wc_delete_related_product_transients_async", "complete", "2025-12-09 05:40:42", "2025-12-09 05:40:42", "10", "{\"post_id\":702}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765258842;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765258842;}", "9", "1", "2025-12-09 05:41:03", "2025-12-09 09:11:03", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1510", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-09 05:40:43", "2025-12-09 05:40:43", "10", "[702,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765258843;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765258843;}", "4", "1", "2025-12-09 05:41:03", "2025-12-09 09:11:03", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1511", "wc_delete_related_product_transients_async", "complete", "2025-12-09 05:46:03", "2025-12-09 05:46:03", "10", "{\"post_id\":704}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765259163;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765259163;}", "9", "1", "2025-12-09 05:46:36", "2025-12-09 09:16:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1512", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-09 05:46:04", "2025-12-09 05:46:04", "10", "[704,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765259164;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765259164;}", "4", "1", "2025-12-09 05:46:36", "2025-12-09 09:16:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1513", "wc_delete_related_product_transients_async", "complete", "2025-12-09 05:47:32", "2025-12-09 05:47:32", "10", "{\"post_id\":704}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765259252;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765259252;}", "9", "1", "2025-12-09 05:47:37", "2025-12-09 09:17:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1514", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-09 05:47:33", "2025-12-09 05:47:33", "10", "[704,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765259253;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765259253;}", "4", "1", "2025-12-09 05:47:37", "2025-12-09 09:17:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1515", "wc_delete_related_product_transients_async", "complete", "2025-12-09 05:59:33", "2025-12-09 05:59:33", "10", "{\"post_id\":704}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765259973;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765259973;}", "9", "1", "2025-12-09 06:00:26", "2025-12-09 09:30:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1516", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-09 05:59:34", "2025-12-09 05:59:34", "10", "[704,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765259974;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765259974;}", "4", "1", "2025-12-09 06:00:26", "2025-12-09 09:30:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1517", "wc_delete_related_product_transients_async", "complete", "2025-12-09 06:05:09", "2025-12-09 06:05:09", "10", "{\"post_id\":702}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765260309;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765260309;}", "9", "1", "2025-12-09 06:05:58", "2025-12-09 09:35:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1518", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-09 06:05:10", "2025-12-09 06:05:10", "10", "[702,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765260310;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765260310;}", "4", "1", "2025-12-09 06:05:58", "2025-12-09 09:35:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1519", "wc_delete_related_product_transients_async", "complete", "2025-12-09 06:06:32", "2025-12-09 06:06:32", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765260392;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765260392;}", "9", "1", "2025-12-09 06:07:04", "2025-12-09 09:37:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1520", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-09 06:06:33", "2025-12-09 06:06:33", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765260393;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765260393;}", "4", "1", "2025-12-09 06:07:04", "2025-12-09 09:37:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1521", "wc_delete_related_product_transients_async", "complete", "2025-12-09 06:08:39", "2025-12-09 06:08:39", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765260519;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765260519;}", "9", "1", "2025-12-09 06:09:54", "2025-12-09 09:39:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1522", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-09 06:08:40", "2025-12-09 06:08:40", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765260520;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765260520;}", "4", "1", "2025-12-09 06:09:54", "2025-12-09 09:39:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1523", "wc_delete_related_product_transients_async", "complete", "2025-12-09 06:11:34", "2025-12-09 06:11:34", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765260694;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765260694;}", "9", "1", "2025-12-09 06:19:48", "2025-12-09 09:49:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1524", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-09 06:11:35", "2025-12-09 06:11:35", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765260695;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765260695;}", "4", "1", "2025-12-09 06:19:48", "2025-12-09 09:49:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1525", "wc_delete_related_product_transients_async", "complete", "2025-12-09 06:20:40", "2025-12-09 06:20:40", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765261240;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765261240;}", "9", "1", "2025-12-09 06:20:50", "2025-12-09 09:50:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1526", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-09 06:20:41", "2025-12-09 06:20:41", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765261241;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765261241;}", "4", "1", "2025-12-09 06:20:50", "2025-12-09 09:50:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1527", "wc_delete_related_product_transients_async", "complete", "2025-12-09 06:21:44", "2025-12-09 06:21:44", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765261304;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765261304;}", "9", "1", "2025-12-09 06:21:54", "2025-12-09 09:51:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1528", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-09 06:21:45", "2025-12-09 06:21:45", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765261305;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765261305;}", "4", "1", "2025-12-09 06:21:54", "2025-12-09 09:51:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1529", "wc_delete_related_product_transients_async", "complete", "2025-12-09 06:22:41", "2025-12-09 06:22:41", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765261361;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765261361;}", "9", "1", "2025-12-09 06:22:56", "2025-12-09 09:52:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1530", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-09 06:22:42", "2025-12-09 06:22:42", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765261362;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765261362;}", "4", "1", "2025-12-09 06:22:56", "2025-12-09 09:52:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1531", "wc_delete_related_product_transients_async", "complete", "2025-12-09 06:26:04", "2025-12-09 06:26:04", "10", "{\"post_id\":609}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765261564;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765261564;}", "9", "1", "2025-12-09 08:47:14", "2025-12-09 12:17:14", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1532", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-09 06:26:05", "2025-12-09 06:26:05", "10", "[609,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765261565;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765261565;}", "4", "1", "2025-12-09 08:47:14", "2025-12-09 12:17:14", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1533", "woocommerce_refresh_order_count_cache", "complete", "2025-12-09 23:56:09", "2025-12-09 23:56:09", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765324569;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765324569;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-10 05:58:28", "2025-12-10 09:28:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1534", "woocommerce_cleanup_draft_orders", "complete", "2025-12-11 05:58:28", "2025-12-11 05:58:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765432708;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765432708;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-11 06:42:25", "2025-12-11 10:12:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1535", "woocommerce_cleanup_draft_orders", "complete", "2025-12-11 05:58:28", "2025-12-11 05:58:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765432708;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765432708;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-11 06:42:25", "2025-12-11 10:12:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1536", "woocommerce_refresh_order_count_cache", "complete", "2025-12-10 17:58:28", "2025-12-10 17:58:28", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765389508;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765389508;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-10 21:20:50", "2025-12-11 00:50:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1537", "woocommerce_refresh_order_count_cache", "complete", "2025-12-11 09:20:50", "2025-12-11 09:20:50", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765444850;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765444850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-11 13:20:37", "2025-12-11 16:50:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1538", "woocommerce_cleanup_draft_orders", "complete", "2025-12-12 06:42:25", "2025-12-12 06:42:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765521745;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765521745;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-12 06:54:09", "2025-12-12 10:24:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1539", "woocommerce_cleanup_draft_orders", "complete", "2025-12-12 06:42:25", "2025-12-12 06:42:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765521745;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765521745;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-12 06:54:09", "2025-12-12 10:24:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1540", "wc_delete_related_product_transients_async", "complete", "2025-12-11 06:45:18", "2025-12-11 06:45:18", "10", "{\"post_id\":530}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765435518;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765435518;}", "9", "1", "2025-12-11 06:45:33", "2025-12-11 10:15:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1541", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-11 06:45:19", "2025-12-11 06:45:19", "10", "[530,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765435519;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765435519;}", "4", "1", "2025-12-11 06:45:33", "2025-12-11 10:15:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1542", "wc_delete_related_product_transients_async", "complete", "2025-12-11 06:45:39", "2025-12-11 06:45:39", "10", "{\"post_id\":530}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765435539;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765435539;}", "9", "1", "2025-12-11 06:46:38", "2025-12-11 10:16:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1543", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-11 06:45:40", "2025-12-11 06:45:40", "10", "[530,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765435540;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765435540;}", "4", "1", "2025-12-11 06:46:38", "2025-12-11 10:16:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1544", "woocommerce_refresh_order_count_cache", "complete", "2025-12-12 01:20:37", "2025-12-12 01:20:37", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765502437;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765502437;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-12 04:27:54", "2025-12-12 07:57:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1545", "woocommerce_refresh_order_count_cache", "complete", "2025-12-12 16:27:54", "2025-12-12 16:27:54", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765556874;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765556874;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-12 16:57:54", "2025-12-12 20:27:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1546", "woocommerce_cleanup_draft_orders", "complete", "2025-12-13 06:54:09", "2025-12-13 06:54:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765608849;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765608849;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-13 12:11:37", "2025-12-13 15:41:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1547", "woocommerce_cleanup_draft_orders", "complete", "2025-12-13 06:54:09", "2025-12-13 06:54:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765608849;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765608849;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-13 12:11:37", "2025-12-13 15:41:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1548", "woocommerce_refresh_order_count_cache", "complete", "2025-12-13 04:57:54", "2025-12-13 04:57:54", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765601874;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765601874;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-13 12:11:37", "2025-12-13 15:41:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1549", "woocommerce_refresh_order_count_cache", "complete", "2025-12-14 00:11:37", "2025-12-14 00:11:37", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765671097;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765671097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-14 04:47:34", "2025-12-14 08:17:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1550", "woocommerce_cleanup_draft_orders", "complete", "2025-12-14 12:11:37", "2025-12-14 12:11:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765714297;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765714297;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-14 16:48:14", "2025-12-14 20:18:14", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1551", "woocommerce_cleanup_draft_orders", "complete", "2025-12-14 12:11:37", "2025-12-14 12:11:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765714297;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765714297;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-14 16:48:14", "2025-12-14 20:18:14", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1552", "woocommerce_refresh_order_count_cache", "complete", "2025-12-14 16:47:34", "2025-12-14 16:47:34", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765730854;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765730854;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-14 16:48:14", "2025-12-14 20:18:14", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1553", "woocommerce_cleanup_draft_orders", "complete", "2025-12-15 16:48:14", "2025-12-15 16:48:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765817294;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765817294;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-15 17:58:06", "2025-12-15 21:28:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1554", "woocommerce_cleanup_draft_orders", "complete", "2025-12-15 16:48:14", "2025-12-15 16:48:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765817294;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765817294;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-15 17:58:06", "2025-12-15 21:28:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1555", "woocommerce_refresh_order_count_cache", "complete", "2025-12-15 04:48:14", "2025-12-15 04:48:14", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765774094;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765774094;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-15 17:58:06", "2025-12-15 21:28:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1556", "woocommerce_refresh_order_count_cache", "complete", "2025-12-16 05:58:06", "2025-12-16 05:58:06", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765864686;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765864686;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-16 08:03:09", "2025-12-16 11:33:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1557", "woocommerce_cleanup_draft_orders", "complete", "2025-12-16 17:58:06", "2025-12-16 17:58:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765907886;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765907886;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-18 03:01:05", "2025-12-18 06:31:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1558", "woocommerce_cleanup_draft_orders", "complete", "2025-12-16 17:58:06", "2025-12-16 17:58:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765907886;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765907886;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-18 03:01:06", "2025-12-18 06:31:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1559", "woocommerce_refresh_order_count_cache", "complete", "2025-12-16 20:03:09", "2025-12-16 20:03:09", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765915389;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765915389;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-18 03:01:06", "2025-12-18 06:31:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1560", "woocommerce_cleanup_draft_orders", "complete", "2025-12-19 03:01:05", "2025-12-19 03:01:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766113265;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766113265;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-19 06:07:48", "2025-12-19 09:37:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1561", "woocommerce_cleanup_draft_orders", "complete", "2025-12-19 03:01:06", "2025-12-19 03:01:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766113266;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766113266;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-19 06:07:48", "2025-12-19 09:37:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1562", "woocommerce_refresh_order_count_cache", "complete", "2025-12-18 15:01:06", "2025-12-18 15:01:06", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766070066;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766070066;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-18 21:29:45", "2025-12-19 00:59:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1563", "woocommerce_refresh_order_count_cache", "complete", "2025-12-19 09:29:45", "2025-12-19 09:29:45", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766136585;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766136585;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-19 20:05:27", "2025-12-19 23:35:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1564", "woocommerce_cleanup_draft_orders", "complete", "2025-12-20 06:07:48", "2025-12-20 06:07:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766210868;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766210868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-20 07:59:46", "2025-12-20 11:29:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1565", "woocommerce_cleanup_draft_orders", "complete", "2025-12-20 06:07:48", "2025-12-20 06:07:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766210868;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766210868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-20 07:59:46", "2025-12-20 11:29:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1566", "woocommerce_refresh_order_count_cache", "complete", "2025-12-20 08:05:27", "2025-12-20 08:05:27", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766217927;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766217927;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-20 15:42:31", "2025-12-20 19:12:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1567", "woocommerce_cleanup_draft_orders", "complete", "2025-12-21 07:59:46", "2025-12-21 07:59:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766303986;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766303986;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-21 09:33:56", "2025-12-21 13:03:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1568", "woocommerce_cleanup_draft_orders", "complete", "2025-12-21 07:59:46", "2025-12-21 07:59:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766303986;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766303986;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-21 09:33:56", "2025-12-21 13:03:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1569", "woocommerce_refresh_order_count_cache", "complete", "2025-12-21 03:42:31", "2025-12-21 03:42:31", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766288551;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766288551;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-21 06:18:27", "2025-12-21 09:48:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1570", "woocommerce_refresh_order_count_cache", "complete", "2025-12-21 18:18:27", "2025-12-21 18:18:27", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766341107;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766341107;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-21 21:59:48", "2025-12-22 01:29:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1571", "woocommerce_cleanup_draft_orders", "complete", "2025-12-22 09:33:56", "2025-12-22 09:33:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766396036;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766396036;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-22 14:14:52", "2025-12-22 17:44:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1572", "woocommerce_cleanup_draft_orders", "complete", "2025-12-22 09:33:56", "2025-12-22 09:33:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766396036;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766396036;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-22 14:14:52", "2025-12-22 17:44:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1573", "woocommerce_refresh_order_count_cache", "complete", "2025-12-22 09:59:48", "2025-12-22 09:59:48", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766397588;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766397588;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-22 14:14:52", "2025-12-22 17:44:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1574", "woocommerce_cleanup_draft_orders", "complete", "2025-12-23 14:14:52", "2025-12-23 14:14:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766499292;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766499292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-23 19:51:42", "2025-12-23 23:21:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1575", "woocommerce_cleanup_draft_orders", "complete", "2025-12-23 14:14:52", "2025-12-23 14:14:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766499292;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766499292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-23 19:51:42", "2025-12-23 23:21:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1576", "woocommerce_refresh_order_count_cache", "complete", "2025-12-23 02:14:52", "2025-12-23 02:14:52", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766456092;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766456092;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-23 02:54:22", "2025-12-23 06:24:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1577", "woocommerce_refresh_order_count_cache", "complete", "2025-12-23 14:54:22", "2025-12-23 14:54:22", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766501662;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766501662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-23 19:51:42", "2025-12-23 23:21:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1578", "woocommerce_cleanup_draft_orders", "complete", "2025-12-24 19:51:42", "2025-12-24 19:51:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766605902;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766605902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-24 21:19:17", "2025-12-25 00:49:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1579", "woocommerce_cleanup_draft_orders", "complete", "2025-12-24 19:51:42", "2025-12-24 19:51:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766605902;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766605902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-24 21:19:17", "2025-12-25 00:49:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1580", "woocommerce_refresh_order_count_cache", "complete", "2025-12-24 07:51:42", "2025-12-24 07:51:42", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766562702;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766562702;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-24 10:17:39", "2025-12-24 13:47:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1581", "woocommerce_refresh_order_count_cache", "complete", "2025-12-24 22:17:39", "2025-12-24 22:17:39", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766614659;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766614659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-25 12:51:44", "2025-12-25 16:21:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1582", "woocommerce_cleanup_draft_orders", "complete", "2025-12-25 21:19:17", "2025-12-25 21:19:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766697557;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766697557;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-26 02:53:31", "2025-12-26 06:23:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1583", "woocommerce_cleanup_draft_orders", "complete", "2025-12-25 21:19:17", "2025-12-25 21:19:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766697557;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766697557;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-26 02:53:31", "2025-12-26 06:23:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1584", "woocommerce_refresh_order_count_cache", "complete", "2025-12-26 00:51:44", "2025-12-26 00:51:44", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766710304;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766710304;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-12-26 02:53:31", "2025-12-26 06:23:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1585", "woocommerce_cleanup_draft_orders", "pending", "2025-12-27 02:53:31", "2025-12-27 02:53:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766804011;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766804011;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1586", "woocommerce_cleanup_draft_orders", "pending", "2025-12-27 02:53:31", "2025-12-27 02:53:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766804011;s:18:\"\0*\0first_timestamp\";i:1732294688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766804011;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1587", "woocommerce_refresh_order_count_cache", "pending", "2025-12-26 14:53:31", "2025-12-26 14:53:31", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766760811;s:18:\"\0*\0first_timestamp\";i:1749593174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766760811;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1588", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-26 10:59:17", "2025-12-26 10:59:17", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766746757;s:18:\"\0*\0first_timestamp\";i:1766746757;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766746757;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-12-26 11:09:22", "2025-12-26 14:39:22", "15055", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1589", "action_scheduler/migration_hook", "complete", "2025-12-26 11:10:20", "2025-12-26 11:10:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766747420;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766747420;}", "1", "1", "2025-12-26 11:10:31", "2025-12-26 14:40:31", "15058", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1590", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2025-12-27 11:09:22", "2025-12-27 11:09:22", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766833762;s:18:\"\0*\0first_timestamp\";i:1766746757;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766833762;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1591", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-26 11:09:24", "2025-12-26 11:09:24", "10", "[700,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766747364;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766747364;}", "4", "1", "2025-12-26 11:10:31", "2025-12-26 14:40:31", "15058", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1592", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2025-12-26 11:09:34", "2025-12-26 11:09:34", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766747374;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766747374;}", "4", "1", "2025-12-26 11:10:31", "2025-12-26 14:40:31", "15058", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1593", "fetch_patterns", "complete", "2025-12-26 11:10:02", "2025-12-26 11:10:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766747402;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766747402;}", "2", "1", "2025-12-26 11:10:31", "2025-12-26 14:40:31", "15058", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1594", "woocommerce_run_update_callback", "complete", "2025-12-26 11:10:07", "2025-12-26 11:10:07", "10", "{\"update_callback\":\"wc_update_1000_multisite_visibility_setting\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766747407;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766747407;}", "4", "1", "2025-12-26 11:10:31", "2025-12-26 14:40:31", "15058", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1595", "woocommerce_run_update_callback", "complete", "2025-12-26 11:10:08", "2025-12-26 11:10:08", "10", "{\"update_callback\":\"wc_update_1000_remove_patterns_toolkit_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766747408;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766747408;}", "4", "1", "2025-12-26 11:10:31", "2025-12-26 14:40:31", "15058", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1596", "woocommerce_run_update_callback", "complete", "2025-12-26 11:10:09", "2025-12-26 11:10:09", "10", "{\"update_callback\":\"wc_update_1020_add_old_refunded_order_items_to_product_lookup_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766747409;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766747409;}", "4", "1", "2025-12-26 11:10:31", "2025-12-26 14:40:31", "15058", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1597", "woocommerce_run_update_callback", "complete", "2025-12-26 11:10:10", "2025-12-26 11:10:10", "10", "{\"update_callback\":\"wc_update_1030_add_comments_date_type_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766747410;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766747410;}", "4", "1", "2025-12-26 11:10:31", "2025-12-26 14:40:31", "15058", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1598", "woocommerce_run_update_callback", "complete", "2025-12-26 11:10:11", "2025-12-26 11:10:11", "10", "{\"update_callback\":\"wc_update_1040_add_idx_date_paid_status_parent\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766747411;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766747411;}", "4", "1", "2025-12-26 11:10:31", "2025-12-26 14:40:31", "15058", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1599", "woocommerce_run_update_callback", "complete", "2025-12-26 11:10:12", "2025-12-26 11:10:12", "10", "{\"update_callback\":\"wc_update_1040_cleanup_legacy_ptk_patterns_fetching\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766747412;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766747412;}", "4", "1", "2025-12-26 11:10:31", "2025-12-26 14:40:31", "15058", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1600", "woocommerce_update_db_to_current_version", "complete", "2025-12-26 11:10:13", "2025-12-26 11:10:13", "10", "{\"version\":\"10.4.3\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766747413;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766747413;}", "4", "1", "2025-12-26 11:10:31", "2025-12-26 14:40:31", "15058", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1601", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-12-26 11:10:07", "2025-12-26 11:10:07", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766747407;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766747407;}", "5", "1", "2025-12-26 11:10:31", "2025-12-26 14:40:31", "15058", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "wc_update_product_default_cat");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "rank-math");
INSERT INTO `wp_actionscheduler_groups` VALUES("8", "count");
INSERT INTO `wp_actionscheduler_groups` VALUES("9", "wc_delete_related_product_transients_group");
INSERT INTO `wp_actionscheduler_groups` VALUES("10", "ActionScheduler");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("24", "17", "action created", "2024-12-03 10:44:36", "2024-12-03 10:44:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("26", "17", "action started via Async Request", "2024-12-03 10:45:05", "2024-12-03 10:45:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("27", "17", "action failed via Async Request: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.", "2024-12-03 10:45:05", "2024-12-03 10:45:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("60", "29", "action created", "2024-12-04 09:04:28", "2024-12-04 09:04:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("61", "29", "action started via WP Cron", "2024-12-04 09:05:34", "2024-12-04 09:05:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("62", "29", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-12-04 09:05:34", "2024-12-04 09:05:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2802", "943", "action created", "2025-03-25 11:20:23", "2025-03-25 11:20:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2824", "943", "action started via WP Cron", "2025-03-26 17:18:50", "2025-03-26 17:18:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2825", "943", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2025-03-26 17:18:50", "2025-03-26 17:18:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2826", "951", "action created", "2025-03-26 17:18:50", "2025-03-26 17:18:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2869", "951", "action started via WP Cron", "2025-04-02 17:26:02", "2025-04-02 17:26:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2870", "951", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2025-04-02 17:26:02", "2025-04-02 17:26:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2871", "966", "action created", "2025-04-02 17:26:02", "2025-04-02 17:26:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2908", "966", "action started via WP Cron", "2025-04-09 17:32:52", "2025-04-09 17:32:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2909", "966", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2025-04-09 17:32:52", "2025-04-09 17:32:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2910", "979", "action created", "2025-04-09 17:32:52", "2025-04-09 17:32:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2962", "979", "action started via WP Cron", "2025-04-16 17:36:33", "2025-04-16 17:36:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2963", "979", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2025-04-16 17:36:33", "2025-04-16 17:36:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2964", "997", "action created", "2025-04-16 17:36:33", "2025-04-16 17:36:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3064", "997", "action started via WP Cron", "2025-04-23 17:42:36", "2025-04-23 17:42:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3065", "997", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2025-04-23 17:42:36", "2025-04-23 17:42:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3066", "997", "This action appears to be consistently failing. A new instance will not be scheduled.", "2025-04-23 17:42:36", "2025-04-23 17:42:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4300", "1442", "action created", "2025-11-25 08:38:49", "2025-11-25 08:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4303", "1443", "action created", "2025-11-25 08:38:49", "2025-11-25 08:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4306", "1444", "action created", "2025-11-25 08:38:49", "2025-11-25 08:38:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4307", "1444", "action started via Async Request", "2025-11-25 20:42:01", "2025-11-25 20:42:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4308", "1444", "action complete via Async Request", "2025-11-25 20:42:01", "2025-11-25 20:42:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4309", "1445", "action created", "2025-11-25 20:42:01", "2025-11-25 20:42:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4310", "1442", "action started via Async Request", "2025-11-26 08:39:31", "2025-11-26 08:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4311", "1442", "action complete via Async Request", "2025-11-26 08:39:31", "2025-11-26 08:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4312", "1446", "action created", "2025-11-26 08:39:31", "2025-11-26 08:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4313", "1443", "action started via Async Request", "2025-11-26 08:39:31", "2025-11-26 08:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4314", "1443", "action complete via Async Request", "2025-11-26 08:39:31", "2025-11-26 08:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4315", "1447", "action created", "2025-11-26 08:39:31", "2025-11-26 08:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4316", "1445", "action started via Async Request", "2025-11-26 15:29:03", "2025-11-26 15:29:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("4317", "1445", "action complete via Async Request", "2025-11-26 15:29:03", "2025-11-26 15:29:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("4318", "1448", "action created", "2025-11-26 15:29:03", "2025-11-26 15:29:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("4319", "1448", "action started via Async Request", "2025-11-28 10:44:42", "2025-11-28 10:44:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4320", "1448", "action complete via Async Request", "2025-11-28 10:44:42", "2025-11-28 10:44:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4321", "1449", "action created", "2025-11-28 10:44:42", "2025-11-28 10:44:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4322", "1446", "action started via Async Request", "2025-11-28 10:44:42", "2025-11-28 10:44:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4323", "1446", "action complete via Async Request", "2025-11-28 10:44:42", "2025-11-28 10:44:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4324", "1450", "action created", "2025-11-28 10:44:42", "2025-11-28 10:44:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4325", "1447", "action started via Async Request", "2025-11-28 10:44:42", "2025-11-28 10:44:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4326", "1447", "action complete via Async Request", "2025-11-28 10:44:42", "2025-11-28 10:44:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4327", "1451", "action created", "2025-11-28 10:44:42", "2025-11-28 10:44:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4328", "1449", "action started via Async Request", "2025-11-28 22:46:00", "2025-11-28 22:46:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4329", "1449", "action complete via Async Request", "2025-11-28 22:46:00", "2025-11-28 22:46:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4330", "1452", "action created", "2025-11-28 22:46:00", "2025-11-28 22:46:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4331", "1450", "action started via Async Request", "2025-11-29 12:46:25", "2025-11-29 12:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4332", "1450", "action complete via Async Request", "2025-11-29 12:46:25", "2025-11-29 12:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4333", "1453", "action created", "2025-11-29 12:46:25", "2025-11-29 12:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4334", "1451", "action started via Async Request", "2025-11-29 12:46:25", "2025-11-29 12:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4335", "1451", "action complete via Async Request", "2025-11-29 12:46:25", "2025-11-29 12:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4336", "1454", "action created", "2025-11-29 12:46:25", "2025-11-29 12:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4337", "1452", "action started via Async Request", "2025-11-29 12:46:25", "2025-11-29 12:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4338", "1452", "action complete via Async Request", "2025-11-29 12:46:25", "2025-11-29 12:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4339", "1455", "action created", "2025-11-29 12:46:25", "2025-11-29 12:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4340", "1455", "action started via Async Request", "2025-11-30 01:07:00", "2025-11-30 01:07:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4341", "1455", "action complete via Async Request", "2025-11-30 01:07:00", "2025-11-30 01:07:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4342", "1456", "action created", "2025-11-30 01:07:00", "2025-11-30 01:07:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4343", "1453", "action started via Async Request", "2025-12-01 07:18:35", "2025-12-01 07:18:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4344", "1453", "action complete via Async Request", "2025-12-01 07:18:35", "2025-12-01 07:18:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4345", "1457", "action created", "2025-12-01 07:18:35", "2025-12-01 07:18:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4346", "1454", "action started via Async Request", "2025-12-01 07:18:35", "2025-12-01 07:18:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4347", "1454", "action complete via Async Request", "2025-12-01 07:18:35", "2025-12-01 07:18:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4348", "1458", "action created", "2025-12-01 07:18:35", "2025-12-01 07:18:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4349", "1456", "action started via Async Request", "2025-12-01 07:18:35", "2025-12-01 07:18:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4350", "1456", "action complete via Async Request", "2025-12-01 07:18:35", "2025-12-01 07:18:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4351", "1459", "action created", "2025-12-01 07:18:35", "2025-12-01 07:18:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4352", "1459", "action started via Async Request", "2025-12-01 21:34:48", "2025-12-01 21:34:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4353", "1459", "action complete via Async Request", "2025-12-01 21:34:48", "2025-12-01 21:34:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4354", "1460", "action created", "2025-12-01 21:34:48", "2025-12-01 21:34:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4355", "1457", "action started via Async Request", "2025-12-02 08:02:44", "2025-12-02 08:02:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4356", "1457", "action complete via Async Request", "2025-12-02 08:02:44", "2025-12-02 08:02:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4357", "1461", "action created", "2025-12-02 08:02:44", "2025-12-02 08:02:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4358", "1458", "action started via Async Request", "2025-12-02 08:02:44", "2025-12-02 08:02:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4359", "1458", "action complete via Async Request", "2025-12-02 08:02:44", "2025-12-02 08:02:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4360", "1462", "action created", "2025-12-02 08:02:44", "2025-12-02 08:02:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4361", "1460", "action started via Async Request", "2025-12-02 12:37:08", "2025-12-02 12:37:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4362", "1460", "action complete via Async Request", "2025-12-02 12:37:08", "2025-12-02 12:37:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4363", "1463", "action created", "2025-12-02 12:37:08", "2025-12-02 12:37:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4364", "1463", "action started via Async Request", "2025-12-03 04:05:57", "2025-12-03 04:05:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4365", "1463", "action complete via Async Request", "2025-12-03 04:05:57", "2025-12-03 04:05:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4366", "1464", "action created", "2025-12-03 04:05:57", "2025-12-03 04:05:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4367", "1461", "action started via Async Request", "2025-12-03 08:02:50", "2025-12-03 08:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4368", "1461", "action complete via Async Request", "2025-12-03 08:02:50", "2025-12-03 08:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4369", "1465", "action created", "2025-12-03 08:02:50", "2025-12-03 08:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4370", "1462", "action started via Async Request", "2025-12-03 08:02:50", "2025-12-03 08:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4371", "1462", "action complete via Async Request", "2025-12-03 08:02:50", "2025-12-03 08:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4372", "1466", "action created", "2025-12-03 08:02:50", "2025-12-03 08:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4373", "1464", "action started via Async Request", "2025-12-03 19:30:33", "2025-12-03 19:30:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4374", "1464", "action complete via Async Request", "2025-12-03 19:30:33", "2025-12-03 19:30:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4375", "1467", "action created", "2025-12-03 19:30:33", "2025-12-03 19:30:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4376", "1467", "action started via Async Request", "2025-12-04 16:23:29", "2025-12-04 16:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4377", "1467", "action complete via Async Request", "2025-12-04 16:23:29", "2025-12-04 16:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4378", "1468", "action created", "2025-12-04 16:23:29", "2025-12-04 16:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4379", "1465", "action started via Async Request", "2025-12-04 16:23:29", "2025-12-04 16:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4380", "1465", "action complete via Async Request", "2025-12-04 16:23:29", "2025-12-04 16:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4381", "1469", "action created", "2025-12-04 16:23:29", "2025-12-04 16:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4382", "1466", "action started via Async Request", "2025-12-04 16:23:29", "2025-12-04 16:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4383", "1466", "action complete via Async Request", "2025-12-04 16:23:29", "2025-12-04 16:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4384", "1470", "action created", "2025-12-04 16:23:29", "2025-12-04 16:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4385", "1468", "action started via Async Request", "2025-12-05 21:15:01", "2025-12-05 21:15:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4386", "1468", "action complete via Async Request", "2025-12-05 21:15:01", "2025-12-05 21:15:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4387", "1471", "action created", "2025-12-05 21:15:01", "2025-12-05 21:15:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4388", "1469", "action started via Async Request", "2025-12-05 21:15:01", "2025-12-05 21:15:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4389", "1469", "action complete via Async Request", "2025-12-05 21:15:01", "2025-12-05 21:15:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4390", "1472", "action created", "2025-12-05 21:15:01", "2025-12-05 21:15:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4391", "1470", "action started via Async Request", "2025-12-05 21:15:01", "2025-12-05 21:15:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4392", "1470", "action complete via Async Request", "2025-12-05 21:15:01", "2025-12-05 21:15:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4393", "1473", "action created", "2025-12-05 21:15:01", "2025-12-05 21:15:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4394", "1471", "action started via Async Request", "2025-12-06 11:20:11", "2025-12-06 11:20:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4395", "1471", "action complete via Async Request", "2025-12-06 11:20:11", "2025-12-06 11:20:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4396", "1474", "action created", "2025-12-06 11:20:11", "2025-12-06 11:20:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4397", "1472", "action started via Async Request", "2025-12-06 21:38:31", "2025-12-06 21:38:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4398", "1472", "action complete via Async Request", "2025-12-06 21:38:31", "2025-12-06 21:38:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4399", "1475", "action created", "2025-12-06 21:38:31", "2025-12-06 21:38:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4400", "1473", "action started via Async Request", "2025-12-06 21:38:31", "2025-12-06 21:38:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4401", "1473", "action complete via Async Request", "2025-12-06 21:38:31", "2025-12-06 21:38:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4402", "1476", "action created", "2025-12-06 21:38:31", "2025-12-06 21:38:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4403", "1474", "action started via Async Request", "2025-12-06 23:24:37", "2025-12-06 23:24:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4404", "1474", "action complete via Async Request", "2025-12-06 23:24:37", "2025-12-06 23:24:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4405", "1477", "action created", "2025-12-06 23:24:37", "2025-12-06 23:24:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4406", "1477", "action started via Async Request", "2025-12-07 12:32:09", "2025-12-07 12:32:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4407", "1477", "action complete via Async Request", "2025-12-07 12:32:09", "2025-12-07 12:32:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4408", "1478", "action created", "2025-12-07 12:32:09", "2025-12-07 12:32:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4409", "1475", "action started via Async Request", "2025-12-07 22:52:37", "2025-12-07 22:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4410", "1475", "action complete via Async Request", "2025-12-07 22:52:37", "2025-12-07 22:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4411", "1479", "action created", "2025-12-07 22:52:37", "2025-12-07 22:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4412", "1476", "action started via Async Request", "2025-12-07 22:52:37", "2025-12-07 22:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4413", "1476", "action complete via Async Request", "2025-12-07 22:52:37", "2025-12-07 22:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4414", "1480", "action created", "2025-12-07 22:52:37", "2025-12-07 22:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4415", "1478", "action started via Async Request", "2025-12-08 03:55:27", "2025-12-08 03:55:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("4416", "1478", "action complete via Async Request", "2025-12-08 03:55:27", "2025-12-08 03:55:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("4417", "1481", "action created", "2025-12-08 03:55:27", "2025-12-08 03:55:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("4418", "1482", "action created", "2025-12-08 07:00:49", "2025-12-08 07:00:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4419", "1483", "action created", "2025-12-08 07:00:49", "2025-12-08 07:00:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4420", "1482", "action started via Async Request", "2025-12-08 07:07:32", "2025-12-08 07:07:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4421", "1482", "action complete via Async Request", "2025-12-08 07:07:32", "2025-12-08 07:07:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4422", "1483", "action started via Async Request", "2025-12-08 07:07:32", "2025-12-08 07:07:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4423", "1483", "action complete via Async Request", "2025-12-08 07:07:32", "2025-12-08 07:07:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4424", "1484", "action created", "2025-12-08 07:11:24", "2025-12-08 07:11:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("4425", "1485", "action created", "2025-12-08 07:11:24", "2025-12-08 07:11:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("4426", "1484", "action started via Async Request", "2025-12-08 07:12:29", "2025-12-08 07:12:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4427", "1484", "action complete via Async Request", "2025-12-08 07:12:29", "2025-12-08 07:12:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4428", "1485", "action started via Async Request", "2025-12-08 07:12:29", "2025-12-08 07:12:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4429", "1485", "action complete via Async Request", "2025-12-08 07:12:29", "2025-12-08 07:12:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4430", "1486", "action created", "2025-12-08 07:13:21", "2025-12-08 07:13:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("4431", "1487", "action created", "2025-12-08 07:13:21", "2025-12-08 07:13:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("4432", "1486", "action started via Async Request", "2025-12-08 07:13:29", "2025-12-08 07:13:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4433", "1486", "action complete via Async Request", "2025-12-08 07:13:29", "2025-12-08 07:13:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4434", "1487", "action started via Async Request", "2025-12-08 07:13:29", "2025-12-08 07:13:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4435", "1487", "action complete via Async Request", "2025-12-08 07:13:29", "2025-12-08 07:13:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4436", "1488", "action created", "2025-12-08 07:14:54", "2025-12-08 07:14:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4437", "1489", "action created", "2025-12-08 07:14:54", "2025-12-08 07:14:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4438", "1488", "action started via Async Request", "2025-12-08 07:16:02", "2025-12-08 07:16:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4439", "1488", "action complete via Async Request", "2025-12-08 07:16:02", "2025-12-08 07:16:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4440", "1489", "action started via Async Request", "2025-12-08 07:16:02", "2025-12-08 07:16:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4441", "1489", "action complete via Async Request", "2025-12-08 07:16:02", "2025-12-08 07:16:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4442", "1490", "action created", "2025-12-08 08:26:45", "2025-12-08 08:26:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4443", "1491", "action created", "2025-12-08 08:26:45", "2025-12-08 08:26:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4444", "1490", "action started via Async Request", "2025-12-08 08:27:35", "2025-12-08 08:27:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4445", "1490", "action complete via Async Request", "2025-12-08 08:27:35", "2025-12-08 08:27:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4446", "1491", "action started via Async Request", "2025-12-08 08:27:35", "2025-12-08 08:27:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4447", "1491", "action complete via Async Request", "2025-12-08 08:27:35", "2025-12-08 08:27:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4448", "1492", "action created", "2025-12-08 09:02:54", "2025-12-08 09:02:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4449", "1493", "action created", "2025-12-08 09:02:54", "2025-12-08 09:02:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4450", "1492", "action started via Async Request", "2025-12-08 09:05:20", "2025-12-08 09:05:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4451", "1492", "action complete via Async Request", "2025-12-08 09:05:20", "2025-12-08 09:05:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4452", "1493", "action started via Async Request", "2025-12-08 09:05:20", "2025-12-08 09:05:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4453", "1493", "action complete via Async Request", "2025-12-08 09:05:20", "2025-12-08 09:05:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4454", "1494", "action created", "2025-12-08 09:08:31", "2025-12-08 09:08:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4455", "1495", "action created", "2025-12-08 09:08:31", "2025-12-08 09:08:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4456", "1494", "action started via Async Request", "2025-12-08 09:08:38", "2025-12-08 09:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4457", "1494", "action complete via Async Request", "2025-12-08 09:08:38", "2025-12-08 09:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4458", "1495", "action started via Async Request", "2025-12-08 09:08:38", "2025-12-08 09:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4459", "1495", "action complete via Async Request", "2025-12-08 09:08:38", "2025-12-08 09:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4460", "1496", "action created", "2025-12-08 09:09:45", "2025-12-08 09:09:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4461", "1497", "action created", "2025-12-08 09:09:45", "2025-12-08 09:09:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4462", "1496", "action started via Async Request", "2025-12-08 09:10:54", "2025-12-08 09:10:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4463", "1496", "action complete via Async Request", "2025-12-08 09:10:54", "2025-12-08 09:10:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4464", "1497", "action started via Async Request", "2025-12-08 09:10:54", "2025-12-08 09:10:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4465", "1497", "action complete via Async Request", "2025-12-08 09:10:54", "2025-12-08 09:10:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4466", "1498", "action created", "2025-12-08 09:11:37", "2025-12-08 09:11:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4467", "1499", "action created", "2025-12-08 09:11:37", "2025-12-08 09:11:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4468", "1498", "action started via Async Request", "2025-12-08 09:12:13", "2025-12-08 09:12:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4469", "1498", "action complete via Async Request", "2025-12-08 09:12:13", "2025-12-08 09:12:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4470", "1499", "action started via Async Request", "2025-12-08 09:12:13", "2025-12-08 09:12:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4471", "1499", "action complete via Async Request", "2025-12-08 09:12:13", "2025-12-08 09:12:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4472", "1500", "action created", "2025-12-08 09:13:19", "2025-12-08 09:13:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4473", "1501", "action created", "2025-12-08 09:13:19", "2025-12-08 09:13:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4474", "1500", "action started via Async Request", "2025-12-08 09:14:19", "2025-12-08 09:14:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4475", "1500", "action complete via Async Request", "2025-12-08 09:14:19", "2025-12-08 09:14:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4476", "1501", "action started via Async Request", "2025-12-08 09:14:19", "2025-12-08 09:14:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4477", "1501", "action complete via Async Request", "2025-12-08 09:14:19", "2025-12-08 09:14:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4478", "1502", "action created", "2025-12-08 09:28:42", "2025-12-08 09:28:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4479", "1503", "action created", "2025-12-08 09:28:42", "2025-12-08 09:28:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4480", "1502", "action started via Async Request", "2025-12-08 09:29:07", "2025-12-08 09:29:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4481", "1502", "action complete via Async Request", "2025-12-08 09:29:07", "2025-12-08 09:29:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4482", "1503", "action started via Async Request", "2025-12-08 09:29:07", "2025-12-08 09:29:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4483", "1503", "action complete via Async Request", "2025-12-08 09:29:07", "2025-12-08 09:29:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4484", "1481", "action started via Async Request", "2025-12-08 21:27:05", "2025-12-08 21:27:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4485", "1481", "action complete via Async Request", "2025-12-08 21:27:05", "2025-12-08 21:27:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4486", "1504", "action created", "2025-12-08 21:27:05", "2025-12-08 21:27:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4487", "1479", "action started via Async Request", "2025-12-08 23:55:12", "2025-12-08 23:55:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4488", "1479", "action complete via Async Request", "2025-12-08 23:55:12", "2025-12-08 23:55:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4489", "1505", "action created", "2025-12-08 23:55:12", "2025-12-08 23:55:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4490", "1480", "action started via Async Request", "2025-12-08 23:55:12", "2025-12-08 23:55:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4491", "1480", "action complete via Async Request", "2025-12-08 23:55:12", "2025-12-08 23:55:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4492", "1506", "action created", "2025-12-08 23:55:12", "2025-12-08 23:55:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4493", "1507", "action created", "2025-12-09 05:38:58", "2025-12-09 05:38:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("4494", "1508", "action created", "2025-12-09 05:38:58", "2025-12-09 05:38:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("4495", "1507", "action started via Async Request", "2025-12-09 05:40:00", "2025-12-09 05:40:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4496", "1507", "action complete via Async Request", "2025-12-09 05:40:00", "2025-12-09 05:40:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4497", "1508", "action started via Async Request", "2025-12-09 05:40:00", "2025-12-09 05:40:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4498", "1508", "action complete via Async Request", "2025-12-09 05:40:00", "2025-12-09 05:40:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4499", "1509", "action created", "2025-12-09 05:40:42", "2025-12-09 05:40:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4500", "1510", "action created", "2025-12-09 05:40:42", "2025-12-09 05:40:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4501", "1509", "action started via Async Request", "2025-12-09 05:41:03", "2025-12-09 05:41:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("4502", "1509", "action complete via Async Request", "2025-12-09 05:41:03", "2025-12-09 05:41:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("4503", "1510", "action started via Async Request", "2025-12-09 05:41:03", "2025-12-09 05:41:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("4504", "1510", "action complete via Async Request", "2025-12-09 05:41:03", "2025-12-09 05:41:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("4505", "1511", "action created", "2025-12-09 05:46:03", "2025-12-09 05:46:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("4506", "1512", "action created", "2025-12-09 05:46:03", "2025-12-09 05:46:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("4507", "1511", "action started via Async Request", "2025-12-09 05:46:36", "2025-12-09 05:46:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4508", "1511", "action complete via Async Request", "2025-12-09 05:46:36", "2025-12-09 05:46:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4509", "1512", "action started via Async Request", "2025-12-09 05:46:36", "2025-12-09 05:46:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4510", "1512", "action complete via Async Request", "2025-12-09 05:46:36", "2025-12-09 05:46:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4511", "1513", "action created", "2025-12-09 05:47:32", "2025-12-09 05:47:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4512", "1514", "action created", "2025-12-09 05:47:32", "2025-12-09 05:47:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4513", "1513", "action started via Async Request", "2025-12-09 05:47:37", "2025-12-09 05:47:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4514", "1513", "action complete via Async Request", "2025-12-09 05:47:37", "2025-12-09 05:47:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4515", "1514", "action started via Async Request", "2025-12-09 05:47:37", "2025-12-09 05:47:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4516", "1514", "action complete via Async Request", "2025-12-09 05:47:37", "2025-12-09 05:47:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4517", "1515", "action created", "2025-12-09 05:59:33", "2025-12-09 05:59:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4518", "1516", "action created", "2025-12-09 05:59:33", "2025-12-09 05:59:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4519", "1515", "action started via Async Request", "2025-12-09 06:00:26", "2025-12-09 06:00:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4520", "1515", "action complete via Async Request", "2025-12-09 06:00:26", "2025-12-09 06:00:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4521", "1516", "action started via Async Request", "2025-12-09 06:00:26", "2025-12-09 06:00:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4522", "1516", "action complete via Async Request", "2025-12-09 06:00:26", "2025-12-09 06:00:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4523", "1517", "action created", "2025-12-09 06:05:09", "2025-12-09 06:05:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4524", "1518", "action created", "2025-12-09 06:05:09", "2025-12-09 06:05:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4525", "1517", "action started via Async Request", "2025-12-09 06:05:58", "2025-12-09 06:05:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("4526", "1517", "action complete via Async Request", "2025-12-09 06:05:58", "2025-12-09 06:05:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("4527", "1518", "action started via Async Request", "2025-12-09 06:05:58", "2025-12-09 06:05:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("4528", "1518", "action complete via Async Request", "2025-12-09 06:05:58", "2025-12-09 06:05:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("4529", "1519", "action created", "2025-12-09 06:06:32", "2025-12-09 06:06:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4530", "1520", "action created", "2025-12-09 06:06:32", "2025-12-09 06:06:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4531", "1519", "action started via Async Request", "2025-12-09 06:07:04", "2025-12-09 06:07:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4532", "1519", "action complete via Async Request", "2025-12-09 06:07:04", "2025-12-09 06:07:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4533", "1520", "action started via Async Request", "2025-12-09 06:07:04", "2025-12-09 06:07:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4534", "1520", "action complete via Async Request", "2025-12-09 06:07:04", "2025-12-09 06:07:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4535", "1521", "action created", "2025-12-09 06:08:39", "2025-12-09 06:08:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4536", "1522", "action created", "2025-12-09 06:08:39", "2025-12-09 06:08:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4537", "1521", "action started via Async Request", "2025-12-09 06:09:54", "2025-12-09 06:09:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4538", "1521", "action complete via Async Request", "2025-12-09 06:09:54", "2025-12-09 06:09:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4539", "1522", "action started via Async Request", "2025-12-09 06:09:54", "2025-12-09 06:09:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4540", "1522", "action complete via Async Request", "2025-12-09 06:09:54", "2025-12-09 06:09:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4541", "1523", "action created", "2025-12-09 06:11:34", "2025-12-09 06:11:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4542", "1524", "action created", "2025-12-09 06:11:34", "2025-12-09 06:11:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4543", "1523", "action started via Async Request", "2025-12-09 06:19:48", "2025-12-09 06:19:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4544", "1523", "action complete via Async Request", "2025-12-09 06:19:48", "2025-12-09 06:19:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4545", "1524", "action started via Async Request", "2025-12-09 06:19:48", "2025-12-09 06:19:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4546", "1524", "action complete via Async Request", "2025-12-09 06:19:48", "2025-12-09 06:19:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4547", "1525", "action created", "2025-12-09 06:20:40", "2025-12-09 06:20:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4548", "1526", "action created", "2025-12-09 06:20:40", "2025-12-09 06:20:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4549", "1525", "action started via Async Request", "2025-12-09 06:20:50", "2025-12-09 06:20:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4550", "1525", "action complete via Async Request", "2025-12-09 06:20:50", "2025-12-09 06:20:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4551", "1526", "action started via Async Request", "2025-12-09 06:20:50", "2025-12-09 06:20:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4552", "1526", "action complete via Async Request", "2025-12-09 06:20:50", "2025-12-09 06:20:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4553", "1527", "action created", "2025-12-09 06:21:44", "2025-12-09 06:21:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4554", "1528", "action created", "2025-12-09 06:21:44", "2025-12-09 06:21:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4555", "1527", "action started via Async Request", "2025-12-09 06:21:54", "2025-12-09 06:21:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4556", "1527", "action complete via Async Request", "2025-12-09 06:21:54", "2025-12-09 06:21:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4557", "1528", "action started via Async Request", "2025-12-09 06:21:54", "2025-12-09 06:21:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4558", "1528", "action complete via Async Request", "2025-12-09 06:21:54", "2025-12-09 06:21:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4559", "1529", "action created", "2025-12-09 06:22:41", "2025-12-09 06:22:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("4560", "1530", "action created", "2025-12-09 06:22:41", "2025-12-09 06:22:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("4561", "1529", "action started via Async Request", "2025-12-09 06:22:56", "2025-12-09 06:22:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4562", "1529", "action complete via Async Request", "2025-12-09 06:22:56", "2025-12-09 06:22:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4563", "1530", "action started via Async Request", "2025-12-09 06:22:56", "2025-12-09 06:22:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4564", "1530", "action complete via Async Request", "2025-12-09 06:22:56", "2025-12-09 06:22:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4565", "1531", "action created", "2025-12-09 06:26:04", "2025-12-09 06:26:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4566", "1532", "action created", "2025-12-09 06:26:04", "2025-12-09 06:26:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4567", "1531", "action started via Async Request", "2025-12-09 08:47:14", "2025-12-09 08:47:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4568", "1531", "action complete via Async Request", "2025-12-09 08:47:14", "2025-12-09 08:47:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4569", "1532", "action started via Async Request", "2025-12-09 08:47:14", "2025-12-09 08:47:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4570", "1532", "action complete via Async Request", "2025-12-09 08:47:14", "2025-12-09 08:47:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4571", "1504", "action started via Async Request", "2025-12-09 11:56:09", "2025-12-09 11:56:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4572", "1504", "action complete via Async Request", "2025-12-09 11:56:09", "2025-12-09 11:56:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4573", "1533", "action created", "2025-12-09 11:56:09", "2025-12-09 11:56:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4574", "1505", "action started via Async Request", "2025-12-10 05:58:28", "2025-12-10 05:58:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4575", "1505", "action complete via Async Request", "2025-12-10 05:58:28", "2025-12-10 05:58:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4576", "1534", "action created", "2025-12-10 05:58:28", "2025-12-10 05:58:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4577", "1506", "action started via Async Request", "2025-12-10 05:58:28", "2025-12-10 05:58:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4578", "1506", "action complete via Async Request", "2025-12-10 05:58:28", "2025-12-10 05:58:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4579", "1535", "action created", "2025-12-10 05:58:28", "2025-12-10 05:58:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4580", "1533", "action started via Async Request", "2025-12-10 05:58:28", "2025-12-10 05:58:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4581", "1533", "action complete via Async Request", "2025-12-10 05:58:28", "2025-12-10 05:58:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4582", "1536", "action created", "2025-12-10 05:58:28", "2025-12-10 05:58:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4583", "1536", "action started via Async Request", "2025-12-10 21:20:50", "2025-12-10 21:20:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4584", "1536", "action complete via Async Request", "2025-12-10 21:20:50", "2025-12-10 21:20:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4585", "1537", "action created", "2025-12-10 21:20:50", "2025-12-10 21:20:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4586", "1534", "action started via Async Request", "2025-12-11 06:42:25", "2025-12-11 06:42:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4587", "1534", "action complete via Async Request", "2025-12-11 06:42:25", "2025-12-11 06:42:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4588", "1538", "action created", "2025-12-11 06:42:25", "2025-12-11 06:42:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4589", "1535", "action started via Async Request", "2025-12-11 06:42:25", "2025-12-11 06:42:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4590", "1535", "action complete via Async Request", "2025-12-11 06:42:25", "2025-12-11 06:42:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4591", "1539", "action created", "2025-12-11 06:42:25", "2025-12-11 06:42:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4592", "1540", "action created", "2025-12-11 06:45:18", "2025-12-11 06:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("4593", "1541", "action created", "2025-12-11 06:45:18", "2025-12-11 06:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("4594", "1540", "action started via Async Request", "2025-12-11 06:45:33", "2025-12-11 06:45:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4595", "1540", "action complete via Async Request", "2025-12-11 06:45:33", "2025-12-11 06:45:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4596", "1541", "action started via Async Request", "2025-12-11 06:45:33", "2025-12-11 06:45:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4597", "1541", "action complete via Async Request", "2025-12-11 06:45:33", "2025-12-11 06:45:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4598", "1542", "action created", "2025-12-11 06:45:39", "2025-12-11 06:45:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4599", "1543", "action created", "2025-12-11 06:45:39", "2025-12-11 06:45:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4600", "1542", "action started via Async Request", "2025-12-11 06:46:38", "2025-12-11 06:46:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4601", "1542", "action complete via Async Request", "2025-12-11 06:46:38", "2025-12-11 06:46:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4602", "1543", "action started via Async Request", "2025-12-11 06:46:38", "2025-12-11 06:46:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4603", "1543", "action complete via Async Request", "2025-12-11 06:46:38", "2025-12-11 06:46:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4604", "1537", "action started via Async Request", "2025-12-11 13:20:37", "2025-12-11 13:20:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4605", "1537", "action complete via Async Request", "2025-12-11 13:20:37", "2025-12-11 13:20:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4606", "1544", "action created", "2025-12-11 13:20:37", "2025-12-11 13:20:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4607", "1544", "action started via Async Request", "2025-12-12 04:27:54", "2025-12-12 04:27:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4608", "1544", "action complete via Async Request", "2025-12-12 04:27:54", "2025-12-12 04:27:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4609", "1545", "action created", "2025-12-12 04:27:54", "2025-12-12 04:27:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4610", "1538", "action started via Async Request", "2025-12-12 06:54:09", "2025-12-12 06:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4611", "1538", "action complete via Async Request", "2025-12-12 06:54:09", "2025-12-12 06:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4612", "1546", "action created", "2025-12-12 06:54:09", "2025-12-12 06:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4613", "1539", "action started via Async Request", "2025-12-12 06:54:09", "2025-12-12 06:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4614", "1539", "action complete via Async Request", "2025-12-12 06:54:09", "2025-12-12 06:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4615", "1547", "action created", "2025-12-12 06:54:09", "2025-12-12 06:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4616", "1545", "action started via Async Request", "2025-12-12 16:57:54", "2025-12-12 16:57:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4617", "1545", "action complete via Async Request", "2025-12-12 16:57:54", "2025-12-12 16:57:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4618", "1548", "action created", "2025-12-12 16:57:54", "2025-12-12 16:57:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4619", "1548", "action started via Async Request", "2025-12-13 12:11:37", "2025-12-13 12:11:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4620", "1548", "action complete via Async Request", "2025-12-13 12:11:37", "2025-12-13 12:11:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4621", "1549", "action created", "2025-12-13 12:11:37", "2025-12-13 12:11:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4622", "1546", "action started via Async Request", "2025-12-13 12:11:37", "2025-12-13 12:11:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4623", "1546", "action complete via Async Request", "2025-12-13 12:11:37", "2025-12-13 12:11:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4624", "1550", "action created", "2025-12-13 12:11:37", "2025-12-13 12:11:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4625", "1547", "action started via Async Request", "2025-12-13 12:11:37", "2025-12-13 12:11:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4626", "1547", "action complete via Async Request", "2025-12-13 12:11:37", "2025-12-13 12:11:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4627", "1551", "action created", "2025-12-13 12:11:37", "2025-12-13 12:11:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4628", "1549", "action started via Async Request", "2025-12-14 04:47:34", "2025-12-14 04:47:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4629", "1549", "action complete via Async Request", "2025-12-14 04:47:34", "2025-12-14 04:47:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4630", "1552", "action created", "2025-12-14 04:47:34", "2025-12-14 04:47:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4631", "1550", "action started via Async Request", "2025-12-14 16:48:14", "2025-12-14 16:48:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4632", "1550", "action complete via Async Request", "2025-12-14 16:48:14", "2025-12-14 16:48:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4633", "1553", "action created", "2025-12-14 16:48:14", "2025-12-14 16:48:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4634", "1551", "action started via Async Request", "2025-12-14 16:48:14", "2025-12-14 16:48:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4635", "1551", "action complete via Async Request", "2025-12-14 16:48:14", "2025-12-14 16:48:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4636", "1554", "action created", "2025-12-14 16:48:14", "2025-12-14 16:48:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4637", "1552", "action started via Async Request", "2025-12-14 16:48:14", "2025-12-14 16:48:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4638", "1552", "action complete via Async Request", "2025-12-14 16:48:14", "2025-12-14 16:48:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4639", "1555", "action created", "2025-12-14 16:48:14", "2025-12-14 16:48:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4640", "1555", "action started via Async Request", "2025-12-15 17:58:06", "2025-12-15 17:58:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4641", "1555", "action complete via Async Request", "2025-12-15 17:58:06", "2025-12-15 17:58:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4642", "1556", "action created", "2025-12-15 17:58:06", "2025-12-15 17:58:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4643", "1553", "action started via Async Request", "2025-12-15 17:58:06", "2025-12-15 17:58:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4644", "1553", "action complete via Async Request", "2025-12-15 17:58:06", "2025-12-15 17:58:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4645", "1557", "action created", "2025-12-15 17:58:06", "2025-12-15 17:58:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4646", "1554", "action started via Async Request", "2025-12-15 17:58:06", "2025-12-15 17:58:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4647", "1554", "action complete via Async Request", "2025-12-15 17:58:06", "2025-12-15 17:58:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4648", "1558", "action created", "2025-12-15 17:58:06", "2025-12-15 17:58:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4649", "1556", "action started via Async Request", "2025-12-16 08:03:09", "2025-12-16 08:03:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4650", "1556", "action complete via Async Request", "2025-12-16 08:03:09", "2025-12-16 08:03:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4651", "1559", "action created", "2025-12-16 08:03:09", "2025-12-16 08:03:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4652", "1557", "action started via Async Request", "2025-12-18 03:01:05", "2025-12-18 03:01:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4653", "1557", "action complete via Async Request", "2025-12-18 03:01:05", "2025-12-18 03:01:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4654", "1560", "action created", "2025-12-18 03:01:06", "2025-12-18 03:01:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4655", "1558", "action started via Async Request", "2025-12-18 03:01:06", "2025-12-18 03:01:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4656", "1558", "action complete via Async Request", "2025-12-18 03:01:06", "2025-12-18 03:01:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4657", "1561", "action created", "2025-12-18 03:01:06", "2025-12-18 03:01:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4658", "1559", "action started via Async Request", "2025-12-18 03:01:06", "2025-12-18 03:01:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4659", "1559", "action complete via Async Request", "2025-12-18 03:01:06", "2025-12-18 03:01:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4660", "1562", "action created", "2025-12-18 03:01:06", "2025-12-18 03:01:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4661", "1562", "action started via Async Request", "2025-12-18 21:29:45", "2025-12-18 21:29:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4662", "1562", "action complete via Async Request", "2025-12-18 21:29:45", "2025-12-18 21:29:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4663", "1563", "action created", "2025-12-18 21:29:45", "2025-12-18 21:29:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4664", "1560", "action started via Async Request", "2025-12-19 06:07:48", "2025-12-19 06:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4665", "1560", "action complete via Async Request", "2025-12-19 06:07:48", "2025-12-19 06:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4666", "1564", "action created", "2025-12-19 06:07:48", "2025-12-19 06:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4667", "1561", "action started via Async Request", "2025-12-19 06:07:48", "2025-12-19 06:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4668", "1561", "action complete via Async Request", "2025-12-19 06:07:48", "2025-12-19 06:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4669", "1565", "action created", "2025-12-19 06:07:48", "2025-12-19 06:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4670", "1563", "action started via Async Request", "2025-12-19 20:05:27", "2025-12-19 20:05:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("4671", "1563", "action complete via Async Request", "2025-12-19 20:05:27", "2025-12-19 20:05:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("4672", "1566", "action created", "2025-12-19 20:05:27", "2025-12-19 20:05:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("4673", "1564", "action started via Async Request", "2025-12-20 07:59:46", "2025-12-20 07:59:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4674", "1564", "action complete via Async Request", "2025-12-20 07:59:46", "2025-12-20 07:59:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4675", "1567", "action created", "2025-12-20 07:59:46", "2025-12-20 07:59:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4676", "1565", "action started via Async Request", "2025-12-20 07:59:46", "2025-12-20 07:59:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4677", "1565", "action complete via Async Request", "2025-12-20 07:59:46", "2025-12-20 07:59:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4678", "1568", "action created", "2025-12-20 07:59:46", "2025-12-20 07:59:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4679", "1566", "action started via Async Request", "2025-12-20 15:42:31", "2025-12-20 15:42:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4680", "1566", "action complete via Async Request", "2025-12-20 15:42:31", "2025-12-20 15:42:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4681", "1569", "action created", "2025-12-20 15:42:31", "2025-12-20 15:42:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4682", "1569", "action started via Async Request", "2025-12-21 06:18:27", "2025-12-21 06:18:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("4683", "1569", "action complete via Async Request", "2025-12-21 06:18:27", "2025-12-21 06:18:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("4684", "1570", "action created", "2025-12-21 06:18:27", "2025-12-21 06:18:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("4685", "1567", "action started via Async Request", "2025-12-21 09:33:56", "2025-12-21 09:33:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4686", "1567", "action complete via Async Request", "2025-12-21 09:33:56", "2025-12-21 09:33:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4687", "1571", "action created", "2025-12-21 09:33:56", "2025-12-21 09:33:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4688", "1568", "action started via Async Request", "2025-12-21 09:33:56", "2025-12-21 09:33:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4689", "1568", "action complete via Async Request", "2025-12-21 09:33:56", "2025-12-21 09:33:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4690", "1572", "action created", "2025-12-21 09:33:56", "2025-12-21 09:33:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4691", "1570", "action started via Async Request", "2025-12-21 21:59:48", "2025-12-21 21:59:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4692", "1570", "action complete via Async Request", "2025-12-21 21:59:48", "2025-12-21 21:59:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4693", "1573", "action created", "2025-12-21 21:59:48", "2025-12-21 21:59:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4694", "1571", "action started via Async Request", "2025-12-22 14:14:52", "2025-12-22 14:14:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4695", "1571", "action complete via Async Request", "2025-12-22 14:14:52", "2025-12-22 14:14:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4696", "1574", "action created", "2025-12-22 14:14:52", "2025-12-22 14:14:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4697", "1572", "action started via Async Request", "2025-12-22 14:14:52", "2025-12-22 14:14:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4698", "1572", "action complete via Async Request", "2025-12-22 14:14:52", "2025-12-22 14:14:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4699", "1575", "action created", "2025-12-22 14:14:52", "2025-12-22 14:14:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4700", "1573", "action started via Async Request", "2025-12-22 14:14:52", "2025-12-22 14:14:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4701", "1573", "action complete via Async Request", "2025-12-22 14:14:52", "2025-12-22 14:14:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4702", "1576", "action created", "2025-12-22 14:14:52", "2025-12-22 14:14:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4703", "1576", "action started via Async Request", "2025-12-23 02:54:22", "2025-12-23 02:54:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("4704", "1576", "action complete via Async Request", "2025-12-23 02:54:22", "2025-12-23 02:54:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("4705", "1577", "action created", "2025-12-23 02:54:22", "2025-12-23 02:54:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("4706", "1574", "action started via Async Request", "2025-12-23 19:51:42", "2025-12-23 19:51:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4707", "1574", "action complete via Async Request", "2025-12-23 19:51:42", "2025-12-23 19:51:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4708", "1578", "action created", "2025-12-23 19:51:42", "2025-12-23 19:51:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4709", "1575", "action started via Async Request", "2025-12-23 19:51:42", "2025-12-23 19:51:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4710", "1575", "action complete via Async Request", "2025-12-23 19:51:42", "2025-12-23 19:51:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4711", "1579", "action created", "2025-12-23 19:51:42", "2025-12-23 19:51:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4712", "1577", "action started via Async Request", "2025-12-23 19:51:42", "2025-12-23 19:51:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4713", "1577", "action complete via Async Request", "2025-12-23 19:51:42", "2025-12-23 19:51:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4714", "1580", "action created", "2025-12-23 19:51:42", "2025-12-23 19:51:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4715", "1580", "action started via Async Request", "2025-12-24 10:17:39", "2025-12-24 10:17:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4716", "1580", "action complete via Async Request", "2025-12-24 10:17:39", "2025-12-24 10:17:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4717", "1581", "action created", "2025-12-24 10:17:39", "2025-12-24 10:17:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4718", "1578", "action started via Async Request", "2025-12-24 21:19:17", "2025-12-24 21:19:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4719", "1578", "action complete via Async Request", "2025-12-24 21:19:17", "2025-12-24 21:19:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4720", "1582", "action created", "2025-12-24 21:19:17", "2025-12-24 21:19:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4721", "1579", "action started via Async Request", "2025-12-24 21:19:17", "2025-12-24 21:19:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4722", "1579", "action complete via Async Request", "2025-12-24 21:19:17", "2025-12-24 21:19:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4723", "1583", "action created", "2025-12-24 21:19:17", "2025-12-24 21:19:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4724", "1581", "action started via Async Request", "2025-12-25 12:51:44", "2025-12-25 12:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4725", "1581", "action complete via Async Request", "2025-12-25 12:51:44", "2025-12-25 12:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4726", "1584", "action created", "2025-12-25 12:51:44", "2025-12-25 12:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4727", "1582", "action started via Async Request", "2025-12-26 02:53:31", "2025-12-26 02:53:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4728", "1582", "action complete via Async Request", "2025-12-26 02:53:31", "2025-12-26 02:53:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4729", "1585", "action created", "2025-12-26 02:53:31", "2025-12-26 02:53:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4730", "1583", "action started via Async Request", "2025-12-26 02:53:31", "2025-12-26 02:53:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4731", "1583", "action complete via Async Request", "2025-12-26 02:53:31", "2025-12-26 02:53:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4732", "1586", "action created", "2025-12-26 02:53:31", "2025-12-26 02:53:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4733", "1584", "action started via Async Request", "2025-12-26 02:53:31", "2025-12-26 02:53:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4734", "1584", "action complete via Async Request", "2025-12-26 02:53:31", "2025-12-26 02:53:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4735", "1587", "action created", "2025-12-26 02:53:31", "2025-12-26 02:53:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4736", "1588", "ایجاد فعالیت", "2025-12-26 10:59:17", "2025-12-26 10:59:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4737", "1589", "ایجاد فعالیت", "2025-12-26 11:09:20", "2025-12-26 11:09:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4738", "1588", "عملیات توسط Async Request شروع شد", "2025-12-26 11:09:22", "2025-12-26 11:09:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("4739", "1588", "عملیات توسط Async Request کامل شد", "2025-12-26 11:09:22", "2025-12-26 11:09:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("4740", "1590", "ایجاد فعالیت", "2025-12-26 11:09:22", "2025-12-26 11:09:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("4741", "1591", "action created", "2025-12-26 11:09:23", "2025-12-26 11:09:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("4742", "1592", "action created", "2025-12-26 11:09:33", "2025-12-26 11:09:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4743", "1593", "ایجاد فعالیت", "2025-12-26 11:10:02", "2025-12-26 11:10:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4744", "1594", "action created", "2025-12-26 11:10:07", "2025-12-26 11:10:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4745", "1595", "action created", "2025-12-26 11:10:07", "2025-12-26 11:10:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4746", "1596", "action created", "2025-12-26 11:10:07", "2025-12-26 11:10:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4747", "1597", "action created", "2025-12-26 11:10:07", "2025-12-26 11:10:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4748", "1598", "action created", "2025-12-26 11:10:07", "2025-12-26 11:10:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4749", "1599", "action created", "2025-12-26 11:10:07", "2025-12-26 11:10:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4750", "1600", "action created", "2025-12-26 11:10:07", "2025-12-26 11:10:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4751", "1601", "action created", "2025-12-26 11:10:07", "2025-12-26 11:10:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4752", "1591", "عملیات توسط Async Request شروع شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4753", "1591", "عملیات توسط Async Request کامل شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4754", "1592", "عملیات توسط Async Request شروع شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4755", "1592", "عملیات توسط Async Request کامل شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4756", "1593", "عملیات توسط Async Request شروع شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4757", "1593", "عملیات توسط Async Request کامل شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4758", "1594", "عملیات توسط Async Request شروع شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4759", "1594", "عملیات توسط Async Request کامل شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4760", "1601", "عملیات توسط Async Request شروع شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4761", "1601", "عملیات توسط Async Request کامل شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4762", "1595", "عملیات توسط Async Request شروع شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4763", "1595", "عملیات توسط Async Request کامل شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4764", "1596", "عملیات توسط Async Request شروع شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4765", "1596", "عملیات توسط Async Request کامل شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4766", "1597", "عملیات توسط Async Request شروع شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4767", "1597", "عملیات توسط Async Request کامل شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4768", "1598", "عملیات توسط Async Request شروع شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4769", "1598", "عملیات توسط Async Request کامل شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4770", "1599", "عملیات توسط Async Request شروع شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4771", "1599", "عملیات توسط Async Request کامل شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4772", "1600", "عملیات توسط Async Request شروع شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4773", "1600", "عملیات توسط Async Request کامل شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4774", "1589", "عملیات توسط Async Request شروع شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4775", "1589", "عملیات توسط Async Request کامل شد", "2025-12-26 11:10:31", "2025-12-26 11:10:31");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "یک نویسنده دیدگاه وردپرس", "wapuu@wordpress.example", "https://fa.wordpress.org/", "", "2024-11-22 18:14:46", "2024-11-22 14:44:46", "سلام، این یک دیدگاه است.\nبرای شروع مدیریت، ویرایش و پاک کردن دیدگاه‌ها، لطفا بخش دیدگاه‌ها در پیشخوان را ببینید.\nتصاویر نویسندگان دیدگاه از <a href=\"https://gravatar.com/\">Gravatar</a> گرفته می‌شود.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("2", "18", "lpldkcb", "", "", "", "2024-12-17 23:50:02", "2024-12-17 20:20:02", "شما می‌توانید هر گونه درخواست و همچنین انتقاد یا پیشنهادی را با ما در میان بگذارید.", "0", "1", "", "comment", "0", "1");
INSERT INTO `wp_comments` VALUES("4", "42", "John", "hsafhnvm@testing-your-form.info", "", "196.251.72.3", "2025-04-03 09:00:41", "2025-04-03 05:30:41", "BCQFRd CCLqfU LlTKaYk", "0", "0", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7; rv:132.0) Gecko/20100101 Firefox/132.0", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "42", "Frank1269", "Frank1269@gmail.com", "", "202.186.205.38", "2025-04-17 07:29:59", "2025-04-17 03:59:59", "<a href=\"https://honda-fit.ru/forums/index.php?autocom=gallery&amp;req=si&amp;img=7041\" rel=\"nofollow ugc\">https://honda-fit.ru/forums/index.php?autocom=gallery&amp;req=si&amp;img=7041</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "1", "John", "gyfwvzey@testing-your-form.info", "", "196.251.81.54", "2025-04-21 20:31:44", "2025-04-21 17:01:44", "kFUjI WmjihXJ ZsHl aDr mFxdV dMd", "0", "0", "Mozilla/5.0 (iPhone; CPU iPhone OS 17_7_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("7", "42", "* * * Win Free Cash Instantly: https://quickrxpads.com/index.php?uxpe38 * * * hs=9bb5519d722ad651f51b163776c3201b* ххх*", "pazapz@mailbox.in.ua", "", "107.189.3.94", "2025-06-16 22:15:35", "2025-06-16 18:45:35", "8jkv5t", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("8", "1", "* * * Claim Free iPhone 16 * * * hs=7ef29cff0baf8a5d6879725f345d920c* ххх*", "pazapz@mailbox.in.ua", "", "185.244.192.184", "2025-06-16 22:15:50", "2025-06-16 18:45:50", "twvyis", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "42", "Jesse2009", "Jesse2009@gmail.com", "", "23.237.210.82", "2025-10-05 02:14:51", "2025-10-04 22:44:51", "<a href=\"https://shorturl.fm/qKCPW\" rel=\"nofollow ugc\">https://shorturl.fm/qKCPW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("10", "42", "* * * $3,222 payment available! Confirm your transaction here: https://www.wolf-grid.com/index.php?zw1p2e * * * hs=9bb5519d722ad651f51b163776c3201b* ххх*", "paouqua@mailbox.in.ua", "", "204.137.14.104", "2025-10-06 04:59:20", "2025-10-06 01:29:20", "4hzeje", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("11", "1", "* * * $3,222 payment available! Confirm your operation here: http://assaafahotels.com/index.php?2xetwe * * * hs=7ef29cff0baf8a5d6879725f345d920c* ххх*", "paouqua@mailbox.in.ua", "", "185.220.101.15", "2025-11-10 14:55:10", "2025-11-10 11:25:10", "iymi6o", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("12", "42", "backlinks", "joycebauman1952@vargosmail.com", "", "85.90.208.132", "2025-12-03 01:40:59", "2025-12-02 22:10:59", "Эй, оптимизаторы — кто уже тестил, как работают бэки?\r\n\r\n\r\nНачал копать тему SEO и понял — пока \r\nне займёшься ссылочным — топа не будет.\r\n\r\n\r\nБрал ссылки вручную и через агрегаторы, но цены кусаются.\r\n\r\nВ итоге нашёл способ, который реально работает.\r\n\r\nНе буду спойлерить, но вот ссылка \r\n— переходите по кнопке ниже  backlinks .\r\n\r\n\r\n\r\nТам всё объяснено простым языком.\r\n\r\nВидно, что доноры живые, не ГС.\r\n\r\n\r\nТак что если ищете эффективный \r\nинструмент, рекомендую заглянуть.\r\n\r\nКому нужно — ссылка выше  https://kwork.ru/links/21204741/razmeshchenie-tekstov-zametok-relizov-v-sotsialnykh-zakladkakh", "0", "0", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("13", "42", "backlinks", "joycebauman1952@vargosmail.com", "", "85.90.208.132", "2025-12-03 01:41:20", "2025-12-02 22:11:20", "Эй, оптимизаторы — кто уже тестил, как работают \r\nбэки?\r\nНачал копать тему SEO и понял — пока не займёшься ссылочным — топа не \r\nбудет.\r\n\r\nБрал ссылки вручную и через агрегаторы, но цены кусаются.\r\n\r\nВ итоге нашёл способ, который реально работает.\r\n\r\nНе буду спойлерить, но вот ссылка — \r\nпереходите по кнопке ниже  backlinks .\r\n\r\n\r\nТам всё объяснено простым языком.\r\n\r\nВидно, что доноры живые, не ГС.\r\n\r\nТак что если ищете эффективный инструмент, рекомендую заглянуть.\r\n\r\nКому нужно — ссылка выше  https://kwork.ru/links/35702199/otpravlyu-vashi-ssylki-dlya-uskorennoy-indeksatsii-v-google", "0", "0", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("14", "1", "legendlinkph", "legendlinkph@legendlinkph.info", "https://legendlinkph.info", "143.58.144.105", "2025-12-06 01:01:58", "2025-12-05 21:31:58", "Interesting analysis! Seeing localized platforms like <a href=\'https://legendlinkph.info\' rel=\"nofollow ugc\">legend link ph login</a> thrive shows the demand for tailored gaming experiences. Fast withdrawals are key for serious players, too! 🤔", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/119.0", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("15", "1", "link368bet", "admin@link368bet.com", "https://link368bet.com", "45.204.209.253", "2025-12-15 03:40:31", "2025-12-15 00:10:31", "Need a quick link to 368bet? link368bet seems to do the trick. Sometimes those other sites are blocked, so it\'s handy to have a backup. Worth bookmarking, yeah? Check out <a href=\'https://link368bet.com\' rel=\"nofollow ugc\">link368bet</a> if you\'re having trouble getting through.", "0", "0", "Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("16", "42", "vip345apk", "admin@vip345apk.info", "https://vip345apk.info", "156.245.246.155", "2025-12-20 15:41:01", "2025-12-20 12:11:01", "VIP345APK... Sounds like an app download. Anyone know if it\'s safe and legit? What are the perks of <a href=\'https://vip345apk.info\' rel=\"nofollow ugc\">vip345apk</a>?", "0", "0", "Mozilla/5.0 (iPhone; CPU iPhone OS 18_1_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) GSA/363.0.743255906 Mobile/15E148 Safari/604.1", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("17", "42", "Как выбрать жильё посуточно", "bella-elston@gmail.com", "", "185.215.186.47", "2025-12-22 20:17:22", "2025-12-22 16:47:22", "Потрясающе веб-страница у вас есть прямо здесь.\r\nПосетите также мою страничку Как выбрать жильё посуточно https://tiktur.ru/bilety-i-oteli/", "0", "0", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("18", "42", "Как выбрать жильё посуточно", "bella-elston@gmail.com", "", "185.215.186.47", "2025-12-22 20:17:40", "2025-12-22 16:47:40", "Потрясающе веб-страница у вас есть прямо \r\nздесь. Посетите также мою \r\nстраничку Как выбрать жильё посуточно https://sutochny.ru/poleznyye-sovety/", "0", "0", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("19", "42", "Посуточно", "lakeisha.kopf_3942@polosmail.com", "", "185.215.186.47", "2025-12-25 06:33:45", "2025-12-25 03:03:45", "Вам предстоит командировка? \r\nВыбор жилья всегда важен. Сегодня у вас есть масса предложений: квартиры на сутки, отели разного уровня,\r\nдомики и гостевые дома на сутки.\r\nВсё, что остаётся — это выбрать лучший формат именно для вас.\r\n\r\nЗачем снимать жильё на сутки \r\nАрендуя квартиры, отели и гостевые \r\nдома на сутки, вы получаете:\r\n\r\n\r\n✅ Свободу выбора: аренда от суток до нескольких недель.\r\n\r\n✅ Экономию — квартиры и гостевые дома \r\nчасто дешевле отелей. \r\n✅ Комфорт — возможность готовить дома, \r\nбольше пространства для семьи.\r\n\r\n✅ Большой выбор форматов жилья.\r\n\r\nгостевые дома на сутки\r\n\r\n@airbn@b77 https://lord-watch.ru/bitrix/redirect.php?goto=https://mytischi-city.ru/imgnews/aHR0cHM6Ly9zYWRhLS1jb2xvci1tYWtpMy1uZXQudHJhbnNsYXRlLmdvb2cvYmJzL2Jicy5jZ2k/cGFnZT0wJl94X3RyX3NjaD1odHRwJl94X3RyX3NsPWF1dG8mX3hfdHJfdGw9ZnImX3hfdHJfaGw9ZnI=", "0", "0", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("20", "42", "Виртуальные карты для бизнеса", "manuelmullah_1938@gmail.com", "", "185.215.186.47", "2025-12-25 14:01:49", "2025-12-25 10:31:49", "Рассмотрим подробнее XCARDS — сервис, о котором сейчас говорят.\r\n\r\n\r\nСовсем недавно обнаружил на виртуальный сервис XCARDS,\r\nкоторый помогает оформлять цифровые банковские карты чтобы \r\nоплачивать сервисы.\r\n\r\nОсобенности, на которые я обратил внимание:\r\n\r\nВыпуск занимает всего несколько минут.\r\n\r\nСервис позволяет оформить неограниченное \r\nколичество карт.\r\nЕсть поддержка в любое время суток и даже через Telegram-бота.\r\n\r\nЕсть контроль онлайн — лимиты, \r\nуведомления, отчёты, статистика.\r\n\r\n\r\nНа что стоит обратить внимание:\r\n\r\nРегистрация: европейская юрисдикция — лучше проверить, \r\nчто сервис можно использовать \r\nбез нарушений.\r\n\r\nСтоимость: карты заявлены как “бесплатные”, но дополнительные сборы, поэтому \r\nлучше внимательно изучить раздел с тарифами.\r\n\r\n\r\nПрактический опыт: по отзывам поддержка \r\nработает быстро.\r\n\r\nНадёжность системы: все операции подтверждаются \r\nуведомлениями, но всегда лучше отслеживать транзакции вручную.\r\n\r\n\r\nВывод:\r\nВ целом платформа кажется\r\nполезным сервисом для бизнеса.\r\n\r\nСервис совмещает скорость, удобство и гибкость.\r\n\r\n\r\nКак вы думаете?\r\nПользовались ли вы XCARDS?\r\n\r\nПоделитесь опытом — будет интересно \r\nсравнить. Виртуальные карты для бизнеса https://tinyurl.com/4h7kcs2r", "0", "0", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("21", "42", "Виртуальные карты для бизнеса", "manuelmullah_1938@gmail.com", "", "185.215.186.47", "2025-12-25 14:02:15", "2025-12-25 10:32:15", "Рассмотрим подробнее XCARDS — сервис,\r\nо котором сейчас говорят.\r\n\r\nСовсем недавно обнаружил на виртуальный \r\nсервис XCARDS, который помогает оформлять цифровые банковские карты чтобы оплачивать сервисы.\r\n\r\n\r\nОсобенности, на которые я обратил внимание:\r\n\r\nВыпуск занимает всего несколько \r\nминут.\r\nСервис позволяет оформить неограниченное \r\nколичество карт.\r\nЕсть поддержка в любое время суток и даже через Telegram-бота.\r\n\r\nЕсть контроль онлайн — лимиты, \r\nуведомления, отчёты, статистика.\r\n\r\n\r\n\r\nНа что стоит обратить внимание:\r\n\r\nРегистрация: европейская юрисдикция — лучше проверить, что сервис можно использовать \r\nбез нарушений.\r\n\r\nСтоимость: карты заявлены как “бесплатные”, \r\nно дополнительные сборы, поэтому лучше внимательно изучить раздел с тарифами.\r\n\r\n\r\nПрактический опыт: по отзывам поддержка работает быстро.\r\n\r\n\r\nНадёжность системы: все операции \r\nподтверждаются уведомлениями, но всегда лучше отслеживать транзакции вручную.\r\n\r\n\r\nВывод:\r\nВ целом платформа кажется\r\nполезным сервисом для бизнеса.\r\n\r\nСервис совмещает скорость, удобство и гибкость.\r\n\r\n\r\nКак вы думаете?\r\nПользовались ли вы XCARDS?\r\nПоделитесь опытом — будет интересно сравнить.\r\nВиртуальные карты для бизнеса https://tinyurl.com/antarctic-wallet", "0", "0", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("8", "mianabpefinall", "09a25d93da2b744f1401_20251226112125", "21", "2025-12-26 11:21:39", "mohammadrezabehdarvand@gmail.com", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-26 11:21:25\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:7:\"10.6.24\";s:10:\"VersionPHP\";s:6:\"8.1.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:8;s:4:\"Name\";s:14:\"mianabpefinall\";s:4:\"Hash\";s:35:\"09a25d93da2b744f1401_20251226112125\";s:8:\"NameHash\";s:50:\"mianabpefinall_09a25d93da2b744f1401_20251226112125\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:60:\"mianabpefinall_09a25d93da2b744f1401_20251226112125_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.1\";s:6:\"WPUser\";s:32:\"mohammadrezabehdarvand@gmail.com\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:62:\"mianabpefinall_09a25d93da2b744f1401_20251226112125_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:47:\"/home/fekragam/domains/mianabpe.com/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2888;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:18884;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-26 11:21:25\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:7:\"10.6.24\";s:10:\"VersionPHP\";s:6:\"8.1.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:14:\"mianabpefinall\";s:4:\"Hash\";s:35:\"09a25d93da2b744f1401_20251226112125\";s:8:\"NameHash\";s:50:\"mianabpefinall_09a25d93da2b744f1401_20251226112125\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:68:\"mianabpefinall_09a25d93da2b744f1401_20251226112125_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:61:\"/home/fekragam/domains/mianabpe.com/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:63:\"mianabpefinall_09a25d93da2b744f1401_20251226112125_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:143:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/backups-dup-lite/tmp/mianabpefinall_09a25d93da2b744f1401_20251226112125_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:56:\"/home/fekragam/domains/mianabpe.com/public_html/wp-admin\";i:1;s:59:\"/home/fekragam/domains/mianabpe.com/public_html/wp-includes\";i:2;s:68:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:47:\"/home/fekragam/domains/mianabpe.com/public_html\";i:1;s:47:\"/home/fekragam/domains/mianabpe.com/public_html\";i:2;s:58:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content\";i:3;s:66:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/uploads\";i:4;s:66:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/plugins\";i:5;s:69:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/mu-plugins\";i:6;s:65:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:79:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:22:{i:1766748101;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1766749487;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1766749879;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1766750262;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1766750293;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1766756571;a:1:{s:35:\"yith_wcan_delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766760287;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766760306;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1766760313;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766761302;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766763886;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1766765686;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1766767486;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1766768258;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766768262;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766790862;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1766793600;a:2:{s:35:\"rank_math/redirection/clean_trashed\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"rank_math/links/internal_links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766806405;a:1:{s:35:\"rank_math/content-ai/update_prompts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766846687;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766882719;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1767004200;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "https://mianabpe.com", "on");
INSERT INTO `wp_options` VALUES("3", "home", "https://mianabpe.com", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "لوله و پلی اتیلن میاناب", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "mohammadrezabehdarvand@gmail.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "6", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "0", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:191:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:15:\"^checkout-link$\";s:28:\"index.php?checkout-link=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:47:\"برند/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:42:\"برند/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:23:\"برند/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:35:\"برند/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:17:\"برند/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:23:\"index.php?sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=18&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:8:{i:0;s:36:\"contact-form-7/wp-contact-form-7.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:35:\"redux-framework/redux-framework.php\";i:4;s:30:\"seo-by-rank-math/rank-math.php\";i:5;s:25:\"tablepress/tablepress.php\";i:6;s:35:\"taxonomy-images/taxonomy-images.php\";i:8;s:27:\"woocommerce/woocommerce.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "3.5", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "a:5:{i:0;s:103:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/themes/mohammadrezabehdarvand/front-page.php\";i:1;s:98:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/themes/mohammadrezabehdarvand/style.css\";i:2;s:151:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/themes/mohammadrezabehdarvand/template-parts/category-product/category-product-not-slide.php\";i:3;s:145:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/themes/mohammadrezabehdarvand/template-parts/slider-width/slider-desktop-main-page.php\";i:4;s:120:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/themes/mohammadrezabehdarvand/inc/panel-option/main-panel.php\";}", "off");
INSERT INTO `wp_options` VALUES("41", "template", "mohammadrezabehdarvand", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "mohammadrezabehdarvand", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "shop_manager", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "60717", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:2:{i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:72:\"طراحی و توسعه توسط <b>محمدرضا بهداروند</b>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "on");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:1:{s:37:\"user-role-editor/user-role-editor.php\";a:2:{i:0;s:16:\"User_Role_Editor\";i:1;s:9:\"uninstall\";}}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "16", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "18", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "606", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1747838686", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:154:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"rank_math_edit_htaccess\";b:1;s:16:\"rank_math_titles\";b:1;s:17:\"rank_math_general\";b:1;s:17:\"rank_math_sitemap\";b:1;s:21:\"rank_math_404_monitor\";b:1;s:22:\"rank_math_link_builder\";b:1;s:22:\"rank_math_redirections\";b:1;s:22:\"rank_math_role_manager\";b:1;s:19:\"rank_math_analytics\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:25:\"rank_math_onpage_advanced\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:20:\"rank_math_content_ai\";b:1;s:19:\"rank_math_admin_bar\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:23:\"tablepress_edit_options\";b:1;s:28:\"tablepress_import_tables_url\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:24:\"wpcf7_edit_contact_forms\";b:1;s:22:\"edit_tablepress_tables\";b:1;s:29:\"edit_others_tablepress_tables\";b:1;s:25:\"publish_tablepress_tables\";b:1;s:30:\"read_private_tablepress_tables\";b:1;s:24:\"delete_tablepress_tables\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:49:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:28:\"tablepress_import_tables_url\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:23:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:109:{s:20:\"assign_product_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:19:\"delete_others_pages\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_others_products\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:12:\"delete_pages\";b:1;s:12:\"delete_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:23:\"delete_private_products\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:14:\"delete_product\";b:1;s:20:\"delete_product_terms\";b:1;s:15:\"delete_products\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:25:\"delete_published_products\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:18:\"delete_shop_coupon\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:19:\"delete_shop_coupons\";b:1;s:17:\"delete_shop_order\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:18:\"delete_shop_orders\";b:1;s:24:\"delete_tablepress_tables\";b:1;s:17:\"edit_others_pages\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_others_products\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:29:\"edit_others_tablepress_tables\";b:1;s:10:\"edit_pages\";b:1;s:10:\"edit_posts\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:21:\"edit_private_products\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:12:\"edit_product\";b:1;s:18:\"edit_product_terms\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_published_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:23:\"edit_published_products\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:16:\"edit_shop_coupon\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:17:\"edit_shop_coupons\";b:1;s:15:\"edit_shop_order\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:16:\"edit_shop_orders\";b:1;s:22:\"edit_tablepress_tables\";b:1;s:18:\"edit_theme_options\";b:1;s:11:\"edit_themes\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:7:\"level_2\";b:1;s:7:\"level_3\";b:1;s:7:\"level_4\";b:1;s:7:\"level_5\";b:1;s:7:\"level_6\";b:1;s:7:\"level_7\";b:1;s:7:\"level_8\";b:1;s:7:\"level_9\";b:1;s:10:\"list_users\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:14:\"manage_options\";b:1;s:20:\"manage_product_terms\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:18:\"manage_woocommerce\";b:1;s:17:\"moderate_comments\";b:1;s:13:\"publish_pages\";b:1;s:13:\"publish_posts\";b:1;s:16:\"publish_products\";b:1;s:20:\"publish_shop_coupons\";b:1;s:19:\"publish_shop_orders\";b:1;s:25:\"publish_tablepress_tables\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:21:\"read_private_products\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:24:\"read_private_shop_orders\";b:1;s:30:\"read_private_tablepress_tables\";b:1;s:12:\"read_product\";b:1;s:16:\"read_shop_coupon\";b:1;s:15:\"read_shop_order\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:23:\"tablepress_edit_options\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:28:\"tablepress_import_tables_url\";b:1;s:22:\"tablepress_list_tables\";b:1;s:12:\"upload_files\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:16:\"create_customers\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "WPLANG", "fa_IR", "auto");
INSERT INTO `wp_options` VALUES("105", "user_count", "2", "off");
INSERT INTO `wp_options` VALUES("106", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("107", "sidebars_widgets", "a:14:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:14:\"footer-address\";a:1:{i:0;s:13:\"custom_html-2\";}s:16:\"footer-right-one\";a:1:{i:0;s:10:\"nav_menu-3\";}s:16:\"footer-right-two\";a:1:{i:0;s:10:\"nav_menu-2\";}s:18:\"footer-right-three\";a:0:{}s:16:\"footer_copyright\";a:1:{i:0;s:6:\"text-3\";}s:22:\"filter_product_archive\";a:0:{}s:18:\"footer_majavez_one\";a:0:{}s:18:\"footer_majavez_two\";a:0:{}s:20:\"footer_majavez_three\";a:0:{}s:19:\"footer_majavez_four\";a:0:{}s:19:\"footer_majavez_five\";a:0:{}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_nav_menu", "a:3:{i:2;a:2:{s:5:\"title\";s:25:\"فهرست ابتدایی\";s:8:\"nav_menu\";i:34;}i:3;a:2:{s:5:\"title\";s:21:\"دسترسی سریع\";s:8:\"nav_menu\";i:29;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "widget_custom_html", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:698:\"    <div class=\"text-base font-bold text-zinc-800 flex p-0 m-0 items-center justify-center md:justify-end h-auto pb-2 bg-slate-50 mt-10 flex-wrap\">\r\n\r\n        <span class=\"px-1\">تلفن های پشتیبانی:</span>\r\n\r\n        <div class=\"flex\">\r\n            <a href=\"tel:06136210009\">06136210009</a>\r\n            <span class=\"px-2\">-</span>\r\n            <a href=\"tel:061362220009\">061362220009</a>\r\n            <span class=\"px-2\">-</span>\r\n            <a href=\"tel:09169097809\">09169097809</a>\r\n        </div>\r\n\r\n    </div>\r\n    دفتر مرکزی: ایران – استان خوزستان – شهرستان شوشتر – میدان غدیر – روبروی پارک شهید کجباف\r\n\r\n\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("128", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1732287265;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("129", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("159", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("160", "current_theme", "", "auto");
INSERT INTO `wp_options` VALUES("161", "theme_mods_mohammadrezabehdarvand", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:4:{s:6:\"menu-1\";i:0;s:11:\"header-menu\";i:2;s:10:\"extra-menu\";i:0;s:21:\"category-product-menu\";i:2;}s:18:\"custom_css_post_id\";i:281;}", "on");
INSERT INTO `wp_options` VALUES("162", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("165", "data_var_option_theme", "a:92:{s:8:\"last_tab\";s:1:\"1\";s:11:\"header-logo\";a:5:{s:3:\"url\";s:63:\"https://mianabpe.com/wp-content/uploads/2024/12/New-Project.png\";s:2:\"id\";s:2:\"60\";s:6:\"height\";s:3:\"500\";s:5:\"width\";s:4:\"1500\";s:9:\"thumbnail\";s:63:\"https://mianabpe.com/wp-content/uploads/2024/12/New-Project.png\";}s:11:\"footer-logo\";a:5:{s:3:\"url\";s:63:\"https://mianabpe.com/wp-content/uploads/2024/12/New-Project.png\";s:2:\"id\";s:2:\"60\";s:6:\"height\";s:3:\"500\";s:5:\"width\";s:4:\"1500\";s:9:\"thumbnail\";s:63:\"https://mianabpe.com/wp-content/uploads/2024/12/New-Project.png\";}s:19:\"header-logo_favicon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:45:\"Support_contact_number_to_solve_problems_text\";s:11:\"09169097509\";s:52:\"Support_header_contact_number_to_solve_problems_text\";s:11:\"09169097509\";s:27:\"switch-learn-phy_singe_post\";s:1:\"0\";s:36:\"switch-learn-phy_category_singe_post\";s:1:\"0\";s:35:\"switch-learn-phy_monthly_singe_post\";s:1:\"0\";s:43:\"switch_learn_phy_Latest_articles_singe_post\";s:1:\"0\";s:22:\"social_network_youtube\";s:1:\"#\";s:22:\"social_network_twitter\";s:1:\"#\";s:24:\"social_network_instagram\";s:1:\"#\";s:23:\"social_network_linkedin\";s:1:\"#\";s:23:\"social_network_telegram\";s:30:\"https://t.me/+SflNDb0hIdpmYTJk\";s:23:\"social_network_facebook\";s:1:\"#\";s:21:\"social_network_aparat\";s:1:\"#\";s:32:\"repeater-field-add_item_for_sale\";a:1:{s:19:\"redux_repeater_data\";a:5:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}i:4;a:1:{s:5:\"title\";s:0:\"\";}}}s:29:\"title_field_add_item_for_sale\";a:5:{i:0;s:50:\"مشاوره رایگان حضوری و تلفنی\";i:1;s:49:\"پشتیبانی و خدمات پس از فروش\";i:2;s:47:\"گواهی استاندارد ملی ایران\";i:3;s:62:\"کنترل کیفی محصولات توسط کارشناسان\";i:4;s:71:\"انجام آزمون‌های MFR، CBC، OIT، کشش و پراکنش\";}s:37:\"repeater-field-add_item_for_sale_note\";a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}s:34:\"title_field_add_item_for_sale_note\";a:1:{i:0;s:0:\"\";}s:26:\"img_slider_mobile_repeater\";a:1:{s:19:\"redux_repeater_data\";a:3:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}}}s:17:\"img_slider_mobile\";a:3:{i:0;a:5:{s:3:\"url\";s:72:\"https://mianabpe.com/wp-content/uploads/2025/03/3.-200-100-2-scaled.webp\";s:2:\"id\";s:3:\"562\";s:6:\"height\";s:4:\"1280\";s:5:\"width\";s:4:\"2560\";s:9:\"thumbnail\";s:73:\"https://mianabpe.com/wp-content/uploads/2025/03/3.-200-100-2-150x150.webp\";}i:1;a:5:{s:3:\"url\";s:61:\"https://mianabpe.com/wp-content/uploads/2025/03/2-scaled.webp\";s:2:\"id\";s:3:\"563\";s:6:\"height\";s:4:\"1280\";s:5:\"width\";s:4:\"2560\";s:9:\"thumbnail\";s:62:\"https://mianabpe.com/wp-content/uploads/2025/03/2-150x150.webp\";}i:2;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:32:\"img_slider_mobile_text_url_tag_a\";a:3:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";}s:22:\"img_slider_mobile_text\";a:3:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";}s:27:\"img_slider_desktop_repeater\";a:1:{s:19:\"redux_repeater_data\";a:2:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}}}s:18:\"img_slider_desktop\";a:2:{i:0;a:5:{s:3:\"url\";s:72:\"https://mianabpe.com/wp-content/uploads/2025/03/3.-200-100-2-scaled.webp\";s:2:\"id\";s:3:\"562\";s:6:\"height\";s:4:\"1280\";s:5:\"width\";s:4:\"2560\";s:9:\"thumbnail\";s:73:\"https://mianabpe.com/wp-content/uploads/2025/03/3.-200-100-2-150x150.webp\";}i:1;a:5:{s:3:\"url\";s:61:\"https://mianabpe.com/wp-content/uploads/2025/03/2-scaled.webp\";s:2:\"id\";s:3:\"563\";s:6:\"height\";s:4:\"1280\";s:5:\"width\";s:4:\"2560\";s:9:\"thumbnail\";s:62:\"https://mianabpe.com/wp-content/uploads/2025/03/2-150x150.webp\";}}s:32:\"img_slider_desktop_editor__title\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:33:\"img_slider_desktop_text_url_tag_a\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:23:\"img_slider_desktop_text\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:50:\"sticky_social_networks_at_the_bottom_telegram_name\";s:0:\"\";s:45:\"sticky_social_networks_at_the_bottom_telegram\";s:30:\"https://t.me/+SflNDb0hIdpmYTJk\";s:51:\"sticky_social_networks_at_the_bottom_telegram_media\";a:5:{s:3:\"url\";s:64:\"https://mianabpe.com/wp-content/uploads/2024/12/تلگرام.png\";s:2:\"id\";s:2:\"71\";s:6:\"height\";s:3:\"150\";s:5:\"width\";s:3:\"150\";s:9:\"thumbnail\";s:64:\"https://mianabpe.com/wp-content/uploads/2024/12/تلگرام.png\";}s:44:\"sticky_social_networks_at_the_bottom_wp_name\";s:0:\"\";s:39:\"sticky_social_networks_at_the_bottom_wp\";s:12:\"986136220009\";s:45:\"sticky_social_networks_at_the_bottom_wp_media\";a:5:{s:3:\"url\";s:65:\"https://mianabpe.com/wp-content/uploads/2024/12/New-Project-3.png\";s:2:\"id\";s:2:\"72\";s:6:\"height\";s:3:\"150\";s:5:\"width\";s:3:\"150\";s:9:\"thumbnail\";s:65:\"https://mianabpe.com/wp-content/uploads/2024/12/New-Project-3.png\";}s:45:\"sticky_social_networks_at_the_bottom_ita_name\";s:0:\"\";s:40:\"sticky_social_networks_at_the_bottom_ita\";s:8:\"mianabpe\";s:46:\"sticky_social_networks_at_the_bottom_ita_media\";a:5:{s:3:\"url\";s:65:\"https://mianabpe.com/wp-content/uploads/2024/12/New-Project-7.png\";s:2:\"id\";s:2:\"76\";s:6:\"height\";s:3:\"150\";s:5:\"width\";s:3:\"150\";s:9:\"thumbnail\";s:65:\"https://mianabpe.com/wp-content/uploads/2024/12/New-Project-7.png\";}s:46:\"sticky_social_networks_at_the_bottom_call_name\";s:21:\"تماس: 09169097809\";s:41:\"sticky_social_networks_at_the_bottom_call\";s:11:\"09169097809\";s:47:\"sticky_social_networks_at_the_bottom_call_media\";a:5:{s:3:\"url\";s:65:\"https://mianabpe.com/wp-content/uploads/2024/12/New-Project-5.png\";s:2:\"id\";s:2:\"74\";s:6:\"height\";s:3:\"150\";s:5:\"width\";s:3:\"150\";s:9:\"thumbnail\";s:65:\"https://mianabpe.com/wp-content/uploads/2024/12/New-Project-5.png\";}s:45:\"introducing_important_products_for_home_title\";s:37:\"محصولات شرکت میاناب \";s:49:\"introducing_important_products_for_home_title_des\";s:126:\"در اینجا می توانید برخی از مهمترین محصولات شرکت میاناب را مشاهده کنید\";s:43:\"introducing_important_products_for_home_tax\";a:1:{s:19:\"redux_repeater_data\";a:3:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}}}s:44:\"introducing_important_products_for_home_text\";a:3:{i:0;s:106:\"لوله پلی اتیلن (لوله های آبرسانی، فاضلابی و زهکشی تحت فشار)\";i:1;s:34:\"منهول (خروجی مرکزی)\";i:2;s:28:\"پروانه هواده (PP)\";}s:51:\"introducing_important_products_for_home_description\";a:3:{i:0;s:625:\"شرکت میان آب پلیمر با تجهیزات پیشرفته، لوله‌های پلی‌اتیلن در سایز 16 تا 315 میلی‌متر و فشار 3 تا 25 بار را با گریدهای PE100 و PE80 تولید می‌کند. محصولات شامل لوله‌های آبرسانی، فاضلابی، زهکشی و قطعات موردنیاز صنعت پرورش میگو هستند. این لوله‌ها برای انتقال آب آشامیدنی، فاضلاب شهری و صنعتی استفاده شده و با استانداردهای ملی و بین‌المللی تولید می‌شوند.\";i:1;s:609:\"شرکت میان آب پلمیر از منهول‌های پلی‌اتیلن با تغییراتی در طراحی برای توالت مرکزی استخرهای پرورش میگو استفاده می‌کند. این منهول‌ها در ابعاد مختلف (۱۰۰×۱۶۰، ۱۰۰×۱۵۰، ۱۲۰×۱۸۰) متناسب با وسعت مزرعه تغییر می‌کنند. خروجی مرکزی آن‌ها فضولات و پسماند غذا را از استخر خارج کرده، گازهای مضر را کاهش داده و تغذیه و برداشت میگو را بهبود می‌بخشد.\";i:2;s:697:\"پروانه هواده یکی از اجزای مهم سیستم‌های هوادهی است که با ایجاد جریان و تلاطم در آب، اکسیژن‌رسانی را افزایش داده و کیفیت آب را بهبود می‌بخشد. این وسیله در استخرهای پرورش ماهی، تصفیه‌خانه‌های فاضلاب و محیط‌های آبی دیگر استفاده می‌شود و با کاهش لایه‌بندی حرارتی، توزیع یکنواخت اکسیژن و دما را تضمین می‌کند. همچنین، از تجمع گازهای مضر جلوگیری کرده و به رشد و سلامت آبزیان کمک می‌کند.\";}s:43:\"introducing_important_products_for_home_img\";a:3:{i:0;a:5:{s:3:\"url\";s:103:\"https://mianabpe.com/wp-content/uploads/2025/04/لوله-پلی-اتیلن-مریدی-میاناب.webp\";s:2:\"id\";s:3:\"630\";s:6:\"height\";s:4:\"1024\";s:5:\"width\";s:4:\"1024\";s:9:\"thumbnail\";s:111:\"https://mianabpe.com/wp-content/uploads/2025/04/لوله-پلی-اتیلن-مریدی-میاناب-150x150.webp\";}i:1;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/wp-content/uploads/2025/04/منهول-شرکت-میاناب.webp\";s:2:\"id\";s:3:\"629\";s:6:\"height\";s:4:\"1024\";s:5:\"width\";s:4:\"1024\";s:9:\"thumbnail\";s:93:\"https://mianabpe.com/wp-content/uploads/2025/04/منهول-شرکت-میاناب-150x150.webp\";}i:2;a:5:{s:3:\"url\";s:103:\"https://mianabpe.com/wp-content/uploads/2025/04/پروانه-هواده-PP-شرکت-میاناب-1.webp\";s:2:\"id\";s:3:\"628\";s:6:\"height\";s:4:\"1024\";s:5:\"width\";s:4:\"1024\";s:9:\"thumbnail\";s:111:\"https://mianabpe.com/wp-content/uploads/2025/04/پروانه-هواده-PP-شرکت-میاناب-1-150x150.webp\";}}s:31:\"img_slider_desktop_repeater_tax\";a:1:{s:19:\"redux_repeater_data\";a:3:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}}}s:22:\"img_slider_desktop_tax\";a:3:{i:0;a:5:{s:3:\"url\";s:60:\"https://mianabpe.com/wp-content/uploads/2025/03/IMG_7903.jpg\";s:2:\"id\";s:3:\"536\";s:6:\"height\";s:4:\"1500\";s:5:\"width\";s:4:\"2000\";s:9:\"thumbnail\";s:68:\"https://mianabpe.com/wp-content/uploads/2025/03/IMG_7903-150x150.jpg\";}i:1;a:5:{s:3:\"url\";s:103:\"https://mianabpe.com/wp-content/uploads/2024/12/984a733854009523a318d2edb55f09c9dfac6e02_1732720127.gif\";s:2:\"id\";s:2:\"38\";s:6:\"height\";s:3:\"328\";s:5:\"width\";s:3:\"820\";s:9:\"thumbnail\";s:103:\"https://mianabpe.com/wp-content/uploads/2024/12/984a733854009523a318d2edb55f09c9dfac6e02_1732720127.gif\";}i:2;a:5:{s:3:\"url\";s:103:\"https://mianabpe.com/wp-content/uploads/2024/12/601c2bda992dc57716959584c0a6debc12cecb79_1732719831.jpg\";s:2:\"id\";s:2:\"39\";s:6:\"height\";s:3:\"328\";s:5:\"width\";s:3:\"820\";s:9:\"thumbnail\";s:103:\"https://mianabpe.com/wp-content/uploads/2024/12/601c2bda992dc57716959584c0a6debc12cecb79_1732719831.jpg\";}}s:21:\"display-disable_store\";s:1:\"1\";s:17:\"editor__title_404\";s:0:\"\";s:13:\"bg__title_404\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:35:\"display-post-category-in-front-page\";s:1:\"0\";s:38:\"display-product-category-in-front-page\";s:1:\"1\";s:22:\"bg__title_category_woo\";s:45:\"دسته بندی محصولات میاناب\";s:26:\"editor__title_category_woo\";s:148:\"تنوع محصولات میاناب، پاسخ‌گوی نیازهای مختلف در صنعت و کشاورزی با کیفیتی بی‌نظیر\";s:23:\"bg__title_category_post\";s:0:\"\";s:27:\"editor__title_category_post\";s:151:\"<img class=\"alignnone size-full wp-image-72\" src=\"https://mianabpe.com/wp-content/uploads/2024/12/New-Project-3.png\" alt=\"\" width=\"150\" height=\"150\" />\";s:18:\"bg__title_call_woo\";s:96:\"اگر سوالی دارید؟ یا قصد خرید دارید! با ما تماس بگیرید.\";s:22:\"editor__title_call_woo\";s:151:\"شما می‌توانید هر گونه درخواست و همچنین انتقاد یا پیشنهادی را با ما در میان بگذارید.\";s:21:\"bg__title_call_number\";s:11:\"06136220009\";s:26:\"bg__title_call_number_text\";s:53:\"تماس سریع با کارشناسان 06136220009\";s:15:\"bg__title__home\";s:21:\"نمایشگاه ها\";s:23:\"editor__title__home_des\";s:0:\"\";s:31:\"bg__title_mdu_home_page_desktop\";a:5:{s:3:\"url\";s:68:\"https://mianabpe.com/wp-content/uploads/2025/04/شرکت-scaled.webp\";s:2:\"id\";s:3:\"582\";s:6:\"height\";s:3:\"533\";s:5:\"width\";s:4:\"2560\";s:9:\"thumbnail\";s:69:\"https://mianabpe.com/wp-content/uploads/2025/04/شرکت-150x150.webp\";}s:41:\"bg__title_mdu_home_page_desktop_url_tag_a\";s:0:\"\";s:30:\"bg__title_mdu_home_page_mobile\";a:5:{s:3:\"url\";s:68:\"https://mianabpe.com/wp-content/uploads/2025/04/شرکت-scaled.webp\";s:2:\"id\";s:3:\"582\";s:6:\"height\";s:3:\"533\";s:5:\"width\";s:4:\"2560\";s:9:\"thumbnail\";s:69:\"https://mianabpe.com/wp-content/uploads/2025/04/شرکت-150x150.webp\";}s:20:\"bg__title__home_work\";s:51:\"معرفی برخی از شرکت های همکار\";s:25:\"editor__title__home__work\";s:0:\"\";s:38:\"img_slider_mobile_repeater__home__work\";a:1:{s:19:\"redux_repeater_data\";a:8:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}i:4;a:1:{s:5:\"title\";s:0:\"\";}i:5;a:1:{s:5:\"title\";s:0:\"\";}i:6;a:1:{s:5:\"title\";s:0:\"\";}i:7;a:1:{s:5:\"title\";s:0:\"\";}}}s:29:\"img_slider_mobile__home__work\";a:8:{i:0;a:5:{s:3:\"url\";s:67:\"https://mianabpe.com/wp-content/uploads/2025/03/پلی-رود-1.jpg\";s:2:\"id\";s:3:\"575\";s:6:\"height\";s:3:\"300\";s:5:\"width\";s:3:\"300\";s:9:\"thumbnail\";s:75:\"https://mianabpe.com/wp-content/uploads/2025/03/پلی-رود-1-150x150.jpg\";}i:1;a:5:{s:3:\"url\";s:73:\"https://mianabpe.com/wp-content/uploads/2025/03/شیلنگ-لوله-1.jpg\";s:2:\"id\";s:3:\"574\";s:6:\"height\";s:3:\"300\";s:5:\"width\";s:3:\"300\";s:9:\"thumbnail\";s:81:\"https://mianabpe.com/wp-content/uploads/2025/03/شیلنگ-لوله-1-150x150.jpg\";}i:2;a:5:{s:3:\"url\";s:67:\"https://mianabpe.com/wp-content/uploads/2025/03/اب-صنعت-1.jpg\";s:2:\"id\";s:3:\"573\";s:6:\"height\";s:3:\"300\";s:5:\"width\";s:3:\"300\";s:9:\"thumbnail\";s:75:\"https://mianabpe.com/wp-content/uploads/2025/03/اب-صنعت-1-150x150.jpg\";}i:3;a:5:{s:3:\"url\";s:70:\"https://mianabpe.com/wp-content/uploads/2025/03/ابنهالان-1.jpg\";s:2:\"id\";s:3:\"572\";s:6:\"height\";s:3:\"300\";s:5:\"width\";s:3:\"300\";s:9:\"thumbnail\";s:78:\"https://mianabpe.com/wp-content/uploads/2025/03/ابنهالان-1-150x150.jpg\";}i:4;a:5:{s:3:\"url\";s:64:\"https://mianabpe.com/wp-content/uploads/2025/03/اسایش-1.jpg\";s:2:\"id\";s:3:\"571\";s:6:\"height\";s:3:\"300\";s:5:\"width\";s:3:\"300\";s:9:\"thumbnail\";s:72:\"https://mianabpe.com/wp-content/uploads/2025/03/اسایش-1-150x150.jpg\";}i:5;a:5:{s:3:\"url\";s:64:\"https://mianabpe.com/wp-content/uploads/2025/03/الوند-1.jpg\";s:2:\"id\";s:3:\"570\";s:6:\"height\";s:3:\"300\";s:5:\"width\";s:3:\"300\";s:9:\"thumbnail\";s:72:\"https://mianabpe.com/wp-content/uploads/2025/03/الوند-1-150x150.jpg\";}i:6;a:5:{s:3:\"url\";s:64:\"https://mianabpe.com/wp-content/uploads/2025/03/ویسپار.jpg\";s:2:\"id\";s:3:\"576\";s:6:\"height\";s:3:\"300\";s:5:\"width\";s:3:\"300\";s:9:\"thumbnail\";s:72:\"https://mianabpe.com/wp-content/uploads/2025/03/ویسپار-150x150.jpg\";}i:7;a:5:{s:3:\"url\";s:71:\"https://mianabpe.com/wp-content/uploads/2025/03/پارس-پلیمر.jpg\";s:2:\"id\";s:3:\"577\";s:6:\"height\";s:3:\"300\";s:5:\"width\";s:3:\"300\";s:9:\"thumbnail\";s:79:\"https://mianabpe.com/wp-content/uploads/2025/03/پارس-پلیمر-150x150.jpg\";}}s:34:\"img_slider_mobile__home__work_text\";a:8:{i:0;s:10:\"شرکت 2\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";}s:28:\"bg__title__home_comment-user\";s:0:\"\";s:34:\"editor__title__home___comment-user\";s:47:\"نظرات کاربران شرکت میاناب\";s:35:\"img_slider__repeater___comment-user\";a:1:{s:19:\"redux_repeater_data\";a:3:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}}}s:31:\"img_slider__home___comment-user\";a:3:{i:0;s:1215:\"<p>\r\nبرای یکی از مزارعمون در بوشهر به‌دنبال لوله و اتصالات باکیفیت برای خط انتقال آب بودیم. از طریق جستجو در اینترنت با سایت <a href=\"https://mianabpe.com\" target=\"_blank\">mianabpe.com</a> آشنا شدم. با شرکت تماس گرفتم و تیم فروش خیلی سریع و دقیق اطلاعات کامل محصولات رو در اختیارم گذاشتند.  \r\n<br>\r\nنکته‌ای که واقعاً برام جالب بود، پاسخ‌گویی سریع و مسئولانه‌شون بود. در همون تماس اول مشاوره‌های لازم رو دریافت کردم و به‌سرعت سفارش ثبت و بارگیری انجام شد.  \r\n<br>\r\nوقتی بار به مزرعه رسید، همه چیز منظم، دقیق و طبق سفارش بود. کیفیت لوله‌ها بسیار بالاست و از همون روز اول بدون هیچ مشکلی در حال استفاده هستن. از تجربه‌ام با شرکت میان‌آب‌پلیمر بسیار راضی‌ام و قطعاً در پروژه‌های بعدی هم از همین برند خرید می‌کنم.\";i:1;s:1157:\"<p>\r\nمن از طریق یکی از همکارانم با شرکت میان‌آب‌پلیمر آشنا شدم و بعد از اولین خرید، همکاری‌مون ادامه‌دار شد. به‌ویژه از آقای مریدی خریدهای زیادی انجام دادم و باید بگم که هم خودشون و هم تیم فروش شرکت، بسیار حرفه‌ای، خوش‌قول و خوش‌برخورد هستند.  \r\n<br>\r\nاز محصولاتشون هم رضایت کامل دارم. لوله‌هایی که از میان‌آب‌پلیمر خریدیم، طی چند سال اخیر در چند پروژه بزرگ آبیاری تحت فشار در جنوب کشور استفاده شده و تا امروز کوچک‌ترین مشکلی نداشتند؛ نه نشتی، نه افت کیفیت.  \r\n<br>\r\nبرای من که به‌عنوان پیمانکار با پروژه‌های متعدد سر و کار دارم، کیفیت محصولات و پشتیبانی بعد از فروش اهمیت زیادی داره و خوشبختانه این شرکت تونسته هر دو رو به‌خوبی ارائه بده.\r\n</p>\";i:2;s:1136:\"<p>\r\nسال‌هاست که در کار کشاورزی فعالیت دارم و در این مدت از برندهای مختلفی برای خرید لوله و اتصالات استفاده کرده‌ام، اما بدون اغراق باید بگم که تجربه خرید از شرکت میان‌آب‌پلیمر یکی از بهترین تجربه‌های من بوده. از همان تماس اول، برخورد پرسنل فروش بسیار حرفه‌ای و محترمانه بود. با صبوری به همه سوالاتم جواب دادن و حتی برای انتخاب دقیق سایز و نوع اتصالات، راهنمایی‌های فنی دقیقی ارائه کردند.  \r\n<br>\r\nنکته مهم‌تر این بود که بارگیری و ارسال سفارش من برای خط انتقال آب زمین کشاورزیم در کمترین زمان ممکن انجام شد و هیچ تأخیری نداشتم. همین سرعت عمل و دقت باعث شد که پروژه من بدون معطلی اجرا بشه. واقعاً ممنونم از تیم خوب میان‌آب‌پلیمر.\r\n</p>\";}s:36:\"img_slider__home___comment-user-name\";a:3:{i:0;s:57:\"سحر کریمی – مدیر مزرعه در بوشهر\";i:1;s:86:\"مهندس ناصر رفیعی – پیمانکار پروژه‌های کشاورزی\";i:2;s:56:\"علیرضا مرادی – کشاورز از دزفول\";}s:31:\"img_slider__repeater___about-us\";a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}s:32:\"img_slider__home__media-about-us\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:33:\"img_slider__home___about-us-title\";a:1:{i:0;s:0:\"\";}s:30:\"img_slider__home___about-us-sw\";a:1:{i:0;s:30:\"<p><br data-mce-bogus=\"1\"></p>\";}s:47:\"img_slider_mobile_repeater__home__work_end_page\";a:1:{s:19:\"redux_repeater_data\";a:2:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}}}s:38:\"img_slider_mobile__home__work_end_page\";a:2:{i:0;a:5:{s:3:\"url\";s:71:\"https://mianabpe.com/wp-content/uploads/2025/04/آزمایشگاه.webp\";s:2:\"id\";s:3:\"583\";s:6:\"height\";s:3:\"328\";s:5:\"width\";s:3:\"820\";s:9:\"thumbnail\";s:79:\"https://mianabpe.com/wp-content/uploads/2025/04/آزمایشگاه-150x150.webp\";}i:1;a:5:{s:3:\"url\";s:61:\"https://mianabpe.com/wp-content/uploads/2025/04/مدیر.webp\";s:2:\"id\";s:3:\"584\";s:6:\"height\";s:3:\"328\";s:5:\"width\";s:3:\"820\";s:9:\"thumbnail\";s:69:\"https://mianabpe.com/wp-content/uploads/2025/04/مدیر-150x150.webp\";}}s:47:\"img_slider_mobile__home__work_text_end_page_url\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:43:\"img_slider_mobile__home__work_text_end_page\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:15:\"bg__title_about\";a:5:{s:3:\"url\";s:68:\"https://mianabpe.com/wp-content/uploads/2025/04/شرکت-scaled.webp\";s:2:\"id\";s:3:\"582\";s:6:\"height\";s:3:\"533\";s:5:\"width\";s:4:\"2560\";s:9:\"thumbnail\";s:69:\"https://mianabpe.com/wp-content/uploads/2025/04/شرکت-150x150.webp\";}s:20:\"bg_arrow_radio_items\";s:24:\"object-position: bottom;\";s:13:\"bg__title_faq\";a:5:{s:3:\"url\";s:53:\"https://mianabpe.com/wp-content/uploads/2025/04/3.jpg\";s:2:\"id\";s:3:\"596\";s:6:\"height\";s:3:\"301\";s:5:\"width\";s:4:\"1280\";s:9:\"thumbnail\";s:61:\"https://mianabpe.com/wp-content/uploads/2025/04/3-150x150.jpg\";}s:24:\"bg_arrow_radio_items_faq\";s:24:\"object-position: bottom;\";s:22:\"bg__title_archive_shop\";a:5:{s:3:\"url\";s:53:\"https://mianabpe.com/wp-content/uploads/2025/04/3.jpg\";s:2:\"id\";s:3:\"596\";s:6:\"height\";s:3:\"301\";s:5:\"width\";s:4:\"1280\";s:9:\"thumbnail\";s:61:\"https://mianabpe.com/wp-content/uploads/2025/04/3-150x150.jpg\";}s:33:\"bg_arrow_radio_items_archive_shop\";s:24:\"object-position: bottom;\";}", "auto");
INSERT INTO `wp_options` VALUES("166", "data_var_option_theme-transients", "a:4:{s:14:\"changed_values\";a:1:{s:45:\"sticky_social_networks_at_the_bottom_telegram\";s:28:\"https://t.me/MohammadBayat97\";}s:9:\"last_save\";i:1754415773;s:13:\"last_compiler\";i:1754415773;s:11:\"last_import\";i:1754415773;}", "auto");
INSERT INTO `wp_options` VALUES("168", "recently_activated", "a:1:{s:37:\"user-role-editor/user-role-editor.php\";i:1766746760;}", "off");
INSERT INTO `wp_options` VALUES("169", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.1.4\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1732287370;s:7:\"version\";s:3:\"6.0\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "auto");
INSERT INTO `wp_options` VALUES("170", "action_scheduler_hybrid_store_demarkation", "7", "auto");
INSERT INTO `wp_options` VALUES("171", "schema-ActionScheduler_StoreSchema", "8.0.1766746756", "auto");
INSERT INTO `wp_options` VALUES("172", "schema-ActionScheduler_LoggerSchema", "3.0.1732287386", "auto");
INSERT INTO `wp_options` VALUES("173", "rank_math_known_post_types", "a:4:{s:4:\"post\";s:4:\"post\";s:4:\"page\";s:4:\"page\";s:10:\"attachment\";s:10:\"attachment\";s:7:\"product\";s:7:\"product\";}", "auto");
INSERT INTO `wp_options` VALUES("174", "rank_math_modules", "a:14:{i:0;s:12:\"link-counter\";i:1;s:9:\"analytics\";i:2;s:12:\"seo-analysis\";i:3;s:7:\"sitemap\";i:4;s:12:\"rich-snippet\";i:5;s:11:\"woocommerce\";i:6;s:10:\"buddypress\";i:7;s:7:\"bbpress\";i:8;s:3:\"acf\";i:9;s:11:\"web-stories\";i:10;s:10:\"content-ai\";i:11;s:16:\"instant-indexing\";i:12;s:9:\"local-seo\";i:13;s:12:\"role-manager\";}", "auto");
INSERT INTO `wp_options` VALUES("175", "rank-math-options-general", "a:49:{s:19:\"strip_category_base\";s:3:\"off\";s:24:\"attachment_redirect_urls\";s:2:\"on\";s:27:\"attachment_redirect_default\";s:20:\"https://mianabpe.com\";s:23:\"nofollow_external_links\";s:3:\"off\";s:20:\"nofollow_image_links\";s:3:\"off\";s:25:\"new_window_external_links\";s:2:\"on\";s:11:\"add_img_alt\";s:3:\"off\";s:14:\"img_alt_format\";s:11:\" %filename%\";s:13:\"add_img_title\";s:3:\"off\";s:16:\"img_title_format\";s:22:\"%title% %count(title)%\";s:11:\"breadcrumbs\";s:3:\"off\";s:21:\"breadcrumbs_separator\";s:1:\"-\";s:16:\"breadcrumbs_home\";s:2:\"on\";s:22:\"breadcrumbs_home_label\";s:4:\"Home\";s:26:\"breadcrumbs_archive_format\";s:15:\"Archives for %s\";s:25:\"breadcrumbs_search_format\";s:14:\"Results for %s\";s:21:\"breadcrumbs_404_label\";s:25:\"404 Error: page not found\";s:31:\"breadcrumbs_ancestor_categories\";s:3:\"off\";s:21:\"breadcrumbs_blog_page\";s:3:\"off\";s:16:\"404_monitor_mode\";s:6:\"simple\";s:17:\"404_monitor_limit\";i:100;s:35:\"404_monitor_ignore_query_parameters\";s:2:\"on\";s:24:\"redirections_header_code\";s:3:\"301\";s:18:\"redirections_debug\";s:3:\"off\";s:23:\"console_caching_control\";s:2:\"90\";s:21:\"console_email_reports\";b:0;s:23:\"console_email_frequency\";s:7:\"monthly\";s:27:\"link_builder_links_per_page\";s:1:\"7\";s:29:\"link_builder_links_per_target\";s:1:\"1\";s:22:\"wc_remove_product_base\";s:3:\"off\";s:23:\"wc_remove_category_base\";s:3:\"off\";s:31:\"wc_remove_category_parent_slugs\";s:3:\"off\";s:18:\"rss_before_content\";s:0:\"\";s:17:\"rss_after_content\";s:0:\"\";s:19:\"wc_remove_generator\";s:2:\"on\";s:24:\"remove_shop_snippet_data\";s:2:\"on\";s:18:\"frontend_seo_score\";s:3:\"off\";s:29:\"frontend_seo_score_post_types\";a:1:{i:0;s:4:\"post\";}s:27:\"frontend_seo_score_position\";s:3:\"top\";s:10:\"setup_mode\";s:4:\"easy\";s:21:\"content_ai_post_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:18:\"content_ai_country\";s:3:\"all\";s:15:\"content_ai_tone\";s:6:\"Formal\";s:19:\"content_ai_audience\";s:16:\"General Audience\";s:19:\"content_ai_language\";s:10:\"US English\";s:15:\"analytics_stats\";s:2:\"on\";s:15:\"toc_block_title\";s:17:\"Table of Contents\";s:20:\"toc_block_list_style\";s:2:\"ul\";s:15:\"llms_post_types\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:7:\"product\";}}", "auto");
INSERT INTO `wp_options` VALUES("176", "rank-math-options-titles", "a:110:{s:24:\"noindex_empty_taxonomies\";s:2:\"on\";s:15:\"title_separator\";s:1:\"-\";s:17:\"capitalize_titles\";s:3:\"off\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:19:\"knowledgegraph_type\";s:7:\"company\";s:19:\"knowledgegraph_name\";s:68:\"لوله و اتصالات پلی اتیلن میاناب پلیمر\";s:12:\"website_name\";s:68:\"لوله و اتصالات پلی اتیلن میاناب پلیمر\";s:19:\"local_business_type\";s:12:\"Organization\";s:20:\"local_address_format\";s:43:\"{address} {locality}, {region} {postalcode}\";s:13:\"opening_hours\";a:7:{i:0;a:2:{s:3:\"day\";s:6:\"Monday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:1;a:2:{s:3:\"day\";s:7:\"Tuesday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:2;a:2:{s:3:\"day\";s:9:\"Wednesday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:3;a:2:{s:3:\"day\";s:8:\"Thursday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:4;a:2:{s:3:\"day\";s:6:\"Friday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:5;a:2:{s:3:\"day\";s:8:\"Saturday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:6;a:2:{s:3:\"day\";s:6:\"Sunday\";s:4:\"time\";s:11:\"09:00-17:00\";}}s:20:\"opening_hours_format\";s:3:\"off\";s:14:\"homepage_title\";s:34:\"%sitename% %page% %sep% %sitedesc%\";s:20:\"homepage_description\";s:0:\"\";s:22:\"homepage_custom_robots\";s:3:\"off\";s:23:\"disable_author_archives\";s:3:\"off\";s:15:\"url_author_base\";s:6:\"author\";s:20:\"author_custom_robots\";s:2:\"on\";s:13:\"author_robots\";a:1:{i:0;s:7:\"noindex\";}s:20:\"author_archive_title\";s:30:\"%name% %sep% %sitename% %page%\";s:19:\"author_add_meta_box\";s:2:\"on\";s:21:\"disable_date_archives\";s:2:\"on\";s:18:\"date_archive_title\";s:30:\"%date% %page% %sep% %sitename%\";s:12:\"search_title\";s:38:\"%search_query% %page% %sep% %sitename%\";s:9:\"404_title\";s:31:\"Page Not Found %sep% %sitename%\";s:19:\"date_archive_robots\";a:1:{i:0;s:7:\"noindex\";}s:14:\"noindex_search\";s:2:\"on\";s:24:\"noindex_archive_subpages\";s:3:\"off\";s:26:\"noindex_password_protected\";s:3:\"off\";s:32:\"pt_download_default_rich_snippet\";s:7:\"product\";s:29:\"author_slack_enhanced_sharing\";s:2:\"on\";s:13:\"pt_post_title\";s:24:\"%title% %sep% %sitename%\";s:19:\"pt_post_description\";s:9:\"%excerpt%\";s:14:\"pt_post_robots\";a:0:{}s:21:\"pt_post_custom_robots\";s:3:\"off\";s:28:\"pt_post_default_rich_snippet\";s:7:\"article\";s:28:\"pt_post_default_article_type\";s:11:\"BlogPosting\";s:28:\"pt_post_default_snippet_name\";s:11:\"%seo_title%\";s:28:\"pt_post_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_post_slack_enhanced_sharing\";s:2:\"on\";s:17:\"pt_post_ls_use_fk\";s:6:\"titles\";s:20:\"pt_post_add_meta_box\";s:2:\"on\";s:20:\"pt_post_bulk_editing\";s:7:\"editing\";s:24:\"pt_post_link_suggestions\";s:2:\"on\";s:24:\"pt_post_primary_taxonomy\";s:8:\"category\";s:13:\"pt_page_title\";s:24:\"%title% %sep% %sitename%\";s:19:\"pt_page_description\";s:9:\"%excerpt%\";s:14:\"pt_page_robots\";a:0:{}s:21:\"pt_page_custom_robots\";s:3:\"off\";s:28:\"pt_page_default_rich_snippet\";s:7:\"article\";s:28:\"pt_page_default_article_type\";s:7:\"Article\";s:28:\"pt_page_default_snippet_name\";s:11:\"%seo_title%\";s:28:\"pt_page_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_page_slack_enhanced_sharing\";s:2:\"on\";s:17:\"pt_page_ls_use_fk\";s:6:\"titles\";s:20:\"pt_page_add_meta_box\";s:2:\"on\";s:20:\"pt_page_bulk_editing\";s:7:\"editing\";s:24:\"pt_page_link_suggestions\";s:2:\"on\";s:19:\"pt_attachment_title\";s:24:\"%title% %sep% %sitename%\";s:25:\"pt_attachment_description\";s:9:\"%excerpt%\";s:20:\"pt_attachment_robots\";a:1:{i:0;s:7:\"noindex\";}s:27:\"pt_attachment_custom_robots\";s:2:\"on\";s:34:\"pt_attachment_default_rich_snippet\";s:3:\"off\";s:34:\"pt_attachment_default_article_type\";s:7:\"Article\";s:34:\"pt_attachment_default_snippet_name\";s:11:\"%seo_title%\";s:34:\"pt_attachment_default_snippet_desc\";s:17:\"%seo_description%\";s:36:\"pt_attachment_slack_enhanced_sharing\";s:3:\"off\";s:26:\"pt_attachment_add_meta_box\";s:3:\"off\";s:16:\"pt_product_title\";s:24:\"%title% %sep% %sitename%\";s:22:\"pt_product_description\";s:9:\"%excerpt%\";s:17:\"pt_product_robots\";a:0:{}s:24:\"pt_product_custom_robots\";s:3:\"off\";s:31:\"pt_product_default_rich_snippet\";s:7:\"product\";s:31:\"pt_product_default_article_type\";s:7:\"Article\";s:31:\"pt_product_default_snippet_name\";s:11:\"%seo_title%\";s:31:\"pt_product_default_snippet_desc\";s:17:\"%seo_description%\";s:33:\"pt_product_slack_enhanced_sharing\";s:2:\"on\";s:20:\"pt_product_ls_use_fk\";s:6:\"titles\";s:23:\"pt_product_add_meta_box\";s:2:\"on\";s:23:\"pt_product_bulk_editing\";s:7:\"editing\";s:27:\"pt_product_link_suggestions\";s:2:\"on\";s:27:\"pt_product_primary_taxonomy\";s:11:\"product_cat\";s:18:\"pt_web-story_title\";s:24:\"%title% %sep% %sitename%\";s:24:\"pt_web-story_description\";s:9:\"%excerpt%\";s:19:\"pt_web-story_robots\";a:0:{}s:26:\"pt_web-story_custom_robots\";s:3:\"off\";s:33:\"pt_web-story_default_rich_snippet\";s:7:\"article\";s:33:\"pt_web-story_default_article_type\";s:7:\"Article\";s:33:\"pt_web-story_default_snippet_name\";s:11:\"%seo_title%\";s:33:\"pt_web-story_default_snippet_desc\";s:17:\"%seo_description%\";s:35:\"pt_web-story_slack_enhanced_sharing\";s:3:\"off\";s:25:\"pt_web-story_add_meta_box\";s:3:\"off\";s:18:\"tax_category_title\";s:23:\"%term% %sep% %sitename%\";s:19:\"tax_category_robots\";a:0:{}s:25:\"tax_category_add_meta_box\";s:2:\"on\";s:26:\"tax_category_custom_robots\";s:3:\"off\";s:24:\"tax_category_description\";s:18:\"%term_description%\";s:35:\"tax_category_slack_enhanced_sharing\";s:2:\"on\";s:18:\"tax_post_tag_title\";s:23:\"%term% %sep% %sitename%\";s:19:\"tax_post_tag_robots\";a:1:{i:0;s:7:\"noindex\";}s:25:\"tax_post_tag_add_meta_box\";s:2:\"on\";s:26:\"tax_post_tag_custom_robots\";s:2:\"on\";s:24:\"tax_post_tag_description\";s:18:\"%term_description%\";s:35:\"tax_post_tag_slack_enhanced_sharing\";s:2:\"on\";s:31:\"remove_product_cat_snippet_data\";s:2:\"on\";s:31:\"remove_product_tag_snippet_data\";s:2:\"on\";s:28:\"tax_post_format_add_meta_box\";s:2:\"on\";s:30:\"tax_product_brand_add_meta_box\";s:2:\"on\";s:28:\"tax_product_cat_add_meta_box\";s:2:\"on\";s:28:\"tax_product_tag_add_meta_box\";s:2:\"on\";s:39:\"tax_product_shipping_class_add_meta_box\";s:2:\"on\";}", "auto");
INSERT INTO `wp_options` VALUES("177", "rank-math-options-sitemap", "a:16:{s:14:\"items_per_page\";i:200;s:14:\"include_images\";s:2:\"on\";s:22:\"include_featured_image\";s:3:\"off\";s:13:\"exclude_roles\";a:2:{i:0;s:11:\"contributor\";i:1;s:10:\"subscriber\";}s:12:\"html_sitemap\";s:2:\"on\";s:20:\"html_sitemap_display\";s:9:\"shortcode\";s:17:\"html_sitemap_sort\";s:9:\"published\";s:23:\"html_sitemap_seo_titles\";s:6:\"titles\";s:15:\"authors_sitemap\";s:2:\"on\";s:15:\"pt_post_sitemap\";s:2:\"on\";s:15:\"pt_page_sitemap\";s:2:\"on\";s:21:\"pt_attachment_sitemap\";s:3:\"off\";s:18:\"pt_product_sitemap\";s:2:\"on\";s:20:\"pt_web-story_sitemap\";s:3:\"off\";s:20:\"tax_category_sitemap\";s:2:\"on\";s:20:\"tax_post_tag_sitemap\";s:3:\"off\";}", "auto");
INSERT INTO `wp_options` VALUES("178", "rank-math-options-instant-indexing", "a:2:{s:15:\"bing_post_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:16:\"indexnow_api_key\";s:32:\"dbbb8f3622de4929b782873e48d4555d\";}", "auto");
INSERT INTO `wp_options` VALUES("181", "rank_math_version", "1.0.260", "off");
INSERT INTO `wp_options` VALUES("182", "rank_math_db_version", "1", "auto");
INSERT INTO `wp_options` VALUES("183", "rank_math_install_date", "1732299987", "auto");
INSERT INTO `wp_options` VALUES("185", "searchwp_live_search_last_update", "1732299988", "auto");
INSERT INTO `wp_options` VALUES("186", "searchwp_live_search_version", "1.8.3", "auto");
INSERT INTO `wp_options` VALUES("189", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:29:\"tablepress/libraries/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:6:\"2.13.0\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1766747359;s:11:\"plugin_path\";s:25:\"tablepress/tablepress.php\";}}s:7:\"abspath\";s:48:\"/home/fekragam/domains/mianabpe.com/public_html/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:25:\"tablepress/tablepress.php\";s:8:\"sdk_path\";s:29:\"tablepress/libraries/freemius\";s:7:\"version\";s:6:\"2.13.0\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1766747359;}}", "auto");
INSERT INTO `wp_options` VALUES("190", "fs_debug_mode", "", "auto");
INSERT INTO `wp_options` VALUES("191", "fs_accounts", "a:8:{s:21:\"id_slug_type_path_map\";a:1:{i:10340;a:3:{s:4:\"slug\";s:10:\"tablepress\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:25:\"tablepress/tablepress.php\";}}s:11:\"plugin_data\";a:1:{s:10:\"tablepress\";a:17:{s:19:\"last_load_timestamp\";i:1766732148;s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:25:\"tablepress/tablepress.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1732287388;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";s:6:\"2.12.0\";s:11:\"sdk_version\";s:6:\"2.13.0\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";s:5:\"3.1.3\";s:14:\"plugin_version\";s:5:\"3.2.6\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";N;s:4:\"host\";s:12:\"mianabpe.com\";s:9:\"server_ip\";s:13:\"195.28.168.63\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1766747359;s:7:\"version\";s:5:\"3.2.6\";}s:15:\"prev_is_premium\";b:0;s:21:\"is_pending_activation\";b:1;}}s:13:\"file_slug_map\";a:1:{s:25:\"tablepress/tablepress.php\";s:10:\"tablepress\";}s:7:\"plugins\";a:1:{s:10:\"tablepress\";O:9:\"FS_Plugin\":24:{s:2:\"id\";s:5:\"10340\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:1;s:10:\"public_key\";s:32:\"pk_b215ca1bb4041cf43ed137ae7665b\";s:10:\"secret_key\";N;s:16:\"parent_plugin_id\";N;s:5:\"title\";s:10:\"TablePress\";s:4:\"slug\";s:10:\"tablepress\";s:12:\"premium_slug\";s:18:\"tablepress-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:25:\"tablepress/tablepress.php\";s:7:\"version\";s:5:\"3.2.6\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:17:\"opt_in_moderation\";a:3:{s:3:\"new\";b:1;s:7:\"updates\";b:0;s:9:\"localhost\";b:0;}}}s:12:\"gc_timestamp\";a:0:{}s:10:\"theme_data\";a:0:{}s:9:\"unique_id\";s:32:\"6d02e5ce8b4ec041614c42fd081ea2bb\";s:13:\"admin_notices\";a:1:{s:10:\"tablepress\";a:0:{}}}", "auto");
INSERT INTO `wp_options` VALUES("192", "fs_api_cache", "a:1:{s:116:\"get:/v1/plugins/10340/pricing.json?is_enriched=1&trial=0&sandbox=0&s_ctx_type=0&s_ctx_id=0&s_ctx_ts=0&s_ctx_secure=0\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":12:{s:6:\"plugin\";O:8:\"stdClass\":12:{s:16:\"parent_plugin_id\";N;s:4:\"slug\";s:10:\"tablepress\";s:5:\"title\";s:10:\"TablePress\";s:4:\"icon\";s:100:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10340/icons/bbb5e88022c798909cdc07ae0258568d.png\";s:17:\"money_back_period\";i:30;s:13:\"refund_policy\";s:8:\"flexible\";s:22:\"renewals_discount_type\";s:10:\"percentage\";s:19:\"is_wp_org_compliant\";b:1;s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_b215ca1bb4041cf43ed137ae7665b\";s:2:\"id\";s:5:\"10340\";s:19:\"has_premium_version\";b:1;}s:5:\"plans\";a:3:{i:0;O:8:\"stdClass\":23:{s:9:\"plugin_id\";s:5:\"10340\";s:4:\"name\";s:4:\"free\";s:5:\"title\";s:4:\"Free\";s:11:\"description\";s:62:\"Basic TablePress features. The solid foundation for all needs!\";s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";s:27:\"https://tablepress.org/faq/\";s:13:\"support_forum\";s:48:\"https://wordpress.org/support/plugin/tablepress/\";s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"17454\";s:7:\"created\";s:19:\"2022-05-09 10:00:43\";s:7:\"updated\";s:19:\"2024-11-12 21:24:22\";s:8:\"features\";a:11:{i:0;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"17454\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:28:\"Table management and editing\";s:11:\"description\";s:57:\"Create small or large tables in an easy to use interface.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"11680\";s:7:\"created\";s:19:\"2022-05-09 13:31:34\";s:7:\"updated\";s:19:\"2022-10-15 15:02:23\";}i:1;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"17454\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:16:\"Unlimited tables\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12720\";s:7:\"created\";s:19:\"2022-10-26 18:33:38\";s:7:\"updated\";N;}i:2;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"17454\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:14:\"No size limits\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"18660\";s:7:\"created\";s:19:\"2024-11-12 21:25:17\";s:7:\"updated\";N;}i:3;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17454\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:17:\"Accessible tables\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"18661\";s:7:\"created\";s:19:\"2024-11-12 21:25:21\";s:7:\"updated\";N;}i:4;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17454\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:28:\"Embed via Block or Shortcode\";s:11:\"description\";s:0:\"\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12642\";s:7:\"created\";s:19:\"2022-10-15 15:04:38\";s:7:\"updated\";N;}i:5;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17454\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:17:\"Import from files\";s:11:\"description\";s:47:\"Import tables from Excel, CSV, HTML, ... files.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"11679\";s:7:\"created\";s:19:\"2022-05-09 13:31:18\";s:7:\"updated\";s:19:\"2022-10-15 15:01:00\";}i:6;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17454\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:16:\"Export of tables\";s:11:\"description\";s:42:\"Export tables to CSV, HTML, or JSON files.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"11681\";s:7:\"created\";s:19:\"2022-05-09 13:37:34\";s:7:\"updated\";s:19:\"2022-10-15 15:04:13\";}i:7;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"17454\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:8:\"Formulas\";s:11:\"description\";s:41:\"Add and use math formulas in your tables!\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12639\";s:7:\"created\";s:19:\"2022-10-15 15:01:39\";s:7:\"updated\";N;}i:8;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17454\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:19:\"Basic table options\";s:11:\"description\";s:78:\"Show a table head or foot row, alternating row colors, hover highlighting, ...\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12640\";s:7:\"created\";s:19:\"2022-10-15 15:03:01\";s:7:\"updated\";s:19:\"2022-10-15 15:03:43\";}i:9;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17454\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:38:\"Basic table features for site visitors\";s:11:\"description\";s:61:\"Sorting, search/filter, pagination, horizontal scrolling, ...\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12641\";s:7:\"created\";s:19:\"2022-10-15 15:03:24\";s:7:\"updated\";s:19:\"2022-10-15 15:03:57\";}i:10;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17454\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:21:\"Styling with CSS code\";s:11:\"description\";s:72:\"Use &amp;quot;Custom CSS&amp;quot; to adjust the styling of your tables!\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12643\";s:7:\"created\";s:19:\"2022-10-15 15:05:05\";s:7:\"updated\";s:19:\"2022-11-26 12:39:17\";}}}i:1;O:8:\"stdClass\":24:{s:9:\"plugin_id\";s:5:\"10340\";s:4:\"name\";s:3:\"pro\";s:5:\"title\";s:3:\"Pro\";s:11:\"description\";s:58:\"Extra features for your visitors! Perfect for small sites!\";s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:0;s:25:\"is_block_features_monthly\";b:0;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";s:27:\"https://tablepress.org/faq/\";s:13:\"support_forum\";s:48:\"https://wordpress.org/support/plugin/tablepress/\";s:13:\"support_email\";s:30:\"premium-support@tablepress.org\";s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:1;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"17457\";s:7:\"created\";s:19:\"2022-05-09 12:42:35\";s:7:\"updated\";s:19:\"2024-11-12 21:33:31\";s:7:\"pricing\";a:14:{i:0;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17457\";s:8:\"licenses\";i:1;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:89;s:14:\"lifetime_price\";i:389;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"19678\";s:7:\"created\";s:19:\"2022-05-09 13:23:04\";s:7:\"updated\";s:19:\"2024-11-19 08:47:55\";s:8:\"currency\";s:3:\"eur\";}i:1;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17457\";s:8:\"licenses\";i:1;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:89;s:14:\"lifetime_price\";i:389;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"19677\";s:7:\"created\";s:19:\"2022-05-09 13:22:23\";s:7:\"updated\";s:19:\"2024-11-19 08:47:21\";s:8:\"currency\";s:3:\"usd\";}i:2;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17457\";s:8:\"licenses\";i:3;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:149;s:14:\"lifetime_price\";i:649;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"19681\";s:7:\"created\";s:19:\"2022-05-09 13:25:55\";s:7:\"updated\";s:19:\"2024-11-19 08:47:57\";s:8:\"currency\";s:3:\"eur\";}i:3;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17457\";s:8:\"licenses\";i:3;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:149;s:14:\"lifetime_price\";i:649;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"19679\";s:7:\"created\";s:19:\"2022-05-09 13:23:20\";s:7:\"updated\";s:19:\"2024-11-19 08:47:24\";s:8:\"currency\";s:3:\"usd\";}i:4;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17457\";s:8:\"licenses\";i:5;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:169;s:14:\"lifetime_price\";i:739;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"35536\";s:7:\"created\";s:19:\"2024-11-18 15:01:36\";s:7:\"updated\";s:19:\"2024-11-19 08:47:59\";s:8:\"currency\";s:3:\"eur\";}i:5;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17457\";s:8:\"licenses\";i:5;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:169;s:14:\"lifetime_price\";i:739;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"35535\";s:7:\"created\";s:19:\"2024-11-18 15:00:30\";s:7:\"updated\";s:19:\"2024-11-19 08:47:28\";s:8:\"currency\";s:3:\"usd\";}i:6;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17457\";s:8:\"licenses\";i:25;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:299;s:14:\"lifetime_price\";i:1299;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"32585\";s:7:\"created\";s:19:\"2024-07-04 10:37:13\";s:7:\"updated\";s:19:\"2024-07-04 10:37:45\";s:8:\"currency\";s:3:\"eur\";}i:7;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17457\";s:8:\"licenses\";i:25;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:299;s:14:\"lifetime_price\";i:1299;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"32576\";s:7:\"created\";s:19:\"2024-07-04 09:19:19\";s:7:\"updated\";s:19:\"2024-07-04 10:35:38\";s:8:\"currency\";s:3:\"usd\";}i:8;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17457\";s:8:\"licenses\";i:100;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:399;s:14:\"lifetime_price\";i:1799;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"32586\";s:7:\"created\";s:19:\"2024-07-04 10:37:20\";s:7:\"updated\";s:19:\"2024-11-19 08:48:11\";s:8:\"currency\";s:3:\"eur\";}i:9;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17457\";s:8:\"licenses\";i:100;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:399;s:14:\"lifetime_price\";i:1799;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"32578\";s:7:\"created\";s:19:\"2024-07-04 09:19:38\";s:7:\"updated\";s:19:\"2024-11-19 08:47:38\";s:8:\"currency\";s:3:\"usd\";}i:10;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17457\";s:8:\"licenses\";i:1000;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:599;s:14:\"lifetime_price\";i:2599;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"32587\";s:7:\"created\";s:19:\"2024-07-04 10:37:25\";s:7:\"updated\";s:19:\"2024-11-19 08:48:17\";s:8:\"currency\";s:3:\"eur\";}i:11;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17457\";s:8:\"licenses\";i:1000;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:599;s:14:\"lifetime_price\";i:2599;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"32577\";s:7:\"created\";s:19:\"2024-07-04 09:19:28\";s:7:\"updated\";s:19:\"2024-11-19 08:47:45\";s:8:\"currency\";s:3:\"usd\";}i:12;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17457\";s:8:\"licenses\";N;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:799;s:14:\"lifetime_price\";i:3449;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"19684\";s:7:\"created\";s:19:\"2022-05-09 13:30:36\";s:7:\"updated\";s:19:\"2024-08-22 18:09:23\";s:8:\"currency\";s:3:\"eur\";}i:13;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17457\";s:8:\"licenses\";N;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:799;s:14:\"lifetime_price\";i:3449;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"19683\";s:7:\"created\";s:19:\"2022-05-09 13:28:52\";s:7:\"updated\";s:19:\"2024-08-22 18:08:55\";s:8:\"currency\";s:3:\"usd\";}}s:8:\"features\";a:18:{i:0;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:17:\"Responsive Tables\";s:11:\"description\";s:53:\"Make your tables look good on different screen sizes.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12665\";s:7:\"created\";s:19:\"2022-10-15 19:14:02\";s:7:\"updated\";s:19:\"2022-12-01 13:11:32\";}i:1;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:24:\"Default Style Customizer\";s:11:\"description\";s:100:\"Choose from multiple style variations or define your own color scheme in an easy-to-use visual tool!\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"15919\";s:7:\"created\";s:19:\"2023-11-01 14:03:10\";s:7:\"updated\";N;}i:2;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:12:\"Table Layout\";s:11:\"description\";s:65:\"Customize the layout and position of features around your tables.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"18662\";s:7:\"created\";s:19:\"2024-11-12 21:36:16\";s:7:\"updated\";N;}i:3;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:28:\"Advanced Pagination Settings\";s:11:\"description\";s:49:\"Customize the pagination settings of your tables.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"18663\";s:7:\"created\";s:19:\"2024-11-12 21:36:54\";s:7:\"updated\";N;}i:4;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:22:\"Fixed Rows and Columns\";s:11:\"description\";s:85:\"Fix the header and footer row and the first and last column when scrolling the table.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12661\";s:7:\"created\";s:19:\"2022-10-15 19:13:08\";s:7:\"updated\";N;}i:5;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:19:\"User Action Buttons\";s:11:\"description\";s:89:\"Add buttons for downloading, copying, printing, and changing column visibility of tables.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12657\";s:7:\"created\";s:19:\"2022-10-15 19:11:37\";s:7:\"updated\";s:19:\"2024-11-12 21:35:34\";}i:6;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:12:\"Row Grouping\";s:11:\"description\";s:57:\"Group table rows by a common keyword, category, or title.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12662\";s:7:\"created\";s:19:\"2022-10-15 19:13:20\";s:7:\"updated\";s:19:\"2022-12-01 13:18:26\";}i:7;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:25:\"Cell and Row Highlighting\";s:11:\"description\";s:74:\"Add CSS classes to cells and rows for highlighting based on their content.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12653\";s:7:\"created\";s:19:\"2022-10-15 19:10:13\";s:7:\"updated\";s:19:\"2022-10-15 19:10:53\";}i:8;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:12:\"Index Column\";s:11:\"description\";s:71:\"Make the first column an index or counter column with the row position.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12660\";s:7:\"created\";s:19:\"2022-10-15 19:12:50\";s:7:\"updated\";s:19:\"2024-11-12 21:35:38\";}i:9;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:23:\"Column Filter Dropdowns\";s:11:\"description\";s:54:\"Add a search dropdown for each column above the table.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12658\";s:7:\"created\";s:19:\"2022-10-15 19:12:14\";s:7:\"updated\";s:19:\"2022-10-15 19:12:25\";}i:10;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:27:\"Individual Column Filtering\";s:11:\"description\";s:65:\"Add a search field for each column to the table head or foot row.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12659\";s:7:\"created\";s:19:\"2022-10-15 19:12:37\";s:7:\"updated\";s:19:\"2022-12-01 14:20:49\";}i:11;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:15:\"Alphabet Search\";s:11:\"description\";s:75:\"Show Alphabet buttons above the table to filter rows by their first letter.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12655\";s:7:\"created\";s:19:\"2022-10-15 19:11:08\";s:7:\"updated\";N;}i:12;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:16:\"Automatic Filter\";s:11:\"description\";s:36:\"Pre-filter a table when it is shown.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12656\";s:7:\"created\";s:19:\"2022-10-15 19:11:23\";s:7:\"updated\";N;}i:13;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:19:\"Search Highlighting\";s:11:\"description\";s:42:\"Highlight found search terms in the table.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12663\";s:7:\"created\";s:19:\"2022-10-15 19:13:34\";s:7:\"updated\";N;}i:14;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:12:\"Search Panes\";s:11:\"description\";s:37:\"Show panes for filtering the columns.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12664\";s:7:\"created\";s:19:\"2022-10-15 19:13:46\";s:7:\"updated\";N;}i:15;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:20:\"Column and Row Order\";s:11:\"description\";s:67:\"Order the columns and rows in different ways when a table is shown.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12654\";s:7:\"created\";s:19:\"2022-10-15 19:10:38\";s:7:\"updated\";N;}i:16;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:13:\"Row Filtering\";s:11:\"description\";s:51:\"Show only table rows that contain defined keywords.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12666\";s:7:\"created\";s:19:\"2022-10-15 19:14:22\";s:7:\"updated\";N;}i:17;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"17457\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:22:\"Automatic Table Export\";s:11:\"description\";s:71:\"Export and save tables to files on the server after they were modified.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12644\";s:7:\"created\";s:19:\"2022-10-15 18:29:29\";s:7:\"updated\";s:19:\"2022-10-15 19:09:57\";}}}i:2;O:8:\"stdClass\":24:{s:9:\"plugin_id\";s:5:\"10340\";s:4:\"name\";s:3:\"max\";s:5:\"title\";s:3:\"Max\";s:11:\"description\";s:62:\"Even better table management for professionals and businesses!\";s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:0;s:25:\"is_block_features_monthly\";b:0;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";s:27:\"https://tablepress.org/faq/\";s:13:\"support_forum\";s:48:\"https://wordpress.org/support/plugin/tablepress/\";s:13:\"support_email\";s:22:\"support@tablepress.org\";s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"17459\";s:7:\"created\";s:19:\"2022-05-09 13:32:06\";s:7:\"updated\";s:19:\"2024-11-12 21:41:55\";s:7:\"pricing\";a:14:{i:0;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17459\";s:8:\"licenses\";i:1;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:189;s:14:\"lifetime_price\";i:789;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"19692\";s:7:\"created\";s:19:\"2022-05-09 13:34:12\";s:7:\"updated\";s:19:\"2024-11-19 08:52:14\";s:8:\"currency\";s:3:\"eur\";}i:1;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17459\";s:8:\"licenses\";i:1;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:189;s:14:\"lifetime_price\";i:789;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"19691\";s:7:\"created\";s:19:\"2022-05-09 13:33:57\";s:7:\"updated\";s:19:\"2024-11-19 08:52:09\";s:8:\"currency\";s:3:\"usd\";}i:2;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17459\";s:8:\"licenses\";i:3;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:349;s:14:\"lifetime_price\";i:1449;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"19695\";s:7:\"created\";s:19:\"2022-05-09 13:34:26\";s:7:\"updated\";s:19:\"2024-11-19 08:48:51\";s:8:\"currency\";s:3:\"eur\";}i:3;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17459\";s:8:\"licenses\";i:3;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:349;s:14:\"lifetime_price\";i:1449;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"19693\";s:7:\"created\";s:19:\"2022-05-09 13:34:18\";s:7:\"updated\";s:19:\"2024-11-19 08:48:32\";s:8:\"currency\";s:3:\"usd\";}i:4;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17459\";s:8:\"licenses\";i:5;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:369;s:14:\"lifetime_price\";i:1539;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"35538\";s:7:\"created\";s:19:\"2024-11-18 15:02:29\";s:7:\"updated\";s:19:\"2024-11-19 08:48:53\";s:8:\"currency\";s:3:\"eur\";}i:5;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17459\";s:8:\"licenses\";i:5;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:369;s:14:\"lifetime_price\";i:1539;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"35537\";s:7:\"created\";s:19:\"2024-11-18 15:02:09\";s:7:\"updated\";s:19:\"2024-11-19 08:48:33\";s:8:\"currency\";s:3:\"usd\";}i:6;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17459\";s:8:\"licenses\";i:25;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:699;s:14:\"lifetime_price\";i:2899;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"32588\";s:7:\"created\";s:19:\"2024-07-04 10:41:40\";s:7:\"updated\";s:19:\"2024-07-04 10:43:27\";s:8:\"currency\";s:3:\"usd\";}i:7;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17459\";s:8:\"licenses\";i:25;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:699;s:14:\"lifetime_price\";i:2899;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"32591\";s:7:\"created\";s:19:\"2024-07-04 10:41:55\";s:7:\"updated\";s:19:\"2024-07-04 10:44:22\";s:8:\"currency\";s:3:\"eur\";}i:8;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17459\";s:8:\"licenses\";i:100;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:999;s:14:\"lifetime_price\";i:4149;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"32589\";s:7:\"created\";s:19:\"2024-07-04 10:41:44\";s:7:\"updated\";s:19:\"2024-07-04 10:43:35\";s:8:\"currency\";s:3:\"usd\";}i:9;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17459\";s:8:\"licenses\";i:100;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:999;s:14:\"lifetime_price\";i:4149;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"32592\";s:7:\"created\";s:19:\"2024-07-04 10:41:59\";s:7:\"updated\";s:19:\"2024-07-04 10:44:27\";s:8:\"currency\";s:3:\"eur\";}i:10;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17459\";s:8:\"licenses\";i:1000;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:1399;s:14:\"lifetime_price\";i:5799;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"32590\";s:7:\"created\";s:19:\"2024-07-04 10:41:48\";s:7:\"updated\";s:19:\"2024-07-04 10:43:41\";s:8:\"currency\";s:3:\"usd\";}i:11;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17459\";s:8:\"licenses\";i:1000;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:1399;s:14:\"lifetime_price\";i:5799;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"32593\";s:7:\"created\";s:19:\"2024-07-04 10:42:03\";s:7:\"updated\";s:19:\"2024-07-04 10:44:32\";s:8:\"currency\";s:3:\"eur\";}i:12;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17459\";s:8:\"licenses\";N;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:1899;s:14:\"lifetime_price\";i:7849;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"19694\";s:7:\"created\";s:19:\"2022-05-09 13:34:22\";s:7:\"updated\";s:19:\"2024-08-22 18:12:09\";s:8:\"currency\";s:3:\"usd\";}i:13;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"17459\";s:8:\"licenses\";N;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:1899;s:14:\"lifetime_price\";i:7849;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"19696\";s:7:\"created\";s:19:\"2022-05-09 13:34:31\";s:7:\"updated\";s:19:\"2024-08-22 18:12:04\";s:8:\"currency\";s:3:\"eur\";}}s:8:\"features\";a:9:{i:0;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"17459\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:29:\"Direct priority email support\";s:11:\"description\";s:45:\"Immediate Help from the TablePress Developer!\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"18665\";s:7:\"created\";s:19:\"2024-11-12 21:44:07\";s:7:\"updated\";s:19:\"2024-11-12 21:44:50\";}i:1;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17459\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:31:\"Automatic Periodic Table Import\";s:11:\"description\";s:59:\"Periodically update tables from a configured import source.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12648\";s:7:\"created\";s:19:\"2022-10-15 19:07:21\";s:7:\"updated\";N;}i:2;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"17459\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:22:\"Advanced Access Rights\";s:11:\"description\";s:58:\"Restrict access to individual tables for individual users.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12647\";s:7:\"created\";s:19:\"2022-10-15 19:07:03\";s:7:\"updated\";N;}i:3;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17459\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:16:\"Advanced Loading\";s:11:\"description\";s:57:\"Load the table data from a JSON array for faster loading.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12649\";s:7:\"created\";s:19:\"2022-10-15 19:07:39\";s:7:\"updated\";N;}i:4;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"17459\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:18:\"Inverted Filtering\";s:11:\"description\";s:81:\"Turn the filtering into a search and hide the table if no search term is entered.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"18664\";s:7:\"created\";s:19:\"2024-11-12 21:39:57\";s:7:\"updated\";N;}i:5;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"17459\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:12:\"Fuzzy Search\";s:11:\"description\";s:80:\"Let the search account for spelling mistakes and typos and find similar matches.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17474\";s:7:\"created\";s:19:\"2024-07-04 10:42:52\";s:7:\"updated\";N;}i:6;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17459\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:21:\"Custom Search Builder\";s:11:\"description\";s:73:\"Show a search builder interface for filtering from groups and conditions.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12650\";s:7:\"created\";s:19:\"2022-10-15 19:08:00\";s:7:\"updated\";s:19:\"2022-12-01 14:40:35\";}i:7;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17459\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:22:\"Server-side Processing\";s:11:\"description\";s:92:\"Process sorting, filtering, and pagination on the server for faster loading of large tables.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12651\";s:7:\"created\";s:19:\"2022-10-15 19:08:00\";s:7:\"updated\";s:19:\"2022-10-15 19:08:57\";}i:8;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17459\";s:9:\"plugin_id\";s:5:\"10340\";s:5:\"title\";s:8:\"REST API\";s:11:\"description\";s:43:\"Read table data via the WordPress REST API.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12652\";s:7:\"created\";s:19:\"2022-10-15 19:08:23\";s:7:\"updated\";s:19:\"2022-10-15 19:09:09\";}}}}s:7:\"reviews\";a:23:{i:0;O:8:\"stdClass\":22:{s:5:\"first\";s:5:\"James\";s:4:\"last\";s:5:\"Welch\";s:5:\"email\";s:26:\"jamesthomaswelch@gmail.com\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"8386355\";s:4:\"rate\";i:100;s:5:\"title\";s:17:\"Brilliantly easy.\";s:4:\"text\";s:101:\"I tried a cheaper alternative but it was so, so lacking compared to TablePress. It really is the GOAT\";s:4:\"name\";s:11:\"James Welch\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1441676\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"14971\";s:7:\"created\";s:19:\"2024-06-17 19:13:34\";s:7:\"updated\";s:19:\"2024-07-01 08:26:15\";}i:1;O:8:\"stdClass\":22:{s:5:\"first\";s:8:\"praxisf4\";s:4:\"last\";s:0:\"\";s:5:\"email\";s:22:\"info@simone-steiger.ch\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"2357509\";s:4:\"rate\";i:100;s:5:\"title\";s:26:\"Perfect Tool for our needs\";s:4:\"text\";s:154:\"We’re using table press for a collection of exercises for art therapists. It’s fabulous: easy to use, flexible and the table is sortable in many ways.\";s:4:\"name\";s:14:\"Simone Steiger\";s:9:\"job_title\";s:9:\"Developer\";s:7:\"company\";s:13:\"Art Solutions\";s:11:\"company_url\";s:27:\"https://artsolutions.online\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1342424\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"14916\";s:7:\"created\";s:19:\"2024-06-08 07:36:05\";s:7:\"updated\";s:19:\"2024-07-01 08:26:28\";}i:2;O:8:\"stdClass\":22:{s:5:\"first\";s:5:\"Admin\";s:4:\"last\";s:0:\"\";s:5:\"email\";s:20:\"claytonc@lomanco.com\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"6884847\";s:4:\"rate\";i:100;s:5:\"title\";s:37:\"Exceptional Tool for Table Management\";s:4:\"text\";s:922:\"TablePress for WordPress is an excellent tool for managing website tables. It simplifies updating data across multiple pages by centralizing changes, which automatically reflect everywhere the table is used. This feature saves significant time and effort, especially for data-intensive sites. The interface of TablePress is user-friendly, designed to accommodate users with various levels of technical skills. What sets TablePress apart is its exceptional customer support. Whenever I faced any issues, the support team was incredibly responsive and helpful, providing clear and effective solutions quickly. I recently purchased a lifetime license, a testament to my trust and satisfaction with TablePress. I highly recommend it for anyone looking to enhance their website\'s functionality and efficiency in managing data displayed in tables. It’s a reliable, efficient, and essential tool for any WordPress site manager.\";s:4:\"name\";s:5:\"Admin\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1127189\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"14780\";s:7:\"created\";s:19:\"2024-05-13 14:15:45\";s:7:\"updated\";s:19:\"2024-07-01 08:26:43\";}i:3;O:8:\"stdClass\":22:{s:5:\"first\";s:5:\"JULIO\";s:4:\"last\";s:6:\"Alfaya\";s:5:\"email\";s:22:\"julio.alfaya@gmail.com\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"6875383\";s:4:\"rate\";i:100;s:5:\"title\";s:18:\"Perfect for my ste\";s:4:\"text\";s:105:\"I was about to make a donation for my satisfaction. I thought the best way to do this would be to upgrade\";s:4:\"name\";s:12:\"JULIO Alfaya\";s:9:\"job_title\";N;s:7:\"company\";s:5:\"FTERJ\";s:11:\"company_url\";s:20:\"www.triathlon.com.br\";s:7:\"picture\";s:102:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10340/reviews/d0a4bae8b54d53f2dce4327c0276fba8.gif\";s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1125351\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11894\";s:7:\"created\";s:19:\"2023-04-14 15:16:50\";s:7:\"updated\";s:19:\"2023-04-18 21:00:41\";}i:4;O:8:\"stdClass\":22:{s:5:\"first\";s:8:\"Michelle\";s:4:\"last\";s:6:\"Piette\";s:5:\"email\";s:23:\"mpiette@gsscreative.net\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"6793294\";s:4:\"rate\";i:100;s:5:\"title\";s:73:\"Great plugin and wonderful customer support for customization assistance!\";s:4:\"text\";s:190:\"Tobias was a pleasure to work with and was very responsive to my requests. I definitely recommend this plugin, and if you need all of the bells and whistles the upgraded package is worth it!\";s:4:\"name\";s:11:\"Michelle P.\";s:9:\"job_title\";s:16:\"Graphic Designer\";s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1112884\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11878\";s:7:\"created\";s:19:\"2023-04-11 14:30:53\";s:7:\"updated\";s:19:\"2023-04-18 21:00:40\";}i:5;O:8:\"stdClass\":22:{s:5:\"first\";s:4:\"Gary\";s:4:\"last\";s:5:\"Borek\";s:5:\"email\";s:23:\"garyborek@garyborek.com\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"6525559\";s:4:\"rate\";i:100;s:5:\"title\";s:32:\"Excellent wordpress table plugin\";s:4:\"text\";s:582:\"I tried several WordPress data table plugins before coming upon TablePress. All the others seem clunky difficult to format, or riddled with bugs. TablePress handled a database of 35,000 records with ease. The free version worked so well that I kept sending the developer donations for the plugins to help assure future development. I was delighted to learn that a premium edition was available because I believe that offers the best chance of continued development for the product. Examples of my use of TablePress can be found at www.taxlawcenter.com and www.cheektowagamatters.com\";s:4:\"name\";s:10:\"Gary Borek\";s:9:\"job_title\";s:8:\"Attorney\";s:7:\"company\";s:28:\"Gary D Borek Attorney at Law\";s:11:\"company_url\";s:25:\"https://www.garyborek.com\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1070320\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11865\";s:7:\"created\";s:19:\"2023-04-07 23:05:00\";s:7:\"updated\";s:19:\"2023-04-18 21:00:39\";}i:6;O:8:\"stdClass\":22:{s:5:\"first\";s:3:\"ESR\";s:4:\"last\";s:9:\"-Luftbild\";s:5:\"email\";s:20:\"info@esr-luftbild.de\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"1954883\";s:4:\"rate\";i:100;s:5:\"title\";s:34:\"Perfect for my site, Great support\";s:4:\"text\";s:59:\"Perfect to configure the table views for desktop and mobile\";s:4:\"name\";s:15:\"Ulrich Rosinger\";s:9:\"job_title\";N;s:7:\"company\";s:12:\"ESR-Luftbild\";s:11:\"company_url\";s:24:\"https://esr-luftbild.de/\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1108949\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11739\";s:7:\"created\";s:19:\"2023-03-19 15:10:34\";s:7:\"updated\";s:19:\"2023-04-18 21:00:39\";}i:7;O:8:\"stdClass\":22:{s:5:\"first\";s:4:\"Toni\";s:4:\"last\";s:7:\"Frieden\";s:5:\"email\";s:22:\"toni.thommen@gmail.com\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"6652335\";s:4:\"rate\";i:100;s:5:\"title\";s:32:\"Great plugin, amazing support!!!\";s:4:\"text\";s:270:\"The plugin itself is worth the money for the premium plans. The support by the developper himself solves all your problems if anything does not work or even if you have requirements that wouldn\'t be covered in the standard functionalities. A huge recommendation from me!\";s:4:\"name\";s:6:\"Toni F\";s:9:\"job_title\";s:7:\"Founder\";s:7:\"company\";N;s:11:\"company_url\";s:26:\"https://kein-gutschein.com\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1091679\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11536\";s:7:\"created\";s:19:\"2023-02-16 11:04:38\";s:7:\"updated\";s:19:\"2023-02-21 16:01:46\";}i:8;O:8:\"stdClass\":22:{s:5:\"first\";s:5:\"David\";s:4:\"last\";s:8:\"Oliveira\";s:5:\"email\";s:29:\"david@washingtonaudiology.com\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"6641848\";s:4:\"rate\";i:100;s:5:\"title\";s:25:\"Great Support and Product\";s:4:\"text\";s:153:\"Tobias was great in helping me with any questions I had regarding the plugin. Top notch, and made my tables look much better on my websites. Thanks guys!\";s:4:\"name\";s:14:\"David Oliveira\";s:9:\"job_title\";s:7:\"CEO-CTO\";s:7:\"company\";s:21:\"Oliveira Technologies\";s:11:\"company_url\";s:28:\"www.OliveiraTechnologies.com\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1090089\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11526\";s:7:\"created\";s:19:\"2023-02-13 20:43:02\";s:7:\"updated\";s:19:\"2023-02-21 16:01:49\";}i:9;O:8:\"stdClass\":22:{s:5:\"first\";s:5:\"Ralph\";s:4:\"last\";s:7:\"Grizzle\";s:5:\"email\";s:36:\"subscriptions@rivercruiseadvisor.com\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"6632210\";s:4:\"rate\";i:100;s:5:\"title\";s:25:\"Great Features for Tables\";s:4:\"text\";s:380:\"We’ve used TablePress for years. The developer, Tobias, is responsive and helpful. His software makes updating nice-looking, feature-rich tables easy. We use Tablepress a lot on tables such as the one on this page, https://www.rivercruiseadvisor.com/2023/02/riverside-luxury-cruises-2023-mozart-sailings-with-pricing/ Check the link out in mobile to see its responsive features.\";s:4:\"name\";s:13:\"Ralph Grizzle\";s:9:\"job_title\";s:6:\"Editor\";s:7:\"company\";s:20:\"River Cruise Advisor\";s:11:\"company_url\";s:34:\"HTTPS://www.rivercruiseadvisor.com\";s:7:\"picture\";s:102:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10340/reviews/e75cb4ce5b0fec7f8f8865cccde01fda.jpg\";s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1088635\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11504\";s:7:\"created\";s:19:\"2023-02-10 20:05:39\";s:7:\"updated\";s:19:\"2023-02-21 16:01:49\";}i:10;O:8:\"stdClass\":22:{s:5:\"first\";s:5:\"Sorin\";s:4:\"last\";s:3:\"Iga\";s:5:\"email\";s:19:\"sorin.iga@gmail.com\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"6618342\";s:4:\"rate\";i:100;s:5:\"title\";s:11:\"Very useful\";s:4:\"text\";s:90:\"For what advantage? I was tricked because of my own poor skills of using the free version.\";s:4:\"name\";s:9:\"Sorin Iga\";s:9:\"job_title\";s:9:\"President\";s:7:\"company\";s:28:\"SOCIETATEA ROMANA DE YUMEIHO\";s:11:\"company_url\";s:14:\"Https://sry.ro\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1086526\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11488\";s:7:\"created\";s:19:\"2023-02-07 13:07:55\";s:7:\"updated\";s:19:\"2023-02-21 16:01:50\";}i:11;O:8:\"stdClass\":22:{s:5:\"first\";s:7:\"Michael\";s:4:\"last\";s:8:\"Phillips\";s:5:\"email\";s:25:\"mphillips@syntegrausa.com\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"6594205\";s:4:\"rate\";i:100;s:5:\"title\";s:12:\"Great Plugin\";s:4:\"text\";s:242:\"We use this as a document listing page. I have been using this for some time, but the recent upgrades to make the tables responsive in addition to being able to fix the head row makes this even better. I give this a full-throated endorsement.\";s:4:\"name\";s:16:\"Michael Phillips\";s:9:\"job_title\";s:5:\"Owner\";s:7:\"company\";s:9:\"Syntégra\";s:11:\"company_url\";s:15:\"syntegrausa.com\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1083006\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11445\";s:7:\"created\";s:19:\"2023-02-01 00:03:24\";s:7:\"updated\";s:19:\"2023-02-21 16:01:51\";}i:12;O:8:\"stdClass\":22:{s:5:\"first\";s:5:\"Peter\";s:4:\"last\";s:9:\"Hoogeboom\";s:5:\"email\";s:44:\"secretaris@natuurwetenschappen-diligentia.nl\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"6567502\";s:4:\"rate\";i:100;s:5:\"title\";s:23:\"Tablepress does the job\";s:4:\"text\";s:167:\"For my website I needed a quick and direct search in one of my tables. Without programming Tablepress Pro allows me to achieve this. I\'m quite happy with the solution.\";s:4:\"name\";s:15:\"Peter Hoogeboom\";s:9:\"job_title\";s:24:\"secretary and IT manager\";s:7:\"company\";s:10:\"Diligentia\";s:11:\"company_url\";s:37:\"www.natuurwetenschappen-diligentia.nl\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1077269\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11385\";s:7:\"created\";s:19:\"2023-01-24 18:40:56\";s:7:\"updated\";s:19:\"2023-02-21 16:01:52\";}i:13;O:8:\"stdClass\":22:{s:5:\"first\";s:7:\"reymond\";s:4:\"last\";s:14:\"cervantes aras\";s:5:\"email\";s:23:\"invictusgeeks@gmail.com\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"5482715\";s:4:\"rate\";i:100;s:5:\"title\";s:7:\"Awesome\";s:4:\"text\";s:69:\"Awesome plugin, love it! It helps a lot on my esports gaming business\";s:4:\"name\";s:22:\"reymond cervantes aras\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1075487\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11349\";s:7:\"created\";s:19:\"2023-01-20 08:27:33\";s:7:\"updated\";s:19:\"2023-02-21 16:01:53\";}i:14;O:8:\"stdClass\":22:{s:5:\"first\";s:6:\"Sandro\";s:4:\"last\";s:4:\"Adam\";s:5:\"email\";s:18:\"adam@signcastle.ch\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"6409231\";s:4:\"rate\";i:100;s:5:\"title\";s:13:\"Great Support\";s:4:\"text\";s:264:\"It is all fine and easier to make a table. Except Vertical Scroll and Responsives doesn`t work, but I have a idea and had this table small to build and copy for phone and another big table for desktop. Tobias is a great support it helps me forwards to goal. Thanks\";s:4:\"name\";s:11:\"Sandro Adam\";s:9:\"job_title\";s:27:\"Freelancer & Werbetechniker\";s:7:\"company\";s:15:\"Adam Signcastle\";s:11:\"company_url\";s:17:\"www.signcastle.ch\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1073166\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11338\";s:7:\"created\";s:19:\"2023-01-18 10:37:34\";s:7:\"updated\";s:19:\"2023-02-21 16:01:54\";}i:15;O:8:\"stdClass\":22:{s:5:\"first\";s:5:\"Brian\";s:4:\"last\";s:6:\"Gannon\";s:5:\"email\";s:21:\"brian.gannon@mail.com\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"4424986\";s:4:\"rate\";i:100;s:5:\"title\";s:29:\"TablePress a must have plugin\";s:4:\"text\";s:318:\"I\'ve been using the free version of TablePress for over a year and now upgraded to the Pro. We are a Not for Profit classic car club and money is tight but as we use TablePress extensively throughout the site we consider it money well spent. I\'d definitely recommend it to anyone starting out on the WordPress journey.\";s:4:\"name\";s:12:\"Brian Gannon\";s:9:\"job_title\";s:25:\"Retired Computing Manager\";s:7:\"company\";s:37:\"Riley Motor Club of Western Australia\";s:11:\"company_url\";s:14:\"rileywa.org.au\";s:7:\"picture\";s:102:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10340/reviews/82046acbb1e5d08f332987042af7ffdd.jpg\";s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1072816\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11322\";s:7:\"created\";s:19:\"2023-01-16 06:21:22\";s:7:\"updated\";s:19:\"2023-02-21 16:01:55\";}i:16;O:8:\"stdClass\":22:{s:5:\"first\";s:3:\"Bob\";s:4:\"last\";s:5:\"Lucas\";s:5:\"email\";s:25:\"bob@lucastechservices.com\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"5407143\";s:4:\"rate\";i:100;s:5:\"title\";s:23:\"Lucas Tech Services LLC\";s:4:\"text\";s:110:\"Excellent plugin! We\'re using this for a \"Find a Dentist\" tool for Lee County Dental Society in Fort Myers, FL\";s:4:\"name\";s:9:\"Bob Lucas\";s:9:\"job_title\";s:5:\"Owner\";s:7:\"company\";s:23:\"Lucas Tech Services LLC\";s:11:\"company_url\";s:29:\"https://lucastechservices.com\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1069169\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11280\";s:7:\"created\";s:19:\"2023-01-09 16:37:07\";s:7:\"updated\";s:19:\"2023-01-15 19:38:41\";}i:17;O:8:\"stdClass\":22:{s:5:\"first\";s:4:\"Katy\";s:4:\"last\";s:4:\"Went\";s:5:\"email\";s:17:\"katy@paintout.org\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"6516621\";s:4:\"rate\";i:100;s:5:\"title\";s:29:\"Next level interactive tables\";s:4:\"text\";s:362:\"V2.x is a leap forward from v1. Much easier to manipulate large tables. Interactive search and filtering is intuitive and the pro version adds superb customisations. Same day support at a weekend blew.me away. Worth paying for Pro to support future development as the plug in is now critical to our site innovations. See paintout.org/catalogue for how we use it.\";s:4:\"name\";s:13:\"Katy Jon Went\";s:9:\"job_title\";s:14:\"Event creative\";s:7:\"company\";s:8:\"PaintOut\";s:11:\"company_url\";s:23:\"Http://www.paintout.org\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1068689\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11276\";s:7:\"created\";s:19:\"2023-01-08 15:41:13\";s:7:\"updated\";s:19:\"2023-02-21 16:02:02\";}i:18;O:8:\"stdClass\":22:{s:5:\"first\";s:5:\"Peter\";s:4:\"last\";s:6:\"Deegan\";s:5:\"email\";s:21:\"shop@office-watch.com\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"6512846\";s:4:\"rate\";i:100;s:5:\"title\";s:39:\"Invaluable, flexible and well-supported\";s:4:\"text\";s:256:\"Tobias has done a great job with TablePress. It’s invaluable on our sites. Very flexible, really more adaptable than it might first appear. On the rare occasion I’ve need support, Tobias has been quick to reply with help that’s relevant and accurate.\";s:4:\"name\";s:12:\"Peter Deegan\";s:9:\"job_title\";s:15:\"Editor in Chief\";s:7:\"company\";s:16:\"Office-Watch.com\";s:11:\"company_url\";s:25:\"https://office-watch.com/\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1067915\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11264\";s:7:\"created\";s:19:\"2023-01-07 13:12:15\";s:7:\"updated\";s:19:\"2023-02-21 16:02:03\";}i:19;O:8:\"stdClass\":22:{s:5:\"first\";s:7:\"Stephen\";s:4:\"last\";s:6:\"Jarvis\";s:5:\"email\";s:24:\"steve@jarvisfamily.me.uk\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"6509270\";s:4:\"rate\";i:100;s:5:\"title\";s:9:\"Excellent\";s:4:\"text\";s:79:\"Best Wordpress plug-in for tables - have used for many years, Support excellent\";s:4:\"name\";s:14:\"Stephen Jarvis\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1067262\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11255\";s:7:\"created\";s:19:\"2023-01-05 10:51:17\";s:7:\"updated\";s:19:\"2023-01-05 10:54:30\";}i:20;O:8:\"stdClass\":22:{s:5:\"first\";s:7:\"Quentin\";s:4:\"last\";s:7:\"Patault\";s:5:\"email\";s:29:\"web.eggbeater123@passmail.net\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"6494117\";s:4:\"rate\";i:100;s:5:\"title\";s:31:\"Awesome plugin and great plugin\";s:4:\"text\";s:163:\"Fast to learn, easy to use, efficicient, the best data table plugin you can find to show tables with filters, search bar, and more. Big plus : Support from Tobias.\";s:4:\"name\";s:7:\"Blodarn\";s:9:\"job_title\";s:8:\"Engineer\";s:7:\"company\";N;s:11:\"company_url\";s:38:\"https://www.beyondlifting.org/results/\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1064952\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11219\";s:7:\"created\";s:19:\"2022-12-30 06:42:23\";s:7:\"updated\";s:19:\"2023-01-05 10:21:54\";}i:21;O:8:\"stdClass\":22:{s:5:\"first\";s:4:\"Rolf\";s:4:\"last\";s:6:\"Kyburz\";s:5:\"email\";s:18:\"rolf.kyburz@me.com\";s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";s:6:\"820689\";s:4:\"rate\";i:100;s:5:\"title\";s:46:\"It was well worth the wait: a fabulous update!\";s:4:\"text\";s:192:\"With this update, most or all of the previous flaws / deficiencies are resolved, in my case particularly the speed of importing large / huge databases: thanks a lot for all these enhancements!\";s:4:\"name\";s:11:\"Rolf Kyburz\";s:9:\"job_title\";s:17:\"Freelance blogger\";s:7:\"company\";N;s:11:\"company_url\";s:30:\"https://www.rolf-musicblog.net\";s:7:\"picture\";s:102:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10340/reviews/5f60cd8a87baf5acfddab66cb52e6d1c.jpg\";s:11:\"profile_url\";N;s:10:\"license_id\";s:7:\"1064906\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"11217\";s:7:\"created\";s:19:\"2022-12-30 01:21:13\";s:7:\"updated\";s:19:\"2023-01-05 10:21:55\";}i:22;O:8:\"stdClass\":22:{s:5:\"first\";N;s:4:\"last\";N;s:5:\"email\";N;s:9:\"plugin_id\";s:5:\"10340\";s:11:\"external_id\";N;s:7:\"user_id\";N;s:4:\"rate\";i:100;s:5:\"title\";s:19:\"Absolutely Fabulous\";s:4:\"text\";s:180:\"The support with these amazing plugin is just amazing! The creator, Tobias, is just patient and friendly. ALWAYS! You will not be disappointed with this plugin. Tobias, keep it up!\";s:4:\"name\";s:11:\"rtw4jwerito\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";N;s:11:\"is_verified\";b:0;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"9946\";s:7:\"created\";s:19:\"2022-05-31 19:21:42\";s:7:\"updated\";s:19:\"2022-12-21 10:51:35\";}}s:15:\"active_installs\";i:700000;s:9:\"downloads\";i:18095262;s:29:\"all_plans_single_site_pricing\";O:8:\"stdClass\":3:{s:5:\"17454\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}s:5:\"17457\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";d:7.4166666666666998;s:3:\"eur\";d:7.4166666666666998;s:3:\"gbp\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:89;s:3:\"eur\";i:89;s:3:\"gbp\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:389;s:3:\"gbp\";i:0;s:3:\"eur\";i:389;}}s:5:\"17459\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";d:15.75;s:3:\"eur\";d:15.75;s:3:\"gbp\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:189;s:3:\"eur\";i:189;s:3:\"gbp\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:789;s:3:\"gbp\";i:0;s:3:\"eur\";i:789;}}}s:12:\"checkout_url\";s:29:\"https://checkout.freemius.com\";s:18:\"fs_wp_endpoint_url\";s:23:\"https://wp.freemius.com\";s:10:\"trial_mode\";b:0;s:14:\"trial_utilized\";b:0;s:23:\"skip_directly_to_paypal\";b:0;s:19:\"is_paypal_supported\";b:1;}s:7:\"created\";i:1737007579;s:9:\"timestamp\";i:1737093979;}}", "off");
INSERT INTO `wp_options` VALUES("195", "action_scheduler_lock_async-request-runner", "694e6fb7932c75.06455111|1766748147", "no");
INSERT INTO `wp_options` VALUES("199", "widget_searchwp_live_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("200", "tablepress_plugin_options", "{\"plugin_options_db_version\":120,\"table_scheme_db_version\":3,\"prev_tablepress_version\":\"3.1.3\",\"tablepress_version\":\"3.2.6\",\"first_activation\":1732287396,\"message_plugin_update\":true,\"message_donation_nag\":true,\"use_custom_css\":true,\"use_custom_css_file\":true,\"custom_css\":\"\",\"custom_css_minified\":\"\",\"custom_css_version\":0,\"modules\":false}", "auto");
INSERT INTO `wp_options` VALUES("204", "searchwp_lite_admin_notifications", "a:3:{s:10:\"updated_at\";i:1733298526;s:13:\"dismissed_ids\";a:0:{}s:13:\"notifications\";a:1:{i:0;a:9:{s:9:\"remote_id\";s:2:\"43\";s:4:\"type\";s:4:\"info\";s:5:\"title\";s:48:\"Black Friday: Get Up to $350 Off SearchWP Today!\";s:4:\"slug\";s:45:\"black-friday-get-up-to-350-off-searchwp-today\";s:7:\"content\";s:402:\"Our biggest sale of the year is now live! Get up to $350 off SearchWP, the most powerful search plugin for WordPress, when you purchase or upgrade today. You’ll unlock all the incredible features like conditional search redirects, searching ALL your website content, metrics &amp; insights and more! Your discount is already applied to the cart, so claim it today for the biggest savings of the year!\";s:7:\"actions\";a:1:{i:0;a:3:{s:4:\"type\";s:7:\"primary\";s:3:\"url\";s:129:\"https://searchwp.com/buy/?utm_source=WordPress&utm_campaign=BFCM2024&utm_medium=Plugin+Notification&utm_content=Claim+My+Discount\";s:4:\"text\";s:17:\"Claim My Discount\";}}s:10:\"conditions\";a:4:{i:0;s:4:\"lite\";i:1;s:8:\"inactive\";i:2;s:3:\"pro\";i:3;s:8:\"standard\";}s:5:\"start\";s:19:\"2024-11-26 00:00:00\";s:3:\"end\";s:19:\"2024-12-08 00:00:00\";}}}", "auto");
INSERT INTO `wp_options` VALUES("228", "duplicator_version_plugin", "1.5.14", "auto");
INSERT INTO `wp_options` VALUES("231", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `wp_options` VALUES("232", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `wp_options` VALUES("233", "duplicator_settings", "a:19:{s:7:\"version\";s:6:\"1.5.14\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:8;s:14:\"usage_tracking\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("237", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-26 11:21:25\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:7:\"10.6.24\";s:10:\"VersionPHP\";s:6:\"8.1.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:14:\"mianabpefinall\";s:4:\"Hash\";s:35:\"09a25d93da2b744f1401_20251226112125\";s:8:\"NameHash\";s:50:\"mianabpefinall_09a25d93da2b744f1401_20251226112125\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:60:\"mianabpefinall_09a25d93da2b744f1401_20251226112125_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:47:\"/home/fekragam/domains/mianabpe.com/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2888;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:18884;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-26 11:21:25\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:7:\"10.6.24\";s:10:\"VersionPHP\";s:6:\"8.1.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:14:\"mianabpefinall\";s:4:\"Hash\";s:35:\"09a25d93da2b744f1401_20251226112125\";s:8:\"NameHash\";s:50:\"mianabpefinall_09a25d93da2b744f1401_20251226112125\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:61:\"/home/fekragam/domains/mianabpe.com/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:56:\"/home/fekragam/domains/mianabpe.com/public_html/wp-admin\";i:1;s:59:\"/home/fekragam/domains/mianabpe.com/public_html/wp-includes\";i:2;s:68:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:47:\"/home/fekragam/domains/mianabpe.com/public_html\";i:1;s:47:\"/home/fekragam/domains/mianabpe.com/public_html\";i:2;s:58:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content\";i:3;s:66:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/uploads\";i:4;s:66:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/plugins\";i:5;s:69:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/mu-plugins\";i:6;s:65:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:79:\"/home/fekragam/domains/mianabpe.com/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "auto");
INSERT INTO `wp_options` VALUES("244", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[],\"failedPackageIds\":[]}", "auto");
INSERT INTO `wp_options` VALUES("274", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("287", "woocommerce_newly_installed", "no", "auto");
INSERT INTO `wp_options` VALUES("288", "woocommerce_schema_version", "920", "auto");
INSERT INTO `wp_options` VALUES("289", "woocommerce_store_address", "", "on");
INSERT INTO `wp_options` VALUES("290", "woocommerce_store_address_2", "", "on");
INSERT INTO `wp_options` VALUES("291", "woocommerce_store_city", "", "on");
INSERT INTO `wp_options` VALUES("292", "woocommerce_default_country", "US:CA", "on");
INSERT INTO `wp_options` VALUES("293", "woocommerce_store_postcode", "", "on");
INSERT INTO `wp_options` VALUES("294", "woocommerce_allowed_countries", "all", "on");
INSERT INTO `wp_options` VALUES("295", "woocommerce_all_except_countries", "", "on");
INSERT INTO `wp_options` VALUES("296", "woocommerce_specific_allowed_countries", "", "on");
INSERT INTO `wp_options` VALUES("297", "woocommerce_ship_to_countries", "", "on");
INSERT INTO `wp_options` VALUES("298", "woocommerce_specific_ship_to_countries", "", "on");
INSERT INTO `wp_options` VALUES("299", "woocommerce_default_customer_address", "base", "on");
INSERT INTO `wp_options` VALUES("300", "woocommerce_calc_taxes", "no", "on");
INSERT INTO `wp_options` VALUES("301", "woocommerce_enable_coupons", "yes", "on");
INSERT INTO `wp_options` VALUES("302", "woocommerce_calc_discounts_sequentially", "no", "off");
INSERT INTO `wp_options` VALUES("303", "woocommerce_currency", "USD", "on");
INSERT INTO `wp_options` VALUES("304", "woocommerce_currency_pos", "left", "on");
INSERT INTO `wp_options` VALUES("305", "woocommerce_price_thousand_sep", ",", "on");
INSERT INTO `wp_options` VALUES("306", "woocommerce_price_decimal_sep", ".", "on");
INSERT INTO `wp_options` VALUES("307", "woocommerce_price_num_decimals", "2", "on");
INSERT INTO `wp_options` VALUES("308", "woocommerce_shop_page_id", "11", "on");
INSERT INTO `wp_options` VALUES("309", "woocommerce_cart_redirect_after_add", "no", "on");
INSERT INTO `wp_options` VALUES("310", "woocommerce_enable_ajax_add_to_cart", "yes", "on");
INSERT INTO `wp_options` VALUES("311", "woocommerce_placeholder_image", "10", "on");
INSERT INTO `wp_options` VALUES("312", "woocommerce_weight_unit", "kg", "on");
INSERT INTO `wp_options` VALUES("313", "woocommerce_dimension_unit", "cm", "on");
INSERT INTO `wp_options` VALUES("314", "woocommerce_enable_reviews", "yes", "on");
INSERT INTO `wp_options` VALUES("315", "woocommerce_review_rating_verification_label", "yes", "off");
INSERT INTO `wp_options` VALUES("316", "woocommerce_review_rating_verification_required", "no", "off");
INSERT INTO `wp_options` VALUES("317", "woocommerce_enable_review_rating", "yes", "on");
INSERT INTO `wp_options` VALUES("318", "woocommerce_review_rating_required", "yes", "off");
INSERT INTO `wp_options` VALUES("319", "woocommerce_manage_stock", "yes", "on");
INSERT INTO `wp_options` VALUES("320", "woocommerce_hold_stock_minutes", "60", "off");
INSERT INTO `wp_options` VALUES("321", "woocommerce_notify_low_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("322", "woocommerce_notify_no_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("323", "woocommerce_stock_email_recipient", "mohammadrezabehdarvand@gmail.com", "off");
INSERT INTO `wp_options` VALUES("324", "woocommerce_notify_low_stock_amount", "2", "off");
INSERT INTO `wp_options` VALUES("325", "woocommerce_notify_no_stock_amount", "0", "on");
INSERT INTO `wp_options` VALUES("326", "woocommerce_hide_out_of_stock_items", "no", "on");
INSERT INTO `wp_options` VALUES("327", "woocommerce_stock_format", "", "on");
INSERT INTO `wp_options` VALUES("328", "woocommerce_file_download_method", "force", "off");
INSERT INTO `wp_options` VALUES("329", "woocommerce_downloads_redirect_fallback_allowed", "no", "off");
INSERT INTO `wp_options` VALUES("330", "woocommerce_downloads_require_login", "no", "off");
INSERT INTO `wp_options` VALUES("331", "woocommerce_downloads_grant_access_after_payment", "yes", "off");
INSERT INTO `wp_options` VALUES("332", "woocommerce_downloads_deliver_inline", "", "off");
INSERT INTO `wp_options` VALUES("333", "woocommerce_downloads_add_hash_to_filename", "yes", "on");
INSERT INTO `wp_options` VALUES("334", "woocommerce_downloads_count_partial", "yes", "on");
INSERT INTO `wp_options` VALUES("336", "woocommerce_attribute_lookup_direct_updates", "no", "on");
INSERT INTO `wp_options` VALUES("337", "woocommerce_attribute_lookup_optimized_updates", "no", "on");
INSERT INTO `wp_options` VALUES("338", "woocommerce_product_match_featured_image_by_sku", "no", "on");
INSERT INTO `wp_options` VALUES("339", "woocommerce_prices_include_tax", "no", "on");
INSERT INTO `wp_options` VALUES("340", "woocommerce_tax_based_on", "shipping", "on");
INSERT INTO `wp_options` VALUES("341", "woocommerce_shipping_tax_class", "inherit", "on");
INSERT INTO `wp_options` VALUES("342", "woocommerce_tax_round_at_subtotal", "no", "on");
INSERT INTO `wp_options` VALUES("343", "woocommerce_tax_classes", "", "on");
INSERT INTO `wp_options` VALUES("344", "woocommerce_tax_display_shop", "excl", "on");
INSERT INTO `wp_options` VALUES("345", "woocommerce_tax_display_cart", "excl", "on");
INSERT INTO `wp_options` VALUES("346", "woocommerce_price_display_suffix", "", "on");
INSERT INTO `wp_options` VALUES("347", "woocommerce_tax_total_display", "itemized", "off");
INSERT INTO `wp_options` VALUES("348", "woocommerce_enable_shipping_calc", "yes", "off");
INSERT INTO `wp_options` VALUES("349", "woocommerce_shipping_cost_requires_address", "no", "on");
INSERT INTO `wp_options` VALUES("350", "woocommerce_ship_to_destination", "billing", "off");
INSERT INTO `wp_options` VALUES("351", "woocommerce_shipping_debug_mode", "no", "on");
INSERT INTO `wp_options` VALUES("352", "woocommerce_enable_guest_checkout", "yes", "off");
INSERT INTO `wp_options` VALUES("353", "woocommerce_enable_checkout_login_reminder", "yes", "off");
INSERT INTO `wp_options` VALUES("354", "woocommerce_enable_signup_and_login_from_checkout", "yes", "off");
INSERT INTO `wp_options` VALUES("355", "woocommerce_enable_myaccount_registration", "yes", "off");
INSERT INTO `wp_options` VALUES("356", "woocommerce_registration_generate_username", "yes", "off");
INSERT INTO `wp_options` VALUES("357", "woocommerce_registration_generate_password", "yes", "off");
INSERT INTO `wp_options` VALUES("358", "woocommerce_erasure_request_removes_order_data", "no", "off");
INSERT INTO `wp_options` VALUES("359", "woocommerce_erasure_request_removes_download_data", "no", "off");
INSERT INTO `wp_options` VALUES("360", "woocommerce_allow_bulk_remove_personal_data", "no", "off");
INSERT INTO `wp_options` VALUES("361", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.", "on");
INSERT INTO `wp_options` VALUES("362", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما، پشتیبانی از تجربه شما در سراسر این وب سایت و برای اهدافی که در [privacy_policy] ذکر شده است استفاده می شود.", "on");
INSERT INTO `wp_options` VALUES("363", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("364", "woocommerce_trash_pending_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "off");
INSERT INTO `wp_options` VALUES("365", "woocommerce_trash_failed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "off");
INSERT INTO `wp_options` VALUES("366", "woocommerce_trash_cancelled_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "off");
INSERT INTO `wp_options` VALUES("367", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("368", "woocommerce_email_from_name", "لوله و پلی اتیلن میاناب", "off");
INSERT INTO `wp_options` VALUES("369", "woocommerce_email_from_address", "mohammadrezabehdarvand@gmail.com", "off");
INSERT INTO `wp_options` VALUES("370", "woocommerce_email_header_image", "", "off");
INSERT INTO `wp_options` VALUES("371", "woocommerce_email_base_color", "#720eec", "off");
INSERT INTO `wp_options` VALUES("372", "woocommerce_email_background_color", "#f7f7f7", "off");
INSERT INTO `wp_options` VALUES("373", "woocommerce_email_body_background_color", "#ffffff", "off");
INSERT INTO `wp_options` VALUES("374", "woocommerce_email_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("375", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "off");
INSERT INTO `wp_options` VALUES("376", "woocommerce_email_footer_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("377", "woocommerce_merchant_email_notifications", "no", "off");
INSERT INTO `wp_options` VALUES("378", "woocommerce_cart_page_id", "12", "off");
INSERT INTO `wp_options` VALUES("379", "woocommerce_checkout_page_id", "13", "off");
INSERT INTO `wp_options` VALUES("380", "woocommerce_myaccount_page_id", "14", "off");
INSERT INTO `wp_options` VALUES("381", "woocommerce_terms_page_id", "", "off");
INSERT INTO `wp_options` VALUES("382", "woocommerce_force_ssl_checkout", "no", "on");
INSERT INTO `wp_options` VALUES("383", "woocommerce_unforce_ssl_checkout", "no", "on");
INSERT INTO `wp_options` VALUES("384", "woocommerce_checkout_pay_endpoint", "order-pay", "on");
INSERT INTO `wp_options` VALUES("385", "woocommerce_checkout_order_received_endpoint", "order-received", "on");
INSERT INTO `wp_options` VALUES("386", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "on");
INSERT INTO `wp_options` VALUES("387", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "on");
INSERT INTO `wp_options` VALUES("388", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "on");
INSERT INTO `wp_options` VALUES("389", "woocommerce_myaccount_orders_endpoint", "orders", "on");
INSERT INTO `wp_options` VALUES("390", "woocommerce_myaccount_view_order_endpoint", "view-order", "on");
INSERT INTO `wp_options` VALUES("391", "woocommerce_myaccount_downloads_endpoint", "downloads", "on");
INSERT INTO `wp_options` VALUES("392", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "on");
INSERT INTO `wp_options` VALUES("393", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "on");
INSERT INTO `wp_options` VALUES("394", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "on");
INSERT INTO `wp_options` VALUES("395", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "on");
INSERT INTO `wp_options` VALUES("396", "woocommerce_logout_endpoint", "customer-logout", "on");
INSERT INTO `wp_options` VALUES("397", "woocommerce_api_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("398", "woocommerce_allow_tracking", "no", "on");
INSERT INTO `wp_options` VALUES("399", "woocommerce_show_marketplace_suggestions", "yes", "off");
INSERT INTO `wp_options` VALUES("400", "woocommerce_custom_orders_table_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("401", "woocommerce_analytics_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("402", "woocommerce_feature_order_attribution_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("403", "woocommerce_feature_site_visibility_badge_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("404", "woocommerce_feature_product_block_editor_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("405", "woocommerce_hpos_fts_index_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("406", "woocommerce_single_image_width", "600", "on");
INSERT INTO `wp_options` VALUES("407", "woocommerce_thumbnail_image_width", "300", "on");
INSERT INTO `wp_options` VALUES("408", "woocommerce_checkout_highlight_required_fields", "yes", "on");
INSERT INTO `wp_options` VALUES("409", "woocommerce_demo_store", "no", "off");
INSERT INTO `wp_options` VALUES("410", "wc_downloads_approved_directories_mode", "enabled", "auto");
INSERT INTO `wp_options` VALUES("411", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"/product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("412", "current_theme_supports_woocommerce", "yes", "auto");
INSERT INTO `wp_options` VALUES("413", "woocommerce_queue_flush_rewrite_rules", "no", "auto");
INSERT INTO `wp_options` VALUES("416", "default_product_cat", "16", "auto");
INSERT INTO `wp_options` VALUES("418", "woocommerce_refund_returns_page_id", "15", "auto");
INSERT INTO `wp_options` VALUES("421", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:32:\"mohammadrezabehdarvand@gmail.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:32:\"mohammadrezabehdarvand@gmail.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "on");
INSERT INTO `wp_options` VALUES("422", "woocommerce_version", "10.4.3", "auto");
INSERT INTO `wp_options` VALUES("423", "woocommerce_db_version", "10.4.3", "auto");
INSERT INTO `wp_options` VALUES("424", "woocommerce_store_id", "b9e0b206-6516-4533-8feb-ed0a3dffd5de", "auto");
INSERT INTO `wp_options` VALUES("425", "woocommerce_admin_install_timestamp", "1732294659", "auto");
INSERT INTO `wp_options` VALUES("426", "woocommerce_inbox_variant_assignment", "11", "auto");
INSERT INTO `wp_options` VALUES("427", "woocommerce_remote_variant_assignment", "6", "auto");
INSERT INTO `wp_options` VALUES("433", "woocommerce_admin_notices", "a:1:{i:0;s:14:\"template_files\";}", "auto");
INSERT INTO `wp_options` VALUES("435", "wc_blocks_version", "11.8.0-dev", "auto");
INSERT INTO `wp_options` VALUES("436", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"SH7jPrqrmC0D1PfgKLNYmibvFQpPXukf\";}", "on");
INSERT INTO `wp_options` VALUES("439", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("441", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("442", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("443", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("444", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("445", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("446", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("447", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("448", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("449", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("451", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("452", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("461", "wcpay_was_in_use", "no", "auto");
INSERT INTO `wp_options` VALUES("468", "wc_admin_show_legacy_coupon_menu", "0", "auto");
INSERT INTO `wp_options` VALUES("469", "woocommerce_custom_orders_table_created", "yes", "auto");
INSERT INTO `wp_options` VALUES("470", "woocommerce_coming_soon", "no", "auto");
INSERT INTO `wp_options` VALUES("471", "woocommerce_initial_installed_version", "9.4.2", "off");
INSERT INTO `wp_options` VALUES("474", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("477", "jetpack_options", "a:1:{s:14:\"last_heartbeat\";i:1766747377;}", "auto");
INSERT INTO `wp_options` VALUES("481", "wc_blocks_db_schema_version", "260", "auto");
INSERT INTO `wp_options` VALUES("517", "https_detection_errors", "a:1:{s:23:\"ssl_verification_failed\";a:1:{i:0;s:35:\"تأیید SSL ناموفق بود.\";}}", "auto");
INSERT INTO `wp_options` VALUES("554", "duplicator_dismissed_admin_notices", "a:1:{s:14:\"review_request\";a:1:{s:4:\"time\";i:1733050040;}}", "on");
INSERT INTO `wp_options` VALUES("772", "recovery_mode_email_last_sent", "1733752418", "auto");
INSERT INTO `wp_options` VALUES("919", "category_children", "a:2:{i:1;a:2:{i:0;i:17;i:1;i:18;}i:19;a:3:{i:0;i:20;i:1;i:21;i:2;i:22;}}", "auto");
INSERT INTO `wp_options` VALUES("929", "taxonomy_image_plugin_settings", "a:1:{s:10:\"taxonomies\";a:1:{i:0;s:8:\"category\";}}", "auto");
INSERT INTO `wp_options` VALUES("933", "taxonomy_image_plugin", "a:7:{i:1;i:24;i:18;i:24;i:17;i:24;i:19;i:24;i:21;i:24;i:22;i:24;i:20;i:24;}", "auto");
INSERT INTO `wp_options` VALUES("961", "searchwp_live_search_admin_notices", "a:1:{s:23:\"improve_your_search_cta\";a:2:{s:4:\"time\";i:1733219892;s:9:\"dismissed\";b:1;}}", "on");
INSERT INTO `wp_options` VALUES("972", "woocommerce_task_list_tracked_completed_tasks", "a:3:{i:0;s:17:\"launch-your-store\";i:1;s:8:\"products\";i:2;s:15:\"customize-store\";}", "auto");
INSERT INTO `wp_options` VALUES("1064", "tablepress_tables", "{\"last_id\":24,\"table_post\":{\"5\":276,\"6\":287,\"7\":297,\"8\":300,\"9\":361,\"10\":433,\"12\":456,\"13\":459,\"14\":461,\"15\":465,\"16\":468,\"17\":471,\"18\":474,\"20\":479,\"21\":492,\"22\":494,\"23\":496,\"24\":499}}", "auto");
INSERT INTO `wp_options` VALUES("1137", "searchwp_live_search_settings", "a:20:{s:18:\"enable-live-search\";b:1;s:20:\"include-frontend-css\";s:3:\"all\";s:21:\"results-pane-position\";s:6:\"bottom\";s:23:\"results-pane-auto-width\";b:1;s:18:\"hide-announcements\";b:0;s:16:\"swp-layout-theme\";s:4:\"rich\";s:14:\"swp-image-size\";s:5:\"small\";s:22:\"swp-no-results-message\";s:17:\"No results found.\";s:23:\"swp-description-enabled\";b:0;s:20:\"swp-results-per-page\";i:7;s:13:\"swp-min-chars\";i:3;s:15:\"swp-title-color\";s:0:\"\";s:19:\"swp-title-font-size\";i:16;s:17:\"swp-price-enabled\";b:0;s:15:\"swp-price-color\";s:0:\"\";s:19:\"swp-price-font-size\";i:14;s:23:\"swp-add-to-cart-enabled\";b:0;s:32:\"swp-add-to-cart-background-color\";s:0:\"\";s:26:\"swp-add-to-cart-font-color\";s:0:\"\";s:25:\"swp-add-to-cart-font-size\";i:14;}", "auto");
INSERT INTO `wp_options` VALUES("1166", "jetpack_connection_active_plugins", "a:1:{s:11:\"woocommerce\";a:1:{s:4:\"name\";s:11:\"WooCommerce\";}}", "auto");
INSERT INTO `wp_options` VALUES("1338", "wc_remote_inbox_notifications_wca_updated", "", "off");
INSERT INTO `wp_options` VALUES("1520", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wp_options` VALUES("2315", "duplicator_notifications", "a:4:{s:6:\"update\";i:1766717609;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("2745", "duplicator_pro_exe_safe_mode", "0", "yes");
INSERT INTO `wp_options` VALUES("2746", "duplicator_activate_plugins_after_installation", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2865", "redux-framework_extendify_plugin_notice", "hide", "auto");
INSERT INTO `wp_options` VALUES("3544", "woocommerce_task_list_reminder_bar_hidden", "yes", "auto");
INSERT INTO `wp_options` VALUES("4654", "woocommerce_admin_customize_store_completed", "yes", "auto");
INSERT INTO `wp_options` VALUES("4655", "woocommerce_maybe_regenerate_images_hash", "991b1ca641921cf0f5baf7a2fe85861b", "auto");
INSERT INTO `wp_options` VALUES("5761", "woocommerce_share_key", "e6iYI8GQRcqIdKyeM7v4eEIrliYGtaYO", "auto");
INSERT INTO `wp_options` VALUES("6038", "ure_tasks_queue", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("8579", "wcpay_welcome_page_viewed_timestamp", "1739883039", "auto");
INSERT INTO `wp_options` VALUES("14676", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:32:\"mohammadrezabehdarvand@gmail.com\";s:7:\"version\";s:5:\"6.8.1\";s:9:\"timestamp\";i:1746071661;}", "off");
INSERT INTO `wp_options` VALUES("15661", "yit_recently_activated", "a:1:{i:0;s:41:\"yith-woocommerce-ajax-navigation/init.php\";}", "auto");
INSERT INTO `wp_options` VALUES("15663", "widget_yith-woo-ajax-navigation", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("15664", "widget_yith-woo-ajax-reset-navigation", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("15665", "widget_yith-woocommerce-ajax-navigation-filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("15666", "yith_wcan_default_preset_created", "1", "auto");
INSERT INTO `wp_options` VALUES("15667", "yith_wcan_lazy_load_filters", "yes", "auto");
INSERT INTO `wp_options` VALUES("15668", "yith_wcan_paginate_terms", "yes", "auto");
INSERT INTO `wp_options` VALUES("15669", "yith_woocommerce_variations_filtering", "yes", "auto");
INSERT INTO `wp_options` VALUES("15670", "yith_wcan_version", "5.9.0", "auto");
INSERT INTO `wp_options` VALUES("15671", "yith_wcan_db_version", "5.1.0", "auto");
INSERT INTO `wp_options` VALUES("15672", "yith_wcan_show_reset", "no", "auto");
INSERT INTO `wp_options` VALUES("15673", "yith_wcan_reset_button_position", "after_filters", "auto");
INSERT INTO `wp_options` VALUES("15674", "yith_wcan_change_browser_url", "yes", "auto");
INSERT INTO `wp_options` VALUES("15675", "yit_plugin_fw_panel_wc_default_options_set", "a:1:{s:15:\"yith_wcan_panel\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("20894", "widget_wc_brands_brand_description", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("20895", "widget_woocommerce_brand_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("20896", "widget_wc_brands_brand_thumbnails", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("20899", "woocommerce_feature_rate_limit_checkout_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("20900", "woocommerce_feature_remote_logging_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("20901", "woocommerce_feature_email_improvements_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("20902", "woocommerce_feature_cost_of_goods_sold_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("20926", "woocommerce_admin_pes_incentive_woopayments_store_had_woopayments", "no", "auto");
INSERT INTO `wp_options` VALUES("20936", "product_brand_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("20938", "rank_math_registration_skip", "1", "auto");
INSERT INTO `wp_options` VALUES("20939", "rank_math_review_notice_date", "1744123761", "off");
INSERT INTO `wp_options` VALUES("20940", "rank_math_pro_notice_date", "1743778161", "off");
INSERT INTO `wp_options` VALUES("20941", "rank_math_review_posts_converted", "1", "auto");
INSERT INTO `wp_options` VALUES("20943", "rank_math_wizard_completed", "1", "off");
INSERT INTO `wp_options` VALUES("20946", "rank_math_google_analytic_profile", "a:3:{s:7:\"country\";b:0;s:7:\"profile\";b:0;s:19:\"enable_index_status\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("20947", "rank_math_google_analytic_options", "a:11:{s:10:\"adsense_id\";b:0;s:10:\"account_id\";b:0;s:11:\"property_id\";b:0;s:7:\"view_id\";b:0;s:14:\"measurement_id\";b:0;s:11:\"stream_name\";b:0;s:7:\"country\";b:0;s:12:\"install_code\";b:0;s:12:\"anonymize_ip\";b:0;s:11:\"local_ga_js\";b:0;s:16:\"exclude_loggedin\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("20948", "rank_math_analytics_installed", "1", "auto");
INSERT INTO `wp_options` VALUES("20950", "rank_math_is_configured", "1", "off");
INSERT INTO `wp_options` VALUES("20953", "rank_math_viewed_seo_analyer", "1", "off");
INSERT INTO `wp_options` VALUES("20957", "woocommerce_checkout_phone_field", "optional", "auto");
INSERT INTO `wp_options` VALUES("20958", "woocommerce_checkout_company_field", "hidden", "auto");
INSERT INTO `wp_options` VALUES("20959", "woocommerce_checkout_address_2_field", "optional", "auto");
INSERT INTO `wp_options` VALUES("20962", "rank_math_content_ai_viewed", "1", "off");
INSERT INTO `wp_options` VALUES("22212", "rank_math_pro_notice_added", "1", "off");
INSERT INTO `wp_options` VALUES("22661", "rank_math_review_notice_added", "1", "off");
INSERT INTO `wp_options` VALUES("23791", "rank_math_indexnow_log", "a:54:{i:0;a:5:{s:3:\"url\";s:30:\"https://mianabpe.com/about-us/\";s:6:\"status\";i:202;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1744624828;}i:1;a:5:{s:3:\"url\";s:30:\"https://mianabpe.com/about-us/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1744625982;}i:2;a:5:{s:3:\"url\";s:30:\"https://mianabpe.com/about-us/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1744626005;}i:3;a:5:{s:3:\"url\";s:30:\"https://mianabpe.com/about-us/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1744626509;}i:4;a:5:{s:3:\"url\";s:30:\"https://mianabpe.com/about-us/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1744626517;}i:5;a:5:{s:3:\"url\";s:29:\"https://mianabpe.com/contact/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1744626932;}i:6;a:5:{s:3:\"url\";s:29:\"https://mianabpe.com/contact/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1744627284;}i:7;a:5:{s:3:\"url\";s:29:\"https://mianabpe.com/contact/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1744627309;}i:8;a:5:{s:3:\"url\";s:21:\"https://mianabpe.com/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1744627916;}i:9;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1746517849;}i:10;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:429;s:17:\"manual_submission\";b:0;s:7:\"message\";s:17:\"Too Many Requests\";s:4:\"time\";i:1748854432;}i:11;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:429;s:17:\"manual_submission\";b:0;s:7:\"message\";s:17:\"Too Many Requests\";s:4:\"time\";i:1748855983;}i:12;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:429;s:17:\"manual_submission\";b:0;s:7:\"message\";s:17:\"Too Many Requests\";s:4:\"time\";i:1748856018;}i:13;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:429;s:17:\"manual_submission\";b:0;s:7:\"message\";s:17:\"Too Many Requests\";s:4:\"time\";i:1748881875;}i:14;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:429;s:17:\"manual_submission\";b:0;s:7:\"message\";s:17:\"Too Many Requests\";s:4:\"time\";i:1748882019;}i:15;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:429;s:17:\"manual_submission\";b:0;s:7:\"message\";s:17:\"Too Many Requests\";s:4:\"time\";i:1748884494;}i:16;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:429;s:17:\"manual_submission\";b:0;s:7:\"message\";s:17:\"Too Many Requests\";s:4:\"time\";i:1748971412;}i:17;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1749554812;}i:18;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1749646891;}i:19;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1749646966;}i:20;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1749648413;}i:21;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1749648522;}i:22;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1749648562;}i:23;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1749648637;}i:24;a:5:{s:3:\"url\";s:29:\"https://mianabpe.com/contact/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1749649612;}i:25;a:5:{s:3:\"url\";s:29:\"https://mianabpe.com/contact/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1749650526;}i:26;a:5:{s:3:\"url\";s:29:\"https://mianabpe.com/contact/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1749650625;}i:27;a:5:{s:3:\"url\";s:29:\"https://mianabpe.com/contact/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1749650667;}i:28;a:5:{s:3:\"url\";s:29:\"https://mianabpe.com/contact/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1749650743;}i:29;a:5:{s:3:\"url\";s:29:\"https://mianabpe.com/contact/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1749650808;}i:30;a:5:{s:3:\"url\";s:29:\"https://mianabpe.com/contact/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1749650929;}i:31;a:5:{s:3:\"url\";s:29:\"https://mianabpe.com/contact/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1749650954;}i:32;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1752386403;}i:33;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1752471272;}i:34;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1756884538;}i:35;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1756884675;}i:36;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1760349604;}i:37;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1760351333;}i:38;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1760351848;}i:39;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1760418395;}i:40;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1760428799;}i:41;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1760430319;}i:42;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1760430641;}i:43;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1764738063;}i:44;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1764738206;}i:45;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1764741603;}i:46;a:5:{s:3:\"url\";s:96:\"https://mianabpe.com/mianab-polymer-companys-presence-at-the-13th-ahvaz-agricultural-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1764741982;}i:47;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1764742714;}i:48;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1764747004;}i:49;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1764747245;}i:50;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1764752544;}i:51;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1764752647;}i:52;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1764752760;}i:53;a:5:{s:3:\"url\";s:85:\"https://mianabpe.com/mianab-polymers-participation-in-bushehr-specialized-exhibition/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1764752917;}}", "off");
INSERT INTO `wp_options` VALUES("23831", "new_admin_email", "mohammadrezabehdarvand@gmail.com", "auto");
INSERT INTO `wp_options` VALUES("28961", "as_has_wp_comment_logs", "no", "on");
INSERT INTO `wp_options` VALUES("29328", "duplicator_migration_data", "{\n    \"plugin\": \"dup-lite\",\n    \"installerVersion\": \"1.5.12\",\n    \"installType\": -1,\n    \"logicModes\": [\n        \"CLASSIC\"\n    ],\n    \"template\": \"default\",\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home\\/fekragam\\/domains\\/mianabpe.com\\/public_html\\/mianabpefinall_a8e2a0cd410ccfc63852_20250603172749_archive.zip\",\n    \"packageHash\": \"a8e2a0c-03172749\",\n    \"installerPath\": \"\\/home\\/fekragam\\/domains\\/mianabpe.com\\/public_html\\/installer.php\",\n    \"installerBootLog\": \"\\/home\\/fekragam\\/domains\\/mianabpe.com\\/public_html\\/dup-installer-bootlog__0db0c55-03172749.txt\",\n    \"installerLog\": \"\\/home\\/fekragam\\/domains\\/mianabpe.com\\/public_html\\/dup-installer\\/dup-installer-log__0db0c55-03172749.txt\",\n    \"dupInstallerPath\": \"\\/home\\/fekragam\\/domains\\/mianabpe.com\\/public_html\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home\\/fekragam\\/domains\\/mianabpe.com\\/public_html\\/dup-installer\\/original_files_a8e2a0c-03172749\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true,\n    \"licenseType\": 0,\n    \"phpVersion\": \"8.0.28\",\n    \"archiveType\": \"zip\",\n    \"siteSize\": 204893829,\n    \"siteNumFiles\": 20173,\n    \"siteDbSize\": 5198992,\n    \"siteDBNumTables\": 56,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"ustatIdentifier\": \"\",\n    \"time\": 1748972656\n}", "no");
INSERT INTO `wp_options` VALUES("29329", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("29336", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"5bee6bf6035680b037def116f1e1cdb1\";s:6:\"blocks\";a:6:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:18:\"core/term-template\";s:120:\":where(.wp-block-term-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-term-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("29339", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "on");
INSERT INTO `wp_options` VALUES("29915", "_transient_product_query-transient-version", "1766748026", "on");
INSERT INTO `wp_options` VALUES("29918", "_transient_shipping-transient-version", "1749275802", "on");
INSERT INTO `wp_options` VALUES("29966", "_transient_health-check-site-status-result", "{\"good\":16,\"recommended\":6,\"critical\":2}", "on");
INSERT INTO `wp_options` VALUES("30396", "_transient_rank_math_first_submenu_id", "rank-math", "on");
INSERT INTO `wp_options` VALUES("30398", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"IK4aBeFKAU77vvh8HWbneWmuvhhi=yC2RNX4WQHC=qVp\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 1,\n    \"buildLastDate\": 1752311050,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 391.69,\n    \"siteNumFiles\": 21772,\n    \"siteDbSizeMB\": 6.29,\n    \"siteDbNumTables\": 56\n}", "auto");
INSERT INTO `wp_options` VALUES("30414", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("30418", "_transient_woocommerce_reports-transient-version", "1749544823", "on");
INSERT INTO `wp_options` VALUES("30467", "_transient_woocommerce_product_task_product_count_transient", "20", "on");
INSERT INTO `wp_options` VALUES("30470", "_transient_woocommerce_shipping_task_zone_count_transient", "0", "on");
INSERT INTO `wp_options` VALUES("30526", "woocommerce_shipping_hide_rates_when_free", "no", "off");
INSERT INTO `wp_options` VALUES("30527", "woocommerce_anonymize_refunded_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("30528", "woocommerce_email_header_image_width", "120", "on");
INSERT INTO `wp_options` VALUES("30529", "woocommerce_email_header_alignment", "left", "on");
INSERT INTO `wp_options` VALUES("30530", "woocommerce_email_font_family", "Helvetica", "on");
INSERT INTO `wp_options` VALUES("30531", "woocommerce_email_auto_sync_with_theme", "no", "off");
INSERT INTO `wp_options` VALUES("30532", "woocommerce_feature_blueprint_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("30533", "woocommerce_hpos_datastore_caching_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("30534", "woocommerce_feature_block_email_editor_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("30543", "woocommerce_gateway_order", "a:6:{s:19:\"_wc_pes_woopayments\";i:0;s:25:\"_wc_pes_paypal_full_stack\";i:1;s:33:\"_wc_offline_payment_methods_group\";i:2;s:4:\"bacs\";i:3;s:6:\"cheque\";i:4;s:3:\"cod\";i:5;}", "auto");
INSERT INTO `wp_options` VALUES("30549", "_transient_timeout_woocommerce_analytics_orders_statuses_all", "1781085985", "off");
INSERT INTO `wp_options` VALUES("30550", "_transient_woocommerce_analytics_orders_statuses_all", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("30555", "woocommerce_feature_reactify-classic-payments-settings_enabled", "yes", "auto");
INSERT INTO `wp_options` VALUES("30598", "_transient_woocommerce_product_task_has_product_transient", "yes", "on");
INSERT INTO `wp_options` VALUES("32571", "duplicator_expire_search-replace-wpcode", "{\"expire\":1753520536,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.0\"}}", "on");
INSERT INTO `wp_options` VALUES("32572", "duplicator_expire_wp-mail-smtp", "{\"expire\":1753520538,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.4\"}}", "on");
INSERT INTO `wp_options` VALUES("32573", "duplicator_expire_insert-headers-and-footers", "{\"expire\":1753520539,\"value\":{\"wp_version\":\"4.6\",\"php_version\":\"5.5\"}}", "on");
INSERT INTO `wp_options` VALUES("40307", "_transient_timeout_woocommerce_blocks_asset_api_script_data_ssl", "1769340027", "off");
INSERT INTO `wp_options` VALUES("40308", "_transient_woocommerce_blocks_asset_api_script_data_ssl", "{\"script_data\":{\"assets\\/client\\/blocks\\/wc-settings.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-settings.js\",\"version\":\"508473c3c2ece9af8f8f\",\"dependencies\":[\"wc-types\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-types.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-types.js\",\"version\":\"de925be9bc9f555c810c\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-entities.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-entities.js\",\"version\":\"cdb01de69fb7dbbbb30f\",\"dependencies\":[\"wc-settings\",\"wp-core-data\",\"wp-data\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-middleware.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-middleware.js\",\"version\":\"d79dedade2f2e4dc9df4\",\"dependencies\":[\"wp-api-fetch\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-data.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-data.js\",\"version\":\"d62ecc40f192d0f05f05\",\"dependencies\":[\"wc-blocks-checkout-events\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-data\",\"wp-data-controls\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-vendors.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-vendors.js\",\"version\":\"a2c27bf10c2c51d247cf\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-registry.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-registry.js\",\"version\":\"a16aa912ffa0a15063f1\",\"dependencies\":[\"react-jsx-runtime\",\"wc-settings\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks.js\",\"version\":\"0db759a8a6e010732c50\",\"dependencies\":[\"react-jsx-runtime\",\"wp-blocks\",\"wp-compose\",\"wp-element\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-context.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-context.js\",\"version\":\"621353d8a3a7c8d44b41\",\"dependencies\":[\"react-jsx-runtime\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\",\"version\":\"c18bbb2325f333897e6b\",\"dependencies\":[\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-blocks-shared-context\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/price-format.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-format.js\",\"version\":\"0df720e448f7ab3c5d0d\",\"dependencies\":[\"wc-settings\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\",\"version\":\"00b931bcc27024fa60ca\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\",\"version\":\"d179e1f113881cf2f0a9\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\",\"version\":\"56daaae21456ba6fa364\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-checkout.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout.js\",\"version\":\"c71566edd56265d976c6\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-sanitize\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/blocks-checkout-events.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout-events.js\",\"version\":\"2d0fd4590f6cc663947c\",\"dependencies\":[\"wc-types\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-components.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-components.js\",\"version\":\"1cecc164412419d4282d\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-sanitize\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/wc-schema-parser.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-schema-parser.js\",\"version\":\"f762078aeb4207fe9c3d\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/admin\\/sanitize\\/index.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/admin\\/sanitize\\/index.js\",\"version\":\"c7a741f8dc5bec166999\",\"dependencies\":[]},\"assets\\/client\\/admin\\/customer-effort-score\\/index.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/admin\\/customer-effort-score\\/index.js\",\"version\":\"ebdc0b2d7487174621e6\",\"dependencies\":[\"react\",\"wc-experimental\",\"wc-navigation\",\"wc-store-data\",\"wc-tracks\",\"wp-api-fetch\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-data-controls\",\"wp-element\",\"wp-i18n\"]},\"assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\":{\"src\":\"https:\\/\\/mianabpe.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\",\"version\":\"0446a66f2604add5f739\",\"dependencies\":[\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]}},\"version\":\"wc-10.4.3\",\"hash\":\"a8964ba62a6d753950b5f0a3c3bcc052\"}", "off");
INSERT INTO `wp_options` VALUES("40773", "_transient_timeout_wc_blocks_query_ecbdfe3b605c7fd59f42fd50d2ff3359", "1768465063", "off");
INSERT INTO `wp_options` VALUES("40774", "_transient_wc_blocks_query_ecbdfe3b605c7fd59f42fd50d2ff3359", "a:2:{s:7:\"version\";s:10:\"1765435539\";s:5:\"value\";a:4:{i:0;i:360;i:1;i:435;i:2;i:441;i:3;i:443;}}", "off");
INSERT INTO `wp_options` VALUES("41887", "_site_transient_timeout_woocommerce_blocks_patterns", "1769339408", "off");
INSERT INTO `wp_options` VALUES("41888", "_site_transient_woocommerce_blocks_patterns", "a:2:{s:7:\"version\";s:6:\"10.4.3\";s:8:\"patterns\";a:41:{i:0;a:11:{s:5:\"title\";s:6:\"Banner\";s:4:\"slug\";s:25:\"woocommerce-blocks/banner\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:10:\"banner.php\";}i:1;a:11:{s:5:\"title\";s:23:\"Coming Soon Entire Site\";s:4:\"slug\";s:35:\"woocommerce/coming-soon-entire-site\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"coming-soon-entire-site.php\";}i:2;a:11:{s:5:\"title\";s:22:\"Coming Soon Store Only\";s:4:\"slug\";s:34:\"woocommerce/coming-soon-store-only\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"coming-soon-store-only.php\";}i:3;a:11:{s:5:\"title\";s:11:\"Coming Soon\";s:4:\"slug\";s:23:\"woocommerce/coming-soon\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:15:\"coming-soon.php\";}i:4;a:11:{s:5:\"title\";s:29:\"Content right with image left\";s:4:\"slug\";s:48:\"woocommerce-blocks/content-right-with-image-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:28:\"content-right-image-left.php\";}i:5;a:11:{s:5:\"title\";s:29:\"Featured Category Cover Image\";s:4:\"slug\";s:48:\"woocommerce-blocks/featured-category-cover-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:33:\"featured-category-cover-image.php\";}i:6;a:11:{s:5:\"title\";s:24:\"Featured Category Triple\";s:4:\"slug\";s:43:\"woocommerce-blocks/featured-category-triple\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:28:\"featured-category-triple.php\";}i:7;a:11:{s:5:\"title\";s:12:\"Large Footer\";s:4:\"slug\";s:31:\"woocommerce-blocks/footer-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:16:\"footer-large.php\";}i:8;a:11:{s:5:\"title\";s:23:\"Footer with Simple Menu\";s:4:\"slug\";s:37:\"woocommerce-blocks/footer-simple-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:22:\"footer-simple-menu.php\";}i:9;a:11:{s:5:\"title\";s:17:\"Footer with menus\";s:4:\"slug\";s:38:\"woocommerce-blocks/footer-with-3-menus\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"footer-with-3-menus.php\";}i:10;a:11:{s:5:\"title\";s:28:\"Four Image Grid Content Left\";s:4:\"slug\";s:47:\"woocommerce-blocks/form-image-grid-content-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"four-image-grid-content-left.php\";}i:11;a:11:{s:5:\"title\";s:20:\"Centered Header Menu\";s:4:\"slug\";s:39:\"woocommerce-blocks/header-centered-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"header-centered-pattern.php\";}i:12;a:11:{s:5:\"title\";s:23:\"Distraction Free Header\";s:4:\"slug\";s:42:\"woocommerce-blocks/header-distraction-free\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"header-distraction-free.php\";}i:13;a:11:{s:5:\"title\";s:16:\"Essential Header\";s:4:\"slug\";s:35:\"woocommerce-blocks/header-essential\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:20:\"header-essential.php\";}i:14;a:11:{s:5:\"title\";s:12:\"Large Header\";s:4:\"slug\";s:31:\"woocommerce-blocks/header-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:16:\"header-large.php\";}i:15;a:11:{s:5:\"title\";s:14:\"Minimal Header\";s:4:\"slug\";s:33:\"woocommerce-blocks/header-minimal\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:18:\"header-minimal.php\";}i:16;a:11:{s:5:\"title\";s:47:\"Heading with three columns of content with link\";s:4:\"slug\";s:66:\"woocommerce-blocks/heading-with-three-columns-of-content-with-link\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:51:\"heading-with-three-columns-of-content-with-link.php\";}i:17;a:11:{s:5:\"title\";s:20:\"Hero Product 3 Split\";s:4:\"slug\";s:39:\"woocommerce-blocks/hero-product-3-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:24:\"hero-product-3-split.php\";}i:18;a:11:{s:5:\"title\";s:23:\"Hero Product Chessboard\";s:4:\"slug\";s:42:\"woocommerce-blocks/hero-product-chessboard\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"hero-product-chessboard.php\";}i:19;a:11:{s:5:\"title\";s:18:\"Hero Product Split\";s:4:\"slug\";s:37:\"woocommerce-blocks/hero-product-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:22:\"hero-product-split.php\";}i:20;a:11:{s:5:\"title\";s:33:\"Centered content with image below\";s:4:\"slug\";s:52:\"woocommerce-blocks/centered-content-with-image-below\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:43:\"intro-centered-content-with-image-below.php\";}i:21;a:11:{s:5:\"title\";s:22:\"Just Arrived Full Hero\";s:4:\"slug\";s:41:\"woocommerce-blocks/just-arrived-full-hero\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"just-arrived-full-hero.php\";}i:22;a:11:{s:5:\"title\";s:33:\"No Products Found - Clear Filters\";s:4:\"slug\";s:43:\"woocommerce/no-products-found-clear-filters\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:29:\"no-products-found-filters.php\";}i:23;a:11:{s:5:\"title\";s:17:\"No Products Found\";s:4:\"slug\";s:29:\"woocommerce/no-products-found\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:21:\"no-products-found.php\";}i:24;a:11:{s:5:\"title\";s:19:\"Default Coming Soon\";s:4:\"slug\";s:36:\"woocommerce/page-coming-soon-default\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:28:\"page-coming-soon-default.php\";}i:25;a:11:{s:5:\"title\";s:25:\"Coming Soon Image Gallery\";s:4:\"slug\";s:42:\"woocommerce/page-coming-soon-image-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:34:\"page-coming-soon-image-gallery.php\";}i:26;a:11:{s:5:\"title\";s:30:\"Coming Soon Minimal Left Image\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-minimal-left-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:39:\"page-coming-soon-minimal-left-image.php\";}i:27;a:11:{s:5:\"title\";s:24:\"Coming Soon Modern Black\";s:4:\"slug\";s:41:\"woocommerce/page-coming-soon-modern-black\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:33:\"page-coming-soon-modern-black.php\";}i:28;a:11:{s:5:\"title\";s:29:\"Coming Soon Split Right Image\";s:4:\"slug\";s:46:\"woocommerce/page-coming-soon-split-right-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:38:\"page-coming-soon-split-right-image.php\";}i:29;a:11:{s:5:\"title\";s:34:\"Coming Soon With Header and Footer\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-with-header-footer\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:39:\"page-coming-soon-with-header-footer.php\";}i:30;a:11:{s:5:\"title\";s:28:\"Product Collection 3 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-3-columns.php\";}i:31;a:11:{s:5:\"title\";s:28:\"Product Collection 4 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-4-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-4-columns.php\";}i:32;a:11:{s:5:\"title\";s:28:\"Product Collection 5 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-5-columns.php\";}i:33;a:11:{s:5:\"title\";s:47:\"Product Collection: Featured Products 5 Columns\";s:4:\"slug\";s:65:\"woocommerce-blocks/product-collection-featured-products-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:50:\"product-collection-featured-products-5-columns.php\";}i:34;a:11:{s:5:\"title\";s:15:\"Product Gallery\";s:4:\"slug\";s:48:\"woocommerce-blocks/product-query-product-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:36:\"core/query/woocommerce/product-query\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:33:\"product-query-product-gallery.php\";}i:35;a:11:{s:5:\"title\";s:14:\"Product Search\";s:4:\"slug\";s:31:\"woocommerce/product-search-form\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"product-search-form.php\";}i:36;a:11:{s:5:\"title\";s:16:\"Related Products\";s:4:\"slug\";s:35:\"woocommerce-blocks/related-products\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:20:\"related-products.php\";}i:37;a:11:{s:5:\"title\";s:33:\"Social: Follow us on social media\";s:4:\"slug\";s:51:\"woocommerce-blocks/social-follow-us-in-social-media\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:25:\"WooCommerce, social-media\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:36:\"social-follow-us-in-social-media.php\";}i:38;a:11:{s:5:\"title\";s:22:\"Testimonials 3 Columns\";s:4:\"slug\";s:41:\"woocommerce-blocks/testimonials-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"testimonials-3-columns.php\";}i:39;a:11:{s:5:\"title\";s:19:\"Testimonials Single\";s:4:\"slug\";s:38:\"woocommerce-blocks/testimonials-single\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"testimonials-single.php\";}i:40;a:11:{s:5:\"title\";s:37:\"Three columns with images and content\";s:4:\"slug\";s:56:\"woocommerce-blocks/three-columns-with-images-and-content\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:41:\"three-columns-with-images-and-content.php\";}}}", "off");
INSERT INTO `wp_options` VALUES("41951", "product_cat_children", "a:2:{i:16;a:2:{i:0;i:23;i:1;i:24;}i:33;a:4:{i:0;i:26;i:1;i:27;i:2;i:28;i:3;i:30;}}", "auto");
INSERT INTO `wp_options` VALUES("41952", "_transient_product-transient-version", "1765435539", "on");
INSERT INTO `wp_options` VALUES("41953", "_transient_filter_data-transient-version", "1765435539", "on");
INSERT INTO `wp_options` VALUES("42248", "rank_math_notifications", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("42335", "_transient_timeout_wc_term_counts", "1768031753", "off");
INSERT INTO `wp_options` VALUES("42336", "_transient_wc_term_counts", "a:9:{s:14:\"23_product_cat\";i:5;s:14:\"16_product_cat\";i:19;s:14:\"33_product_cat\";i:3;s:14:\"30_product_cat\";i:3;s:14:\"35_product_tag\";i:1;s:14:\"27_product_cat\";i:0;s:14:\"26_product_cat\";i:0;s:14:\"28_product_cat\";i:0;s:14:\"24_product_cat\";i:14;}", "off");
INSERT INTO `wp_options` VALUES("42669", "_transient_timeout_wc_shipping_method_count", "1768465063", "off");
INSERT INTO `wp_options` VALUES("42670", "_transient_wc_shipping_method_count", "a:4:{s:7:\"version\";s:10:\"1749275802\";s:6:\"legacy\";i:0;s:7:\"enabled\";i:0;s:8:\"disabled\";i:0;}", "off");
INSERT INTO `wp_options` VALUES("43358", "_site_transient_timeout_fs_garbage_collection", "1766804008", "off");
INSERT INTO `wp_options` VALUES("43359", "_site_transient_fs_garbage_collection", "1", "off");
INSERT INTO `wp_options` VALUES("43390", "_transient_timeout_woocommerce_admin_pes_incentive_woopayments_store_has_orders", "1766768268", "off");
INSERT INTO `wp_options` VALUES("43391", "_transient_woocommerce_admin_pes_incentive_woopayments_store_has_orders", "no", "off");
INSERT INTO `wp_options` VALUES("43392", "_transient_timeout_woocommerce_admin_pes_incentive_woopayments_cache", "1766833069", "off");
INSERT INTO `wp_options` VALUES("43393", "_transient_woocommerce_admin_pes_incentive_woopayments_cache", "a:3:{s:10:\"incentives\";a:0:{}s:12:\"context_hash\";s:32:\"ebf1de498803f569b23b36078b721d21\";s:9:\"timestamp\";i:1766746669;}", "off");
INSERT INTO `wp_options` VALUES("43394", "_transient_timeout_woocommerce_admin_settings_payments_has_providers_with_incentive", "1766750269", "off");
INSERT INTO `wp_options` VALUES("43395", "_transient_woocommerce_admin_settings_payments_has_providers_with_incentive", "no", "off");
INSERT INTO `wp_options` VALUES("43398", "_site_transient_timeout_theme_roots", "1766748470", "off");
INSERT INTO `wp_options` VALUES("43399", "_site_transient_theme_roots", "a:1:{s:22:\"mohammadrezabehdarvand\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("43400", "_site_transient_timeout_browser_3c9fc7ddec9b58823c1c96756dbd45d8", "1767351471", "off");
INSERT INTO `wp_options` VALUES("43401", "_site_transient_browser_3c9fc7ddec9b58823c1c96756dbd45d8", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"142.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("43402", "_site_transient_timeout_php_check_f5e5d07428dc8d0f307641bd39321a48", "1767351472", "off");
INSERT INTO `wp_options` VALUES("43403", "_site_transient_php_check_f5e5d07428dc8d0f307641bd39321a48", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("43404", "_transient_timeout_wc_tracks_blog_details", "1766833072", "off");
INSERT INTO `wp_options` VALUES("43405", "_transient_wc_tracks_blog_details", "a:6:{s:3:\"url\";s:20:\"https://mianabpe.com\";s:9:\"blog_lang\";s:5:\"fa_IR\";s:7:\"blog_id\";b:0;s:8:\"store_id\";s:36:\"b9e0b206-6516-4533-8feb-ed0a3dffd5de\";s:14:\"products_count\";s:2:\"22\";s:10:\"wc_version\";s:5:\"9.9.3\";}", "off");
INSERT INTO `wp_options` VALUES("43406", "_site_transient_timeout_community-events-343b8072d4c82597810ddbbaa87289f8", "1766789877", "off");
INSERT INTO `wp_options` VALUES("43407", "_site_transient_community-events-343b8072d4c82597810ddbbaa87289f8", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"89.198.126.0\";}s:6:\"events\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("43408", "_transient_timeout_rank_math_feed_posts_v2", "1766789878", "off");
INSERT INTO `wp_options` VALUES("43409", "_transient_rank_math_feed_posts_v2", "a:4:{i:0;a:5:{s:5:\"title\";a:1:{s:8:\"rendered\";s:51:\"Content AI 2.0: Introducing AI SEO Inside WordPress\";}s:4:\"date\";s:19:\"2025-12-26 09:34:53\";s:4:\"link\";s:62:\"https://rankmath.com/blog/introducing-supercharged-content-ai/\";s:12:\"custom_label\";s:0:\"\";s:9:\"condition\";s:0:\"\";}i:1;a:3:{s:5:\"title\";a:1:{s:8:\"rendered\";s:46:\"Pinterest SEO: Grow Your Business on Pinterest\";}s:4:\"date\";s:19:\"2025-12-24 16:44:07\";s:4:\"link\";s:40:\"https://rankmath.com/blog/pinterest-seo/\";}i:2;a:3:{s:5:\"title\";a:1:{s:8:\"rendered\";s:68:\"SEO Statistics in 2026: What the Latest Data Means for Your Strategy\";}s:4:\"date\";s:19:\"2025-12-23 14:42:24\";s:4:\"link\";s:41:\"https://rankmath.com/blog/seo-statistics/\";}i:3;a:3:{s:5:\"title\";a:1:{s:8:\"rendered\";s:64:\"24 Best Small Business Marketing Tools You Actually Need in 2026\";}s:4:\"date\";s:19:\"2025-12-19 13:21:56\";s:4:\"link\";s:62:\"https://rankmath.com/blog/best-small-business-marketing-tools/\";}}", "off");
INSERT INTO `wp_options` VALUES("43411", "wp_notes_notify", "1", "on");
INSERT INTO `wp_options` VALUES("43412", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("43419", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:3:\"6.9\";s:5:\"files\";a:584:{i:0;s:31:\"accordion-heading/style-rtl.css\";i:1;s:35:\"accordion-heading/style-rtl.min.css\";i:2;s:27:\"accordion-heading/style.css\";i:3;s:31:\"accordion-heading/style.min.css\";i:4;s:28:\"accordion-item/style-rtl.css\";i:5;s:32:\"accordion-item/style-rtl.min.css\";i:6;s:24:\"accordion-item/style.css\";i:7;s:28:\"accordion-item/style.min.css\";i:8;s:29:\"accordion-panel/style-rtl.css\";i:9;s:33:\"accordion-panel/style-rtl.min.css\";i:10;s:25:\"accordion-panel/style.css\";i:11;s:29:\"accordion-panel/style.min.css\";i:12;s:23:\"accordion/style-rtl.css\";i:13;s:27:\"accordion/style-rtl.min.css\";i:14;s:19:\"accordion/style.css\";i:15;s:23:\"accordion/style.min.css\";i:16;s:23:\"archives/editor-rtl.css\";i:17;s:27:\"archives/editor-rtl.min.css\";i:18;s:19:\"archives/editor.css\";i:19;s:23:\"archives/editor.min.css\";i:20;s:22:\"archives/style-rtl.css\";i:21;s:26:\"archives/style-rtl.min.css\";i:22;s:18:\"archives/style.css\";i:23;s:22:\"archives/style.min.css\";i:24;s:20:\"audio/editor-rtl.css\";i:25;s:24:\"audio/editor-rtl.min.css\";i:26;s:16:\"audio/editor.css\";i:27;s:20:\"audio/editor.min.css\";i:28;s:19:\"audio/style-rtl.css\";i:29;s:23:\"audio/style-rtl.min.css\";i:30;s:15:\"audio/style.css\";i:31;s:19:\"audio/style.min.css\";i:32;s:19:\"audio/theme-rtl.css\";i:33;s:23:\"audio/theme-rtl.min.css\";i:34;s:15:\"audio/theme.css\";i:35;s:19:\"audio/theme.min.css\";i:36;s:21:\"avatar/editor-rtl.css\";i:37;s:25:\"avatar/editor-rtl.min.css\";i:38;s:17:\"avatar/editor.css\";i:39;s:21:\"avatar/editor.min.css\";i:40;s:20:\"avatar/style-rtl.css\";i:41;s:24:\"avatar/style-rtl.min.css\";i:42;s:16:\"avatar/style.css\";i:43;s:20:\"avatar/style.min.css\";i:44;s:21:\"button/editor-rtl.css\";i:45;s:25:\"button/editor-rtl.min.css\";i:46;s:17:\"button/editor.css\";i:47;s:21:\"button/editor.min.css\";i:48;s:20:\"button/style-rtl.css\";i:49;s:24:\"button/style-rtl.min.css\";i:50;s:16:\"button/style.css\";i:51;s:20:\"button/style.min.css\";i:52;s:22:\"buttons/editor-rtl.css\";i:53;s:26:\"buttons/editor-rtl.min.css\";i:54;s:18:\"buttons/editor.css\";i:55;s:22:\"buttons/editor.min.css\";i:56;s:21:\"buttons/style-rtl.css\";i:57;s:25:\"buttons/style-rtl.min.css\";i:58;s:17:\"buttons/style.css\";i:59;s:21:\"buttons/style.min.css\";i:60;s:22:\"calendar/style-rtl.css\";i:61;s:26:\"calendar/style-rtl.min.css\";i:62;s:18:\"calendar/style.css\";i:63;s:22:\"calendar/style.min.css\";i:64;s:25:\"categories/editor-rtl.css\";i:65;s:29:\"categories/editor-rtl.min.css\";i:66;s:21:\"categories/editor.css\";i:67;s:25:\"categories/editor.min.css\";i:68;s:24:\"categories/style-rtl.css\";i:69;s:28:\"categories/style-rtl.min.css\";i:70;s:20:\"categories/style.css\";i:71;s:24:\"categories/style.min.css\";i:72;s:19:\"code/editor-rtl.css\";i:73;s:23:\"code/editor-rtl.min.css\";i:74;s:15:\"code/editor.css\";i:75;s:19:\"code/editor.min.css\";i:76;s:18:\"code/style-rtl.css\";i:77;s:22:\"code/style-rtl.min.css\";i:78;s:14:\"code/style.css\";i:79;s:18:\"code/style.min.css\";i:80;s:18:\"code/theme-rtl.css\";i:81;s:22:\"code/theme-rtl.min.css\";i:82;s:14:\"code/theme.css\";i:83;s:18:\"code/theme.min.css\";i:84;s:22:\"columns/editor-rtl.css\";i:85;s:26:\"columns/editor-rtl.min.css\";i:86;s:18:\"columns/editor.css\";i:87;s:22:\"columns/editor.min.css\";i:88;s:21:\"columns/style-rtl.css\";i:89;s:25:\"columns/style-rtl.min.css\";i:90;s:17:\"columns/style.css\";i:91;s:21:\"columns/style.min.css\";i:92;s:33:\"comment-author-name/style-rtl.css\";i:93;s:37:\"comment-author-name/style-rtl.min.css\";i:94;s:29:\"comment-author-name/style.css\";i:95;s:33:\"comment-author-name/style.min.css\";i:96;s:29:\"comment-content/style-rtl.css\";i:97;s:33:\"comment-content/style-rtl.min.css\";i:98;s:25:\"comment-content/style.css\";i:99;s:29:\"comment-content/style.min.css\";i:100;s:26:\"comment-date/style-rtl.css\";i:101;s:30:\"comment-date/style-rtl.min.css\";i:102;s:22:\"comment-date/style.css\";i:103;s:26:\"comment-date/style.min.css\";i:104;s:31:\"comment-edit-link/style-rtl.css\";i:105;s:35:\"comment-edit-link/style-rtl.min.css\";i:106;s:27:\"comment-edit-link/style.css\";i:107;s:31:\"comment-edit-link/style.min.css\";i:108;s:32:\"comment-reply-link/style-rtl.css\";i:109;s:36:\"comment-reply-link/style-rtl.min.css\";i:110;s:28:\"comment-reply-link/style.css\";i:111;s:32:\"comment-reply-link/style.min.css\";i:112;s:30:\"comment-template/style-rtl.css\";i:113;s:34:\"comment-template/style-rtl.min.css\";i:114;s:26:\"comment-template/style.css\";i:115;s:30:\"comment-template/style.min.css\";i:116;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:117;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:118;s:38:\"comments-pagination-numbers/editor.css\";i:119;s:42:\"comments-pagination-numbers/editor.min.css\";i:120;s:34:\"comments-pagination/editor-rtl.css\";i:121;s:38:\"comments-pagination/editor-rtl.min.css\";i:122;s:30:\"comments-pagination/editor.css\";i:123;s:34:\"comments-pagination/editor.min.css\";i:124;s:33:\"comments-pagination/style-rtl.css\";i:125;s:37:\"comments-pagination/style-rtl.min.css\";i:126;s:29:\"comments-pagination/style.css\";i:127;s:33:\"comments-pagination/style.min.css\";i:128;s:29:\"comments-title/editor-rtl.css\";i:129;s:33:\"comments-title/editor-rtl.min.css\";i:130;s:25:\"comments-title/editor.css\";i:131;s:29:\"comments-title/editor.min.css\";i:132;s:23:\"comments/editor-rtl.css\";i:133;s:27:\"comments/editor-rtl.min.css\";i:134;s:19:\"comments/editor.css\";i:135;s:23:\"comments/editor.min.css\";i:136;s:22:\"comments/style-rtl.css\";i:137;s:26:\"comments/style-rtl.min.css\";i:138;s:18:\"comments/style.css\";i:139;s:22:\"comments/style.min.css\";i:140;s:20:\"cover/editor-rtl.css\";i:141;s:24:\"cover/editor-rtl.min.css\";i:142;s:16:\"cover/editor.css\";i:143;s:20:\"cover/editor.min.css\";i:144;s:19:\"cover/style-rtl.css\";i:145;s:23:\"cover/style-rtl.min.css\";i:146;s:15:\"cover/style.css\";i:147;s:19:\"cover/style.min.css\";i:148;s:22:\"details/editor-rtl.css\";i:149;s:26:\"details/editor-rtl.min.css\";i:150;s:18:\"details/editor.css\";i:151;s:22:\"details/editor.min.css\";i:152;s:21:\"details/style-rtl.css\";i:153;s:25:\"details/style-rtl.min.css\";i:154;s:17:\"details/style.css\";i:155;s:21:\"details/style.min.css\";i:156;s:20:\"embed/editor-rtl.css\";i:157;s:24:\"embed/editor-rtl.min.css\";i:158;s:16:\"embed/editor.css\";i:159;s:20:\"embed/editor.min.css\";i:160;s:19:\"embed/style-rtl.css\";i:161;s:23:\"embed/style-rtl.min.css\";i:162;s:15:\"embed/style.css\";i:163;s:19:\"embed/style.min.css\";i:164;s:19:\"embed/theme-rtl.css\";i:165;s:23:\"embed/theme-rtl.min.css\";i:166;s:15:\"embed/theme.css\";i:167;s:19:\"embed/theme.min.css\";i:168;s:19:\"file/editor-rtl.css\";i:169;s:23:\"file/editor-rtl.min.css\";i:170;s:15:\"file/editor.css\";i:171;s:19:\"file/editor.min.css\";i:172;s:18:\"file/style-rtl.css\";i:173;s:22:\"file/style-rtl.min.css\";i:174;s:14:\"file/style.css\";i:175;s:18:\"file/style.min.css\";i:176;s:23:\"footnotes/style-rtl.css\";i:177;s:27:\"footnotes/style-rtl.min.css\";i:178;s:19:\"footnotes/style.css\";i:179;s:23:\"footnotes/style.min.css\";i:180;s:23:\"freeform/editor-rtl.css\";i:181;s:27:\"freeform/editor-rtl.min.css\";i:182;s:19:\"freeform/editor.css\";i:183;s:23:\"freeform/editor.min.css\";i:184;s:22:\"gallery/editor-rtl.css\";i:185;s:26:\"gallery/editor-rtl.min.css\";i:186;s:18:\"gallery/editor.css\";i:187;s:22:\"gallery/editor.min.css\";i:188;s:21:\"gallery/style-rtl.css\";i:189;s:25:\"gallery/style-rtl.min.css\";i:190;s:17:\"gallery/style.css\";i:191;s:21:\"gallery/style.min.css\";i:192;s:21:\"gallery/theme-rtl.css\";i:193;s:25:\"gallery/theme-rtl.min.css\";i:194;s:17:\"gallery/theme.css\";i:195;s:21:\"gallery/theme.min.css\";i:196;s:20:\"group/editor-rtl.css\";i:197;s:24:\"group/editor-rtl.min.css\";i:198;s:16:\"group/editor.css\";i:199;s:20:\"group/editor.min.css\";i:200;s:19:\"group/style-rtl.css\";i:201;s:23:\"group/style-rtl.min.css\";i:202;s:15:\"group/style.css\";i:203;s:19:\"group/style.min.css\";i:204;s:19:\"group/theme-rtl.css\";i:205;s:23:\"group/theme-rtl.min.css\";i:206;s:15:\"group/theme.css\";i:207;s:19:\"group/theme.min.css\";i:208;s:21:\"heading/style-rtl.css\";i:209;s:25:\"heading/style-rtl.min.css\";i:210;s:17:\"heading/style.css\";i:211;s:21:\"heading/style.min.css\";i:212;s:19:\"html/editor-rtl.css\";i:213;s:23:\"html/editor-rtl.min.css\";i:214;s:15:\"html/editor.css\";i:215;s:19:\"html/editor.min.css\";i:216;s:20:\"image/editor-rtl.css\";i:217;s:24:\"image/editor-rtl.min.css\";i:218;s:16:\"image/editor.css\";i:219;s:20:\"image/editor.min.css\";i:220;s:19:\"image/style-rtl.css\";i:221;s:23:\"image/style-rtl.min.css\";i:222;s:15:\"image/style.css\";i:223;s:19:\"image/style.min.css\";i:224;s:19:\"image/theme-rtl.css\";i:225;s:23:\"image/theme-rtl.min.css\";i:226;s:15:\"image/theme.css\";i:227;s:19:\"image/theme.min.css\";i:228;s:29:\"latest-comments/style-rtl.css\";i:229;s:33:\"latest-comments/style-rtl.min.css\";i:230;s:25:\"latest-comments/style.css\";i:231;s:29:\"latest-comments/style.min.css\";i:232;s:27:\"latest-posts/editor-rtl.css\";i:233;s:31:\"latest-posts/editor-rtl.min.css\";i:234;s:23:\"latest-posts/editor.css\";i:235;s:27:\"latest-posts/editor.min.css\";i:236;s:26:\"latest-posts/style-rtl.css\";i:237;s:30:\"latest-posts/style-rtl.min.css\";i:238;s:22:\"latest-posts/style.css\";i:239;s:26:\"latest-posts/style.min.css\";i:240;s:18:\"list/style-rtl.css\";i:241;s:22:\"list/style-rtl.min.css\";i:242;s:14:\"list/style.css\";i:243;s:18:\"list/style.min.css\";i:244;s:22:\"loginout/style-rtl.css\";i:245;s:26:\"loginout/style-rtl.min.css\";i:246;s:18:\"loginout/style.css\";i:247;s:22:\"loginout/style.min.css\";i:248;s:19:\"math/editor-rtl.css\";i:249;s:23:\"math/editor-rtl.min.css\";i:250;s:15:\"math/editor.css\";i:251;s:19:\"math/editor.min.css\";i:252;s:18:\"math/style-rtl.css\";i:253;s:22:\"math/style-rtl.min.css\";i:254;s:14:\"math/style.css\";i:255;s:18:\"math/style.min.css\";i:256;s:25:\"media-text/editor-rtl.css\";i:257;s:29:\"media-text/editor-rtl.min.css\";i:258;s:21:\"media-text/editor.css\";i:259;s:25:\"media-text/editor.min.css\";i:260;s:24:\"media-text/style-rtl.css\";i:261;s:28:\"media-text/style-rtl.min.css\";i:262;s:20:\"media-text/style.css\";i:263;s:24:\"media-text/style.min.css\";i:264;s:19:\"more/editor-rtl.css\";i:265;s:23:\"more/editor-rtl.min.css\";i:266;s:15:\"more/editor.css\";i:267;s:19:\"more/editor.min.css\";i:268;s:30:\"navigation-link/editor-rtl.css\";i:269;s:34:\"navigation-link/editor-rtl.min.css\";i:270;s:26:\"navigation-link/editor.css\";i:271;s:30:\"navigation-link/editor.min.css\";i:272;s:29:\"navigation-link/style-rtl.css\";i:273;s:33:\"navigation-link/style-rtl.min.css\";i:274;s:25:\"navigation-link/style.css\";i:275;s:29:\"navigation-link/style.min.css\";i:276;s:33:\"navigation-submenu/editor-rtl.css\";i:277;s:37:\"navigation-submenu/editor-rtl.min.css\";i:278;s:29:\"navigation-submenu/editor.css\";i:279;s:33:\"navigation-submenu/editor.min.css\";i:280;s:25:\"navigation/editor-rtl.css\";i:281;s:29:\"navigation/editor-rtl.min.css\";i:282;s:21:\"navigation/editor.css\";i:283;s:25:\"navigation/editor.min.css\";i:284;s:24:\"navigation/style-rtl.css\";i:285;s:28:\"navigation/style-rtl.min.css\";i:286;s:20:\"navigation/style.css\";i:287;s:24:\"navigation/style.min.css\";i:288;s:23:\"nextpage/editor-rtl.css\";i:289;s:27:\"nextpage/editor-rtl.min.css\";i:290;s:19:\"nextpage/editor.css\";i:291;s:23:\"nextpage/editor.min.css\";i:292;s:24:\"page-list/editor-rtl.css\";i:293;s:28:\"page-list/editor-rtl.min.css\";i:294;s:20:\"page-list/editor.css\";i:295;s:24:\"page-list/editor.min.css\";i:296;s:23:\"page-list/style-rtl.css\";i:297;s:27:\"page-list/style-rtl.min.css\";i:298;s:19:\"page-list/style.css\";i:299;s:23:\"page-list/style.min.css\";i:300;s:24:\"paragraph/editor-rtl.css\";i:301;s:28:\"paragraph/editor-rtl.min.css\";i:302;s:20:\"paragraph/editor.css\";i:303;s:24:\"paragraph/editor.min.css\";i:304;s:23:\"paragraph/style-rtl.css\";i:305;s:27:\"paragraph/style-rtl.min.css\";i:306;s:19:\"paragraph/style.css\";i:307;s:23:\"paragraph/style.min.css\";i:308;s:35:\"post-author-biography/style-rtl.css\";i:309;s:39:\"post-author-biography/style-rtl.min.css\";i:310;s:31:\"post-author-biography/style.css\";i:311;s:35:\"post-author-biography/style.min.css\";i:312;s:30:\"post-author-name/style-rtl.css\";i:313;s:34:\"post-author-name/style-rtl.min.css\";i:314;s:26:\"post-author-name/style.css\";i:315;s:30:\"post-author-name/style.min.css\";i:316;s:25:\"post-author/style-rtl.css\";i:317;s:29:\"post-author/style-rtl.min.css\";i:318;s:21:\"post-author/style.css\";i:319;s:25:\"post-author/style.min.css\";i:320;s:33:\"post-comments-count/style-rtl.css\";i:321;s:37:\"post-comments-count/style-rtl.min.css\";i:322;s:29:\"post-comments-count/style.css\";i:323;s:33:\"post-comments-count/style.min.css\";i:324;s:33:\"post-comments-form/editor-rtl.css\";i:325;s:37:\"post-comments-form/editor-rtl.min.css\";i:326;s:29:\"post-comments-form/editor.css\";i:327;s:33:\"post-comments-form/editor.min.css\";i:328;s:32:\"post-comments-form/style-rtl.css\";i:329;s:36:\"post-comments-form/style-rtl.min.css\";i:330;s:28:\"post-comments-form/style.css\";i:331;s:32:\"post-comments-form/style.min.css\";i:332;s:32:\"post-comments-link/style-rtl.css\";i:333;s:36:\"post-comments-link/style-rtl.min.css\";i:334;s:28:\"post-comments-link/style.css\";i:335;s:32:\"post-comments-link/style.min.css\";i:336;s:26:\"post-content/style-rtl.css\";i:337;s:30:\"post-content/style-rtl.min.css\";i:338;s:22:\"post-content/style.css\";i:339;s:26:\"post-content/style.min.css\";i:340;s:23:\"post-date/style-rtl.css\";i:341;s:27:\"post-date/style-rtl.min.css\";i:342;s:19:\"post-date/style.css\";i:343;s:23:\"post-date/style.min.css\";i:344;s:27:\"post-excerpt/editor-rtl.css\";i:345;s:31:\"post-excerpt/editor-rtl.min.css\";i:346;s:23:\"post-excerpt/editor.css\";i:347;s:27:\"post-excerpt/editor.min.css\";i:348;s:26:\"post-excerpt/style-rtl.css\";i:349;s:30:\"post-excerpt/style-rtl.min.css\";i:350;s:22:\"post-excerpt/style.css\";i:351;s:26:\"post-excerpt/style.min.css\";i:352;s:34:\"post-featured-image/editor-rtl.css\";i:353;s:38:\"post-featured-image/editor-rtl.min.css\";i:354;s:30:\"post-featured-image/editor.css\";i:355;s:34:\"post-featured-image/editor.min.css\";i:356;s:33:\"post-featured-image/style-rtl.css\";i:357;s:37:\"post-featured-image/style-rtl.min.css\";i:358;s:29:\"post-featured-image/style.css\";i:359;s:33:\"post-featured-image/style.min.css\";i:360;s:34:\"post-navigation-link/style-rtl.css\";i:361;s:38:\"post-navigation-link/style-rtl.min.css\";i:362;s:30:\"post-navigation-link/style.css\";i:363;s:34:\"post-navigation-link/style.min.css\";i:364;s:27:\"post-template/style-rtl.css\";i:365;s:31:\"post-template/style-rtl.min.css\";i:366;s:23:\"post-template/style.css\";i:367;s:27:\"post-template/style.min.css\";i:368;s:24:\"post-terms/style-rtl.css\";i:369;s:28:\"post-terms/style-rtl.min.css\";i:370;s:20:\"post-terms/style.css\";i:371;s:24:\"post-terms/style.min.css\";i:372;s:31:\"post-time-to-read/style-rtl.css\";i:373;s:35:\"post-time-to-read/style-rtl.min.css\";i:374;s:27:\"post-time-to-read/style.css\";i:375;s:31:\"post-time-to-read/style.min.css\";i:376;s:24:\"post-title/style-rtl.css\";i:377;s:28:\"post-title/style-rtl.min.css\";i:378;s:20:\"post-title/style.css\";i:379;s:24:\"post-title/style.min.css\";i:380;s:26:\"preformatted/style-rtl.css\";i:381;s:30:\"preformatted/style-rtl.min.css\";i:382;s:22:\"preformatted/style.css\";i:383;s:26:\"preformatted/style.min.css\";i:384;s:24:\"pullquote/editor-rtl.css\";i:385;s:28:\"pullquote/editor-rtl.min.css\";i:386;s:20:\"pullquote/editor.css\";i:387;s:24:\"pullquote/editor.min.css\";i:388;s:23:\"pullquote/style-rtl.css\";i:389;s:27:\"pullquote/style-rtl.min.css\";i:390;s:19:\"pullquote/style.css\";i:391;s:23:\"pullquote/style.min.css\";i:392;s:23:\"pullquote/theme-rtl.css\";i:393;s:27:\"pullquote/theme-rtl.min.css\";i:394;s:19:\"pullquote/theme.css\";i:395;s:23:\"pullquote/theme.min.css\";i:396;s:39:\"query-pagination-numbers/editor-rtl.css\";i:397;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:398;s:35:\"query-pagination-numbers/editor.css\";i:399;s:39:\"query-pagination-numbers/editor.min.css\";i:400;s:31:\"query-pagination/editor-rtl.css\";i:401;s:35:\"query-pagination/editor-rtl.min.css\";i:402;s:27:\"query-pagination/editor.css\";i:403;s:31:\"query-pagination/editor.min.css\";i:404;s:30:\"query-pagination/style-rtl.css\";i:405;s:34:\"query-pagination/style-rtl.min.css\";i:406;s:26:\"query-pagination/style.css\";i:407;s:30:\"query-pagination/style.min.css\";i:408;s:25:\"query-title/style-rtl.css\";i:409;s:29:\"query-title/style-rtl.min.css\";i:410;s:21:\"query-title/style.css\";i:411;s:25:\"query-title/style.min.css\";i:412;s:25:\"query-total/style-rtl.css\";i:413;s:29:\"query-total/style-rtl.min.css\";i:414;s:21:\"query-total/style.css\";i:415;s:25:\"query-total/style.min.css\";i:416;s:20:\"query/editor-rtl.css\";i:417;s:24:\"query/editor-rtl.min.css\";i:418;s:16:\"query/editor.css\";i:419;s:20:\"query/editor.min.css\";i:420;s:19:\"quote/style-rtl.css\";i:421;s:23:\"quote/style-rtl.min.css\";i:422;s:15:\"quote/style.css\";i:423;s:19:\"quote/style.min.css\";i:424;s:19:\"quote/theme-rtl.css\";i:425;s:23:\"quote/theme-rtl.min.css\";i:426;s:15:\"quote/theme.css\";i:427;s:19:\"quote/theme.min.css\";i:428;s:23:\"read-more/style-rtl.css\";i:429;s:27:\"read-more/style-rtl.min.css\";i:430;s:19:\"read-more/style.css\";i:431;s:23:\"read-more/style.min.css\";i:432;s:18:\"rss/editor-rtl.css\";i:433;s:22:\"rss/editor-rtl.min.css\";i:434;s:14:\"rss/editor.css\";i:435;s:18:\"rss/editor.min.css\";i:436;s:17:\"rss/style-rtl.css\";i:437;s:21:\"rss/style-rtl.min.css\";i:438;s:13:\"rss/style.css\";i:439;s:17:\"rss/style.min.css\";i:440;s:21:\"search/editor-rtl.css\";i:441;s:25:\"search/editor-rtl.min.css\";i:442;s:17:\"search/editor.css\";i:443;s:21:\"search/editor.min.css\";i:444;s:20:\"search/style-rtl.css\";i:445;s:24:\"search/style-rtl.min.css\";i:446;s:16:\"search/style.css\";i:447;s:20:\"search/style.min.css\";i:448;s:20:\"search/theme-rtl.css\";i:449;s:24:\"search/theme-rtl.min.css\";i:450;s:16:\"search/theme.css\";i:451;s:20:\"search/theme.min.css\";i:452;s:24:\"separator/editor-rtl.css\";i:453;s:28:\"separator/editor-rtl.min.css\";i:454;s:20:\"separator/editor.css\";i:455;s:24:\"separator/editor.min.css\";i:456;s:23:\"separator/style-rtl.css\";i:457;s:27:\"separator/style-rtl.min.css\";i:458;s:19:\"separator/style.css\";i:459;s:23:\"separator/style.min.css\";i:460;s:23:\"separator/theme-rtl.css\";i:461;s:27:\"separator/theme-rtl.min.css\";i:462;s:19:\"separator/theme.css\";i:463;s:23:\"separator/theme.min.css\";i:464;s:24:\"shortcode/editor-rtl.css\";i:465;s:28:\"shortcode/editor-rtl.min.css\";i:466;s:20:\"shortcode/editor.css\";i:467;s:24:\"shortcode/editor.min.css\";i:468;s:24:\"site-logo/editor-rtl.css\";i:469;s:28:\"site-logo/editor-rtl.min.css\";i:470;s:20:\"site-logo/editor.css\";i:471;s:24:\"site-logo/editor.min.css\";i:472;s:23:\"site-logo/style-rtl.css\";i:473;s:27:\"site-logo/style-rtl.min.css\";i:474;s:19:\"site-logo/style.css\";i:475;s:23:\"site-logo/style.min.css\";i:476;s:27:\"site-tagline/editor-rtl.css\";i:477;s:31:\"site-tagline/editor-rtl.min.css\";i:478;s:23:\"site-tagline/editor.css\";i:479;s:27:\"site-tagline/editor.min.css\";i:480;s:26:\"site-tagline/style-rtl.css\";i:481;s:30:\"site-tagline/style-rtl.min.css\";i:482;s:22:\"site-tagline/style.css\";i:483;s:26:\"site-tagline/style.min.css\";i:484;s:25:\"site-title/editor-rtl.css\";i:485;s:29:\"site-title/editor-rtl.min.css\";i:486;s:21:\"site-title/editor.css\";i:487;s:25:\"site-title/editor.min.css\";i:488;s:24:\"site-title/style-rtl.css\";i:489;s:28:\"site-title/style-rtl.min.css\";i:490;s:20:\"site-title/style.css\";i:491;s:24:\"site-title/style.min.css\";i:492;s:26:\"social-link/editor-rtl.css\";i:493;s:30:\"social-link/editor-rtl.min.css\";i:494;s:22:\"social-link/editor.css\";i:495;s:26:\"social-link/editor.min.css\";i:496;s:27:\"social-links/editor-rtl.css\";i:497;s:31:\"social-links/editor-rtl.min.css\";i:498;s:23:\"social-links/editor.css\";i:499;s:27:\"social-links/editor.min.css\";i:500;s:26:\"social-links/style-rtl.css\";i:501;s:30:\"social-links/style-rtl.min.css\";i:502;s:22:\"social-links/style.css\";i:503;s:26:\"social-links/style.min.css\";i:504;s:21:\"spacer/editor-rtl.css\";i:505;s:25:\"spacer/editor-rtl.min.css\";i:506;s:17:\"spacer/editor.css\";i:507;s:21:\"spacer/editor.min.css\";i:508;s:20:\"spacer/style-rtl.css\";i:509;s:24:\"spacer/style-rtl.min.css\";i:510;s:16:\"spacer/style.css\";i:511;s:20:\"spacer/style.min.css\";i:512;s:20:\"table/editor-rtl.css\";i:513;s:24:\"table/editor-rtl.min.css\";i:514;s:16:\"table/editor.css\";i:515;s:20:\"table/editor.min.css\";i:516;s:19:\"table/style-rtl.css\";i:517;s:23:\"table/style-rtl.min.css\";i:518;s:15:\"table/style.css\";i:519;s:19:\"table/style.min.css\";i:520;s:19:\"table/theme-rtl.css\";i:521;s:23:\"table/theme-rtl.min.css\";i:522;s:15:\"table/theme.css\";i:523;s:19:\"table/theme.min.css\";i:524;s:24:\"tag-cloud/editor-rtl.css\";i:525;s:28:\"tag-cloud/editor-rtl.min.css\";i:526;s:20:\"tag-cloud/editor.css\";i:527;s:24:\"tag-cloud/editor.min.css\";i:528;s:23:\"tag-cloud/style-rtl.css\";i:529;s:27:\"tag-cloud/style-rtl.min.css\";i:530;s:19:\"tag-cloud/style.css\";i:531;s:23:\"tag-cloud/style.min.css\";i:532;s:28:\"template-part/editor-rtl.css\";i:533;s:32:\"template-part/editor-rtl.min.css\";i:534;s:24:\"template-part/editor.css\";i:535;s:28:\"template-part/editor.min.css\";i:536;s:27:\"template-part/theme-rtl.css\";i:537;s:31:\"template-part/theme-rtl.min.css\";i:538;s:23:\"template-part/theme.css\";i:539;s:27:\"template-part/theme.min.css\";i:540;s:24:\"term-count/style-rtl.css\";i:541;s:28:\"term-count/style-rtl.min.css\";i:542;s:20:\"term-count/style.css\";i:543;s:24:\"term-count/style.min.css\";i:544;s:30:\"term-description/style-rtl.css\";i:545;s:34:\"term-description/style-rtl.min.css\";i:546;s:26:\"term-description/style.css\";i:547;s:30:\"term-description/style.min.css\";i:548;s:23:\"term-name/style-rtl.css\";i:549;s:27:\"term-name/style-rtl.min.css\";i:550;s:19:\"term-name/style.css\";i:551;s:23:\"term-name/style.min.css\";i:552;s:28:\"term-template/editor-rtl.css\";i:553;s:32:\"term-template/editor-rtl.min.css\";i:554;s:24:\"term-template/editor.css\";i:555;s:28:\"term-template/editor.min.css\";i:556;s:27:\"term-template/style-rtl.css\";i:557;s:31:\"term-template/style-rtl.min.css\";i:558;s:23:\"term-template/style.css\";i:559;s:27:\"term-template/style.min.css\";i:560;s:27:\"text-columns/editor-rtl.css\";i:561;s:31:\"text-columns/editor-rtl.min.css\";i:562;s:23:\"text-columns/editor.css\";i:563;s:27:\"text-columns/editor.min.css\";i:564;s:26:\"text-columns/style-rtl.css\";i:565;s:30:\"text-columns/style-rtl.min.css\";i:566;s:22:\"text-columns/style.css\";i:567;s:26:\"text-columns/style.min.css\";i:568;s:19:\"verse/style-rtl.css\";i:569;s:23:\"verse/style-rtl.min.css\";i:570;s:15:\"verse/style.css\";i:571;s:19:\"verse/style.min.css\";i:572;s:20:\"video/editor-rtl.css\";i:573;s:24:\"video/editor-rtl.min.css\";i:574;s:16:\"video/editor.css\";i:575;s:20:\"video/editor.min.css\";i:576;s:19:\"video/style-rtl.css\";i:577;s:23:\"video/style-rtl.min.css\";i:578;s:15:\"video/style.css\";i:579;s:19:\"video/style.min.css\";i:580;s:19:\"video/theme-rtl.css\";i:581;s:23:\"video/theme-rtl.min.css\";i:582;s:15:\"video/theme.css\";i:583;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("43420", "can_compress_scripts", "1", "on");
INSERT INTO `wp_options` VALUES("43421", "_transient_timeout_wc_upgrade_notice_9.9.6", "1766833143", "off");
INSERT INTO `wp_options` VALUES("43422", "_transient_wc_upgrade_notice_9.9.6", "", "off");
INSERT INTO `wp_options` VALUES("43426", "rank_math_backups", "a:1:{i:1766759356;a:5:{s:7:\"general\";a:49:{s:19:\"strip_category_base\";s:3:\"off\";s:24:\"attachment_redirect_urls\";s:2:\"on\";s:27:\"attachment_redirect_default\";s:20:\"https://mianabpe.com\";s:23:\"nofollow_external_links\";s:3:\"off\";s:20:\"nofollow_image_links\";s:3:\"off\";s:25:\"new_window_external_links\";s:2:\"on\";s:11:\"add_img_alt\";s:3:\"off\";s:14:\"img_alt_format\";s:11:\" %filename%\";s:13:\"add_img_title\";s:3:\"off\";s:16:\"img_title_format\";s:22:\"%title% %count(title)%\";s:11:\"breadcrumbs\";s:3:\"off\";s:21:\"breadcrumbs_separator\";s:1:\"-\";s:16:\"breadcrumbs_home\";s:2:\"on\";s:22:\"breadcrumbs_home_label\";s:4:\"Home\";s:26:\"breadcrumbs_archive_format\";s:15:\"Archives for %s\";s:25:\"breadcrumbs_search_format\";s:14:\"Results for %s\";s:21:\"breadcrumbs_404_label\";s:25:\"404 Error: page not found\";s:31:\"breadcrumbs_ancestor_categories\";s:3:\"off\";s:21:\"breadcrumbs_blog_page\";s:3:\"off\";s:16:\"404_monitor_mode\";s:6:\"simple\";s:17:\"404_monitor_limit\";i:100;s:35:\"404_monitor_ignore_query_parameters\";s:2:\"on\";s:24:\"redirections_header_code\";s:3:\"301\";s:18:\"redirections_debug\";s:3:\"off\";s:23:\"console_caching_control\";s:2:\"90\";s:21:\"console_email_reports\";b:0;s:23:\"console_email_frequency\";s:7:\"monthly\";s:27:\"link_builder_links_per_page\";s:1:\"7\";s:29:\"link_builder_links_per_target\";s:1:\"1\";s:22:\"wc_remove_product_base\";s:3:\"off\";s:23:\"wc_remove_category_base\";s:3:\"off\";s:31:\"wc_remove_category_parent_slugs\";s:3:\"off\";s:18:\"rss_before_content\";s:0:\"\";s:17:\"rss_after_content\";s:0:\"\";s:19:\"wc_remove_generator\";s:2:\"on\";s:24:\"remove_shop_snippet_data\";s:2:\"on\";s:18:\"frontend_seo_score\";s:3:\"off\";s:29:\"frontend_seo_score_post_types\";a:1:{i:0;s:4:\"post\";}s:27:\"frontend_seo_score_position\";s:3:\"top\";s:10:\"setup_mode\";s:4:\"easy\";s:21:\"content_ai_post_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:18:\"content_ai_country\";s:3:\"all\";s:15:\"content_ai_tone\";s:6:\"Formal\";s:19:\"content_ai_audience\";s:16:\"General Audience\";s:19:\"content_ai_language\";s:10:\"US English\";s:15:\"analytics_stats\";s:2:\"on\";s:15:\"toc_block_title\";s:17:\"Table of Contents\";s:20:\"toc_block_list_style\";s:2:\"ul\";s:15:\"llms_post_types\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:7:\"product\";}}s:6:\"titles\";a:110:{s:24:\"noindex_empty_taxonomies\";s:2:\"on\";s:15:\"title_separator\";s:1:\"-\";s:17:\"capitalize_titles\";s:3:\"off\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:19:\"knowledgegraph_type\";s:7:\"company\";s:19:\"knowledgegraph_name\";s:68:\"لوله و اتصالات پلی اتیلن میاناب پلیمر\";s:12:\"website_name\";s:68:\"لوله و اتصالات پلی اتیلن میاناب پلیمر\";s:19:\"local_business_type\";s:12:\"Organization\";s:20:\"local_address_format\";s:43:\"{address} {locality}, {region} {postalcode}\";s:13:\"opening_hours\";a:7:{i:0;a:2:{s:3:\"day\";s:6:\"Monday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:1;a:2:{s:3:\"day\";s:7:\"Tuesday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:2;a:2:{s:3:\"day\";s:9:\"Wednesday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:3;a:2:{s:3:\"day\";s:8:\"Thursday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:4;a:2:{s:3:\"day\";s:6:\"Friday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:5;a:2:{s:3:\"day\";s:8:\"Saturday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:6;a:2:{s:3:\"day\";s:6:\"Sunday\";s:4:\"time\";s:11:\"09:00-17:00\";}}s:20:\"opening_hours_format\";s:3:\"off\";s:14:\"homepage_title\";s:34:\"%sitename% %page% %sep% %sitedesc%\";s:20:\"homepage_description\";s:0:\"\";s:22:\"homepage_custom_robots\";s:3:\"off\";s:23:\"disable_author_archives\";s:3:\"off\";s:15:\"url_author_base\";s:6:\"author\";s:20:\"author_custom_robots\";s:2:\"on\";s:13:\"author_robots\";a:1:{i:0;s:7:\"noindex\";}s:20:\"author_archive_title\";s:30:\"%name% %sep% %sitename% %page%\";s:19:\"author_add_meta_box\";s:2:\"on\";s:21:\"disable_date_archives\";s:2:\"on\";s:18:\"date_archive_title\";s:30:\"%date% %page% %sep% %sitename%\";s:12:\"search_title\";s:38:\"%search_query% %page% %sep% %sitename%\";s:9:\"404_title\";s:31:\"Page Not Found %sep% %sitename%\";s:19:\"date_archive_robots\";a:1:{i:0;s:7:\"noindex\";}s:14:\"noindex_search\";s:2:\"on\";s:24:\"noindex_archive_subpages\";s:3:\"off\";s:26:\"noindex_password_protected\";s:3:\"off\";s:32:\"pt_download_default_rich_snippet\";s:7:\"product\";s:29:\"author_slack_enhanced_sharing\";s:2:\"on\";s:13:\"pt_post_title\";s:24:\"%title% %sep% %sitename%\";s:19:\"pt_post_description\";s:9:\"%excerpt%\";s:14:\"pt_post_robots\";a:0:{}s:21:\"pt_post_custom_robots\";s:3:\"off\";s:28:\"pt_post_default_rich_snippet\";s:7:\"article\";s:28:\"pt_post_default_article_type\";s:11:\"BlogPosting\";s:28:\"pt_post_default_snippet_name\";s:11:\"%seo_title%\";s:28:\"pt_post_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_post_slack_enhanced_sharing\";s:2:\"on\";s:17:\"pt_post_ls_use_fk\";s:6:\"titles\";s:20:\"pt_post_add_meta_box\";s:2:\"on\";s:20:\"pt_post_bulk_editing\";s:7:\"editing\";s:24:\"pt_post_link_suggestions\";s:2:\"on\";s:24:\"pt_post_primary_taxonomy\";s:8:\"category\";s:13:\"pt_page_title\";s:24:\"%title% %sep% %sitename%\";s:19:\"pt_page_description\";s:9:\"%excerpt%\";s:14:\"pt_page_robots\";a:0:{}s:21:\"pt_page_custom_robots\";s:3:\"off\";s:28:\"pt_page_default_rich_snippet\";s:7:\"article\";s:28:\"pt_page_default_article_type\";s:7:\"Article\";s:28:\"pt_page_default_snippet_name\";s:11:\"%seo_title%\";s:28:\"pt_page_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_page_slack_enhanced_sharing\";s:2:\"on\";s:17:\"pt_page_ls_use_fk\";s:6:\"titles\";s:20:\"pt_page_add_meta_box\";s:2:\"on\";s:20:\"pt_page_bulk_editing\";s:7:\"editing\";s:24:\"pt_page_link_suggestions\";s:2:\"on\";s:19:\"pt_attachment_title\";s:24:\"%title% %sep% %sitename%\";s:25:\"pt_attachment_description\";s:9:\"%excerpt%\";s:20:\"pt_attachment_robots\";a:1:{i:0;s:7:\"noindex\";}s:27:\"pt_attachment_custom_robots\";s:2:\"on\";s:34:\"pt_attachment_default_rich_snippet\";s:3:\"off\";s:34:\"pt_attachment_default_article_type\";s:7:\"Article\";s:34:\"pt_attachment_default_snippet_name\";s:11:\"%seo_title%\";s:34:\"pt_attachment_default_snippet_desc\";s:17:\"%seo_description%\";s:36:\"pt_attachment_slack_enhanced_sharing\";s:3:\"off\";s:26:\"pt_attachment_add_meta_box\";s:3:\"off\";s:16:\"pt_product_title\";s:24:\"%title% %sep% %sitename%\";s:22:\"pt_product_description\";s:9:\"%excerpt%\";s:17:\"pt_product_robots\";a:0:{}s:24:\"pt_product_custom_robots\";s:3:\"off\";s:31:\"pt_product_default_rich_snippet\";s:7:\"product\";s:31:\"pt_product_default_article_type\";s:7:\"Article\";s:31:\"pt_product_default_snippet_name\";s:11:\"%seo_title%\";s:31:\"pt_product_default_snippet_desc\";s:17:\"%seo_description%\";s:33:\"pt_product_slack_enhanced_sharing\";s:2:\"on\";s:20:\"pt_product_ls_use_fk\";s:6:\"titles\";s:23:\"pt_product_add_meta_box\";s:2:\"on\";s:23:\"pt_product_bulk_editing\";s:7:\"editing\";s:27:\"pt_product_link_suggestions\";s:2:\"on\";s:27:\"pt_product_primary_taxonomy\";s:11:\"product_cat\";s:18:\"pt_web-story_title\";s:24:\"%title% %sep% %sitename%\";s:24:\"pt_web-story_description\";s:9:\"%excerpt%\";s:19:\"pt_web-story_robots\";a:0:{}s:26:\"pt_web-story_custom_robots\";s:3:\"off\";s:33:\"pt_web-story_default_rich_snippet\";s:7:\"article\";s:33:\"pt_web-story_default_article_type\";s:7:\"Article\";s:33:\"pt_web-story_default_snippet_name\";s:11:\"%seo_title%\";s:33:\"pt_web-story_default_snippet_desc\";s:17:\"%seo_description%\";s:35:\"pt_web-story_slack_enhanced_sharing\";s:3:\"off\";s:25:\"pt_web-story_add_meta_box\";s:3:\"off\";s:18:\"tax_category_title\";s:23:\"%term% %sep% %sitename%\";s:19:\"tax_category_robots\";a:0:{}s:25:\"tax_category_add_meta_box\";s:2:\"on\";s:26:\"tax_category_custom_robots\";s:3:\"off\";s:24:\"tax_category_description\";s:18:\"%term_description%\";s:35:\"tax_category_slack_enhanced_sharing\";s:2:\"on\";s:18:\"tax_post_tag_title\";s:23:\"%term% %sep% %sitename%\";s:19:\"tax_post_tag_robots\";a:1:{i:0;s:7:\"noindex\";}s:25:\"tax_post_tag_add_meta_box\";s:2:\"on\";s:26:\"tax_post_tag_custom_robots\";s:2:\"on\";s:24:\"tax_post_tag_description\";s:18:\"%term_description%\";s:35:\"tax_post_tag_slack_enhanced_sharing\";s:2:\"on\";s:31:\"remove_product_cat_snippet_data\";s:2:\"on\";s:31:\"remove_product_tag_snippet_data\";s:2:\"on\";s:28:\"tax_post_format_add_meta_box\";s:2:\"on\";s:30:\"tax_product_brand_add_meta_box\";s:2:\"on\";s:28:\"tax_product_cat_add_meta_box\";s:2:\"on\";s:28:\"tax_product_tag_add_meta_box\";s:2:\"on\";s:39:\"tax_product_shipping_class_add_meta_box\";s:2:\"on\";}s:7:\"sitemap\";a:16:{s:14:\"items_per_page\";i:200;s:14:\"include_images\";s:2:\"on\";s:22:\"include_featured_image\";s:3:\"off\";s:13:\"exclude_roles\";a:2:{i:0;s:11:\"contributor\";i:1;s:10:\"subscriber\";}s:12:\"html_sitemap\";s:2:\"on\";s:20:\"html_sitemap_display\";s:9:\"shortcode\";s:17:\"html_sitemap_sort\";s:9:\"published\";s:23:\"html_sitemap_seo_titles\";s:6:\"titles\";s:15:\"authors_sitemap\";s:2:\"on\";s:15:\"pt_post_sitemap\";s:2:\"on\";s:15:\"pt_page_sitemap\";s:2:\"on\";s:21:\"pt_attachment_sitemap\";s:3:\"off\";s:18:\"pt_product_sitemap\";s:2:\"on\";s:20:\"pt_web-story_sitemap\";s:3:\"off\";s:20:\"tax_category_sitemap\";s:2:\"on\";s:20:\"tax_post_tag_sitemap\";s:3:\"off\";}s:12:\"role-manager\";a:3:{s:13:\"administrator\";a:16:{i:0;s:16:\"rank_math_titles\";i:1;s:17:\"rank_math_general\";i:2;s:17:\"rank_math_sitemap\";i:3;s:21:\"rank_math_404_monitor\";i:4;s:22:\"rank_math_link_builder\";i:5;s:22:\"rank_math_redirections\";i:6;s:22:\"rank_math_role_manager\";i:7;s:19:\"rank_math_analytics\";i:8;s:23:\"rank_math_site_analysis\";i:9;s:25:\"rank_math_onpage_analysis\";i:10;s:24:\"rank_math_onpage_general\";i:11;s:25:\"rank_math_onpage_advanced\";i:12;s:24:\"rank_math_onpage_snippet\";i:13;s:23:\"rank_math_onpage_social\";i:14;s:20:\"rank_math_content_ai\";i:15;s:19:\"rank_math_admin_bar\";}s:6:\"editor\";a:5:{i:0;s:23:\"rank_math_site_analysis\";i:1;s:25:\"rank_math_onpage_analysis\";i:2;s:24:\"rank_math_onpage_general\";i:3;s:24:\"rank_math_onpage_snippet\";i:4;s:23:\"rank_math_onpage_social\";}s:6:\"author\";a:4:{i:0;s:25:\"rank_math_onpage_analysis\";i:1;s:24:\"rank_math_onpage_general\";i:2;s:24:\"rank_math_onpage_snippet\";i:3;s:23:\"rank_math_onpage_social\";}}s:7:\"modules\";a:14:{i:0;s:12:\"link-counter\";i:1;s:9:\"analytics\";i:2;s:12:\"seo-analysis\";i:3;s:7:\"sitemap\";i:4;s:12:\"rich-snippet\";i:5;s:11:\"woocommerce\";i:6;s:10:\"buddypress\";i:7;s:7:\"bbpress\";i:8;s:3:\"acf\";i:9;s:11:\"web-stories\";i:10;s:10:\"content-ai\";i:11;s:16:\"instant-indexing\";i:12;s:9:\"local-seo\";i:13;s:12:\"role-manager\";}}}", "off");
INSERT INTO `wp_options` VALUES("43427", "rank_math_react_settings_ui", "on", "off");
INSERT INTO `wp_options` VALUES("43431", "_transient_timeout_woocommerce_admin_remote_inbox_notifications_specs", "1767352177", "off");
INSERT INTO `wp_options` VALUES("43432", "_transient_woocommerce_admin_remote_inbox_notifications_specs", "a:1:{s:5:\"fa_IR\";a:55:{s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:467:\"That’s huge! You’re well on your way to building a successful online store — now it’s time to think about how you’ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:130:\"https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:13\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";s:7:\"default\";a:0:{}}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:177:\"It’s crucial to get your store’s checkout as smooth as possible to avoid losing sales. Let’s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:144:\"https://woocommerce.com/posts/optimizing-woocommerce-checkout?utm_source=inbox_note&utm_medium=product&utm_campaign=optimizing-the-checkout-flow\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:49\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";s:7:\"default\";a:0:{}}}}s:32:\"wc-payments-qualitative-feedback\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wc-payments-qualitative-feedback\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:46:\"WooPayments setup - let us know what you think\";s:7:\"content\";s:137:\"Congrats on enabling WooPayments for your store. Please share your feedback in this 2 minute survey to help us improve the setup process.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"qualitative-feedback-from-new-users\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:58:\"https://automattic.survey.fm/woopayments-new-user-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:13\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:20:\"woocommerce-payments\";s:7:\"default\";a:0:{}}}}s:29:\"share-your-feedback-on-paypal\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"share-your-feedback-on-paypal\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:29:\"Share your feedback on PayPal\";s:7:\"content\";s:127:\"Share your feedback in this 2 minute survey about how we can make the process of accepting payments more useful for your store.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:43:\"http://automattic.survey.fm/paypal-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:50\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}}}s:31:\"google_listings_and_ads_install\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"google_listings_and_ads_install\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Drive traffic and sales with Google\";s:7:\"content\";s:123:\"Reach online shoppers to drive traffic and sales for your store by showcasing products across Google, for free or with ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"get-started\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Get started\";}}s:3:\"url\";s:122:\"https://woocommerce.com/products/google-listings-and-ads?utm_source=inbox_note&utm_medium=product&utm_campaign=get-started\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-09 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google_listings_and_ads\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:10;}}}s:39:\"wc-subscriptions-security-update-3-0-15\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-subscriptions-security-update-3-0-15\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:42:\"WooCommerce Subscriptions security update!\";s:7:\"content\";s:738:\"We recently released an important security update to WooCommerce Subscriptions. To ensure your site’s data is protected, please upgrade <strong>WooCommerce Subscriptions to version 3.0.15</strong> or later.<br/><br/>Click the button below to view and update to the latest Subscriptions version, or log in to <a href=\"https://woocommerce.com/my-dashboard\">WooCommerce.com Dashboard</a> and navigate to your <strong>Downloads</strong> page.<br/><br/>We recommend always using the latest version of WooCommerce Subscriptions, and other software running on your site, to ensure maximum security.<br/><br/>If you have any questions we are here to help — just <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">open a ticket</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"update-wc-subscriptions-3-0-15\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"View latest version\";}}s:3:\"url\";s:30:\"&page=wc-addons&section=helper\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:30:32\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:6:\"3.0.15\";}}}s:29:\"woocommerce-core-update-5-4-0\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"woocommerce-core-update-5-4-0\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Update to WooCommerce 5.4.1 now\";s:7:\"content\";s:140:\"WooCommerce 5.4.1 addresses a checkout issue discovered in WooCommerce 5.4. We recommend upgrading to WooCommerce 5.4.1 as soon as possible.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"update-wc-core-5-4-0\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:25:\"How to update WooCommerce\";}}s:3:\"url\";s:64:\"https://docs.woocommerce.com/document/how-to-update-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:31:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.0\";}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-11\";s:7:\"content\";s:19:\"wcpay-promo-2020-11\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-12\";s:7:\"content\";s:19:\"wcpay-promo-2020-12\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:34:\"ppxo-pps-upgrade-paypal-payments-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-1\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Get the latest PayPal extension for WooCommerce\";s:7:\"content\";s:442:\"Heads up! There’s a new PayPal on the block!<br/><br/>Now is a great time to upgrade to our latest <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension</a> to continue to receive support and updates with PayPal.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, and pay later options with the all-new PayPal extension for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:33:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:7;s:7:\"default\";i:1;s:9:\"operation\";s:1:\"<\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-2\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Upgrade your PayPal experience!\";s:7:\"content\";s:358:\"Get access to a full suite of PayPal payment methods, extensive currency and country coverage, offer subscription and recurring payments, and the new PayPal pay later options.<br /><br />Start using our <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">latest PayPal today</a> to continue to receive support and updates.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-2\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:34:30\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:6;s:7:\"default\";i:1;s:9:\"operation\";s:1:\">\";}}}s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Critical vulnerabilities in WooCommerce\";s:7:\"content\";s:574:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br /><br />Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br /><br />For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:59:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.8\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.9\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.2\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.3\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.4\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.5\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.4\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.4\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.2\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:36;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:37;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.3\";}i:38;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}i:39;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.5.10\";}i:40;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.7\";}i:41;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.3\";}i:42;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.3\";}i:43;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.5\";}i:44;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.4\";}i:45;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.4\";}i:46;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.5\";}i:47;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.6\";}i:48;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.4\";}i:49;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.5\";}i:50;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.5\";}i:51;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.4\";}i:52;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.3\";}i:53;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.5\";}i:54;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.3\";}i:55;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:56;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.5\";}i:57;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.3\";}i:58;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.4\";}}}s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Critical vulnerabilities in WooCommerce Blocks\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:32:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:42\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"2.5.16\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.6.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.7.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.8.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.9.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.0.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.1.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.1\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:45:\"woocommerce-core-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woocommerce-core-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"Solved: Critical vulnerabilities patched in WooCommerce\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:18\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:23:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.1\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Solved: Critical vulnerabilities patched in WooCommerce Blocks\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:54\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:19:\"habit-moment-survey\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"habit-moment-survey\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"We’re all ears! Share your experience so far with WooCommerce\";s:7:\"content\";s:136:\"We’d love your input to shape the future of WooCommerce together. Feel free to share any feedback, ideas or suggestions that you have.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:45:\"https://automattic.survey.fm/store-management\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:37:30\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:30;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:0;}}}s:42:\"woocommerce-core-paypal-march-2022-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:391:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy PayPal Standard security updates for stores running WooCommerce (version 3.5 to 6.3). It’s recommended to disable PayPal Standard, and use <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal Payments</a> to accept PayPal.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-core-paypal-march-2022-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:44:57\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:3:\"5.5\";}i:1;a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}}}}}}}s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:237:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy security updates related to PayPal Standard payment gateway for stores running WooCommerce (version 3.5 to 6.3).\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:45:04\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}s:24:\"pinterest_03_2022_update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"pinterest_03_2022_update\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"Your Pinterest for WooCommerce plugin is out of date!\";s:7:\"content\";s:262:\"Update to the latest version of Pinterest for WooCommerce to continue using this plugin and keep your store connected with Pinterest. To update, visit <strong>Plugins &gt; Installed Plugins</strong>, and click on “update now” under Pinterest for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"pinterest_03_2022_update\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"Update Instructions\";}}s:3:\"url\";s:148:\"https://woocommerce.com/document/pinterest-for-woocommerce/?utm_source=inbox_note&utm_medium=product&utm_campaign=pinterest_03_2022_update#section-3\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-23 00:00:39\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"pinterest-for-woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"1.0.8\";}}}s:33:\"store_setup_survey_survey_q2_2022\";O:8:\"stdClass\":8:{s:4:\"slug\";s:33:\"store_setup_survey_survey_q2_2022\";s:4:\"type\";s:6:\"survey\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:30:\"How is your store setup going?\";s:7:\"content\";s:232:\"Our goal is to make sure you have all the right tools to start setting up your store in the smoothest way possible.\r\nWe’d love to know if we hit our mark and how we can improve. To collect your thoughts, we made a 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:53:\"store_setup_survey_survey_q2_2022_share_your_thoughts\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Tell us how it’s going\";}}s:3:\"url\";s:52:\"https://automattic.survey.fm/store-setup-survey-2022\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-05-09 08:42:10\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:7;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:9;}}}s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:58:\"Security vulnerability patched in WooCommerce Eway Gateway\";s:7:\"content\";s:323:\"In response to a potential vulnerability identified in WooCommerce Eway Gateway versions 3.1.0 to 3.5.0, we’ve worked to deploy security fixes and have released an updated version.\r\nNo external exploits have been detected, but we recommend you update to your latest supported version 3.1.26, 3.2.3, 3.3.1, 3.4.6, or 3.5.1\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:62:\"needs-update-eway-payment-gateway-rin-action-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"/update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:63:\"needs-update-eway-payment-gateway-rin-dismiss-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:7:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-03 23:45:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.1.26\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"3.5.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"3.1.0\";}}}s:43:\"updated-eway-payment-gateway-rin-2022-12-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:43:\"updated-eway-payment-gateway-rin-2022-12-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Eway Gateway has been automatically updated\";s:7:\"content\";s:280:\"Your store is now running the latest secure version of WooCommerce Eway Gateway. We worked with the WordPress Plugins team to deploy a software update to stores running WooCommerce Eway Gateway (versions 3.1.0 to 3.5.0) in response to a security vulnerability that was discovered.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:57:\"updated-eway-payment-gateway-rin-action-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"See all updates\";}}s:3:\"url\";s:16:\"/update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"updated-eway-payment-gateway-rin-dismiss-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-03 23:45:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:5:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.1.26\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.3\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}}}}}s:31:\"ecomm-wc-navigation-survey-2023\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"ecomm-wc-navigation-survey-2023\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:39:\"Navigating WooCommerce on WordPress.com\";s:7:\"content\";s:166:\"We are improving the WooCommerce navigation on WordPress.com and would love your help to make it better! Please share your experience with us in this 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:32:\"share-navigation-survey-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:58:\"https://automattic.survey.fm/new-ecommerce-plan-navigation\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-01-16 09:53:44\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:12:\"is_ecommerce\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:180;}}}s:39:\"woopay-beta-merchantrecruitment-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"woopay-beta-merchantrecruitment-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:319:\"WooPay, a new express checkout feature built into WooCommerce Payments, is <b>now available</b> —and we’re inviting you to be one of the first to try it. \r\n<br><br>\r\n<b>Boost conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\r\n<br><br>\r\n<b>Get started in seconds.</b>\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:48:\"woopay-beta-merchantrecruitment-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-activate-learnmore-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:155:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-activate-learnmore-04MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:27\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.handinhandparenting.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://pritikinfoods.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://utahrecsports.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.hunterpta.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.smokinbeans.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://shulabeauty.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bingeworthytvmerch.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://s91.4d8.myftpupload.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://stephanienicolenorris.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://aliensshirt.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://libertyordeathapparelllc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://cowboystatedaily.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:42:\"https://fundrgear.com/beckendorffathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:50:\"http://wordpress-528155-2231771.cloudwaysapps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://checkout.sohaprice.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://amadozstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://eliwehbe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://lunabra.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://nptixx.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://louisianapantry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://aplusanatomy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://wildsvg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://bleachfilm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://benabeautyspa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:47:\"http://barrettfitnessenterprises.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://goabroadable.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://alexoathletica.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.fourpurls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.hagmannreport.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://busybeeorganics.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nallsproduce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://bigtimebats.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://shop.cookingwithkarli.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.queenofpeacemedia.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://bigjohnsbeefjerky.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://paperbyjaney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://carolinarisemembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://veroticaevents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://spira.farm\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://endlessassist.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://betterlifeblog.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://ashleighrenard.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.turkeymerck.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://carfiershop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://normanmusicfestival.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://www.olfactoryfactoryllc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://fundrgear.com/anthonyathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"http://tkechilifestdotcom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://pvsa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://becbatop.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wwmeconvention.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://lswmp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bubbaskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://fusango.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://vcdpostershow.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.rileysribz.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.fakeultrasound.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://onelongfellowsquare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://agodpod.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/littleladybulldogs\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://thecirclelarp.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://byletam.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.nachonite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://designerdab.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2151.temp.domains/~lovebyt2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://shortporchbaseballcompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://distancecme.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://middleswarthchips.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://railblazausa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://mikescountrymeats.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://www.woodenshoe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://rockspringscafe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"http://footballfangears.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://ybtoner.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://simplyclayyy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://naturecreation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://marisrodriguez.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://asanteinternational.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://theatre55.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://carolynscreativeclassroom.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.miiriya.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://trendyds.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wooedbythefood.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://papasteamstores.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://omdurags.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://happydogbarkery.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://kitbose.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://seamossdeals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://zeatala.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://shop.atwaterffa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://www.brettsfirstresponders.org/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://shirtactive.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://boerneparade.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://zorahshrine.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://davidcervenka.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://addisjourney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://305ycle.cc\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"http://yourworstnightmarehaunt.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://westcoastpreps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://checkout.sohaking.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://www.theunshakeablepundit.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.stellaandchewys.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.raywhitcomb.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"http://constellationtheatercompany.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://stacynguyen.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:46:\"https://fundrgear.com/lakecreekgirlsbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://winslowartcenter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://flufftastik.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mygreenbeach.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://ebookvip.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/needvillevolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bifocalmedia.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://clrc.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://hyperpins.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/lakecreekboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://fundrgear.com/kparktennis\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mogadorspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://fundrgear.com/newcaneytrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://sigmascents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://bsharisemoore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://morrflate.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://westbrosinc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://shop.danceplexaz.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://chikepod.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.advanahealth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://tatter.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://greatawakeningbrewing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://waterfowlfestival.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://preppedwellness.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://events.thus.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://stormtide.thefifthtrooper.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.tabsynth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"http://staging.fliptheswitchon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://duffysdough.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodieliving.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://breakerbrotherstcg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://andymation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://recklessmetals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://sophielark.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://wp.arabtherapy.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://creativeappliques.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://altitude.win\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:42:\"woocommerce-wcpay-march-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-wcpay-march-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:57:\"Action required: Security update for WooCommerce Payments\";s:7:\"content\";s:296:\"<strong>Your store requires a security update for WooCommerce Payments</strong>. Please update to the latest version of WooCommerce Payments immediately to address a potential vulnerability discovered on March 22. For more information on how to update, visit this WooCommerce Developer Blog Post.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:49:\"woocommerce-wcpay-march-2023-update-needed-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"See Blog Post\";}}s:3:\"url\";s:122:\"https://developer.woocommerce.com/2023/03/23/critical-vulnerability-detected-in-woocommerce-payments-what-you-need-to-know\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:57:\"woocommerce-wcpay-march-2023-update-needed-dismiss-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:11:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-03-22 20:25:44\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.5.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"4.8.0\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"5.6.1\";}}}s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:52:\"Accept in-person contactless payments on your iPhone\";s:7:\"content\";s:230:\"Tap to Pay on iPhone and WooCommerce Payments is quick, secure, and simple to set up — no extra terminals or card readers are needed. Accept contactless debit and credit cards, Apple Pay, and other NFC digital wallets in person.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:20:\"Simplify my payments\";}}s:3:\"url\";s:143:\"https://woocommerce.com/products/woocommerce-payments/?utm_source=inbox_note&utm_medium=product&utm_campaign=tap_to_pay_iphone_q2_2023_no_wcpay\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-03 23:59:47\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}s:48:\"woocommerce-WCPreOrders-april-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-WCPreOrders-april-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:68:\"Action required: Security update of WooCommerce Pre-Orders extension\";s:7:\"content\";s:220:\"<strong>Your store requires a security update for the WooCommerce Pre-Orders extension</strong>. Please update the WooCommerce Pre-Orders extension immediately to address a potential vulnerability discovered on April 11.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:18:\"extension-settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:15:\"update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-12 22:16:37\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:22:\"woocommerce-pre-orders\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.0.0\";}}}s:46:\"woopay-beta-merchantrecruitment-update-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woopay-beta-merchantrecruitment-update-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:321:\"WooPay, a new express checkout feature built into WooCommerce Payments, is <b>now available</b> — and you’re invited to try it. \r\n<br /><br />\r\n<b>Boost conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\r\n<br /><br />\r\n<b>Update WooCommerce Payments</b> to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:52:\"woopay-beta-merchantrecruitment-update-WCPay-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:55:\"woopay-beta-merchantrecruitment-update-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.handinhandparenting.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://pritikinfoods.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://utahrecsports.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.hunterpta.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.smokinbeans.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://shulabeauty.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bingeworthytvmerch.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://s91.4d8.myftpupload.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://stephanienicolenorris.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://aliensshirt.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://libertyordeathapparelllc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://cowboystatedaily.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:42:\"https://fundrgear.com/beckendorffathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:50:\"http://wordpress-528155-2231771.cloudwaysapps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://checkout.sohaprice.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://amadozstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://eliwehbe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://lunabra.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://nptixx.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://louisianapantry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://aplusanatomy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://wildsvg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://bleachfilm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://benabeautyspa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:47:\"http://barrettfitnessenterprises.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://goabroadable.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://alexoathletica.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.fourpurls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.hagmannreport.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://busybeeorganics.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nallsproduce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://bigtimebats.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://shop.cookingwithkarli.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.queenofpeacemedia.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://bigjohnsbeefjerky.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://paperbyjaney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://carolinarisemembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://veroticaevents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://spira.farm\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://endlessassist.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://betterlifeblog.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://ashleighrenard.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.turkeymerck.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://carfiershop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://normanmusicfestival.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://www.olfactoryfactoryllc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://fundrgear.com/anthonyathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"http://tkechilifestdotcom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://pvsa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://becbatop.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wwmeconvention.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://lswmp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bubbaskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://fusango.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://vcdpostershow.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.rileysribz.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.fakeultrasound.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://onelongfellowsquare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://agodpod.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/littleladybulldogs\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://thecirclelarp.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://byletam.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.nachonite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://designerdab.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2151.temp.domains/~lovebyt2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://shortporchbaseballcompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://distancecme.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://middleswarthchips.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://railblazausa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://mikescountrymeats.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://www.woodenshoe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://rockspringscafe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"http://footballfangears.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://ybtoner.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://simplyclayyy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://naturecreation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://marisrodriguez.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://asanteinternational.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://theatre55.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://carolynscreativeclassroom.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.miiriya.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://trendyds.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wooedbythefood.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://papasteamstores.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://omdurags.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://happydogbarkery.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://kitbose.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://seamossdeals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://zeatala.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://shop.atwaterffa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://www.brettsfirstresponders.org/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://shirtactive.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://boerneparade.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://zorahshrine.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://davidcervenka.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://addisjourney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://305ycle.cc\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"http://yourworstnightmarehaunt.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://westcoastpreps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://checkout.sohaking.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://www.theunshakeablepundit.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.stellaandchewys.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.raywhitcomb.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"http://constellationtheatercompany.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://stacynguyen.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:46:\"https://fundrgear.com/lakecreekgirlsbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://winslowartcenter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://flufftastik.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mygreenbeach.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://ebookvip.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/needvillevolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bifocalmedia.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://clrc.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://hyperpins.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/lakecreekboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://fundrgear.com/kparktennis\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mogadorspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://fundrgear.com/newcaneytrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://sigmascents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://bsharisemoore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://morrflate.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://westbrosinc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://shop.danceplexaz.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://chikepod.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.advanahealth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://tatter.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://greatawakeningbrewing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://waterfowlfestival.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://preppedwellness.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://events.thus.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://stormtide.thefifthtrooper.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.tabsynth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"http://staging.fliptheswitchon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://duffysdough.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodieliving.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://breakerbrotherstcg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://andymation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://recklessmetals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://sophielark.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://wp.arabtherapy.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://creativeappliques.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://altitude.win\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:46:\"woopay-beta-existingmerchants-noaction-27APR23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woopay-beta-existingmerchants-noaction-27APR23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:15:\"WooPay is back!\";s:7:\"content\";s:361:\"Thanks for previously trying WooPay, the<b> express checkout feature</b> built into WooCommerce Payments. We’re excited to announce that <b>WooPay availability has resumed</b>. No action is required on your part.\r\n<br /><br />\r\nYou can now <b>continue boosting conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-existingmerchants-noaction-documentation-27APR23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Documentation\";}}s:3:\"url\";s:178:\"https://woocommerce.com/document/woopay-merchant-documentation/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-existingmerchants-noaction-documentation-27APR23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-26 19:00:23\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:38:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://store.startingstrongman.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://joacreativelab.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.pureskincaresalon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mariablaquier.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://getprodigital.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://dalefrickeholsters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://sstour.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://tk-txstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://humanspiritproject.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://viradadrums.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://rosariumblends.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://organicskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://stuckpigmedical.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.seattlegiftbasket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.cloverandviolet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gvscholarship.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://yesimadiva.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://www.old.jmtrashbgone.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://victorialansford.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://craftcosplay.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://thefossilexchange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nextgenspeed.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cappellarecords.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://ontimesupermarket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://new2knox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://lovestudiollc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://socceruniformkits.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://willowcreativ.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://summitprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://howda.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://soapavenuecompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://subsbox.mystagingwebsite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wifflebreakers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.mps-outfitters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://howardharrisassociates.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bettersaferadio.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://bunnyluna.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:44:\"woopay-beta-existingmerchants-update-27APR23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"woopay-beta-existingmerchants-update-27APR23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:15:\"WooPay is back!\";s:7:\"content\";s:368:\"Thanks for previously trying WooPay, the <b>express checkout feature</b> built into WooCommerce Payments. We’re excited to announce that <b>WooPay availability has resumed</b>.\r\n<br /><br />\r\n\r\nUpdate to the latest WooCommerce Payments version to <b>continue boosting conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:50:\"woopay-beta-existingmerchants-update-WCPay-27APR23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-26 19:00:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:38:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://store.startingstrongman.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://joacreativelab.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.pureskincaresalon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mariablaquier.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://getprodigital.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://dalefrickeholsters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://sstour.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://tk-txstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://humanspiritproject.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://viradadrums.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://rosariumblends.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://organicskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://stuckpigmedical.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.seattlegiftbasket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.cloverandviolet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gvscholarship.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://yesimadiva.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://www.old.jmtrashbgone.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://victorialansford.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://craftcosplay.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://thefossilexchange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nextgenspeed.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cappellarecords.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://ontimesupermarket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://new2knox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://lovestudiollc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://socceruniformkits.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://willowcreativ.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://summitprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://howda.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://soapavenuecompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://subsbox.mystagingwebsite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wifflebreakers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.mps-outfitters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://howardharrisassociates.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bettersaferadio.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://bunnyluna.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:45:\"woopay-beta-merchantrecruitment-short-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woopay-beta-merchantrecruitment-short-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woopay-beta-merchantrecruitment-short-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:64:\"woopay-beta-merchantrecruitment-short-activate-learnmore-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:161:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-04MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:36\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.bluebeautifly.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://indianrivernatural.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://fouroaksproducts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:14:\"https://acb.la\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://www.sweetpotatoplant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://www.gocaseyourself.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://laugun.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://nebraskadaybyday.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://vintagemarche727.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://kohai.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://gracegaze.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://aliensmeaning.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://myheritagegardens.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://shopmoresport.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://oladino.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://frogjumpstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cagedthundermma.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/mcelwainelementary\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://mgco.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://500gp.io/pay\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://waterglassslimes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://antiqueful.shop/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://deeperkidmin.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/cyspringsboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://houseofminifigs.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2273.temp.domains/~dreambx2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://madebymixture.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://reliabletrash.company\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.daddybutter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://circleqessentials.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://garlicbraids.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://fbdonline.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://galaxysedge.us\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://duckduckbeetfarm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://varsitygraphics.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://jademackenzie.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://kristysketolifestyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://covid19criticalcare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://parkviewprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://rock-fest.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://fillinxsolutions.com/etarix/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://doughremitx.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.montanafiddlecamp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://fococomiccon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://patricendouglas.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://hectue.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://montanamaxbbq.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://smellzoom.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://uptowne.theoandson.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://superbasic.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ppodstore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://kerenzan.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://a13bargains.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://colorgr.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://mindbodysoulcandles.com/Charlotte\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://peaceloveandadhd.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://seymoursmash.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mwtournament.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:43:\"https://fundrgear.com/beckendorffgirlstrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://allswellnyc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://childoftheredwoodsmembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/grandoaksvolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.newhollandrochester.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.purplecatvet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"https://www.mustangmountaincoaster.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.roccanj.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.teerico.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://passportunlimited.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.paladincards20.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://giantshorties.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visualsports.biz\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://thefreakinricanrestaurant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://arequestionscom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://pt.tktxcompanystore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodiechicks.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://nutoshop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://backwoodzhiphop.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://gartapparel.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bodega.badiaspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://rampartrange.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://teeuni.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bearsinthealley.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://vitalbooks.net/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://hair-free-hair-remover.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gangtaynails.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://crochetfoundry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://westcoastbelts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://payment.sundryfiles.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://ccadunkirk.mudhenmama.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://desertsupercup.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://shops-eminem.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://75yearsofracing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://tixpls.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:44:\"http://legacyoutfitters.org/banquet/raffles/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://91170e9fc9.nxcli.io/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://beachwayrentals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://esd.camp\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mfkgamecalls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://1greatce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.luthyouth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://electionintegrityidaho.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://renbundle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://premierseamoss.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://teemart.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/beckendorffgirlsbb\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visiblechild.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ebookvital.me/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://renemarsh.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://www.eventricate.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://transgression.party\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://profadex.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://mxsbattlegrounds.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.poeinbaltimore.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://freefall.gg\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://underthechurchhatblog.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://naksparkle.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"http://bearlyburly.gay/inventory\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.premierboneandjoint.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://farm-2-bowl.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://hollandgrill.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://lividian.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.trainingrange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://sarakepskitchen.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.phoenixyouththeatre.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://drivenarmsco.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://audiobro.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://www.iowaabortionaccessfund.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://findthemenu.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://moderndepot.co\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://granitesupplements.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://healthyrican.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://utest.edsandbox.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://c-pounds.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://littleschoolofsmiths.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://goblinstyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://proper-testing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.cosafoundation.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://farmsteadboxes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://fundraise4books.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://norskenook.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://cajulove.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:52:\"woopay-beta-merchantrecruitment-short-update-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woopay-beta-merchantrecruitment-short-update-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:227:\"Be one of the first to try WooPay, our new express checkout feature. <br><b>Boost conversions</b> by letting customers pay with a <b>single click</b>. <br><br>Update to the latest version of WooCommerce Payments to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-short-update-WCPay-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-update-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:20\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.bluebeautifly.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://indianrivernatural.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://fouroaksproducts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:14:\"https://acb.la\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://www.sweetpotatoplant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://www.gocaseyourself.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://laugun.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://nebraskadaybyday.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://vintagemarche727.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://kohai.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://gracegaze.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://aliensmeaning.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://myheritagegardens.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://shopmoresport.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://oladino.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://frogjumpstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cagedthundermma.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/mcelwainelementary\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://mgco.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://500gp.io/pay\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://waterglassslimes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://antiqueful.shop/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://deeperkidmin.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/cyspringsboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://houseofminifigs.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2273.temp.domains/~dreambx2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://madebymixture.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://reliabletrash.company\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.daddybutter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://circleqessentials.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://garlicbraids.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://fbdonline.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://galaxysedge.us\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://duckduckbeetfarm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://varsitygraphics.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://jademackenzie.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://kristysketolifestyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://covid19criticalcare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://parkviewprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://rock-fest.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://fillinxsolutions.com/etarix/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://doughremitx.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.montanafiddlecamp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://fococomiccon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://patricendouglas.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://hectue.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://montanamaxbbq.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://smellzoom.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://uptowne.theoandson.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://superbasic.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ppodstore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://kerenzan.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://a13bargains.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://colorgr.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://mindbodysoulcandles.com/Charlotte\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://peaceloveandadhd.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://seymoursmash.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mwtournament.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:43:\"https://fundrgear.com/beckendorffgirlstrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://allswellnyc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://childoftheredwoodsmembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/grandoaksvolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.newhollandrochester.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.purplecatvet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"https://www.mustangmountaincoaster.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.roccanj.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.teerico.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://passportunlimited.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.paladincards20.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://giantshorties.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visualsports.biz\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://thefreakinricanrestaurant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://arequestionscom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://pt.tktxcompanystore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodiechicks.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://nutoshop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://backwoodzhiphop.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://gartapparel.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bodega.badiaspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://rampartrange.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://teeuni.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bearsinthealley.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://vitalbooks.net/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://hair-free-hair-remover.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gangtaynails.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://crochetfoundry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://westcoastbelts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://payment.sundryfiles.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://ccadunkirk.mudhenmama.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://desertsupercup.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://shops-eminem.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://75yearsofracing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://tixpls.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:44:\"http://legacyoutfitters.org/banquet/raffles/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://91170e9fc9.nxcli.io/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://beachwayrentals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://esd.camp\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mfkgamecalls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://1greatce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.luthyouth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://electionintegrityidaho.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://renbundle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://premierseamoss.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://teemart.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/beckendorffgirlsbb\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visiblechild.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ebookvital.me/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://renemarsh.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://www.eventricate.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://transgression.party\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://profadex.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://mxsbattlegrounds.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.poeinbaltimore.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://freefall.gg\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://underthechurchhatblog.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://naksparkle.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"http://bearlyburly.gay/inventory\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.premierboneandjoint.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://farm-2-bowl.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://hollandgrill.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://lividian.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.trainingrange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://sarakepskitchen.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.phoenixyouththeatre.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://drivenarmsco.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://audiobro.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://www.iowaabortionaccessfund.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://findthemenu.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://moderndepot.co\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://granitesupplements.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://healthyrican.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://utest.edsandbox.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://c-pounds.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://littleschoolofsmiths.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://goblinstyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://proper-testing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.cosafoundation.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://farmsteadboxes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://fundraise4books.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://norskenook.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://cajulove.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:45:\"woopay-beta-merchantrecruitment-short-09MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woopay-beta-merchantrecruitment-short-09MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-activate-button-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:72:\"woopay-beta-merchantrecruitment-short-activate-learnmore-button2-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:169:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-button2-09MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-08 19:18:44\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:17:\"platform_checkout\";}}}s:11:\"option_name\";s:41:\"woocommerce_woocommerce_payments_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"no\";s:7:\"default\";b:0;}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:31:\"data.platform_checkout_eligible\";}}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;s:7:\"default\";b:0;}}}s:52:\"woopay-beta-merchantrecruitment-short-update-09MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woopay-beta-merchantrecruitment-short-update-09MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:227:\"Be one of the first to try WooPay, our new express checkout feature. <br><b>Boost conversions</b> by letting customers pay with a <b>single click</b>. <br><br>Update to the latest version of WooCommerce Payments to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-short-update-WCPay-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-update-activate-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-08 19:45:57\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:17:\"platform_checkout\";}}}s:11:\"option_name\";s:41:\"woocommerce_woocommerce_payments_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"no\";s:7:\"default\";b:0;}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:31:\"data.platform_checkout_eligible\";}}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;s:7:\"default\";b:0;}}}s:52:\"woocommerce-WCSubscriptions-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woocommerce-WCSubscriptions-June-2023-updated-needed\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Action required: Security update of WooCommerce Subscriptions\";s:7:\"content\";s:197:\"<strong>Your store requires a security update for the WooCommerce Subscriptions plugin</strong>. Please update the WooCommerce Subscriptions plugin immediately to address a potential vulnerability.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:68:\"woocommerce-WCSubscriptions-June-2023-updated-needed-Plugin-Settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woocommerce-WCSubscriptions-June-2023-updated-needed-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-06 08:00:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"2.1.0\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"5.1.2\";}}}s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:87:\"Action required: Security update of WooCommerce Returns and Warranty Requests extension\";s:7:\"content\";s:270:\"<strong>Your store requires a security update for the Returns and Warranty Requests extension</strong>.  Please update to the latest version of the WooCommerce Returns and Warranty Requests extension immediately to address a potential vulnerability discovered on May 31.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-02 23:53:57\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-warranty\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.1.8\";}}}s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:65:\"Action required: Security update of WooCommerce One Page Checkout\";s:7:\"content\";s:232:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce One Page Checkout extension</strong>. The fix for this vulnerability was released for this extension on June 13th. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-21 14:05:46\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:29:\"woocommerce-one-page-checkout\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"2.4.0\";}}}s:40:\"woocommerce-WCGC-July-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:68:\"Action required: Security update of WooCommerce GoCardless Extension\";s:7:\"content\";s:205:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce GoCardless extension</strong>. The fix for this vulnerability was released on July 4th. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-04 15:36:07\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:30:\"woocommerce-gateway-gocardless\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.5.6\";}}}s:48:\"woocommerce-shipping-fedex-api-outage-2023-07-16\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-shipping-fedex-api-outage-2023-07-16\";s:4:\"type\";s:7:\"warning\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:40:\"Scheduled FedEx API outage — July 2023\";s:7:\"content\";s:277:\"On July 16 there will be a full outage of the FedEx API from 04:00 to 08:00 AM UTC. Due to planned maintenance by FedEx, you\'ll be unable to provide FedEx shipping rates during this time. Follow the link below for more information and recommendations on how to minimize impact.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:125:\"https://woocommerce.com/document/fedex/?utm_medium=product&utm_source=inbox_note&utm_campaign=learn-more#july-2023-api-outage\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-05 18:19:17\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-shipping-fedex\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-07-17 00:00:00\";}}}s:35:\"wcship-2023-07-hazmat-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wcship-2023-07-hazmat-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:87:\"Action required: USPS HAZMAT compliance update for WooCommerce Shipping & Tax extension\";s:7:\"content\";s:251:\"<strong>Your store requires an update for the WooCommerce Shipping extension</strong>. Please update to the latest version of the WooCommerce Shipping &amp; Tax extension immediately to ensure compliance with new USPS HAZMAT rules currently in effect.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"plugin-list\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:23:\"admin.php?page=wc-admin\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-11 20:26:59\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-services\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"2.3.0\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Action required: Security update for WooCommerce Stripe plugin\";s:7:\"content\";s:183:\"<strong>Your shop requires an important security update for the  WooCommerce Stripe plugin</strong>. The fix for this vulnerability was released on July 31. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"update-core.php?\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"7.4.2\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.3.2\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.4.5\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.5.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.6.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.9.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.0.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.2.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.3.2\";}}}}}}}s:46:\"woocommerce-WCStripe-Aug-2023-security-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-WCStripe-Aug-2023-security-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:44:\"Security update of WooCommerce Stripe plugin\";s:7:\"content\";s:144:\"<strong>Your store has been updated to the latest secure version of the WooCommerce Stripe plugin</strong>. This update was released on July 31.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:07\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.3.2\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.4.5\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.5.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.6.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.9.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.0.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.2.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.3.2\";}}}}}s:49:\"woocommerce-WooPayments-Aug-2023-security-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:49:\"woocommerce-WooPayments-Aug-2023-security-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:60:\"Security update of WooPayments (WooCommerce Payments) plugin\";s:7:\"content\";s:147:\"<strong>Your store has been updated to the more secure version of WooPayments (WooCommerce Payments)</strong>. This update was released on July 31.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:13\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:17:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.6\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.5\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.4\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}}}}}s:24:\"avalara_q3-2023_noAvaTax\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"avalara_q3-2023_noAvaTax\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:40:\"Automatically calculate VAT in real time\";s:7:\"content\";s:284:\"Take the effort out of determining tax rates and sell confidently across borders with automated tax management from Avalara AvaTax— including built-in VAT calculation when you sell into or across the EU and UK. Save time and stay compliant when you let Avalara do the heavy lifting.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"avalara_q3-2023_noAvaTax\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Automate my sales tax\";}}s:3:\"url\";s:131:\"https://woocommerce.com/products/woocommerce-avatax/?utm_source=inbox_note&utm_medium=product&utm_campaign=avalara_q3-2023_noAvaTax\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-08 22:32:23\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-08-09 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-avatax\";}}}}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:30;}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:20:\"total_payments_value\";s:9:\"timeframe\";s:9:\"last_year\";s:5:\"value\";i:100;s:9:\"operation\";s:1:\">\";}}}s:44:\"woocommerce-usermeta-Sept2023-productvendors\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"woocommerce-usermeta-Sept2023-productvendors\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:37:\"Your store requires a security update\";s:7:\"content\";s:339:\"<strong>Your shop needs an update to address a vulnerability in WooCommerce.</strong> The fix was released on Sept 15. Please update WooCommerce to the latest version immediately. <a href=\"https://developer.woocommerce.com/2023/09/16/woocommerce-vulnerability-reintroduced-from-7-0-1/\" />Read our developer update</a> for more information.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:44:\"woocommerce-usermeta-Sept2023-productvendors\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:11:\"plugins.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-09-20 00:50:07\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-product-vendors\";}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"8.1.1\";}}}s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Security update for WooCommerce Stripe Gateway\";s:7:\"content\";s:201:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce Stripe Gateway</strong>. The fix for this vulnerability was released on October 17. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:15:\"update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:36:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-10-18 00:01:58\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"4.5.4\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.6\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.5.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.6.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.8.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.9.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.0.2\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.1.2\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.2.2\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.3.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.4.6\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.5.4\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.6.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.5.4\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.6.3\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.7.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.8.3\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.9.3\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.0.5\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.1.3\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.2.3\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.3.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.4.3\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.5.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"7.6.1\";}}}s:29:\"amazon-mcf-reviews-2023-12-07\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"amazon-mcf-reviews-2023-12-07\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:36:\"Enjoying Amazon MCF for WooCommerce?\";s:7:\"content\";s:292:\"We\'re Never Settle, the developers behind Amazon MCF for WooCommerce, and would be deeply honored to have your review. Reviews help immensely as other users can learn how MCF can solve their needs too! Not happy or need help? Please reach out for support and we’d love to make things right!\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"amazon-mcf-review-button-2023-12-07\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Leave a review\";}}s:3:\"url\";s:161:\"https://woocommerce.com/products/woocommerce-amazon-fulfillment/?review&utm_source=inbox_note&utm_medium=product&utm_campaign=amazon-mcf-review-button-2023-12-07\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:36:\"amazon-mcf-support-button-2023-12-07\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Request support\";}}s:3:\"url\";s:142:\"https://woocommerce.com/my-account/contact-support/?utm_source=inbox_note&utm_medium=product&utm_campaign=amazon-mcf-support-button-2023-12-07\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-12-06 15:21:27\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:30:\"woocommerce-amazon-fulfillment\";}}}}s:30:\"remove_estimated_deposits_2024\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"remove_estimated_deposits_2024\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:33:\"Estimated deposits are going away\";s:7:\"content\";s:267:\"To provide more accurate deposit information and support the expansion of instant deposits, estimated deposit details will no longer be available in WooPayments. We recommend upgrading to the latest version of WooPayments for more detailed balance status information.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:9:\"view_docs\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:29:\"Learn about Deposit schedules\";}}s:3:\"url\";s:151:\"https://woocommerce.com/document/woopayments/deposits/deposit-schedule/?utm_source=inbox_note&utm_medium=product&utm_campaign=view_docs#available-funds\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:3:\"6.9\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2024-01-21 08:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2024-01-31 23:59:59\";}}}s:26:\"sirt-woo-2024-11-xss-admin\";O:8:\"stdClass\":8:{s:4:\"slug\";s:26:\"sirt-woo-2024-11-xss-admin\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"An important update is required for WooCommerce\";s:7:\"content\";s:353:\"This update addresses a security vulnerability that could allow unauthorized access to administrative privileges on your site. <a href=\"https://developer.woocommerce.com/2024/12/03/woocommerce-9-4-3-and-woocommerce-9-3-4-available-now/\">Learn more</a>.\r\n<br><br>\r\n<strong>Please ensure your site is updated to the latest version to stay secure.</strong>\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:26:\"sirt-woo-2024-11-xss-admin\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"update-core.php?\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:26:\"sirt-woo-2024-11-xss-admin\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2024-12-04 02:07:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"WooCommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"8.4.0\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"WooCommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"9.4.3\";}}}s:44:\"paypal-braintree-sdk-depreciation-2025-02-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"paypal-braintree-sdk-depreciation-2025-02-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:51:\"Update required for your PayPal Braintree extension\";s:7:\"content\";s:253:\"To continue securely accepting payments, you must update your PayPal Braintree extension to version 3.2.4 or newer before June 30, 2025. Your current extension version will not support payment processing after this date due to an SSL certificate update.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:51:\"paypal-braintree-sdk-depreciation-2025-02-20-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Upgrade now\";}}s:3:\"url\";s:21:\"/wp-admin/plugins.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2025-03-03 19:49:10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:47:\"woocommerce-gateway-paypal-powered-by-braintree\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"3.2.3\";}}}s:24:\"uk-vat-notice-2025-04-30\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"uk-vat-notice-2025-04-30\";s:4:\"type\";s:7:\"warning\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:38:\"UK VAT numbers are no longer supported\";s:7:\"content\";s:322:\"Due to recent HM Revenue &amp; Customs (HMRC) VAT API changes, your EU VAT Number for WooCommerce extension can no longer validate UK VAT numbers. HMRC now requires merchants to register an API key, which this extension does not currently support. We recommend EU/UK VAT Validation Manager for WooCommerce as a replacement\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:31:\"uk-vat-notice-button-2025-04-30\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:31:\"Learn more about this extension\";}}s:3:\"url\";s:53:\"https://wordpress.org/plugins/eu-vat-for-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:25:\"woocommerce-eu-vat-number\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2025-05-05 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2025-05-15 00:00:00\";}}}s:22:\"payson-retirement-2025\";O:8:\"stdClass\":8:{s:4:\"slug\";s:22:\"payson-retirement-2025\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:22:\"Payson Form Retirement\";s:7:\"content\";s:208:\"Svea Bank is discontinuing the Payson service; the last date for transactions is August 31, 2025. As a result, the Payson Form extension has been removed from WooCommerce.com. Documentation remains available.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:22:\"payson-retirement-2025\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:35:\"Explore alternative payment methods\";}}s:3:\"url\";s:218:\"https://woocommerce.com/product-category/woocommerce-extensions/payment-gateways/?categoryIds=28680&collections=product&page=1&country=Sweden&utm_source=inbox_note&utm_medium=product&utm_campaign=payson-retirement-2025\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2025-05-13 01:35:31\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2025-12-31 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-payson\";}}}}s:44:\"paypal-braintree-sdk-depreciation-2025-05-30\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"paypal-braintree-sdk-depreciation-2025-05-30\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:54:\"Action required: Update the PayPal Braintree extension\";s:7:\"content\";s:228:\"Your PayPal Braintree extension is using an outdated SDK and will stop processing payments after June 30, 2025, due to a root SSL certificate expiration. To avoid service disruption, update to version 3.2.4 or newer immediately.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:51:\"paypal-braintree-sdk-depreciation-2025-05-30-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Update now\";}}s:3:\"url\";s:21:\"/wp-admin/plugins.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2025-05-29 17:56:45\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:47:\"woocommerce-gateway-paypal-powered-by-braintree\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"3.2.3\";}}}s:31:\"paypal-carding-recaptcha-dec-25\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"paypal-carding-recaptcha-dec-25\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:32:\"Activate PayPal fraud management\";s:7:\"content\";s:165:\"PayPal detected increased suspicious card activity in market. Please enable fraud protection in your PayPal Payment settings by enabling CAPTCHA for PayPal Payments.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:18:\"setup-instructions\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"Setup Instructions\";}}s:3:\"url\";s:163:\"https://woocommerce.com/document/woocommerce-paypal-payments/fraud-and-disputes/?utm_source=inbox_note&utm_medium=product&utm_campaign=setup-instructions#section-4\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:12:\"activate-now\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:12:\"Activate Now\";}}s:3:\"url\";s:65:\"admin.php?page=wc-settings&tab=integration&section=ppcp-recaptcha\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2025-12-04 01:54:34\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2026-01-30 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:27:\"woocommerce-paypal-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"3.3.0\";}i:4;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:35:\"woocommerce_ppcp-recaptcha_settings\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:9:\"operation\";s:2:\"!=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";s:2:\"no\";}}}s:35:\"WC10.4.3-security-update-12-22-2025\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"WC10.4.3-security-update-12-22-2025\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"An important update is required for WooCommerce\";s:7:\"content\";s:396:\"<strong>Please update to WooCommerce 10.4.3 to resolve a security issue.</strong> This update addresses an issue with the WooCommerce Store API that may have made guest order information visible to other logged in users. See the <a href=\"https://developer.woocommerce.com/2025/12/22/store-api-vulnerability-patched-in-woocommerce-8-1/\" target=\"_blank\">Woo Developer blog</a> for more information.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"WC10.4.3-security-update-12-22-2025\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"update-core.php?\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2025-12-22 18:33:12\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2025-12-29 16:00:00\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"WooCommerce\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"8.1.0\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"WooCommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:6:\"10.4.2\";}}}}}", "off");
INSERT INTO `wp_options` VALUES("43434", "_transient_timeout_as-post-store-dependencies-met", "1766833760", "off");
INSERT INTO `wp_options` VALUES("43435", "_transient_as-post-store-dependencies-met", "yes", "off");
INSERT INTO `wp_options` VALUES("43444", "_transient_timeout__woocommerce_upload_directory_status", "1766833773", "off");
INSERT INTO `wp_options` VALUES("43445", "_transient__woocommerce_upload_directory_status", "protected", "off");
INSERT INTO `wp_options` VALUES("43447", "_transient_timeout_woocommerce_admin_payment_gateway_suggestions_specs", "1767352176", "off");
INSERT INTO `wp_options` VALUES("43448", "_transient_woocommerce_admin_payment_gateway_suggestions_specs", "a:1:{s:5:\"fa_IR\";a:24:{s:6:\"affirm\";O:8:\"stdClass\":11:{s:2:\"id\";s:6:\"affirm\";s:5:\"title\";s:6:\"Affirm\";s:7:\"content\";s:169:\"Affirm’s tailored Buy Now Pay Later programs remove price as a barrier, turning browsers into buyers, increasing average order value, and expanding your customer base.\";s:5:\"image\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/affirm.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/affirm.png\";s:7:\"plugins\";a:0:{}s:13:\"external_link\";s:59:\"https://woocommerce.com/products/woocommerce-gateway-affirm\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"6.5.0-dev\";s:8:\"operator\";s:2:\">=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:1:\"<\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:2:{i:0;s:2:\"US\";i:1;s:2:\"CA\";}s:23:\"recommendation_priority\";i:7;}s:8:\"afterpay\";O:8:\"stdClass\":10:{s:2:\"id\";s:8:\"afterpay\";s:5:\"title\";s:8:\"Afterpay\";s:7:\"content\";s:125:\"Afterpay allows customers to receive products immediately and pay for purchases over four installments, always interest-free.\";s:5:\"image\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/afterpay.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/afterpay.png\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"6.5.0-dev\";s:8:\"operator\";s:2:\">=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:1:\"<\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:3:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"AU\";}s:23:\"recommendation_priority\";i:8;}s:14:\"airwallex_main\";O:8:\"stdClass\":11:{s:2:\"id\";s:14:\"airwallex_main\";s:5:\"title\";s:18:\"Airwallex Payments\";s:7:\"content\";s:115:\"Boost international sales and save on FX fees. Accept 60+ local payment methods including Apple Pay and Google Pay.\";s:5:\"image\";s:105:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/airwallex.png\";s:11:\"image_72x72\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/airwallex.png\";s:12:\"square_image\";s:112:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/airwallex-square.png\";s:7:\"plugins\";a:1:{i:0;s:33:\"airwallex-online-payments-gateway\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:17:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CN\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"category_other\";a:17:{i:0;s:2:\"GB\";i:1;s:2:\"AT\";i:2;s:2:\"BE\";i:3;s:2:\"EE\";i:4;s:2:\"FR\";i:5;s:2:\"DE\";i:6;s:2:\"GR\";i:7;s:2:\"IE\";i:8;s:2:\"IT\";i:9;s:2:\"NL\";i:10;s:2:\"PL\";i:11;s:2:\"PT\";i:12;s:2:\"AU\";i:13;s:2:\"NZ\";i:14;s:2:\"HK\";i:15;s:2:\"SG\";i:16;s:2:\"CN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:24:\"amazon_payments_advanced\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"amazon_payments_advanced\";s:5:\"title\";s:10:\"Amazon Pay\";s:7:\"content\";s:94:\"Enable a familiar, fast checkout for hundreds of millions of active Amazon customers globally.\";s:5:\"image\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/amazonpay.png\";s:11:\"image_72x72\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/amazonpay.png\";s:7:\"plugins\";a:1:{i:0;s:44:\"woocommerce-gateway-amazon-payments-advanced\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:18:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"6.5.0-dev\";s:8:\"operator\";s:2:\">=\";}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:18:{i:0;s:2:\"US\";i:1;s:2:\"AT\";i:2;s:2:\"BE\";i:3;s:2:\"CY\";i:4;s:2:\"DK\";i:5;s:2:\"ES\";i:6;s:2:\"FR\";i:7;s:2:\"DE\";i:8;s:2:\"GB\";i:9;s:2:\"HU\";i:10;s:2:\"IE\";i:11;s:2:\"IT\";i:12;s:2:\"LU\";i:13;s:2:\"NL\";i:14;s:2:\"PT\";i:15;s:2:\"SL\";i:16;s:2:\"SE\";i:17;s:2:\"JP\";}s:23:\"recommendation_priority\";i:6;}s:4:\"bacs\";O:8:\"stdClass\":8:{s:2:\"id\";s:4:\"bacs\";s:5:\"title\";s:20:\"Direct bank transfer\";s:7:\"content\";s:32:\"Take payments via bank transfer.\";s:5:\"image\";s:100:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/bacs.svg\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/bacs.png\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":1:{s:4:\"type\";s:4:\"pass\";}}s:10:\"is_offline\";b:1;s:23:\"recommendation_priority\";i:10;}s:3:\"cod\";O:8:\"stdClass\":8:{s:2:\"id\";s:3:\"cod\";s:5:\"title\";s:16:\"Cash on delivery\";s:7:\"content\";s:36:\"Take payments in cash upon delivery.\";s:5:\"image\";s:99:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/cod.svg\";s:11:\"image_72x72\";s:105:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/cod.png\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":1:{s:4:\"type\";s:4:\"pass\";}}s:10:\"is_offline\";b:1;s:23:\"recommendation_priority\";i:10;}s:4:\"eway\";O:8:\"stdClass\":11:{s:2:\"id\";s:4:\"eway\";s:5:\"title\";s:4:\"Eway\";s:7:\"content\";s:171:\"The Eway extension for WooCommerce allows you to take credit card payments directly on your store without redirecting your customers to a third party site to make payment.\";s:5:\"image\";s:100:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/eway.png\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/eway.png\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/eway-square.png\";s:7:\"plugins\";a:1:{i:0;s:24:\"woocommerce-gateway-eway\";}s:10:\"is_visible\";b:0;s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:3:\"kco\";O:8:\"stdClass\":10:{s:2:\"id\";s:3:\"kco\";s:5:\"title\";s:15:\"Klarna Checkout\";s:7:\"content\";s:115:\"Choose the payment that you want, pay now, pay later or slice it. No credit card numbers, no passwords, no worries.\";s:5:\"image\";s:85:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/klarna-black.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/klarna.png\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-checkout-for-woocommerce\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:3:{i:0;s:2:\"NO\";i:1;s:2:\"SE\";i:2;s:2:\"FI\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:15:\"klarna_payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:15:\"klarna_payments\";s:5:\"title\";s:15:\"Klarna Payments\";s:7:\"content\";s:115:\"Choose the payment that you want, pay now, pay later or slice it. No credit card numbers, no passwords, no worries.\";s:5:\"image\";s:85:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/klarna-black.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/klarna.png\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:19:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:1:\"<\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:19:{i:0;s:2:\"MX\";i:1;s:2:\"US\";i:2;s:2:\"CA\";i:3;s:2:\"AT\";i:4;s:2:\"BE\";i:5;s:2:\"CH\";i:6;s:2:\"DK\";i:7;s:2:\"ES\";i:8;s:2:\"FI\";i:9;s:2:\"FR\";i:10;s:2:\"DE\";i:11;s:2:\"GB\";i:12;s:2:\"IT\";i:13;s:2:\"NL\";i:14;s:2:\"NO\";i:15;s:2:\"PL\";i:16;s:2:\"SE\";i:17;s:2:\"NZ\";i:18;s:2:\"AU\";}s:23:\"recommendation_priority\";i:9;}s:30:\"mollie_wc_gateway_banktransfer\";O:8:\"stdClass\":11:{s:2:\"id\";s:30:\"mollie_wc_gateway_banktransfer\";s:5:\"title\";s:6:\"Mollie\";s:7:\"content\";s:128:\"Effortless payments by Mollie: Offer global and local payment methods, get onboarded in minutes, and supported in your language.\";s:5:\"image\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/mollie.svg\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/mollie.png\";s:12:\"square_image\";s:109:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/mollie-square.png\";s:7:\"plugins\";a:1:{i:0;s:31:\"mollie-payments-for-woocommerce\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"category_other\";a:11:{i:0;s:2:\"AT\";i:1;s:2:\"BE\";i:2;s:2:\"CH\";i:3;s:2:\"ES\";i:4;s:2:\"FI\";i:5;s:2:\"FR\";i:6;s:2:\"DE\";i:7;s:2:\"GB\";i:8;s:2:\"IT\";i:9;s:2:\"NL\";i:10;s:2:\"PL\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:7:\"payfast\";O:8:\"stdClass\":10:{s:2:\"id\";s:7:\"payfast\";s:5:\"title\";s:7:\"Payfast\";s:7:\"content\";s:299:\"The Payfast extension for WooCommerce enables you to accept payments by Credit Card and EFT via one of South Africa’s most popular payment gateways. No setup fees or monthly subscription costs. Selecting this extension will configure your store to use South African rands as the selected currency.\";s:5:\"image\";s:80:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/payfast.png\";s:11:\"image_72x72\";s:109:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/payfast.png\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-payfast-gateway\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ZA\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:1:{i:0;s:2:\"ZA\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:17:\"payoneer-checkout\";O:8:\"stdClass\":10:{s:2:\"id\";s:17:\"payoneer-checkout\";s:5:\"title\";s:17:\"Payoneer Checkout\";s:7:\"content\";s:202:\"Payoneer Checkout is the next generation of payment processing platforms, giving merchants around the world the solutions and direction they need to succeed in today’s hyper-competitive global market.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/payoneer.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/payoneer.png\";s:7:\"plugins\";a:1:{i:0;s:17:\"payoneer-checkout\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CN\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:2:{i:0;s:2:\"HK\";i:1;s:2:\"CN\";}s:23:\"recommendation_priority\";i:10;}s:8:\"paystack\";O:8:\"stdClass\":11:{s:2:\"id\";s:8:\"paystack\";s:5:\"title\";s:8:\"Paystack\";s:7:\"content\";s:127:\"Paystack helps African merchants accept one-time and recurring payments online with a modern, safe, and secure payment gateway.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/paystack.png\";s:12:\"square_image\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/paystack-square.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/paystack.png\";s:7:\"plugins\";a:1:{i:0;s:12:\"woo-paystack\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ZA\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GH\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NG\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:3:{i:0;s:2:\"ZA\";i:1;s:2:\"GH\";i:2;s:2:\"NG\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:7:\"payubiz\";O:8:\"stdClass\":10:{s:2:\"id\";s:7:\"payubiz\";s:5:\"title\";s:20:\"PayU for WooCommerce\";s:7:\"content\";s:169:\"Enable PayU’s exclusive plugin for WooCommerce to start accepting payments in 100+ payment methods available in India including credit cards, debit cards, UPI, & more!\";s:5:\"image\";s:100:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/payu.svg\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/payu.png\";s:7:\"plugins\";a:1:{i:0;s:10:\"payu-india\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:1:{i:0;s:2:\"IN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:12:\"ppcp-gateway\";O:8:\"stdClass\":11:{s:2:\"id\";s:12:\"ppcp-gateway\";s:5:\"title\";s:15:\"PayPal Payments\";s:7:\"content\";s:78:\"Safe and secure payments using credit cards or your customer\'s PayPal account.\";s:5:\"image\";s:79:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/paypal.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/paypal.png\";s:12:\"square_image\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/paypal.svg\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:49:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CL\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CO\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EC\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"UY\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"VE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SL\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CN\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ID\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:48:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"BR\";i:4;s:2:\"AR\";i:5;s:2:\"CL\";i:6;s:2:\"CO\";i:7;s:2:\"EC\";i:8;s:2:\"PE\";i:9;s:2:\"UY\";i:10;s:2:\"VE\";i:11;s:2:\"AT\";i:12;s:2:\"BE\";i:13;s:2:\"BG\";i:14;s:2:\"HR\";i:15;s:2:\"CH\";i:16;s:2:\"CY\";i:17;s:2:\"CZ\";i:18;s:2:\"DK\";i:19;s:2:\"EE\";i:20;s:2:\"ES\";i:21;s:2:\"FI\";i:22;s:2:\"FR\";i:23;s:2:\"DE\";i:24;s:2:\"GB\";i:25;s:2:\"GR\";i:26;s:2:\"HU\";i:27;s:2:\"IE\";i:28;s:2:\"IT\";i:29;s:2:\"LV\";i:30;s:2:\"LT\";i:31;s:2:\"LU\";i:32;s:2:\"MT\";i:33;s:2:\"NL\";i:34;s:2:\"NO\";i:35;s:2:\"PL\";i:36;s:2:\"PT\";i:37;s:2:\"RO\";i:38;s:2:\"SK\";i:39;s:2:\"SL\";i:40;s:2:\"SE\";i:41;s:2:\"AU\";i:42;s:2:\"NZ\";i:43;s:2:\"HK\";i:44;s:2:\"JP\";i:45;s:2:\"SG\";i:46;s:2:\"CN\";i:47;s:2:\"ID\";}s:19:\"category_additional\";a:49:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"BR\";i:4;s:2:\"AR\";i:5;s:2:\"CL\";i:6;s:2:\"CO\";i:7;s:2:\"EC\";i:8;s:2:\"PE\";i:9;s:2:\"UY\";i:10;s:2:\"VE\";i:11;s:2:\"AT\";i:12;s:2:\"BE\";i:13;s:2:\"BG\";i:14;s:2:\"HR\";i:15;s:2:\"CH\";i:16;s:2:\"CY\";i:17;s:2:\"CZ\";i:18;s:2:\"DK\";i:19;s:2:\"EE\";i:20;s:2:\"ES\";i:21;s:2:\"FI\";i:22;s:2:\"FR\";i:23;s:2:\"DE\";i:24;s:2:\"GB\";i:25;s:2:\"GR\";i:26;s:2:\"HU\";i:27;s:2:\"IE\";i:28;s:2:\"IT\";i:29;s:2:\"LV\";i:30;s:2:\"LT\";i:31;s:2:\"LU\";i:32;s:2:\"MT\";i:33;s:2:\"NL\";i:34;s:2:\"NO\";i:35;s:2:\"PL\";i:36;s:2:\"PT\";i:37;s:2:\"RO\";i:38;s:2:\"SK\";i:39;s:2:\"SL\";i:40;s:2:\"SE\";i:41;s:2:\"AU\";i:42;s:2:\"NZ\";i:43;s:2:\"HK\";i:44;s:2:\"JP\";i:45;s:2:\"SG\";i:46;s:2:\"CN\";i:47;s:2:\"ID\";i:48;s:2:\"IN\";}s:23:\"recommendation_priority\";i:4;}s:8:\"razorpay\";O:8:\"stdClass\":10:{s:2:\"id\";s:8:\"razorpay\";s:5:\"title\";s:8:\"Razorpay\";s:7:\"content\";s:133:\"The official Razorpay extension for WooCommerce allows you to accept credit cards, debit cards, netbanking, wallet, and UPI payments.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/razorpay.svg\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/razorpay.png\";s:7:\"plugins\";a:1:{i:0;s:12:\"woo-razorpay\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:1:{i:0;s:2:\"IN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:18:\"square_credit_card\";O:8:\"stdClass\":10:{s:2:\"id\";s:18:\"square_credit_card\";s:5:\"title\";s:6:\"Square\";s:7:\"content\";s:169:\"Securely accept credit and debit cards with one low rate, no surprise fees (custom rates available). Sell online and in store and track sales and inventory in one place.\";s:5:\"image\";s:85:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/square-black.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/square.png\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-square\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}i:1;a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:8:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:14:\"selling_venues\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:12:\"brick-mortar\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:14:\"selling_venues\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:18:\"brick-mortar-other\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:21:\"selling_online_answer\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:21:\"no_im_selling_offline\";s:7:\"default\";s:0:\"\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:21:\"selling_online_answer\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:34:\"im_selling_both_online_and_offline\";s:7:\"default\";s:0:\"\";}}}}}}}}}s:14:\"category_other\";a:8:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"IE\";i:3;s:2:\"ES\";i:4;s:2:\"FR\";i:5;s:2:\"GB\";i:6;s:2:\"AU\";i:7;s:2:\"JP\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:5;}s:6:\"stripe\";O:8:\"stdClass\":11:{s:2:\"id\";s:6:\"stripe\";s:5:\"title\";s:6:\"Stripe\";s:7:\"content\";s:112:\"Accept debit and credit cards in 135+ currencies, methods such as Alipay, and one-touch checkout with Apple Pay.\";s:5:\"image\";s:79:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/stripe.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/stripe.png\";s:12:\"square_image\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/stripe.svg\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:40:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SL\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ID\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:40:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"BR\";i:4;s:2:\"AT\";i:5;s:2:\"BE\";i:6;s:2:\"BG\";i:7;s:2:\"CH\";i:8;s:2:\"CY\";i:9;s:2:\"CZ\";i:10;s:2:\"DK\";i:11;s:2:\"EE\";i:12;s:2:\"ES\";i:13;s:2:\"FI\";i:14;s:2:\"FR\";i:15;s:2:\"DE\";i:16;s:2:\"GB\";i:17;s:2:\"GR\";i:18;s:2:\"HU\";i:19;s:2:\"IE\";i:20;s:2:\"IT\";i:21;s:2:\"LV\";i:22;s:2:\"LT\";i:23;s:2:\"LU\";i:24;s:2:\"MT\";i:25;s:2:\"NL\";i:26;s:2:\"NO\";i:27;s:2:\"PL\";i:28;s:2:\"PT\";i:29;s:2:\"RO\";i:30;s:2:\"SK\";i:31;s:2:\"SL\";i:32;s:2:\"SE\";i:33;s:2:\"AU\";i:34;s:2:\"NZ\";i:35;s:2:\"HK\";i:36;s:2:\"JP\";i:37;s:2:\"SG\";i:38;s:2:\"ID\";i:39;s:2:\"IN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:3;}s:23:\"woo-mercado-pago-custom\";O:8:\"stdClass\":11:{s:2:\"id\";s:23:\"woo-mercado-pago-custom\";s:5:\"title\";s:12:\"Mercado Pago\";s:7:\"content\";s:198:\"Set up your payment methods and accept credit and debit cards, cash, bank transfers and money from your Mercado Pago account. Offer safe and secure payments with Latin America’s leading processor.\";s:5:\"image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/mercadopago.png\";s:11:\"image_72x72\";s:113:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/mercadopago.png\";s:7:\"plugins\";a:1:{i:0;s:23:\"woocommerce-mercadopago\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:8:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AR\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CL\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CO\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EC\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"UY\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}}}}s:16:\"is_local_partner\";b:1;s:14:\"category_other\";a:8:{i:0;s:2:\"AR\";i:1;s:2:\"CL\";i:2;s:2:\"CO\";i:3;s:2:\"EC\";i:4;s:2:\"PE\";i:5;s:2:\"UY\";i:6;s:2:\"MX\";i:7;s:2:\"BR\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:20:\"woocommerce_payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:20:\"woocommerce_payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:84:\"Manage transactions without leaving your WordPress Dashboard. Only with WooPayments.\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:11:\"image_72x72\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:11:\"description\";s:225:\"With WooPayments, you can securely accept major cards, Apple Pay, and payments in over 100 currencies. Track cash flow and manage recurring revenue directly from your store’s dashboard - with no setup costs or monthly fees.\";s:10:\"is_visible\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"5.10.0-dev\";s:8:\"operator\";s:1:\"<\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:17:\"woocommerce-admin\";}}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:7:\"version\";s:9:\"2.9.0-dev\";s:8:\"operator\";s:1:\"<\";}}}}s:23:\"recommendation_priority\";i:2;}s:47:\"woocommerce_payments:without-in-person-payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:47:\"woocommerce_payments:without-in-person-payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:84:\"Manage transactions without leaving your WordPress Dashboard. Only with WooPayments.\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:11:\"image_72x72\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:11:\"description\";s:225:\"With WooPayments, you can securely accept major cards, Apple Pay, and payments in over 100 currencies. Track cash flow and manage recurring revenue directly from your store’s dashboard - with no setup costs or monthly fees.\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:37:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:7:\"version\";s:9:\"2.9.0-dev\";s:8:\"operator\";s:2:\">=\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"5.10.0-dev\";s:8:\"operator\";s:2:\">=\";}}}}s:23:\"recommendation_priority\";i:1;}s:44:\"woocommerce_payments:with-in-person-payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:44:\"woocommerce_payments:with-in-person-payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:84:\"Manage transactions without leaving your WordPress Dashboard. Only with WooPayments.\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:11:\"image_72x72\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:11:\"description\";s:212:\"With WooPayments, you can securely accept major cards, Apple Pay, and payments in over 100 currencies – with no setup costs or monthly fees – and you can now accept in-person payments with the Woo mobile app.\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:7:\"version\";s:9:\"2.9.0-dev\";s:8:\"operator\";s:2:\">=\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"5.10.0-dev\";s:8:\"operator\";s:2:\">=\";}}}}s:23:\"recommendation_priority\";i:0;}s:25:\"woocommerce_payments:bnpl\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"woocommerce_payments:bnpl\";s:5:\"title\";s:38:\"Activate BNPL instantly on WooPayments\";s:7:\"content\";s:185:\"The world’s favorite buy now, pay later options and many more are right at your fingertips with WooPayments — all from one dashboard, without needing multiple extensions and logins.\";s:5:\"image\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay-bnpl.svg\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay-bnpl.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:10:\"is_visible\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:18:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:2:\">=\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}i:4;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}s:23:\"recommendation_priority\";i:10;}s:8:\"zipmoney\";O:8:\"stdClass\":10:{s:2:\"id\";s:8:\"zipmoney\";s:5:\"title\";s:27:\"Zip Co - Buy Now, Pay Later\";s:7:\"content\";s:84:\"Give your customers the power to pay later, interest free and watch your sales grow.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/zipmoney.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/zipmoney.png\";s:7:\"plugins\";a:1:{i:0;s:29:\"zipmoney-payments-woocommerce\";}s:10:\"is_visible\";b:0;s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}}}", "off");
INSERT INTO `wp_options` VALUES("43451", "_transient_timeout_woocommerce_marketplace_promotions_v2", "1766834074", "off");
INSERT INTO `wp_options` VALUES("43452", "_transient_woocommerce_marketplace_promotions_v2", "a:2:{s:6:\"notice\";a:8:{s:13:\"date_from_gmt\";s:16:\"2024-11-17 00:00\";s:11:\"date_to_gmt\";s:16:\"2024-11-20 23:59\";s:6:\"format\";s:6:\"notice\";s:5:\"style\";s:4:\"info\";s:5:\"pages\";a:5:{i:0;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:0:\"\";s:4:\"name\";s:8:\"Discover\";}i:1;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:10:\"extensions\";s:4:\"name\";s:6:\"Browse\";}i:2;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:6:\"themes\";s:4:\"name\";s:6:\"Themes\";}i:3;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:17:\"business-services\";s:4:\"name\";s:17:\"Business Services\";}i:4;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:16:\"my-subscriptions\";s:4:\"name\";s:16:\"My Subscriptions\";}}s:7:\"content\";a:1:{s:5:\"en_US\";s:192:\"<strong>Save 40%</strong> in the WooCommerce Marketplace sale. Offer ends December 3 at 3 pm UTC. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&amp;Cs</a> apply.\";}s:4:\"icon\";s:7:\"percent\";s:14:\"is_dismissible\";b:1;}s:6:\"promos\";a:4:{i:0;a:9:{s:13:\"date_from_gmt\";s:16:\"2025-11-26 14:15\";s:11:\"date_to_gmt\";s:16:\"2025-12-02 13:59\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"path\";s:0:\"\";s:8:\"pathname\";s:33:\"/wp-admin/admin.php?page=wc-admin\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:13:\"Shop the sale\";}s:8:\"cta_link\";s:52:\"/wp-admin/admin.php?page=wc-admin&path=%2Fextensions\";s:7:\"content\";a:1:{s:5:\"en_US\";s:240:\"Save up to 40% on themes and extensions in the WooCommerce Marketplace until December 2 at 14:00 UTC. <strong>Coupon applied at checkout.</strong> <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&C</a>’s apply.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:29:\"Black Friday savings are live\";}s:4:\"icon\";s:7:\"percent\";}i:1;a:9:{s:13:\"date_from_gmt\";s:16:\"2025-11-26 14:15\";s:11:\"date_to_gmt\";s:16:\"2025-12-02 13:59\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:10:\"/marketing\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:23:\"Level up your marketing\";}s:8:\"cta_link\";s:52:\"/wp-admin/admin.php?page=wc-admin&path=%2Fextensions\";s:7:\"content\";a:1:{s:5:\"en_US\";s:223:\"Save up to 40% in the Woo BFCM sale. <strong>Coupon applied at checkout.</strong> Offer ends December 2 at 14:00 UTC. T&Cs apply. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&C</a>’s apply.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:43:\"Take up to 40% off marketing tools and more\";}s:4:\"icon\";s:7:\"percent\";}i:2;a:10:{s:13:\"date_from_gmt\";s:16:\"2025-11-26 14:15\";s:11:\"date_to_gmt\";s:16:\"2025-12-02 13:59\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"path\";s:0:\"\";s:8:\"pathname\";s:40:\"/wp-admin/edit.php?post_type=shop_coupon\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:19:\"Upgrade your promos\";}s:8:\"cta_link\";s:52:\"/wp-admin/admin.php?page=wc-admin&path=%2Fextensions\";s:7:\"content\";a:1:{s:5:\"en_US\";s:211:\"Save up to 40% in the Woo BFCM sale. <strong>Coupon applied at checkout.</strong> Offer ends December 2 at 14:00 UTC. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&C</a>’s apply.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:46:\"Take up to 40% off coupon and promo extensions\";}s:5:\"style\";s:4:\"wide\";s:4:\"icon\";s:7:\"percent\";}i:3;a:10:{s:13:\"date_from_gmt\";s:16:\"2025-11-26 14:15\";s:11:\"date_to_gmt\";s:16:\"2025-12-02 13:59\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:13:\"Shop the sale\";}s:8:\"cta_link\";s:52:\"/wp-admin/admin.php?page=wc-admin&path=%2Fextensions\";s:7:\"content\";a:1:{s:5:\"en_US\";s:233:\"Take up to 40% off WooCommerce Marketplace products this BFCM. <strong>Coupon applied at checkout.</strong> Sale ends December 2 at 14:00 UTC. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&Cs</a> apply.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:39:\"Save up to 40% on your next big upgrade\";}s:5:\"style\";s:14:\"has-background\";s:4:\"icon\";s:7:\"percent\";}}}", "off");
INSERT INTO `wp_options` VALUES("43460", "duplicator_install_info", "a:3:{s:7:\"version\";s:8:\"1.5.11.2\";s:4:\"time\";i:1732288015;s:10:\"updateTime\";i:1766747387;}", "off");
INSERT INTO `wp_options` VALUES("43465", "_transient_timeout_last_fetch_patterns_request", "1766751002", "off");
INSERT INTO `wp_options` VALUES("43466", "_transient_last_fetch_patterns_request", "1766747402", "off");
INSERT INTO `wp_options` VALUES("43471", "woocommerce_order_stats_has_fulfillment_column", "no", "off");
INSERT INTO `wp_options` VALUES("43472", "woocommerce_address_autocomplete_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("43473", "woocommerce_pos_store_name", "لوله و پلی اتیلن میاناب", "on");
INSERT INTO `wp_options` VALUES("43474", "woocommerce_pos_store_address", "CA", "on");
INSERT INTO `wp_options` VALUES("43475", "woocommerce_pos_store_phone", "", "on");
INSERT INTO `wp_options` VALUES("43476", "woocommerce_pos_store_email", "mohammadrezabehdarvand@gmail.com", "on");
INSERT INTO `wp_options` VALUES("43477", "woocommerce_pos_refund_returns_policy", "", "on");
INSERT INTO `wp_options` VALUES("43478", "woocommerce_feature_point_of_sale_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("43479", "woocommerce_feature_mcp_integration_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("43480", "woocommerce_feature_destroy-empty-sessions_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("43481", "_site_transient_timeout_wp_theme_files_patterns-582d05b06d539a60cb60eac884429b98", "1766749207", "off");
INSERT INTO `wp_options` VALUES("43482", "_site_transient_wp_theme_files_patterns-582d05b06d539a60cb60eac884429b98", "a:2:{s:7:\"version\";s:0:\"\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("43483", "_transient_wc_attribute_taxonomies", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("43484", "woocommerce_attribute_lookup_enabled", "yes", "auto");
INSERT INTO `wp_options` VALUES("43485", "action_scheduler_migration_status", "complete", "auto");
INSERT INTO `wp_options` VALUES("43489", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:63:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.9.zip\";s:6:\"locale\";s:5:\"fa_IR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:63:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.9.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.9\";s:7:\"version\";s:3:\"6.9\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1766748025;s:15:\"version_checked\";s:3:\"6.9\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("43490", "_transient_timeout__woocommerce_helper_subscriptions", "1766748925", "off");
INSERT INTO `wp_options` VALUES("43491", "_transient__woocommerce_helper_subscriptions", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("43493", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1766748042;s:7:\"checked\";a:1:{s:22:\"mohammadrezabehdarvand\";s:0:\"\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("43495", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1766748041;s:8:\"response\";a:1:{s:35:\"redux-framework/redux-framework.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:29:\"w.org/plugins/redux-framework\";s:4:\"slug\";s:15:\"redux-framework\";s:6:\"plugin\";s:35:\"redux-framework/redux-framework.php\";s:11:\"new_version\";s:5:\"4.5.9\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/redux-framework/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/redux-framework.4.5.9.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:60:\"https://ps.w.org/redux-framework/assets/icon.svg?rev=2889347\";s:3:\"svg\";s:60:\"https://ps.w.org/redux-framework/assets/icon.svg?rev=2889347\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:70:\"https://ps.w.org/redux-framework/assets/banner-772x250.png?rev=2889347\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:7:{s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"6.1.4\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.1.4.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.7\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.5.14\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.5.14.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}s:30:\"seo-by-rank-math/rank-math.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:30:\"w.org/plugins/seo-by-rank-math\";s:4:\"slug\";s:16:\"seo-by-rank-math\";s:6:\"plugin\";s:30:\"seo-by-rank-math/rank-math.php\";s:11:\"new_version\";s:7:\"1.0.260\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/seo-by-rank-math/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/seo-by-rank-math.1.0.260.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:61:\"https://ps.w.org/seo-by-rank-math/assets/icon.svg?rev=3218327\";s:3:\"svg\";s:61:\"https://ps.w.org/seo-by-rank-math/assets/icon.svg?rev=3218327\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/seo-by-rank-math/assets/banner-1544x500.png?rev=2639678\";s:2:\"1x\";s:71:\"https://ps.w.org/seo-by-rank-math/assets/banner-772x250.png?rev=2639678\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.3\";}s:25:\"tablepress/tablepress.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/tablepress\";s:4:\"slug\";s:10:\"tablepress\";s:6:\"plugin\";s:25:\"tablepress/tablepress.php\";s:11:\"new_version\";s:5:\"3.2.6\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/tablepress/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/tablepress.3.2.6.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:55:\"https://ps.w.org/tablepress/assets/icon.svg?rev=3192944\";s:3:\"svg\";s:55:\"https://ps.w.org/tablepress/assets/icon.svg?rev=3192944\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/tablepress/assets/banner-1544x500.png?rev=3192944\";s:2:\"1x\";s:65:\"https://ps.w.org/tablepress/assets/banner-772x250.png?rev=3192944\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/tablepress/assets/banner-1544x500-rtl.png?rev=3192944\";s:2:\"1x\";s:69:\"https://ps.w.org/tablepress/assets/banner-772x250-rtl.png?rev=3192944\";}s:8:\"requires\";s:3:\"6.2\";}s:35:\"taxonomy-images/taxonomy-images.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/taxonomy-images\";s:4:\"slug\";s:15:\"taxonomy-images\";s:6:\"plugin\";s:35:\"taxonomy-images/taxonomy-images.php\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/taxonomy-images/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/taxonomy-images.1.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/taxonomy-images/assets/icon-256x256.png?rev=1283547\";s:2:\"1x\";s:68:\"https://ps.w.org/taxonomy-images/assets/icon-128x128.png?rev=1283547\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/taxonomy-images/assets/banner-1544x500.png?rev=1288553\";s:2:\"1x\";s:70:\"https://ps.w.org/taxonomy-images/assets/banner-772x250.png?rev=1288553\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.4\";}s:37:\"user-role-editor/user-role-editor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:30:\"w.org/plugins/user-role-editor\";s:4:\"slug\";s:16:\"user-role-editor\";s:6:\"plugin\";s:37:\"user-role-editor/user-role-editor.php\";s:11:\"new_version\";s:6:\"4.64.6\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/user-role-editor/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/user-role-editor.4.64.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/user-role-editor/assets/icon-256x256.jpg?rev=1020390\";s:2:\"1x\";s:69:\"https://ps.w.org/user-role-editor/assets/icon-128x128.jpg?rev=1020390\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:71:\"https://ps.w.org/user-role-editor/assets/banner-772x250.png?rev=1263116\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.4\";}s:27:\"woocommerce/woocommerce.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:6:\"plugin\";s:27:\"woocommerce/woocommerce.php\";s:11:\"new_version\";s:6:\"10.4.3\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/woocommerce/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.4.3.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:56:\"https://ps.w.org/woocommerce/assets/icon.svg?rev=3234504\";s:3:\"svg\";s:56:\"https://ps.w.org/woocommerce/assets/icon.svg?rev=3234504\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/woocommerce/assets/banner-1544x500.png?rev=3234504\";s:2:\"1x\";s:66:\"https://ps.w.org/woocommerce/assets/banner-772x250.png?rev=3234504\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.8\";}}s:7:\"checked\";a:8:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"6.1.4\";s:25:\"duplicator/duplicator.php\";s:6:\"1.5.14\";s:30:\"seo-by-rank-math/rank-math.php\";s:7:\"1.0.260\";s:35:\"redux-framework/redux-framework.php\";s:5:\"4.5.7\";s:25:\"tablepress/tablepress.php\";s:5:\"3.2.6\";s:35:\"taxonomy-images/taxonomy-images.php\";s:3:\"1.0\";s:37:\"user-role-editor/user-role-editor.php\";s:6:\"4.64.6\";s:27:\"woocommerce/woocommerce.php\";s:6:\"10.4.3\";}}", "off");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("3", "6", "_form", "<label> Your name\n    [text* your-name autocomplete:name] </label>\n\n<label> Your email\n    [email* your-email autocomplete:email] </label>\n\n<label> Subject\n    [text* your-subject] </label>\n\n<label> Your message (optional)\n    [textarea your-message] </label>\n\n[submit \"Submit\"]");
INSERT INTO `wp_postmeta` VALUES("4", "6", "_mail", "a:8:{s:7:\"subject\";s:30:\"[_site_title] \"[your-subject]\"\";s:6:\"sender\";s:48:\"[_site_title] <mohammadrezabehdarvand@gmail.com>\";s:4:\"body\";s:191:\"From: [your-name] [your-email]\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n-- \nThis is a notification that a contact form was submitted on your website ([_site_title] [_site_url]).\";s:9:\"recipient\";s:19:\"[_site_admin_email]\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("5", "6", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:30:\"[_site_title] \"[your-subject]\"\";s:6:\"sender\";s:48:\"[_site_title] <mohammadrezabehdarvand@gmail.com>\";s:4:\"body\";s:220:\"Message Body:\n[your-message]\n\n-- \nThis email is a receipt for your contact form submission on our website ([_site_title] [_site_url]) in which your email address was used. If that was not you, please ignore this message.\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:29:\"Reply-To: [_site_admin_email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("6", "6", "_messages", "a:12:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:27:\"Please fill out this field.\";s:16:\"invalid_too_long\";s:32:\"This field has a too long input.\";s:17:\"invalid_too_short\";s:33:\"This field has a too short input.\";s:13:\"upload_failed\";s:46:\"There was an unknown error uploading the file.\";s:24:\"upload_file_type_invalid\";s:49:\"You are not allowed to upload files of this type.\";s:21:\"upload_file_too_large\";s:31:\"The uploaded file is too large.\";s:23:\"upload_failed_php_error\";s:38:\"There was an error uploading the file.\";}");
INSERT INTO `wp_postmeta` VALUES("7", "6", "_additional_settings", "");
INSERT INTO `wp_postmeta` VALUES("8", "6", "_locale", "fa_IR");
INSERT INTO `wp_postmeta` VALUES("9", "6", "_hash", "1b68db3470073451d0cb425db30ff4acee4ac5ae");
INSERT INTO `wp_postmeta` VALUES("10", "7", "_wp_attached_file", "2024/11/معرفی-شرکت-میاناب.jpg");
INSERT INTO `wp_postmeta` VALUES("11", "7", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1646;s:6:\"height\";i:412;s:4:\"file\";s:44:\"2024/11/معرفی-شرکت-میاناب.jpg\";s:8:\"filesize\";i:108731;s:5:\"sizes\";a:3:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:44:\"معرفی-شرکت-میاناب-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18578;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:44:\"معرفی-شرکت-میاناب-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3366;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:44:\"معرفی-شرکت-میاناب-600x150.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22670;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("30", "10", "_wp_attached_file", "woocommerce-placeholder.png");
INSERT INTO `wp_postmeta` VALUES("31", "10", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:1200;s:4:\"file\";s:27:\"woocommerce-placeholder.png\";s:8:\"filesize\";i:48149;s:5:\"sizes\";a:3:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:35:\"woocommerce-placeholder-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12321;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:35:\"woocommerce-placeholder-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2330;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:35:\"woocommerce-placeholder-600x600.png\";s:5:\"width\";i:600;s:6:\"height\";i:600;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:38159;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("32", "16", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("33", "16", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("34", "16", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("35", "16", "switch-page-service-physical", "");
INSERT INTO `wp_postmeta` VALUES("36", "16", "repeater-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("37", "16", "title_field_accordion", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("38", "16", "editor-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("39", "16", "custom_text-the_excerpt-contact-service", "");
INSERT INTO `wp_postmeta` VALUES("40", "16", "media_text_the_excerpt-contact-service_send_pro", "");
INSERT INTO `wp_postmeta` VALUES("41", "16", "media_text_the_excerpt-contact-service_video", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("42", "16", "media_text_the_excerpt-contact-service_poster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("43", "16", "media_text_the_excerpt-contact-service_backgraound-one", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("44", "16", "media_text_the_excerpt-contact_title-service_short-code", "");
INSERT INTO `wp_postmeta` VALUES("45", "16", "media_text_the_excerpt-contact-service_short-code", "0");
INSERT INTO `wp_postmeta` VALUES("46", "16", "repeater-field-page-contact-repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("47", "16", "title_field_page-contact-repeater", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("48", "16", "editor_field_page-contact-repeater", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("49", "16", "media-text-page-contact-repeater", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("50", "16", "location_field_page-contact-repeater", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("51", "16", "_edit_lock", "1741982056:2");
INSERT INTO `wp_postmeta` VALUES("52", "18", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("53", "18", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("54", "18", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("55", "18", "switch-page-service-physical", "");
INSERT INTO `wp_postmeta` VALUES("56", "18", "repeater-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("57", "18", "title_field_accordion", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("58", "18", "editor-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("59", "18", "custom_text-the_excerpt-contact-service", "");
INSERT INTO `wp_postmeta` VALUES("60", "18", "media_text_the_excerpt-contact-service_send_pro", "");
INSERT INTO `wp_postmeta` VALUES("61", "18", "media_text_the_excerpt-contact-service_video", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("62", "18", "media_text_the_excerpt-contact-service_poster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("63", "18", "media_text_the_excerpt-contact-service_backgraound-one", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("64", "18", "media_text_the_excerpt-contact_title-service_short-code", "");
INSERT INTO `wp_postmeta` VALUES("65", "18", "media_text_the_excerpt-contact-service_short-code", "0");
INSERT INTO `wp_postmeta` VALUES("66", "18", "repeater-field-page-contact-repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("67", "18", "title_field_page-contact-repeater", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("68", "18", "editor_field_page-contact-repeater", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("69", "18", "media-text-page-contact-repeater", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("70", "18", "location_field_page-contact-repeater", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("71", "18", "_edit_lock", "1745774167:1");
INSERT INTO `wp_postmeta` VALUES("74", "22", "_wp_attached_file", "2024/12/pimplast.jpg");
INSERT INTO `wp_postmeta` VALUES("75", "22", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1560;s:6:\"height\";i:800;s:4:\"file\";s:20:\"2024/12/pimplast.jpg\";s:8:\"filesize\";i:66714;s:5:\"sizes\";a:3:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:20:\"pimplast-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15146;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:20:\"pimplast-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3330;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:20:\"pimplast-600x308.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:308;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22335;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("76", "23", "_wp_attached_file", "2024/12/slider161024_3-copy.jpg");
INSERT INTO `wp_postmeta` VALUES("77", "23", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1560;s:6:\"height\";i:800;s:4:\"file\";s:31:\"2024/12/slider161024_3-copy.jpg\";s:8:\"filesize\";i:211949;s:5:\"sizes\";a:3:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:31:\"slider161024_3-copy-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34648;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:31:\"slider161024_3-copy-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5100;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:31:\"slider161024_3-copy-600x308.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:308;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:73120;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("78", "24", "_wp_attached_file", "2024/12/New-Project-1.jpg");
INSERT INTO `wp_postmeta` VALUES("79", "24", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:33:\"2024/12/New-Project-1-150x150.jpg\";s:8:\"filesize\";i:4394;s:5:\"sizes\";a:2:{s:24:\"thumbnail_search_size_60\";a:5:{s:4:\"file\";s:31:\"New-Project-1-150x150-60x60.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:60;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1594;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:33:\"New-Project-1-150x150-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2524;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("145", "29", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("146", "29", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("147", "29", "_menu_item_object_id", "16");
INSERT INTO `wp_postmeta` VALUES("148", "29", "_menu_item_object", "product_cat");
INSERT INTO `wp_postmeta` VALUES("149", "29", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("150", "29", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("151", "29", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("152", "29", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("168", "1", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("169", "1", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("171", "1", "_edit_lock", "1764752782:2");
INSERT INTO `wp_postmeta` VALUES("172", "36", "_wp_attached_file", "2024/11/New-Project-5.jpg");
INSERT INTO `wp_postmeta` VALUES("173", "36", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:25:\"2024/11/New-Project-5.jpg\";s:8:\"filesize\";i:36702;s:5:\"sizes\";a:2:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:25:\"New-Project-5-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22309;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:25:\"New-Project-5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3709;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("174", "1", "_thumbnail_id", "536");
INSERT INTO `wp_postmeta` VALUES("176", "37", "_wp_attached_file", "2024/12/8e86ee120dae13e91808ed94d754297c4728d6cd_1731400149-scaled.gif");
INSERT INTO `wp_postmeta` VALUES("177", "37", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:533;s:4:\"file\";s:70:\"2024/12/8e86ee120dae13e91808ed94d754297c4728d6cd_1731400149-scaled.gif\";s:8:\"filesize\";i:432348;s:5:\"sizes\";a:3:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:63:\"8e86ee120dae13e91808ed94d754297c4728d6cd_1731400149-300x300.gif\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:49577;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:63:\"8e86ee120dae13e91808ed94d754297c4728d6cd_1731400149-100x100.gif\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:7705;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:63:\"8e86ee120dae13e91808ed94d754297c4728d6cd_1731400149-600x125.gif\";s:5:\"width\";i:600;s:6:\"height\";i:125;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:25952;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:55:\"8e86ee120dae13e91808ed94d754297c4728d6cd_1731400149.gif\";}");
INSERT INTO `wp_postmeta` VALUES("178", "38", "_wp_attached_file", "2024/12/984a733854009523a318d2edb55f09c9dfac6e02_1732720127.gif");
INSERT INTO `wp_postmeta` VALUES("179", "38", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:820;s:6:\"height\";i:328;s:4:\"file\";s:63:\"2024/12/984a733854009523a318d2edb55f09c9dfac6e02_1732720127.gif\";s:8:\"filesize\";i:523720;s:5:\"sizes\";a:3:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:63:\"984a733854009523a318d2edb55f09c9dfac6e02_1732720127-300x300.gif\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:52005;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:63:\"984a733854009523a318d2edb55f09c9dfac6e02_1732720127-100x100.gif\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:8181;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:63:\"984a733854009523a318d2edb55f09c9dfac6e02_1732720127-600x240.gif\";s:5:\"width\";i:600;s:6:\"height\";i:240;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:86777;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("180", "39", "_wp_attached_file", "2024/12/601c2bda992dc57716959584c0a6debc12cecb79_1732719831.jpg");
INSERT INTO `wp_postmeta` VALUES("181", "39", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:820;s:6:\"height\";i:328;s:4:\"file\";s:63:\"2024/12/601c2bda992dc57716959584c0a6debc12cecb79_1732719831.jpg\";s:8:\"filesize\";i:20621;s:5:\"sizes\";a:3:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:63:\"601c2bda992dc57716959584c0a6debc12cecb79_1732719831-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18420;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:63:\"601c2bda992dc57716959584c0a6debc12cecb79_1732719831-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3784;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:63:\"601c2bda992dc57716959584c0a6debc12cecb79_1732719831-600x240.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24056;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("182", "40", "_wp_attached_file", "2024/12/pimplast-1-rotated.jpg");
INSERT INTO `wp_postmeta` VALUES("183", "40", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:1560;s:6:\"height\";i:800;s:4:\"file\";s:30:\"2024/12/pimplast-1-rotated.jpg\";s:8:\"filesize\";i:219835;s:5:\"sizes\";a:3:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:22:\"pimplast-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21094;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:22:\"pimplast-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3675;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:22:\"pimplast-1-600x308.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:308;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:41291;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:14:\"pimplast-1.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("184", "41", "_wp_attached_file", "2024/12/pimplast-2-rotated.jpg");
INSERT INTO `wp_postmeta` VALUES("185", "41", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:1560;s:6:\"height\";i:800;s:4:\"file\";s:30:\"2024/12/pimplast-2-rotated.jpg\";s:8:\"filesize\";i:274900;s:5:\"sizes\";a:3:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:22:\"pimplast-2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24936;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:22:\"pimplast-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3995;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:22:\"pimplast-2-600x308.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:308;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:48525;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:14:\"pimplast-2.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("186", "42", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("187", "42", "_edit_lock", "1764741852:2");
INSERT INTO `wp_postmeta` VALUES("188", "42", "_thumbnail_id", "545");
INSERT INTO `wp_postmeta` VALUES("189", "42", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("206", "51", "_wp_attached_file", "2024/12/pimplast-3.jpg");
INSERT INTO `wp_postmeta` VALUES("207", "51", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1560;s:6:\"height\";i:800;s:4:\"file\";s:22:\"2024/12/pimplast-3.jpg\";s:8:\"filesize\";i:219395;s:5:\"sizes\";a:3:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:22:\"pimplast-3-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29379;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:22:\"pimplast-3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4619;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:22:\"pimplast-3-600x308.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:308;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:56529;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("208", "53", "_wp_attached_file", "2024/12/1.jpg");
INSERT INTO `wp_postmeta` VALUES("209", "53", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:13:\"2024/12/1.jpg\";s:8:\"filesize\";i:2453;s:5:\"sizes\";a:2:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:13:\"1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2134;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:13:\"1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:886;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("210", "54", "_wp_attached_file", "2024/12/2.jpg");
INSERT INTO `wp_postmeta` VALUES("211", "54", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:13:\"2024/12/2.jpg\";s:8:\"filesize\";i:2453;s:5:\"sizes\";a:2:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:13:\"2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2134;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:13:\"2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:886;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("212", "55", "_wp_attached_file", "2024/12/3.jpg");
INSERT INTO `wp_postmeta` VALUES("213", "55", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:13:\"2024/12/3.jpg\";s:8:\"filesize\";i:3924;s:5:\"sizes\";a:2:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:13:\"3-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3807;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:13:\"3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1269;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("214", "56", "_wp_attached_file", "2024/12/4.jpg");
INSERT INTO `wp_postmeta` VALUES("215", "56", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:13:\"2024/12/4.jpg\";s:8:\"filesize\";i:5859;s:5:\"sizes\";a:2:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:13:\"4-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4433;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:13:\"4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1391;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("216", "57", "_wp_attached_file", "2024/12/5.jpg");
INSERT INTO `wp_postmeta` VALUES("217", "57", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:13:\"2024/12/5.jpg\";s:8:\"filesize\";i:6141;s:5:\"sizes\";a:2:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:13:\"5-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4669;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:13:\"5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1396;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("218", "58", "_wp_attached_file", "2024/12/pimplast-2-1.jpg");
INSERT INTO `wp_postmeta` VALUES("219", "58", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1560;s:6:\"height\";i:591;s:4:\"file\";s:24:\"2024/12/pimplast-2-1.jpg\";s:8:\"filesize\";i:139692;s:5:\"sizes\";a:3:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:24:\"pimplast-2-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22732;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:24:\"pimplast-2-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3899;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:24:\"pimplast-2-1-600x227.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:227;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36208;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("220", "59", "_wp_attached_file", "2024/12/pimplast-2-1-1.jpg");
INSERT INTO `wp_postmeta` VALUES("221", "59", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1560;s:6:\"height\";i:591;s:4:\"file\";s:26:\"2024/12/pimplast-2-1-1.jpg\";s:8:\"filesize\";i:163938;s:5:\"sizes\";a:3:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:26:\"pimplast-2-1-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27182;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:26:\"pimplast-2-1-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4436;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:26:\"pimplast-2-1-1-600x227.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:227;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47033;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("223", "29", "_wp_old_date", "2024-12-03");
INSERT INTO `wp_postmeta` VALUES("225", "60", "_wp_attached_file", "2024/12/New-Project.png");
INSERT INTO `wp_postmeta` VALUES("226", "60", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1500;s:6:\"height\";i:500;s:4:\"file\";s:23:\"2024/12/New-Project.png\";s:8:\"filesize\";i:16493;s:5:\"sizes\";a:3:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:23:\"New-Project-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6238;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:23:\"New-Project-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1585;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:23:\"New-Project-600x200.png\";s:5:\"width\";i:600;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13159;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("227", "61", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("228", "61", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("229", "61", "_menu_item_object_id", "18");
INSERT INTO `wp_postmeta` VALUES("230", "61", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("231", "61", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("232", "61", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("233", "61", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("234", "61", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("236", "62", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("237", "62", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("238", "62", "_menu_item_object_id", "16");
INSERT INTO `wp_postmeta` VALUES("239", "62", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("240", "62", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("241", "62", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("242", "62", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("243", "62", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("245", "63", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("246", "63", "_edit_lock", "1749652169:1");
INSERT INTO `wp_postmeta` VALUES("247", "63", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("248", "63", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("249", "63", "switch-page-service-physical", "");
INSERT INTO `wp_postmeta` VALUES("250", "63", "repeater-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("251", "63", "title_field_accordion", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("252", "63", "editor-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("253", "63", "custom_text-the_excerpt-contact-service", "");
INSERT INTO `wp_postmeta` VALUES("254", "63", "media_text_the_excerpt-contact-service_send_pro", "");
INSERT INTO `wp_postmeta` VALUES("255", "63", "media_text_the_excerpt-contact-service_video", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("256", "63", "media_text_the_excerpt-contact-service_poster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("257", "63", "media_text_the_excerpt-contact-service_backgraound-one", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("258", "63", "media_text_the_excerpt-contact_title-service_short-code", "");
INSERT INTO `wp_postmeta` VALUES("259", "63", "media_text_the_excerpt-contact-service_short-code", "0");
INSERT INTO `wp_postmeta` VALUES("260", "63", "repeater-field-page-contact-repeater", "a:1:{s:19:\"redux_repeater_data\";a:2:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("261", "63", "title_field_page-contact-repeater", "a:2:{i:0;s:19:\"دفتر مرکزی\";i:1;s:25:\"نشانی کارخانه\";}");
INSERT INTO `wp_postmeta` VALUES("262", "63", "editor_field_page-contact-repeater", "a:2:{i:0;s:486:\"ایران – استان خوزستان – شهرستان شوشتر – میدان غدیر – روبروی پارک شهید کجباف\r\n<div class=\"text-base font-bold text-zinc-800 flex p-0 m-0 items-center justify-center md:justify-center h-8 bg-slate-50 \">\r\n<div class=\"flex\"><a href=\"tel:06136210009\">06136210009</a>\r\n<span class=\"px-2\">-</span>\r\n<a href=\"tel:061362220009\">061362220009</a>\r\n<span class=\"px-2\">-</span>\r\n<a href=\"tel:09169097809\">09169097809</a></div>\r\n</div>\";i:1;s:418:\"ایران – استان خوزستان – شهرستان شوشتر – جاده کارون - شهرک صنعتی شماره ۱ خیابان ۴\r\n<div class=\"text-base font-bold text-zinc-800 flex p-0 m-0 items-center justify-center md:justify-center h-8 bg-slate-50 \">\r\n<div class=\"flex\"><a href=\"tel:06136271444\">06136271444</a>\r\n<span class=\"px-2\">-</span>\r\n<a href=\"tel:06136271443\">06136271443</a></div>\r\n</div>\";}");
INSERT INTO `wp_postmeta` VALUES("263", "63", "media-text-page-contact-repeater", "a:2:{i:0;a:5:{s:3:\"url\";s:69:\"https://mianabpe.com/wp-content/uploads/2025/04/IMG_05821-scaled.webp\";s:2:\"id\";s:3:\"603\";s:6:\"height\";s:4:\"1920\";s:5:\"width\";s:4:\"2560\";s:9:\"thumbnail\";s:70:\"https://mianabpe.com/wp-content/uploads/2025/04/IMG_05821-150x150.webp\";}i:1;a:5:{s:3:\"url\";s:62:\"https://mianabpe.com/wp-content/uploads/2024/12/pimplast-2.jpg\";s:2:\"id\";s:2:\"41\";s:6:\"height\";s:3:\"800\";s:5:\"width\";s:4:\"1560\";s:9:\"thumbnail\";s:62:\"https://mianabpe.com/wp-content/uploads/2024/12/pimplast-2.jpg\";}}");
INSERT INTO `wp_postmeta` VALUES("264", "63", "location_field_page-contact-repeater", "a:2:{i:0;s:41:\"https://maps.app.goo.gl/XspqLvtrBEh5EwQU7\";i:1;s:41:\"https://maps.app.goo.gl/CNv1GY46ka9LTS748\";}");
INSERT INTO `wp_postmeta` VALUES("265", "65", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("266", "65", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("267", "65", "_menu_item_object_id", "63");
INSERT INTO `wp_postmeta` VALUES("268", "65", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("269", "65", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("270", "65", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("271", "65", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("272", "65", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("283", "63", "editor_field_page-contact-repeater-two", "a:1:{i:0;s:603:\"    دفتر مرکزی: ایران – استان خوزستان – شهرستان شوشتر – میدان غدیر – روبروی پارک شهید کجباف\r\n\r\n  <div class=\"text-base font-bold text-zinc-800 flex p-0 m-0 items-center justify-center md:justify-center h-8 bg-slate-50 \">\r\n\r\n        <div class=\"flex\">\r\n            <a href=\"tel:06136210009\">06136210009</a>\r\n            <span class=\"px-2\">-</span>\r\n            <a href=\"tel:061362220009\">061362220009</a>\r\n            <span class=\"px-2\">-</span>\r\n            <a href=\"tel:09169097809\">09169097809</a>\r\n        </div>\r\n\r\n    </div>\";}");
INSERT INTO `wp_postmeta` VALUES("293", "70", "_wp_attached_file", "2024/12/آیکون-واتس-اپ.png");
INSERT INTO `wp_postmeta` VALUES("294", "70", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:36:\"2024/12/آیکون-واتس-اپ.png\";s:8:\"filesize\";i:3356;s:5:\"sizes\";a:1:{s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:36:\"آیکون-واتس-اپ-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8908;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("295", "71", "_wp_attached_file", "2024/12/تلگرام.png");
INSERT INTO `wp_postmeta` VALUES("296", "71", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:24:\"2024/12/تلگرام.png\";s:8:\"filesize\";i:1906;s:5:\"sizes\";a:1:{s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:24:\"تلگرام-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4230;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("297", "72", "_wp_attached_file", "2024/12/New-Project-3.png");
INSERT INTO `wp_postmeta` VALUES("298", "72", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:25:\"2024/12/New-Project-3.png\";s:8:\"filesize\";i:2442;s:5:\"sizes\";a:1:{s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:25:\"New-Project-3-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6654;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("299", "73", "_wp_attached_file", "2024/12/New-Project-4.png");
INSERT INTO `wp_postmeta` VALUES("300", "73", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:25:\"2024/12/New-Project-4.png\";s:8:\"filesize\";i:2393;s:5:\"sizes\";a:1:{s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:25:\"New-Project-4-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6057;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("301", "74", "_wp_attached_file", "2024/12/New-Project-5.png");
INSERT INTO `wp_postmeta` VALUES("302", "74", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:25:\"2024/12/New-Project-5.png\";s:8:\"filesize\";i:1716;s:5:\"sizes\";a:1:{s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:25:\"New-Project-5-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2467;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("303", "75", "_wp_attached_file", "2024/12/New-Project-6.png");
INSERT INTO `wp_postmeta` VALUES("304", "75", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:25:\"2024/12/New-Project-6.png\";s:8:\"filesize\";i:3472;s:5:\"sizes\";a:1:{s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:25:\"New-Project-6-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8438;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("305", "76", "_wp_attached_file", "2024/12/New-Project-7.png");
INSERT INTO `wp_postmeta` VALUES("306", "76", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:25:\"2024/12/New-Project-7.png\";s:8:\"filesize\";i:2846;s:5:\"sizes\";a:1:{s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:25:\"New-Project-7-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4128;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("307", "77", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("308", "77", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("309", "77", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("310", "77", "switch-page-service-physical", "");
INSERT INTO `wp_postmeta` VALUES("311", "77", "repeater-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("312", "77", "title_field_accordion", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("313", "77", "editor-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("314", "77", "custom_text-the_excerpt-contact-service", "");
INSERT INTO `wp_postmeta` VALUES("315", "77", "media_text_the_excerpt-contact-service_send_pro", "");
INSERT INTO `wp_postmeta` VALUES("316", "77", "media_text_the_excerpt-contact-service_video", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("317", "77", "media_text_the_excerpt-contact-service_poster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("318", "77", "media_text_the_excerpt-contact-service_backgraound-one", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("319", "77", "media_text_the_excerpt-contact_title-service_short-code", "");
INSERT INTO `wp_postmeta` VALUES("320", "77", "media_text_the_excerpt-contact-service_short-code", "0");
INSERT INTO `wp_postmeta` VALUES("321", "77", "repeater-field-page-contact-repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("322", "77", "title_field_page-contact-repeater", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("323", "77", "editor_field_page-contact-repeater", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("324", "77", "media-text-page-contact-repeater", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("325", "77", "location_field_page-contact-repeater", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("326", "77", "_edit_lock", "1749556937:1");
INSERT INTO `wp_postmeta` VALUES("327", "80", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("328", "80", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("329", "80", "_menu_item_object_id", "77");
INSERT INTO `wp_postmeta` VALUES("330", "80", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("331", "80", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("332", "80", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("333", "80", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("334", "80", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("981", "167", "_wp_attached_file", "2024/12/لوله-پلی-اتیلن-کلافی-شرکت-میاناب.webp");
INSERT INTO `wp_postmeta` VALUES("982", "167", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:72:\"2024/12/لوله-پلی-اتیلن-کلافی-شرکت-میاناب.webp\";s:8:\"filesize\";i:8444;s:5:\"sizes\";a:8:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:72:\"لوله-پلی-اتیلن-کلافی-شرکت-میاناب-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7462;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:72:\"لوله-پلی-اتیلن-کلافی-شرکت-میاناب-100x100.webp\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:1612;}s:6:\"medium\";a:5:{s:4:\"file\";s:72:\"لوله-پلی-اتیلن-کلافی-شرکت-میاناب-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7462;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:72:\"لوله-پلی-اتیلن-کلافی-شرکت-میاناب-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2900;}s:7:\"153x153\";a:5:{s:4:\"file\";s:72:\"لوله-پلی-اتیلن-کلافی-شرکت-میاناب-153x153.webp\";s:5:\"width\";i:153;s:6:\"height\";i:153;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2882;}s:24:\"thumbnail_search_size_60\";a:5:{s:4:\"file\";s:70:\"لوله-پلی-اتیلن-کلافی-شرکت-میاناب-60x60.webp\";s:5:\"width\";i:60;s:6:\"height\";i:60;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:872;}s:28:\"thumbnail_product_archive_60\";a:5:{s:4:\"file\";s:72:\"لوله-پلی-اتیلن-کلافی-شرکت-میاناب-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2900;}s:6:\"detail\";a:5:{s:4:\"file\";s:72:\"لوله-پلی-اتیلن-کلافی-شرکت-میاناب-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2900;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("983", "168", "_wp_attached_file", "2024/12/لوله-پلی-اتیلن-شاخه-ای-شرکت-میاناب.webp");
INSERT INTO `wp_postmeta` VALUES("984", "168", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:75:\"2024/12/لوله-پلی-اتیلن-شاخه-ای-شرکت-میاناب.webp\";s:8:\"filesize\";i:5664;s:5:\"sizes\";a:8:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:75:\"لوله-پلی-اتیلن-شاخه-ای-شرکت-میاناب-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:4954;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:75:\"لوله-پلی-اتیلن-شاخه-ای-شرکت-میاناب-100x100.webp\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:1296;}s:6:\"medium\";a:5:{s:4:\"file\";s:75:\"لوله-پلی-اتیلن-شاخه-ای-شرکت-میاناب-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:4954;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:75:\"لوله-پلی-اتیلن-شاخه-ای-شرکت-میاناب-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2058;}s:7:\"153x153\";a:5:{s:4:\"file\";s:75:\"لوله-پلی-اتیلن-شاخه-ای-شرکت-میاناب-153x153.webp\";s:5:\"width\";i:153;s:6:\"height\";i:153;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2066;}s:24:\"thumbnail_search_size_60\";a:5:{s:4:\"file\";s:73:\"لوله-پلی-اتیلن-شاخه-ای-شرکت-میاناب-60x60.webp\";s:5:\"width\";i:60;s:6:\"height\";i:60;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:732;}s:28:\"thumbnail_product_archive_60\";a:5:{s:4:\"file\";s:75:\"لوله-پلی-اتیلن-شاخه-ای-شرکت-میاناب-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2058;}s:6:\"detail\";a:5:{s:4:\"file\";s:75:\"لوله-پلی-اتیلن-شاخه-ای-شرکت-میاناب-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2058;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1032", "167", "_edit_lock", "1734904687:1");
INSERT INTO `wp_postmeta` VALUES("1597", "1595", "_product_type", "simple");
INSERT INTO `wp_postmeta` VALUES("1598", "1595", "product_size_type", "stick");
INSERT INTO `wp_postmeta` VALUES("1763", "1761", "_product_type", "simple");
INSERT INTO `wp_postmeta` VALUES("1764", "1761", "product_size_type", "stick");
INSERT INTO `wp_postmeta` VALUES("1765", "168", "_edit_lock", "1734904839:1");
INSERT INTO `wp_postmeta` VALUES("1849", "1847", "_product_type", "simple");
INSERT INTO `wp_postmeta` VALUES("1850", "1847", "product_size_type", "stick");
INSERT INTO `wp_postmeta` VALUES("2689", "276", "_tablepress_table_options", "{\"last_editor\":2,\"table_head\":1,\"table_foot\":0,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":false,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("2690", "276", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],\"columns\":[1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("2694", "287", "_tablepress_table_options", "{\"last_editor\":1,\"table_head\":1,\"table_foot\":0,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":false,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("2695", "287", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],\"columns\":[1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("2751", "77", "_thumbnail_id", "602");
INSERT INTO `wp_postmeta` VALUES("2752", "14", "_edit_lock", "1738993989:2");
INSERT INTO `wp_postmeta` VALUES("2753", "297", "_tablepress_table_options", "{\"last_editor\":2,\"table_head\":1,\"table_foot\":0,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":true,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("2754", "297", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1,1,1,1,1,1,1,1],\"columns\":[1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("2755", "300", "_tablepress_table_options", "{\"last_editor\":2,\"table_head\":1,\"table_foot\":0,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":false,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("2756", "300", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1,1,1],\"columns\":[1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("2757", "304", "_wp_attached_file", "2025/01/photo_2025-01-29_09-59-42.jpg");
INSERT INTO `wp_postmeta` VALUES("2758", "304", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:931;s:4:\"file\";s:37:\"2025/01/photo_2025-01-29_09-59-42.jpg\";s:8:\"filesize\";i:106601;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:37:\"photo_2025-01-29_09-59-42-300x218.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:218;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9998;}s:5:\"large\";a:5:{s:4:\"file\";s:38:\"photo_2025-01-29_09-59-42-1024x745.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:745;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58975;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:37:\"photo_2025-01-29_09-59-42-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4878;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:37:\"photo_2025-01-29_09-59-42-768x559.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:559;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37536;}s:7:\"153x153\";a:5:{s:4:\"file\";s:37:\"photo_2025-01-29_09-59-42-153x111.jpg\";s:5:\"width\";i:153;s:6:\"height\";i:111;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4207;}s:24:\"thumbnail_search_size_60\";a:5:{s:4:\"file\";s:35:\"photo_2025-01-29_09-59-42-60x44.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:44;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1646;}s:32:\"thumbnail_product_archive_edu_60\";a:5:{s:4:\"file\";s:37:\"photo_2025-01-29_09-59-42-600x436.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:436;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26199;}s:22:\"thumbnail_page-service\";a:5:{s:4:\"file\";s:37:\"photo_2025-01-29_09-59-42-600x436.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:436;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26199;}s:28:\"thumbnail_product_archive_60\";a:5:{s:4:\"file\";s:37:\"photo_2025-01-29_09-59-42-150x109.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:109;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4244;}s:6:\"detail\";a:5:{s:4:\"file\";s:37:\"photo_2025-01-29_09-59-42-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4878;}s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:37:\"photo_2025-01-29_09-59-42-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11965;s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:37:\"photo_2025-01-29_09-59-42-600x436.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:436;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26199;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:37:\"photo_2025-01-29_09-59-42-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3100;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2853", "312", "_edit_lock", "1738146500:2");
INSERT INTO `wp_postmeta` VALUES("2854", "312", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("2855", "312", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2856", "312", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("2857", "312", "switch-page-service-physical", "");
INSERT INTO `wp_postmeta` VALUES("2858", "312", "repeater-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("2859", "312", "title_field_accordion", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2860", "312", "editor-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2861", "312", "custom_text-the_excerpt-contact-service", "");
INSERT INTO `wp_postmeta` VALUES("2862", "312", "media_text_the_excerpt-contact-service_send_pro", "");
INSERT INTO `wp_postmeta` VALUES("2863", "312", "media_text_the_excerpt-contact-service_video", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2864", "312", "media_text_the_excerpt-contact-service_poster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2865", "312", "media_text_the_excerpt-contact-service_backgraound-one", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2866", "312", "media_text_the_excerpt-contact_title-service_short-code", "");
INSERT INTO `wp_postmeta` VALUES("2867", "312", "media_text_the_excerpt-contact-service_short-code", "0");
INSERT INTO `wp_postmeta` VALUES("2868", "312", "repeater-field-page-contact-repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("2869", "312", "title_field_page-contact-repeater", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2870", "312", "editor_field_page-contact-repeater", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2871", "312", "media-text-page-contact-repeater", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2872", "312", "location_field_page-contact-repeater", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2892", "29", "_wp_old_date", "2024-12-13");
INSERT INTO `wp_postmeta` VALUES("4672", "29", "_wp_old_date", "2025-01-29");
INSERT INTO `wp_postmeta` VALUES("4897", "360", "_edit_lock", "1765261370:2");
INSERT INTO `wp_postmeta` VALUES("4898", "360", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("4899", "360", "_visibility", "visible");
INSERT INTO `wp_postmeta` VALUES("4900", "360", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("4901", "360", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("4902", "360", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("4903", "360", "c", "");
INSERT INTO `wp_postmeta` VALUES("4904", "360", "level-learn-select-position", "");
INSERT INTO `wp_postmeta` VALUES("4905", "360", "editor__title_404_number_in_cart_ase", "به صورت کلاف در سایزهای 100-150-200 متری");
INSERT INTO `wp_postmeta` VALUES("4906", "360", "repeater-detail-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:2:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("4907", "360", "editor-detail-text-lic", "a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("4908", "360", "title_field_add_item_for_sale_learn_one", "");
INSERT INTO `wp_postmeta` VALUES("4909", "360", "title_field_add_item_for_sale_learn_send_one", "");
INSERT INTO `wp_postmeta` VALUES("4910", "360", "title_field_add_item_for_sale_learn_update_one", "");
INSERT INTO `wp_postmeta` VALUES("4911", "360", "title_field_add_item_for_sale_learn_support_one", "");
INSERT INTO `wp_postmeta` VALUES("4912", "360", "text_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("4913", "360", "time_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("4914", "360", "level-learn-select", "");
INSERT INTO `wp_postmeta` VALUES("4915", "360", "location_lesson_record", "");
INSERT INTO `wp_postmeta` VALUES("4916", "360", "videos_repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("4917", "360", "section_name_part_start", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("4918", "360", "lesson-spinner", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("4919", "360", "custom_media_learn_product-free-sec", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("4920", "360", "custom_media_learn-pooster-free", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("4921", "360", "free_checkbox", "a:1:{i:0;s:1:\"1\";}");
INSERT INTO `wp_postmeta` VALUES("4922", "360", "free-editor-text", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("4923", "360", "custom_media_learn_product", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("4924", "360", "custom_media_learn-pooster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("4925", "360", "custom_img-te", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("4926", "360", "custom-te-name", "");
INSERT INTO `wp_postmeta` VALUES("4927", "360", "custom-te-name-bold", "");
INSERT INTO `wp_postmeta` VALUES("4928", "360", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("4929", "360", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("4930", "360", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("4931", "360", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("4932", "360", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("4933", "360", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("4934", "360", "_virtual", "no");
INSERT INTO `wp_postmeta` VALUES("4935", "360", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("4936", "360", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("4937", "360", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("4938", "360", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("4939", "360", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("4940", "360", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("4941", "360", "_product_version", "9.7.1");
INSERT INTO `wp_postmeta` VALUES("4942", "360", "_wp_old_slug", "%d9%84%d9%88%d9%84%d9%87-%d9%be%d9%84%db%8c-%d8%a7%d8%aa%db%8c%d9%84%d9%86-%db%b2%db%b0-%d9%85%db%8c%d9%84%db%8c-%d9%85%d8%aa%d8%b1-pe100");
INSERT INTO `wp_postmeta` VALUES("4943", "361", "_tablepress_table_options", "{\"last_editor\":2,\"table_head\":1,\"table_foot\":4,\"alternating_row_colors\":false,\"row_hover\":false,\"print_name\":false,\"print_name_position\":\"below\",\"print_description\":false,\"print_description_position\":\"above\",\"extra_css_classes\":\"\",\"use_datatables\":false,\"datatables_sort\":false,\"datatables_filter\":false,\"datatables_paginate\":false,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":false,\"datatables_scrollx\":true,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("4944", "361", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1],\"columns\":[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("4999", "433", "_tablepress_table_options", "{\"last_editor\":1,\"table_head\":1,\"table_foot\":4,\"alternating_row_colors\":false,\"row_hover\":false,\"print_name\":false,\"print_name_position\":\"below\",\"print_description\":false,\"print_description_position\":\"above\",\"extra_css_classes\":\"\",\"use_datatables\":false,\"datatables_sort\":false,\"datatables_filter\":false,\"datatables_paginate\":false,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":false,\"datatables_scrollx\":true,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("5000", "433", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1],\"columns\":[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("5002", "360", "_wp_old_slug", "polyethylene-pipe-25mm");
INSERT INTO `wp_postmeta` VALUES("5003", "435", "_edit_lock", "1741984297:2");
INSERT INTO `wp_postmeta` VALUES("5004", "435", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("5005", "435", "_visibility", "visible");
INSERT INTO `wp_postmeta` VALUES("5006", "435", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("5007", "435", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5008", "435", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("5009", "435", "c", "");
INSERT INTO `wp_postmeta` VALUES("5010", "435", "level-learn-select-position", "");
INSERT INTO `wp_postmeta` VALUES("5011", "435", "editor__title_404_number_in_cart_ase", "به صورت کلاف در سایزهای 100-150-200 متری");
INSERT INTO `wp_postmeta` VALUES("5012", "435", "repeater-detail-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5013", "435", "editor-detail-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5014", "435", "title_field_add_item_for_sale_learn_one", "");
INSERT INTO `wp_postmeta` VALUES("5015", "435", "title_field_add_item_for_sale_learn_send_one", "");
INSERT INTO `wp_postmeta` VALUES("5016", "435", "title_field_add_item_for_sale_learn_update_one", "");
INSERT INTO `wp_postmeta` VALUES("5017", "435", "title_field_add_item_for_sale_learn_support_one", "");
INSERT INTO `wp_postmeta` VALUES("5018", "435", "text_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5019", "435", "time_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5020", "435", "level-learn-select", "");
INSERT INTO `wp_postmeta` VALUES("5021", "435", "location_lesson_record", "");
INSERT INTO `wp_postmeta` VALUES("5022", "435", "videos_repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5023", "435", "section_name_part_start", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5024", "435", "lesson-spinner", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5025", "435", "custom_media_learn_product-free-sec", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5026", "435", "custom_media_learn-pooster-free", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5027", "435", "free_checkbox", "a:1:{i:0;s:1:\"1\";}");
INSERT INTO `wp_postmeta` VALUES("5028", "435", "free-editor-text", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5029", "435", "custom_media_learn_product", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5030", "435", "custom_media_learn-pooster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5031", "435", "custom_img-te", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5032", "435", "custom-te-name", "");
INSERT INTO `wp_postmeta` VALUES("5033", "435", "custom-te-name-bold", "");
INSERT INTO `wp_postmeta` VALUES("5034", "435", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("5035", "435", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("5036", "435", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("5037", "435", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("5038", "435", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("5039", "435", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("5040", "435", "_virtual", "no");
INSERT INTO `wp_postmeta` VALUES("5041", "435", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("5042", "435", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("5043", "435", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("5044", "435", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("5045", "435", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("5046", "435", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("5047", "435", "_product_version", "9.4.3");
INSERT INTO `wp_postmeta` VALUES("5048", "435", "_thumbnail_id", "167");
INSERT INTO `wp_postmeta` VALUES("5049", "360", "_thumbnail_id", "167");
INSERT INTO `wp_postmeta` VALUES("5050", "360", "_wp_old_slug", "polyethylene-pipe-20mm");
INSERT INTO `wp_postmeta` VALUES("5056", "441", "_edit_lock", "1741984327:2");
INSERT INTO `wp_postmeta` VALUES("5057", "441", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("5058", "441", "_visibility", "visible");
INSERT INTO `wp_postmeta` VALUES("5059", "441", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("5060", "441", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5061", "441", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("5062", "441", "c", "");
INSERT INTO `wp_postmeta` VALUES("5063", "441", "level-learn-select-position", "");
INSERT INTO `wp_postmeta` VALUES("5064", "441", "editor__title_404_number_in_cart_ase", "به صورت کلاف در سایزهای 100-150-200 متری");
INSERT INTO `wp_postmeta` VALUES("5065", "441", "repeater-detail-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5066", "441", "editor-detail-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5067", "441", "title_field_add_item_for_sale_learn_one", "");
INSERT INTO `wp_postmeta` VALUES("5068", "441", "title_field_add_item_for_sale_learn_send_one", "");
INSERT INTO `wp_postmeta` VALUES("5069", "441", "title_field_add_item_for_sale_learn_update_one", "");
INSERT INTO `wp_postmeta` VALUES("5070", "441", "title_field_add_item_for_sale_learn_support_one", "");
INSERT INTO `wp_postmeta` VALUES("5071", "441", "text_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5072", "441", "time_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5073", "441", "level-learn-select", "");
INSERT INTO `wp_postmeta` VALUES("5074", "441", "location_lesson_record", "");
INSERT INTO `wp_postmeta` VALUES("5075", "441", "videos_repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5076", "441", "section_name_part_start", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5077", "441", "lesson-spinner", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5078", "441", "custom_media_learn_product-free-sec", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5079", "441", "custom_media_learn-pooster-free", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5080", "441", "free_checkbox", "a:1:{i:0;s:1:\"1\";}");
INSERT INTO `wp_postmeta` VALUES("5081", "441", "free-editor-text", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5082", "441", "custom_media_learn_product", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5083", "441", "custom_media_learn-pooster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5084", "441", "custom_img-te", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5085", "441", "custom-te-name", "");
INSERT INTO `wp_postmeta` VALUES("5086", "441", "custom-te-name-bold", "");
INSERT INTO `wp_postmeta` VALUES("5087", "441", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("5088", "441", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("5089", "441", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("5090", "441", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("5091", "441", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("5092", "441", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("5093", "441", "_virtual", "no");
INSERT INTO `wp_postmeta` VALUES("5094", "441", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("5095", "441", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("5096", "441", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("5097", "441", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("5098", "441", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("5099", "441", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("5100", "441", "_product_version", "9.4.3");
INSERT INTO `wp_postmeta` VALUES("5101", "441", "_thumbnail_id", "167");
INSERT INTO `wp_postmeta` VALUES("5102", "443", "_edit_lock", "1741984351:2");
INSERT INTO `wp_postmeta` VALUES("5103", "443", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("5104", "443", "_visibility", "visible");
INSERT INTO `wp_postmeta` VALUES("5105", "443", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("5106", "443", "_thumbnail_id", "167");
INSERT INTO `wp_postmeta` VALUES("5107", "443", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5108", "443", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("5109", "443", "c", "");
INSERT INTO `wp_postmeta` VALUES("5110", "443", "level-learn-select-position", "");
INSERT INTO `wp_postmeta` VALUES("5111", "443", "editor__title_404_number_in_cart_ase", "به صورت کلاف در سایزهای 100-150-200 متری");
INSERT INTO `wp_postmeta` VALUES("5112", "443", "repeater-detail-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5113", "443", "editor-detail-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5114", "443", "title_field_add_item_for_sale_learn_one", "");
INSERT INTO `wp_postmeta` VALUES("5115", "443", "title_field_add_item_for_sale_learn_send_one", "");
INSERT INTO `wp_postmeta` VALUES("5116", "443", "title_field_add_item_for_sale_learn_update_one", "");
INSERT INTO `wp_postmeta` VALUES("5117", "443", "title_field_add_item_for_sale_learn_support_one", "");
INSERT INTO `wp_postmeta` VALUES("5118", "443", "text_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5119", "443", "time_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5120", "443", "level-learn-select", "");
INSERT INTO `wp_postmeta` VALUES("5121", "443", "location_lesson_record", "");
INSERT INTO `wp_postmeta` VALUES("5122", "443", "videos_repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5123", "443", "section_name_part_start", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5124", "443", "lesson-spinner", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5125", "443", "custom_media_learn_product-free-sec", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5126", "443", "custom_media_learn-pooster-free", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5127", "443", "free_checkbox", "a:1:{i:0;s:1:\"1\";}");
INSERT INTO `wp_postmeta` VALUES("5128", "443", "free-editor-text", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5129", "443", "custom_media_learn_product", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5130", "443", "custom_media_learn-pooster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5131", "443", "custom_img-te", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5132", "443", "custom-te-name", "");
INSERT INTO `wp_postmeta` VALUES("5133", "443", "custom-te-name-bold", "");
INSERT INTO `wp_postmeta` VALUES("5134", "443", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("5135", "443", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("5136", "443", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("5137", "443", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("5138", "443", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("5139", "443", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("5140", "443", "_virtual", "no");
INSERT INTO `wp_postmeta` VALUES("5141", "443", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("5142", "443", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("5143", "443", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("5144", "443", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("5145", "443", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("5146", "443", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("5147", "443", "_product_version", "9.4.3");
INSERT INTO `wp_postmeta` VALUES("5148", "444", "_edit_lock", "1741984387:2");
INSERT INTO `wp_postmeta` VALUES("5149", "444", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("5150", "444", "_visibility", "visible");
INSERT INTO `wp_postmeta` VALUES("5151", "444", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("5152", "444", "_thumbnail_id", "167");
INSERT INTO `wp_postmeta` VALUES("5153", "444", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5154", "444", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("5155", "444", "c", "");
INSERT INTO `wp_postmeta` VALUES("5156", "444", "level-learn-select-position", "");
INSERT INTO `wp_postmeta` VALUES("5157", "444", "editor__title_404_number_in_cart_ase", "به صورت کلاف در سایزهای 100-150-200 متری");
INSERT INTO `wp_postmeta` VALUES("5158", "444", "repeater-detail-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5159", "444", "editor-detail-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5160", "444", "title_field_add_item_for_sale_learn_one", "");
INSERT INTO `wp_postmeta` VALUES("5161", "444", "title_field_add_item_for_sale_learn_send_one", "");
INSERT INTO `wp_postmeta` VALUES("5162", "444", "title_field_add_item_for_sale_learn_update_one", "");
INSERT INTO `wp_postmeta` VALUES("5163", "444", "title_field_add_item_for_sale_learn_support_one", "");
INSERT INTO `wp_postmeta` VALUES("5164", "444", "text_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5165", "444", "time_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5166", "444", "level-learn-select", "");
INSERT INTO `wp_postmeta` VALUES("5167", "444", "location_lesson_record", "");
INSERT INTO `wp_postmeta` VALUES("5168", "444", "videos_repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5169", "444", "section_name_part_start", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5170", "444", "lesson-spinner", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5171", "444", "custom_media_learn_product-free-sec", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5172", "444", "custom_media_learn-pooster-free", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5173", "444", "free_checkbox", "a:1:{i:0;s:1:\"1\";}");
INSERT INTO `wp_postmeta` VALUES("5174", "444", "free-editor-text", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5175", "444", "custom_media_learn_product", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5176", "444", "custom_media_learn-pooster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5177", "444", "custom_img-te", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5178", "444", "custom-te-name", "");
INSERT INTO `wp_postmeta` VALUES("5179", "444", "custom-te-name-bold", "");
INSERT INTO `wp_postmeta` VALUES("5180", "444", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("5181", "444", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("5182", "444", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("5183", "444", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("5184", "444", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("5185", "444", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("5186", "444", "_virtual", "no");
INSERT INTO `wp_postmeta` VALUES("5187", "444", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("5188", "444", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("5189", "444", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("5190", "444", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("5191", "444", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("5192", "444", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("5193", "444", "_product_version", "9.4.3");
INSERT INTO `wp_postmeta` VALUES("5194", "445", "_edit_lock", "1741984412:2");
INSERT INTO `wp_postmeta` VALUES("5195", "445", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("5196", "445", "_visibility", "visible");
INSERT INTO `wp_postmeta` VALUES("5197", "445", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("5198", "445", "_thumbnail_id", "167");
INSERT INTO `wp_postmeta` VALUES("5199", "445", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5200", "445", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("5201", "445", "c", "");
INSERT INTO `wp_postmeta` VALUES("5202", "445", "level-learn-select-position", "");
INSERT INTO `wp_postmeta` VALUES("5203", "445", "editor__title_404_number_in_cart_ase", "به صورت کلاف در سایزهای 100-150-200 متری");
INSERT INTO `wp_postmeta` VALUES("5204", "445", "repeater-detail-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5205", "445", "editor-detail-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5206", "445", "title_field_add_item_for_sale_learn_one", "");
INSERT INTO `wp_postmeta` VALUES("5207", "445", "title_field_add_item_for_sale_learn_send_one", "");
INSERT INTO `wp_postmeta` VALUES("5208", "445", "title_field_add_item_for_sale_learn_update_one", "");
INSERT INTO `wp_postmeta` VALUES("5209", "445", "title_field_add_item_for_sale_learn_support_one", "");
INSERT INTO `wp_postmeta` VALUES("5210", "445", "text_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5211", "445", "time_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5212", "445", "level-learn-select", "");
INSERT INTO `wp_postmeta` VALUES("5213", "445", "location_lesson_record", "");
INSERT INTO `wp_postmeta` VALUES("5214", "445", "videos_repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5215", "445", "section_name_part_start", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5216", "445", "lesson-spinner", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5217", "445", "custom_media_learn_product-free-sec", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5218", "445", "custom_media_learn-pooster-free", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5219", "445", "free_checkbox", "a:1:{i:0;s:1:\"1\";}");
INSERT INTO `wp_postmeta` VALUES("5220", "445", "free-editor-text", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5221", "445", "custom_media_learn_product", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5222", "445", "custom_media_learn-pooster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5223", "445", "custom_img-te", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5224", "445", "custom-te-name", "");
INSERT INTO `wp_postmeta` VALUES("5225", "445", "custom-te-name-bold", "");
INSERT INTO `wp_postmeta` VALUES("5226", "445", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("5227", "445", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("5228", "445", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("5229", "445", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("5230", "445", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("5231", "445", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("5232", "445", "_virtual", "no");
INSERT INTO `wp_postmeta` VALUES("5233", "445", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("5234", "445", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("5235", "445", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("5236", "445", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("5237", "445", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("5238", "445", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("5239", "445", "_product_version", "9.4.3");
INSERT INTO `wp_postmeta` VALUES("5240", "446", "_edit_lock", "1741984573:2");
INSERT INTO `wp_postmeta` VALUES("5241", "446", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("5242", "446", "_visibility", "visible");
INSERT INTO `wp_postmeta` VALUES("5243", "446", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("5244", "446", "_thumbnail_id", "167");
INSERT INTO `wp_postmeta` VALUES("5245", "446", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5246", "446", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("5247", "446", "c", "");
INSERT INTO `wp_postmeta` VALUES("5248", "446", "level-learn-select-position", "");
INSERT INTO `wp_postmeta` VALUES("5249", "446", "editor__title_404_number_in_cart_ase", "به صورت کلاف در سایزهای 100-150-200 متری");
INSERT INTO `wp_postmeta` VALUES("5250", "446", "repeater-detail-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5251", "446", "editor-detail-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5252", "446", "title_field_add_item_for_sale_learn_one", "");
INSERT INTO `wp_postmeta` VALUES("5253", "446", "title_field_add_item_for_sale_learn_send_one", "");
INSERT INTO `wp_postmeta` VALUES("5254", "446", "title_field_add_item_for_sale_learn_update_one", "");
INSERT INTO `wp_postmeta` VALUES("5255", "446", "title_field_add_item_for_sale_learn_support_one", "");
INSERT INTO `wp_postmeta` VALUES("5256", "446", "text_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5257", "446", "time_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5258", "446", "level-learn-select", "");
INSERT INTO `wp_postmeta` VALUES("5259", "446", "location_lesson_record", "");
INSERT INTO `wp_postmeta` VALUES("5260", "446", "videos_repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5261", "446", "section_name_part_start", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5262", "446", "lesson-spinner", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5263", "446", "custom_media_learn_product-free-sec", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5264", "446", "custom_media_learn-pooster-free", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5265", "446", "free_checkbox", "a:1:{i:0;s:1:\"1\";}");
INSERT INTO `wp_postmeta` VALUES("5266", "446", "free-editor-text", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5267", "446", "custom_media_learn_product", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5268", "446", "custom_media_learn-pooster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5269", "446", "custom_img-te", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5270", "446", "custom-te-name", "");
INSERT INTO `wp_postmeta` VALUES("5271", "446", "custom-te-name-bold", "");
INSERT INTO `wp_postmeta` VALUES("5272", "446", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("5273", "446", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("5274", "446", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("5275", "446", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("5276", "446", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("5277", "446", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("5278", "446", "_virtual", "no");
INSERT INTO `wp_postmeta` VALUES("5279", "446", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("5280", "446", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("5281", "446", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("5282", "446", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("5283", "446", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("5284", "446", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("5285", "446", "_product_version", "9.4.3");
INSERT INTO `wp_postmeta` VALUES("5286", "447", "_edit_lock", "1741984457:2");
INSERT INTO `wp_postmeta` VALUES("5287", "447", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("5288", "447", "_visibility", "visible");
INSERT INTO `wp_postmeta` VALUES("5289", "447", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("5290", "447", "_thumbnail_id", "167");
INSERT INTO `wp_postmeta` VALUES("5291", "447", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5292", "447", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("5293", "447", "c", "");
INSERT INTO `wp_postmeta` VALUES("5294", "447", "level-learn-select-position", "");
INSERT INTO `wp_postmeta` VALUES("5295", "447", "editor__title_404_number_in_cart_ase", "به صورت کلاف در سایزهای 100-150-200 متری");
INSERT INTO `wp_postmeta` VALUES("5296", "447", "repeater-detail-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5297", "447", "editor-detail-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5298", "447", "title_field_add_item_for_sale_learn_one", "");
INSERT INTO `wp_postmeta` VALUES("5299", "447", "title_field_add_item_for_sale_learn_send_one", "");
INSERT INTO `wp_postmeta` VALUES("5300", "447", "title_field_add_item_for_sale_learn_update_one", "");
INSERT INTO `wp_postmeta` VALUES("5301", "447", "title_field_add_item_for_sale_learn_support_one", "");
INSERT INTO `wp_postmeta` VALUES("5302", "447", "text_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5303", "447", "time_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5304", "447", "level-learn-select", "");
INSERT INTO `wp_postmeta` VALUES("5305", "447", "location_lesson_record", "");
INSERT INTO `wp_postmeta` VALUES("5306", "447", "videos_repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5307", "447", "section_name_part_start", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5308", "447", "lesson-spinner", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5309", "447", "custom_media_learn_product-free-sec", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5310", "447", "custom_media_learn-pooster-free", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5311", "447", "free_checkbox", "a:1:{i:0;s:1:\"1\";}");
INSERT INTO `wp_postmeta` VALUES("5312", "447", "free-editor-text", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5313", "447", "custom_media_learn_product", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5314", "447", "custom_media_learn-pooster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5315", "447", "custom_img-te", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5316", "447", "custom-te-name", "");
INSERT INTO `wp_postmeta` VALUES("5317", "447", "custom-te-name-bold", "");
INSERT INTO `wp_postmeta` VALUES("5318", "447", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("5319", "447", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("5320", "447", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("5321", "447", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("5322", "447", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("5323", "447", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("5324", "447", "_virtual", "no");
INSERT INTO `wp_postmeta` VALUES("5325", "447", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("5326", "447", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("5327", "447", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("5328", "447", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("5329", "447", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("5330", "447", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("5331", "447", "_product_version", "9.4.3");
INSERT INTO `wp_postmeta` VALUES("5332", "448", "_edit_lock", "1741984585:2");
INSERT INTO `wp_postmeta` VALUES("5333", "448", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("5334", "448", "_visibility", "visible");
INSERT INTO `wp_postmeta` VALUES("5335", "448", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("5336", "448", "_thumbnail_id", "167");
INSERT INTO `wp_postmeta` VALUES("5337", "448", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5338", "448", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("5339", "448", "c", "");
INSERT INTO `wp_postmeta` VALUES("5340", "448", "level-learn-select-position", "");
INSERT INTO `wp_postmeta` VALUES("5341", "448", "editor__title_404_number_in_cart_ase", "به صورت کلاف و شاخه تولید میشود");
INSERT INTO `wp_postmeta` VALUES("5342", "448", "repeater-detail-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5343", "448", "editor-detail-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5344", "448", "title_field_add_item_for_sale_learn_one", "");
INSERT INTO `wp_postmeta` VALUES("5345", "448", "title_field_add_item_for_sale_learn_send_one", "");
INSERT INTO `wp_postmeta` VALUES("5346", "448", "title_field_add_item_for_sale_learn_update_one", "");
INSERT INTO `wp_postmeta` VALUES("5347", "448", "title_field_add_item_for_sale_learn_support_one", "");
INSERT INTO `wp_postmeta` VALUES("5348", "448", "text_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5349", "448", "time_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5350", "448", "level-learn-select", "");
INSERT INTO `wp_postmeta` VALUES("5351", "448", "location_lesson_record", "");
INSERT INTO `wp_postmeta` VALUES("5352", "448", "videos_repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5353", "448", "section_name_part_start", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5354", "448", "lesson-spinner", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5355", "448", "custom_media_learn_product-free-sec", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5356", "448", "custom_media_learn-pooster-free", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5357", "448", "free_checkbox", "a:1:{i:0;s:1:\"1\";}");
INSERT INTO `wp_postmeta` VALUES("5358", "448", "free-editor-text", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5359", "448", "custom_media_learn_product", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5360", "448", "custom_media_learn-pooster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5361", "448", "custom_img-te", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5362", "448", "custom-te-name", "");
INSERT INTO `wp_postmeta` VALUES("5363", "448", "custom-te-name-bold", "");
INSERT INTO `wp_postmeta` VALUES("5364", "448", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("5365", "448", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("5366", "448", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("5367", "448", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("5368", "448", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("5369", "448", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("5370", "448", "_virtual", "no");
INSERT INTO `wp_postmeta` VALUES("5371", "448", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("5372", "448", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("5373", "448", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("5374", "448", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("5375", "448", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("5376", "448", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("5377", "448", "_product_version", "9.4.3");
INSERT INTO `wp_postmeta` VALUES("5560", "454", "_wp_attached_file", "2025/02/عکس-لوله-e1738563610784.jpg");
INSERT INTO `wp_postmeta` VALUES("5561", "454", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:960;s:6:\"height\";i:962;s:4:\"file\";s:42:\"2025/02/عکس-لوله-e1738563610784.jpg\";s:8:\"filesize\";i:89114;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:42:\"عکس-لوله-e1738563610784-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12545;}s:5:\"large\";a:5:{s:4:\"file\";s:28:\"عکس-لوله-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58517;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:42:\"عکس-لوله-e1738563610784-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4728;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:42:\"عکس-لوله-e1738563610784-768x770.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:770;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54280;}s:7:\"153x153\";a:5:{s:4:\"file\";s:42:\"عکس-لوله-e1738563610784-153x153.jpg\";s:5:\"width\";i:153;s:6:\"height\";i:153;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4906;}s:24:\"thumbnail_search_size_60\";a:5:{s:4:\"file\";s:40:\"عکس-لوله-e1738563610784-60x60.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:60;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1624;}s:32:\"thumbnail_product_archive_edu_60\";a:5:{s:4:\"file\";s:42:\"عکس-لوله-e1738563610784-600x601.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:601;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36245;}s:22:\"thumbnail_page-service\";a:5:{s:4:\"file\";s:42:\"عکس-لوله-e1738563610784-600x601.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:601;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36245;}s:28:\"thumbnail_product_archive_60\";a:5:{s:4:\"file\";s:42:\"عکس-لوله-e1738563610784-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4716;}s:6:\"detail\";a:5:{s:4:\"file\";s:42:\"عکس-لوله-e1738563610784-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4728;}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:42:\"عکس-لوله-e1738563610784-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12521;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:42:\"عکس-لوله-e1738563610784-600x601.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:601;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36245;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:42:\"عکس-لوله-e1738563610784-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2888;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5562", "454", "_wp_attachment_backup_sizes", "a:14:{s:9:\"full-orig\";a:4:{s:5:\"width\";i:960;s:6:\"height\";i:1280;s:8:\"filesize\";i:107008;s:4:\"file\";s:19:\"عکس-لوله.jpg\";}s:14:\"thumbnail-orig\";a:5:{s:4:\"file\";s:27:\"عکس-لوله-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4501;}s:11:\"medium-orig\";a:5:{s:4:\"file\";s:27:\"عکس-لوله-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8886;}s:17:\"medium_large-orig\";a:5:{s:4:\"file\";s:28:\"عکس-لوله-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58517;}s:10:\"large-orig\";a:5:{s:4:\"file\";s:28:\"عکس-لوله-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58517;}s:12:\"153x153-orig\";a:5:{s:4:\"file\";s:27:\"عکس-لوله-115x153.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:153;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3624;}s:29:\"thumbnail_search_size_60-orig\";a:5:{s:4:\"file\";s:25:\"عکس-لوله-60x80.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1711;}s:37:\"thumbnail_product_archive_edu_60-orig\";a:5:{s:4:\"file\";s:27:\"عکس-لوله-600x800.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38939;}s:27:\"thumbnail_page-service-orig\";a:5:{s:4:\"file\";s:27:\"عکس-لوله-600x800.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38939;}s:33:\"thumbnail_product_archive_60-orig\";a:5:{s:4:\"file\";s:27:\"عکس-لوله-150x200.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4999;}s:11:\"detail-orig\";a:5:{s:4:\"file\";s:27:\"عکس-لوله-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4501;}s:26:\"woocommerce_thumbnail-orig\";a:6:{s:4:\"file\";s:27:\"عکس-لوله-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11920;s:9:\"uncropped\";b:0;}s:23:\"woocommerce_single-orig\";a:5:{s:4:\"file\";s:27:\"عکس-لوله-600x800.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38939;}s:34:\"woocommerce_gallery_thumbnail-orig\";a:5:{s:4:\"file\";s:27:\"عکس-لوله-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2774;}}");
INSERT INTO `wp_postmeta` VALUES("5613", "456", "_tablepress_table_options", "{\"last_editor\":2,\"table_head\":1,\"table_foot\":0,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":false,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("5614", "456", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1],\"columns\":[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("5615", "459", "_tablepress_table_options", "{\"last_editor\":2,\"table_head\":1,\"table_foot\":0,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":false,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("5616", "459", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1],\"columns\":[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("5617", "461", "_tablepress_table_options", "{\"last_editor\":2,\"table_head\":1,\"table_foot\":0,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":false,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("5618", "461", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1],\"columns\":[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("5634", "464", "_edit_lock", "1741984621:2");
INSERT INTO `wp_postmeta` VALUES("5635", "464", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("5636", "464", "_visibility", "visible");
INSERT INTO `wp_postmeta` VALUES("5637", "464", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("5638", "464", "_thumbnail_id", "454");
INSERT INTO `wp_postmeta` VALUES("5639", "464", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5640", "464", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("5641", "464", "c", "");
INSERT INTO `wp_postmeta` VALUES("5642", "464", "level-learn-select-position", "");
INSERT INTO `wp_postmeta` VALUES("5643", "464", "editor__title_404_number_in_cart_ase", "");
INSERT INTO `wp_postmeta` VALUES("5644", "464", "repeater-detail-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5645", "464", "editor-detail-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5646", "464", "title_field_add_item_for_sale_learn_one", "");
INSERT INTO `wp_postmeta` VALUES("5647", "464", "title_field_add_item_for_sale_learn_send_one", "");
INSERT INTO `wp_postmeta` VALUES("5648", "464", "title_field_add_item_for_sale_learn_update_one", "");
INSERT INTO `wp_postmeta` VALUES("5649", "464", "title_field_add_item_for_sale_learn_support_one", "");
INSERT INTO `wp_postmeta` VALUES("5650", "464", "text_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5651", "464", "time_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5652", "464", "level-learn-select", "");
INSERT INTO `wp_postmeta` VALUES("5653", "464", "location_lesson_record", "");
INSERT INTO `wp_postmeta` VALUES("5654", "464", "videos_repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5655", "464", "section_name_part_start", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5656", "464", "lesson-spinner", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5657", "464", "custom_media_learn_product-free-sec", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5658", "464", "custom_media_learn-pooster-free", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5659", "464", "free_checkbox", "a:1:{i:0;s:1:\"1\";}");
INSERT INTO `wp_postmeta` VALUES("5660", "464", "free-editor-text", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5661", "464", "custom_media_learn_product", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5662", "464", "custom_media_learn-pooster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5663", "464", "custom_img-te", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5664", "464", "custom-te-name", "");
INSERT INTO `wp_postmeta` VALUES("5665", "464", "custom-te-name-bold", "");
INSERT INTO `wp_postmeta` VALUES("5666", "464", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("5667", "464", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("5668", "464", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("5669", "464", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("5670", "464", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("5671", "464", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("5672", "464", "_virtual", "no");
INSERT INTO `wp_postmeta` VALUES("5673", "464", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("5674", "464", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("5675", "464", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("5676", "464", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("5677", "464", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("5678", "464", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("5679", "464", "_product_version", "9.4.3");
INSERT INTO `wp_postmeta` VALUES("5680", "465", "_tablepress_table_options", "{\"last_editor\":2,\"table_head\":1,\"table_foot\":0,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":false,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("5681", "465", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1],\"columns\":[1,1,1,1,1,1,1,1,1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("5682", "467", "_edit_lock", "1738579572:2");
INSERT INTO `wp_postmeta` VALUES("5683", "467", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("5684", "467", "_visibility", "visible");
INSERT INTO `wp_postmeta` VALUES("5685", "467", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("5686", "467", "_thumbnail_id", "454");
INSERT INTO `wp_postmeta` VALUES("5687", "467", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5688", "467", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("5689", "467", "c", "");
INSERT INTO `wp_postmeta` VALUES("5690", "467", "level-learn-select-position", "");
INSERT INTO `wp_postmeta` VALUES("5691", "467", "editor__title_404_number_in_cart_ase", "");
INSERT INTO `wp_postmeta` VALUES("5692", "467", "repeater-detail-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5693", "467", "editor-detail-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5694", "467", "title_field_add_item_for_sale_learn_one", "");
INSERT INTO `wp_postmeta` VALUES("5695", "467", "title_field_add_item_for_sale_learn_send_one", "");
INSERT INTO `wp_postmeta` VALUES("5696", "467", "title_field_add_item_for_sale_learn_update_one", "");
INSERT INTO `wp_postmeta` VALUES("5697", "467", "title_field_add_item_for_sale_learn_support_one", "");
INSERT INTO `wp_postmeta` VALUES("5698", "467", "text_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5699", "467", "time_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5700", "467", "level-learn-select", "");
INSERT INTO `wp_postmeta` VALUES("5701", "467", "location_lesson_record", "");
INSERT INTO `wp_postmeta` VALUES("5702", "467", "videos_repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5703", "467", "section_name_part_start", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5704", "467", "lesson-spinner", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5705", "467", "custom_media_learn_product-free-sec", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5706", "467", "custom_media_learn-pooster-free", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5707", "467", "free_checkbox", "a:1:{i:0;s:1:\"1\";}");
INSERT INTO `wp_postmeta` VALUES("5708", "467", "free-editor-text", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5709", "467", "custom_media_learn_product", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5710", "467", "custom_media_learn-pooster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5711", "467", "custom_img-te", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5712", "467", "custom-te-name", "");
INSERT INTO `wp_postmeta` VALUES("5713", "467", "custom-te-name-bold", "");
INSERT INTO `wp_postmeta` VALUES("5714", "467", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("5715", "467", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("5716", "467", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("5717", "467", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("5718", "467", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("5719", "467", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("5720", "467", "_virtual", "no");
INSERT INTO `wp_postmeta` VALUES("5721", "467", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("5722", "467", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("5723", "467", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("5724", "467", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("5725", "467", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("5726", "467", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("5727", "467", "_product_version", "9.4.3");
INSERT INTO `wp_postmeta` VALUES("5728", "468", "_tablepress_table_options", "{\"last_editor\":2,\"table_head\":1,\"table_foot\":0,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":false,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("5729", "468", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1],\"columns\":[1,1,1,1,1,1,1,1,1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("5730", "470", "_edit_lock", "1738580044:2");
INSERT INTO `wp_postmeta` VALUES("5731", "470", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("5732", "470", "_visibility", "visible");
INSERT INTO `wp_postmeta` VALUES("5733", "470", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("5734", "470", "_thumbnail_id", "454");
INSERT INTO `wp_postmeta` VALUES("5735", "470", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5736", "470", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("5737", "470", "c", "");
INSERT INTO `wp_postmeta` VALUES("5738", "470", "level-learn-select-position", "");
INSERT INTO `wp_postmeta` VALUES("5739", "470", "editor__title_404_number_in_cart_ase", "");
INSERT INTO `wp_postmeta` VALUES("5740", "470", "repeater-detail-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5741", "470", "editor-detail-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5742", "470", "title_field_add_item_for_sale_learn_one", "");
INSERT INTO `wp_postmeta` VALUES("5743", "470", "title_field_add_item_for_sale_learn_send_one", "");
INSERT INTO `wp_postmeta` VALUES("5744", "470", "title_field_add_item_for_sale_learn_update_one", "");
INSERT INTO `wp_postmeta` VALUES("5745", "470", "title_field_add_item_for_sale_learn_support_one", "");
INSERT INTO `wp_postmeta` VALUES("5746", "470", "text_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5747", "470", "time_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5748", "470", "level-learn-select", "");
INSERT INTO `wp_postmeta` VALUES("5749", "470", "location_lesson_record", "");
INSERT INTO `wp_postmeta` VALUES("5750", "470", "videos_repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5751", "470", "section_name_part_start", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5752", "470", "lesson-spinner", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5753", "470", "custom_media_learn_product-free-sec", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5754", "470", "custom_media_learn-pooster-free", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5755", "470", "free_checkbox", "a:1:{i:0;s:1:\"1\";}");
INSERT INTO `wp_postmeta` VALUES("5756", "470", "free-editor-text", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5757", "470", "custom_media_learn_product", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5758", "470", "custom_media_learn-pooster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5759", "470", "custom_img-te", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5760", "470", "custom-te-name", "");
INSERT INTO `wp_postmeta` VALUES("5761", "470", "custom-te-name-bold", "");
INSERT INTO `wp_postmeta` VALUES("5762", "470", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("5763", "470", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("5764", "470", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("5765", "470", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("5766", "470", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("5767", "470", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("5768", "470", "_virtual", "no");
INSERT INTO `wp_postmeta` VALUES("5769", "470", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("5770", "470", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("5771", "470", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("5772", "470", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("5773", "470", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("5774", "470", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("5775", "470", "_product_version", "9.4.3");
INSERT INTO `wp_postmeta` VALUES("5776", "471", "_tablepress_table_options", "{\"last_editor\":2,\"table_head\":1,\"table_foot\":0,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":false,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("5777", "471", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1],\"columns\":[1,1,1,1,1,1,1,1,1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("5778", "473", "_edit_lock", "1738579964:2");
INSERT INTO `wp_postmeta` VALUES("5779", "473", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("5780", "473", "_visibility", "visible");
INSERT INTO `wp_postmeta` VALUES("5781", "473", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("5782", "473", "_thumbnail_id", "454");
INSERT INTO `wp_postmeta` VALUES("5783", "473", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5784", "473", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("5785", "473", "c", "");
INSERT INTO `wp_postmeta` VALUES("5786", "473", "level-learn-select-position", "");
INSERT INTO `wp_postmeta` VALUES("5787", "473", "editor__title_404_number_in_cart_ase", "");
INSERT INTO `wp_postmeta` VALUES("5788", "473", "repeater-detail-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5789", "473", "editor-detail-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5790", "473", "title_field_add_item_for_sale_learn_one", "");
INSERT INTO `wp_postmeta` VALUES("5791", "473", "title_field_add_item_for_sale_learn_send_one", "");
INSERT INTO `wp_postmeta` VALUES("5792", "473", "title_field_add_item_for_sale_learn_update_one", "");
INSERT INTO `wp_postmeta` VALUES("5793", "473", "title_field_add_item_for_sale_learn_support_one", "");
INSERT INTO `wp_postmeta` VALUES("5794", "473", "text_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5795", "473", "time_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5796", "473", "level-learn-select", "");
INSERT INTO `wp_postmeta` VALUES("5797", "473", "location_lesson_record", "");
INSERT INTO `wp_postmeta` VALUES("5798", "473", "videos_repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5799", "473", "section_name_part_start", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5800", "473", "lesson-spinner", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5801", "473", "custom_media_learn_product-free-sec", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5802", "473", "custom_media_learn-pooster-free", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5803", "473", "free_checkbox", "a:1:{i:0;s:1:\"1\";}");
INSERT INTO `wp_postmeta` VALUES("5804", "473", "free-editor-text", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5805", "473", "custom_media_learn_product", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5806", "473", "custom_media_learn-pooster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5807", "473", "custom_img-te", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5808", "473", "custom-te-name", "");
INSERT INTO `wp_postmeta` VALUES("5809", "473", "custom-te-name-bold", "");
INSERT INTO `wp_postmeta` VALUES("5810", "473", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("5811", "473", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("5812", "473", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("5813", "473", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("5814", "473", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("5815", "473", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("5816", "473", "_virtual", "no");
INSERT INTO `wp_postmeta` VALUES("5817", "473", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("5818", "473", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("5819", "473", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("5820", "473", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("5821", "473", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("5822", "473", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("5823", "473", "_product_version", "9.4.3");
INSERT INTO `wp_postmeta` VALUES("5824", "474", "_tablepress_table_options", "{\"last_editor\":2,\"table_head\":1,\"table_foot\":0,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":false,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("5825", "474", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1],\"columns\":[1,1,1,1,1,1,1,1,1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("5826", "477", "_edit_lock", "1738741450:2");
INSERT INTO `wp_postmeta` VALUES("5827", "477", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("5828", "477", "_visibility", "visible");
INSERT INTO `wp_postmeta` VALUES("5829", "477", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("5830", "477", "_thumbnail_id", "454");
INSERT INTO `wp_postmeta` VALUES("5831", "477", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5832", "477", "redux-metabox-section", "");
INSERT INTO `wp_postmeta` VALUES("5833", "477", "c", "");
INSERT INTO `wp_postmeta` VALUES("5834", "477", "level-learn-select-position", "");
INSERT INTO `wp_postmeta` VALUES("5835", "477", "editor__title_404_number_in_cart_ase", "");
INSERT INTO `wp_postmeta` VALUES("5836", "477", "repeater-detail-field-id-accordion", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5837", "477", "editor-detail-text-lic", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5838", "477", "title_field_add_item_for_sale_learn_one", "");
INSERT INTO `wp_postmeta` VALUES("5839", "477", "title_field_add_item_for_sale_learn_send_one", "");
INSERT INTO `wp_postmeta` VALUES("5840", "477", "title_field_add_item_for_sale_learn_update_one", "");
INSERT INTO `wp_postmeta` VALUES("5841", "477", "title_field_add_item_for_sale_learn_support_one", "");
INSERT INTO `wp_postmeta` VALUES("5842", "477", "text_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5843", "477", "time_lesson_number", "");
INSERT INTO `wp_postmeta` VALUES("5844", "477", "level-learn-select", "");
INSERT INTO `wp_postmeta` VALUES("5845", "477", "location_lesson_record", "");
INSERT INTO `wp_postmeta` VALUES("5846", "477", "videos_repeater", "a:1:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("5847", "477", "section_name_part_start", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5848", "477", "lesson-spinner", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5849", "477", "custom_media_learn_product-free-sec", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5850", "477", "custom_media_learn-pooster-free", "a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("5851", "477", "free_checkbox", "a:1:{i:0;s:1:\"1\";}");
INSERT INTO `wp_postmeta` VALUES("5852", "477", "free-editor-text", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5853", "477", "custom_media_learn_product", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5854", "477", "custom_media_learn-pooster", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5855", "477", "custom_img-te", "a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5856", "477", "custom-te-name", "");
INSERT INTO `wp_postmeta` VALUES("5857", "477", "custom-te-name-bold", "");
INSERT INTO `wp_postmeta` VALUES("5858", "477", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("5859", "477", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("5860", "477", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("5861", "477", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("5862", "477", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("5863", "477", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("5864", "477", "_virtual", "no");
INSERT INTO `wp_postmeta` VALUES("5865", "477", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("5866", "477", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("5867", "477", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("5868", "477", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("5869", "477", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("5870", "477", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("5871", "477", "_product_version", "9.4.3");
INSERT INTO `wp_postmeta` VALUES("5874", "479", "_tablepress_table_options", "{\"last_editor\":2,\"table_head\":1,\"table_foot\":0,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":true,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("5875", "479", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1],\"columns\":[1,1,1,1,1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("5876", "492", "_tablepress_table_options", "{\"last_editor\":2,\"table_head\":1,\"table_foot\":0,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":true,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("5877", "492", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1],\"columns\":[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("5878", "494", "_tablepress_table_options", "{\"last_editor\":2,\"table_head\":1,\"table_foot\":0,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":true,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("5879", "494", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1],\"columns\":[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("5880", "496", "_tablepress_table_options", "{\"last_editor\":2,\"table_head\":1,\"table_foot\":0,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":true,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("5881", "496", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1],\"columns\":[1,1,1,1,1,1,1,1,1,1,1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("5882", "499", "_tablepress_table_options", "{\"last_editor\":2,\"table_head\":1,\"table_foot\":0,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":true,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("5883", "499", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1],\"columns\":[1,1,1,1,1,1,1,1,1,1,1]}");
INSERT INTO `wp_postmeta` VALUES("5884", "503", "_wp_attached_file", "2025/02/اتصالات.jpg");
INSERT INTO `wp_postmeta` VALUES("5885", "503", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:1280;s:4:\"file\";s:26:\"2025/02/اتصالات.jpg\";s:8:\"filesize\";i:43764;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"اتصالات-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8515;}s:5:\"large\";a:5:{s:4:\"file\";s:28:\"اتصالات-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45681;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"اتصالات-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3759;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:26:\"اتصالات-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30248;}s:7:\"153x153\";a:5:{s:4:\"file\";s:26:\"اتصالات-153x153.jpg\";s:5:\"width\";i:153;s:6:\"height\";i:153;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3836;}s:24:\"thumbnail_search_size_60\";a:5:{s:4:\"file\";s:24:\"اتصالات-60x60.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:60;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1596;}s:32:\"thumbnail_product_archive_edu_60\";a:5:{s:4:\"file\";s:26:\"اتصالات-600x600.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:600;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21364;}s:22:\"thumbnail_page-service\";a:5:{s:4:\"file\";s:26:\"اتصالات-600x600.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:600;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21364;}s:28:\"thumbnail_product_archive_60\";a:5:{s:4:\"file\";s:26:\"اتصالات-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3759;}s:6:\"detail\";a:5:{s:4:\"file\";s:26:\"اتصالات-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3759;}s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:26:\"اتصالات-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8515;s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:26:\"اتصالات-600x600.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:600;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21364;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:26:\"اتصالات-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2435;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5886", "504", "_wp_attached_file", "2025/02/منهول.jpg");
INSERT INTO `wp_postmeta` VALUES("5887", "504", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:22:\"2025/02/منهول.jpg\";s:8:\"filesize\";i:61969;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"منهول-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6533;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"منهول-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38875;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"منهول-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3903;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:22:\"منهول-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24775;}s:7:\"153x153\";a:5:{s:4:\"file\";s:22:\"منهول-153x115.jpg\";s:5:\"width\";i:153;s:6:\"height\";i:115;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2950;}s:24:\"thumbnail_search_size_60\";a:5:{s:4:\"file\";s:20:\"منهول-60x45.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:45;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1307;}s:32:\"thumbnail_product_archive_edu_60\";a:5:{s:4:\"file\";s:22:\"منهول-600x450.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17196;}s:22:\"thumbnail_page-service\";a:5:{s:4:\"file\";s:22:\"منهول-600x450.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17196;}s:28:\"thumbnail_product_archive_60\";a:5:{s:4:\"file\";s:22:\"منهول-150x113.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:113;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2877;}s:6:\"detail\";a:5:{s:4:\"file\";s:22:\"منهول-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3903;}s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:22:\"منهول-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9219;s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:22:\"منهول-600x450.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17196;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:22:\"منهول-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2505;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5888", "505", "_wp_attached_file", "2025/02/منهول-پلی-اتیلن.jpg");
INSERT INTO `wp_postmeta` VALUES("5889", "505", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:577;s:6:\"height\";i:433;s:4:\"file\";s:40:\"2025/02/منهول-پلی-اتیلن.jpg\";s:8:\"filesize\";i:16588;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:40:\"منهول-پلی-اتیلن-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6258;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:40:\"منهول-پلی-اتیلن-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3640;}s:7:\"153x153\";a:5:{s:4:\"file\";s:40:\"منهول-پلی-اتیلن-153x115.jpg\";s:5:\"width\";i:153;s:6:\"height\";i:115;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2901;}s:24:\"thumbnail_search_size_60\";a:5:{s:4:\"file\";s:38:\"منهول-پلی-اتیلن-60x45.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:45;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1293;}s:28:\"thumbnail_product_archive_60\";a:5:{s:4:\"file\";s:40:\"منهول-پلی-اتیلن-150x113.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:113;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2884;}s:6:\"detail\";a:5:{s:4:\"file\";s:40:\"منهول-پلی-اتیلن-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3640;}s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:40:\"منهول-پلی-اتیلن-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8390;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:40:\"منهول-پلی-اتیلن-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2424;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5890", "506", "_wp_attached_file", "2025/02/IMG_8983-e1739263249971.png");
INSERT INTO `wp_postmeta` VALUES("5891", "506", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:488;s:6:\"height\";i:383;s:4:\"file\";s:35:\"2025/02/IMG_8983-e1739263249971.png\";s:8:\"filesize\";i:140788;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:35:\"IMG_8983-e1739263249971-300x235.png\";s:5:\"width\";i:300;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:59845;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:35:\"IMG_8983-e1739263249971-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:27212;}s:7:\"153x153\";a:5:{s:4:\"file\";s:35:\"IMG_8983-e1739263249971-153x120.png\";s:5:\"width\";i:153;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:18863;}s:24:\"thumbnail_search_size_60\";a:5:{s:4:\"file\";s:33:\"IMG_8983-e1739263249971-60x47.png\";s:5:\"width\";i:60;s:6:\"height\";i:47;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4019;}s:28:\"thumbnail_product_archive_60\";a:5:{s:4:\"file\";s:35:\"IMG_8983-e1739263249971-150x118.png\";s:5:\"width\";i:150;s:6:\"height\";i:118;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:18228;}s:6:\"detail\";a:5:{s:4:\"file\";s:35:\"IMG_8983-e1739263249971-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:27212;}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:35:\"IMG_8983-e1739263249971-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:89509;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:35:\"IMG_8983-e1739263249971-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13570;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5892", "506", "_wp_attachment_backup_sizes", "a:18:{s:9:\"full-orig\";a:4:{s:5:\"width\";i:577;s:6:\"height\";i:433;s:8:\"filesize\";i:156583;s:4:\"file\";s:12:\"IMG_8983.png\";}s:14:\"thumbnail-orig\";a:5:{s:4:\"file\";s:20:\"IMG_8983-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:22361;}s:11:\"medium-orig\";a:5:{s:4:\"file\";s:20:\"IMG_8983-300x225.png\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:45245;}s:12:\"153x153-orig\";a:5:{s:4:\"file\";s:20:\"IMG_8983-153x115.png\";s:5:\"width\";i:153;s:6:\"height\";i:115;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14296;}s:29:\"thumbnail_search_size_60-orig\";a:5:{s:4:\"file\";s:18:\"IMG_8983-60x45.png\";s:5:\"width\";i:60;s:6:\"height\";i:45;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3108;}s:33:\"thumbnail_product_archive_60-orig\";a:5:{s:4:\"file\";s:20:\"IMG_8983-150x113.png\";s:5:\"width\";i:150;s:6:\"height\";i:113;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13867;}s:11:\"detail-orig\";a:5:{s:4:\"file\";s:20:\"IMG_8983-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:22361;}s:26:\"woocommerce_thumbnail-orig\";a:6:{s:4:\"file\";s:20:\"IMG_8983-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:73509;s:9:\"uncropped\";b:0;}s:34:\"woocommerce_gallery_thumbnail-orig\";a:5:{s:4:\"file\";s:20:\"IMG_8983-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:11124;}s:18:\"full-1739256685519\";a:4:{s:5:\"width\";i:513;s:6:\"height\";i:371;s:8:\"filesize\";i:140971;s:4:\"file\";s:27:\"IMG_8983-e1739255562144.png\";}s:23:\"thumbnail-1739256685519\";a:5:{s:4:\"file\";s:35:\"IMG_8983-e1739255562144-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:28399;}s:20:\"medium-1739256685519\";a:5:{s:4:\"file\";s:35:\"IMG_8983-e1739255562144-300x217.png\";s:5:\"width\";i:300;s:6:\"height\";i:217;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:54949;}s:21:\"153x153-1739256685519\";a:5:{s:4:\"file\";s:35:\"IMG_8983-e1739255562144-153x111.png\";s:5:\"width\";i:153;s:6:\"height\";i:111;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17359;}s:38:\"thumbnail_search_size_60-1739256685519\";a:5:{s:4:\"file\";s:33:\"IMG_8983-e1739255562144-60x43.png\";s:5:\"width\";i:60;s:6:\"height\";i:43;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3695;}s:42:\"thumbnail_product_archive_60-1739256685519\";a:5:{s:4:\"file\";s:35:\"IMG_8983-e1739255562144-150x108.png\";s:5:\"width\";i:150;s:6:\"height\";i:108;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:16695;}s:20:\"detail-1739256685519\";a:5:{s:4:\"file\";s:35:\"IMG_8983-e1739255562144-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:28399;}s:35:\"woocommerce_thumbnail-1739256685519\";a:5:{s:4:\"file\";s:35:\"IMG_8983-e1739255562144-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:93519;}s:43:\"woocommerce_gallery_thumbnail-1739256685519\";a:5:{s:4:\"file\";s:35:\"IMG_8983-e1739255562144-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14152;}}");
INSERT INTO `wp_postmeta` VALUES("5893", "507", "_wp_attached_file", "2025/02/photo_2025-02-11_12-49-24.jpg");
INSERT INTO `wp_postmeta` VALUES("5894", "507", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:433;s:6:\"height\";i:577;s:4:\"file\";s:37:\"2025/02/photo_2025-02-11_12-49-24.jpg\";s:8:\"filesize\";i:22166;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-24-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10774;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-24-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5951;}s:7:\"153x153\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-24-115x153.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:153;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4219;}s:24:\"thumbnail_search_size_60\";a:5:{s:4:\"file\";s:35:\"photo_2025-02-11_12-49-24-60x80.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1872;}s:28:\"thumbnail_product_archive_60\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-24-150x200.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6074;}s:6:\"detail\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-24-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5951;}s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-24-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15874;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-24-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3434;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5895", "508", "_wp_attached_file", "2025/02/photo_2025-02-11_12-49-35-e1739272031332.jpg");
INSERT INTO `wp_postmeta` VALUES("5896", "508", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:262;s:6:\"height\";i:280;s:4:\"file\";s:52:\"2025/02/photo_2025-02-11_12-49-35-e1739272031332.jpg\";s:8:\"filesize\";i:17291;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-35-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11700;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:52:\"photo_2025-02-11_12-49-35-e1739272031332-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7292;}s:7:\"153x153\";a:5:{s:4:\"file\";s:52:\"photo_2025-02-11_12-49-35-e1739272031332-143x153.jpg\";s:5:\"width\";i:143;s:6:\"height\";i:153;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6921;}s:24:\"thumbnail_search_size_60\";a:5:{s:4:\"file\";s:50:\"photo_2025-02-11_12-49-35-e1739272031332-60x64.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:64;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2334;}s:28:\"thumbnail_product_archive_60\";a:5:{s:4:\"file\";s:52:\"photo_2025-02-11_12-49-35-e1739272031332-150x160.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7333;}s:6:\"detail\";a:5:{s:4:\"file\";s:52:\"photo_2025-02-11_12-49-35-e1739272031332-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7292;}s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-35-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17335;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:52:\"photo_2025-02-11_12-49-35-e1739272031332-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4222;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5897", "509", "_wp_attached_file", "2025/02/photo_2025-02-11_12-49-35-1-e1739272226412.jpg");
INSERT INTO `wp_postmeta` VALUES("5898", "509", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:384;s:6:\"height\";i:421;s:4:\"file\";s:54:\"2025/02/photo_2025-02-11_12-49-35-1-e1739272226412.jpg\";s:8:\"filesize\";i:31721;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:54:\"photo_2025-02-11_12-49-35-1-e1739272226412-274x300.jpg\";s:5:\"width\";i:274;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17918;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:54:\"photo_2025-02-11_12-49-35-1-e1739272226412-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7479;}s:7:\"153x153\";a:5:{s:4:\"file\";s:54:\"photo_2025-02-11_12-49-35-1-e1739272226412-140x153.jpg\";s:5:\"width\";i:140;s:6:\"height\";i:153;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6875;}s:24:\"thumbnail_search_size_60\";a:5:{s:4:\"file\";s:52:\"photo_2025-02-11_12-49-35-1-e1739272226412-60x66.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2300;}s:28:\"thumbnail_product_archive_60\";a:5:{s:4:\"file\";s:54:\"photo_2025-02-11_12-49-35-1-e1739272226412-150x164.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7590;}s:6:\"detail\";a:5:{s:4:\"file\";s:54:\"photo_2025-02-11_12-49-35-1-e1739272226412-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7479;}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:54:\"photo_2025-02-11_12-49-35-1-e1739272226412-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20083;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:54:\"photo_2025-02-11_12-49-35-1-e1739272226412-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4251;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5899", "509", "_wp_attachment_backup_sizes", "a:19:{s:9:\"full-orig\";a:4:{s:5:\"width\";i:433;s:6:\"height\";i:577;s:8:\"filesize\";i:24205;s:4:\"file\";s:31:\"photo_2025-02-11_12-49-35-1.jpg\";}s:14:\"thumbnail-orig\";a:5:{s:4:\"file\";s:39:\"photo_2025-02-11_12-49-35-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6403;}s:11:\"medium-orig\";a:5:{s:4:\"file\";s:39:\"photo_2025-02-11_12-49-35-1-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11700;}s:12:\"153x153-orig\";a:5:{s:4:\"file\";s:39:\"photo_2025-02-11_12-49-35-1-115x153.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:153;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4633;}s:29:\"thumbnail_search_size_60-orig\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-35-1-60x80.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2078;}s:33:\"thumbnail_product_archive_60-orig\";a:5:{s:4:\"file\";s:39:\"photo_2025-02-11_12-49-35-1-150x200.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6503;}s:11:\"detail-orig\";a:5:{s:4:\"file\";s:39:\"photo_2025-02-11_12-49-35-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6403;}s:26:\"woocommerce_thumbnail-orig\";a:6:{s:4:\"file\";s:39:\"photo_2025-02-11_12-49-35-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17335;s:9:\"uncropped\";b:0;}s:34:\"woocommerce_gallery_thumbnail-orig\";a:5:{s:4:\"file\";s:39:\"photo_2025-02-11_12-49-35-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3679;}s:18:\"full-1739271775828\";a:4:{s:5:\"width\";i:387;s:6:\"height\";i:422;s:8:\"filesize\";i:32194;s:4:\"file\";s:46:\"photo_2025-02-11_12-49-35-1-e1739269607599.jpg\";}s:18:\"full-1739272197890\";a:4:{s:5:\"width\";i:150;s:6:\"height\";i:164;s:8:\"filesize\";i:7531;s:4:\"file\";s:46:\"photo_2025-02-11_12-49-35-1-e1739271775828.jpg\";}s:23:\"thumbnail-1739272197890\";a:5:{s:4:\"file\";s:54:\"photo_2025-02-11_12-49-35-1-e1739269607599-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7465;}s:20:\"medium-1739272197890\";a:5:{s:4:\"file\";s:54:\"photo_2025-02-11_12-49-35-1-e1739269607599-275x300.jpg\";s:5:\"width\";i:275;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17763;}s:21:\"153x153-1739272197890\";a:5:{s:4:\"file\";s:54:\"photo_2025-02-11_12-49-35-1-e1739269607599-140x153.jpg\";s:5:\"width\";i:140;s:6:\"height\";i:153;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6810;}s:38:\"thumbnail_search_size_60-1739272197890\";a:5:{s:4:\"file\";s:52:\"photo_2025-02-11_12-49-35-1-e1739269607599-60x65.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:65;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2263;}s:42:\"thumbnail_product_archive_60-1739272197890\";a:5:{s:4:\"file\";s:54:\"photo_2025-02-11_12-49-35-1-e1739269607599-150x164.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7518;}s:20:\"detail-1739272197890\";a:5:{s:4:\"file\";s:54:\"photo_2025-02-11_12-49-35-1-e1739269607599-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7465;}s:35:\"woocommerce_thumbnail-1739272197890\";a:5:{s:4:\"file\";s:54:\"photo_2025-02-11_12-49-35-1-e1739269607599-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20044;}s:43:\"woocommerce_gallery_thumbnail-1739272197890\";a:5:{s:4:\"file\";s:54:\"photo_2025-02-11_12-49-35-1-e1739269607599-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4232;}}");
INSERT INTO `wp_postmeta` VALUES("5900", "510", "_wp_attached_file", "2025/02/photo_2025-02-11_14-25-55-e1739271533272.jpg");
INSERT INTO `wp_postmeta` VALUES("5901", "510", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:494;s:6:\"height\";i:379;s:4:\"file\";s:52:\"2025/02/photo_2025-02-11_14-25-55-e1739271533272.jpg\";s:8:\"filesize\";i:18960;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:52:\"photo_2025-02-11_14-25-55-e1739271533272-300x230.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9028;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:52:\"photo_2025-02-11_14-25-55-e1739271533272-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4652;}s:7:\"153x153\";a:5:{s:4:\"file\";s:52:\"photo_2025-02-11_14-25-55-e1739271533272-153x117.jpg\";s:5:\"width\";i:153;s:6:\"height\";i:117;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3996;}s:24:\"thumbnail_search_size_60\";a:5:{s:4:\"file\";s:50:\"photo_2025-02-11_14-25-55-e1739271533272-60x46.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:46;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1615;}s:28:\"thumbnail_product_archive_60\";a:5:{s:4:\"file\";s:52:\"photo_2025-02-11_14-25-55-e1739271533272-150x115.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:115;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3915;}s:6:\"detail\";a:5:{s:4:\"file\";s:52:\"photo_2025-02-11_14-25-55-e1739271533272-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4652;}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:52:\"photo_2025-02-11_14-25-55-e1739271533272-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11068;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:52:\"photo_2025-02-11_14-25-55-e1739271533272-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2949;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5902", "510", "_wp_attachment_backup_sizes", "a:9:{s:9:\"full-orig\";a:4:{s:5:\"width\";i:577;s:6:\"height\";i:433;s:8:\"filesize\";i:14606;s:4:\"file\";s:29:\"photo_2025-02-11_14-25-55.jpg\";}s:14:\"thumbnail-orig\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_14-25-55-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4455;}s:11:\"medium-orig\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_14-25-55-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7782;}s:12:\"153x153-orig\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_14-25-55-153x115.jpg\";s:5:\"width\";i:153;s:6:\"height\";i:115;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3494;}s:29:\"thumbnail_search_size_60-orig\";a:5:{s:4:\"file\";s:35:\"photo_2025-02-11_14-25-55-60x45.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:45;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1505;}s:33:\"thumbnail_product_archive_60-orig\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_14-25-55-150x113.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:113;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3387;}s:11:\"detail-orig\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_14-25-55-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4455;}s:26:\"woocommerce_thumbnail-orig\";a:6:{s:4:\"file\";s:37:\"photo_2025-02-11_14-25-55-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10530;s:9:\"uncropped\";b:0;}s:34:\"woocommerce_gallery_thumbnail-orig\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_14-25-55-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2833;}}");
INSERT INTO `wp_postmeta` VALUES("5903", "508", "_wp_attachment_backup_sizes", "a:10:{s:9:\"full-orig\";a:4:{s:5:\"width\";i:433;s:6:\"height\";i:577;s:8:\"filesize\";i:24205;s:4:\"file\";s:29:\"photo_2025-02-11_12-49-35.jpg\";}s:18:\"full-1739272031332\";a:4:{s:5:\"width\";i:300;s:6:\"height\";i:400;s:8:\"filesize\";i:17740;s:4:\"file\";s:44:\"photo_2025-02-11_12-49-35-e1739271946643.jpg\";}s:14:\"thumbnail-orig\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-35-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6403;}s:11:\"medium-orig\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-35-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11700;}s:12:\"153x153-orig\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-35-115x153.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:153;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4633;}s:29:\"thumbnail_search_size_60-orig\";a:5:{s:4:\"file\";s:35:\"photo_2025-02-11_12-49-35-60x80.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2078;}s:33:\"thumbnail_product_archive_60-orig\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-35-150x200.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6503;}s:11:\"detail-orig\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-35-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6403;}s:26:\"woocommerce_thumbnail-orig\";a:6:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-35-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17335;s:9:\"uncropped\";b:0;}s:34:\"woocommerce_gallery_thumbnail-orig\";a:5:{s:4:\"file\";s:37:\"photo_2025-02-11_12-49-35-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3679;}}");
INSERT INTO `wp_postmeta` VALUES("5904", "511", "_wp_attached_file", "2025/02/photo_2025-02-11_12-49-