<?php
if ( !class_exists('Puc_v4p6_Factory', false) ): class Puc_v4p6_Factory { protected static $classVersions = array(); protected static $sorted = false; protected static $myMajorVersion = ''; protected static $latestCompatibleVersion = ''; public static function buildUpdateChecker($metadataUrl, $fullPath, $slug = '', $checkPeriod = 12, $optionName = '', $muPluginFile = '') { $fullPath = self::normalizePath($fullPath); $id = null; $themeDirectory = self::getThemeDirectoryName($fullPath); if ( self::isPluginFile($fullPath) ) { $type = 'Plugin'; $id = $fullPath; } else if ( $themeDirectory !== null ) { $type = 'Theme'; $id = $themeDirectory; } else { throw new RuntimeException(sprintf( 'The update checker cannot determine if "%s" is a plugin or a theme. ' . 'This is a bug. Please contact the PUC developer.', htmlentities($fullPath) )); } $service = self::getVcsService($metadataUrl); $apiClass = null; if ( empty($service) ) { $checkerClass = $type . '_UpdateChecker'; } else { $checkerClass = 'Vcs_' . $type . 'UpdateChecker'; $apiClass = $service . 'Api'; } $checkerClass = self::getCompatibleClassVersion($checkerClass); if ( $checkerClass === null ) { return null; } if ( !isset($apiClass) ) { return new $checkerClass($metadataUrl, $id, $slug, $checkPeriod, $optionName, $muPluginFile); } else { $apiClass = self::getCompatibleClassVersion($apiClass); if ( $apiClass === null ) { return null; } return new $checkerClass( new $apiClass($metadataUrl), $id, $slug, $checkPeriod, $optionName, $muPluginFile ); } } public static function normalizePath($path) { if ( function_exists('wp_normalize_path') ) { return wp_normalize_path($path); } $path = str_replace('\\', '/', $path); $path = preg_replace('|(?<=.)/+|', '/', $path); if ( substr($path, 1, 1) === ':' ) { $path = ucfirst($path); } return $path; } protected static function isPluginFile($absolutePath) { $pluginDir = self::normalizePath(WP_PLUGIN_DIR); $muPluginDir = self::normalizePath(WPMU_PLUGIN_DIR); if ( (strpos($absolutePath, $pluginDir) === 0) || (strpos($absolutePath, $muPluginDir) === 0) ) { return true; } if ( !is_file($absolutePath) ) { return false; } if ( function_exists('get_file_data') ) { $headers = get_file_data($absolutePath, array('Name' => 'Plugin Name'), 'plugin'); return !empty($headers['Name']); } return false; } protected static function getThemeDirectoryName($absolutePath) { if ( is_file($absolutePath) ) { $absolutePath = dirname($absolutePath); } if ( file_exists($absolutePath . '/style.css') ) { return basename($absolutePath); } return null; } private static function getVcsService($metadataUrl) { $service = null; $host = @parse_url($metadataUrl, PHP_URL_HOST); $path = @parse_url($metadataUrl, PHP_URL_PATH); $repoRegex = '@^/?([^/]+?)/([^/#?&]+?)/?$@'; if ( $host === 'gitlab.com' ) { $repoRegex = '@^/?(?:[^/#?&]++/){1,20}(?:[^/#?&]++)/?$@'; } if ( preg_match($repoRegex, $path) ) { $knownServices = array( 'github.com' => 'GitHub', 'bitbucket.org' => 'BitBucket', 'gitlab.com' => 'GitLab', ); if ( isset($knownServices[$host]) ) { $service = $knownServices[$host]; } } return apply_filters('puc_get_vcs_service', $service, $host, $path, $metadataUrl); } protected static function getCompatibleClassVersion($class) { if ( isset(self::$classVersions[$class][self::$latestCompatibleVersion]) ) { return self::$classVersions[$class][self::$latestCompatibleVersion]; } return null; } public static function getLatestClassVersion($class) { if ( !self::$sorted ) { self::sortVersions(); } if ( isset(self::$classVersions[$class]) ) { return reset(self::$classVersions[$class]); } else { return null; } } protected static function sortVersions() { foreach ( self::$classVersions as $class => $versions ) { uksort($versions, array(__CLASS__, 'compareVersions')); self::$classVersions[$class] = $versions; } self::$sorted = true; } protected static function compareVersions($a, $b) { return -version_compare($a, $b); } public static function addVersion($generalClass, $versionedClass, $version) { if ( empty(self::$myMajorVersion) ) { $nameParts = explode('_', __CLASS__, 3); self::$myMajorVersion = substr(ltrim($nameParts[1], 'v'), 0, 1); } $components = explode('.', $version); if ( $components[0] === self::$myMajorVersion ) { if ( empty(self::$latestCompatibleVersion) || version_compare($version, self::$latestCompatibleVersion, '>') ) { self::$latestCompatibleVersion = $version; } } if ( !isset(self::$classVersions[$generalClass]) ) { self::$classVersions[$generalClass] = array(); } self::$classVersions[$generalClass][$version] = $versionedClass; self::$sorted = false; } } endif; 