<?php

defined('ABSPATH') || exit;

function dig_get_state_list()
{
    return array(
        'AF' => array(),
        'AL' => array( // Albanian states.
            'AL-01' => __('Berat', 'digits'),
            'AL-09' => __('Dibër', 'digits'),
            'AL-02' => __('Durrës', 'digits'),
            'AL-03' => __('Elbasan', 'digits'),
            'AL-04' => __('Fier', 'digits'),
            'AL-05' => __('Gjirokastër', 'digits'),
            'AL-06' => __('Korçë', 'digits'),
            'AL-07' => __('Kukës', 'digits'),
            'AL-08' => __('Lezhë', 'digits'),
            'AL-10' => __('Shkodër', 'digits'),
            'AL-11' => __('Tirana', 'digits'),
            'AL-12' => __('Vlorë', 'digits'),
        ),
        'AO' => array( // Angolan states.
            'BGO' => __('Bengo', 'digits'),
            'BLU' => __('Benguela', 'digits'),
            'BIE' => __('Bié', 'digits'),
            'CAB' => __('Cabinda', 'digits'),
            'CNN' => __('Cunene', 'digits'),
            'HUA' => __('Huambo', 'digits'),
            'HUI' => __('Huíla', 'digits'),
            'CCU' => __('Kuando Kubango', 'digits'),
            'CNO' => __('Kwanza-Norte', 'digits'),
            'CUS' => __('Kwanza-Sul', 'digits'),
            'LUA' => __('Luanda', 'digits'),
            'LNO' => __('Lunda-Norte', 'digits'),
            'LSU' => __('Lunda-Sul', 'digits'),
            'MAL' => __('Malanje', 'digits'),
            'MOX' => __('Moxico', 'digits'),
            'NAM' => __('Namibe', 'digits'),
            'UIG' => __('Uíge', 'digits'),
            'ZAI' => __('Zaire', 'digits'),
        ),
        'AR' => array( // Argentinian provinces.
            'C' => __('Ciudad Autónoma de Buenos Aires', 'digits'),
            'B' => __('Buenos Aires', 'digits'),
            'K' => __('Catamarca', 'digits'),
            'H' => __('Chaco', 'digits'),
            'U' => __('Chubut', 'digits'),
            'X' => __('Córdoba', 'digits'),
            'W' => __('Corrientes', 'digits'),
            'E' => __('Entre Ríos', 'digits'),
            'P' => __('Formosa', 'digits'),
            'Y' => __('Jujuy', 'digits'),
            'L' => __('La Pampa', 'digits'),
            'F' => __('La Rioja', 'digits'),
            'M' => __('Mendoza', 'digits'),
            'N' => __('Misiones', 'digits'),
            'Q' => __('Neuquén', 'digits'),
            'R' => __('Río Negro', 'digits'),
            'A' => __('Salta', 'digits'),
            'J' => __('San Juan', 'digits'),
            'D' => __('San Luis', 'digits'),
            'Z' => __('Santa Cruz', 'digits'),
            'S' => __('Santa Fe', 'digits'),
            'G' => __('Santiago del Estero', 'digits'),
            'V' => __('Tierra del Fuego', 'digits'),
            'T' => __('Tucumán', 'digits'),
        ),
        'AT' => array(),
        'AU' => array( // Australian states.
            'ACT' => __('Australian Capital Territory', 'digits'),
            'NSW' => __('New South Wales', 'digits'),
            'NT' => __('Northern Territory', 'digits'),
            'QLD' => __('Queensland', 'digits'),
            'SA' => __('South Australia', 'digits'),
            'TAS' => __('Tasmania', 'digits'),
            'VIC' => __('Victoria', 'digits'),
            'WA' => __('Western Australia', 'digits'),
        ),
        'AX' => array(),
        'BD' => array( // Bangladeshi districts.
            'BD-05' => __('Bagerhat', 'digits'),
            'BD-01' => __('Bandarban', 'digits'),
            'BD-02' => __('Barguna', 'digits'),
            'BD-06' => __('Barishal', 'digits'),
            'BD-07' => __('Bhola', 'digits'),
            'BD-03' => __('Bogura', 'digits'),
            'BD-04' => __('Brahmanbaria', 'digits'),
            'BD-09' => __('Chandpur', 'digits'),
            'BD-10' => __('Chattogram', 'digits'),
            'BD-12' => __('Chuadanga', 'digits'),
            'BD-11' => __("Cox's Bazar", 'digits'),
            'BD-08' => __('Cumilla', 'digits'),
            'BD-13' => __('Dhaka', 'digits'),
            'BD-14' => __('Dinajpur', 'digits'),
            'BD-15' => __('Faridpur ', 'digits'),
            'BD-16' => __('Feni', 'digits'),
            'BD-19' => __('Gaibandha', 'digits'),
            'BD-18' => __('Gazipur', 'digits'),
            'BD-17' => __('Gopalganj', 'digits'),
            'BD-20' => __('Habiganj', 'digits'),
            'BD-21' => __('Jamalpur', 'digits'),
            'BD-22' => __('Jashore', 'digits'),
            'BD-25' => __('Jhalokati', 'digits'),
            'BD-23' => __('Jhenaidah', 'digits'),
            'BD-24' => __('Joypurhat', 'digits'),
            'BD-29' => __('Khagrachhari', 'digits'),
            'BD-27' => __('Khulna', 'digits'),
            'BD-26' => __('Kishoreganj', 'digits'),
            'BD-28' => __('Kurigram', 'digits'),
            'BD-30' => __('Kushtia', 'digits'),
            'BD-31' => __('Lakshmipur', 'digits'),
            'BD-32' => __('Lalmonirhat', 'digits'),
            'BD-36' => __('Madaripur', 'digits'),
            'BD-37' => __('Magura', 'digits'),
            'BD-33' => __('Manikganj ', 'digits'),
            'BD-39' => __('Meherpur', 'digits'),
            'BD-38' => __('Moulvibazar', 'digits'),
            'BD-35' => __('Munshiganj', 'digits'),
            'BD-34' => __('Mymensingh', 'digits'),
            'BD-48' => __('Naogaon', 'digits'),
            'BD-43' => __('Narail', 'digits'),
            'BD-40' => __('Narayanganj', 'digits'),
            'BD-42' => __('Narsingdi', 'digits'),
            'BD-44' => __('Natore', 'digits'),
            'BD-45' => __('Nawabganj', 'digits'),
            'BD-41' => __('Netrakona', 'digits'),
            'BD-46' => __('Nilphamari', 'digits'),
            'BD-47' => __('Noakhali', 'digits'),
            'BD-49' => __('Pabna', 'digits'),
            'BD-52' => __('Panchagarh', 'digits'),
            'BD-51' => __('Patuakhali', 'digits'),
            'BD-50' => __('Pirojpur', 'digits'),
            'BD-53' => __('Rajbari', 'digits'),
            'BD-54' => __('Rajshahi', 'digits'),
            'BD-56' => __('Rangamati', 'digits'),
            'BD-55' => __('Rangpur', 'digits'),
            'BD-58' => __('Satkhira', 'digits'),
            'BD-62' => __('Shariatpur', 'digits'),
            'BD-57' => __('Sherpur', 'digits'),
            'BD-59' => __('Sirajganj', 'digits'),
            'BD-61' => __('Sunamganj', 'digits'),
            'BD-60' => __('Sylhet', 'digits'),
            'BD-63' => __('Tangail', 'digits'),
            'BD-64' => __('Thakurgaon', 'digits'),
        ),
        'BE' => array(),
        'BG' => array( // Bulgarian states.
            'BG-01' => __('Blagoevgrad', 'digits'),
            'BG-02' => __('Burgas', 'digits'),
            'BG-08' => __('Dobrich', 'digits'),
            'BG-07' => __('Gabrovo', 'digits'),
            'BG-26' => __('Haskovo', 'digits'),
            'BG-09' => __('Kardzhali', 'digits'),
            'BG-10' => __('Kyustendil', 'digits'),
            'BG-11' => __('Lovech', 'digits'),
            'BG-12' => __('Montana', 'digits'),
            'BG-13' => __('Pazardzhik', 'digits'),
            'BG-14' => __('Pernik', 'digits'),
            'BG-15' => __('Pleven', 'digits'),
            'BG-16' => __('Plovdiv', 'digits'),
            'BG-17' => __('Razgrad', 'digits'),
            'BG-18' => __('Ruse', 'digits'),
            'BG-27' => __('Shumen', 'digits'),
            'BG-19' => __('Silistra', 'digits'),
            'BG-20' => __('Sliven', 'digits'),
            'BG-21' => __('Smolyan', 'digits'),
            'BG-23' => __('Sofia District', 'digits'),
            'BG-22' => __('Sofia', 'digits'),
            'BG-24' => __('Stara Zagora', 'digits'),
            'BG-25' => __('Targovishte', 'digits'),
            'BG-03' => __('Varna', 'digits'),
            'BG-04' => __('Veliko Tarnovo', 'digits'),
            'BG-05' => __('Vidin', 'digits'),
            'BG-06' => __('Vratsa', 'digits'),
            'BG-28' => __('Yambol', 'digits'),
        ),
        'BH' => array(),
        'BI' => array(),
        'BJ' => array( // Beninese states.
            'AL' => __('Alibori', 'digits'),
            'AK' => __('Atakora', 'digits'),
            'AQ' => __('Atlantique', 'digits'),
            'BO' => __('Borgou', 'digits'),
            'CO' => __('Collines', 'digits'),
            'KO' => __('Kouffo', 'digits'),
            'DO' => __('Donga', 'digits'),
            'LI' => __('Littoral', 'digits'),
            'MO' => __('Mono', 'digits'),
            'OU' => __('Ouémé', 'digits'),
            'PL' => __('Plateau', 'digits'),
            'ZO' => __('Zou', 'digits'),
        ),
        'BO' => array( // Bolivian states.
            'BO-B' => __('Beni', 'digits'),
            'BO-H' => __('Chuquisaca', 'digits'),
            'BO-C' => __('Cochabamba', 'digits'),
            'BO-L' => __('La Paz', 'digits'),
            'BO-O' => __('Oruro', 'digits'),
            'BO-N' => __('Pando', 'digits'),
            'BO-P' => __('Potosí', 'digits'),
            'BO-S' => __('Santa Cruz', 'digits'),
            'BO-T' => __('Tarija', 'digits'),
        ),
        'BR' => array( // Brazilian states.
            'AC' => __('Acre', 'digits'),
            'AL' => __('Alagoas', 'digits'),
            'AP' => __('Amapá', 'digits'),
            'AM' => __('Amazonas', 'digits'),
            'BA' => __('Bahia', 'digits'),
            'CE' => __('Ceará', 'digits'),
            'DF' => __('Distrito Federal', 'digits'),
            'ES' => __('Espírito Santo', 'digits'),
            'GO' => __('Goiás', 'digits'),
            'MA' => __('Maranhão', 'digits'),
            'MT' => __('Mato Grosso', 'digits'),
            'MS' => __('Mato Grosso do Sul', 'digits'),
            'MG' => __('Minas Gerais', 'digits'),
            'PA' => __('Pará', 'digits'),
            'PB' => __('Paraíba', 'digits'),
            'PR' => __('Paraná', 'digits'),
            'PE' => __('Pernambuco', 'digits'),
            'PI' => __('Piauí', 'digits'),
            'RJ' => __('Rio de Janeiro', 'digits'),
            'RN' => __('Rio Grande do Norte', 'digits'),
            'RS' => __('Rio Grande do Sul', 'digits'),
            'RO' => __('Rondônia', 'digits'),
            'RR' => __('Roraima', 'digits'),
            'SC' => __('Santa Catarina', 'digits'),
            'SP' => __('São Paulo', 'digits'),
            'SE' => __('Sergipe', 'digits'),
            'TO' => __('Tocantins', 'digits'),
        ),
        'CA' => array( // Canadian states.
            'AB' => __('Alberta', 'digits'),
            'BC' => __('British Columbia', 'digits'),
            'MB' => __('Manitoba', 'digits'),
            'NB' => __('New Brunswick', 'digits'),
            'NL' => __('Newfoundland and Labrador', 'digits'),
            'NT' => __('Northwest Territories', 'digits'),
            'NS' => __('Nova Scotia', 'digits'),
            'NU' => __('Nunavut', 'digits'),
            'ON' => __('Ontario', 'digits'),
            'PE' => __('Prince Edward Island', 'digits'),
            'QC' => __('Quebec', 'digits'),
            'SK' => __('Saskatchewan', 'digits'),
            'YT' => __('Yukon Territory', 'digits'),
        ),
        'CH' => array( // Swiss cantons.
            'AG' => __('Aargau', 'digits'),
            'AR' => __('Appenzell Ausserrhoden', 'digits'),
            'AI' => __('Appenzell Innerrhoden', 'digits'),
            'BL' => __('Basel-Landschaft', 'digits'),
            'BS' => __('Basel-Stadt', 'digits'),
            'BE' => __('Bern', 'digits'),
            'FR' => __('Fribourg', 'digits'),
            'GE' => __('Geneva', 'digits'),
            'GL' => __('Glarus', 'digits'),
            'GR' => __('Graubünden', 'digits'),
            'JU' => __('Jura', 'digits'),
            'LU' => __('Luzern', 'digits'),
            'NE' => __('Neuchâtel', 'digits'),
            'NW' => __('Nidwalden', 'digits'),
            'OW' => __('Obwalden', 'digits'),
            'SH' => __('Schaffhausen', 'digits'),
            'SZ' => __('Schwyz', 'digits'),
            'SO' => __('Solothurn', 'digits'),
            'SG' => __('St. Gallen', 'digits'),
            'TG' => __('Thurgau', 'digits'),
            'TI' => __('Ticino', 'digits'),
            'UR' => __('Uri', 'digits'),
            'VS' => __('Valais', 'digits'),
            'VD' => __('Vaud', 'digits'),
            'ZG' => __('Zug', 'digits'),
            'ZH' => __('Zürich', 'digits'),
        ),
        'CL' => array( // Chilean states.
            'CL-AI' => __('Aisén del General Carlos Ibañez del Campo', 'digits'),
            'CL-AN' => __('Antofagasta', 'digits'),
            'CL-AP' => __('Arica y Parinacota', 'digits'),
            'CL-AR' => __('La Araucanía', 'digits'),
            'CL-AT' => __('Atacama', 'digits'),
            'CL-BI' => __('Biobío', 'digits'),
            'CL-CO' => __('Coquimbo', 'digits'),
            'CL-LI' => __('Libertador General Bernardo O\'Higgins', 'digits'),
            'CL-LL' => __('Los Lagos', 'digits'),
            'CL-LR' => __('Los Ríos', 'digits'),
            'CL-MA' => __('Magallanes', 'digits'),
            'CL-ML' => __('Maule', 'digits'),
            'CL-NB' => __('Ñuble', 'digits'),
            'CL-RM' => __('Región Metropolitana de Santiago', 'digits'),
            'CL-TA' => __('Tarapacá', 'digits'),
            'CL-VS' => __('Valparaíso', 'digits'),
        ),
        'CN' => array( // Chinese states.
            'CN1' => __('Yunnan / 云南', 'digits'),
            'CN2' => __('Beijing / 北京', 'digits'),
            'CN3' => __('Tianjin / 天津', 'digits'),
            'CN4' => __('Hebei / 河北', 'digits'),
            'CN5' => __('Shanxi / 山西', 'digits'),
            'CN6' => __('Inner Mongolia / 內蒙古', 'digits'),
            'CN7' => __('Liaoning / 辽宁', 'digits'),
            'CN8' => __('Jilin / 吉林', 'digits'),
            'CN9' => __('Heilongjiang / 黑龙江', 'digits'),
            'CN10' => __('Shanghai / 上海', 'digits'),
            'CN11' => __('Jiangsu / 江苏', 'digits'),
            'CN12' => __('Zhejiang / 浙江', 'digits'),
            'CN13' => __('Anhui / 安徽', 'digits'),
            'CN14' => __('Fujian / 福建', 'digits'),
            'CN15' => __('Jiangxi / 江西', 'digits'),
            'CN16' => __('Shandong / 山东', 'digits'),
            'CN17' => __('Henan / 河南', 'digits'),
            'CN18' => __('Hubei / 湖北', 'digits'),
            'CN19' => __('Hunan / 湖南', 'digits'),
            'CN20' => __('Guangdong / 广东', 'digits'),
            'CN21' => __('Guangxi Zhuang / 广西壮族', 'digits'),
            'CN22' => __('Hainan / 海南', 'digits'),
            'CN23' => __('Chongqing / 重庆', 'digits'),
            'CN24' => __('Sichuan / 四川', 'digits'),
            'CN25' => __('Guizhou / 贵州', 'digits'),
            'CN26' => __('Shaanxi / 陕西', 'digits'),
            'CN27' => __('Gansu / 甘肃', 'digits'),
            'CN28' => __('Qinghai / 青海', 'digits'),
            'CN29' => __('Ningxia Hui / 宁夏', 'digits'),
            'CN30' => __('Macao / 澳门', 'digits'),
            'CN31' => __('Tibet / 西藏', 'digits'),
            'CN32' => __('Xinjiang / 新疆', 'digits'),
        ),
        'CO' => array( // Colombian states.
            'CO-AMA' => __('Amazonas', 'digits'),
            'CO-ANT' => __('Antioquia', 'digits'),
            'CO-ARA' => __('Arauca', 'digits'),
            'CO-ATL' => __('Atlántico', 'digits'),
            'CO-BOL' => __('Bolívar', 'digits'),
            'CO-BOY' => __('Boyacá', 'digits'),
            'CO-CAL' => __('Caldas', 'digits'),
            'CO-CAQ' => __('Caquetá', 'digits'),
            'CO-CAS' => __('Casanare', 'digits'),
            'CO-CAU' => __('Cauca', 'digits'),
            'CO-CES' => __('Cesar', 'digits'),
            'CO-CHO' => __('Chocó', 'digits'),
            'CO-COR' => __('Córdoba', 'digits'),
            'CO-CUN' => __('Cundinamarca', 'digits'),
            'CO-DC' => __('Capital District', 'digits'),
            'CO-GUA' => __('Guainía', 'digits'),
            'CO-GUV' => __('Guaviare', 'digits'),
            'CO-HUI' => __('Huila', 'digits'),
            'CO-LAG' => __('La Guajira', 'digits'),
            'CO-MAG' => __('Magdalena', 'digits'),
            'CO-MET' => __('Meta', 'digits'),
            'CO-NAR' => __('Nariño', 'digits'),
            'CO-NSA' => __('Norte de Santander', 'digits'),
            'CO-PUT' => __('Putumayo', 'digits'),
            'CO-QUI' => __('Quindío', 'digits'),
            'CO-RIS' => __('Risaralda', 'digits'),
            'CO-SAN' => __('Santander', 'digits'),
            'CO-SAP' => __('San Andrés & Providencia', 'digits'),
            'CO-SUC' => __('Sucre', 'digits'),
            'CO-TOL' => __('Tolima', 'digits'),
            'CO-VAC' => __('Valle del Cauca', 'digits'),
            'CO-VAU' => __('Vaupés', 'digits'),
            'CO-VID' => __('Vichada', 'digits'),
        ),
        'CR' => array( // Costa Rican states.
            'CR-A' => __('Alajuela', 'digits'),
            'CR-C' => __('Cartago', 'digits'),
            'CR-G' => __('Guanacaste', 'digits'),
            'CR-H' => __('Heredia', 'digits'),
            'CR-L' => __('Limón', 'digits'),
            'CR-P' => __('Puntarenas', 'digits'),
            'CR-SJ' => __('San José', 'digits'),
        ),
        'CZ' => array(),
        'DE' => array( // German states.
            'DE-BW' => __('Baden-Württemberg', 'digits'),
            'DE-BY' => __('Bavaria', 'digits'),
            'DE-BE' => __('Berlin', 'digits'),
            'DE-BB' => __('Brandenburg', 'digits'),
            'DE-HB' => __('Bremen', 'digits'),
            'DE-HH' => __('Hamburg', 'digits'),
            'DE-HE' => __('Hesse', 'digits'),
            'DE-MV' => __('Mecklenburg-Vorpommern', 'digits'),
            'DE-NI' => __('Lower Saxony', 'digits'),
            'DE-NW' => __('North Rhine-Westphalia', 'digits'),
            'DE-RP' => __('Rhineland-Palatinate', 'digits'),
            'DE-SL' => __('Saarland', 'digits'),
            'DE-SN' => __('Saxony', 'digits'),
            'DE-ST' => __('Saxony-Anhalt', 'digits'),
            'DE-SH' => __('Schleswig-Holstein', 'digits'),
            'DE-TH' => __('Thuringia', 'digits'),
        ),
        'DK' => array(),
        'DO' => array( // Dominican states.
            'DO-01' => __('Distrito Nacional', 'digits'),
            'DO-02' => __('Azua', 'digits'),
            'DO-03' => __('Baoruco', 'digits'),
            'DO-04' => __('Barahona', 'digits'),
            'DO-33' => __('Cibao Nordeste', 'digits'),
            'DO-34' => __('Cibao Noroeste', 'digits'),
            'DO-35' => __('Cibao Norte', 'digits'),
            'DO-36' => __('Cibao Sur', 'digits'),
            'DO-05' => __('Dajabón', 'digits'),
            'DO-06' => __('Duarte', 'digits'),
            'DO-08' => __('El Seibo', 'digits'),
            'DO-37' => __('El Valle', 'digits'),
            'DO-07' => __('Elías Piña', 'digits'),
            'DO-38' => __('Enriquillo', 'digits'),
            'DO-09' => __('Espaillat', 'digits'),
            'DO-30' => __('Hato Mayor', 'digits'),
            'DO-19' => __('Hermanas Mirabal', 'digits'),
            'DO-39' => __('Higüamo', 'digits'),
            'DO-10' => __('Independencia', 'digits'),
            'DO-11' => __('La Altagracia', 'digits'),
            'DO-12' => __('La Romana', 'digits'),
            'DO-13' => __('La Vega', 'digits'),
            'DO-14' => __('María Trinidad Sánchez', 'digits'),
            'DO-28' => __('Monseñor Nouel', 'digits'),
            'DO-15' => __('Monte Cristi', 'digits'),
            'DO-29' => __('Monte Plata', 'digits'),
            'DO-40' => __('Ozama', 'digits'),
            'DO-16' => __('Pedernales', 'digits'),
            'DO-17' => __('Peravia', 'digits'),
            'DO-18' => __('Puerto Plata', 'digits'),
            'DO-20' => __('Samaná', 'digits'),
            'DO-21' => __('San Cristóbal', 'digits'),
            'DO-31' => __('San José de Ocoa', 'digits'),
            'DO-22' => __('San Juan', 'digits'),
            'DO-23' => __('San Pedro de Macorís', 'digits'),
            'DO-24' => __('Sánchez Ramírez', 'digits'),
            'DO-25' => __('Santiago', 'digits'),
            'DO-26' => __('Santiago Rodríguez', 'digits'),
            'DO-32' => __('Santo Domingo', 'digits'),
            'DO-41' => __('Valdesia', 'digits'),
            'DO-27' => __('Valverde', 'digits'),
            'DO-42' => __('Yuma', 'digits'),
        ),
        'DZ' => array( // Algerian states.
            'DZ-01' => __('Adrar', 'digits'),
            'DZ-02' => __('Chlef', 'digits'),
            'DZ-03' => __('Laghouat', 'digits'),
            'DZ-04' => __('Oum El Bouaghi', 'digits'),
            'DZ-05' => __('Batna', 'digits'),
            'DZ-06' => __('Béjaïa', 'digits'),
            'DZ-07' => __('Biskra', 'digits'),
            'DZ-08' => __('Béchar', 'digits'),
            'DZ-09' => __('Blida', 'digits'),
            'DZ-10' => __('Bouira', 'digits'),
            'DZ-11' => __('Tamanghasset', 'digits'),
            'DZ-12' => __('Tébessa', 'digits'),
            'DZ-13' => __('Tlemcen', 'digits'),
            'DZ-14' => __('Tiaret', 'digits'),
            'DZ-15' => __('Tizi Ouzou', 'digits'),
            'DZ-16' => __('Algiers', 'digits'),
            'DZ-17' => __('Djelfa', 'digits'),
            'DZ-18' => __('Jijel', 'digits'),
            'DZ-19' => __('Sétif', 'digits'),
            'DZ-20' => __('Saïda', 'digits'),
            'DZ-21' => __('Skikda', 'digits'),
            'DZ-22' => __('Sidi Bel Abbès', 'digits'),
            'DZ-23' => __('Annaba', 'digits'),
            'DZ-24' => __('Guelma', 'digits'),
            'DZ-25' => __('Constantine', 'digits'),
            'DZ-26' => __('Médéa', 'digits'),
            'DZ-27' => __('Mostaganem', 'digits'),
            'DZ-28' => __('M’Sila', 'digits'),
            'DZ-29' => __('Mascara', 'digits'),
            'DZ-30' => __('Ouargla', 'digits'),
            'DZ-31' => __('Oran', 'digits'),
            'DZ-32' => __('El Bayadh', 'digits'),
            'DZ-33' => __('Illizi', 'digits'),
            'DZ-34' => __('Bordj Bou Arréridj', 'digits'),
            'DZ-35' => __('Boumerdès', 'digits'),
            'DZ-36' => __('El Tarf', 'digits'),
            'DZ-37' => __('Tindouf', 'digits'),
            'DZ-38' => __('Tissemsilt', 'digits'),
            'DZ-39' => __('El Oued', 'digits'),
            'DZ-40' => __('Khenchela', 'digits'),
            'DZ-41' => __('Souk Ahras', 'digits'),
            'DZ-42' => __('Tipasa', 'digits'),
            'DZ-43' => __('Mila', 'digits'),
            'DZ-44' => __('Aïn Defla', 'digits'),
            'DZ-45' => __('Naama', 'digits'),
            'DZ-46' => __('Aïn Témouchent', 'digits'),
            'DZ-47' => __('Ghardaïa', 'digits'),
            'DZ-48' => __('Relizane', 'digits'),
        ),
        'EE' => array(),
        'EC' => array( // Ecuadorian states.
            'EC-A' => __('Azuay', 'digits'),
            'EC-B' => __('Bolívar', 'digits'),
            'EC-F' => __('Cañar', 'digits'),
            'EC-C' => __('Carchi', 'digits'),
            'EC-H' => __('Chimborazo', 'digits'),
            'EC-X' => __('Cotopaxi', 'digits'),
            'EC-O' => __('El Oro', 'digits'),
            'EC-E' => __('Esmeraldas', 'digits'),
            'EC-W' => __('Galápagos', 'digits'),
            'EC-G' => __('Guayas', 'digits'),
            'EC-I' => __('Imbabura', 'digits'),
            'EC-L' => __('Loja', 'digits'),
            'EC-R' => __('Los Ríos', 'digits'),
            'EC-M' => __('Manabí', 'digits'),
            'EC-S' => __('Morona-Santiago', 'digits'),
            'EC-N' => __('Napo', 'digits'),
            'EC-D' => __('Orellana', 'digits'),
            'EC-Y' => __('Pastaza', 'digits'),
            'EC-P' => __('Pichincha', 'digits'),
            'EC-SE' => __('Santa Elena', 'digits'),
            'EC-SD' => __('Santo Domingo de los Tsáchilas', 'digits'),
            'EC-U' => __('Sucumbíos', 'digits'),
            'EC-T' => __('Tungurahua', 'digits'),
            'EC-Z' => __('Zamora-Chinchipe', 'digits'),
        ),
        'EG' => array( // Egyptian states.
            'EGALX' => __('Alexandria', 'digits'),
            'EGASN' => __('Aswan', 'digits'),
            'EGAST' => __('Asyut', 'digits'),
            'EGBA' => __('Red Sea', 'digits'),
            'EGBH' => __('Beheira', 'digits'),
            'EGBNS' => __('Beni Suef', 'digits'),
            'EGC' => __('Cairo', 'digits'),
            'EGDK' => __('Dakahlia', 'digits'),
            'EGDT' => __('Damietta', 'digits'),
            'EGFYM' => __('Faiyum', 'digits'),
            'EGGH' => __('Gharbia', 'digits'),
            'EGGZ' => __('Giza', 'digits'),
            'EGIS' => __('Ismailia', 'digits'),
            'EGJS' => __('South Sinai', 'digits'),
            'EGKB' => __('Qalyubia', 'digits'),
            'EGKFS' => __('Kafr el-Sheikh', 'digits'),
            'EGKN' => __('Qena', 'digits'),
            'EGLX' => __('Luxor', 'digits'),
            'EGMN' => __('Minya', 'digits'),
            'EGMNF' => __('Monufia', 'digits'),
            'EGMT' => __('Matrouh', 'digits'),
            'EGPTS' => __('Port Said', 'digits'),
            'EGSHG' => __('Sohag', 'digits'),
            'EGSHR' => __('Al Sharqia', 'digits'),
            'EGSIN' => __('North Sinai', 'digits'),
            'EGSUZ' => __('Suez', 'digits'),
            'EGWAD' => __('New Valley', 'digits'),
        ),
        'ES' => array( // Spanish states.
            'C' => __('A Coruña', 'digits'),
            'VI' => __('Araba/Álava', 'digits'),
            'AB' => __('Albacete', 'digits'),
            'A' => __('Alicante', 'digits'),
            'AL' => __('Almería', 'digits'),
            'O' => __('Asturias', 'digits'),
            'AV' => __('Ávila', 'digits'),
            'BA' => __('Badajoz', 'digits'),
            'PM' => __('Baleares', 'digits'),
            'B' => __('Barcelona', 'digits'),
            'BU' => __('Burgos', 'digits'),
            'CC' => __('Cáceres', 'digits'),
            'CA' => __('Cádiz', 'digits'),
            'S' => __('Cantabria', 'digits'),
            'CS' => __('Castellón', 'digits'),
            'CE' => __('Ceuta', 'digits'),
            'CR' => __('Ciudad Real', 'digits'),
            'CO' => __('Córdoba', 'digits'),
            'CU' => __('Cuenca', 'digits'),
            'GI' => __('Girona', 'digits'),
            'GR' => __('Granada', 'digits'),
            'GU' => __('Guadalajara', 'digits'),
            'SS' => __('Gipuzkoa', 'digits'),
            'H' => __('Huelva', 'digits'),
            'HU' => __('Huesca', 'digits'),
            'J' => __('Jaén', 'digits'),
            'LO' => __('La Rioja', 'digits'),
            'GC' => __('Las Palmas', 'digits'),
            'LE' => __('León', 'digits'),
            'L' => __('Lleida', 'digits'),
            'LU' => __('Lugo', 'digits'),
            'M' => __('Madrid', 'digits'),
            'MA' => __('Málaga', 'digits'),
            'ML' => __('Melilla', 'digits'),
            'MU' => __('Murcia', 'digits'),
            'NA' => __('Navarra', 'digits'),
            'OR' => __('Ourense', 'digits'),
            'P' => __('Palencia', 'digits'),
            'PO' => __('Pontevedra', 'digits'),
            'SA' => __('Salamanca', 'digits'),
            'TF' => __('Santa Cruz de Tenerife', 'digits'),
            'SG' => __('Segovia', 'digits'),
            'SE' => __('Sevilla', 'digits'),
            'SO' => __('Soria', 'digits'),
            'T' => __('Tarragona', 'digits'),
            'TE' => __('Teruel', 'digits'),
            'TO' => __('Toledo', 'digits'),
            'V' => __('Valencia', 'digits'),
            'VA' => __('Valladolid', 'digits'),
            'BI' => __('Biscay', 'digits'),
            'ZA' => __('Zamora', 'digits'),
            'Z' => __('Zaragoza', 'digits'),
        ),
        'FI' => array(),
        'FR' => array(),
        'GF' => array(),
        'GH' => array( // Ghanaian regions.
            'AF' => __('Ahafo', 'digits'),
            'AH' => __('Ashanti', 'digits'),
            'BA' => __('Brong-Ahafo', 'digits'),
            'BO' => __('Bono', 'digits'),
            'BE' => __('Bono East', 'digits'),
            'CP' => __('Central', 'digits'),
            'EP' => __('Eastern', 'digits'),
            'AA' => __('Greater Accra', 'digits'),
            'NE' => __('North East', 'digits'),
            'NP' => __('Northern', 'digits'),
            'OT' => __('Oti', 'digits'),
            'SV' => __('Savannah', 'digits'),
            'UE' => __('Upper East', 'digits'),
            'UW' => __('Upper West', 'digits'),
            'TV' => __('Volta', 'digits'),
            'WP' => __('Western', 'digits'),
            'WN' => __('Western North', 'digits'),
        ),
        'GP' => array(),
        'GR' => array( // Greek regions.
            'I' => __('Attica', 'digits'),
            'A' => __('East Macedonia and Thrace', 'digits'),
            'B' => __('Central Macedonia', 'digits'),
            'C' => __('West Macedonia', 'digits'),
            'D' => __('Epirus', 'digits'),
            'E' => __('Thessaly', 'digits'),
            'F' => __('Ionian Islands', 'digits'),
            'G' => __('West Greece', 'digits'),
            'H' => __('Central Greece', 'digits'),
            'J' => __('Peloponnese', 'digits'),
            'K' => __('North Aegean', 'digits'),
            'L' => __('South Aegean', 'digits'),
            'M' => __('Crete', 'digits'),
        ),
        'GT' => array( // Guatemalan states.
            'GT-AV' => __('Alta Verapaz', 'digits'),
            'GT-BV' => __('Baja Verapaz', 'digits'),
            'GT-CM' => __('Chimaltenango', 'digits'),
            'GT-CQ' => __('Chiquimula', 'digits'),
            'GT-PR' => __('El Progreso', 'digits'),
            'GT-ES' => __('Escuintla', 'digits'),
            'GT-GU' => __('Guatemala', 'digits'),
            'GT-HU' => __('Huehuetenango', 'digits'),
            'GT-IZ' => __('Izabal', 'digits'),
            'GT-JA' => __('Jalapa', 'digits'),
            'GT-JU' => __('Jutiapa', 'digits'),
            'GT-PE' => __('Petén', 'digits'),
            'GT-QZ' => __('Quetzaltenango', 'digits'),
            'GT-QC' => __('Quiché', 'digits'),
            'GT-RE' => __('Retalhuleu', 'digits'),
            'GT-SA' => __('Sacatepéquez', 'digits'),
            'GT-SM' => __('San Marcos', 'digits'),
            'GT-SR' => __('Santa Rosa', 'digits'),
            'GT-SO' => __('Sololá', 'digits'),
            'GT-SU' => __('Suchitepéquez', 'digits'),
            'GT-TO' => __('Totonicapán', 'digits'),
            'GT-ZA' => __('Zacapa', 'digits'),
        ),
        'HK' => array( // Hong Kong states.
            'HONG KONG' => __('Hong Kong Island', 'digits'),
            'KOWLOON' => __('Kowloon', 'digits'),
            'NEW TERRITORIES' => __('New Territories', 'digits'),
        ),
        'HN' => array( // Honduran states.
            'HN-AT' => __('Atlántida', 'digits'),
            'HN-IB' => __('Bay Islands', 'digits'),
            'HN-CH' => __('Choluteca', 'digits'),
            'HN-CL' => __('Colón', 'digits'),
            'HN-CM' => __('Comayagua', 'digits'),
            'HN-CP' => __('Copán', 'digits'),
            'HN-CR' => __('Cortés', 'digits'),
            'HN-EP' => __('El Paraíso', 'digits'),
            'HN-FM' => __('Francisco Morazán', 'digits'),
            'HN-GD' => __('Gracias a Dios', 'digits'),
            'HN-IN' => __('Intibucá', 'digits'),
            'HN-LE' => __('Lempira', 'digits'),
            'HN-LP' => __('La Paz', 'digits'),
            'HN-OC' => __('Ocotepeque', 'digits'),
            'HN-OL' => __('Olancho', 'digits'),
            'HN-SB' => __('Santa Bárbara', 'digits'),
            'HN-VA' => __('Valle', 'digits'),
            'HN-YO' => __('Yoro', 'digits'),
        ),
        'HU' => array( // Hungarian states.
            'BK' => __('Bács-Kiskun', 'digits'),
            'BE' => __('Békés', 'digits'),
            'BA' => __('Baranya', 'digits'),
            'BZ' => __('Borsod-Abaúj-Zemplén', 'digits'),
            'BU' => __('Budapest', 'digits'),
            'CS' => __('Csongrád-Csanád', 'digits'),
            'FE' => __('Fejér', 'digits'),
            'GS' => __('Győr-Moson-Sopron', 'digits'),
            'HB' => __('Hajdú-Bihar', 'digits'),
            'HE' => __('Heves', 'digits'),
            'JN' => __('Jász-Nagykun-Szolnok', 'digits'),
            'KE' => __('Komárom-Esztergom', 'digits'),
            'NO' => __('Nógrád', 'digits'),
            'PE' => __('Pest', 'digits'),
            'SO' => __('Somogy', 'digits'),
            'SZ' => __('Szabolcs-Szatmár-Bereg', 'digits'),
            'TO' => __('Tolna', 'digits'),
            'VA' => __('Vas', 'digits'),
            'VE' => __('Veszprém', 'digits'),
            'ZA' => __('Zala', 'digits'),
        ),
        'ID' => array( // Indonesian provinces.
            'AC' => __('Daerah Istimewa Aceh', 'digits'),
            'SU' => __('Sumatera Utara', 'digits'),
            'SB' => __('Sumatera Barat', 'digits'),
            'RI' => __('Riau', 'digits'),
            'KR' => __('Kepulauan Riau', 'digits'),
            'JA' => __('Jambi', 'digits'),
            'SS' => __('Sumatera Selatan', 'digits'),
            'BB' => __('Bangka Belitung', 'digits'),
            'BE' => __('Bengkulu', 'digits'),
            'LA' => __('Lampung', 'digits'),
            'JK' => __('DKI Jakarta', 'digits'),
            'JB' => __('Jawa Barat', 'digits'),
            'BT' => __('Banten', 'digits'),
            'JT' => __('Jawa Tengah', 'digits'),
            'JI' => __('Jawa Timur', 'digits'),
            'YO' => __('Daerah Istimewa Yogyakarta', 'digits'),
            'BA' => __('Bali', 'digits'),
            'NB' => __('Nusa Tenggara Barat', 'digits'),
            'NT' => __('Nusa Tenggara Timur', 'digits'),
            'KB' => __('Kalimantan Barat', 'digits'),
            'KT' => __('Kalimantan Tengah', 'digits'),
            'KI' => __('Kalimantan Timur', 'digits'),
            'KS' => __('Kalimantan Selatan', 'digits'),
            'KU' => __('Kalimantan Utara', 'digits'),
            'SA' => __('Sulawesi Utara', 'digits'),
            'ST' => __('Sulawesi Tengah', 'digits'),
            'SG' => __('Sulawesi Tenggara', 'digits'),
            'SR' => __('Sulawesi Barat', 'digits'),
            'SN' => __('Sulawesi Selatan', 'digits'),
            'GO' => __('Gorontalo', 'digits'),
            'MA' => __('Maluku', 'digits'),
            'MU' => __('Maluku Utara', 'digits'),
            'PA' => __('Papua', 'digits'),
            'PB' => __('Papua Barat', 'digits'),
        ),
        'IE' => array( // Irish states.
            'CW' => __('Carlow', 'digits'),
            'CN' => __('Cavan', 'digits'),
            'CE' => __('Clare', 'digits'),
            'CO' => __('Cork', 'digits'),
            'DL' => __('Donegal', 'digits'),
            'D' => __('Dublin', 'digits'),
            'G' => __('Galway', 'digits'),
            'KY' => __('Kerry', 'digits'),
            'KE' => __('Kildare', 'digits'),
            'KK' => __('Kilkenny', 'digits'),
            'LS' => __('Laois', 'digits'),
            'LM' => __('Leitrim', 'digits'),
            'LK' => __('Limerick', 'digits'),
            'LD' => __('Longford', 'digits'),
            'LH' => __('Louth', 'digits'),
            'MO' => __('Mayo', 'digits'),
            'MH' => __('Meath', 'digits'),
            'MN' => __('Monaghan', 'digits'),
            'OY' => __('Offaly', 'digits'),
            'RN' => __('Roscommon', 'digits'),
            'SO' => __('Sligo', 'digits'),
            'TA' => __('Tipperary', 'digits'),
            'WD' => __('Waterford', 'digits'),
            'WH' => __('Westmeath', 'digits'),
            'WX' => __('Wexford', 'digits'),
            'WW' => __('Wicklow', 'digits'),
        ),
        'IN' => array( // Indian states.
            'AP' => __('Andhra Pradesh', 'digits'),
            'AR' => __('Arunachal Pradesh', 'digits'),
            'AS' => __('Assam', 'digits'),
            'BR' => __('Bihar', 'digits'),
            'CT' => __('Chhattisgarh', 'digits'),
            'GA' => __('Goa', 'digits'),
            'GJ' => __('Gujarat', 'digits'),
            'HR' => __('Haryana', 'digits'),
            'HP' => __('Himachal Pradesh', 'digits'),
            'JK' => __('Jammu and Kashmir', 'digits'),
            'JH' => __('Jharkhand', 'digits'),
            'KA' => __('Karnataka', 'digits'),
            'KL' => __('Kerala', 'digits'),
            'LA' => __('Ladakh', 'digits'),
            'MP' => __('Madhya Pradesh', 'digits'),
            'MH' => __('Maharashtra', 'digits'),
            'MN' => __('Manipur', 'digits'),
            'ML' => __('Meghalaya', 'digits'),
            'MZ' => __('Mizoram', 'digits'),
            'NL' => __('Nagaland', 'digits'),
            'OR' => __('Odisha', 'digits'),
            'PB' => __('Punjab', 'digits'),
            'RJ' => __('Rajasthan', 'digits'),
            'SK' => __('Sikkim', 'digits'),
            'TN' => __('Tamil Nadu', 'digits'),
            'TS' => __('Telangana', 'digits'),
            'TR' => __('Tripura', 'digits'),
            'UK' => __('Uttarakhand', 'digits'),
            'UP' => __('Uttar Pradesh', 'digits'),
            'WB' => __('West Bengal', 'digits'),
            'AN' => __('Andaman and Nicobar Islands', 'digits'),
            'CH' => __('Chandigarh', 'digits'),
            'DN' => __('Dadra and Nagar Haveli', 'digits'),
            'DD' => __('Daman and Diu', 'digits'),
            'DL' => __('Delhi', 'digits'),
            'LD' => __('Lakshadeep', 'digits'),
            'PY' => __('Pondicherry (Puducherry)', 'digits'),
        ),
        'IR' => array( // Irania states.
            'KHZ' => __('Khuzestan (خوزستان)', 'digits'),
            'THR' => __('Tehran (تهران)', 'digits'),
            'ILM' => __('Ilaam (ایلام)', 'digits'),
            'BHR' => __('Bushehr (بوشهر)', 'digits'),
            'ADL' => __('Ardabil (اردبیل)', 'digits'),
            'ESF' => __('Isfahan (اصفهان)', 'digits'),
            'YZD' => __('Yazd (یزد)', 'digits'),
            'KRH' => __('Kermanshah (کرمانشاه)', 'digits'),
            'KRN' => __('Kerman (کرمان)', 'digits'),
            'HDN' => __('Hamadan (همدان)', 'digits'),
            'GZN' => __('Ghazvin (قزوین)', 'digits'),
            'ZJN' => __('Zanjan (زنجان)', 'digits'),
            'LRS' => __('Luristan (لرستان)', 'digits'),
            'ABZ' => __('Alborz (البرز)', 'digits'),
            'EAZ' => __('East Azarbaijan (آذربایجان شرقی)', 'digits'),
            'WAZ' => __('West Azarbaijan (آذربایجان غربی)', 'digits'),
            'CHB' => __('Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'digits'),
            'SKH' => __('South Khorasan (خراسان جنوبی)', 'digits'),
            'RKH' => __('Razavi Khorasan (خراسان رضوی)', 'digits'),
            'NKH' => __('North Khorasan (خراسان شمالی)', 'digits'),
            'SMN' => __('Semnan (سمنان)', 'digits'),
            'FRS' => __('Fars (فارس)', 'digits'),
            'QHM' => __('Qom (قم)', 'digits'),
            'KRD' => __('Kurdistan / کردستان)', 'digits'),
            'KBD' => __('Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'digits'),
            'GLS' => __('Golestan (گلستان)', 'digits'),
            'GIL' => __('Gilan (گیلان)', 'digits'),
            'MZN' => __('Mazandaran (مازندران)', 'digits'),
            'MKZ' => __('Markazi (مرکزی)', 'digits'),
            'HRZ' => __('Hormozgan (هرمزگان)', 'digits'),
            'SBN' => __('Sistan and Baluchestan (سیستان و بلوچستان)', 'digits'),
        ),
        'IS' => array(),
        'IT' => array( // Italian provinces.
            'AG' => __('Agrigento', 'digits'),
            'AL' => __('Alessandria', 'digits'),
            'AN' => __('Ancona', 'digits'),
            'AO' => __('Aosta', 'digits'),
            'AR' => __('Arezzo', 'digits'),
            'AP' => __('Ascoli Piceno', 'digits'),
            'AT' => __('Asti', 'digits'),
            'AV' => __('Avellino', 'digits'),
            'BA' => __('Bari', 'digits'),
            'BT' => __('Barletta-Andria-Trani', 'digits'),
            'BL' => __('Belluno', 'digits'),
            'BN' => __('Benevento', 'digits'),
            'BG' => __('Bergamo', 'digits'),
            'BI' => __('Biella', 'digits'),
            'BO' => __('Bologna', 'digits'),
            'BZ' => __('Bolzano', 'digits'),
            'BS' => __('Brescia', 'digits'),
            'BR' => __('Brindisi', 'digits'),
            'CA' => __('Cagliari', 'digits'),
            'CL' => __('Caltanissetta', 'digits'),
            'CB' => __('Campobasso', 'digits'),
            'CE' => __('Caserta', 'digits'),
            'CT' => __('Catania', 'digits'),
            'CZ' => __('Catanzaro', 'digits'),
            'CH' => __('Chieti', 'digits'),
            'CO' => __('Como', 'digits'),
            'CS' => __('Cosenza', 'digits'),
            'CR' => __('Cremona', 'digits'),
            'KR' => __('Crotone', 'digits'),
            'CN' => __('Cuneo', 'digits'),
            'EN' => __('Enna', 'digits'),
            'FM' => __('Fermo', 'digits'),
            'FE' => __('Ferrara', 'digits'),
            'FI' => __('Firenze', 'digits'),
            'FG' => __('Foggia', 'digits'),
            'FC' => __('Forlì-Cesena', 'digits'),
            'FR' => __('Frosinone', 'digits'),
            'GE' => __('Genova', 'digits'),
            'GO' => __('Gorizia', 'digits'),
            'GR' => __('Grosseto', 'digits'),
            'IM' => __('Imperia', 'digits'),
            'IS' => __('Isernia', 'digits'),
            'SP' => __('La Spezia', 'digits'),
            'AQ' => __("L'Aquila", 'digits'),
            'LT' => __('Latina', 'digits'),
            'LE' => __('Lecce', 'digits'),
            'LC' => __('Lecco', 'digits'),
            'LI' => __('Livorno', 'digits'),
            'LO' => __('Lodi', 'digits'),
            'LU' => __('Lucca', 'digits'),
            'MC' => __('Macerata', 'digits'),
            'MN' => __('Mantova', 'digits'),
            'MS' => __('Massa-Carrara', 'digits'),
            'MT' => __('Matera', 'digits'),
            'ME' => __('Messina', 'digits'),
            'MI' => __('Milano', 'digits'),
            'MO' => __('Modena', 'digits'),
            'MB' => __('Monza e della Brianza', 'digits'),
            'NA' => __('Napoli', 'digits'),
            'NO' => __('Novara', 'digits'),
            'NU' => __('Nuoro', 'digits'),
            'OR' => __('Oristano', 'digits'),
            'PD' => __('Padova', 'digits'),
            'PA' => __('Palermo', 'digits'),
            'PR' => __('Parma', 'digits'),
            'PV' => __('Pavia', 'digits'),
            'PG' => __('Perugia', 'digits'),
            'PU' => __('Pesaro e Urbino', 'digits'),
            'PE' => __('Pescara', 'digits'),
            'PC' => __('Piacenza', 'digits'),
            'PI' => __('Pisa', 'digits'),
            'PT' => __('Pistoia', 'digits'),
            'PN' => __('Pordenone', 'digits'),
            'PZ' => __('Potenza', 'digits'),
            'PO' => __('Prato', 'digits'),
            'RG' => __('Ragusa', 'digits'),
            'RA' => __('Ravenna', 'digits'),
            'RC' => __('Reggio Calabria', 'digits'),
            'RE' => __('Reggio Emilia', 'digits'),
            'RI' => __('Rieti', 'digits'),
            'RN' => __('Rimini', 'digits'),
            'RM' => __('Roma', 'digits'),
            'RO' => __('Rovigo', 'digits'),
            'SA' => __('Salerno', 'digits'),
            'SS' => __('Sassari', 'digits'),
            'SV' => __('Savona', 'digits'),
            'SI' => __('Siena', 'digits'),
            'SR' => __('Siracusa', 'digits'),
            'SO' => __('Sondrio', 'digits'),
            'SU' => __('Sud Sardegna', 'digits'),
            'TA' => __('Taranto', 'digits'),
            'TE' => __('Teramo', 'digits'),
            'TR' => __('Terni', 'digits'),
            'TO' => __('Torino', 'digits'),
            'TP' => __('Trapani', 'digits'),
            'TN' => __('Trento', 'digits'),
            'TV' => __('Treviso', 'digits'),
            'TS' => __('Trieste', 'digits'),
            'UD' => __('Udine', 'digits'),
            'VA' => __('Varese', 'digits'),
            'VE' => __('Venezia', 'digits'),
            'VB' => __('Verbano-Cusio-Ossola', 'digits'),
            'VC' => __('Vercelli', 'digits'),
            'VR' => __('Verona', 'digits'),
            'VV' => __('Vibo Valentia', 'digits'),
            'VI' => __('Vicenza', 'digits'),
            'VT' => __('Viterbo', 'digits'),
        ),
        'IL' => array(),
        'IM' => array(),
        'JM' => array( // Jamaican parishes.
            'JM-01' => __('Kingston', 'digits'),
            'JM-02' => __('Saint Andrew', 'digits'),
            'JM-03' => __('Saint Thomas', 'digits'),
            'JM-04' => __('Portland', 'digits'),
            'JM-05' => __('Saint Mary', 'digits'),
            'JM-06' => __('Saint Ann', 'digits'),
            'JM-07' => __('Trelawny', 'digits'),
            'JM-08' => __('Saint James', 'digits'),
            'JM-09' => __('Hanover', 'digits'),
            'JM-10' => __('Westmoreland', 'digits'),
            'JM-11' => __('Saint Elizabeth', 'digits'),
            'JM-12' => __('Manchester', 'digits'),
            'JM-13' => __('Clarendon', 'digits'),
            'JM-14' => __('Saint Catherine', 'digits'),
        ),

        /**
         * Japanese states.
         *
         * English notation of prefectures conform to the notation of Japan Post.
         * The suffix corresponds with the Japanese translation file.
         */
        'JP' => array(
            'JP01' => __('Hokkaido', 'digits'),
            'JP02' => __('Aomori', 'digits'),
            'JP03' => __('Iwate', 'digits'),
            'JP04' => __('Miyagi', 'digits'),
            'JP05' => __('Akita', 'digits'),
            'JP06' => __('Yamagata', 'digits'),
            'JP07' => __('Fukushima', 'digits'),
            'JP08' => __('Ibaraki', 'digits'),
            'JP09' => __('Tochigi', 'digits'),
            'JP10' => __('Gunma', 'digits'),
            'JP11' => __('Saitama', 'digits'),
            'JP12' => __('Chiba', 'digits'),
            'JP13' => __('Tokyo', 'digits'),
            'JP14' => __('Kanagawa', 'digits'),
            'JP15' => __('Niigata', 'digits'),
            'JP16' => __('Toyama', 'digits'),
            'JP17' => __('Ishikawa', 'digits'),
            'JP18' => __('Fukui', 'digits'),
            'JP19' => __('Yamanashi', 'digits'),
            'JP20' => __('Nagano', 'digits'),
            'JP21' => __('Gifu', 'digits'),
            'JP22' => __('Shizuoka', 'digits'),
            'JP23' => __('Aichi', 'digits'),
            'JP24' => __('Mie', 'digits'),
            'JP25' => __('Shiga', 'digits'),
            'JP26' => __('Kyoto', 'digits'),
            'JP27' => __('Osaka', 'digits'),
            'JP28' => __('Hyogo', 'digits'),
            'JP29' => __('Nara', 'digits'),
            'JP30' => __('Wakayama', 'digits'),
            'JP31' => __('Tottori', 'digits'),
            'JP32' => __('Shimane', 'digits'),
            'JP33' => __('Okayama', 'digits'),
            'JP34' => __('Hiroshima', 'digits'),
            'JP35' => __('Yamaguchi', 'digits'),
            'JP36' => __('Tokushima', 'digits'),
            'JP37' => __('Kagawa', 'digits'),
            'JP38' => __('Ehime', 'digits'),
            'JP39' => __('Kochi', 'digits'),
            'JP40' => __('Fukuoka', 'digits'),
            'JP41' => __('Saga', 'digits'),
            'JP42' => __('Nagasaki', 'digits'),
            'JP43' => __('Kumamoto', 'digits'),
            'JP44' => __('Oita', 'digits'),
            'JP45' => __('Miyazaki', 'digits'),
            'JP46' => __('Kagoshima', 'digits'),
            'JP47' => __('Okinawa', 'digits'),
        ),
        'KE' => array( // Kenyan counties.
            'KE01' => __('Baringo', 'digits'),
            'KE02' => __('Bomet', 'digits'),
            'KE03' => __('Bungoma', 'digits'),
            'KE04' => __('Busia', 'digits'),
            'KE05' => __('Elgeyo-Marakwet', 'digits'),
            'KE06' => __('Embu', 'digits'),
            'KE07' => __('Garissa', 'digits'),
            'KE08' => __('Homa Bay', 'digits'),
            'KE09' => __('Isiolo', 'digits'),
            'KE10' => __('Kajiado', 'digits'),
            'KE11' => __('Kakamega', 'digits'),
            'KE12' => __('Kericho', 'digits'),
            'KE13' => __('Kiambu', 'digits'),
            'KE14' => __('Kilifi', 'digits'),
            'KE15' => __('Kirinyaga', 'digits'),
            'KE16' => __('Kisii', 'digits'),
            'KE17' => __('Kisumu', 'digits'),
            'KE18' => __('Kitui', 'digits'),
            'KE19' => __('Kwale', 'digits'),
            'KE20' => __('Laikipia', 'digits'),
            'KE21' => __('Lamu', 'digits'),
            'KE22' => __('Machakos', 'digits'),
            'KE23' => __('Makueni', 'digits'),
            'KE24' => __('Mandera', 'digits'),
            'KE25' => __('Marsabit', 'digits'),
            'KE26' => __('Meru', 'digits'),
            'KE27' => __('Migori', 'digits'),
            'KE28' => __('Mombasa', 'digits'),
            'KE29' => __('Murang’a', 'digits'),
            'KE30' => __('Nairobi County', 'digits'),
            'KE31' => __('Nakuru', 'digits'),
            'KE32' => __('Nandi', 'digits'),
            'KE33' => __('Narok', 'digits'),
            'KE34' => __('Nyamira', 'digits'),
            'KE35' => __('Nyandarua', 'digits'),
            'KE36' => __('Nyeri', 'digits'),
            'KE37' => __('Samburu', 'digits'),
            'KE38' => __('Siaya', 'digits'),
            'KE39' => __('Taita-Taveta', 'digits'),
            'KE40' => __('Tana River', 'digits'),
            'KE41' => __('Tharaka-Nithi', 'digits'),
            'KE42' => __('Trans Nzoia', 'digits'),
            'KE43' => __('Turkana', 'digits'),
            'KE44' => __('Uasin Gishu', 'digits'),
            'KE45' => __('Vihiga', 'digits'),
            'KE46' => __('Wajir', 'digits'),
            'KE47' => __('West Pokot', 'digits'),
        ),
        'KR' => array(),
        'KW' => array(),
        'LA' => array( // Laotian provinces.
            'AT' => __('Attapeu', 'digits'),
            'BK' => __('Bokeo', 'digits'),
            'BL' => __('Bolikhamsai', 'digits'),
            'CH' => __('Champasak', 'digits'),
            'HO' => __('Houaphanh', 'digits'),
            'KH' => __('Khammouane', 'digits'),
            'LM' => __('Luang Namtha', 'digits'),
            'LP' => __('Luang Prabang', 'digits'),
            'OU' => __('Oudomxay', 'digits'),
            'PH' => __('Phongsaly', 'digits'),
            'SL' => __('Salavan', 'digits'),
            'SV' => __('Savannakhet', 'digits'),
            'VI' => __('Vientiane Province', 'digits'),
            'VT' => __('Vientiane', 'digits'),
            'XA' => __('Sainyabuli', 'digits'),
            'XE' => __('Sekong', 'digits'),
            'XI' => __('Xiangkhouang', 'digits'),
            'XS' => __('Xaisomboun', 'digits'),
        ),
        'LB' => array(),
        'LI' => array(),
        'LR' => array( // Liberian provinces.
            'BM' => __('Bomi', 'digits'),
            'BN' => __('Bong', 'digits'),
            'GA' => __('Gbarpolu', 'digits'),
            'GB' => __('Grand Bassa', 'digits'),
            'GC' => __('Grand Cape Mount', 'digits'),
            'GG' => __('Grand Gedeh', 'digits'),
            'GK' => __('Grand Kru', 'digits'),
            'LO' => __('Lofa', 'digits'),
            'MA' => __('Margibi', 'digits'),
            'MY' => __('Maryland', 'digits'),
            'MO' => __('Montserrado', 'digits'),
            'NM' => __('Nimba', 'digits'),
            'RV' => __('Rivercess', 'digits'),
            'RG' => __('River Gee', 'digits'),
            'SN' => __('Sinoe', 'digits'),
        ),
        'LU' => array(),
        'MD' => array( // Moldovan states.
            'C' => __('Chișinău', 'digits'),
            'BL' => __('Bălți', 'digits'),
            'AN' => __('Anenii Noi', 'digits'),
            'BS' => __('Basarabeasca', 'digits'),
            'BR' => __('Briceni', 'digits'),
            'CH' => __('Cahul', 'digits'),
            'CT' => __('Cantemir', 'digits'),
            'CL' => __('Călărași', 'digits'),
            'CS' => __('Căușeni', 'digits'),
            'CM' => __('Cimișlia', 'digits'),
            'CR' => __('Criuleni', 'digits'),
            'DN' => __('Dondușeni', 'digits'),
            'DR' => __('Drochia', 'digits'),
            'DB' => __('Dubăsari', 'digits'),
            'ED' => __('Edineț', 'digits'),
            'FL' => __('Fălești', 'digits'),
            'FR' => __('Florești', 'digits'),
            'GE' => __('UTA Găgăuzia', 'digits'),
            'GL' => __('Glodeni', 'digits'),
            'HN' => __('Hîncești', 'digits'),
            'IL' => __('Ialoveni', 'digits'),
            'LV' => __('Leova', 'digits'),
            'NS' => __('Nisporeni', 'digits'),
            'OC' => __('Ocnița', 'digits'),
            'OR' => __('Orhei', 'digits'),
            'RZ' => __('Rezina', 'digits'),
            'RS' => __('Rîșcani', 'digits'),
            'SG' => __('Sîngerei', 'digits'),
            'SR' => __('Soroca', 'digits'),
            'ST' => __('Strășeni', 'digits'),
            'SD' => __('Șoldănești', 'digits'),
            'SV' => __('Ștefan Vodă', 'digits'),
            'TR' => __('Taraclia', 'digits'),
            'TL' => __('Telenești', 'digits'),
            'UN' => __('Ungheni', 'digits'),
        ),
        'MF' => array(),
        'MQ' => array(),
        'MT' => array(),
        'MX' => array( // Mexican states.
            'DF' => __('Ciudad de México', 'digits'),
            'JA' => __('Jalisco', 'digits'),
            'NL' => __('Nuevo León', 'digits'),
            'AG' => __('Aguascalientes', 'digits'),
            'BC' => __('Baja California', 'digits'),
            'BS' => __('Baja California Sur', 'digits'),
            'CM' => __('Campeche', 'digits'),
            'CS' => __('Chiapas', 'digits'),
            'CH' => __('Chihuahua', 'digits'),
            'CO' => __('Coahuila', 'digits'),
            'CL' => __('Colima', 'digits'),
            'DG' => __('Durango', 'digits'),
            'GT' => __('Guanajuato', 'digits'),
            'GR' => __('Guerrero', 'digits'),
            'HG' => __('Hidalgo', 'digits'),
            'MX' => __('Estado de México', 'digits'),
            'MI' => __('Michoacán', 'digits'),
            'MO' => __('Morelos', 'digits'),
            'NA' => __('Nayarit', 'digits'),
            'OA' => __('Oaxaca', 'digits'),
            'PU' => __('Puebla', 'digits'),
            'QT' => __('Querétaro', 'digits'),
            'QR' => __('Quintana Roo', 'digits'),
            'SL' => __('San Luis Potosí', 'digits'),
            'SI' => __('Sinaloa', 'digits'),
            'SO' => __('Sonora', 'digits'),
            'TB' => __('Tabasco', 'digits'),
            'TM' => __('Tamaulipas', 'digits'),
            'TL' => __('Tlaxcala', 'digits'),
            'VE' => __('Veracruz', 'digits'),
            'YU' => __('Yucatán', 'digits'),
            'ZA' => __('Zacatecas', 'digits'),
        ),
        'MY' => array( // Malaysian states.
            'JHR' => __('Johor', 'digits'),
            'KDH' => __('Kedah', 'digits'),
            'KTN' => __('Kelantan', 'digits'),
            'LBN' => __('Labuan', 'digits'),
            'MLK' => __('Malacca (Melaka)', 'digits'),
            'NSN' => __('Negeri Sembilan', 'digits'),
            'PHG' => __('Pahang', 'digits'),
            'PNG' => __('Penang (Pulau Pinang)', 'digits'),
            'PRK' => __('Perak', 'digits'),
            'PLS' => __('Perlis', 'digits'),
            'SBH' => __('Sabah', 'digits'),
            'SWK' => __('Sarawak', 'digits'),
            'SGR' => __('Selangor', 'digits'),
            'TRG' => __('Terengganu', 'digits'),
            'PJY' => __('Putrajaya', 'digits'),
            'KUL' => __('Kuala Lumpur', 'digits'),
        ),
        'MZ' => array( // Mozambican provinces.
            'MZP' => __('Cabo Delgado', 'digits'),
            'MZG' => __('Gaza', 'digits'),
            'MZI' => __('Inhambane', 'digits'),
            'MZB' => __('Manica', 'digits'),
            'MZL' => __('Maputo Province', 'digits'),
            'MZMPM' => __('Maputo', 'digits'),
            'MZN' => __('Nampula', 'digits'),
            'MZA' => __('Niassa', 'digits'),
            'MZS' => __('Sofala', 'digits'),
            'MZT' => __('Tete', 'digits'),
            'MZQ' => __('Zambézia', 'digits'),
        ),
        'NA' => array( // Namibian regions.
            'ER' => __('Erongo', 'digits'),
            'HA' => __('Hardap', 'digits'),
            'KA' => __('Karas', 'digits'),
            'KE' => __('Kavango East', 'digits'),
            'KW' => __('Kavango West', 'digits'),
            'KH' => __('Khomas', 'digits'),
            'KU' => __('Kunene', 'digits'),
            'OW' => __('Ohangwena', 'digits'),
            'OH' => __('Omaheke', 'digits'),
            'OS' => __('Omusati', 'digits'),
            'ON' => __('Oshana', 'digits'),
            'OT' => __('Oshikoto', 'digits'),
            'OD' => __('Otjozondjupa', 'digits'),
            'CA' => __('Zambezi', 'digits'),
        ),
        'NG' => array( // Nigerian provinces.
            'AB' => __('Abia', 'digits'),
            'FC' => __('Abuja', 'digits'),
            'AD' => __('Adamawa', 'digits'),
            'AK' => __('Akwa Ibom', 'digits'),
            'AN' => __('Anambra', 'digits'),
            'BA' => __('Bauchi', 'digits'),
            'BY' => __('Bayelsa', 'digits'),
            'BE' => __('Benue', 'digits'),
            'BO' => __('Borno', 'digits'),
            'CR' => __('Cross River', 'digits'),
            'DE' => __('Delta', 'digits'),
            'EB' => __('Ebonyi', 'digits'),
            'ED' => __('Edo', 'digits'),
            'EK' => __('Ekiti', 'digits'),
            'EN' => __('Enugu', 'digits'),
            'GO' => __('Gombe', 'digits'),
            'IM' => __('Imo', 'digits'),
            'JI' => __('Jigawa', 'digits'),
            'KD' => __('Kaduna', 'digits'),
            'KN' => __('Kano', 'digits'),
            'KT' => __('Katsina', 'digits'),
            'KE' => __('Kebbi', 'digits'),
            'KO' => __('Kogi', 'digits'),
            'KW' => __('Kwara', 'digits'),
            'LA' => __('Lagos', 'digits'),
            'NA' => __('Nasarawa', 'digits'),
            'NI' => __('Niger', 'digits'),
            'OG' => __('Ogun', 'digits'),
            'ON' => __('Ondo', 'digits'),
            'OS' => __('Osun', 'digits'),
            'OY' => __('Oyo', 'digits'),
            'PL' => __('Plateau', 'digits'),
            'RI' => __('Rivers', 'digits'),
            'SO' => __('Sokoto', 'digits'),
            'TA' => __('Taraba', 'digits'),
            'YO' => __('Yobe', 'digits'),
            'ZA' => __('Zamfara', 'digits'),
        ),
        'NL' => array(),
        'NO' => array(),
        'NP' => array( // Nepalese zones.
            'BAG' => __('Bagmati', 'digits'),
            'BHE' => __('Bheri', 'digits'),
            'DHA' => __('Dhaulagiri', 'digits'),
            'GAN' => __('Gandaki', 'digits'),
            'JAN' => __('Janakpur', 'digits'),
            'KAR' => __('Karnali', 'digits'),
            'KOS' => __('Koshi', 'digits'),
            'LUM' => __('Lumbini', 'digits'),
            'MAH' => __('Mahakali', 'digits'),
            'MEC' => __('Mechi', 'digits'),
            'NAR' => __('Narayani', 'digits'),
            'RAP' => __('Rapti', 'digits'),
            'SAG' => __('Sagarmatha', 'digits'),
            'SET' => __('Seti', 'digits'),
        ),
        'NI' => array( // Nicaraguan states.
            'NI-AN' => __('Atlántico Norte', 'digits'),
            'NI-AS' => __('Atlántico Sur', 'digits'),
            'NI-BO' => __('Boaco', 'digits'),
            'NI-CA' => __('Carazo', 'digits'),
            'NI-CI' => __('Chinandega', 'digits'),
            'NI-CO' => __('Chontales', 'digits'),
            'NI-ES' => __('Estelí', 'digits'),
            'NI-GR' => __('Granada', 'digits'),
            'NI-JI' => __('Jinotega', 'digits'),
            'NI-LE' => __('León', 'digits'),
            'NI-MD' => __('Madriz', 'digits'),
            'NI-MN' => __('Managua', 'digits'),
            'NI-MS' => __('Masaya', 'digits'),
            'NI-MT' => __('Matagalpa', 'digits'),
            'NI-NS' => __('Nueva Segovia', 'digits'),
            'NI-RI' => __('Rivas', 'digits'),
            'NI-SJ' => __('Río San Juan', 'digits'),
        ),
        'NZ' => array( // New Zealand states.
            'NTL' => __('Northland', 'digits'),
            'AUK' => __('Auckland', 'digits'),
            'WKO' => __('Waikato', 'digits'),
            'BOP' => __('Bay of Plenty', 'digits'),
            'TKI' => __('Taranaki', 'digits'),
            'GIS' => __('Gisborne', 'digits'),
            'HKB' => __('Hawke’s Bay', 'digits'),
            'MWT' => __('Manawatu-Wanganui', 'digits'),
            'WGN' => __('Wellington', 'digits'),
            'NSN' => __('Nelson', 'digits'),
            'MBH' => __('Marlborough', 'digits'),
            'TAS' => __('Tasman', 'digits'),
            'WTC' => __('West Coast', 'digits'),
            'CAN' => __('Canterbury', 'digits'),
            'OTA' => __('Otago', 'digits'),
            'STL' => __('Southland', 'digits'),
        ),
        'PA' => array( // Panamanian states.
            'PA-1' => __('Bocas del Toro', 'digits'),
            'PA-2' => __('Coclé', 'digits'),
            'PA-3' => __('Colón', 'digits'),
            'PA-4' => __('Chiriquí', 'digits'),
            'PA-5' => __('Darién', 'digits'),
            'PA-6' => __('Herrera', 'digits'),
            'PA-7' => __('Los Santos', 'digits'),
            'PA-8' => __('Panamá', 'digits'),
            'PA-9' => __('Veraguas', 'digits'),
            'PA-10' => __('West Panamá', 'digits'),
            'PA-EM' => __('Emberá', 'digits'),
            'PA-KY' => __('Guna Yala', 'digits'),
            'PA-NB' => __('Ngöbe-Buglé', 'digits'),
        ),
        'PE' => array( // Peruvian states.
            'CAL' => __('El Callao', 'digits'),
            'LMA' => __('Municipalidad Metropolitana de Lima', 'digits'),
            'AMA' => __('Amazonas', 'digits'),
            'ANC' => __('Ancash', 'digits'),
            'APU' => __('Apurímac', 'digits'),
            'ARE' => __('Arequipa', 'digits'),
            'AYA' => __('Ayacucho', 'digits'),
            'CAJ' => __('Cajamarca', 'digits'),
            'CUS' => __('Cusco', 'digits'),
            'HUV' => __('Huancavelica', 'digits'),
            'HUC' => __('Huánuco', 'digits'),
            'ICA' => __('Ica', 'digits'),
            'JUN' => __('Junín', 'digits'),
            'LAL' => __('La Libertad', 'digits'),
            'LAM' => __('Lambayeque', 'digits'),
            'LIM' => __('Lima', 'digits'),
            'LOR' => __('Loreto', 'digits'),
            'MDD' => __('Madre de Dios', 'digits'),
            'MOQ' => __('Moquegua', 'digits'),
            'PAS' => __('Pasco', 'digits'),
            'PIU' => __('Piura', 'digits'),
            'PUN' => __('Puno', 'digits'),
            'SAM' => __('San Martín', 'digits'),
            'TAC' => __('Tacna', 'digits'),
            'TUM' => __('Tumbes', 'digits'),
            'UCA' => __('Ucayali', 'digits'),
        ),
        'PH' => array( // Philippine provinces.
            'ABR' => __('Abra', 'digits'),
            'AGN' => __('Agusan del Norte', 'digits'),
            'AGS' => __('Agusan del Sur', 'digits'),
            'AKL' => __('Aklan', 'digits'),
            'ALB' => __('Albay', 'digits'),
            'ANT' => __('Antique', 'digits'),
            'APA' => __('Apayao', 'digits'),
            'AUR' => __('Aurora', 'digits'),
            'BAS' => __('Basilan', 'digits'),
            'BAN' => __('Bataan', 'digits'),
            'BTN' => __('Batanes', 'digits'),
            'BTG' => __('Batangas', 'digits'),
            'BEN' => __('Benguet', 'digits'),
            'BIL' => __('Biliran', 'digits'),
            'BOH' => __('Bohol', 'digits'),
            'BUK' => __('Bukidnon', 'digits'),
            'BUL' => __('Bulacan', 'digits'),
            'CAG' => __('Cagayan', 'digits'),
            'CAN' => __('Camarines Norte', 'digits'),
            'CAS' => __('Camarines Sur', 'digits'),
            'CAM' => __('Camiguin', 'digits'),
            'CAP' => __('Capiz', 'digits'),
            'CAT' => __('Catanduanes', 'digits'),
            'CAV' => __('Cavite', 'digits'),
            'CEB' => __('Cebu', 'digits'),
            'COM' => __('Compostela Valley', 'digits'),
            'NCO' => __('Cotabato', 'digits'),
            'DAV' => __('Davao del Norte', 'digits'),
            'DAS' => __('Davao del Sur', 'digits'),
            'DAC' => __('Davao Occidental', 'digits'),
            'DAO' => __('Davao Oriental', 'digits'),
            'DIN' => __('Dinagat Islands', 'digits'),
            'EAS' => __('Eastern Samar', 'digits'),
            'GUI' => __('Guimaras', 'digits'),
            'IFU' => __('Ifugao', 'digits'),
            'ILN' => __('Ilocos Norte', 'digits'),
            'ILS' => __('Ilocos Sur', 'digits'),
            'ILI' => __('Iloilo', 'digits'),
            'ISA' => __('Isabela', 'digits'),
            'KAL' => __('Kalinga', 'digits'),
            'LUN' => __('La Union', 'digits'),
            'LAG' => __('Laguna', 'digits'),
            'LAN' => __('Lanao del Norte', 'digits'),
            'LAS' => __('Lanao del Sur', 'digits'),
            'LEY' => __('Leyte', 'digits'),
            'MAG' => __('Maguindanao', 'digits'),
            'MAD' => __('Marinduque', 'digits'),
            'MAS' => __('Masbate', 'digits'),
            'MSC' => __('Misamis Occidental', 'digits'),
            'MSR' => __('Misamis Oriental', 'digits'),
            'MOU' => __('Mountain Province', 'digits'),
            'NEC' => __('Negros Occidental', 'digits'),
            'NER' => __('Negros Oriental', 'digits'),
            'NSA' => __('Northern Samar', 'digits'),
            'NUE' => __('Nueva Ecija', 'digits'),
            'NUV' => __('Nueva Vizcaya', 'digits'),
            'MDC' => __('Occidental Mindoro', 'digits'),
            'MDR' => __('Oriental Mindoro', 'digits'),
            'PLW' => __('Palawan', 'digits'),
            'PAM' => __('Pampanga', 'digits'),
            'PAN' => __('Pangasinan', 'digits'),
            'QUE' => __('Quezon', 'digits'),
            'QUI' => __('Quirino', 'digits'),
            'RIZ' => __('Rizal', 'digits'),
            'ROM' => __('Romblon', 'digits'),
            'WSA' => __('Samar', 'digits'),
            'SAR' => __('Sarangani', 'digits'),
            'SIQ' => __('Siquijor', 'digits'),
            'SOR' => __('Sorsogon', 'digits'),
            'SCO' => __('South Cotabato', 'digits'),
            'SLE' => __('Southern Leyte', 'digits'),
            'SUK' => __('Sultan Kudarat', 'digits'),
            'SLU' => __('Sulu', 'digits'),
            'SUN' => __('Surigao del Norte', 'digits'),
            'SUR' => __('Surigao del Sur', 'digits'),
            'TAR' => __('Tarlac', 'digits'),
            'TAW' => __('Tawi-Tawi', 'digits'),
            'ZMB' => __('Zambales', 'digits'),
            'ZAN' => __('Zamboanga del Norte', 'digits'),
            'ZAS' => __('Zamboanga del Sur', 'digits'),
            'ZSI' => __('Zamboanga Sibugay', 'digits'),
            '00' => __('Metro Manila', 'digits'),
        ),
        'PK' => array( // Pakistani states.
            'JK' => __('Azad Kashmir', 'digits'),
            'BA' => __('Balochistan', 'digits'),
            'TA' => __('FATA', 'digits'),
            'GB' => __('Gilgit Baltistan', 'digits'),
            'IS' => __('Islamabad Capital Territory', 'digits'),
            'KP' => __('Khyber Pakhtunkhwa', 'digits'),
            'PB' => __('Punjab', 'digits'),
            'SD' => __('Sindh', 'digits'),
        ),
        'PL' => array(),
        'PR' => array(),
        'PT' => array(),
        'PY' => array( // Paraguayan states.
            'PY-ASU' => __('Asunción', 'digits'),
            'PY-1' => __('Concepción', 'digits'),
            'PY-2' => __('San Pedro', 'digits'),
            'PY-3' => __('Cordillera', 'digits'),
            'PY-4' => __('Guairá', 'digits'),
            'PY-5' => __('Caaguazú', 'digits'),
            'PY-6' => __('Caazapá', 'digits'),
            'PY-7' => __('Itapúa', 'digits'),
            'PY-8' => __('Misiones', 'digits'),
            'PY-9' => __('Paraguarí', 'digits'),
            'PY-10' => __('Alto Paraná', 'digits'),
            'PY-11' => __('Central', 'digits'),
            'PY-12' => __('Ñeembucú', 'digits'),
            'PY-13' => __('Amambay', 'digits'),
            'PY-14' => __('Canindeyú', 'digits'),
            'PY-15' => __('Presidente Hayes', 'digits'),
            'PY-16' => __('Alto Paraguay', 'digits'),
            'PY-17' => __('Boquerón', 'digits'),
        ),
        'RE' => array(),
        'RO' => array( // Romanian states.
            'AB' => __('Alba', 'digits'),
            'AR' => __('Arad', 'digits'),
            'AG' => __('Argeș', 'digits'),
            'BC' => __('Bacău', 'digits'),
            'BH' => __('Bihor', 'digits'),
            'BN' => __('Bistrița-Năsăud', 'digits'),
            'BT' => __('Botoșani', 'digits'),
            'BR' => __('Brăila', 'digits'),
            'BV' => __('Brașov', 'digits'),
            'B' => __('București', 'digits'),
            'BZ' => __('Buzău', 'digits'),
            'CL' => __('Călărași', 'digits'),
            'CS' => __('Caraș-Severin', 'digits'),
            'CJ' => __('Cluj', 'digits'),
            'CT' => __('Constanța', 'digits'),
            'CV' => __('Covasna', 'digits'),
            'DB' => __('Dâmbovița', 'digits'),
            'DJ' => __('Dolj', 'digits'),
            'GL' => __('Galați', 'digits'),
            'GR' => __('Giurgiu', 'digits'),
            'GJ' => __('Gorj', 'digits'),
            'HR' => __('Harghita', 'digits'),
            'HD' => __('Hunedoara', 'digits'),
            'IL' => __('Ialomița', 'digits'),
            'IS' => __('Iași', 'digits'),
            'IF' => __('Ilfov', 'digits'),
            'MM' => __('Maramureș', 'digits'),
            'MH' => __('Mehedinți', 'digits'),
            'MS' => __('Mureș', 'digits'),
            'NT' => __('Neamț', 'digits'),
            'OT' => __('Olt', 'digits'),
            'PH' => __('Prahova', 'digits'),
            'SJ' => __('Sălaj', 'digits'),
            'SM' => __('Satu Mare', 'digits'),
            'SB' => __('Sibiu', 'digits'),
            'SV' => __('Suceava', 'digits'),
            'TR' => __('Teleorman', 'digits'),
            'TM' => __('Timiș', 'digits'),
            'TL' => __('Tulcea', 'digits'),
            'VL' => __('Vâlcea', 'digits'),
            'VS' => __('Vaslui', 'digits'),
            'VN' => __('Vrancea', 'digits'),
        ),
        'SN' => array( // Regions of Senegal. Ref: https://github.com/unicode-org/cldr/blob/release-42/common/subdivisions/en.xml#L4801.
            'SNDB' => __('Diourbel', 'digits'),
            'SNDK' => __('Dakar', 'digits'),
            'SNFK' => __('Fatick', 'digits'),
            'SNKA' => __('Kaffrine', 'digits'),
            'SNKD' => __('Kolda', 'digits'),
            'SNKE' => __('Kédougou', 'digits'),
            'SNKL' => __('Kaolack', 'digits'),
            'SNLG' => __('Louga', 'digits'),
            'SNMT' => __('Matam', 'digits'),
            'SNSE' => __('Sédhiou', 'digits'),
            'SNSL' => __('Saint-Louis', 'digits'),
            'SNTC' => __('Tambacounda', 'digits'),
            'SNTH' => __('Thiès', 'digits'),
            'SNZG' => __('Ziguinchor', 'digits'),
        ),
        'SG' => array(),
        'SK' => array(),
        'SI' => array(),
        'SV' => array( // Salvadoran states.
            'SV-AH' => __('Ahuachapán', 'digits'),
            'SV-CA' => __('Cabañas', 'digits'),
            'SV-CH' => __('Chalatenango', 'digits'),
            'SV-CU' => __('Cuscatlán', 'digits'),
            'SV-LI' => __('La Libertad', 'digits'),
            'SV-MO' => __('Morazán', 'digits'),
            'SV-PA' => __('La Paz', 'digits'),
            'SV-SA' => __('Santa Ana', 'digits'),
            'SV-SM' => __('San Miguel', 'digits'),
            'SV-SO' => __('Sonsonate', 'digits'),
            'SV-SS' => __('San Salvador', 'digits'),
            'SV-SV' => __('San Vicente', 'digits'),
            'SV-UN' => __('La Unión', 'digits'),
            'SV-US' => __('Usulután', 'digits'),
        ),
        'TH' => array( // Thai states.
            'TH-37' => __('Amnat Charoen', 'digits'),
            'TH-15' => __('Ang Thong', 'digits'),
            'TH-14' => __('Ayutthaya', 'digits'),
            'TH-10' => __('Bangkok', 'digits'),
            'TH-38' => __('Bueng Kan', 'digits'),
            'TH-31' => __('Buri Ram', 'digits'),
            'TH-24' => __('Chachoengsao', 'digits'),
            'TH-18' => __('Chai Nat', 'digits'),
            'TH-36' => __('Chaiyaphum', 'digits'),
            'TH-22' => __('Chanthaburi', 'digits'),
            'TH-50' => __('Chiang Mai', 'digits'),
            'TH-57' => __('Chiang Rai', 'digits'),
            'TH-20' => __('Chonburi', 'digits'),
            'TH-86' => __('Chumphon', 'digits'),
            'TH-46' => __('Kalasin', 'digits'),
            'TH-62' => __('Kamphaeng Phet', 'digits'),
            'TH-71' => __('Kanchanaburi', 'digits'),
            'TH-40' => __('Khon Kaen', 'digits'),
            'TH-81' => __('Krabi', 'digits'),
            'TH-52' => __('Lampang', 'digits'),
            'TH-51' => __('Lamphun', 'digits'),
            'TH-42' => __('Loei', 'digits'),
            'TH-16' => __('Lopburi', 'digits'),
            'TH-58' => __('Mae Hong Son', 'digits'),
            'TH-44' => __('Maha Sarakham', 'digits'),
            'TH-49' => __('Mukdahan', 'digits'),
            'TH-26' => __('Nakhon Nayok', 'digits'),
            'TH-73' => __('Nakhon Pathom', 'digits'),
            'TH-48' => __('Nakhon Phanom', 'digits'),
            'TH-30' => __('Nakhon Ratchasima', 'digits'),
            'TH-60' => __('Nakhon Sawan', 'digits'),
            'TH-80' => __('Nakhon Si Thammarat', 'digits'),
            'TH-55' => __('Nan', 'digits'),
            'TH-96' => __('Narathiwat', 'digits'),
            'TH-39' => __('Nong Bua Lam Phu', 'digits'),
            'TH-43' => __('Nong Khai', 'digits'),
            'TH-12' => __('Nonthaburi', 'digits'),
            'TH-13' => __('Pathum Thani', 'digits'),
            'TH-94' => __('Pattani', 'digits'),
            'TH-82' => __('Phang Nga', 'digits'),
            'TH-93' => __('Phatthalung', 'digits'),
            'TH-56' => __('Phayao', 'digits'),
            'TH-67' => __('Phetchabun', 'digits'),
            'TH-76' => __('Phetchaburi', 'digits'),
            'TH-66' => __('Phichit', 'digits'),
            'TH-65' => __('Phitsanulok', 'digits'),
            'TH-54' => __('Phrae', 'digits'),
            'TH-83' => __('Phuket', 'digits'),
            'TH-25' => __('Prachin Buri', 'digits'),
            'TH-77' => __('Prachuap Khiri Khan', 'digits'),
            'TH-85' => __('Ranong', 'digits'),
            'TH-70' => __('Ratchaburi', 'digits'),
            'TH-21' => __('Rayong', 'digits'),
            'TH-45' => __('Roi Et', 'digits'),
            'TH-27' => __('Sa Kaeo', 'digits'),
            'TH-47' => __('Sakon Nakhon', 'digits'),
            'TH-11' => __('Samut Prakan', 'digits'),
            'TH-74' => __('Samut Sakhon', 'digits'),
            'TH-75' => __('Samut Songkhram', 'digits'),
            'TH-19' => __('Saraburi', 'digits'),
            'TH-91' => __('Satun', 'digits'),
            'TH-17' => __('Sing Buri', 'digits'),
            'TH-33' => __('Sisaket', 'digits'),
            'TH-90' => __('Songkhla', 'digits'),
            'TH-64' => __('Sukhothai', 'digits'),
            'TH-72' => __('Suphan Buri', 'digits'),
            'TH-84' => __('Surat Thani', 'digits'),
            'TH-32' => __('Surin', 'digits'),
            'TH-63' => __('Tak', 'digits'),
            'TH-92' => __('Trang', 'digits'),
            'TH-23' => __('Trat', 'digits'),
            'TH-34' => __('Ubon Ratchathani', 'digits'),
            'TH-41' => __('Udon Thani', 'digits'),
            'TH-61' => __('Uthai Thani', 'digits'),
            'TH-53' => __('Uttaradit', 'digits'),
            'TH-95' => __('Yala', 'digits'),
            'TH-35' => __('Yasothon', 'digits'),
        ),
        'TR' => array( // Turkish states.
            'TR01' => __('Adana', 'digits'),
            'TR02' => __('Adıyaman', 'digits'),
            'TR03' => __('Afyon', 'digits'),
            'TR04' => __('Ağrı', 'digits'),
            'TR05' => __('Amasya', 'digits'),
            'TR06' => __('Ankara', 'digits'),
            'TR07' => __('Antalya', 'digits'),
            'TR08' => __('Artvin', 'digits'),
            'TR09' => __('Aydın', 'digits'),
            'TR10' => __('Balıkesir', 'digits'),
            'TR11' => __('Bilecik', 'digits'),
            'TR12' => __('Bingöl', 'digits'),
            'TR13' => __('Bitlis', 'digits'),
            'TR14' => __('Bolu', 'digits'),
            'TR15' => __('Burdur', 'digits'),
            'TR16' => __('Bursa', 'digits'),
            'TR17' => __('Çanakkale', 'digits'),
            'TR18' => __('Çankırı', 'digits'),
            'TR19' => __('Çorum', 'digits'),
            'TR20' => __('Denizli', 'digits'),
            'TR21' => __('Diyarbakır', 'digits'),
            'TR22' => __('Edirne', 'digits'),
            'TR23' => __('Elazığ', 'digits'),
            'TR24' => __('Erzincan', 'digits'),
            'TR25' => __('Erzurum', 'digits'),
            'TR26' => __('Eskişehir', 'digits'),
            'TR27' => __('Gaziantep', 'digits'),
            'TR28' => __('Giresun', 'digits'),
            'TR29' => __('Gümüşhane', 'digits'),
            'TR30' => __('Hakkari', 'digits'),
            'TR31' => __('Hatay', 'digits'),
            'TR32' => __('Isparta', 'digits'),
            'TR33' => __('İçel', 'digits'),
            'TR34' => __('İstanbul', 'digits'),
            'TR35' => __('İzmir', 'digits'),
            'TR36' => __('Kars', 'digits'),
            'TR37' => __('Kastamonu', 'digits'),
            'TR38' => __('Kayseri', 'digits'),
            'TR39' => __('Kırklareli', 'digits'),
            'TR40' => __('Kırşehir', 'digits'),
            'TR41' => __('Kocaeli', 'digits'),
            'TR42' => __('Konya', 'digits'),
            'TR43' => __('Kütahya', 'digits'),
            'TR44' => __('Malatya', 'digits'),
            'TR45' => __('Manisa', 'digits'),
            'TR46' => __('Kahramanmaraş', 'digits'),
            'TR47' => __('Mardin', 'digits'),
            'TR48' => __('Muğla', 'digits'),
            'TR49' => __('Muş', 'digits'),
            'TR50' => __('Nevşehir', 'digits'),
            'TR51' => __('Niğde', 'digits'),
            'TR52' => __('Ordu', 'digits'),
            'TR53' => __('Rize', 'digits'),
            'TR54' => __('Sakarya', 'digits'),
            'TR55' => __('Samsun', 'digits'),
            'TR56' => __('Siirt', 'digits'),
            'TR57' => __('Sinop', 'digits'),
            'TR58' => __('Sivas', 'digits'),
            'TR59' => __('Tekirdağ', 'digits'),
            'TR60' => __('Tokat', 'digits'),
            'TR61' => __('Trabzon', 'digits'),
            'TR62' => __('Tunceli', 'digits'),
            'TR63' => __('Şanlıurfa', 'digits'),
            'TR64' => __('Uşak', 'digits'),
            'TR65' => __('Van', 'digits'),
            'TR66' => __('Yozgat', 'digits'),
            'TR67' => __('Zonguldak', 'digits'),
            'TR68' => __('Aksaray', 'digits'),
            'TR69' => __('Bayburt', 'digits'),
            'TR70' => __('Karaman', 'digits'),
            'TR71' => __('Kırıkkale', 'digits'),
            'TR72' => __('Batman', 'digits'),
            'TR73' => __('Şırnak', 'digits'),
            'TR74' => __('Bartın', 'digits'),
            'TR75' => __('Ardahan', 'digits'),
            'TR76' => __('Iğdır', 'digits'),
            'TR77' => __('Yalova', 'digits'),
            'TR78' => __('Karabük', 'digits'),
            'TR79' => __('Kilis', 'digits'),
            'TR80' => __('Osmaniye', 'digits'),
            'TR81' => __('Düzce', 'digits'),
        ),
        'TZ' => array( // Tanzanian states.
            'TZ01' => __('Arusha', 'digits'),
            'TZ02' => __('Dar es Salaam', 'digits'),
            'TZ03' => __('Dodoma', 'digits'),
            'TZ04' => __('Iringa', 'digits'),
            'TZ05' => __('Kagera', 'digits'),
            'TZ06' => __('Pemba North', 'digits'),
            'TZ07' => __('Zanzibar North', 'digits'),
            'TZ08' => __('Kigoma', 'digits'),
            'TZ09' => __('Kilimanjaro', 'digits'),
            'TZ10' => __('Pemba South', 'digits'),
            'TZ11' => __('Zanzibar South', 'digits'),
            'TZ12' => __('Lindi', 'digits'),
            'TZ13' => __('Mara', 'digits'),
            'TZ14' => __('Mbeya', 'digits'),
            'TZ15' => __('Zanzibar West', 'digits'),
            'TZ16' => __('Morogoro', 'digits'),
            'TZ17' => __('Mtwara', 'digits'),
            'TZ18' => __('Mwanza', 'digits'),
            'TZ19' => __('Coast', 'digits'),
            'TZ20' => __('Rukwa', 'digits'),
            'TZ21' => __('Ruvuma', 'digits'),
            'TZ22' => __('Shinyanga', 'digits'),
            'TZ23' => __('Singida', 'digits'),
            'TZ24' => __('Tabora', 'digits'),
            'TZ25' => __('Tanga', 'digits'),
            'TZ26' => __('Manyara', 'digits'),
            'TZ27' => __('Geita', 'digits'),
            'TZ28' => __('Katavi', 'digits'),
            'TZ29' => __('Njombe', 'digits'),
            'TZ30' => __('Simiyu', 'digits'),
        ),
        'LK' => array(),
        'RS' => array( // Serbian districts.
            'RS00' => _x('Belgrade', 'district', 'digits'),
            'RS14' => _x('Bor', 'district', 'digits'),
            'RS11' => _x('Braničevo', 'district', 'digits'),
            'RS02' => _x('Central Banat', 'district', 'digits'),
            'RS10' => _x('Danube', 'district', 'digits'),
            'RS23' => _x('Jablanica', 'district', 'digits'),
            'RS09' => _x('Kolubara', 'district', 'digits'),
            'RS08' => _x('Mačva', 'district', 'digits'),
            'RS17' => _x('Morava', 'district', 'digits'),
            'RS20' => _x('Nišava', 'district', 'digits'),
            'RS01' => _x('North Bačka', 'district', 'digits'),
            'RS03' => _x('North Banat', 'district', 'digits'),
            'RS24' => _x('Pčinja', 'district', 'digits'),
            'RS22' => _x('Pirot', 'district', 'digits'),
            'RS13' => _x('Pomoravlje', 'district', 'digits'),
            'RS19' => _x('Rasina', 'district', 'digits'),
            'RS18' => _x('Raška', 'district', 'digits'),
            'RS06' => _x('South Bačka', 'district', 'digits'),
            'RS04' => _x('South Banat', 'district', 'digits'),
            'RS07' => _x('Srem', 'district', 'digits'),
            'RS12' => _x('Šumadija', 'district', 'digits'),
            'RS21' => _x('Toplica', 'district', 'digits'),
            'RS05' => _x('West Bačka', 'district', 'digits'),
            'RS15' => _x('Zaječar', 'district', 'digits'),
            'RS16' => _x('Zlatibor', 'district', 'digits'),
            'RS25' => _x('Kosovo', 'district', 'digits'),
            'RS26' => _x('Peć', 'district', 'digits'),
            'RS27' => _x('Prizren', 'district', 'digits'),
            'RS28' => _x('Kosovska Mitrovica', 'district', 'digits'),
            'RS29' => _x('Kosovo-Pomoravlje', 'district', 'digits'),
            'RSKM' => _x('Kosovo-Metohija', 'district', 'digits'),
            'RSVO' => _x('Vojvodina', 'district', 'digits'),
        ),
        'SE' => array(),
        'UA' => array( // Ukrainian oblasts. https://github.com/unicode-org/cldr/blob/release-42/common/subdivisions/en.xml#L5243.
            'UA05' => __('Vinnychchyna', 'digits'),
            'UA07' => __('Volyn', 'digits'),
            'UA09' => __('Luhanshchyna', 'digits'),
            'UA12' => __('Dnipropetrovshchyna', 'digits'),
            'UA14' => __('Donechchyna', 'digits'),
            'UA18' => __('Zhytomyrshchyna', 'digits'),
            'UA21' => __('Zakarpattia', 'digits'),
            'UA23' => __('Zaporizhzhya', 'digits'),
            'UA26' => __('Prykarpattia', 'digits'),
            'UA30' => __('Kyiv', 'digits'),
            'UA32' => __('Kyivshchyna', 'digits'),
            'UA35' => __('Kirovohradschyna', 'digits'),
            'UA40' => __('Sevastopol', 'digits'),
            'UA43' => __('Crimea', 'digits'),
            'UA46' => __('Lvivshchyna', 'digits'),
            'UA48' => __('Mykolayivschyna', 'digits'),
            'UA51' => __('Odeshchyna', 'digits'),
            'UA53' => __('Poltavshchyna', 'digits'),
            'UA56' => __('Rivnenshchyna', 'digits'),
            'UA59' => __('Sumshchyna', 'digits'),
            'UA61' => __('Ternopilshchyna', 'digits'),
            'UA63' => __('Kharkivshchyna', 'digits'),
            'UA65' => __('Khersonshchyna', 'digits'),
            'UA68' => __('Khmelnychchyna', 'digits'),
            'UA71' => __('Cherkashchyna', 'digits'),
            'UA74' => __('Chernihivshchyna', 'digits'),
            'UA77' => __('Chernivtsi Oblast', 'digits'),
        ),
        'UG' => array( // Ugandan districts.
            'UG314' => __('Abim', 'digits'),
            'UG301' => __('Adjumani', 'digits'),
            'UG322' => __('Agago', 'digits'),
            'UG323' => __('Alebtong', 'digits'),
            'UG315' => __('Amolatar', 'digits'),
            'UG324' => __('Amudat', 'digits'),
            'UG216' => __('Amuria', 'digits'),
            'UG316' => __('Amuru', 'digits'),
            'UG302' => __('Apac', 'digits'),
            'UG303' => __('Arua', 'digits'),
            'UG217' => __('Budaka', 'digits'),
            'UG218' => __('Bududa', 'digits'),
            'UG201' => __('Bugiri', 'digits'),
            'UG235' => __('Bugweri', 'digits'),
            'UG420' => __('Buhweju', 'digits'),
            'UG117' => __('Buikwe', 'digits'),
            'UG219' => __('Bukedea', 'digits'),
            'UG118' => __('Bukomansimbi', 'digits'),
            'UG220' => __('Bukwa', 'digits'),
            'UG225' => __('Bulambuli', 'digits'),
            'UG416' => __('Buliisa', 'digits'),
            'UG401' => __('Bundibugyo', 'digits'),
            'UG430' => __('Bunyangabu', 'digits'),
            'UG402' => __('Bushenyi', 'digits'),
            'UG202' => __('Busia', 'digits'),
            'UG221' => __('Butaleja', 'digits'),
            'UG119' => __('Butambala', 'digits'),
            'UG233' => __('Butebo', 'digits'),
            'UG120' => __('Buvuma', 'digits'),
            'UG226' => __('Buyende', 'digits'),
            'UG317' => __('Dokolo', 'digits'),
            'UG121' => __('Gomba', 'digits'),
            'UG304' => __('Gulu', 'digits'),
            'UG403' => __('Hoima', 'digits'),
            'UG417' => __('Ibanda', 'digits'),
            'UG203' => __('Iganga', 'digits'),
            'UG418' => __('Isingiro', 'digits'),
            'UG204' => __('Jinja', 'digits'),
            'UG318' => __('Kaabong', 'digits'),
            'UG404' => __('Kabale', 'digits'),
            'UG405' => __('Kabarole', 'digits'),
            'UG213' => __('Kaberamaido', 'digits'),
            'UG427' => __('Kagadi', 'digits'),
            'UG428' => __('Kakumiro', 'digits'),
            'UG101' => __('Kalangala', 'digits'),
            'UG222' => __('Kaliro', 'digits'),
            'UG122' => __('Kalungu', 'digits'),
            'UG102' => __('Kampala', 'digits'),
            'UG205' => __('Kamuli', 'digits'),
            'UG413' => __('Kamwenge', 'digits'),
            'UG414' => __('Kanungu', 'digits'),
            'UG206' => __('Kapchorwa', 'digits'),
            'UG236' => __('Kapelebyong', 'digits'),
            'UG126' => __('Kasanda', 'digits'),
            'UG406' => __('Kasese', 'digits'),
            'UG207' => __('Katakwi', 'digits'),
            'UG112' => __('Kayunga', 'digits'),
            'UG407' => __('Kibaale', 'digits'),
            'UG103' => __('Kiboga', 'digits'),
            'UG227' => __('Kibuku', 'digits'),
            'UG432' => __('Kikuube', 'digits'),
            'UG419' => __('Kiruhura', 'digits'),
            'UG421' => __('Kiryandongo', 'digits'),
            'UG408' => __('Kisoro', 'digits'),
            'UG305' => __('Kitgum', 'digits'),
            'UG319' => __('Koboko', 'digits'),
            'UG325' => __('Kole', 'digits'),
            'UG306' => __('Kotido', 'digits'),
            'UG208' => __('Kumi', 'digits'),
            'UG333' => __('Kwania', 'digits'),
            'UG228' => __('Kween', 'digits'),
            'UG123' => __('Kyankwanzi', 'digits'),
            'UG422' => __('Kyegegwa', 'digits'),
            'UG415' => __('Kyenjojo', 'digits'),
            'UG125' => __('Kyotera', 'digits'),
            'UG326' => __('Lamwo', 'digits'),
            'UG307' => __('Lira', 'digits'),
            'UG229' => __('Luuka', 'digits'),
            'UG104' => __('Luwero', 'digits'),
            'UG124' => __('Lwengo', 'digits'),
            'UG114' => __('Lyantonde', 'digits'),
            'UG223' => __('Manafwa', 'digits'),
            'UG320' => __('Maracha', 'digits'),
            'UG105' => __('Masaka', 'digits'),
            'UG409' => __('Masindi', 'digits'),
            'UG214' => __('Mayuge', 'digits'),
            'UG209' => __('Mbale', 'digits'),
            'UG410' => __('Mbarara', 'digits'),
            'UG423' => __('Mitooma', 'digits'),
            'UG115' => __('Mityana', 'digits'),
            'UG308' => __('Moroto', 'digits'),
            'UG309' => __('Moyo', 'digits'),
            'UG106' => __('Mpigi', 'digits'),
            'UG107' => __('Mubende', 'digits'),
            'UG108' => __('Mukono', 'digits'),
            'UG334' => __('Nabilatuk', 'digits'),
            'UG311' => __('Nakapiripirit', 'digits'),
            'UG116' => __('Nakaseke', 'digits'),
            'UG109' => __('Nakasongola', 'digits'),
            'UG230' => __('Namayingo', 'digits'),
            'UG234' => __('Namisindwa', 'digits'),
            'UG224' => __('Namutumba', 'digits'),
            'UG327' => __('Napak', 'digits'),
            'UG310' => __('Nebbi', 'digits'),
            'UG231' => __('Ngora', 'digits'),
            'UG424' => __('Ntoroko', 'digits'),
            'UG411' => __('Ntungamo', 'digits'),
            'UG328' => __('Nwoya', 'digits'),
            'UG331' => __('Omoro', 'digits'),
            'UG329' => __('Otuke', 'digits'),
            'UG321' => __('Oyam', 'digits'),
            'UG312' => __('Pader', 'digits'),
            'UG332' => __('Pakwach', 'digits'),
            'UG210' => __('Pallisa', 'digits'),
            'UG110' => __('Rakai', 'digits'),
            'UG429' => __('Rubanda', 'digits'),
            'UG425' => __('Rubirizi', 'digits'),
            'UG431' => __('Rukiga', 'digits'),
            'UG412' => __('Rukungiri', 'digits'),
            'UG111' => __('Sembabule', 'digits'),
            'UG232' => __('Serere', 'digits'),
            'UG426' => __('Sheema', 'digits'),
            'UG215' => __('Sironko', 'digits'),
            'UG211' => __('Soroti', 'digits'),
            'UG212' => __('Tororo', 'digits'),
            'UG113' => __('Wakiso', 'digits'),
            'UG313' => __('Yumbe', 'digits'),
            'UG330' => __('Zombo', 'digits'),
        ),
        'UM' => array(
            '81' => __('Baker Island', 'digits'),
            '84' => __('Howland Island', 'digits'),
            '86' => __('Jarvis Island', 'digits'),
            '67' => __('Johnston Atoll', 'digits'),
            '89' => __('Kingman Reef', 'digits'),
            '71' => __('Midway Atoll', 'digits'),
            '76' => __('Navassa Island', 'digits'),
            '95' => __('Palmyra Atoll', 'digits'),
            '79' => __('Wake Island', 'digits'),
        ),
        'US' => array( // U.S. states.
            'AL' => __('Alabama', 'digits'),
            'AK' => __('Alaska', 'digits'),
            'AZ' => __('Arizona', 'digits'),
            'AR' => __('Arkansas', 'digits'),
            'CA' => __('California', 'digits'),
            'CO' => __('Colorado', 'digits'),
            'CT' => __('Connecticut', 'digits'),
            'DE' => __('Delaware', 'digits'),
            'DC' => __('District Of Columbia', 'digits'),
            'FL' => __('Florida', 'digits'),
            'GA' => _x('Georgia', 'US state of Georgia', 'digits'),
            'HI' => __('Hawaii', 'digits'),
            'ID' => __('Idaho', 'digits'),
            'IL' => __('Illinois', 'digits'),
            'IN' => __('Indiana', 'digits'),
            'IA' => __('Iowa', 'digits'),
            'KS' => __('Kansas', 'digits'),
            'KY' => __('Kentucky', 'digits'),
            'LA' => __('Louisiana', 'digits'),
            'ME' => __('Maine', 'digits'),
            'MD' => __('Maryland', 'digits'),
            'MA' => __('Massachusetts', 'digits'),
            'MI' => __('Michigan', 'digits'),
            'MN' => __('Minnesota', 'digits'),
            'MS' => __('Mississippi', 'digits'),
            'MO' => __('Missouri', 'digits'),
            'MT' => __('Montana', 'digits'),
            'NE' => __('Nebraska', 'digits'),
            'NV' => __('Nevada', 'digits'),
            'NH' => __('New Hampshire', 'digits'),
            'NJ' => __('New Jersey', 'digits'),
            'NM' => __('New Mexico', 'digits'),
            'NY' => __('New York', 'digits'),
            'NC' => __('North Carolina', 'digits'),
            'ND' => __('North Dakota', 'digits'),
            'OH' => __('Ohio', 'digits'),
            'OK' => __('Oklahoma', 'digits'),
            'OR' => __('Oregon', 'digits'),
            'PA' => __('Pennsylvania', 'digits'),
            'RI' => __('Rhode Island', 'digits'),
            'SC' => __('South Carolina', 'digits'),
            'SD' => __('South Dakota', 'digits'),
            'TN' => __('Tennessee', 'digits'),
            'TX' => __('Texas', 'digits'),
            'UT' => __('Utah', 'digits'),
            'VT' => __('Vermont', 'digits'),
            'VA' => __('Virginia', 'digits'),
            'WA' => __('Washington', 'digits'),
            'WV' => __('West Virginia', 'digits'),
            'WI' => __('Wisconsin', 'digits'),
            'WY' => __('Wyoming', 'digits'),
            'AA' => __('Armed Forces (AA)', 'digits'),
            'AE' => __('Armed Forces (AE)', 'digits'),
            'AP' => __('Armed Forces (AP)', 'digits'),
        ),
        'UY' => array( // Uruguayan states.
            'UY-AR' => __('Artigas', 'digits'),
            'UY-CA' => __('Canelones', 'digits'),
            'UY-CL' => __('Cerro Largo', 'digits'),
            'UY-CO' => __('Colonia', 'digits'),
            'UY-DU' => __('Durazno', 'digits'),
            'UY-FS' => __('Flores', 'digits'),
            'UY-FD' => __('Florida', 'digits'),
            'UY-LA' => __('Lavalleja', 'digits'),
            'UY-MA' => __('Maldonado', 'digits'),
            'UY-MO' => __('Montevideo', 'digits'),
            'UY-PA' => __('Paysandú', 'digits'),
            'UY-RN' => __('Río Negro', 'digits'),
            'UY-RV' => __('Rivera', 'digits'),
            'UY-RO' => __('Rocha', 'digits'),
            'UY-SA' => __('Salto', 'digits'),
            'UY-SJ' => __('San José', 'digits'),
            'UY-SO' => __('Soriano', 'digits'),
            'UY-TA' => __('Tacuarembó', 'digits'),
            'UY-TT' => __('Treinta y Tres', 'digits'),
        ),
        'VE' => array( // Venezuelan states.
            'VE-A' => __('Capital', 'digits'),
            'VE-B' => __('Anzoátegui', 'digits'),
            'VE-C' => __('Apure', 'digits'),
            'VE-D' => __('Aragua', 'digits'),
            'VE-E' => __('Barinas', 'digits'),
            'VE-F' => __('Bolívar', 'digits'),
            'VE-G' => __('Carabobo', 'digits'),
            'VE-H' => __('Cojedes', 'digits'),
            'VE-I' => __('Falcón', 'digits'),
            'VE-J' => __('Guárico', 'digits'),
            'VE-K' => __('Lara', 'digits'),
            'VE-L' => __('Mérida', 'digits'),
            'VE-M' => __('Miranda', 'digits'),
            'VE-N' => __('Monagas', 'digits'),
            'VE-O' => __('Nueva Esparta', 'digits'),
            'VE-P' => __('Portuguesa', 'digits'),
            'VE-R' => __('Sucre', 'digits'),
            'VE-S' => __('Táchira', 'digits'),
            'VE-T' => __('Trujillo', 'digits'),
            'VE-U' => __('Yaracuy', 'digits'),
            'VE-V' => __('Zulia', 'digits'),
            'VE-W' => __('Federal Dependencies', 'digits'),
            'VE-X' => __('La Guaira (Vargas)', 'digits'),
            'VE-Y' => __('Delta Amacuro', 'digits'),
            'VE-Z' => __('Amazonas', 'digits'),
        ),
        'VN' => array(),
        'YT' => array(),
        'ZA' => array( // South African states.
            'EC' => __('Eastern Cape', 'digits'),
            'FS' => __('Free State', 'digits'),
            'GP' => __('Gauteng', 'digits'),
            'KZN' => __('KwaZulu-Natal', 'digits'),
            'LP' => __('Limpopo', 'digits'),
            'MP' => __('Mpumalanga', 'digits'),
            'NC' => __('Northern Cape', 'digits'),
            'NW' => __('North West', 'digits'),
            'WC' => __('Western Cape', 'digits'),
        ),
        'ZM' => array( // Zambian provinces.
            'ZM-01' => __('Western', 'digits'),
            'ZM-02' => __('Central', 'digits'),
            'ZM-03' => __('Eastern', 'digits'),
            'ZM-04' => __('Luapula', 'digits'),
            'ZM-05' => __('Northern', 'digits'),
            'ZM-06' => __('North-Western', 'digits'),
            'ZM-07' => __('Southern', 'digits'),
            'ZM-08' => __('Copperbelt', 'digits'),
            'ZM-09' => __('Lusaka', 'digits'),
            'ZM-10' => __('Muchinga', 'digits'),
        ),
    );

}