<?php

namespace statsfa;

use zaya\Core\Request;
use zaya\Setup\Enqueue;
use zaya\Setup\AdminBar;
use zaya\Setup\AdminPage;
use zaya\Setup\Metaboxes;
use zaya\Services\Config\Config;
use zaya\Custom\Columns\ShortLinkColumn;
use zaya\Custom\Shortcodes\ShortLinkShortcode;

class App
{
    private static $loaded = false;

    public function __construct()
    {
        $this->initClasses();
    }

    public function initClasses()
    {
        if (static::$loaded) {
            return;
        }
        static::$loaded = true;

        add_action('wp_enqueue_scripts', [
            &$this,
            'front_enqueue',
        ]);

        add_filter('script_loader_tag', [
            &$this,
            'add_attributes',
        ], 10, 3);
    }

    public function front_enqueue()
    {
        wp_enqueue_script('statsfa-js', 'https://statsfa.com/js/script.js', [], null, true);
    }

    public function add_attributes($tag, $handle, $src)
    {
        if ('statsfa-js' === $handle) {
            $attr = 'data-host="https://statsfa.com" data-dnt="false" id="ZwSg9rf6GA" async defer';
            $tag = str_replace('src=', $attr . ' src=', $tag);
        }

        return $tag;
    }
}