<?php  if ( !defined( 'ABSPATH' ) ) exit(); ?>
<?php include('jdf.php'); ?>
<?php
function shdate() {
    echo jdate('Y/m/d');
}
?>
<div class="vendor_wrap"> 
	<?php echo el_get_template( '/vendor/manage_event_sidebar.php' ); ?>

	<div class="contents">
		<?php
			
			$id_event 	= isset($_GET['eid']) ? sanitize_text_field($_GET['eid']) : "";
			$qrcode 	= isset($_GET['qrcode']) ? sanitize_text_field($_GET['qrcode']) : "";

			//Check capacity of user
			if ( ! el_can_manage_ticket() || ! verify_current_user_post( $id_event ) || empty( $id_event ) ) {
				esc_html_e( 'You don\'t have permission view tickets', 'eventlist' );
				exit();
			}

			echo el_get_template( '/vendor/heading.php' );

			echo el_get_template( '/vendor/__event_info.php' );

		
			$slug_event = get_post_field( 'post_name', $id_event);
			$paged 		= get_query_var('paged') ? get_query_var('paged') : 1;

			$check_allow_get_list_tickets = check_allow_get_list_tickets_by_event($id_event);
			$check_allow_export_tickets = check_allow_export_tickets_by_event($id_event);

		 	if ( $check_allow_get_list_tickets =='yes' ) :

		 		$agrs_basic = $agrs_qrcode = array();
			
				$agrs_basic = [
					'post_type' => 'el_tickets',
					'post_status' => 'publish',
					"meta_query" => [
						'relation' => 'AND',
						[
							"key" => OVA_METABOX_EVENT . 'event_id',
							"value" => $id_event,
						],
					],
					'paged'          => $paged,
				];

				if( $qrcode ){
					$agrs_qrcode = [
						"meta_query" => [

							[
								"key" => OVA_METABOX_EVENT . 'qr_code',
								"value" => $qrcode,
								'compare' => 'LIKE'
							],
						],
						
					];
				}

				$agrs = array_merge_recursive( $agrs_basic, $agrs_qrcode );

				$list_ticket_record_by_id_event = new WP_Query( $agrs );

				$list_ckf_output = get_option( 'ova_booking_form', array() );
				?>
				<div class="table-list-ticket">
					
					<?php $current_link = add_query_arg( array(
								'vendor' => 'manage_event',
								'tab' => 'tickets',
								'eid' => $id_event,
							), get_myaccount_page() );
					?>

					<form class="search_ticket" action="<?php echo esc_url( $current_link ); ?>" method="GET">
						
						<input type="text" value="<?php echo $qrcode; ?>" placeholder="<?php esc_html_e( 'Enter some characters in QR Code', 'eventlist' ); ?>" name="qrcode" style="width: 350px;" />
						
						<input type="hidden" name="vendor" value="manage_event" >
						<input type="hidden" name="tab" value="tickets" >
						<input type="hidden" name="eid" value="<?php echo $id_event; ?>" >
						<button type="submit" class="search_ticket_btn button">
							<?php esc_html_e( 'Find Ticket', 'eventlist' ); ?>
						</button>
						
					</form>

					

					<?php if ($check_allow_export_tickets == 'yes') : ?>
						<div class="el-export-csv">
							<a href="#" id="export-csv-extra-ticket"><?php esc_html_e("Choose fields to export", "eventlist"); ?></a>
							<div class="list-check-export-csv">
								<ul>
									<li>
										<input name="event" value="event" type="checkbox" id="id-event" checked="checked">
										<label for="id-event"><?php esc_html_e("Event", "eventlist"); ?></label>
									</li>
									<li>
										<input name="ticket_type" value="ticket_type" type="checkbox" id="ticket_type" checked="checked">
										<label for="ticket_type"><?php esc_html_e("Ticket Type", "eventlist"); ?></label>
									</li>
									<li>
										<input name="name" value="name" type="checkbox" id="name-customer" checked="checked">
										<label for="name-customer"><?php esc_html_e("Name Customer", "eventlist"); ?></label>
									</li>
									<li>
										<input name="phone_customer" value="phone_customer" type="checkbox" id="phone-customer" checked="checked">
										<label for="phone-customer"><?php esc_html_e("Phone Customer", "eventlist"); ?></label>
									</li>
									<li>
										<input name="email_customer" value="email_customer" type="checkbox" id="email-customer" checked="checked">
										<label for="email-customer"><?php esc_html_e("Email Customer", "eventlist"); ?></label>
									</li>
									<li>
										<input name="address_customer" value="address_customer" type="checkbox" id="address-customer" checked="checked">
										<label for="address-customer"><?php esc_html_e("Address Customer", "eventlist"); ?></label>
									</li>
									<li>
										<input name="venue" value="venue" type="checkbox" id="venue" checked="checked">
										<label for="venue"><?php esc_html_e("Venue", "eventlist"); ?></label>
									</li>

									<li>
										<input name="address" value="address" type="checkbox" id="address" checked="checked">
										<label for="address"><?php esc_html_e("Address", "eventlist"); ?></label>
									</li>

									<li>
										<input name="seat" value="seat" type="checkbox" id="seat" checked="checked">
										<label for="seat"><?php esc_html_e("Seat", "eventlist"); ?></label>
									</li>
									<li>
										<input name="qr_code" value="qr_code" type="checkbox" id="qr_code" checked="checked">
										<label for="qr_code"><?php esc_html_e("Qr code", "eventlist"); ?></label>
									</li>

									<li>
										<input name="start_date" value="start_date" type="checkbox" id="start_date" checked="checked">
										<label for="start_date"><?php esc_html_e("Start Date", "eventlist"); ?></label>
									</li>

									<li>
										<input name="end_date" value="end_date" type="checkbox" id="end_date" checked="checked">
										<label for="end_date"><?php esc_html_e("End Date", "eventlist"); ?></label>
									</li>

									<li>
										<input name="date_create" value="date_create" type="checkbox" id="date_create" checked="checked">
										<label for="date_create"><?php esc_html_e("Date created", "eventlist"); ?></label>
									</li>

									<li>
										<input name="checkin_time" value="checkin_time" type="checkbox" id="checkin_time" checked="checked">
										<label for="checkin_time"><?php esc_html_e("Checkin-Time", "eventlist"); ?></label>
									</li>

									<?php
										$list_name_ckf = [];
										if( ! empty( $list_ckf_output ) && is_array( $list_ckf_output ) ) {
											foreach( $list_ckf_output as $key_1 => $val ) {
												if( array_key_exists('enabled', $val) &&  $val['enabled'] == 'on' ) {
													$list_name_ckf[] = esc_html( $key_1 );
													?>
													<li>
														<input name="<?php echo esc_attr( $key_1 ) ?>"  value="<?php echo esc_attr( $key_1 ) ?>" type="checkbox" id="<?php echo esc_attr( $key_1 ) ?>" checked="checked">
														<label for="<?php echo esc_attr( $key_1 ) ?>"><?php echo esc_html( $val['label'] ) ?></label>
													</li>
													<?php
												}
												
											}
										}
									?>
									<li>
										<button type="submit" class="checked-field"><?php esc_html_e( 'Select All', 'eventlist' ); ?></button>
									</li>
									<li>
										<button type="submit" class="clean-field"><?php esc_html_e( 'Clean All', 'eventlist' ); ?></button>
									</li>
								</ul>
								<input type="hidden" name="id_event" value="<?php echo esc_attr( $id_event ); ?>">
								<input type="hidden" name="el_list_ckf" id="el_list_ckf" value="<?php echo esc_attr( json_encode( $list_name_ckf ) ); ?>" />

								<button id="button-submit-ticket-export-csv" data-slug-event="<?php echo esc_attr($slug_event); ?>" data-id-event="<?php echo esc_attr($id_event); ?>"  name="export" class="export-csv-extra"><i class="fas fa-file-download"></i><?php esc_html_e("Export CSV", "eventlist"); ?></button>
							</div>
						</div>
					<?php  endif; ?>
						<input type="text" id="myInput" onkeyup="myFunction()" placeholder="نام یا شماره موبایل را وارد کنید" title="Type in a name">
						
						<!--<p><button onclick="sortTable()">مرتب سازی بر اساس تاریخ</button></p>-->
						
							<style>
							div.sticky {position: -webkit-sticky;position: sticky;  top: 0;}
							.rtl .vendor_wrap table tbody.event_body tr td {font-size:30px!important;}
							.event-ckecktime{display: none;}
							@media print {
							  #print, tfoot, tbody tr:not(.printme), .vendor_sidebar, .elementor-location-header, 
							  .vendor_heading, .sticky, .event_info,.search_ticket, .event-create, .el-export-csv, 
							  #myInput, button#print, .event-select, .event_head, span.error, .update_ticket_status,
							  .event-start{
								display: none !important;
							  }
							  .event-ckecktime{display: inline-block;}
							  .contents{margin: 0!important;padding: 0!important;width:100%!important;}
							  .event-name, .event-customer, .event-seat{font-size:70px!important;font-weight:bold;}
							  .rtl .vendor_wrap table tbody.event_body tr {border-bottom:2px solid #000!important;}
							}

							</style>
						<div class="sticky"><button style="font-size:40px;padding:10px" class="button" id="print" type="button">چاپ</button></div>
					<div style="text-align:right;font-size:35px;border:2px dotted #000;display:inline-block;padding:10px;font-weight:bold;">سامانه خرید بلیط دستواتیکت</div>
					<table id="myTable">
						<thead class="event_head">
							<tr>
								<td><?php esc_html_e("Event", "eventlist"); ?></td>
								<td><?php esc_html_e("Customer", "eventlist"); ?></td>
								<td><?php esc_html_e("Seat", "eventlist"); ?></td>
								<td style="width: 120px"><?php esc_html_e("Qr code", "eventlist"); ?></td>
								<td><?php esc_html_e("Start date", "eventlist"); ?></td>
								<td><?php esc_html_e("Created", "eventlist"); ?></td>
								<td><?php esc_html_e( "Check-in", "eventlist" ); ?></td>
								<td></td>
							</tr>
						</thead>
						<tbody class="event_body">
							<?php 
							if ( $list_ticket_record_by_id_event->have_posts() ) : while ( $list_ticket_record_by_id_event->have_posts() ) : $list_ticket_record_by_id_event->the_post(); 
								$id_ticket_record = get_the_id();
								$qr_code = get_post_meta( $id_ticket_record, OVA_METABOX_EVENT . 'qr_code', true );
								?>
								<tr>
									<td class="event-name" data-colname="<?php esc_attr_e('Event', 'eventlist'); ?>">
										<?php echo esc_html(get_post_meta( $id_ticket_record, OVA_METABOX_EVENT . 'name_event', true )); ?>
									</td>

									<td class="event-customer" data-colname="<?php esc_attr_e('Customer', 'eventlist'); ?>">
										<?php echo esc_html(get_post_meta( $id_ticket_record, OVA_METABOX_EVENT . 'name_customer', true )); ?>
									</td>
									
									<td class="event-seat" data-colname="<?php esc_attr_e('Seat', 'eventlist'); ?>">
										<?php
										$seat = get_post_meta( $id_ticket_record, OVA_METABOX_EVENT . 'seat', true );
										$seat = $seat ? $seat : esc_html__("none", "eventlist");
										echo $seat;
										?>
									</td>

									<td class="event-qr" data-colname="<?php esc_attr_e('Qr code', 'eventlist'); ?>" class="qr_code" style="font-size: 1px!important;width: 120px; word-break: break-all;">
										<?php echo $qr_code; ?>
									</td>

									<td style="direction: ltr;text-align: left;" class="event-start" data-colname="<?php esc_attr_e('Start date', 'eventlist'); ?>">
										<?php
										$start_date = get_post_meta( $id_ticket_record, OVA_METABOX_EVENT . 'date_start', true );
										$date_format = get_option('date_format');
										$time_format = get_option('time_format');

										echo date($date_format, $start_date) . ' - ' . date($time_format, $start_date);
										?>
									</td>

									<td class="event-create" data-colname="<?php esc_attr_e('Created', 'eventlist'); ?>">
										<?php
										$date_format = get_option('date_format');
										$time_format = get_option('time_format');
										echo get_the_date($date_format, $id_ticket_record) . " - " . get_the_date($time_format, $id_ticket_record);
										?>
									</td>

									<td class="event-checkin" data-colname="<?php esc_attr_e('Check-in', 'eventlist'); ?>">
										<?php 
											$ticket_status = get_post_meta( $id_ticket_record, OVA_METABOX_EVENT.'ticket_status', true );
											$checkin_time_tmp = get_post_meta( $id_ticket_record, OVA_METABOX_EVENT.'checkin_time', true ) ;
											$checkin_time =  $checkin_time_tmp ? date_i18n( get_option( 'date_format' ).' '. get_option( 'time_format' ), $checkin_time_tmp ) : '';

											if( $ticket_status == 'checked' ){ ?>
													<span class="error">

														<?php echo esc_html__( 'Check-in', 'eventlist' ); ?>
														<span class="wrap_info" data-toggle="tooltip" data-placement="top" title="<?php echo esc_html__( 'Check-in at ', 'eventlist' ).' '.$checkin_time; ?>">
															<i class="icon_info_alt"></i>
														</span>
													</span>	
											<?php }else{ ?>
													<a href="#" class="update_ticket_status" data-qr_code="<?php echo $qr_code; ?>" title="<?php echo esc_html__( 'Update Ticket Status', 'eventlist' ); ?>">
														<i class="icon_check"></i>
													</a>
											<?php } ?>
										 <span class="event-ckecktime">
										     <?php echo shdate(); ?>
										     </span>
									</td>
									<td class="event-select"><input type="checkbox" id="checkprint" style="width:30px;height:30px;"></td>
								</tr>
							<?php endwhile; else : ?> 
							<td colspan="10"><?php esc_html_e( 'Not Found Tickets', 'eventlist' ); ?></td> 
							<?php ; endif; wp_reset_postdata(); ?>


						</tbody>
					</table>

						<script>
						function myFunction() {
						  var input, filter, table, tr, td, i, txtValue;
						  input = document.getElementById("myInput");
						  filter = input.value.toUpperCase();
						  table = document.getElementById("myTable");
						  tr = table.getElementsByTagName("tr");
						  for (i = 0; i < tr.length; i++) {
							td = tr[i].getElementsByTagName("td")[1];
							if (td) {
							  txtValue = td.textContent || td.innerText;
							  if (txtValue.toUpperCase().indexOf(filter) > -1) {
								tr[i].style.display = "";
							  } else {
								tr[i].style.display = "none";
							  }
							}       
						  }
						}
						</script>
						
						<script>
						function sortTable() {
						  var table, rows, switching, i, x, y, shouldSwitch;
						  table = document.getElementById("myTable");
						  switching = true;
						  /*Make a loop that will continue until
						  no switching has been done:*/
						  while (switching) {
							//start by saying: no switching is done:
							switching = false;
							rows = table.rows;
							/*Loop through all table rows (except the
							first, which contains table headers):*/
							for (i = 1; i < (rows.length - 1); i++) {
							  //start by saying there should be no switching:
							  shouldSwitch = false;
							  /*Get the two elements you want to compare,
							  one from current row and one from the next:*/
							  x = rows[i].getElementsByTagName("TD")[4];
							  y = rows[i + 1].getElementsByTagName("TD")[4];
							  //check if the two rows should switch place:
							  if (x.innerHTML.toLowerCase() > y.innerHTML.toLowerCase()) {
								//if so, mark as a switch and break the loop:
								shouldSwitch = true;
								break;
							  }
							}
							if (shouldSwitch) {
							  /*If a switch has been marked, make the switch
							  and mark that a switch has been done:*/
							  rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
							  switching = true;
							}
						  }
						}
						</script>
						
						<script>
						function matches(el, selector) {
						  // https://developer.mozilla.org/en-US/docs/Web/API/Element/matches
						  var matches = document.querySelectorAll(selector),
							i = matches.length;
						  while (--i >= 0 && matches.item(i) !== el) {}
						  return i > -1;
						}

						function closest(el, selector) {
						  while (el && !matches(el, selector)) {
							el = el.parentNode;
						  }
						  return matches(el, selector) ? el : null;
						}

						document.querySelector('table').addEventListener('change', function(event) {
						  var target = event.target;
						  closest(target, 'tr').classList[target.checked ? 'add' : 'remove']('printme');
						})

						document.querySelector("#print").addEventListener('click', function() {
						  window.print();
						});
						</script>

						
					<!-- Tickets -->

					<?php 
					$total = $list_ticket_record_by_id_event->max_num_pages;
					if ( $total > 1 ) {
						echo pagination_vendor($total);
					} ?>
				</div>

			<?php endif; ?>

	</div>
	
</div>