<?php if (!defined('ABSPATH')) exit;
/** */
if (!class_exists('EL_Abstract_Payment')) return;

class EL_Payment_Zarinpal extends EL_Abstract_Payment {

    public $id = 'zarinpal';

    function __construct() {
        $this->_title = 'درگاه زرین‌پال';

        add_action('wp_ajax_eventlist_zarinpal_verify', array($this, 'eventlist_zarinpal_verify'));
        add_action('wp_ajax_nopriv_eventlist_zarinpal_verify', array($this, 'eventlist_zarinpal_verify'));

        parent::__construct();
    }

    function fields() {
        return array(
            'title' => 'درگاه زرین‌پال',
            'fields' => array(
                'fields' => array(
                    array(
                        'type' => 'select',
                        'label' => __('فعال', 'eventlist'),
                        'desc' => __('You have to active to use this gateway', 'eventlist'),
                        'atts' => array(
                            'id' => 'zarinpal_active',
                            'class' => 'zarinpal_active'
                        ),
                        'name' => 'zarinpal_active',
                        'options' => array(
                            'no' => __('خیر', 'eventlist'),
                            'yes' => __('بله', 'eventlist')
                        )
                    ),
                    array(
                        'type' => 'input',
                        'label' => __('Merchant ID', 'eventlist'),
                        'desc' => __('Merchant ID درگاه زرین‌پال', 'eventlist'),
                        'name' => 'zarinpal_merchant_id',
                    ),
                ),
            ),
        );
    }

    function render_form() {
        return 'Payment via Zarinpal';
    }

    function process() {
        $booking_id = EL()->cart_session->get('booking_id');
        $total = get_post_meta($booking_id, OVA_METABOX_EVENT . 'total', true);
        $red = admin_url('admin-ajax.php?action=eventlist_zarinpal_verify&booking_id=' . $booking_id . '&shf_key=' . session_id());

        $data = array(
            'merchant_id' => EL()->options->checkout->get('zarinpal_merchant_id'),
            'amount' => $total,
            'callback_url' => $red,
            'description' => 'خرید',
            'metadata' => array(
                'email' => 'info@email.com',
                'mobile' => '09121234567'
            )
        );

        $jsonData = json_encode($data);

        $ch = curl_init('https://api.zarinpal.com/pg/v4/payment/request.json');
        curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v1');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonData),
            'X-Zarinpal-Sandbox: true' // for test mode
        ));

        $result = curl_exec($ch);
        $err = curl_error($ch);

        $result = json_decode($result, true, JSON_PRETTY_PRINT);
        curl_close($ch);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            if (empty($result)) {
                if ($result == 100) {
                    header('Location: https://www.zarinpal.com/pg/StartPay/' . $result);
                }
            } else {
                echo 'Error Code: ' . $result . '<br/>' . 'Error Message: ' . $result;
            }
        }
    }

    function eventlist_zarinpal_verify() {
        $booking_id = isset($_GET) ? $_GET : 0;
        $total = get_post_meta($booking_id, OVA_METABOX_EVENT . 'total', true);

        if (!isset($_SESSION)) {
            session_destroy();
            session_id($_GET);
            session_start();
        }

        if (!$booking_id) {
            wp_redirect(get_cart_page());
            exit;
        }

        if (!$total) {
            wp_redirect(get_cart_page());
            exit;
        }

        $Authority = $_GET;
        if ($_GET == 'OK') {
            $MerchantID = EL()->options->checkout->get('zarinpal_merchant_id');
            $Amount = $total;
            $data = array('merchant_id' => $MerchantID, 'authority' => $Authority, 'amount' => $Amount); // فراخوانی API درگاه

            $jsonData = json_encode($data);

            $ch = curl_init('https://api.zarinpal.com/pg/v4/payment/verify.json');
            curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v1');
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Content-Length: ' . strlen($jsonData),
                'X-Zarinpal-Sandbox: true' // for test mode
            ));

            $result = json_decode(curl_exec($ch), true, JSON_PRETTY_PRINT);

            if ($result == 100) {
                EL_Booking::instance()->booking_success($booking_id, $this->_title);
                wp_redirect(get_thanks_page());
            } else {
                echo 'Error Code: ' . $result['errors>' . 'Error Message: '. $result;
            }

            curl_close($ch);
        } else {
            wp_redirect(get_cart_page());
            exit;
        }
    }
}

add_filter('el_payment_gateways_avaiable', function ($methods) {
    $methods = 'EL_Payment_Zarinpal';
    return $methods;
}, 666);
?>
