<?php if (!defined('ABSPATH')) exit;
/**
 * Plugin Name: افزونه ها - سامانه رزرواسیون بلیت رویداد
 * Description:<strong>جامع ترین بستر مدیریت و فروش بلیت کنسرت، سینما، تئاتر  در ایران</strong> 
 * Plugin URI: https://www.rtl-theme.com/author/mardane/products/
 * Author: <strong>افزونه ها</strong>
 * Version: 5.0.0
 * Author URI: https://www.rtl-theme.com/author/mardane/products/
*/
if (!class_exists('EL_Abstract_Payment')) return;
class EL_Payment_Mellat extends EL_Abstract_Payment {
	public $id = 'mellat';
	function __construct() {
		$this->_title = 'درگاه ملت';
		add_action('wp_ajax_eventlist_mellat_verify', array($this, 'eventlist_mellat_verify'));
		add_action('wp_ajax_nopriv_eventlist_mellat_verify', array($this, 'eventlist_mellat_verify'));
		parent::__construct();
	}

	function fields() {
		return array(
			'title' => 'درگاه ملت',
			'fields' => array(
				'fields' => array(
					array(
						'type' => 'select',
						'label' => __( 'فعال', 'eventlist' ),
						'desc' => __( 'You have to active to use this gateway', 'eventlist' ),
						'atts' => array(
							'id' => 'mellat_active',
							'class' => 'mellat_active'
						),
						'name' => 'mellat_active',
						'options' => array(
							'no' => __( 'خیر', 'eventlist' ),
							'yes' => __( 'بله', 'eventlist' )
						)
					),
					array(
						'type' => 'input',
						'label' => __( 'شماره ترمینال', 'eventlist' ),
						'desc' => __( 'شماره ترمینال درگاه ملت', 'eventlist' ),
						'name' => 'mellat_tid',
					),
					array(
						'type' => 'input',
						'label' => __( 'نام کاربری ترمینال', 'eventlist' ),
						'desc' => __( 'نام کاربری ترمینال ملت', 'eventlist' ),
						'name' => 'mellat_tun',
					),
					array(
						'type' => 'input',
						'label' => __( 'پسورد ترمینال', 'eventlist' ),
						'desc' => __( 'رمز عبور ترمینال ملت', 'eventlist' ),
						'name' => 'mellat_tpw',
					),
				),
			)
		);
	}

	function render_form() {
		return 'Payment via Mellat';
	}

	function process() {
		$booking_id = EL()->cart_session->get( 'booking_id' );
		$total = get_post_meta( $booking_id, OVA_METABOX_EVENT.'total', true ) * 10;
		$total = get_post_meta( $booking_id, OVA_METABOX_EVENT.'total_after_tax', true ) * 10;
		$red = admin_url('admin-ajax.php?action=eventlist_mellat_verify&booking_id='.$booking_id.'&shf_key='.session_id());
		ini_set("soap.wsdl_cache_enabled", "0");
		$client = new SoapClient('https://bpm.shaparak.ir/pgwchannel/services/pgw?wsdl');
		$result = $client->bpPayRequest($parameters = array(
				'terminalId'     => EL()->options->checkout->get('mellat_tid'),
				'userName'       => EL()->options->checkout->get('mellat_tun'),
				'userPassword'   => EL()->options->checkout->get('mellat_tpw'),
				'orderId'        => time(),
				'amount'         => $total,
				'localDate'      => date("Ymd"),
				'localTime'      => date("His"),
				'additionalData' => 'سامانه پرداخت الکترونیکی بانک ملت توسعه داده شده توسط :: https://Afzoneha.com/',
				'callBackUrl'    => $red,
				'payerId'        => '0'
			))->return;
		if ($result[0] == '0') {
			$_SESSION['eventlist_mellat_form'] = true;
			return array(
				'status' => 'success',
				'url' => 'https://bpm.shaparak.ir/pgwchannel/startpay.mellat?RefId=' . substr($result,2)
			);
		} else {
			echo json_encode(array('el_message' => 'Mellat Payment Error : ' . $result));
			wp_die();
		}
	}
	function eventlist_mellat_verify() {
		$booking_id = isset($_GET['booking_id']) ? $_GET['booking_id'] : 0;
		$total = get_post_meta( $booking_id, OVA_METABOX_EVENT.'total', true ) * 10;
		$total = get_post_meta( $booking_id, OVA_METABOX_EVENT.'total_after_tax', true ) * 10;
		if (!isset($_SESSION['eventlist_mellat_form'])) {
			session_destroy();
			session_id($_GET['shf_key']);
			session_start();
		}
		if (!$booking_id) {
			wp_redirect(get_cart_page());
			exit;
		}
		if (!$total) {
			wp_redirect(get_cart_page());
			exit;
		}
		if (isset($_POST['ResCode']) && $_POST['ResCode'] == '0') {
			ini_set("soap.wsdl_cache_enabled", "0");
			$client = new SoapClient('https://bpm.shaparak.ir/pgwchannel/services/pgw?wsdl');
			$result = $client->bpVerifyRequest($parameters = array(
					'terminalId'      => EL()->options->checkout->get('mellat_tid'),
					'userName'        => EL()->options->checkout->get('mellat_tun'),
					'userPassword'    => EL()->options->checkout->get('mellat_tpw'),
					'orderId'         => $_POST['SaleOrderId'],
					'saleOrderId'     => $_POST['SaleOrderId'],
					'saleReferenceId' => $_POST['SaleReferenceId']
				))->return;
			if ($result == '0') {
				$result = $client->bpSettleRequest($parameters)->return;
				if ($result == '0') {
					EL_Booking::instance()->booking_success( $booking_id, $this->_title );
					wp_redirect(get_thanks_page());
				} else {
					echo 'Mellat Error : ' . $result;
					exit;
				}
			} else {
				echo 'Mellat Error : ' . $result;
				exit;
			}
		} else {
			wp_redirect(get_cart_page());
			exit;
		}
	}
}

add_filter('el_payment_gateways_avaiable', function($methods) {
	$methods[] = 'EL_Payment_Mellat';
	return $methods;
}, 666);

?>