<?php 

defined( 'ABSPATH' ) || exit();

if( !class_exists( 'El_Admin_Ajax' ) ){

	class El_Admin_Ajax{
		
		public function __construct(){
			$this->init();
		}

		public function init(){

			// Define All Ajax function
			$arr_ajax =  array(
				'mb_add_social',
				'mb_add_ticket',
				'add_seat_map',
				'add_desc_seat_map',
				'mb_add_calendar',
				'mb_add_disable_date',
				'mb_add_disable_time_slot',
				'mb_add_schedules_time',
				'mb_add_coupon',
				'el_load_venue',
				'el_load_checklist_venue',
				'create_ticket_send_mail',
				'create_invoice',
				'send_invoice',
				'download_ticket',
				'unlink_download_ticket',
				'update_status_proccess',
				'add_custom_booking',
				'el_get_idcal_seatopt',
				'el_check_book_before_minutes',
				'el_check_schedules_time_book',
				'el_check_calendar_recurrence_time_book',
				'el_replace_get_tickets',
				'el_replace_ticket_date',
				'el_replace_ticket_date_posts_per_page',
				'el_replace_ticket_date_pagination',
				'el_replace_ticket_date_export_email',
				'el_replace_ticket_date_send_email',
			);

			foreach($arr_ajax as $val){
				add_action( 'wp_ajax_'.$val, array( $this, $val ) );
				add_action( 'wp_ajax_nopriv_'.$val, array( $this, $val ) );
			}
		}

	

		public function update_status_proccess() {
			$id_event = isset($_POST['id_event']) ? sanitize_text_field($_POST['id_event']) : '';
			$status = isset($_POST['status']) ? sanitize_text_field($_POST['status']) : '';

			if (empty($id_event) || empty($status) ) wp_die();

			if ($status == 'paid') {
				$status = 'paid';
			} else {
				$status = 'pending';
			}

			$time_current = current_time('timestamp');
			if (current_user_can('administrator')) {
				update_post_meta($id_event, OVA_METABOX_EVENT . 'status_pay', $status);
				update_post_meta($id_event, OVA_METABOX_EVENT . 'date_update', $time_current);
			}

			echo "success";
			
			wp_die();
		}

		public function create_invoice() {
			$booking_id 	= isset( $_POST['booking_id'] ) ? sanitize_text_field( $_POST['booking_id'] ) : '';
			$invoices_nonce = isset( $_POST['invoice_nonce'] ) ? sanitize_text_field( $_POST['invoice_nonce'] ) : '';

			if ( ! $booking_id || ! $invoices_nonce || ! wp_verify_nonce( $invoices_nonce , 'el_create_invoice_nonce' ) ) wp_die();

			$data = [
				'pdf_url' 	=> '',
				'error' 	=> '',
			];

			$pdf_url = EL_Booking::instance()->el_make_pdf_invoice_by_booking_id( $booking_id );

			$invoices_dir = trailingslashit( wp_upload_dir()['baseurl'] ) . 'invoices';

			if ( $pdf_url ) {
				$position 	= strrpos( $pdf_url, '/');
				$name 		= substr( $pdf_url, $position);
				$pdf_url 	= $invoices_dir . $name;

				$data['pdf_url'] = $pdf_url;
			} else {
				$data['error'] = esc_html__( 'Make PDF invoice failed.','eventlist' );
			}

			echo json_encode( $data );

			wp_die();
		}

		public function send_invoice() {
			$booking_id 	= isset( $_POST['booking_id'] ) ? sanitize_text_field( $_POST['booking_id'] ) : '';
			$invoices_nonce = isset( $_POST['invoice_nonce'] ) ? sanitize_text_field( $_POST['invoice_nonce'] ) : '';

			if ( ! $booking_id || ! $invoices_nonce || ! wp_verify_nonce( $invoices_nonce , 'el_send_invoice_nonce' ) ) wp_die();

			$data = [
				'message' 	=> '',
				'error' 	=> '',
			];

			$pdf_url = EL_Booking::instance()->el_make_pdf_invoice_by_booking_id( $booking_id );

			if ( $pdf_url ) {
				$result = el_sendmail_pdf_invoice( $booking_id, $pdf_url );

				if ( $result ) {
					$data['message'] = esc_html__( 'Send PDF invoice success.','eventlist' );
				} else {
					$data['error'] = esc_html__( 'Send PDF invoice failed.','eventlist' );
				}
			} else {
				$data['error'] = esc_html__( 'Create PDF invoice failed.','eventlist' );
			}

			echo json_encode( $data );

			wp_die();
		}

		public function download_ticket() {

			$id_booking = isset($_POST['id_booking']) ? sanitize_text_field($_POST['id_booking']) : "";

			$data = [];

			$status = get_post_meta($id_booking, OVA_METABOX_EVENT . "status", true);
			if ($status !== "Completed") {
				$data['status'] = 'error';
				$data['message'] = __("Please update booking status to Complete to send mail", "eventlist"); 
				echo json_encode($data);
				wp_die();
			}

			$arr_upload = wp_upload_dir();
			$base_url_upload = $arr_upload['baseurl'];

			if( empty($id_booking) || !isset( $_POST['el_download_ticket_nonce'] ) || !wp_verify_nonce( sanitize_text_field($_POST['el_download_ticket_nonce']), 'el_download_ticket_nonce' ) ) wp_die() ;

			$list_ticket_pdf_png = EL_Ticket::instance()->make_pdf_ticket_by_booking_id( $id_booking );

			$list_url_ticket = [];
			if (is_array($list_ticket_pdf_png) && !empty($list_ticket_pdf_png)) {
				foreach($list_ticket_pdf_png as $ticket_pdf) {
					$position = strrpos($ticket_pdf, '/');
					$name = substr($ticket_pdf, $position);
					$list_url_ticket[] = $base_url_upload . $name;
				}
			}
			
			$data['status'] = 'success';
			$data['list_url_ticket'] = $list_url_ticket;

			echo json_encode($data);

			wp_die();
		}


		public function unlink_download_ticket() {
			$data = $_POST['data_url'];
			$arr_upload = wp_upload_dir();
			$basedir = $arr_upload['basedir'];

			$list_uri_ticket = [];
			if (is_array($data) && !empty($data)) {
				foreach($data as $ticket_pdf) {
					$position = strrpos($ticket_pdf, '/');
					$name = substr($ticket_pdf, $position);
					$list_uri_ticket[] = $basedir . $name;
				}
			}

			if (empty($list_uri_ticket) || !is_array($list_uri_ticket)) wp_die();
			$total_ticket_pdf = count($list_uri_ticket);
			if (!empty($list_uri_ticket) && is_array($list_uri_ticket)) {
				foreach ($list_uri_ticket as $key => $value) {
					if( $key < $total_ticket_pdf ){
						if (file_exists($value)) unlink($value);
					} 
				}
			}
			wp_die();
		}


		public function create_ticket_send_mail() {
			
			$id_booking = isset($_POST['id_booking']) ? sanitize_text_field($_POST['id_booking']) : "";

			if( empty($id_booking) || !isset( $_POST['el_create_send_ticket_nonce'] ) || !wp_verify_nonce( sanitize_text_field($_POST['el_create_send_ticket_nonce']), 'el_create_send_ticket_nonce' ) ) wp_die() ;

			$data = [];
			$status = get_post_meta($id_booking, OVA_METABOX_EVENT . "status", true);
			if ($status !== "Completed") {
				$data['status'] = 'error';
				$data['message'] = __("Please update booking status to Complete to send mail", "eventlist"); 
				echo json_encode($data);
				wp_die();
			}

			$list_id_ticket_by_booking = get_post_meta($id_booking, OVA_METABOX_EVENT . "list_id_ticket", true);
			
			$list_id_ticket_by_booking = json_decode($list_id_ticket_by_booking);
			$number_ticket_in_booking = count($list_id_ticket_by_booking);

			$args = [
				'post_type' => 'el_tickets',
				'post_status' => 'publish',
				'meta_query' => [
					[
						'key' => OVA_METABOX_EVENT . 'booking_id',
						'value' => $id_booking,
					],
				],
				'posts_per_page' => -1, 
				'numberposts' => -1,
				'nopaging' => true,
			];

			$ticket_record = get_posts($args);
			$number_ticket_record = count($ticket_record);
			$list_id_ticket = [];

			if ($number_ticket_record == 0 && $number_ticket_in_booking > 0) {
				$data['message'] = __("Add Ticket and send mail success", "eventlist");
				$list_id_ticket = EL_Ticket::instance()->add_ticket($id_booking);
				
			} else {
				$data['message'] = __("Send mail success", "eventlist");
			}

			// Update profit & commission
			$profit 	= EL_Booking::instance()->get_profit_by_id_booking( $id_booking );
			$commission = EL_Booking::instance()->get_commission_by_id_booking( $id_booking );
			
			update_post_meta( $id_booking, OVA_METABOX_EVENT.'profit', $profit );
			update_post_meta( $id_booking, OVA_METABOX_EVENT.'commission', $commission );
			update_post_meta( $id_booking, OVA_METABOX_EVENT.'profit_status', '' );

			if ( $list_id_ticket ) {
				update_post_meta( $id_booking, OVA_METABOX_EVENT.'record_ticket_ids', $list_id_ticket );
			}

			$result = el_sendmail_by_booking_id($id_booking, $order_status="", $receiver='customer');

			if ($result) {
				$data['status'] = "success";
			} else {
				$data['status'] = "error";
				$data['message'] = __("Send mail failed", "eventlist");
			}
			
			echo json_encode($data);
			wp_die();
		}


		/* Load Venue */
		public static function el_load_venue() {
			$keyword = isset($_POST['keyword']) ? sanitize_text_field( $_POST['keyword'] ) : '';

			$the_query = new WP_Query( array( 'post_type' => 'venue' , 's' => $keyword, 'posts_per_page'=> '10') );
			?>

			<?php

			if( $the_query->have_posts() ) :
				while( $the_query->have_posts() ): $the_query->the_post();

					$title[] = get_the_title();

				endwhile;
				wp_reset_postdata();  
			endif;

			echo json_encode($title);

			wp_die();
		}


		/* Load checklist Venue */
		public static function el_load_checklist_venue() {
			$add_venue = isset( $_POST['add_venue'] ) ? sanitize_text_field( $_POST['add_venue'] ) : '';
			$list_venue = isset( $_POST['list_venue'] ) ? sanitize_text_field( $_POST['list_venue'] ) : '';

			$list_venue = substr($list_venue, 0, -1);

			$add_venue = array_map('ucwords', explode(', ', $add_venue));
			$list_venue = array_map('ucwords', explode(', ', $list_venue));

			foreach($add_venue as $key => $value) {
				$add_venue[$key] = str_replace(',', '', $value);
			}

			$result = array_unique(array_merge($add_venue, $list_venue));

			$_prefix = OVA_METABOX_EVENT;
			
			// remove empty array elements
			foreach($result as $key => $value) {
				if(empty($value)) {
					unset($result[$key]);
				}
			}

			foreach ($result as $key => $value) {
				
				?>
				<li>
					<input type="hidden" name="<?php echo esc_attr($_prefix.'venue['.$key.']'); ?>" value="<?php echo esc_attr($value); ?>">
					<i class="dashicons dashicons-dismiss remove_venue"></i>
					<span><?php echo esc_html($value); ?></span>
				</li>
				<?php
			}

			wp_die();
		}


		/* Add Social */
		public static function mb_add_social(){
			if( !isset( $_POST['data'] ) ) wp_die();
			$post_data = $_POST['data'];
			$index = isset( $post_data['index'] ) ? sanitize_text_field( $post_data['index'] ) : '';
			$_prefix = OVA_METABOX_EVENT;
			?>
			<div class="social_item">
				<input type="text" name="<?php echo esc_attr($_prefix.'social_organizer['.$index.'][link_social]'); ?>" class="link_social" value="" placeholder="<?php echo esc_attr( 'https://' ); ?>" autocomplete="off" autocorrect="off" autocapitalize="none" />
				<select name="<?php echo esc_attr($_prefix.'social_organizer['.$index.'][icon_social]'); ?>" class="icon_social">
					<?php foreach (el_get_social() as $key => $value) { ?>
						<option value="<?php echo esc_attr($key); ?>"><?php echo esc_html( $value ); ?></option>
					<?php } ?>
				</select>
				<a href="#" class="button remove_social"><?php esc_html_e( 'x', 'eventlist' ); ?></a>
			</div>

			<?php
			wp_die();
		}


		/* Add Ticket */
		public static function mb_add_ticket(){
			if( !isset( $_POST['data'] ) ) wp_die();
			$post_data = $_POST['data'];

			$seat_option = isset($post_data['seat_option']) ? sanitize_text_field( $post_data['seat_option'] ) : 'simple';

			$key = isset($post_data['count_tickets']) ? sanitize_text_field( $post_data['count_tickets'] ) : '1';

			$_prefix = OVA_METABOX_EVENT;
			$ticket = OVA_METABOX_EVENT.'ticket';

			

			$time = el_calendar_time_format();
			$format = el_date_time_format_js();
			$first_day = el_first_day_of_week();
			
			$placeholder_dateformat = el_placeholder_dateformat();
			$placeholder_timeformat = el_placeholder_timeformat();

			?>

			<div class="ticket_item" data-prefix="<?php echo esc_attr($_prefix); ?>">

				<!-- Headding Ticket -->
				<div class="heading_ticket">
					<div class="left">
						<i class=" fas fa-ticket-alt"></i>
						<input type="text" 
						name="<?php echo esc_attr( $ticket.'['.$key.'][name_ticket]' ); ?>" 
						id="name_ticket" 
						value="" 
						placeholder="<?php esc_attr_e( 'Click to edit ticket name', 'eventlist' ); ?>" 
						autocomplete="off" autocorrect="off" autocapitalize="none" 
						/>
					</div>
					<div class="right">
						<!-- <i class="dashicons dashicons-move move_ticket"></i> -->
						<i class="fas fa-edit edit_ticket"></i>
						<i class="fas fa-trash delete_ticket"></i>
					</div>
				</div>

				<!-- Content Ticket -->
				<div class="content_ticket">

					<!-- ID Ticket -->
					<div class="id_ticket">
						<label><strong><?php esc_html_e( 'SKU: *', 'eventlist' ); ?></strong></label>
						<input type="text" 
						id="ticket_id" 
						name="<?php echo esc_attr( $ticket.'['.$key.'][ticket_id]' ); ?>"
						value=""
						autocomplete="off" autocorrect="off" autocapitalize="none"
						/>
						<span><?php esc_html_e( 'Auto render if empty', 'eventlist' ); ?></span>
					</div>

					<!-- Top Ticket -->
					<div class="top_ticket">

						<div class="col_price_ticket col">
							<div class="top">
								<span><strong><?php esc_html_e( 'Price', 'eventlist' ); ?></strong></span>

								<div class="radio_type_price" data-type-price="<?php echo esc_attr( 'paid' ); ?>">
									<span> <input type="radio" name="<?php echo esc_attr( $ticket.'['.$key.'][type_price]' ) ?>" id="type_price" class="type_price" value="<?php echo esc_attr('paid'); ?>" <?php echo esc_attr('checked'); ?> > <?php esc_html_e( 'Paid', 'eventlist' ); ?> </span>

									<span> <input type="radio" name="<?php echo esc_attr( $ticket.'['.$key.'][type_price]' ) ?>" id="type_price" class="type_price" value="<?php echo esc_attr('free'); ?>"> <?php esc_html_e( 'Free', 'eventlist' ); ?> </span>

								</div>
							</div>

							<input type="text" 
							name="<?php echo esc_attr( $ticket.'['.$key.'][price_ticket]' ); ?>" 
							id="price_ticket" 
							value="<?php echo esc_attr(''); ?>" 
							placeholder ="<?php esc_attr_e( '0', 'eventlist' ); ?>" 
							autocomplete="off" autocorrect="off" autocapitalize="none" 
							/>

						</div>

						<div class="col_total_number_ticket col">
							<div class="top">
								<strong><?php esc_html_e( 'Total ', 'eventlist' ); ?></strong>
								<span><?php esc_html_e( 'number of tickets', 'eventlist' ); ?></span>
							</div>
							<input type="number" 
							name="<?php echo esc_attr( $ticket.'['.$key.'][number_total_ticket]' ); ?>" 
							id="number_total_ticket" 
							value="<?php echo esc_attr(''); ?>" 
							placeholder="<?php echo esc_attr('10'); ?>" 
							min="0"
							autocomplete="off" autocorrect="off" autocapitalize="none"
							/>
						</div>

						<div class="col_min_number_ticket col">
							<div class="top">
								<strong><?php esc_html_e( 'Minimum ', 'eventlist' ); ?></strong>
								<span><?php esc_html_e( 'number of tickets for one purchase', 'eventlist' ); ?></span>
							</div>
							<input type="number" 
							name="<?php echo esc_attr( $ticket.'['.$key.'][number_min_ticket]' ); ?>"
							id="number_min_ticket" 
							value="<?php echo esc_attr( '' ); ?>" 
							placeholder="<?php echo esc_attr( '1' ); ?>" 
							min="0"
							autocomplete="off" autocorrect="off" autocapitalize="none"
							/>
						</div>

						<div class="col_max_number_ticket col">
							<div class="top">
								<strong><?php esc_html_e( 'Maximum ', 'eventlist' ); ?></strong>
								<span><?php esc_html_e( 'number of tickets for one purchase', 'eventlist' ); ?></span>
							</div>
							<input type="number" 
							name="<?php echo esc_attr( $ticket.'['.$key.'][number_max_ticket]' ); ?>"
							id="number_max_ticket"
							value="<?php echo esc_attr( '' ); ?>" 
							placeholder="<?php echo esc_attr( '10' ); ?>" 
							min="0"
							autocomplete="off" autocorrect="off" autocapitalize="none"
							/>
						</div>
					</div>


					<!-- Middle Ticket -->
					<div class="middle_ticket">
						<div class="date_ticket">
							<div class="start_date">
								<span><?php esc_html_e( 'Start date for selling tickets', 'eventlist' ); ?></span>
								<div>
									<input type="text"
									name="<?php echo esc_attr( $ticket.'['.$key.'][start_ticket_date]' ); ?>" 
									class="start_ticket_date" 
									value="" 
									data-format="<?php echo esc_attr( $format ); ?>" 
									data-firstday="<?php echo esc_attr( $first_day ); ?>" 
									placeholder="<?php echo esc_attr( $placeholder_dateformat ); ?>" 
									autocomplete="off" autocorrect="off" autocapitalize="none"
									/>

									<input type="text" 
									name="<?php echo esc_attr( $ticket.'['.$key.'][start_ticket_time]' ); ?>" 
									id="start_ticket_time" 
									class="start_ticket_time" 
									value="" 
									data-time="<?php echo esc_attr($time); ?>" 
									placeholder="<?php echo esc_attr( $placeholder_timeformat ); ?>" 
									autocomplete="off" autocorrect="off" autocapitalize="none"
									/>
								</div>
							</div>

							<div class="end_date">
								<span><?php esc_html_e( 'End date for selling tickets', 'eventlist' ); ?></span>
								<div>
									<input type="text"
									name="<?php echo esc_attr( $ticket.'['.$key.'][close_ticket_date]' ); ?>" 
									class="close_ticket_date" 
									value="" 
									data-format="<?php echo esc_attr( $format ); ?>" 
									data-firstday="<?php echo esc_attr( $first_day ); ?>" 
									placeholder="<?php echo esc_attr( $placeholder_dateformat ); ?>" 
									autocomplete="off" autocorrect="off" autocapitalize="none"
									/>

									<input type="text" 
									name="<?php echo esc_attr( $ticket.'['.$key.'][close_ticket_time]' ); ?>" 
									id="close_ticket_time" 
									class="close_ticket_time" 
									value="" 
									data-time="<?php echo esc_attr($time); ?>" 
									placeholder="<?php echo esc_attr( $placeholder_timeformat ); ?>" 
									autocomplete="off" autocorrect="off" autocapitalize="none"
									/>
								</div>
							</div>
						</div>

						<div class="wrap_color_ticket">
							<div>
								<div class="span9">
									<span><?php esc_html_e( 'Ticket border color', 'eventlist' ); ?></span>
									<small><?php esc_html_e( '(Color border in ticket)', 'eventlist' ); ?></small>
								</div>
								<div class="span3">
									<input type="text" 
									name="<?php echo esc_attr( $ticket.'['.$key.'][color_ticket]' ); ?>" 
									id="color_ticket" 
									class="color_ticket" 
									value="<?php echo esc_attr( '#fff' ); ?>" 
									autocomplete="off" autocorrect="off" autocapitalize="none" 
									/>
								</div>

							</div>

							<div>
								<div class="span9">
									<span><?php esc_html_e( 'Ticket label color', 'eventlist' ); ?></span>
									<small><?php esc_html_e( '(Color label in ticket)', 'eventlist' ); ?></small>
								</div>
								<div class="span3">
									<input type="text" 
									name="<?php echo esc_attr( $ticket.'['.$key.'][color_label_ticket]' ); ?>" 
									id="color_label_ticket" 
									class="color_label_ticket" 
									value="<?php echo esc_attr( '#fff' ); ?>" 
									autocomplete="off" autocorrect="off" autocapitalize="none" 
									/>
								</div>

							</div>
							<div>
								<div class="span9">
									<span><?php esc_html_e( 'Ticket content color', 'eventlist' ); ?></span>
									<small><?php esc_html_e( '(Color content in ticket)', 'eventlist' ); ?></small>
								</div>
								<div class="span3">
									<input type="text" 
									name="<?php echo esc_attr( $ticket.'['.$key.'][color_content_ticket]' ); ?>" 
									id="color_content_ticket" 
									class="color_content_ticket" 
									value="<?php echo esc_attr( '#fff' ); ?>" 
									autocomplete="off" autocorrect="off" autocapitalize="none" 
									/>
								</div>

							</div>

						</div>
					</div>


					<!-- Bottom Ticket -->
					<div class="bottom_ticket">
						<div class="title_add_desc">
							<small class="text_title"><?php esc_html_e( 'Description display at frontend and PDF Ticket', 'eventlist' ); ?><i class="arrow_triangle-down"></i></small>
						</div>
						<div class="content_desc">
							<textarea 
							name="<?php echo esc_attr( $ticket.'['.$key.'][desc_ticket]' ); ?>" 
							id="desc_ticket" 
							cols="30" rows="5"></textarea>

							<div class="image_ticket" data-index="<?php echo esc_attr($key); ?>">

								<div class="add_image_ticket">
									<input type="hidden" 
									name="<?php echo esc_attr($ticket.'['.$key.'][image_ticket]'); ?>" 
									id="image_ticket" 
									class="image_ticket" 
									value="" />
									<i class="icon_plus_alt2"></i>
									<?php esc_html_e('Add ticket logo (.jpg, .png)', 'eventlist') ?>
									<br/><span><?php esc_html_e( 'Recommended size: 130x50px','eventlist' ); ?></span>
								</div>
								<div class="remove_image_ticket"></div>
							</div>
						</div>
						<div class="private_desc_ticket">
							<div class="title_add_desc">
								<small class="text_title">
									<?php esc_html_e( 'Private Description in Ticket - Only see when bought ticket', 'eventlist' ); ?>
									<i class="arrow_triangle-down"></i>
								</small>
							</div>
							<textarea 
							name="<?php echo esc_attr( $ticket.'['.$key.'][private_desc_ticket]' ); ?>" 
							id="private_desc_ticket" 
							cols="30" rows="5"></textarea>
						</div>

						<div class="setting_ticket_online">
							<div class="title_add_desc">
								<small class="text_title"><?php esc_html_e( 'These info only display in mail', 'eventlist' ); ?><i class="arrow_triangle-down"></i></small>
							</div>
							<div class="online_field link">
								<label><?php esc_html_e( 'Link', 'eventlist' ); ?></label>
								<input type="text" id="online_link" name="<?php echo esc_attr( $ticket.'['.$key.'][online_link]' ); ?>" value="" />
							</div>
							<div class="online_field password">
								<label><?php esc_html_e( 'Password', 'eventlist' ); ?></label>
								<input type="text" id="online_password" name="<?php echo esc_attr( $ticket.'['.$key.'][online_password]' ); ?>" value="" />
							</div>
							<div class="online_field other">
								<label><?php esc_html_e( 'Other info', 'eventlist' ); ?></label>
								<input type="text" id="online_other" name="<?php echo esc_attr( $ticket.'['.$key.'][online_other]' ); ?>" value="" />
							</div>
							
						</div>
					</div>


					<!-- Seat List -->
					<div class="wrap_seat_list" style="<?php if ( $seat_option == 'simple' ) echo esc_attr('display: flex;') ?>">
						<label class="label"><strong><?php esc_html_e( 'Seat Code List:', 'eventlist' ); ?></strong></label>

						<textarea name="<?php echo esc_attr( $ticket.'['.$key.'][seat_list]' ); ?>" id="seat_list" class="seat_list" cols="30" rows="5" placeholder="<?php echo esc_attr( 'A1, B2, C3, ...' ); ?>" ></textarea>
					</div>


					<!-- The customer choose seat -->
					<div class="wrap_setup_seat" data-setup-seat="<?php echo esc_attr( 'yes' ); ?>" style="<?php if ( $seat_option == 'simple' ) echo esc_attr('display: flex;') ?>">
						<label class="label" for="setup_seat"><strong><?php esc_html_e( 'The customer choose seat:', 'eventlist' ); ?></strong></label>

						<span>
							<input type="radio" 
							name="<?php echo esc_attr($ticket.'['.$key.'][setup_seat]'); ?>"
							id="setup_seat" 
							value="yes" 
							<?php echo esc_attr('checked'); ?>
							/>
							<?php esc_html_e( 'Yes', 'eventlist' ); ?>
						</span>

						<span>
							<input 
							type="radio" 
							name="<?php echo esc_attr($ticket.'['.$key.'][setup_seat]'); ?>" 
							id="setup_seat" 
							value="no" 
							/>
							<?php esc_html_e( 'No', 'eventlist' ); ?>
						</span>
					</div>
					<div class="seat_map_ticket" style="<?php if ( $seat_option == 'simple' ) echo esc_attr('display: flex;') ?>">
						<label class="label">
							<strong>
								<?php esc_html_e( 'Seat map image:', 'eventlist' ); ?>
							</strong>
						</label>
						<div class="image_ticket_seat_map" data-index="<?php echo esc_attr($key); ?>">
							<div class="add_seat_map_ticket">
								<input type="hidden" 
									name="<?php echo esc_attr( $ticket.'['.$key.'][seat_map_ticket]' ); ?>" 
									id="seat_map_ticket" 
									value="" 
								/>
								<i class="icon_plus_alt2"></i>
								<?php esc_html_e('Add image (.jpg, .png)', 'eventlist'); ?>
							</div>
							<div class="remove_seat_map_ticket"></div>
						</div>
					</div>

					<!-- Save Ticket -->
					<a href="#" class="save_ticket"><?php esc_html_e('Done', 'eventlist') ?></a>
				</div>

			</div>

			<?php wp_die();		
		}


		/* Add Seat Map */
		public static function add_seat_map(){
			if( !isset( $_POST['data'] ) ) wp_die();
			$post_data = $_POST['data'];
			$key = isset($post_data['count_seat']) ? sanitize_text_field( $post_data['count_seat'] ) : '1';

			$_prefix = OVA_METABOX_EVENT;
			
			$currency = _el_symbol_price();


			?>
			<div class="item_seat" data-prefix="<?php echo esc_attr( $_prefix ); ?>">
				<div class="name_seat_map">
					<label><?php esc_html_e( 'Seat :', 'eventlist' ) ?></label>
					<input type="text" 
					class="map_name_seat" 
					value="" 
					name="<?php echo esc_attr( $_prefix.'ticket_map[seat]['.$key.'][id]' ); ?>" 
					autocomplete="off" autocorrect="off" autocapitalize="none" 
					placeholder="<?php echo esc_attr( 'A1, A2, A3, ...', 'eventlist' ); ?>" 
					/>
				</div>

				<div class="price_seat_map">

					<label><?php esc_html_e( 'Price', 'eventlist' ) ?><?php echo ' ('. $currency .'):'; ?></label>
					<input type="text" 
					class="map_price_seat" 
					value="" 
					name="<?php echo esc_attr( $_prefix.'ticket_map[seat]['.$key.'][price]' ); ?>" 
					autocomplete="off" autocorrect="off" autocapitalize="none" 
					placeholder="<?php echo esc_attr( '50.00', 'eventlist' ); ?>" 
					/>
				</div>

				<a href="#" class="button remove_seat_map"><?php esc_html_e( 'x', 'eventlist' ); ?></a>

			</div>
			<?php
			wp_die();
		}


		/* Add Description Seat Map */
		public static function add_desc_seat_map(){
			if( !isset( $_POST['data'] ) ) wp_die();
			$post_data = $_POST['data'];
			$key = isset($post_data['count_seat']) ? sanitize_text_field( $post_data['count_seat'] ) : '1';

			$_prefix = OVA_METABOX_EVENT;
			$currency = _el_symbol_price();

			?>

			<div class="item_desc_seat" data-prefix="<?php echo esc_attr( $_prefix ); ?>">
				<div class="item-col">
					<label><?php esc_html_e( 'Type Seat:', 'eventlist' ) ?></label>
					<input type="text" 
					class="map_type_seat" 
					value="" 
					name="<?php echo esc_attr( $_prefix.'ticket_map[desc_seat]['.$key.'][map_type_seat]' ); ?>" 
					autocomplete="off" autocorrect="off" autocapitalize="none" 
					placeholder="<?php echo esc_attr__( 'Standard', 'eventlist' ); ?>" 
					/>
				</div>

				<div class="item-col">
					<label>
						<?php esc_html_e( 'Price', 'eventlist' ) ?>
						<?php echo ' ('. $currency .'):'; ?>
					</label>
					<input type="text" 
					class="map_price_type_seat" 
					value="" 
					name="<?php echo esc_attr( $_prefix.'ticket_map[desc_seat]['.$key.'][map_price_type_seat]' ); ?>" 
					autocomplete="off" autocorrect="off" autocapitalize="none" 
					placeholder="<?php echo esc_attr__( '50.00', 'eventlist' ); ?>" 
					/>
				</div>

				<div class="item-col">
					<label><?php esc_html_e( 'Description:', 'eventlist' ) ?></label>
					<input type="text" 
					class="map_desc_type_seat" 
					value="" 
					name="<?php echo esc_attr( $_prefix.'ticket_map[desc_seat]['.$key.'][map_desc_type_seat]' ); ?>" 
					autocomplete="off" autocorrect="off" autocapitalize="none" 
					placeholder="<?php echo esc_attr__( 'Description of type seat', 'eventlist' ); ?>" 
					/>
				</div>

				<div class="item-col">
					<label><?php esc_html_e( 'Color:', 'eventlist' ) ?></label>
					<input type="text" 
					class="map_color_type_seat" 
					value="" 
					name="<?php echo esc_attr( $_prefix.'ticket_map[desc_seat]['.$key.'][map_color_type_seat]' ); ?>" 
					autocomplete="off" autocorrect="off" autocapitalize="none" 
					placeholder="<?php echo esc_attr( '#ffffff', 'eventlist' ); ?>" 
					/>
				</div>
				<a href="#" class="button remove_desc_seat_map"><?php esc_html_e( 'x', 'eventlist' ); ?></a>
			</div>

			<?php
			wp_die();
		}


		/* Add Calendar */
		public static function mb_add_calendar(){
			if( !isset( $_POST['data'] ) ) wp_die();
			$_prefix = OVA_METABOX_EVENT;
			$post_data = $_POST['data'];
			$index = isset( $post_data['index'] ) ? sanitize_text_field( $post_data['index'] ) : '';
			
			$time = el_calendar_time_format();
			$format = el_date_time_format_js();
			$first_day = el_first_day_of_week();

			$placeholder_dateformat = el_placeholder_dateformat();
			$placeholder_timeformat = el_placeholder_timeformat();

			?>

			<div class="item_calendar">
				<input type="hidden" 
				class="calendar_id" 
				name="<?php echo esc_attr( $_prefix.'calendar['.$index.'][calendar_id]' ); ?>"
				value=""
				/>

				<div class="date">

					<label class="label"><?php esc_html_e( 'Start Date:', 'eventlist' ); ?></label>

					<input type="text" 
					class="calendar_date" 
					value="" 
					name="<?php echo esc_attr( $_prefix.'calendar['.$index.'][date]' ); ?>" 
					autocomplete="off" autocorrect="off" autocapitalize="none" 
					placeholder="<?php echo esc_attr( $placeholder_dateformat ); ?>" 
					data-format="<?php echo esc_attr( $format ); ?>" 
					data-firstday="<?php echo esc_attr( $first_day ); ?>" 
					required="required"
					/>

				</div>

				<div class="end_date">

					<label class="label"><?php esc_html_e( 'End Date:', 'eventlist' ); ?></label>

					<input type="text" 
					class="calendar_end_date" 
					value="" 
					name="<?php echo esc_attr( $_prefix.'calendar['.$index.'][end_date]' ); ?>" 
					autocomplete="off" autocorrect="off" autocapitalize="none" 
					placeholder="<?php echo esc_attr( $placeholder_dateformat ); ?>" 
					data-format="<?php echo esc_attr( $format ); ?>" 
					data-firstday="<?php echo esc_attr( $first_day ); ?>" 
					required="required"
					/>

				</div>


				<div class="start_time">
					<label class="label"><?php esc_html_e( 'From:', 'eventlist' ); ?></label>

					<input type="text" 
					class="calendar_start_time" 
					value="" 
					name="<?php echo esc_attr( $_prefix.'calendar['.$index.'][start_time]' ); ?>" 
					autocomplete="off" autocorrect="off" autocapitalize="none" 
					placeholder="<?php echo esc_attr( $placeholder_timeformat ); ?>" data-time="<?php echo esc_attr( $time ); ?>" 
					data-time="<?php echo esc_attr( $time ); ?>"
					required="required"/>

				</div>


				<div class="end_time">
					<label class="label"><?php esc_html_e( 'To:', 'eventlist' ); ?></label>

					<input type="text" 
					class="calendar_end_time" 
					value="" 
					name="<?php echo esc_attr( $_prefix.'calendar['.$index.'][end_time]' ); ?>" 
					autocomplete="off" autocorrect="off" autocapitalize="none" 
					placeholder="<?php echo esc_attr( $placeholder_timeformat ); ?>" data-time="<?php echo esc_attr( $time ); ?>" 
					data-time="<?php echo esc_attr( $time ); ?>"
					required="required"
					/>


				</div>

				<div class="book_before_minutes">
					<label class="label"><?php esc_html_e( 'Booking before x minutes:', 'eventlist' ); ?></label>
					<input type="number" 
					name="<?php echo esc_attr($_prefix.'calendar['.$index.'][book_before_minutes]' ); ?>" 
					class="number_time_book_before"
					value="<?php echo esc_attr( '' ); ?>" 
					placeholder="<?php echo esc_attr( '30', 'eventlist' ); ?>" 
					autocomplete="off" autocorrect="off" autocapitalize="none" 
					/>
				</div>
				<button class="button remove_calendar">x</button>
			</div>

			<?php
			wp_die();
		}


		/* Add Disable Date */
		public static function mb_add_disable_date(){
			if ( ! isset( $_POST['data'] ) ) wp_die();

			$_prefix 		= OVA_METABOX_EVENT;
			$post_data 		= $_POST['data'];
			$index 			= isset( $post_data['index'] ) ? sanitize_text_field( $post_data['index'] ) : '';
			$schedules_time = isset( $post_data['schedules_time'] ) ? ( $post_data['schedules_time'] ) : '';
			$time 			= el_calendar_time_format();
			$format 		= el_date_time_format_js();
			$first_day 		= el_first_day_of_week();
			$placeholder_dateformat = el_placeholder_dateformat();
			$placeholder_timeformat = el_placeholder_timeformat();
			?>
			<div class="item_disable_date">
				<span>
					<?php esc_html_e( 'Form:', 'eventlist' ); ?>
					<input 
						type="text" 
						class="start_date" 
						value="" 
						name="<?php echo esc_attr( $_prefix.'disable_date['.$index.'][start_date]' ); ?>" 
						autocomplete="off" autocorrect="off" autocapitalize="none" 
						placeholder="<?php echo esc_attr( $placeholder_dateformat ); ?>" 
						data-format="<?php echo esc_attr( $format ); ?>" 
						data-firstday="<?php echo esc_attr( $first_day ); ?>" />
				</span>
				<span>
					<?php esc_html_e( 'To:', 'eventlist' ); ?>
					<input 
						type="text" 
						class="end_date" 
						value="" 
						name="<?php echo esc_attr( $_prefix.'disable_date['.$index.'][end_date]' ); ?>" 
						autocomplete="off" autocorrect="off" autocapitalize="none" 
						placeholder="<?php echo esc_attr( $placeholder_dateformat ); ?>" 
						data-format="<?php echo esc_attr( $format ); ?>" 
						data-firstday="<?php echo esc_attr( $first_day ); ?>" />
				</span>
				<?php if ( $schedules_time ): ?>
					<span class="disable_time">
						<select name="<?php echo esc_attr( $_prefix.'disable_date['.$index.'][schedules_time]' ); ?>" class="schedules_time">
							<option value=""><?php esc_html_e( 'Choose Schedules Time', 'eventlist' ); ?></option>
							<?php foreach ( $schedules_time as $key => $value ) { ?>
								<option value="<?php echo esc_attr( $key ); ?>" >
									<?php echo $value['start_time'].'-'.$value['end_time']; ?>
								</option>
							<?php } ?>
						</select>
					</span>
				<?php endif; ?>
				<button class="button remove_disable_date"><?php esc_html_e( 'x', 'eventlist' ); ?></button>
			</div>
			<?php
			wp_die();
		}

		/* Add Disable Time Slot */
		public static function mb_add_disable_time_slot() {
			if ( ! isset( $_POST['data'] ) ) wp_die();

			$_prefix 		= OVA_METABOX_EVENT;
			$post_data 		= $_POST['data'];
			$index 			= isset( $post_data['index'] ) ? sanitize_text_field( $post_data['index'] ) : '';
			$time 			= el_calendar_time_format();
			$format 		= el_date_time_format_js();
			$first_day 		= el_first_day_of_week();
			$placeholder_dateformat = el_placeholder_dateformat();
			$placeholder_timeformat = el_placeholder_timeformat();
			?>
				<div class="item_disable_time_slot">
					<span>
						<?php esc_html_e( 'Form:', 'eventlist' ); ?>
						<input 
							type="text" 
							class="start_date" 
							name="<?php echo esc_attr( $_prefix.'disable_date_time_slot['.$index.'][start_date]' ); ?>" 
							autocomplete="off" autocorrect="off" autocapitalize="none" 
							placeholder="<?php echo esc_attr( $placeholder_dateformat ); ?>" 
							data-format="<?php echo esc_attr( $format ); ?>" 
							data-firstday="<?php echo esc_attr( $first_day ); ?>" />
					</span>
					<span>
						<input 
							type="text" 
							class="start_time" 
							name="<?php echo esc_attr( $_prefix.'disable_date_time_slot['.$index.'][start_time]' ); ?>" 
							autocomplete="off" autocorrect="off" autocapitalize="none" 
							placeholder="<?php echo esc_attr( $placeholder_timeformat ); ?>" 
							data-time="<?php echo esc_attr( $time ); ?>" />
					</span>
					<span>
						<?php esc_html_e( 'To:', 'eventlist' ); ?>
						<input 
							type="text" 
							class="end_date" 
							name="<?php echo esc_attr( $_prefix.'disable_date_time_slot['.$index.'][end_date]' ); ?>" 
							autocomplete="off" autocorrect="off" autocapitalize="none" 
							placeholder="<?php echo esc_attr( $placeholder_dateformat ); ?>" 
							data-format="<?php echo esc_attr( $format ); ?>" 
							data-firstday="<?php echo esc_attr( $first_day ); ?>" />
					</span>
					<span>
						<input 
							type="text" 
							class="end_time" 
							name="<?php echo esc_attr( $_prefix.'disable_date_time_slot['.$index.'][end_time]' ); ?>" 
							autocomplete="off" autocorrect="off" autocapitalize="none" 
							placeholder="<?php echo esc_attr( $placeholder_timeformat ); ?>" 
							data-time="<?php echo esc_attr( $time ); ?>" />
					</span>
					<button class="button remove_disable_time_slot"><?php esc_html_e( 'x', 'eventlist' ); ?></button>
				</div>
			<?php

			wp_die();
		}

		/* Add schedules Time */
		public static function mb_add_schedules_time(){
			if( !isset( $_POST['data'] ) ) wp_die();
			$_prefix = OVA_METABOX_EVENT;
			$post_data = $_POST['data'];
			$index = isset( $post_data['index'] ) ? sanitize_text_field( $post_data['index'] ) : '';

			$time = el_calendar_time_format();
			$format = el_date_time_format_js();
			$placeholder_dateformat = el_placeholder_dateformat();
			$placeholder_timeformat = el_placeholder_timeformat();

			?>
			<div class="item_schedules_time" data-key= '<?php echo esc_attr($index) ;?>'>

				<span>
					<?php esc_html_e( 'Form:', 'eventlist' ); ?>
					<input type="text" 
					class="start_time" 
					value="" 
					name="<?php echo esc_attr( $_prefix.'schedules_time['.$index.'][start_time]' ); ?>" 
					autocomplete="off" autocorrect="off" autocapitalize="none" 
					placeholder="<?php echo esc_attr( $placeholder_timeformat ); ?>" 
					data-time="<?php echo esc_attr( $time ); ?>"
					required="required"
					/>
				</span>

				<span>
					<?php esc_html_e( 'To:', 'eventlist' ); ?>
					<input type="text" 
					class="end_time" 
					value="" 
					name="<?php echo esc_attr( $_prefix.'schedules_time['.$index.'][end_time]' ); ?>" 
					autocomplete="off" autocorrect="off" autocapitalize="none" 
					placeholder="<?php echo esc_attr( $placeholder_timeformat ); ?>" 
					data-time="<?php echo esc_attr( $time ); ?>"
					required="required"
					/>
				</span>

				<span class="schedules_time_book_before">
					<label class="label"><?php esc_html_e( 'Booking before x minutes:', 'eventlist' ); ?></label>
					<input type="number" 
					name="<?php echo esc_attr( $_prefix.'schedules_time['.$index.'][book_before]' ); ?>" 
					class="schedules_time_book"
					value="<?php echo esc_attr( ''); ?>"
					placeholder="<?php echo esc_attr( '30', 'eventlist' ); ?>" 
					autocomplete="off" autocorrect="off" autocapitalize="none" 
					/>
				</span>

				<button class="button remove_schedules_time"><?php esc_html_e( 'x', 'eventlist' ) ?></button>
			</div>
			<?php
			wp_die();
		}


		/* Add Coupon */
		public static function mb_add_coupon() {
			if( !isset( $_POST['data'] ) ) wp_die();
			$_prefix = OVA_METABOX_EVENT;
			$post_data = $_POST['data'];
			$index = isset( $post_data['index'] ) ? sanitize_text_field( $post_data['index'] ) : '';
			$post_id = isset( $post_data['post_id'] ) ? sanitize_text_field( $post_data['post_id'] ) : '';
			
			$time = el_calendar_time_format();
			$format = el_date_time_format_js();
			$first_day = el_first_day_of_week();
			$placeholder_dateformat = el_placeholder_dateformat();
			$placeholder_timeformat = el_placeholder_timeformat();

			?>

			<div class="item_coupon">
				<input 
					type="hidden"  
					class="coupon_id" 
					name="<?php echo esc_attr( $_prefix.'coupon['.$index.'][coupon_id]' ); ?>" 
					value=""
				/>
				<div class="wrap_discount_code">
					<input 
						type="text"  
						class="discount_code" 
						name="<?php echo esc_attr( $_prefix.'coupon['.$index.'][discount_code]' ); ?>" 
						value="" 
						autocomplete="off" autocorrect="off" autocapitalize="none" 
						placeholder="<?php esc_attr_e( 'DISCOUNT CODE', 'eventlist' ); ?>"
					/>
					<span class="least_char"><?php esc_html_e( 'Discount code must have at least 5 characters', 'eventlist' ); ?></span>
					<small class="comment_discount_code"><?php esc_html_e( 'Only alphanumeric characters allowed (A-Z and 0-9)', 'eventlist' ); ?></small>
				</div>
				<div class="discount_amount">
					<span><strong><?php esc_html_e( 'Discount Amount', 'eventlist' ); ?></strong></span>:&nbsp;
					<input 
						type="text" 
						class="discount_amout_number" 
						name="<?php echo esc_attr( $_prefix.'coupon['.$index.'][discount_amout_number]' ); ?>" 
						value="" 
						autocomplete="off" autocorrect="off" autocapitalize="none" 
						placeholder="<?php esc_attr_e( '5', 'eventlist' ); ?>" 
					/>
					<span><?php esc_html_e( '$', 'eventlist' ); ?></span>&nbsp;
					<span><?php esc_html_e( 'or', 'eventlist' ); ?></span>&nbsp;
					<input 
						type="text" 
						class="discount_amount_percent" 
						name="<?php echo esc_attr( $_prefix.'coupon['.$index.'][discount_amount_percent]' ); ?>" 
						value="" 
						autocomplete="off" autocorrect="off" autocapitalize="none" 
						placeholder="<?php esc_attr_e( '10', 'eventlist' ); ?>"
					/>
					<span><?php esc_html_e( '% of ticket price', 'eventlist' ); ?></span>
				</div>
				<div class="discount_time">
					<div class="start_time">
						<span><strong><?php esc_html_e( 'Start', 'eventlist' ); ?></strong></span>
						<input type="text" 
							class="coupon_start_date" 
							name="<?php echo esc_attr( $_prefix.'coupon['.$index.'][start_date]' ); ?>" 
							value=""
							autocomplete="off" autocorrect="off" autocapitalize="none" 
							placeholder="<?php echo esc_attr( $placeholder_dateformat ); ?>" 
							data-format="<?php echo esc_attr( $format ); ?>" 
							data-firstday="<?php echo esc_attr( $first_day ); ?>" 
						/>
						<input type="text" 
							class="coupon_start_time" 
							name="<?php echo esc_attr( $_prefix.'coupon['.$index.'][start_time]' ); ?>" 
							value="" 
							autocomplete="off" autocorrect="off" autocapitalize="none" 
							placeholder="<?php echo esc_attr( $placeholder_timeformat ); ?>" 
							data-time="<?php echo esc_attr( $time ); ?>" 
						/>
					</div>

					<div class="end_time">
						<span><strong><?php esc_html_e( 'End', 'eventlist' ); ?></strong></span>
						<input type="text" 
							class="coupon_end_date" 
							name="<?php echo esc_attr( $_prefix.'coupon['.$index.'][end_date]' ); ?>" 
							value=""
							autocomplete="off" autocorrect="off" autocapitalize="none" 
							placeholder="<?php echo esc_attr( $placeholder_dateformat ); ?>" 
							data-format="<?php echo esc_attr( $format ); ?>" 
							data-firstday="<?php echo esc_attr( $first_day ); ?>" 
						/>
						<input type="text" 
							class="coupon_end_time" 
							name="<?php echo esc_attr( $_prefix.'coupon['.$index.'][end_time]' ); ?>" 
							value="" 
							autocomplete="off" autocorrect="off" autocapitalize="none" 
							placeholder="<?php echo esc_attr( $placeholder_timeformat ); ?>" 
							data-time="<?php echo esc_attr( $time ); ?>" 
						/>
					</div>
				</div>
				<div class="number_coupon_ticket">
					<span><strong><?php esc_html_e( 'Ticket types', 'eventlist' ); ?></strong></span>
					<div class="ticket">
						<div class="all_ticket">
							<input 
								type="checkbox"
								id="coupon_all_ticket" 
								class="coupon_all_ticket" 
								name="<?php echo esc_attr( $_prefix.'coupon['.$index.'][all_ticket]' ); ?>" 
								value=""
							/>
							<label><?php esc_html_e( 'All ticket types', 'eventlist' ); ?></label>
						</div>
						<div class="all_quantity vendor_field">
							<label for="coupon_quantity"><?php esc_html_e( 'Quantity', 'eventlist' ); ?></label>
							<input 
								type="number"
								id="coupon_quantity" 
								class="coupon_quantity" 
								value="" 
								min="0" 
								name="<?php echo esc_attr( $_prefix.'coupon['.$index.'][quantity]' ); ?>" 
								placeholder="<?php echo esc_attr( '100' ); ?>" 
								autocomplete="off" autocorrect="off" autocapitalize="none"
							/>
						</div>
						<div class="wrap_list_ticket">
							<?php 
							$ticket 		= get_post_meta( $post_id, $_prefix.'ticket', true );
							$seat_option 	= get_post_meta( $post_id, $_prefix.'seat_option', true );

							if ( $ticket && $seat_option != 'map' ) {
								foreach ( $ticket as $key_ticket => $value_ticket ) { ?>
									<div class="item_ticket">

										<label>
											<input 
												type="checkbox"
												class="list_ticket" 
												name="<?php echo esc_attr( $_prefix.'coupon['.$index.'][ticket]['.$key_ticket.']' ); ?>" 
												value="<?php echo esc_attr( isset( $value_ticket['ticket_id'] ) ? $value_ticket['ticket_id'] : '' ); ?>" 
											/> 
											<?php echo $value_ticket['name_ticket'] ?>
										</label>
									</div>
								<?php	} 
							} ?>
						</div>
					</div>
				</div>
				<button class="button remove_coupon"><?php esc_html_e( 'Remove Coupon', 'eventlist' ); ?></button>
			</div>

			<?php

			wp_die();
		}


		/* Add Booking */
		public function add_custom_booking() {
			if( !isset( $_POST['data'] ) ) wp_die();
			$post_data = $_POST['data'];
			$type_seat = isset( $post_data['type_seat'] ) ? sanitize_text_field( $post_data['type_seat'] ) : 'none';
			$index = isset( $post_data['index'] ) ? sanitize_text_field( $post_data['index'] ) : 0;
			$_prefix = OVA_METABOX_EVENT;
			
			?>
			<tr class="cart-item">

				<td class="name">

					<a href="#" class="delete_item">x</a>

					<?php if ($type_seat == 'map') { ?>

						<input type="text" class="name" value="" name="<?php echo esc_attr( $_prefix.'cart['.$index.'][id]' ); ?>" autocomplete="off" autocorrect="off" autocapitalize="none" placeholder="<?php esc_html_e( 'seat code', 'eventlist' ) ?> " />

					<?php } else { ?>

						<input type="text" class="name" value="" name="<?php echo esc_attr( $_prefix.'cart['.$index.'][name]' ); ?>" autocomplete="off" autocorrect="off" autocapitalize="none" placeholder="<?php esc_html_e( 'ticket name', 'eventlist' ) ?> " />

					<?php } ?>
				</td>

				<td class="qty" <?php if($type_seat == 'map') echo esc_attr('style=display:none;'); ?> >
					
					<input type="number" class="qty" value="" min="1" name="<?php echo esc_attr( $_prefix.'cart['.$index.'][qty]' ); ?>" autocomplete="off" autocorrect="off" autocapitalize="none" placeholder="1" />

					<input type="text" class="seat" value="" name="<?php echo esc_attr( $_prefix.'cart['.$index.'][seat]' ); ?>" placeholder="<?php esc_attr_e('A1, A2, A3, ...', 'eventlist') ?>" autocomplete="off" autocorrect="off" autocapitalize="none" <?php if($type_seat == 'simple') echo esc_attr('required'); ?> <?php if($type_seat == 'none') echo esc_attr('style=display:none;'); ?> />

				</td>

				<td class="sub-total">

					<input type="text" class="price" value="" name="<?php echo esc_attr( $_prefix.'cart['.$index.'][price]' ); ?>" autocomplete="off" autocorrect="off" autocapitalize="none" placeholder="<?php esc_html_e( '10.5', 'eventlist' ) ?> " />
					
				</td>
			</tr>

			<?php  

			wp_die();
		}

		public function el_get_idcal_seatopt(){

			if( !isset( $_POST['data'] ) ) wp_die();
			$post_data = $_POST['data'];
			$id_event = $post_data['id_event'];
			$id_cal = $post_data['id_cal'];

			$_prefix = OVA_METABOX_EVENT;

			$list_calendar =  get_arr_list_calendar_by_id_event( $id_event );

			$seat_option = get_post_meta( $id_event, $_prefix.'seat_option', true );
			
			?>
			<?php if( $list_calendar ){ ?>
				<label>
					<strong><?php esc_html_e( "Event Calendar",  "eventlist" ); ?>: </strong>
						<select name="<?php echo $_prefix.'id_cal' ?>" >
							<?php foreach ($list_calendar as $key => $value) { ?>
								<option value="<?php echo $value['calendar_id']; ?>" <?php echo selected( $value['calendar_id'], $id_cal ) ?>>
									<?php echo date_i18n( get_option( 'date_format' ), strtotime($value['date']) ); ?>
								</option>
							<?php } ?>
						</select>
					</label>
				<br><br>
				<input type="hidden" name="seat_option" class="seat_option" value="<?php echo $seat_option; ?>" />

				
					<?php if ( $seat_option == 'none' || $seat_option == 'simple' ) { ?>
						<div 
							class="detail_booking_head_cart" 
							data-name="<?php esc_html_e( 'Ticket', 'eventlist' ); ?>"
							data-qty="<?php esc_html_e( 'Quantity', 'eventlist' ); ?>"
							data-sub_total="<?php esc_html_e( 'Sub Total', 'eventlist' ); ?>"
						>
								
						</div>
						
					<?php } elseif ( $seat_option == 'map' ) { ?>

						<div 
							class="detail_booking_head_cart" 
							data-name="<?php esc_html_e( 'Seat Code', 'eventlist' ); ?>"
							data-sub_total="<?php esc_html_e( 'Sub Total', 'eventlist' ); ?>"
						>		
						</div>

						
					<?php } ?>
				

			<?php }else{ echo esc_html__( 'Please make Calendar for event', 'eventlist' ).'<br/><br/>'; } ?>

			<?php
			wp_die();
		}


		public function el_check_book_before_minutes() {
			$number_time = isset($_POST['number_time']) ? sanitize_text_field($_POST['number_time']) : '';
			$date = isset($_POST['date']) ? sanitize_text_field($_POST['date']) : '';
			$end_date = isset($_POST['end_date']) ? sanitize_text_field($_POST['end_date']) : '';
			$start_time = isset($_POST['start_time']) ? sanitize_text_field($_POST['start_time']) : '';
			$end_time = isset($_POST['end_time']) ? sanitize_text_field($_POST['end_time']) : '';

			$start = isset( $date ) ? el_get_time_int_by_date_and_hour($date, $start_time) : '';
			$end = isset( $end_date ) ? el_get_time_int_by_date_and_hour($end_date, $end_time) : '';

			$check_number = floatval( $start - $end );
			$check_time = floatval( $number_time )*60; 


			if($check_number > $check_time){

				echo json_encode( array(  'msg' => esc_html__( 'Booking before x minutes must be more than', 'eventlist' ).' '.floatval( $check_number / 60 ) ));
				wp_die();

			}
			wp_die();

			
		}

		public function el_check_calendar_recurrence_time_book() {
			$number_time = isset($_POST['number_time']) ? sanitize_text_field($_POST['number_time']) : '';
			$start_time = isset($_POST['start_time']) ? sanitize_text_field($_POST['start_time']) : '';
			$end_time = isset($_POST['end_time']) ? sanitize_text_field($_POST['end_time']) : '';

			$start = isset( $start_time ) ? el_get_time_int_by_date_and_hour( 0, $start_time) : '';
			$end = isset( $end_time ) ? el_get_time_int_by_date_and_hour( 0, $end_time) : '';

			$check_number = floatval( $start - $end );
			$check_time = floatval( $number_time )*60; 


			if($check_number > $check_time){

				echo json_encode( array(  'msg' => esc_html__( 'Booking before x minutes must be more than', 'eventlist' ).' '.floatval( $check_number / 60 ) ) );
				wp_die();

			}
			wp_die();

			
		}


		public function el_check_schedules_time_book() {
			$number_time = isset($_POST['number_time']) ? sanitize_text_field($_POST['number_time']) : '';
			$start_time = isset($_POST['start_time']) ? sanitize_text_field($_POST['start_time']) : '';
			$end_time = isset($_POST['end_time']) ? sanitize_text_field($_POST['end_time']) : '';

			$start = isset( $start_time ) ? el_get_time_int_by_date_and_hour( 0, $start_time) : '';
			$end = isset( $end_time ) ? el_get_time_int_by_date_and_hour( 0, $end_time) : '';

			$check_number = floatval( $start - $end );
			$check_time = floatval( $number_time )*60; 


			if($check_number > $check_time){

				echo json_encode( array(  'msg' => esc_html__( 'Booking before x minutes must be more than', 'eventlist' ).' '.floatval( $check_number / 60 ) ) );
				wp_die();

			}

			wp_die();
		}

		public function el_replace_get_tickets() {
			$event_id 	= isset( $_POST['event_id'] ) ? sanitize_text_field( $_POST['event_id'] ) : '';
			$start_date = isset( $_POST['start_date'] ) ? sanitize_text_field( $_POST['start_date'] ) : '';
			$start_time = isset( $_POST['start_time'] ) ? sanitize_text_field( $_POST['start_time'] ) : '';
			$end_date 	= isset( $_POST['end_date'] ) ? sanitize_text_field( $_POST['end_date'] ) : '';
			$end_time 	= isset( $_POST['end_time'] ) ? sanitize_text_field( $_POST['end_time'] ) : '';
			$replaced 	= isset( $_POST['replaced'] ) ? sanitize_text_field( $_POST['replaced'] ) : '';
			$per_page 	= isset( $_POST['posts_per_page'] ) && absint( $_POST['posts_per_page'] ) ? absint( $_POST['posts_per_page'] ) : 25;

			$result 	= $pagination = $error = '';
			$count 		= sprintf( esc_html__( '%s items', 'eventlist' ), 0 );

			if ( $event_id ) {
				$prefix = OVA_METABOX_EVENT;
				$start 	= $end = '';

				// Start Date
				if ( $start_date && $start_time ) {
					$start = strtotime( $start_date . ' ' . $start_time );
				} elseif ( $start_date ) {
					$start = strtotime( $start_date );
				} else {
					$start = false;
				}

				// End Date
				if ( $end_date && $end_time ) {
					$end = strtotime( $end_date . ' ' . $end_time );
				} elseif ( $end_date ) {
					$end = strtotime( $end_date );
				} else {
					$end = false;
				}

				$args = array(
					'post_type' 		=> 'el_tickets',
					'post_status' 		=> 'publish',
					'posts_per_page' 	=> $per_page,
					'meta_query' 		=> array(
						array(
							'key' 		=> $prefix . 'event_id',
							'value' 	=> $event_id,
							'compare' 	=> '='
						)
					)
				);

				if ( $start ) {
					$args['meta_query'][] = array(
						'key' 		=> $prefix . 'date_start',
						'value' 	=> $start,
						'compare' 	=> '='
					);
				}

				if ( $end ) {
					$args['meta_query'][] = array(
						'key' 		=> $prefix . 'date_end',
						'value' 	=> $end,
						'compare' 	=> '='
					);
				}

				if ( $replaced && $replaced === 'on' ) {
					$args['meta_query'][] = array(
						'key' 		=> $prefix . 'replace_date_status',
						'value' 	=> '',
						'compare' 	=> '!='
					);
				}

				$tickets = new WP_Query( $args );

				ob_start();

				if ( $tickets->have_posts() ) {
					$date_format = get_option('date_format');
					$time_format = get_option('time_format');

					if ( count( $tickets->posts ) == 1 ) {
						$count = sprintf( esc_html__( '%s item', 'eventlist' ), count( $tickets->posts ) );
					} else {
						$count = sprintf( esc_html__( '%s items', 'eventlist' ), count( $tickets->posts ) );
					}

					while ( $tickets->have_posts() ) {
						$tickets->the_post();

						$ticket_id 	= get_the_id();
						$event_name = get_post_meta( $ticket_id, $prefix.'name_event', true );
						$booking_id = get_post_meta( $ticket_id, $prefix.'booking_id', true );
						$status 	= get_post_meta( $ticket_id, $prefix.'ticket_status', true );
						$start_date = get_post_meta( $ticket_id, $prefix.'date_start', true );
						$end_date 	= get_post_meta( $ticket_id, $prefix.'date_end', true );
						$qr_code 	= get_post_meta( $ticket_id, $prefix.'qr_code', true );
						$customer 	= get_post_meta( $ticket_id, $prefix.'name_customer', true );
						$arr_venue 	= get_post_meta( $ticket_id, $prefix.'venue', true );
						$address 	= get_post_meta( $ticket_id, $prefix.'address', true );
						$venue 		= is_array( $arr_venue ) ? implode( ", ", $arr_venue ) : $arr_venue;
					?>
						<tr>
							<th scope="row" class="check-column">
								<input 
									type="checkbox"
									name="ticket_id[]"
									value="<?php echo esc_attr( $ticket_id ); ?>"
								/>
							</th>
							<th class="ticket_number">
		                		<a href="<?php echo esc_url( get_edit_post_link( $ticket_id, 'edit' ) ); ?>" target="_blank">
		                			<?php echo esc_html( $ticket_id ); ?>
		                		</a>
		                	</th>
		                	<th class="ticket_type">
		                		<a href="<?php echo esc_url( get_edit_post_link( $ticket_id, 'edit' ) ); ?>" target="_blank">
		                			<?php echo esc_html( get_the_title( $ticket_id ) ); ?>
		                		</a>
		                	</th>
		                	<th class="ticket_status">
		                		<?php echo esc_html( $status ); ?>
		                	</th>
		                	<th class="start_date">
		                		<?php echo date_i18n( $date_format, $start_date ) . ' - ' . date_i18n( $time_format, $start_date ); ?>
		                	</th>
		                	<th class="end_date">
		                		<?php echo date_i18n( $date_format, $end_date ) . ' - ' . date_i18n( $time_format, $end_date ); ?>
		                	</th>
		                	<th class="ticket_qr_code">
		                		<?php echo esc_html( $qr_code ); ?>
		                	</th>
		                	<th class="customer_name">
		                		<?php echo esc_html( $customer ); ?>
		                	</th>
		                	<th class="customer_address">
		                		<?php if ( $venue ): ?>
		                			<?php printf( esc_html__( 'Venue: %s' ).'<br>', $venue ); ?>
		                		<?php endif; ?>
		                		<?php if ( $address ): ?>
		                			<?php printf( esc_html__( 'Address: %s' ).'<br>', $address ); ?>
		                		<?php endif; ?>
		                	</th>
		                	<th class="event">
		                		<a href="<?php echo esc_url( get_edit_post_link( $event_id, 'edit' ) ); ?>" target="_blank">
		                			<?php echo esc_html( $event_name ); ?>
		                		</a>
		                	</th>
		                	<th class="booking_id">
		                		<a href="<?php echo esc_url( get_edit_post_link( $booking_id, 'edit' ) ); ?>" target="_blank">
		                			<?php echo esc_html( $booking_id ); ?>
		                		</a>
		                	</th>
						</tr>
					<?php }
				} else {
					$error = 'yes';
					?>
					<tr class="no-items">
	            		<td class="colspanchange" colspan="11">
	            			<?php esc_html_e( 'No items found.', 'eventlist' ); ?>
	            		</td>
	            	</tr>
					<?php
				}
				wp_reset_postdata();

				$result = ob_get_contents();
				ob_end_clean();

				$max_pages 		= $tickets->max_num_pages;
				$total_items 	= $tickets->found_posts;

				if ( $max_pages > 1 ) {
					ob_start();
				?>
					<span class="total-items" title="<?php esc_attr_e( 'Total items', 'eventlist' ); ?>">
						<?php if ( $total_items == 1 ): ?>
		        			<?php printf( esc_html__( '%s item', 'eventlist' ), $total_items ); ?>
		        		<?php else: ?>
		        			<?php printf( esc_html__( '%s items', 'eventlist' ), $total_items ); ?>
		        		<?php endif; ?>
		        	</span>
		        	<span class="posts-per-page" title="<?php esc_attr_e( 'Posts per page', 'eventlist' ); ?>">
		        		<select name="el_posts_per_page" class="el_posts_per_page">
		        			<option value="25" <?php selected( 25, $per_page ); ?>>25</option>
		        			<option value="50" <?php selected( 50, $per_page ); ?>>50</option>
		        			<option value="100" <?php selected( 100, $per_page ); ?>>100</option>
		        			<option value="250" <?php selected( 250, $per_page ); ?>>250</option>
		        			<option value="500" <?php selected( 500, $per_page ); ?>>500</option>
		        		</select>
		        	</span>
		        	<span class="pagination-links">
		        		<span 
		        			class="btn-pagination el-first disable"
		        			title="<?php esc_attr_e( 'First page', 'eventlist' ); ?>"
		        			data-paged="1">«</span>
		        		<span 
		        			class="btn-pagination el-prev disable"
		        			title="<?php esc_attr_e( 'Previous page', 'eventlist' ); ?>"
		        			data-paged="1">‹</span>
		        		<span 
		        			class="el-current"
		        			title="<?php esc_attr_e( 'Current page', 'eventlist' ); ?>"
		        			data-paged="1">1</span>
		        		<span class="text-pagination" title="<?php esc_attr_e( 'Current page', 'eventlist' ); ?>">
		        			<?php esc_html_e( 'of', 'eventlist' ); ?>
		        			<span 
		        				class="total-page" 
		        				title="<?php esc_attr_e( 'Total page', 'eventlist' ); ?>"
		        				data-max-pages="<?php echo esc_attr( $max_pages ); ?>">
		        				<?php echo esc_html( $max_pages ); ?>
		        			</span>
		        		</span>
		        		<span 
		        			class="btn-pagination el-next"
		        			title="<?php esc_attr_e( 'Next page', 'eventlist' ); ?>"
		        			data-paged="2">›</span>
		        		<span 
		        			class="btn-pagination el-last"
		        			title="<?php esc_attr_e( 'Last page', 'eventlist' ); ?>"
		        			data-paged="<?php echo esc_attr( $max_pages ); ?>">»</span>
		        	</span>
				<?php
					$pagination = ob_get_contents();
					ob_end_clean();
				}
			}

			echo json_encode( array( 
				'result' 		=> $result, 
				'count' 		=> $count, 
				'error' 		=> $error, 
				'pagination' 	=> $pagination 
			));

			wp_die();
		}

		public function el_replace_ticket_date() {
			$ticket_ids = isset( $_POST['ticket_ids'] ) ? $_POST['ticket_ids'] : '';
			$start_date = isset( $_POST['start_date'] ) ? sanitize_text_field( $_POST['start_date'] ) : '';
			$start_time = isset( $_POST['start_time'] ) ? sanitize_text_field( $_POST['start_time'] ) : '';
			$end_date 	= isset( $_POST['end_date'] ) ? sanitize_text_field( $_POST['end_date'] ) : '';
			$end_time 	= isset( $_POST['end_time'] ) ? sanitize_text_field( $_POST['end_time'] ) : '';
			$result 	= $error = '';
			
			if ( ! empty( $ticket_ids ) && is_array( $ticket_ids ) ) {
				if ( $start_date && $start_time && $end_date && $end_time ) {
					$start 	= strtotime( $start_date . ' ' . $start_time );
					$end 	= strtotime( $end_date . ' ' . $end_time );

					foreach ( $ticket_ids as $ticket_id ) {
						$replace_date_status = absint( get_post_meta( $ticket_id, OVA_METABOX_EVENT.'replace_date_status', true ) );

						update_post_meta( $ticket_id, OVA_METABOX_EVENT.'date_start', $start );
						update_post_meta( $ticket_id, OVA_METABOX_EVENT.'date_end', $end );
						update_post_meta( $ticket_id, OVA_METABOX_EVENT.'replace_date_status', $replace_date_status + 1 );
					}

					if ( count( $ticket_ids ) == 1 ) {
						$result = sprintf( esc_html__( 'Update %s item success.', 'eventlist' ), count( $ticket_ids ) );
					} else {
						$result = sprintf( esc_html__( 'Update %s items success.', 'eventlist' ), count( $ticket_ids ) );
					}

					$error 	= false;
				} else {
					$result = esc_html__( 'Please select date & time.', 'eventlist' );
					$error 	= true;
				}
			} else {
				$result = esc_html__( 'Please select ticket.', 'eventlist' );
				$error 	= true;
			}

			echo json_encode( array( 'result' => $result, 'error' => $error ) );

			wp_die();
		}

		public function el_replace_ticket_date_posts_per_page() {
			$event_id 	= isset( $_POST['event_id'] ) ? sanitize_text_field( $_POST['event_id'] ) : '';
			$start_date = isset( $_POST['start_date'] ) ? sanitize_text_field( $_POST['start_date'] ) : '';
			$start_time = isset( $_POST['start_time'] ) ? sanitize_text_field( $_POST['start_time'] ) : '';
			$end_date 	= isset( $_POST['end_date'] ) ? sanitize_text_field( $_POST['end_date'] ) : '';
			$end_time 	= isset( $_POST['end_time'] ) ? sanitize_text_field( $_POST['end_time'] ) : '';
			$replaced 	= isset( $_POST['replaced'] ) ? sanitize_text_field( $_POST['replaced'] ) : '';
			$per_page 	= isset( $_POST['posts_per_page'] ) && absint( $_POST['posts_per_page'] ) ? absint( $_POST['posts_per_page'] ) : 25;

			$result 	= $pagination = '';
			$count 		= sprintf( esc_html__( '%s items', 'eventlist' ), 0 );

			if ( $event_id ) {
				$prefix = OVA_METABOX_EVENT;
				$start 	= $end = '';

				// Start Date
				if ( $start_date && $start_time ) {
					$start = strtotime( $start_date . ' ' . $start_time );
				} elseif ( $start_date ) {
					$start = strtotime( $start_date );
				} else {
					$start = false;
				}

				// End Date
				if ( $end_date && $end_time ) {
					$end = strtotime( $end_date . ' ' . $end_time );
				} elseif ( $end_date ) {
					$end = strtotime( $end_date );
				} else {
					$end = false;
				}

				$args = array(
					'post_type' 		=> 'el_tickets',
					'post_status' 		=> 'publish',
					'posts_per_page' 	=> $per_page,
					'meta_query' 		=> array(
						array(
							'key' 		=> $prefix . 'event_id',
							'value' 	=> $event_id,
							'compare' 	=> '='
						)
					)
				);

				if ( $start ) {
					$args['meta_query'][] = array(
						'key' 		=> $prefix . 'date_start',
						'value' 	=> $start,
						'compare' 	=> '='
					);
				}

				if ( $end ) {
					$args['meta_query'][] = array(
						'key' 		=> $prefix . 'date_end',
						'value' 	=> $end,
						'compare' 	=> '='
					);
				}

				if ( $replaced && $replaced === 'on' ) {
					$args['meta_query'][] = array(
						'key' 		=> $prefix . 'replace_date_status',
						'value' 	=> '',
						'compare' 	=> '!='
					);
				}

				$tickets = new WP_Query( $args );

				ob_start();

				if ( $tickets->have_posts() ) {
					$date_format = get_option('date_format');
					$time_format = get_option('time_format');

					if ( count( $tickets->posts ) == 1 ) {
						$count = sprintf( esc_html__( '%s item', 'eventlist' ), count( $tickets->posts ) );
					} else {
						$count = sprintf( esc_html__( '%s items', 'eventlist' ), count( $tickets->posts ) );
					}

					while ( $tickets->have_posts() ) {
						$tickets->the_post();

						$ticket_id 	= get_the_id();
						$event_name = get_post_meta( $ticket_id, $prefix.'name_event', true );
						$booking_id = get_post_meta( $ticket_id, $prefix.'booking_id', true );
						$status 	= get_post_meta( $ticket_id, $prefix.'ticket_status', true );
						$start_date = get_post_meta( $ticket_id, $prefix.'date_start', true );
						$end_date 	= get_post_meta( $ticket_id, $prefix.'date_end', true );
						$qr_code 	= get_post_meta( $ticket_id, $prefix.'qr_code', true );
						$customer 	= get_post_meta( $ticket_id, $prefix.'name_customer', true );
						$arr_venue 	= get_post_meta( $ticket_id, $prefix.'venue', true );
						$address 	= get_post_meta( $ticket_id, $prefix.'address', true );
						$venue 		= is_array( $arr_venue ) ? implode( ", ", $arr_venue ) : $arr_venue;
					?>
						<tr>
							<th scope="row" class="check-column">
								<input 
									type="checkbox"
									name="ticket_id[]"
									value="<?php echo esc_attr( $ticket_id ); ?>"
								/>
							</th>
							<th class="ticket_number">
		                		<a href="<?php echo esc_url( get_edit_post_link( $ticket_id, 'edit' ) ); ?>" target="_blank">
		                			<?php echo esc_html( $ticket_id ); ?>
		                		</a>
		                	</th>
		                	<th class="ticket_type">
		                		<a href="<?php echo esc_url( get_edit_post_link( $ticket_id, 'edit' ) ); ?>" target="_blank">
		                			<?php echo esc_html( get_the_title( $ticket_id ) ); ?>
		                		</a>
		                	</th>
		                	<th class="ticket_status">
		                		<?php echo esc_html( $status ); ?>
		                	</th>
		                	<th class="start_date">
		                		<?php echo date_i18n( $date_format, $start_date ) . ' - ' . date_i18n( $time_format, $start_date ); ?>
		                	</th>
		                	<th class="end_date">
		                		<?php echo date_i18n( $date_format, $end_date ) . ' - ' . date_i18n( $time_format, $end_date ); ?>
		                	</th>
		                	<th class="ticket_qr_code">
		                		<?php echo esc_html( $qr_code ); ?>
		                	</th>
		                	<th class="customer_name">
		                		<?php echo esc_html( $customer ); ?>
		                	</th>
		                	<th class="customer_address">
		                		<?php if ( $venue ): ?>
		                			<?php printf( esc_html__( 'Venue: %s' ).'<br>', $venue ); ?>
		                		<?php endif; ?>
		                		<?php if ( $address ): ?>
		                			<?php printf( esc_html__( 'Address: %s' ).'<br>', $address ); ?>
		                		<?php endif; ?>
		                	</th>
		                	<th class="event">
		                		<a href="<?php echo esc_url( get_edit_post_link( $event_id, 'edit' ) ); ?>" target="_blank">
		                			<?php echo esc_html( $event_name ); ?>
		                		</a>
		                	</th>
		                	<th class="booking_id">
		                		<a href="<?php echo esc_url( get_edit_post_link( $booking_id, 'edit' ) ); ?>" target="_blank">
		                			<?php echo esc_html( $booking_id ); ?>
		                		</a>
		                	</th>
						</tr>
					<?php }
				} else {
					?>
					<tr class="no-items">
	            		<td class="colspanchange" colspan="11">
	            			<?php esc_html_e( 'No items found.', 'eventlist' ); ?>
	            		</td>
	            	</tr>
					<?php
				}
				wp_reset_postdata();

				$result = ob_get_contents();
				ob_end_clean();

				$max_pages 		= $tickets->max_num_pages;
				$total_items 	= $tickets->found_posts;

				if ( $max_pages > 1 ) {
					ob_start();
				?>
	        		<span 
	        			class="btn-pagination el-first disable"
	        			title="<?php esc_attr_e( 'First page', 'eventlist' ); ?>"
	        			data-paged="1">«</span>
	        		<span 
	        			class="btn-pagination el-prev disable"
	        			title="<?php esc_attr_e( 'Previous page', 'eventlist' ); ?>"
	        			data-paged="1">‹</span>
	        		<span 
	        			class="el-current"
	        			title="<?php esc_attr_e( 'Current page', 'eventlist' ); ?>"
	        			data-paged="1">1</span>
	        		<span class="text-pagination" title="<?php esc_attr_e( 'Current page', 'eventlist' ); ?>">
	        			<?php esc_html_e( 'of', 'eventlist' ); ?>
	        			<span 
	        				class="total-page" 
	        				title="<?php esc_attr_e( 'Total page', 'eventlist' ); ?>"
	        				data-max-pages="<?php echo esc_attr( $max_pages ); ?>">
	        				<?php echo esc_html( $max_pages ); ?>
	        			</span>
	        		</span>
	        		<span 
	        			class="btn-pagination el-next"
	        			title="<?php esc_attr_e( 'Next page', 'eventlist' ); ?>"
	        			data-paged="2">›</span>
	        		<span 
	        			class="btn-pagination el-last"
	        			title="<?php esc_attr_e( 'Last page', 'eventlist' ); ?>"
	        			data-paged="<?php echo esc_attr( $max_pages ); ?>">»</span>
				<?php
					$pagination = ob_get_contents();
					ob_end_clean();
				}
			}

			echo json_encode( array( 'result' => $result, 'count' => $count, 'pagination' => $pagination ) );

			wp_die();
		}

		public function el_replace_ticket_date_pagination() {
			$event_id 	= isset( $_POST['event_id'] ) ? sanitize_text_field( $_POST['event_id'] ) : '';
			$start_date = isset( $_POST['start_date'] ) ? sanitize_text_field( $_POST['start_date'] ) : '';
			$start_time = isset( $_POST['start_time'] ) ? sanitize_text_field( $_POST['start_time'] ) : '';
			$end_date 	= isset( $_POST['end_date'] ) ? sanitize_text_field( $_POST['end_date'] ) : '';
			$end_time 	= isset( $_POST['end_time'] ) ? sanitize_text_field( $_POST['end_time'] ) : '';
			$replaced 	= isset( $_POST['replaced'] ) ? sanitize_text_field( $_POST['replaced'] ) : '';
			$per_page 	= isset( $_POST['posts_per_page'] ) && absint( $_POST['posts_per_page'] ) ? absint( $_POST['posts_per_page'] ) : 25;
			$paged 		= isset( $_POST['paged'] ) && absint( $_POST['paged'] ) ? absint( $_POST['paged'] ) : 1;

			$result 	= '';
			$count 		= sprintf( esc_html__( '%s items', 'eventlist' ), 0 );

			if ( $event_id ) {
				$prefix = OVA_METABOX_EVENT;
				$start 	= $end = '';

				// Start Date
				if ( $start_date && $start_time ) {
					$start = strtotime( $start_date . ' ' . $start_time );
				} elseif ( $start_date ) {
					$start = strtotime( $start_date );
				} else {
					$start = false;
				}

				// End Date
				if ( $end_date && $end_time ) {
					$end = strtotime( $end_date . ' ' . $end_time );
				} elseif ( $end_date ) {
					$end = strtotime( $end_date );
				} else {
					$end = false;
				}

				$args = array(
					'post_type' 		=> 'el_tickets',
					'post_status' 		=> 'publish',
					'posts_per_page' 	=> $per_page,
					'paged' 			=> $paged,
					'meta_query' 		=> array(
						array(
							'key' 		=> $prefix . 'event_id',
							'value' 	=> $event_id,
							'compare' 	=> '='
						)
					)
				);

				if ( $start ) {
					$args['meta_query'][] = array(
						'key' 		=> $prefix . 'date_start',
						'value' 	=> $start,
						'compare' 	=> '='
					);
				}

				if ( $end ) {
					$args['meta_query'][] = array(
						'key' 		=> $prefix . 'date_end',
						'value' 	=> $end,
						'compare' 	=> '='
					);
				}

				if ( $replaced && $replaced === 'on' ) {
					$args['meta_query'][] = array(
						'key' 		=> $prefix . 'replace_date_status',
						'value' 	=> '',
						'compare' 	=> '!='
					);
				}

				$tickets = new WP_Query( $args );

				ob_start();

				if ( $tickets->have_posts() ) {
					$date_format = get_option('date_format');
					$time_format = get_option('time_format');

					if ( count( $tickets->posts ) == 1 ) {
						$count = sprintf( esc_html__( '%s item', 'eventlist' ), count( $tickets->posts ) );
					} else {
						$count = sprintf( esc_html__( '%s items', 'eventlist' ), count( $tickets->posts ) );
					}

					while ( $tickets->have_posts() ) {
						$tickets->the_post();

						$ticket_id 	= get_the_id();
						$event_name = get_post_meta( $ticket_id, $prefix.'name_event', true );
						$booking_id = get_post_meta( $ticket_id, $prefix.'booking_id', true );
						$status 	= get_post_meta( $ticket_id, $prefix.'ticket_status', true );
						$start_date = get_post_meta( $ticket_id, $prefix.'date_start', true );
						$end_date 	= get_post_meta( $ticket_id, $prefix.'date_end', true );
						$qr_code 	= get_post_meta( $ticket_id, $prefix.'qr_code', true );
						$customer 	= get_post_meta( $ticket_id, $prefix.'name_customer', true );
						$arr_venue 	= get_post_meta( $ticket_id, $prefix.'venue', true );
						$address 	= get_post_meta( $ticket_id, $prefix.'address', true );
						$venue 		= is_array( $arr_venue ) ? implode( ", ", $arr_venue ) : $arr_venue;
					?>
						<tr>
							<th scope="row" class="check-column">
								<input 
									type="checkbox"
									name="ticket_id[]"
									value="<?php echo esc_attr( $ticket_id ); ?>"
								/>
							</th>
							<th class="ticket_number">
		                		<a href="<?php echo esc_url( get_edit_post_link( $ticket_id, 'edit' ) ); ?>" target="_blank">
		                			<?php echo esc_html( $ticket_id ); ?>
		                		</a>
		                	</th>
		                	<th class="ticket_type">
		                		<a href="<?php echo esc_url( get_edit_post_link( $ticket_id, 'edit' ) ); ?>" target="_blank">
		                			<?php echo esc_html( get_the_title( $ticket_id ) ); ?>
		                		</a>
		                	</th>
		                	<th class="ticket_status">
		                		<?php echo esc_html( $status ); ?>
		                	</th>
		                	<th class="start_date">
		                		<?php echo date_i18n( $date_format, $start_date ) . ' - ' . date_i18n( $time_format, $start_date ); ?>
		                	</th>
		                	<th class="end_date">
		                		<?php echo date_i18n( $date_format, $end_date ) . ' - ' . date_i18n( $time_format, $end_date ); ?>
		                	</th>
		                	<th class="ticket_qr_code">
		                		<?php echo esc_html( $qr_code ); ?>
		                	</th>
		                	<th class="customer_name">
		                		<?php echo esc_html( $customer ); ?>
		                	</th>
		                	<th class="customer_address">
		                		<?php if ( $venue ): ?>
		                			<?php printf( esc_html__( 'Venue: %s' ).'<br>', $venue ); ?>
		                		<?php endif; ?>
		                		<?php if ( $address ): ?>
		                			<?php printf( esc_html__( 'Address: %s' ).'<br>', $address ); ?>
		                		<?php endif; ?>
		                	</th>
		                	<th class="event">
		                		<a href="<?php echo esc_url( get_edit_post_link( $event_id, 'edit' ) ); ?>" target="_blank">
		                			<?php echo esc_html( $event_name ); ?>
		                		</a>
		                	</th>
		                	<th class="booking_id">
		                		<a href="<?php echo esc_url( get_edit_post_link( $booking_id, 'edit' ) ); ?>" target="_blank">
		                			<?php echo esc_html( $booking_id ); ?>
		                		</a>
		                	</th>
						</tr>
					<?php }
				} else {
					?>
					<tr class="no-items">
	            		<td class="colspanchange" colspan="11">
	            			<?php esc_html_e( 'No items found.', 'eventlist' ); ?>
	            		</td>
	            	</tr>
					<?php
				}
				wp_reset_postdata();

				$result = ob_get_contents();
				ob_end_clean();
			}

			echo json_encode( array( 'result' => $result, 'count' => $count ) );

			wp_die();
		}

		public function el_replace_ticket_date_export_email() {
			$event_id 	= isset( $_POST['event_id'] ) ? sanitize_text_field( $_POST['event_id'] ) : '';
			$start_date = isset( $_POST['start_date'] ) ? sanitize_text_field( $_POST['start_date'] ) : '';
			$start_time = isset( $_POST['start_time'] ) ? sanitize_text_field( $_POST['start_time'] ) : '';
			$end_date 	= isset( $_POST['end_date'] ) ? sanitize_text_field( $_POST['end_date'] ) : '';
			$end_time 	= isset( $_POST['end_time'] ) ? sanitize_text_field( $_POST['end_time'] ) : '';
			$replaced 	= isset( $_POST['replaced'] ) ? sanitize_text_field( $_POST['replaced'] ) : '';

			if ( $event_id ) {
				$prefix = OVA_METABOX_EVENT;
				$start 	= $end = '';

				$csv_row[0][] = esc_html__( 'All Customer Emails', 'eventlist' );

				// Start Date
				if ( $start_date && $start_time ) {
					$start = strtotime( $start_date . ' ' . $start_time );
				} elseif ( $start_date ) {
					$start = strtotime( $start_date );
				} else {
					$start = false;
				}

				// End Date
				if ( $end_date && $end_time ) {
					$end = strtotime( $end_date . ' ' . $end_time );
				} elseif ( $end_date ) {
					$end = strtotime( $end_date );
				} else {
					$end = false;
				}

				$args = array(
					'post_type' 		=> 'el_tickets',
					'post_status' 		=> 'publish',
					'posts_per_page' 	=> -1,
					'meta_query' 		=> array(
						array(
							'key' 		=> $prefix . 'event_id',
							'value' 	=> $event_id,
							'compare' 	=> '='
						)
					),
					'fields' 			=> 'ids',
				);

				if ( $start ) {
					$args['meta_query'][] = array(
						'key' 		=> $prefix . 'date_start',
						'value' 	=> $start,
						'compare' 	=> '='
					);
				}

				if ( $end ) {
					$args['meta_query'][] = array(
						'key' 		=> $prefix . 'date_end',
						'value' 	=> $end,
						'compare' 	=> '='
					);
				}

				if ( $replaced && $replaced === 'on' ) {
					$args['meta_query'][] = array(
						'key' 		=> $prefix . 'replace_date_status',
						'value' 	=> '',
						'compare' 	=> '!='
					);
				}

				$tickets = get_posts( $args );

				if ( ! empty( $tickets ) && is_array( $tickets ) ) {
					$email_exists = [];
					$i = 1;

					foreach( $tickets as $ticket_id ) {
						$email_customer = get_post_meta( $ticket_id, $prefix.'email_customer', true );

						if ( $email_customer && ! in_array( $email_customer, $email_exists ) ) {
							$csv_row[$i][] = $email_customer;

							array_push( $email_exists, $email_customer );

							$i++;
						}
					}
				}

				echo json_encode( $csv_row );
			}

			wp_die();
		}

		public function el_replace_ticket_date_send_email() {
			$event_id 	= isset( $_POST['event_id'] ) ? sanitize_text_field( $_POST['event_id'] ) : '';
			$start_date = isset( $_POST['start_date'] ) ? sanitize_text_field( $_POST['start_date'] ) : '';
			$start_time = isset( $_POST['start_time'] ) ? sanitize_text_field( $_POST['start_time'] ) : '';
			$end_date 	= isset( $_POST['end_date'] ) ? sanitize_text_field( $_POST['end_date'] ) : '';
			$end_time 	= isset( $_POST['end_time'] ) ? sanitize_text_field( $_POST['end_time'] ) : '';
			$replaced 	= isset( $_POST['replaced'] ) ? sanitize_text_field( $_POST['replaced'] ) : '';
			$subject 	= isset( $_POST['subject'] ) ? sanitize_text_field( $_POST['subject'] ) : '';
			$from_name 	= isset( $_POST['from_name'] ) ? sanitize_text_field( $_POST['from_name'] ) : '';
			$send_from 	= isset( $_POST['send_from'] ) ? sanitize_text_field( $_POST['send_from'] ) : '';
			$content 	= isset( $_POST['content'] ) ? $_POST['content'] : '';
			$result 	= $error = '';
			$mail_to 	= [];

			if ( $event_id ) {
				$prefix = OVA_METABOX_EVENT;
				$start 	= $end = '';

				// Start Date
				if ( $start_date && $start_time ) {
					$start = strtotime( $start_date . ' ' . $start_time );
				} elseif ( $start_date ) {
					$start = strtotime( $start_date );
				} else {
					$start = false;
				}

				// End Date
				if ( $end_date && $end_time ) {
					$end = strtotime( $end_date . ' ' . $end_time );
				} elseif ( $end_date ) {
					$end = strtotime( $end_date );
				} else {
					$end = false;
				}

				$args = array(
					'post_type' 		=> 'el_tickets',
					'post_status' 		=> 'publish',
					'posts_per_page' 	=> -1,
					'meta_query' 		=> array(
						array(
							'key' 		=> $prefix . 'event_id',
							'value' 	=> $event_id,
							'compare' 	=> '='
						)
					),
					'fields' 			=> 'ids',
				);

				if ( $start ) {
					$args['meta_query'][] = array(
						'key' 		=> $prefix . 'date_start',
						'value' 	=> $start,
						'compare' 	=> '='
					);
				}

				if ( $end ) {
					$args['meta_query'][] = array(
						'key' 		=> $prefix . 'date_end',
						'value' 	=> $end,
						'compare' 	=> '='
					);
				}

				if ( $replaced && $replaced === 'on' ) {
					$args['meta_query'][] = array(
						'key' 		=> $prefix . 'replace_date_status',
						'value' 	=> '',
						'compare' 	=> '!='
					);
				}

				$tickets = get_posts( $args );

				if ( ! empty( $tickets ) && is_array( $tickets ) ) {
					foreach( $tickets as $ticket_id ) {
						$email_customer = get_post_meta( $ticket_id, $prefix.'email_customer', true );

						if ( $email_customer && ! in_array( $email_customer, $mail_to ) ) {
							array_push( $mail_to, $email_customer );
						}
					}
				}
			}

			if ( ! empty( $mail_to ) && is_array( $mail_to ) ) {
				$mail_to = implode( ",", $mail_to );

				if ( $subject && $from_name && $send_from ) {
					$send_result = el_ticket_replace_date_send_mail( $mail_to, $send_from, $subject, $from_name, $content );

					if ( $send_result ) {
						$result = esc_html__( 'Sent successfully.', 'eventlist' );
					}
				}
			} else {
				$error = esc_html__( 'No email found.', 'eventlist' );
			}

			echo json_encode( array( 'result' => $result, 'error' => $error ) );

			wp_die();
		}
	}

	new El_Admin_Ajax();

}
?>